/* ==========================================================================
*    : ̼
*    : 2006.09.19
* 
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#pragma warning( disable: 4819 )
#pragma warning( disable: 4996 )
#include "ZipArchive.h"
#include <atltime.h>

///  ð
class cFileTime : public CTime
{
public:
	cFileTime();
	cFileTime( time_t time );
	cFileTime( const FILETIME& time );

	const FILETIME& GetFileTime();

	void operator =( const cFileTime& that );

protected:
	FILETIME mFileTime;
};

///  ȿ ִ  
class cFileInPackInfo
{
	friend class cFilePack;

public:
	bool SetPathName( const cStringT& pathName );
	void SetWriteTime( const time_t& time );

	const cStringT& GetPathName() const;
	unsigned int GetSize() const;
	const cFileTime& GetWriteTime() const;
	bool IsDirectory() const;
	time_t GetUnixWriteTime();

private:
	void UpdateFromHeader();

private:
	/// 
	CZipFileHeader mHeader;

	/// ̸
	cStringT mPathName;

	/// ð
	cFileTime mWriteTime;
};

inline
time_t cFileInPackInfo::GetUnixWriteTime()
{
	return mHeader.GetTime();
}

inline
const cStringT& cFileInPackInfo::GetPathName() const
{
	return mPathName;
}

inline
unsigned int cFileInPackInfo::GetSize() const
{
	return (unsigned int)mHeader.m_uUncomprSize;
}

inline
const cFileTime& cFileInPackInfo::GetWriteTime() const
{
	return mWriteTime;
}

inline
bool cFileInPackInfo::IsDirectory() const
{
	return mHeader.IsDirectory();
}

///  
class cFilePack
{
public:
	///  
	enum eOpenMode
	{
		OPEN_READONLY = CZipArchive::zipOpenReadOnly,
		OPEN = CZipArchive::zipOpen,
		CREATE = CZipArchive::zipCreate
	};

public:
	cFilePack();
	~cFilePack();

	/// 
	bool Open( const cStringT& pathName, eOpenMode mode );

	/// ݱ
	void Close();

	/// н
	///    ,  ϰų ߰ϱ  Ѵ.
	bool SetPassword( const charT* password = 0 );

	///  ˻
	///  ε Ѵ. ϸ -1 Ѵ.
	int FindFile( const cStringT& pathName, bool caseSensitive = false );

	///  
	void DeleteFile( int index );
	void DeleteFiles( const tArray<int>& indexArray );

	///  ̸ 
	bool RenameFile( int index, const cStringT& newPathName );

	///  
	bool OpenFile( int index );

	///  ݱ
	bool CloseFile();

	///  б
	/// OpenFile() Լ  ־ Ѵ.
	/// ϸ  о Ʈ  ϰ, ϸ 0 Ѵ.
	unsigned int ReadFile( void* buffer, unsigned int size );

	///   
	/// compressLevel :  
	/// filePath : ش  Ϸκ ð  Ӽ ´.
	bool OpenNewFile( cFileInPackInfo& fi, int compressLevel = Z_NO_COMPRESSION, LPCTSTR filePath = 0 );

	///     ݱ
	bool CloseNewFile();

	///   ؼ 
	/// OpenNewFile() Լ  ־ Ѵ.
	bool WriteNewFile( const void* buffer, unsigned int size );

	///     ҿ 
	void Flush();

	///  ȴ 
	bool IsOpened();

	///   
	int GetNumFiles() const;

	///   
	bool GetFileInfo( cFileInPackInfo* fi, int index ) const;

private:
	///  
	CZipArchive mZip;
};

inline
bool cFilePack::SetPassword( const charT* password )
{
	return mZip.SetPassword( password );
}

inline
bool cFilePack::IsOpened()
{
	return !mZip.IsClosed();
}

inline
int cFilePack::GetNumFiles() const
{
	return mZip.GetCount();
}
