#include "stdafx.h"
#include "FileSystem.h"

#include "File.h"
#include "MemFile.h"

cFileSystem* cFileSystem::mSingleton = 0;

cFileSystem::cFileSystem()
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;
}

cFileSystem::~cFileSystem()
{
	mSingleton = 0;
}

cFileToRead* cFileSystem::OpenFileToRead( const cString& pathName )
{
	cFileToRead* p = new cFileToRead;

	if( p->Open( pathName ) == true )
	{
		return p;
	}
	else
	{
		delete p;
		return 0;
	}
}

cMemFileToRead* cFileSystem::OpenMemFileToRead( const cString& pathName )
{
	cMemFileToRead* p = new cMemFileToRead;

	if( p->Open( pathName ) == true )
	{
		return p;
	}
	else
	{
		delete p;
		return 0;
	}
}

cFileToWrite* cFileSystem::OpenFileToWrite( const cString& pathName )
{
	cFileToWrite* p = new cFileToWrite;

	if( p->Open( pathName ) == true )
	{
		return p;
	}
	else
	{
		delete p;
		return 0;
	}
}
