/* ==========================================================================
*    : ̼
*    : 2007.06.20
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "zlib.h"

class cFileUnzipper
{
public:
	cFileUnzipper();
	~cFileUnzipper();

	/// 
	bool Open( const cString& pathName );

	/// ݱ
	void Close();

	/// Ÿ б
	///    Ÿ ũ⸦ Ѵ.
	///   ϸ 0, ϸ -1 Ѵ.
	int Read( void* buffer, unsigned bufferSize );

private:
	gzFile mZipFile;
};

inline
cFileUnzipper::cFileUnzipper()
: mZipFile( 0 )
{
}

inline
cFileUnzipper::~cFileUnzipper()
{
	Close();
}

inline
bool cFileUnzipper::Open( const cString& pathName )
{
	assert( mZipFile == 0 );

	mZipFile = gzopen( pathName.Cstr(), "rb" );
	return mZipFile != 0;
}

inline
void cFileUnzipper::Close()
{
	if( mZipFile )
	{
		gzclose( mZipFile );
		mZipFile = 0;
	}
}

inline
int cFileUnzipper::Read( void* buffer, unsigned bufferSize )
{
	assert( mZipFile );

	if( mZipFile )
		return gzread( mZipFile, buffer, bufferSize );
	else
		return 0;
}
