/* ==========================================================================
*    : ̼
*    : 2007.06.20
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "zlib.h"

class cFileZipper
{
public:
	cFileZipper();
	~cFileZipper();

	/// 
	bool Open( const cString& pathName );

	/// ݱ
	void Close();

	/// Ÿ 
	///   Ÿ ũ⸦ Ѵ.
	/// ϸ 0 Ѵ.
	unsigned int Write( const void* buffer, unsigned int bufferSize );

private:
	gzFile mZipFile;
};

inline
cFileZipper::cFileZipper()
: mZipFile( 0 )
{
}

inline
cFileZipper::~cFileZipper()
{
	Close();
}

inline
bool cFileZipper::Open( const cString& pathName )
{
	assert( mZipFile == 0 );

	mZipFile = gzopen( pathName.Cstr(), "wb" );
	return mZipFile != 0;
}

inline
void cFileZipper::Close()
{
	if( mZipFile )
	{
		gzclose( mZipFile );
		mZipFile = 0;
	}
}

inline
unsigned int cFileZipper::Write( const void* buffer, unsigned int bufferSize )
{
	assert( mZipFile );

	if( mZipFile )
		return gzwrite( mZipFile, buffer, bufferSize );
	else
		return 0;
}
