/* ==========================================================================
*    : ̼
*    : 2006.09.21
* 
*      : ļ
* ߰ :
*			۾		۾	۾
*
* ǻ : ؽƮ  Ľϱ   ʿ Ѵ.
*===========================================================================*/
#pragma once

#include "Token.h"

class cLexer;

/// ļ
/// ؽƮ  Ľϱ   ʿ Ѵ.
class cParser
{
public:
	cParser();
	cParser( cLexer* lexer, const cString& fileName );
	virtual ~cParser();

	///  
	void SetLexer( cLexer* lexer );

	///  ̸ 
	void SetFileName( const cString& fileName );

	///  ū ´  
	bool ExpectTokenString( const char* str );
	bool ExpectTokenType( int type );

	/// ڿ Ľ
	cString ParseString();
	bool ParseString( cString* str );

	///  Ľ
	int ParseInt();
	bool ParseInt( int* out );

	/// Ǽ Ľ
	float ParseFloat();
	bool ParseFloat( float* out );

	///  
	cLexer* GetLexer() const;

	///  ̸ : 
	const char* GetFileName() const;

	///  ȣ 
	int GetLineNum() const;

protected:
	/// 
	cLexer* mpLexer;

	/// Ľ  ̸
	cString mFileName;

	/// ū
	cToken mToken;
};

inline void cParser::SetLexer( cLexer* lexer )
{
	mpLexer = lexer;
}

inline void cParser::SetFileName( const cString& fileName )
{
	mFileName = fileName;
}

inline cLexer* cParser::GetLexer() const
{
	return mpLexer;
}

inline int cParser::GetLineNum() const
{
	return mToken.mLine;
}


inline const char* cParser::GetFileName() const
{
	return mFileName.Cstr();
}
