/* ==========================================================================
*    : ̼
*    : 2006.09.12
*      : std::basic_string  ⺻ Ʈ ø
* ǻ : 
*===========================================================================*/
#pragma once

#pragma warning( push )
#pragma warning( disable: 4996 )
#pragma warning( disable: 4245 )
#pragma warning( disable: 4267 )
#include <string>
#include "CharTraits.h"

using namespace std;

template <class T, class TRAITS, _STLP_DEFAULT_ALLOCATOR_SELECT(T) >
class tBasicString;

/// ڿ 
template<class T, class TRAITS, class ALLOC>
class tBasicString : protected basic_string<T, TRAITS, ALLOC>
{
	typedef basic_string<T, TRAITS, ALLOC> basic_string;
	typedef tBasicString<T, TRAITS, ALLOC> cSelf;
	static const int BUFFER_SIZE = 1024;

public:
	typedef T* cIterator;
	static const unsigned int NPOS = (unsigned int)basic_string::npos;

public:
	/*
	explicit tBasicString();
	tBasicString( const cSelf& s );
	tBasicString( const cSelf& s, unsigned int pos, unsigned int n = NPOS );
	tBasicString( const T* s );
	tBasicString( const T* s, unsigned int n );
	tBasicString( const T* first, const T* last );
	tBasicString( unsigned int n, T c );
	explicit tBasicString( unsigned int n );

	///  ڸ 
	void Clear();

	/// 뷮 
	void Reserve( unsigned int n );

	/// ڸ  ߰
	void PushBack( T c );

	///  ڸ 
	void PopBack();

	///   
	/// ޸ 뷮   ° Ѵ.
	void Resize( unsigned int n );
	void Resize( unsigned int n, T c );

	/// ڿ ڿ ߰
	void Append( cIterator first, cIterator last );
	void Append( const cSelf& s );
	bool Append( const cSelf& s, unsigned int pos, unsigned int n );
	void Append( const T* s );
	void Append( const T* s, unsigned int n );

	/// ڸ  ߰
	void Append( T c );

	/// ش ġ ڿ 
	bool Insert( unsigned int pos, const cSelf& s );
	bool Insert( unsigned int pos, const cSelf& s, unsigned int beg, unsigned int n );
	bool Insert( unsigned int pos, const T* s, unsigned int n );
	bool Insert( unsigned int pos, const T* s );

	/// [first, last)  ڿ 
	void Erase( cIterator first, cIterator last );
	bool Erase( unsigned int pos = 0, unsigned int n = NPOS );

	///   
	void TrimLeft();
	void TrimLeft( const T* s );
	void TrimLeft( T c );

	///   
	void TrimRight();
	void TrimRight( const T* s );
	void TrimRight( T c );

	/// ڿ ü
	void Replace( cIterator first0, cIterator last0, cIterator first1, cIterator last1 );
	bool Replace( unsigned int pos, unsigned int n, const cSelf& s );
	bool Replace( unsigned int pos0, unsigned int n0, const cSelf& s, unsigned int pos1, unsigned int n1 );
	bool Replace( unsigned int pos, unsigned int n0, const T* s, unsigned int n1 );
	bool Replace( unsigned int pos, unsigned int n, const T* s );
	void Replace( cIterator first, cIterator last, const cSelf& s );
	void Replace( cIterator first, cIterator last, const T* s, unsigned int n );
	void Replace( cIterator first, cIterator last, const T* s );
	void Replace( const cSelf& oldStr, const cSelf& newStr );
	void Replace( const T* oldStr, const T* newStr );
	void Replace( T oldChar, T newChar );

	/// ˻
	unsigned int Find( const cSelf& s, unsigned int pos = 0 ) const;
	unsigned int Find( const T* s, unsigned int pos = 0 ) const;
	unsigned int Find( T c, unsigned int pos = 0 ) const;
	unsigned int FindReverse( const cSelf& s, unsigned int pos = NPOS ) const;
	unsigned int FindReverse( const T* s, unsigned int pos = NPOS ) const;
	unsigned int FindReverse( T c, unsigned int pos = NPOS ) const;

	/// ڿ s κ ù° ڸ ˻
	unsigned int FindFirstof( const cSelf& s, unsigned int pos = 0 ) const;
	unsigned int FindFirstof( const T* s, unsigned int pos = 0 ) const;

	/// ڿ s κ  ڸ ˻
	unsigned int FindLastof( const cSelf& s, unsigned int pos = NPOS ) const;
	unsigned int FindLastof( const T* s, unsigned int pos = NPOS ) const;

	/// ڿ s κ ƴ ù°  ġ 
	unsigned int FindFirstNotof( const cSelf& s, unsigned int pos = 0 ) const;
	unsigned int FindFirstNotof( const T* s, unsigned int pos = 0 ) const;

	///  c  ù°  ġ 
	unsigned int FindFirstNotof( T c, unsigned int pos = 0 ) const;

	/// ڿ s κ ƴ   ġ 
	unsigned int FindLastNotof( const cSelf& s, unsigned int pos = NPOS ) const;
	unsigned int FindLastNotof( const T* s, unsigned int pos = NPOS ) const;

	///  c ƴ   ġ 
	unsigned int FindLastNotof( T c, unsigned int pos = NPOS ) const;

	/// κ ڿ 
	cSelf SubStr( unsigned int pos = 0, unsigned int n = NPOS ) const;
	cSelf Mid( unsigned int pos ) const;
	cSelf Mid( unsigned int pos, unsigned int count ) const;
	cSelf Left( unsigned int count ) const;
	cSelf Right( unsigned int count ) const;

	/// 
	int Compare( const cSelf& s ) const;
	int Compare( const cSelf& s, unsigned int pos, unsigned int len ) const;
	int Compare( unsigned int pos, unsigned int n, const cSelf& s ) const;
	int Compare( unsigned int pos0, unsigned int n0, const cSelf& s, unsigned int pos1, unsigned int n1 ) const;
	int Compare( const T* s ) const;
	int Compare( const T* s, unsigned int pos, unsigned int len ) const;
	int Compare( unsigned int pos, unsigned int n, const T* s ) const;
	int Compare( unsigned int pos, unsigned int n, const T* s, unsigned int n1 ) const;
	int CompareNoCase( const cSelf& s ) const;
	int CompareNoCase( const cSelf& str, unsigned int pos, unsigned int len ) const;
	int CompareNoCase( const T* str ) const;
	int CompareNoCase( const T* str, unsigned int pos, unsigned int len ) const;

	/// ȭ Է
	void Format( const T* fmt, ... );
	void FormatV( const T* fmt, va_list vl );

	/// ȯ
	void ToUpper();
	void ToLower();
	int ToInt() const;
	float ToFloat() const;

	/// ݺڸ 
	cIterator Begin();
	const T* Begin() const;
	cIterator End();
	const T* End() const;

	/// ִ θ 
	bool IsEmpty() const;

	/// ؽ ڵ带 
	operator unsigned int() const;
	unsigned int GetHashCode() const;

	/// ũ() 
	unsigned int GetSize() const;
	unsigned int GetLength() const;

	/// 뷮 
	unsigned int GetCapacity() const;

	/// 0  ڿ 
	const T* Cstr() const;

	///  
	cSelf& operator = ( const cSelf& s );
	cSelf& operator = ( const T* s );
	cSelf& operator = ( T c );
	cSelf& operator += ( const cSelf& s );
	cSelf& operator += ( const T* s );
	cSelf& operator += ( T c );

	///  
	T& operator [] ( unsigned int i );
	const T& operator [] ( unsigned int i ) const;
	*/

#	include "BasicString.inl"
};

template<class T, class TRAITS, class ALLOC> inline
tBasicString<T, TRAITS, ALLOC> operator + ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	typedef tBasicString<T, TRAITS, ALLOC> Str;
	Str out( x.GetSize() + y.GetSize() );
	out.Append( x );
	out.Append( y );
	return out;
}

template<class T, class TRAITS, class ALLOC> inline
tBasicString<T, TRAITS, ALLOC> operator + ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	typedef tBasicString<T, TRAITS, ALLOC> Str;
	unsigned int n = TRAITS::length( s );
	Str out( n + y.GetSize() );
	out.Append( s );
	out.Append( y );
	return out;
}

template<class T, class TRAITS, class ALLOC> inline
tBasicString<T, TRAITS, ALLOC> operator + ( T c, const tBasicString<T, TRAITS, ALLOC>& y )
{
	typedef tBasicString<T, TRAITS, ALLOC> Str;
	Str out( 1 + y.GetSize() );
	out.PushBack( c );
	out.Append( y );
	return out;
}

template<class T, class TRAITS, class ALLOC> inline
tBasicString<T, TRAITS, ALLOC> operator + ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	typedef tBasicString<T, TRAITS, ALLOC> Str;
	unsigned int n = TRAITS::length( s );
	Str out( x.GetSize() + n );
	out.Append( x );
	out.Append( s );
	return out;
}

template<class T, class TRAITS, class ALLOC> inline
tBasicString<T, TRAITS, ALLOC> operator + ( const tBasicString<T, TRAITS, ALLOC>& x, const T c )
{
	typedef tBasicString<T, TRAITS, ALLOC> Str;
	Str out( x.GetSize() + 1 );
	out.Append( x );
	out.PushBack( c );
	return out;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator == ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return x.GetSize() == y.GetSize() && TRAITS::Compare( x.Cstr(), y.Cstr(), x.GetSize() ) == 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator == ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	unsigned int n = TRAITS::length( s );
	return n == y.GetSize() && TRAITS::Compare( s, y.Cstr(), n ) == 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator == ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	unsigned int n = TRAITS::length( s );
	return x.GetSize() == n && TRAITS::Compare( x.Cstr(), s, n ) == 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator < ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return TRAITS::Compare( x.Begin(), y.Begin() ) < 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator < ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return TRAITS::Compare( s, y.Begin() ) < 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator < ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	return TRAITS::Compare( x.Begin(), s ) < 0;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator != ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(x == y);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator > ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return y < x;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator <= ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(y < x);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator >= ( const tBasicString<T, TRAITS, ALLOC>& x, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(x < y);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator != ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(s == y);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator != ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	return !(x == s);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator > ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return y < s;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator > ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	return s < x;
}

template<class T, class TRAITS, class ALLOC> inline
bool operator <= ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(y < s);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator <= ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s )
{
	return !(s < x);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator >= ( const T* s, const tBasicString<T, TRAITS, ALLOC>& y )
{
	return !(s < y);
}

template<class T, class TRAITS, class ALLOC> inline
bool operator >= ( const tBasicString<T, TRAITS, ALLOC>& x, const T* s  )
{
	return !(x < s);
}

#pragma warning( pop )

/// ڿ
typedef tBasicString<char, tCharTraits<char> > cString;
typedef tBasicString<wchar_t, tCharTraits<wchar_t> > cStringW;

#ifdef _UNICODE
;	typedef wchar_t charT;
;	typedef	cStringW cStringT;
#else
;	typedef char charT;
;	typedef	cString cStringT;	
#endif //_UNICODE
