/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      :  Լ ø 
* ǻ : 
*===========================================================================*/
#pragma once

#include "CharTraits.h"

///  Լ
template<class RESULT, class T>
class tMemberFunction
{
	typedef RESULT (T::*Func)( void );

public:
	explicit tMemberFunction( Func func )
		: mFunc( func )
	{
	}

	RESULT operator () ( T* p ) const
	{
		return (p->*mFunc)();
	}

private:
	/// Լ 
	Func mFunc;
};

template<class RESULT, class T> inline
tMemberFunction<RESULT, T> MemFunc(RESULT (T::*f)())
{
	return tMemberFunction<RESULT, T>(f);
}

template<class RESULT, class T>
class tMemberFunctionRef
{
	typedef RESULT (T::*Func)( void );

public:
	explicit tMemberFunctionRef( Func func )
		: mFunc( func )
	{
	}

	RESULT operator () ( T& r ) const
	{
		return (r.*mFunc)();
	}

private:
	/// Լ ۷
	Func mFunc;
};

template<class RESULT, class T> inline
tMemberFunctionRef<RESULT, T> MemFuncRef(RESULT (T::*f)())
{
	return tMemberFunctionRef<RESULT, T>( f );
}

///   Լ
template<class T>
class tUnaryEqual
{
public:
	T mVal;

	tUnaryEqual( const T& x )
		: mVal( x )
	{
	}

	bool operator () ( const T& x ) const
	{
		return x == mVal;
	}
};

template<>
class tUnaryEqual<char*>
{
public:
	char* mVal;

	bool operator () ( const char* x ) const
	{
		return tCharTraits<char>::Compare( mVal, x ) == 0;
	}
};

template<>
class tUnaryEqual<const char*>
{
public:
	const char* mVal;

	bool operator () ( const char* x ) const
	{
		return tCharTraits<char>::Compare( mVal, x ) == 0;
	}
};

///  Լ
template<class T>
class tBinaryEqual
{
public:
	bool operator () ( const T& x, const T& y ) const
	{
		return x == y;
	}
};

template<>
class tBinaryEqual<char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) == 0;
	}
};

template<>
class tBinaryEqual<const char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) == 0;
	}
};

template<class T>
class tBinaryGreater
{
public:
	bool operator () ( const T& x, const T& y ) const
	{
		return x > y;
	}
};

template<>
class tBinaryGreater<char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) > 0;
	}
};

template<>
class tBinaryGreater<const char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) > 0;
	}
};

template<class T>
class tBinaryLess
{
public:
	bool operator () ( const T& x, const T& y ) const
	{
		return x < y;
	}
};

template<>
class tBinaryLess<char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) < 0;
	}
};

template<>
class tBinaryLess<const char*>
{
public:
	bool operator () ( const char* x, const char* y ) const
	{
		return tCharTraits<char>::Compare( x, y ) < 0;
	}
};

///  Լ
template<class Pair>
class tSelect1st
{
public:
	const typename Pair::FIRST& operator () ( const Pair& x ) const
	{
		return x.mFirst;
	}
};

template<class Pair>
class tSelect2nd
{
public:
	const typename Pair::SECOND& operator () ( const Pair& x ) const
	{
		return x.mSecond;
	}
};

template<class T>
class tIdentity
{
public:
	const T& operator () ( const T& x ) const
	{
		return x;
	}
};
