/* ==========================================================================
*    : ̼
*    : 2006.09.17
*      : ޸ Ǯ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Allocator.h"
#include "HashSet.h"

template<class T>
class tPool;

/// ޸ Ǯ 
template<class T, class ALLOC = tAllocator<T> >
class tPoolNode
{
	typedef tPoolNode<T, ALLOC> cSelf;
	friend class tPool<T>;

protected:
	tPoolNode( unsigned int capacity );
	~tPoolNode();

	/// Ʈ 
	T* GetObject( unsigned int i );

protected:
	/// Ʈ 迭
	T* mpObjectArray;

	/// ũ (Ʈ )
	unsigned int mCapacity;

	///  
	cSelf* mpNext;

private:
	tPoolNode( const cSelf& );
	cSelf& operator = ( const cSelf& );
};

/// ޸ Ǯ
template<class T>
class tPool
{
	typedef tPool<T> cSelf;
	typedef tPoolNode<T> cNode;

public:
	explicit tPool( unsigned int initialCapacity = 0, unsigned int stepCapacity = 0, unsigned int hashHint = 1000 );
	~tPool();

	/// Ҵ ޸𸮸  
	void Clear();

	/// 뷮 
	void Reserve( unsigned int capacity, unsigned int stepCapacity = 0 );

	/// Ҵ
	T* Alloc();

	/// 
	void Free( T* p );

	/// ũ(Ҵ Ʈ ) 
	unsigned int GetSize() const;

	/// 뷮 
	unsigned int GetCapacity() const;

protected:
	/// ο 带 
	bool CreateNode( unsigned int capacity );

protected:
	///  Ʈ V
	typedef tHashSet<T*> cObjectSet;
	cObjectSet mFreeObjectSet;

	/// Ʈ 
	cNode* mpRootNode;

	/// ũ
	unsigned int mSize;

	/// 뷮
	unsigned int mCapacity;

	/// ʱ 뷮
	unsigned int mInitialCapacity;

	///  뷮
	unsigned int mStepCapacity;

private:
	tPool( const cSelf& );
	cSelf& operator = ( const cSelf& );
};

#include "Pool.inl"
