/* ==========================================================================
*    : ̼
*    : 2007.10.08
*      : 켱 ť
* ǻ : 
*===========================================================================*/
#pragma once

#include "Functor.h"

/// 켱 ť
///  Ʈ ̿Ͽ   ؿ  Ҹ ڵ Ѵ.
/// ѹ þ 뷮 پ ʴ´.
template <class T, class COMPARE = tBinaryLess<T> >
class tPriorityQueue
{
	/*
	explicit tPriorityQueue( unsigned int capacity );
	~tPriorityQueue();

	///  Ҹ 
	void Clear();

	/// 뷮 
	void Reserve( unsigned int capacity );

	/// Ҹ ߰
	/// 뷮 Ѿ false Ѵ.
	bool Push( T val );

	/// ù° Ҹ 
	/// Ұ ϳ   false Ѵ.
	bool PopFront();

	/// ù° Ҹ 
	T Front();
	T Front() const;

	///   
	unsigned int GetCount() const;

	/// 뷮 
	unsigned int GetCapacity() const;
	*/

protected:
	typedef tPriorityQueue<T, COMPARE> cSelf;

protected:
	///  Լ
	COMPARE mCompare;

	/// 迭
	T* mHead;

	/// 뷮
	unsigned int mCapacity;

	///  
	unsigned int mCount;

protected:
	void Reserve( unsigned int capacity )
	{
		if( capacity <= mCapacity )
			return;

		/// 迭 
		T* newHead = new T[capacity];
		assert( newHead );

		///  迭 
		for( unsigned int i = 0; i < mCount; ++i )
			newHead[i] = mHead[i];

		delete[] mHead;
		mHead = newHead;
		mCapacity = capacity;
	}

	void WalkUp( unsigned int index )
	{
		unsigned int parent = index / 2;
		unsigned int child = index;

		T temp = mHead[child];

		while( parent > 0 )
		{
			if( mCompare( temp, mHead[parent] ) )
			{
				mHead[child] = mHead[parent];
				child = parent;
				parent /= 2;
			}
			else
				break;
		}

		mHead[child] = temp;
	}

	void WalkDown( unsigned int index )
	{
		unsigned int parent = index;
		unsigned int child = index * 2;

		T temp = mHead[parent];

		while( child < mCount )
		{
			if( child < mCount - 1 )
			{
				if( mCompare( mHead[child], mHead[child + 1] ) == false )
				{
					child++;
				}
			}
			if( mCompare( temp, mHead[child] ) == false )
			{
				mHead[parent] = mHead[child];
				parent = child;
				child *= 2;
			}
			else
				break;
		}

		mHead[parent] = temp;
	}

public:
	explicit tPriorityQueue( unsigned int capacity )
		: mHead( 0 )
		, mCapacity( 0 )
		, mCount( 0 )
	{
		assert( capacity );

		Reserve( capacity + 1 );
	}

	~tPriorityQueue()
	{
		delete [] mHead;
	}

	void Clear()
	{
		mCount = 0;
	}

	bool Push( T value )
	{
		if( mCount + 1 >= mCapacity )
		{
			return false;
		}

		++mCount;
		mHead[mCount] = value;
		WalkUp( mCount );
		return true;
	}

	void PopFront()
	{
		if( mCount )
		{
			mHead[1] = mHead[mCount];
			WalkDown( 1 );
			--mCount;
		}
	}

	T Front()
	{
		return mHead[1];
	}

	T Front() const
	{
		return mHead[1];
	}

	unsigned int GetCount() const
	{
		return mCount;
	}

	unsigned int GetCapacity() const
	{
		return mCapacity;
	}
};
