/* ==========================================================================
*    : ̼
*    : 2006.09.15
*      : tStack 
* ǻ : 
*===========================================================================*/

public:
	tStack()
	{
	}

	explicit tStack( unsigned int capacity )
	{
		assert( capacity > 0 );
		reserve( capacity );
	}

	void Clear()
	{
		clear();
	}

	void Reserve( unsigned int capacity )
	{
		reserve( capacity );
	}

	bool PushBack( const T& val )
	{
		if( IsFull() )
		{
			assert( 0 && "stack overflow" );
			return false;
		}
		else
		{
			push_back( val );
			return true;
		}
	}

	bool PopBack( )
	{
		if( IsEmpty() )
		{
			return false;
		}
		else
		{
			pop_back();
			return true;
		}
	}

	T& Back()
	{
		assert( empty() == false );
		return back();
	}

	const T& Back() const
	{
		assert( empty() == false );
		return back();
	}

	unsigned int GetSize() const
	{
		return size();
	}

	unsigned int GetCapacity() const
	{
		return capacity();
	}

	bool IsEmpty() const
	{
		return empty();
	}

	bool IsFull() const
	{
		return size() == capacity();
	}
