/* ==========================================================================
*    : ̼
*    : 2007.01.11
*      : Ÿ Ʈ ̹
* ǻ : 
*===========================================================================*/
#pragma once

class cFileLoader;

/// Ÿ Ʈ ̹
class cTargaImage
{
public:
	cTargaImage();

	/// 
	void Clear();

	/// ε
	bool Load( const cString& pathName );
	bool Load( cFileLoader& loader );

	/// 
	bool Save( const cString& pathName );

	/// ũ 
	void Resize( unsigned int width, unsigned int height, unsigned int bytesPerPixel );

	///  Ʈ  ٲ ( RGB <-> BGR )
	void ChangeColorByteOrder();

	/// ȼ 
	bool SetPixel( unsigned int x, unsigned int y, unsigned char red, unsigned char green, unsigned char blue, unsigned char alpha = 1.0f );

	/// ʺ( ȼ  ) 
	unsigned int GetWidth() const;

	/// ( ȼ  ) 
	unsigned int GetHeight() const;

	/// ȼ Ʈ  
	unsigned int GetBytesPerPixel() const;

	/// ũ( Ʈ  ) 
	unsigned int GetSize() const;

	/// ȼ 
	bool GetPixel( unsigned char* red, unsigned char* green, unsigned char* blue, unsigned int x, unsigned int y );
	bool GetPixel( unsigned char* red, unsigned char* green, unsigned char* blue, unsigned char* alpha, unsigned int x, unsigned int y );

	/// : x y [0, 1]  Ѵ.
	bool GetPixel( unsigned char* red, unsigned char* green, unsigned char* blue, float x, float y );

	///  
	const tArray<unsigned char>& GetBuffer() const;

	///   
	const unsigned char* GetBufferPtr() const;

protected:
	/// ʺ
	unsigned int mWidth;

	/// 
	unsigned int mHeight;

	/// ȼ  Ʈ 
	unsigned int mBytesPerPixel;

	/// ̹ ũ ( mWidth * mHeight * mBytesPerPixel )
	unsigned int mSize;

	/// 
	typedef tArray<unsigned char> cBuffer;
	cBuffer mBuffer;
};

inline
unsigned int cTargaImage::GetWidth() const
{
	return mWidth;
}

inline
unsigned int cTargaImage::GetHeight() const
{
	return mHeight;
}

inline
unsigned int cTargaImage::GetBytesPerPixel() const
{
	return mBytesPerPixel;
}

inline
unsigned int cTargaImage::GetSize() const
{
	return mSize;
}

inline
const tArray<unsigned char>& cTargaImage::GetBuffer() const
{
	return mBuffer;
}

inline
const unsigned char* cTargaImage::GetBufferPtr() const
{
	return &mBuffer[0];
}
