//////////////////////////////////////////////////////////////////////////////////////
// fontscript.c - "Writes out a hcomp compiliable font script file"
//
// Author: Michael Starich   
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2001
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 08/02/99 Starich     Created.
//////////////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "fang.h"
#include "fresload.h"
#include "fontscript.h"
#include "fontpack.h"
#include "fontcut.h"
#include "tga.h"
#include "UnicodeFile.h"
#include <stdio.h>
#include <string.h>

//====================
// private definitions

//=================
// public variables

//==================
// private variables

static TCHAR _pszErrorString[256];

//===================
// private prototypes

//=================
// public functions

BOOL fontscript_ModuleInit( void ) {
	
	_pszErrorString[0] = NULL;

	return TRUE;
}

BOOL fontscript_WriteScriptFile( LPCTSTR pszFileName, LPCTSTR pszSourceFileName, PackData_t *pPack,
								 LPCTSTR pszComputerName, LPCTSTR pszUserName, LPCTSTR pszLetterString,
								 LPCTSTR pszTGAPath, const f32 fLetterSpacing, const f32 fWordSpacing, const f32 fItalicSlant ) {

	// This converts the GENERIC text strings to Wide strings
	// for serialization purposes.
	CStringW sFileName       = pszFileName;
	CStringW sSourceFileName = pszSourceFileName;
	CStringW sComputerName   = pszComputerName;
	CStringW sUserName       = pszUserName;
	CStringW sLetterString   = pszLetterString;
	CStringW sTGAPath        = pszTGAPath;


	CUnicodeFile file;
	CStringW TempString;

	u32 i;
	TCHAR szTemp[ FRES_NAMELEN + 1 ];
	PackedLetter_t *pLetter;
	Letter_t *pOrigLetter;

	if( !file.Open( pszFileName, UNICODEFILE_OPENMODE_WRITE ) ) {
		_tcscpy( _pszErrorString, _T( "Could not open script file for writing!" ) );
		return FALSE;
	}
/*
################################################################
# FONT DESCRIPTION SCRIPT - GENERATED BY FONTOMATIC
#   SCRIPT FILE: XYZ.FNT
#	CREATED FROM: XYZ.TGA
#   CREATED BY USER: XYZ ON WORKSTATION: XYZ
#	37 LETTERS EXPORTED ON 2 TGA(S)
#	OUTPUT TGA 1: XYZ.TGA
#	OUTPUT TGA 2: XYZ.TGA
################################################################
*/	TempString.Format( L"#################################################################\n" );
	file.WriteString( TempString );
	
	TempString.Format( L"# FONT DESCRIPTION SCRIPT - GENERATED BY FONTOMATIC\n" );
	file.WriteString( TempString );
	TempString.Format( L"#   SCRIPT FILE: %s\n", sFileName );
	file.WriteString( TempString );
	TempString.Format( L"#   CREATED FROM: %s\n", sSourceFileName );
	file.WriteString( TempString );
	TempString.Format( L"#   CREATED BY USER: %s ON WORKSTATION: %s\n", sUserName, sComputerName );
	file.WriteString( TempString );
	TempString.Format( L"#  %3d LETTERS EXPORTED ON %d TGA(S)\n", pPack->pOriginalData->nNumLetters, pPack->nNumPages );
	file.WriteString( TempString );
	for( i=0; i < pPack->nNumPages; i++ ) {
		CStringW sTempFilename = pPack->pszFilenames[i];
		TempString.Format( L"#   OUTPUT TGA %d: %s%s\n", i+1, sTGAPath, sTempFilename );
	file.WriteString( TempString );
	}
	TempString.Format( L"#################################################################\n\n");
	file.WriteString( TempString );
	
	
/*
###################
# USER DEFINED AREA
###################

# TEXT STRING OF THE LETTERS CONTAINED IN THE ORIGINAL FONT FILE
TEXT "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.?:" 0

# AMOUNT TO SPACE EACH LETTER
COMMAND FONT_SET_LETTER_SPACING SPACING ID

# AMOUNT TO SPACE A WORD
COMMAND FONT_SET_WORD_SPACING SPACING ID

# AMOUNT TO SLANT A FONT WHEN ITALICIZED
COMMAND FONT_SET_ITALIC_SLANT 2 0

*/	TempString.Format( L"###################\n" );
	file.WriteString( TempString );
	TempString.Format( L"# USER DEFINED AREA\n" );
	file.WriteString( TempString );
	TempString.Format( L"###################\n\n" );
	file.WriteString( TempString );
	TempString.Format( L"# TEXT STRING OF THE LETTERS CONTAINED IN THE ORIGINAL FONT FILE\n" );
	file.WriteString( TempString );
	TempString.Format( L"TEXT \"%s\" 0\n\n", sLetterString );
	file.WriteString( TempString );
	TempString.Format( L"# AMOUNT TO SPACE EACH LETTER\n" );
	file.WriteString( TempString );
	TempString.Format( L"COMMAND FONT_SET_LETTER_SPACING %f 0\n\n", fLetterSpacing );
	file.WriteString( TempString );
	TempString.Format( L"# AMOUNT TO SPACE A WORD\n" );
	file.WriteString( TempString );
	TempString.Format( L"COMMAND FONT_SET_WORD_SPACING %f 0\n\n", fWordSpacing );
	file.WriteString( TempString );
	TempString.Format( L"# AMOUNT TO SLANT A FONT WHEN ITALICIZED\n" );
	file.WriteString( TempString );
	TempString.Format( L"COMMAND FONT_SET_ITALIC_SLANT %f 0\n\n", fItalicSlant );
	file.WriteString( TempString );
/*
###########################
# FONTOMATIC GENERATED AREA
#    DO NOT EDIT BELOW HERE
###########################

COMMAND FONT_SET_NUM_TEXTURE_PAGES 2 0

LOAD "XYZ" width height 0
LOAD "ABC" width height 1

COMMAND FONT_NUMBER_LETTERS 37 0

COMMAND FONT_SET_SIZE 7 9 0

COMMAND FONT_SET_VERTICAL_RULER 26 0

# LETTER PLACEMENT DEFINITIONS
#   THE ORIGIN OF THE TEXTURE COORDINATES IS THE UPPER LEFT PIXEL
#   PARAMS:                  X Y X Y X Y X Y WIDTH HEIGHT V_ALIGN TEX_PAGE ORIG_INDEX ID
COMMAND FONT_SET_LETTER_INFO X Y X Y X Y X Y WIDTH HEIGHT V_ALIGN TEX_PAGE ORIG_INDEX ID
*/	TempString.Format( L"###########################\n" );
	file.WriteString( TempString );
	TempString.Format( L"# FONTOMATIC GENERATED AREA\n" );
	file.WriteString( TempString );
	TempString.Format( L"#    DO NOT EDIT BELOW HERE\n" );
	file.WriteString( TempString );
	TempString.Format( L"###########################\n\n" );
	file.WriteString( TempString );
	TempString.Format( L"COMMAND FONT_SET_NUM_TEXTURE_PAGES %d 0\n\n", pPack->nNumPages );	
	file.WriteString( TempString );
	for( i=0; i < pPack->nNumPages; i++ ) {
		fang_MemZero( szTemp, sizeof( szTemp ) );
		_tcsncpy( szTemp, pPack->pszFilenames[i], _tcslen( pPack->pszFilenames[i] ) - 4 );
		CStringW sTemp = szTemp;
		TempString.Format( L"LOAD \"%s\" %u %u %d\n", sTemp, pPack->pauWidth[i], pPack->pauHeight[i], i );
		file.WriteString( TempString );
	}
	TempString.Format( L"\nCOMMAND FONT_NUMBER_LETTERS %d 0\n", pPack->pOriginalData->nNumLetters );
	file.WriteString( TempString );
	TempString.Format( L"\nCOMMAND FONT_SET_SIZE %d %d 0\n", pPack->pOriginalData->nWidth, pPack->pOriginalData->nHeight );
	file.WriteString( TempString );
	TempString.Format( L"\nCOMMAND FONT_SET_VERTICAL_RULER %d 0\n\n", pPack->pOriginalData->uVertialRuler );
	file.WriteString( TempString );
	TempString.Format( L"# LETTER PLACEMENT DEFINITIONS\n" );
	file.WriteString( TempString );
	TempString.Format( L"#   THE ORIGIN OF THE TEXTURE COORDINATES IS THE UPPER LEFT PIXEL\n" );
	file.WriteString( TempString );
	TempString.Format( L"#   PARAMS:                    X   Y   X   Y   X   Y   X   Y WIDTH HEIGHT V_ALIGN TEX_PAGE ORIG_INDEX  ID\n" );
	file.WriteString( TempString );
	for( i=0; i < pPack->pOriginalData->nNumLetters; i++ ) {
		pLetter = &pPack->pPackedLetterArray[i];
		pOrigLetter = &pPack->pOriginalData->pLetterArray[ pLetter->nUnPackedIndex ];
		TempString.Format( L"COMMAND FONT_SET_LETTER_INFO %3d %3d %3d %3d %3d %3d %3d %3d   %3d    %3d     %3d      %3d        %3d %3d\n", 
			     pLetter->nLeft, pLetter->nBottom,
				 pLetter->nLeft, pLetter->nTop,
				 pLetter->nRight, pLetter->nTop,
				 pLetter->nRight, pLetter->nBottom,
				 pOrigLetter->nWidth, pOrigLetter->nHeight,
				 pOrigLetter->nVAlignment, pLetter->nTexturePageIndex,
				 pLetter->nUnPackedIndex, i );
		file.WriteString( TempString );
	}	

	return TRUE;

}

LPCTSTR fontscript_GetLastError( void ) {
	return _pszErrorString;
}

//==================
// private functions

