//////////////////////////////////////////////////////////////////////////////////////
// LaserBeam.h - Laser beam system for Mettle Arms.
//
// Author: Justin Link
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2002
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 06/13/02 Link		Created.
//////////////////////////////////////////////////////////////////////////////////////

#ifndef _LASERBEAM_H_
#define _LASERBEAM_H_ 1

#include "fang.h"
#include "fmath.h"
#include "ftex.h"
#include "fcoll.h"
#include "fdecal.h"

struct FDrawVtx_t;



class CFWorldMesh;
class CEntity;
class CWeapon;
class CDamageProfile;




FCLASS_ALIGN_PREFIX class CLaserBeam
{
public:
	//////////////////////////////////////////////////////////////////////
	//
	static BOOL InitSystem();
	static void UninitSystem();
	static BOOL InitLevel();
	static void UninitLevel();
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	static void Work();
	static void Draw();
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	static CLaserBeam *GetLaserBeam( void );
	~CLaserBeam();
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	// 
	void SetStartPosAndDir(const CFVec3A &vecPos, const CFVec3A &vecUnitDir, CWeapon *pOwnerWeapon, const CDamageProfile *pDamageProfile);
	//
	//////////////////////////////////////////////////////////////////////

private:
	//////////////////////////////////////////////////////////////////////
	//
	CLaserBeam();

	void _Work();
	// avecCoeff *must* point to an array of 3 CFVec3As.
	void _Eval(CFVec3A *avecCoeff, f32 fInput, CFVec3A &vecOut);
	void _Draw();
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	// Helper functions.

	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	enum LaserBeamFlags_e
	{
		LASERBEAMFLAG_DRAWNEXTFRAME		=	1 << 0,
		LASERBEAMFLAG_DRAWNLASTFRAME	=	1 << 1,

	};
	u32 m_uFlags;
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	static BOOL m_bSystemInitted;
	static CLaserBeam *m_pLastCreated;
	static cchar *m_pszTexName, *m_pszMuzzleFlash;
	static CFTexInst m_texBeam, m_texMuzzleFlash;
	static CFTexInst m_atexBeam[2];
	static FDecalDefHandle_t m_hDecalDef;
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	CLaserBeam *m_pPrev;
	//
	//////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////
	//
	CFVec3A m_vecStartPos;
	CFVec3A m_vecStartUnitDir;
	CFVec3A m_vecEndPosLast;
	CFVec3A m_vecEndPosIdeal;
	CFVec3A m_vecEndPosVel;

	u64 m_nLoopTickSnapshotWhenLastDamageIssued;

	FCollImpact_t m_Impact;
	CEntity *m_pImpactEntity;				// NULL=no impact
	CFWorldMesh *m_pImpactWorldMesh;

	CWeapon *m_pOwnerWeapon;
	const CDamageProfile *m_pDamageProfile;
	

	BOOL m_bHitSomething;

	f32 m_fTexScroll;
	//
	//////////////////////////////////////////////////////////////////////

	FCLASS_STACKMEM_ALIGN(CLaserBeam);
} FCLASS_ALIGN_SUFFIX;

#endif
