//////////////////////////////////////////////////////////////////////////////////////
// botblink_data.cpp - Bot data.
//
// Author: Steve Ranck     
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2002
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 03/26/02 Ranck       Created.
//////////////////////////////////////////////////////////////////////////////////////

#include "fang.h"
#include "fanim.h"
#include "botanim.h"
#include "fmesh.h"
#include "fgamedata.h"
#include "botglitch.h"




//--------------------------------------------------------------------------------------------------------
// Bot Definition:
//--------------------------------------------------------------------------------------------------------

const CBotDef CBotGlitch::m_BotDef = {
	BOTRACE_DROID,							// nRace
	BOTCLASS_MINER,							// nClass
	BOTSUBCLASS_MINER_BLINK,				// nSubClass
};




//--------------------------------------------------------------------------------------------------------
// Game Data Vocab:
//--------------------------------------------------------------------------------------------------------

const FGameData_TableEntry_t CBotGlitch::m_aBotInfoVocab_Glitch[] = {
	// afMaxXlatSpeed[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afMaxXlatSpeed[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afMaxXlatSpeed[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afNormVelocityStepSize[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afNormVelocityStepSize[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afNormVelocityStepSize[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump1[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump1[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump1[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump2[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump2[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afVertVelocityJump2[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afWeaponSwitchTimeScale[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afWeaponSwitchTimeScale[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afWeaponSwitchTimeScale[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherReloadAnimSpeedMult[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherReloadAnimSpeedMult[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherReloadAnimSpeedMult[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherPumpAnimSpeedMult[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherPumpAnimSpeedMult[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afTetherPumpAnimSpeedMult[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afClipReloadAnimSpeedMult[0]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afClipReloadAnimSpeedMult[1]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	// afClipReloadAnimSpeedMult[2]:
	FGAMEDATA_VAR_TYPE_FLOAT|
	FGAMEDATA_FLAGS_FLOAT_X,
	sizeof( f32 ),
	F32_DATATABLE_0,
	F32_DATATABLE_0,

	FGAMEDATA_VOCAB_DAMAGE,			// pDamageProfileGSlap

	FGAMEDATA_VOCAB_SOUND_GROUP,	// pSoundGroupGSlap;

	FGAMEDATA_VOCAB_SOUND_GROUP,	// pSoundGroupRespawn;


	// End of table:
	FGAMEDATA_VAR_TYPE_COUNT| 0, 0, F32_DATATABLE_0, F32_DATATABLE_0
};



//--------------------------------------------------------------------------------------------------------
// Game Data Map:
//--------------------------------------------------------------------------------------------------------

const FGameDataMap_t CBotGlitch::m_aGameDataMap[] = {
	"Gen",
	m_aBotInfoVocab_Gen,
	sizeof(m_BotInfo_Gen),
	(void *)&m_BotInfo_Gen,

	"MountAim",
	m_aBotInfoVocab_MountAim,
	sizeof(m_BotInfo_MountAim),
	(void *)&m_BotInfo_MountAim,

	"Walk",
	m_aBotInfoVocab_Walk,
	sizeof(m_BotInfo_Walk),
	(void *)&m_BotInfo_Walk,

	"Jump",
	m_aBotInfoVocab_Jump,
	sizeof(m_BotInfo_Jump),
	(void *)&m_BotInfo_Jump,

	"Weapon",
	m_aBotInfoVocab_Weapon,
	sizeof(m_BotInfo_Weapon),
	(void *)&m_BotInfo_Weapon,

	"Blink",
	m_aBotInfoVocab_Glitch,
	sizeof(m_BotInfo_Glitch),
	(void *)&m_BotInfo_Glitch,

	"GrabCamera",
	CVehicleCamera::m_aBotInfoVocab_VehicleCamera,
	sizeof( m_BotInfo_GrabCamera ),
	(void*)&m_BotInfo_GrabCamera,
	
	"ThrowCamera",
	CVehicleCamera::m_aBotInfoVocab_VehicleCamera,
	sizeof( m_BotInfo_ThrowCamera ),
	(void*)&m_BotInfo_ThrowCamera,

	NULL
};




//--------------------------------------------------------------------------------------------------------
// Animation Stack Data:
//--------------------------------------------------------------------------------------------------------


cchar *CBotGlitch::m_apszBoneNameTable[BONE_COUNT] = {
	"L_EyeLid_Top",				// BONE_LEFT_EYELID_TOP,
	"L_EyeLid_Bottom",			// BONE_LEFT_EYELID_BOTTOM,
	"L_Eye",					// BONE_LEFT_EYE,

	"Groin",					// BONE_GROIN,
	"Waist",					// BONE_WAIST,
	"Torso",					// BONE_TORSO,
	"L_Arm_Upper",				// BONE_LEFT_ARM_UPPER,
	"L_Arm_Elbow",				// BONE_LEFT_ELBOW,
	"L_Arm_Lower",				// BONE_LEFT_ARM_LOWER,
	"L_Hand",					// BONE_LEFT_HAND,

	"L_ThumbA",					// BONE_LEFT_THUMB_A,
	"L_ThumbB",					// BONE_LEFT_THUMB_B,
	"L_IndexFingerA",			// BONE_LEFT_INDEX_FINGER_A,
	"L_IndexFingerB",			// BONE_LEFT_INDEX_FINGER_B,
	"L_MiddleFingerA",			// BONE_LEFT_MIDDLE_FINGER_A,
	"L_MiddleFingerB",			// BONE_LEFT_MIDDLE_FINGER_B,
	"Secondary_Fire",			// BONE_SECONDARY_FIRE,

	"AttachPoint_Primary",		// BONE_ATTACHPOINT_PRIMARY,
	"R_Shoulder",				// BONE_RIGHT_SHOULDER,
	"R_Arm_Lower",				// BONE_RIGHT_ARM_LOWER,
	"R_Arm_Elbow",				// BONE_RIGHT_ARM_ELBOW,
	"R_ShoulderPad",			// BONE_RIGHT_SHOULDERPAD,

	"Backpack",					// BONE_BACKPACK,
	"AntennaA",					// BONE_ANTENNA1,
	"AntennaB",					// BONE_ANTENNA2,
	"AntennaC",					// BONE_ANTENNA3,
	"AntennaD",					// BONE_ANTENNA4,
	"AntennaE",					// BONE_ANTENNA5,

	"Backpack_Door",			// BONE_BACKPACK_DOOR,
	"Neck",						// BONE_NECK,
	"Head",						// BONE_HEAD,
	"Jaw",						// BONE_JAW,
	"MinerDummy",				// BONE_MINER_DUMMY,

	"R_EyeLid_Top",				// BONE_RIGHT_EYELID_TOP,
	"R_EyeLid_Bottom",			// BONE_RIGHT_EYELID_BOTTOM,
	"R_Eye",					// BONE_RIGHT_EYE,

	"BeltPack1",				// BONE_BELTPACK_1,
	"BeltPack2",				// BONE_BELTPACK_2,
	"BeltPack3",				// BONE_BELTPACK_3,
	"BeltPack4",				// BONE_BELTPACK_4,
	"BeltPack5",				// BONE_BELTPACK_5,

	"R_Leg_Upper",				// BONE_RIGHT_LEG_UPPER,
	"R_Leg_Joint_Dummy",		// BONE_RIGHT_LEG_JOINT_DUMMY,
	"R_Knee",					// BONE_RIGHT_KNEE,
	"R_Leg_Lower",				// BONE_RIGHT_LEG_LOWER,
	"R_Foot_Front",				// BONE_RIGHT_FOOT_FRONT,
	"R_Toe",					// BONE_RIGHT_TOE,
	"R_Foot_Back",				// BONE_RIGHT_FOOT_BACK,
	"R_Heel",					// BONE_RIGHT_HEEL,

	"L_Leg_Upper",				// BONE_LEFT_LEG_UPPER,
	"L_Leg_Joint_Dummy",		// BONE_LEFT_LEG_JOINT_DUMMY,
	"L_Knee",					// BONE_LEFT_KNEE,
	"L_Leg_Lower",				// BONE_LEFT_LEG_LOWER,
	"L_Foot_Back",				// BONE_LEFT_FOOT_FRONT,
	"L_Heel",					// BONE_LEFT_TOE,
	"L_Foot_Front",				// BONE_LEFT_FOOT_BACK,
	"L_Toe",					// BONE_LEFT_HEEL,

};


cchar *CBotGlitch::m_apszBaseAnimNameTable[ANIM_BASE_COUNT] = {
	// Ground locomotion:
	"ARDGidle001",					// ANIM_STAND
	"ARDGtiptoe1",					// ANIM_SNEAK
	"ARDGwalkF01",					// ANIM_WALK_FORWARD
	"ARDGrun_F01",					// ANIM_RUN_FORWARD

	// Air locomotion:
	"ARDGjump_01",					// ANIM_JUMP_LAUNCH
	"ARDGjump_03",					// ANIM_JUMP_LAND
	"ARDGjump_02",					// ANIM_JUMP_FLY
	"ARDGjump201",					// ANIM_JUMP_TUCK
	"ARDGjump202",					// ANIM_JUMP_UNTUCK
	"ARDGcable01",					// ANIM_CABLE_REACH
	"ARDGcable02",					// ANIM_CABLE_GRASP
	"ARDGcable03",					// ANIM_CABLE_RELEASE

	// Weapon firing and reloading:
	//"ARDGactn101",					// ANIM_FIRE_PRIMARY
	"ardgready01",					// ANIM_FIRE_PRIMARY
	"ARDGfirD101",					// ANIM_FIRE_ROCKET1
	"ARDGfirD102",					// ANIM_FIRE_ROCKET23
	"ARDGfirP701",					// ANIM_FIRE_MORTAR

	"ARDGaimD101",					// ANIM_AIM_DUAL_WITH_TORSO_TWISTED
	"ARDGaimD102",					// ANIM_AIM_SHOULDER_MOUNTED
	"ARDGaimP701",					// ANIM_AIM_MORTAR

	"ARDGrldD101",					// ANIM_RELOAD_ROCKET1_GRAB_AMMO
	"ARDGrldD102",					// ANIM_RELOAD_ROCKET1_DROP_IN
	"ARDGrldD103",					// ANIM_RELOAD_ROCKET1_FINISH

	"ARDGrldD401",					// ANIM_RELOAD_TETHER_PREPARE_TO_PUMP,
	"ARDGrldD402",					// ANIM_RELOAD_TETHER_PUMP,
	"ARDGrldD403",					// ANIM_RELOAD_TETHER_GRAB_AMMO,
	"ARDGrldD404",					// ANIM_RELOAD_TETHER_DROP_IN,
	"ARDGrldD405",					// ANIM_RELOAD_TETHER_FINISH,

	"ARDGrldP701",					// ANIM_RELOAD_MORTAR_GRAB_AMMO
	"ARDGrldP702",					// ANIM_RELOAD_MORTAR_PLACE_IN_SLING
	"ARDGrldP703",					// ANIM_RELOAD_MORTAR_TAKE_UP_SLACK

	"ARDGactn201",					// ANIM_FIRE_SECONDARY
	"ARDGrldPx01",					// ANIM_RELOAD_SINGLE_ARM

	"ARDGrldP201",					// ANIM_RELOAD_CLIP_EJECT_OLD
	"ARDGrldP202",					// ANIM_RELOAD_CLIP_GRAB_NEW
	"ARDGrldP203",					// ANIM_RELOAD_CLIP_INSERT_NEW
	"ARDGrldP204",					// ANIM_RELOAD_CLIP_SLAPIN_NEW

	"ARDGrldP702",					// ANIM_SCOPE_ATTACHING

	// Weapon switching:
	"ARDGswtchA3",					// ANIM_WEAPON_SWITCH_RELEASE_SINGLE
	"ARDGswtchB3",					// ANIM_WEAPON_SWITCH_RELEASE_DUAL
	"ARDGswtchC3",					// ANIM_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED
	"ARDGswtch_2",					// ANIM_WEAPON_SWITCH

	// Leech animation
	"ARDGleech01",					// ANIM_LEECH
	
	"ARDGaimpb01",					// ANIM_AIM_PILLBOX

	"ARDGwrench1",					// ANIM_DISASSEMBLE
	"ARDGassemb1",					// ANIM_ASSEMBLE
	"ARDGjoyst01",					// ANIM_USE_CONSOLE

	"ARDGbash_01",					// ANIM_GSLAP,
	"ARDGshove01",					// ANIM_SHOVE,

	"ARDGrespwn1",					// ANIM_RESPAWN,

	"ARDGGetup01",					// ANIM_GETUP,
	"ardgelect01",					// ANIM_RC_TETHER
};


cchar		**CBotGlitch::m_apszIdleAnimNameTable;
const u8	**CBotGlitch::m_apnEnableBoneNameIndexTableForEachIdleTap;

cchar *CBotGlitch::m_apszBaseControlNameTable[ANIMCONTROL_BASE_COUNT] = {
	"stand",						// ANIMCONTROL_STAND,
	"sneak",						// ANIMCONTROL_SNEAK,
	"walk",							// ANIMCONTROL_WALK,
	"run",							// ANIMCONTROL_RUN,
    
	"recoil_summer",				// ANIMCONTROL_RECOIL_SUMMER,
	"aim_summer",					// ANIMCONTROL_AIM_SUMMER,

	"jump_launch",					// ANIMCONTROL_JUMP_LAUNCH,
	"jump_land_L",					// ANIMCONTROL_JUMP_LAND_LOWER,
	"jump_land_U",					// ANIMCONTROL_JUMP_LAND_UPPER,
	"jump_fly",						// ANIMCONTROL_JUMP_FLY,
	"jump_tuck",					// ANIMCONTROL_JUMP_TUCK,
	"jump_untuck",					// ANIMCONTROL_JUMP_UNTUCK,
	"cable_reach",					// ANIMCONTROL_CABLE_REACH,
	"cable_grasp",					// ANIMCONTROL_CABLE_GRASP,
	"cable_release",				// ANIMCONTROL_CABLE_RELEASE,

	"fire1_lower",					// ANIMCONTROL_FIRE_1_LOWER
	"fire1_upper",					// ANIMCONTROL_FIRE_1_UPPER,
	"fire2_lower",					// ANIMCONTROL_FIRE_2_LOWER,
	"fire2_upper",					// ANIMCONTROL_FIRE_2_UPPER,

	"aim_rocket1",					// ANIMCONTROL_AIM_DUAL_WITH_TORSO_TWISTED,
	"aim_rocket23",					// ANIMCONTROL_AIM_SHOULDER_MOUNTED,
	"aim_mortar",					// ANIMCONTROL_AIM_MORTAR

	"rocket1_rld_G",				// ANIMCONTROL_RELOAD_ROCKET1_GRAB_AMMO,
	"rocket1_rld_D",				// ANIMCONTROL_RELOAD_ROCKET1_DROP_IN,
	"rocket1_rld_F",				// ANIMCONTROL_RELOAD_ROCKET1_FINISH,

	"tether_rld_PP",				// ANIMCONTROL_RELOAD_TETHER_PREPARE_TO_PUMP,
	"tether_rld_P",					// ANIMCONTROL_RELOAD_TETHER_PUMP,
	"tether_rld_G",					// ANIMCONTROL_RELOAD_TETHER_GRAB_AMMO,
	"tether_rld_D",					// ANIMCONTROL_RELOAD_TETHER_DROP_IN,
	"tether_rld_F",					// ANIMCONTROL_RELOAD_TETHER_FINISH,

	"mortar_rld_G",					// ANIMCONTROL_RELOAD_MORTAR_GRAB_AMMO,
	"mortar_rld_S",					// ANIMCONTROL_RELOAD_MORTAR_PLACE_IN_SLING,
	"mortar_rld_T",					// ANIMCONTROL_RELOAD_MORTAR_TAKE_UP_SLACK,

	"single_rld_arm",				// ANIMCONTROL_RELOAD_SINGLE_ARM,
	"single_rld_body",				// ANIMCONTROL_RELOAD_SINGLE_BODY,

	"clip_rld_eject",				// ANIMCONTROL_RELOAD_CLIP_EJECT_OLD
	"clip_rld_grab",				// ANIMCONTROL_RELOAD_CLIP_GRAB_NEW
	"clip_rld_insert",				// ANIMCONTROL_RELOAD_CLIP_INSERT_NEW
	"clip_rld_slapin",				// ANIMCONTROL_RELOAD_CLIP_SLAPIN_NEW

	"scope_attaching",				// ANIMCONTROL_SCOPE_ATTACHING

	"ws_release_s",					// ANIMCONTROL_WEAPON_SWITCH_RELEASE_SINGLE,
	"ws_release_d",					// ANIMCONTROL_WEAPON_SWITCH_RELEASE_DUAL,
	"ws_release_RL23",				// ANIMCONTROL_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,
	"ws_switch",					// ANIMCONTROL_WEAPON_SWITCH,

	"leech",						// ANIMCONTROL_LEECH,
	"aim_pillbox",					// ANIMCONTROL_AIM_PILLBOX

	"disassemble",					// ANIMCONTROL_DISASSEMBLE,
	"assemble",						// ANIMCONTROL_ASSEMBLE,
	"use_console",					// ANIMCONTROL_USE_CONSOLE,

	"gslap_u",						// ANIMCONTROL_GSLAP_UPPER,
	"gslap_l",						// ANIMCONTROL_GSLAP_LOWER,
	"shove_u",						// ANIMCONTROL_SHOVE_UPPER,
	"shove_l",						// ANIMCONTROL_SHOVE_LOWER,
	"respawn",						// ANIMCONTROL_RESPAWN,
	"getup",						// ANIMCONTROL_GETUP,
	"tether",						// ANIMCONTROL_RC_TETHER,


};


cchar *CBotGlitch::m_apszBaseTapNameTable[ANIMTAP_BASE_COUNT] = {
	"stand",						// ANIMTAP_STAND,
	"sneak",						// ANIMTAP_SNEAK,
	"walk",							// ANIMTAP_WALK,
	"run",							// ANIMTAP_RUN,

	"recoil_summer",				// ANIMTAP_RECOIL_SUMMER,
	"aim_summer",					// ANIMTAP_AIM_SUMMER,

	"jump_launch",					// ANIMTAP_JUMP_LAUNCH,
	"jump_land_L",					// ANIMTAP_JUMP_LAND_LOWER,
	"jump_land_U",					// ANIMTAP_JUMP_LAND_UPPER,
	"jump_fly",						// ANIMTAP_JUMP_FLY,
	"jump_tuck",					// ANIMTAP_JUMP_TUCK,
	"jump_untuck",					// ANIMTAP_JUMP_UNTUCK,
	"cable_reach",					// ANIMTAP_CABLE_REACH,
	"cable_grasp",					// ANIMTAP_CABLE_GRASP,
	"cable_release",				// ANIMTAP_CABLE_RELEASE,

	"fire1_lower",					// ANIMTAP_FIRE_1_LOWER
	"fire1_upper",					// ANIMTAP_FIRE_1_UPPER,
	"fire2_lower",					// ANIMTAP_FIRE_2_LOWER,
	"fire2_upper",					// ANIMTAP_FIRE_2_UPPER,

	"aim_rocket1",					// ANIMTAP_AIM_DUAL_WITH_TORSO_TWISTED,
	"aim_rocket23",					// ANIMTAP_AIM_SHOULDER_MOUNTED,
	"aim_mortar",					// ANIMTAP_AIM_MORTAR

	"rocket1_rld_G",				// ANIMTAP_RELOAD_ROCKET1_GRAB_AMMO,
	"rocket1_rld_D",				// ANIMTAP_RELOAD_ROCKET1_DROP_IN,
	"rocket1_rld_F",				// ANIMTAP_RELOAD_ROCKET1_FINISH,

	"tether_rld_PP",				// ANIMTAP_RELOAD_TETHER_PREPARE_TO_PUMP,
	"tether_rld_P",					// ANIMTAP_RELOAD_TETHER_PUMP,
	"tether_rld_G",					// ANIMTAP_RELOAD_TETHER_GRAB_AMMO,
	"tether_rld_D",					// ANIMTAP_RELOAD_TETHER_DROP_IN,
	"tether_rld_F",					// ANIMTAP_RELOAD_TETHER_FINISH,

	"mortar_rld_G",					// ANIMTAP_RELOAD_MORTAR_GRAB_AMMO,
	"mortar_rld_S",					// ANIMTAP_RELOAD_MORTAR_PLACE_IN_SLING,
	"mortar_rld_T",					// ANIMTAP_RELOAD_MORTAR_TAKE_UP_SLACK,

	"single_rld_arm",				// ANIMTAP_RELOAD_SINGLE_ARM
	"single_rld_body",				// ANIMTAP_RELOAD_SINGLE_BODY

	"clip_rld_eject",				// ANIMTAP_RELOAD_CLIP_EJECT_OLD
	"clip_rld_grab",				// ANIMTAP_RELOAD_CLIP_GRAB_NEW
	"clip_rld_insert",				// ANIMTAP_RELOAD_CLIP_INSERT_NEW
	"clip_rld_slapin",				// ANIMTAP_RELOAD_CLIP_SLAPIN_NEW

	"scope_attaching",				// ANIMTAP_SCOPE_ATTACHING

	"ws_release_s",					// ANIMTAP_WEAPON_SWITCH_RELEASE_SINGLE,
	"ws_release_d",					// ANIMTAP_WEAPON_SWITCH_RELEASE_DUAL,
	"ws_release_RL23",				// ANIMTAP_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,
	"ws_switch",					// ANIMTAP_WEAPON_SWITCH,

	"leech",						// ANIMTAP_LEECH
	
	"aim_pillbox",					// ANIMTAP_AIM_PILLBOX

	"disassemble",					// ANIMTAP_DISASSEMBLE,
	"assemble",						// ANIMTAP_ASSEMBLE,
	"use_console",					// ANIMTAP_USE_CONSOLE,

	"gslap_u",						// ANIMTAP_GSLAP_UPPER,
	"gslap_l",						// ANIMTAP_GSLAP_LOWER,
	"shove_u",						// ANIMTAP_SHOVE_UPPER,
	"shove_l",						// ANIMTAP_SHOVE_LOWER,
	"respawn",						// ANIMTAP_RESPAWN,
	"getup",						// ANIMTAP_GETUP,
	"tether",						// ANIMTAP_RC_TETHER
};


CFAnimCombinerConfig::ConfigStack_t CBotGlitch::m_aAnimCombinerConfigStack[] = {
	// From highest to lowest priority:
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RC_TETHER,			
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_GETUP,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RESPAWN,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_LEECH,
	
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_AIM_PILLBOX,

	CFAnimMixer::TYPE_SUMMER,						ANIMCONTROL_RECOIL_SUMMER,
//	CFAnimMixer::TYPE_SUMMER,						ANIMCONTROL_AIM_SUMMER,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_USE_CONSOLE,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_ASSEMBLE,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_DISASSEMBLE,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_GSLAP_UPPER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_SHOVE_UPPER,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_FIRE_1_UPPER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_FIRE_2_UPPER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_WEAPON_SWITCH_RELEASE_SINGLE,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_WEAPON_SWITCH_RELEASE_DUAL,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_WEAPON_SWITCH,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_ROCKET1_GRAB_AMMO,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_ROCKET1_DROP_IN,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_ROCKET1_FINISH,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_TETHER_PREPARE_TO_PUMP,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_TETHER_PUMP,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_TETHER_GRAB_AMMO,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_TETHER_DROP_IN,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_TETHER_FINISH,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_MORTAR_GRAB_AMMO,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_MORTAR_PLACE_IN_SLING,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_MORTAR_TAKE_UP_SLACK,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_CLIP_EJECT_OLD,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_CLIP_GRAB_NEW,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_CLIP_INSERT_NEW,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_CLIP_SLAPIN_NEW,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_SCOPE_ATTACHING,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_AIM_SHOULDER_MOUNTED,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_CABLE_REACH,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_CABLE_RELEASE,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_CABLE_GRASP,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_SINGLE_ARM,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_LAUNCH,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_LAND_LOWER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_LAND_UPPER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_TUCK,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_UNTUCK,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_JUMP_FLY,

	CFAnimMixer::TYPE_SUMMER,						ANIMCONTROL_AIM_SUMMER,
	
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_AIM_DUAL_WITH_TORSO_TWISTED,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_AIM_MORTAR,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RELOAD_SINGLE_BODY,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_SNEAK,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_RUN,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_WALK,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_GSLAP_LOWER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_SHOVE_LOWER,

	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_FIRE_1_LOWER,
	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_FIRE_2_LOWER,

 	CFAnimMixer::TYPE_BLENDER,						ANIMCONTROL_STAND,

	CFAnimMixer::TYPE_COUNT,						255
};


CFAnimCombinerConfig::ConfigTap_t CBotGlitch::m_aAnimCombinerConfigTaps[] = {
	ANIMTAP_STAND,									ANIMCONTROL_STAND,									1,
	ANIMTAP_SNEAK,									ANIMCONTROL_SNEAK,									1,
	ANIMTAP_WALK,									ANIMCONTROL_WALK,									1,
	ANIMTAP_RUN,									ANIMCONTROL_RUN,									1,

	ANIMTAP_CABLE_REACH,							ANIMCONTROL_CABLE_REACH,							1,
	ANIMTAP_CABLE_GRASP,							ANIMCONTROL_CABLE_GRASP,							1,
	ANIMTAP_CABLE_RELEASE,							ANIMCONTROL_CABLE_RELEASE,							1,
	ANIMTAP_JUMP_UNTUCK,							ANIMCONTROL_JUMP_UNTUCK,							1,
	ANIMTAP_JUMP_TUCK,								ANIMCONTROL_JUMP_TUCK,								1,
	ANIMTAP_JUMP_FLY,								ANIMCONTROL_JUMP_FLY,								1,
	ANIMTAP_JUMP_LAND_LOWER,						ANIMCONTROL_JUMP_LAND_LOWER,						1,
	ANIMTAP_JUMP_LAND_UPPER,						ANIMCONTROL_JUMP_LAND_UPPER,						1,
	ANIMTAP_JUMP_LAUNCH,							ANIMCONTROL_JUMP_LAUNCH,							1,

	ANIMTAP_WEAPON_SWITCH,							ANIMCONTROL_WEAPON_SWITCH,							1,
	ANIMTAP_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,	ANIMCONTROL_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,	1,
	ANIMTAP_WEAPON_SWITCH_RELEASE_DUAL,				ANIMCONTROL_WEAPON_SWITCH_RELEASE_DUAL,				1,
	ANIMTAP_WEAPON_SWITCH_RELEASE_SINGLE,			ANIMCONTROL_WEAPON_SWITCH_RELEASE_SINGLE,			1,

	ANIMTAP_RELOAD_ROCKET1_GRAB_AMMO,				ANIMCONTROL_RELOAD_ROCKET1_GRAB_AMMO,				1,
	ANIMTAP_RELOAD_ROCKET1_DROP_IN,					ANIMCONTROL_RELOAD_ROCKET1_DROP_IN,					1,
	ANIMTAP_RELOAD_ROCKET1_FINISH,					ANIMCONTROL_RELOAD_ROCKET1_FINISH,					1,

	ANIMTAP_RELOAD_TETHER_PREPARE_TO_PUMP,			ANIMCONTROL_RELOAD_TETHER_PREPARE_TO_PUMP,			1,
	ANIMTAP_RELOAD_TETHER_PUMP,						ANIMCONTROL_RELOAD_TETHER_PUMP,						1,
	ANIMTAP_RELOAD_TETHER_GRAB_AMMO,				ANIMCONTROL_RELOAD_TETHER_GRAB_AMMO,				1,
	ANIMTAP_RELOAD_TETHER_DROP_IN,					ANIMCONTROL_RELOAD_TETHER_DROP_IN,					1,
	ANIMTAP_RELOAD_TETHER_FINISH,					ANIMCONTROL_RELOAD_TETHER_FINISH,					1,

	ANIMTAP_RELOAD_MORTAR_GRAB_AMMO,				ANIMCONTROL_RELOAD_MORTAR_GRAB_AMMO,				1,
	ANIMTAP_RELOAD_MORTAR_PLACE_IN_SLING,			ANIMCONTROL_RELOAD_MORTAR_PLACE_IN_SLING,			1,
	ANIMTAP_RELOAD_MORTAR_TAKE_UP_SLACK,			ANIMCONTROL_RELOAD_MORTAR_TAKE_UP_SLACK,			1,

	ANIMTAP_RELOAD_SINGLE_ARM,						ANIMCONTROL_RELOAD_SINGLE_ARM,						1,
	ANIMTAP_RELOAD_SINGLE_BODY,						ANIMCONTROL_RELOAD_SINGLE_BODY,						1,

	ANIMTAP_RELOAD_CLIP_EJECT_OLD,					ANIMCONTROL_RELOAD_CLIP_EJECT_OLD,					1,
	ANIMTAP_RELOAD_CLIP_GRAB_NEW,					ANIMCONTROL_RELOAD_CLIP_GRAB_NEW,					1,
	ANIMTAP_RELOAD_CLIP_INSERT_NEW,					ANIMCONTROL_RELOAD_CLIP_INSERT_NEW,					1,
	ANIMTAP_RELOAD_CLIP_SLAPIN_NEW,					ANIMCONTROL_RELOAD_CLIP_SLAPIN_NEW,					1,

	ANIMTAP_SCOPE_ATTACHING,						ANIMCONTROL_SCOPE_ATTACHING,						1,

	ANIMTAP_RECOIL_SUMMER,							ANIMCONTROL_RECOIL_SUMMER,							1,
	ANIMTAP_AIM_SUMMER,								ANIMCONTROL_AIM_SUMMER,								1,

	ANIMTAP_AIM_DUAL_WITH_TORSO_TWISTED,			ANIMCONTROL_AIM_DUAL_WITH_TORSO_TWISTED,			1,
	ANIMTAP_AIM_SHOULDER_MOUNTED,					ANIMCONTROL_AIM_SHOULDER_MOUNTED,					1,
	ANIMTAP_AIM_MORTAR,								ANIMCONTROL_AIM_MORTAR,								1,
	ANIMTAP_FIRE_1_UPPER,							ANIMCONTROL_FIRE_1_UPPER,							1,
	ANIMTAP_FIRE_1_LOWER,							ANIMCONTROL_FIRE_1_LOWER,							1,
	ANIMTAP_FIRE_2_UPPER,							ANIMCONTROL_FIRE_2_UPPER,							1,
	ANIMTAP_FIRE_2_LOWER,							ANIMCONTROL_FIRE_2_LOWER,							1,

	ANIMTAP_LEECH,									ANIMCONTROL_LEECH,									1,
	ANIMTAP_AIM_PILLBOX,							ANIMCONTROL_AIM_PILLBOX,							1,
	ANIMTAP_DISASSEMBLE,							ANIMCONTROL_DISASSEMBLE,							1,
	ANIMTAP_ASSEMBLE,								ANIMCONTROL_ASSEMBLE,								1,
	ANIMTAP_USE_CONSOLE,							ANIMCONTROL_USE_CONSOLE,							1,

	ANIMTAP_GSLAP_UPPER,							ANIMCONTROL_GSLAP_UPPER,							1,
	ANIMTAP_GSLAP_LOWER,							ANIMCONTROL_GSLAP_LOWER,							1,
	ANIMTAP_SHOVE_UPPER,							ANIMCONTROL_SHOVE_UPPER,							1,
	ANIMTAP_SHOVE_LOWER,							ANIMCONTROL_SHOVE_LOWER,							1,

	ANIMTAP_RESPAWN,								ANIMCONTROL_RESPAWN,								1,

	ANIMTAP_GETUP,									ANIMCONTROL_GETUP,									1,
	ANIMTAP_RC_TETHER,								ANIMCONTROL_RC_TETHER,								1,

	255,											255,												255
};


CFAnimCombiner::AttachList_t CBotGlitch::m_aAnimAttach[] = {
	ANIM_STAND,										ANIMTAP_STAND,
	ANIM_SNEAK,										ANIMTAP_SNEAK,
	ANIM_WALK_FORWARD,								ANIMTAP_WALK,
	ANIM_RUN_FORWARD,								ANIMTAP_RUN,

	ANIM_JUMP_LAUNCH,								ANIMTAP_JUMP_LAUNCH,
	ANIM_JUMP_LAND,									ANIMTAP_JUMP_LAND_LOWER,
	ANIM_JUMP_LAND,									ANIMTAP_JUMP_LAND_UPPER,
	ANIM_JUMP_FLY,									ANIMTAP_JUMP_FLY,
	ANIM_JUMP_TUCK,									ANIMTAP_JUMP_TUCK,
	ANIM_JUMP_UNTUCK,								ANIMTAP_JUMP_UNTUCK,
	ANIM_CABLE_REACH,								ANIMTAP_CABLE_REACH,
	ANIM_CABLE_GRASP,								ANIMTAP_CABLE_GRASP,
	ANIM_CABLE_RELEASE,								ANIMTAP_CABLE_RELEASE,

	ANIM_RELOAD_ROCKET1_GRAB_AMMO,					ANIMTAP_RELOAD_ROCKET1_GRAB_AMMO,
	ANIM_RELOAD_ROCKET1_DROP_IN,					ANIMTAP_RELOAD_ROCKET1_DROP_IN,
	ANIM_RELOAD_ROCKET1_FINISH,						ANIMTAP_RELOAD_ROCKET1_FINISH,

	ANIM_RELOAD_TETHER_PREPARE_TO_PUMP,				ANIMTAP_RELOAD_TETHER_PREPARE_TO_PUMP,
	ANIM_RELOAD_TETHER_PUMP,						ANIMTAP_RELOAD_TETHER_PUMP,
	ANIM_RELOAD_TETHER_GRAB_AMMO,					ANIMTAP_RELOAD_TETHER_GRAB_AMMO,
	ANIM_RELOAD_TETHER_DROP_IN,						ANIMTAP_RELOAD_TETHER_DROP_IN,
	ANIM_RELOAD_TETHER_FINISH,						ANIMTAP_RELOAD_TETHER_FINISH,

	ANIM_RELOAD_MORTAR_GRAB_AMMO,					ANIMTAP_RELOAD_MORTAR_GRAB_AMMO,
	ANIM_RELOAD_MORTAR_PLACE_IN_SLING,				ANIMTAP_RELOAD_MORTAR_PLACE_IN_SLING,
	ANIM_RELOAD_MORTAR_TAKE_UP_SLACK,				ANIMTAP_RELOAD_MORTAR_TAKE_UP_SLACK,

	ANIM_RELOAD_SINGLE,								ANIMTAP_RELOAD_SINGLE_ARM,
	ANIM_RELOAD_SINGLE,								ANIMTAP_RELOAD_SINGLE_BODY,

	ANIM_RELOAD_CLIP_EJECT_OLD,						ANIMTAP_RELOAD_CLIP_EJECT_OLD,
	ANIM_RELOAD_CLIP_GRAB_NEW,						ANIMTAP_RELOAD_CLIP_GRAB_NEW,
	ANIM_RELOAD_CLIP_INSERT_NEW,					ANIMTAP_RELOAD_CLIP_INSERT_NEW,
	ANIM_RELOAD_CLIP_SLAPIN_NEW,					ANIMTAP_RELOAD_CLIP_SLAPIN_NEW,

	ANIM_SCOPE_ATTACHING,							ANIMTAP_SCOPE_ATTACHING,

	BOTANIM_NULL_ANIMSOURCE_ATTACH,					ANIMTAP_RECOIL_SUMMER,
	BOTANIM_NULL_ANIMSOURCE_ATTACH,					ANIMTAP_AIM_SUMMER,

	ANIM_AIM_DUAL_WITH_TORSO_TWISTED,				ANIMTAP_AIM_DUAL_WITH_TORSO_TWISTED,
	ANIM_AIM_SHOULDER_MOUNTED,						ANIMTAP_AIM_SHOULDER_MOUNTED,
	ANIM_AIM_MORTAR,								ANIMTAP_AIM_MORTAR,
	ANIM_FIRE_PRIMARY,								ANIMTAP_FIRE_1_LOWER,
	ANIM_FIRE_PRIMARY,								ANIMTAP_FIRE_1_UPPER,
	ANIM_FIRE_SECONDARY,							ANIMTAP_FIRE_2_LOWER,
	ANIM_FIRE_SECONDARY,							ANIMTAP_FIRE_2_UPPER,
	ANIM_WEAPON_SWITCH_RELEASE_SINGLE,				ANIMTAP_WEAPON_SWITCH_RELEASE_SINGLE,
	ANIM_WEAPON_SWITCH_RELEASE_DUAL,				ANIMTAP_WEAPON_SWITCH_RELEASE_DUAL,
	ANIM_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,	ANIMTAP_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,
	ANIM_WEAPON_SWITCH,								ANIMTAP_WEAPON_SWITCH,

	ANIM_LEECH,										ANIMTAP_LEECH,
	
	ANIM_AIM_PILLBOX,								ANIMTAP_AIM_PILLBOX,

	ANIM_DISASSEMBLE,								ANIMTAP_DISASSEMBLE,
	ANIM_ASSEMBLE,									ANIMTAP_ASSEMBLE,
	ANIM_USE_CONSOLE,								ANIMTAP_USE_CONSOLE,

	ANIM_GSLAP,										ANIMTAP_GSLAP_UPPER,
	ANIM_GSLAP,										ANIMTAP_GSLAP_LOWER,
	ANIM_SHOVE,										ANIMTAP_SHOVE_UPPER,
	ANIM_SHOVE,										ANIMTAP_SHOVE_LOWER,

	ANIM_RESPAWN,									ANIMTAP_RESPAWN,

	ANIM_GETUP,										ANIMTAP_GETUP,
	ANIM_RC_TETHER,									ANIMTAP_RC_TETHER,

	255,											255
};


const u8 CBotGlitch::m_aBoneEnableIndices_FullBody[] = {
	//BONE_LEFT_EYELID_TOP,
	//BONE_LEFT_EYELID_BOTTOM,
	//BONE_LEFT_EYE,

	BONE_GROIN,
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,
	BONE_MINER_DUMMY,

	//BONE_RIGHT_EYELID_TOP,
	//BONE_RIGHT_EYELID_BOTTOM,
	//BONE_RIGHT_EYE,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,

	255
};

const u8 CBotGlitch::m_aBoneEnableIndices_UpperBody[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,
	BONE_MINER_DUMMY,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_Cable[] = {
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,

	BONE_SECONDARY_FIRE,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_AimMortar[] = {
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,

	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_AimRocket1[] = {
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,

	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_AimRocket23[] = {
	BONE_ATTACHPOINT_PRIMARY,

	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_AimSummer[] = {
	BONE_HEAD,
	BONE_TORSO,

	255
};

const u8 CBotGlitch::m_aBoneEnableIndices_TapFire1[] = {
//	BONE_TORSO,
//	BONE_WAIST,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_JumpLand_Lower[] = {
	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_JumpLand_Upper[] = {
	BONE_GROIN,
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,
	BONE_MINER_DUMMY,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_FireMortar[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,
	BONE_MINER_DUMMY,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_FireRocket1[] = {
	BONE_TORSO,
	BONE_WAIST,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,
	BONE_MINER_DUMMY,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_FireRocket23[] = {
	BONE_TORSO,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,


	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_TapFire1_Lower[] = {
	BONE_GROIN,
	BONE_WAIST,
	//BONE_TORSO,
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,
};


const u8 CBotGlitch::m_aBoneEnableIndices_TapFire2_Lower[] = {
	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,

	BONE_GROIN,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadSingle_Arm[] = {
	BONE_ATTACHPOINT_PRIMARY,

	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadSingle_Body[] = {
	BONE_TORSO,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_TapFire2_Upper[] = {
	BONE_TORSO,
	BONE_WAIST,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_RIGHT_SHOULDER,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_Scope[] = {
//	BONE_RIGHT_SHOULDER,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,

	BONE_SECONDARY_FIRE,


#if 0
	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	BONE_TORSO,
	BONE_HEAD,
	BONE_BACKPACK,
	BONE_BACKPACK_DOOR,
	BONE_BEDROLL,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,
#endif

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadRocket1[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadTether[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadMortar[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_ReloadClip[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_WeaponSwitch[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_UpperBody[] = {
	BONE_WAIST,
	BONE_TORSO,

	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,
	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	BONE_ATTACHPOINT_PRIMARY,
	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,
	BONE_NECK,
	BONE_HEAD,
	BONE_JAW,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_LowerBody[] = {
	BONE_GROIN,

	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_UpperTorso[] = {
	BONE_BACKPACK,
	BONE_ANTENNA1,
	BONE_ANTENNA2,
	BONE_ANTENNA3,
	BONE_ANTENNA4,
	BONE_ANTENNA5,

	BONE_BACKPACK_DOOR,

	BONE_BELTPACK_1,
	BONE_BELTPACK_2,
	BONE_BELTPACK_3,
	BONE_BELTPACK_4,
	BONE_BELTPACK_5,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_LowerTorso[] = {
	BONE_RIGHT_LEG_UPPER,
	BONE_RIGHT_LEG_JOINT_DUMMY,
	BONE_RIGHT_KNEE,
	BONE_RIGHT_LEG_LOWER,
	BONE_RIGHT_FOOT_FRONT,
	BONE_RIGHT_TOE,
	BONE_RIGHT_FOOT_BACK,
	BONE_RIGHT_HEEL,

	BONE_LEFT_LEG_UPPER,
	BONE_LEFT_LEG_JOINT_DUMMY,
	BONE_LEFT_KNEE,
	BONE_LEFT_LEG_LOWER,
	BONE_LEFT_FOOT_FRONT,
	BONE_LEFT_TOE,
	BONE_LEFT_FOOT_BACK,
	BONE_LEFT_HEEL,

	BONE_GROIN,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_LeftArm[] = {
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ELBOW,
	BONE_LEFT_ARM_LOWER,
	BONE_LEFT_HAND,

	BONE_LEFT_THUMB_A,
	BONE_LEFT_THUMB_B,
	BONE_LEFT_INDEX_FINGER_A,
	BONE_LEFT_INDEX_FINGER_B,
	BONE_LEFT_MIDDLE_FINGER_A,
	BONE_LEFT_MIDDLE_FINGER_B,
	BONE_SECONDARY_FIRE,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_RightArm[] = {
	BONE_ATTACHPOINT_PRIMARY,

	BONE_RIGHT_SHOULDER,
	BONE_RIGHT_ARM_LOWER,
	BONE_RIGHT_ARM_ELBOW,
	BONE_RIGHT_SHOULDERPAD,

	255
};


const u8 CBotGlitch::m_aBoneEnableIndices_UserAnim_Head[] = {
	BONE_HEAD,

	BONE_LEFT_EYELID_TOP,
	BONE_LEFT_EYELID_BOTTOM,
	BONE_LEFT_EYE,

	BONE_RIGHT_EYELID_TOP,
	BONE_RIGHT_EYELID_BOTTOM,
	BONE_RIGHT_EYE,

	255
};

const u8 CBotGlitch::m_aBoneEnableIndices_RecoilSummer[] = {
	BONE_RIGHT_SHOULDER,
	BONE_TORSO,
	BONE_LEFT_ARM_UPPER,
	BONE_LEFT_ARM_LOWER,
	BONE_MINER_DUMMY,

	255
};

cchar *CBotGlitch::m_apszRecoilBoneNameTable[ANIMBONE_RECOIL_COUNT] = {
	"R_Shoulder",
	"Torso",
	"L_Arm_Upper",
	"L_Arm_Lower",
	"MinerDummy"
};

const u8 *CBotGlitch::m_apnEnableBoneNameIndexTableForEachBaseTap[ANIMTAP_BASE_COUNT] = {
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_STAND,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_SNEAK,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_WALK,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_RUN,

	//m_aBoneEnableIndices_FullBody,			// ANIMTAP_RECOIL_SUMMER,
	m_aBoneEnableIndices_RecoilSummer,		// ANIMTAP_RECOIL_SUMMER,

	m_aBoneEnableIndices_AimSummer,			// ANIMTAP_AIM_SUMMER,
	
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_JUMP_LAUNCH,
	m_aBoneEnableIndices_JumpLand_Lower,	// ANIMTAP_JUMP_LAND_LOWER,
	m_aBoneEnableIndices_JumpLand_Upper,	// ANIMTAP_JUMP_LAND_UPPER,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_JUMP_FLY,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_JUMP_TUCK,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_JUMP_UNTUCK,
	m_aBoneEnableIndices_Cable,				// ANIMTAP_CABLE_REACH,
	m_aBoneEnableIndices_Cable,				// ANIMTAP_CABLE_GRASP,
	m_aBoneEnableIndices_Cable,				// ANIMTAP_CABLE_RELEASE,

	m_aBoneEnableIndices_TapFire1_Lower,	// ANIMTAP_FIRE_1_LOWER,
	m_aBoneEnableIndices_TapFire1,			// ANIMTAP_FIRE_1_UPPER,
	m_aBoneEnableIndices_TapFire2_Lower,	// ANIMTAP_FIRE_2_LOWER,
	m_aBoneEnableIndices_TapFire2_Upper,	// ANIMTAP_FIRE_2_UPPER,

	m_aBoneEnableIndices_AimRocket1,		// ANIMTAP_AIM_DUAL_WITH_TORSO_TWISTED
	m_aBoneEnableIndices_AimRocket23,		// ANIMTAP_AIM_SHOULDER_MOUNTED
	m_aBoneEnableIndices_AimMortar,			// ANIMTAP_AIM_MORTAR

	m_aBoneEnableIndices_ReloadRocket1,		// ANIMTAP_RELOAD_ROCKET1_GRAB_AMMO
	m_aBoneEnableIndices_ReloadRocket1,		// ANIMTAP_RELOAD_ROCKET1_DROP_IN
	m_aBoneEnableIndices_ReloadRocket1,		// ANIMTAP_RELOAD_ROCKET1_FINISH

	m_aBoneEnableIndices_ReloadTether,		// ANIMTAP_RELOAD_TETHER_PREPARE_TO_PUMP,
	m_aBoneEnableIndices_ReloadTether,		// ANIMTAP_RELOAD_TETHER_PUMP,
	m_aBoneEnableIndices_ReloadTether,		// ANIMTAP_RELOAD_TETHER_GRAB_AMMO,
	m_aBoneEnableIndices_ReloadTether,		// ANIMTAP_RELOAD_TETHER_DROP_IN,
	m_aBoneEnableIndices_ReloadTether,		// ANIMTAP_RELOAD_TETHER_FINISH,

	m_aBoneEnableIndices_ReloadMortar,		// ANIMTAP_RELOAD_MORTAR_GRAB_AMMO,
	m_aBoneEnableIndices_ReloadMortar,		// ANIMTAP_RELOAD_MORTAR_PLACE_IN_SLING,
	m_aBoneEnableIndices_ReloadMortar,		// ANIMTAP_RELOAD_MORTAR_TAKE_UP_SLACK,

	m_aBoneEnableIndices_ReloadSingle_Arm,	// ANIMTAP_RELOAD_SINGLE_ARM
	m_aBoneEnableIndices_ReloadSingle_Body,	// ANIMTAP_RELOAD_SINGLE_BODY

	m_aBoneEnableIndices_ReloadClip,		// ANIMTAP_RELOAD_CLIP_EJECT_OLD
	m_aBoneEnableIndices_ReloadClip,		// ANIMTAP_RELOAD_CLIP_GRAB_NEW
	m_aBoneEnableIndices_ReloadClip,		// ANIMTAP_RELOAD_CLIP_INSERT_NEW
	m_aBoneEnableIndices_ReloadClip,		// ANIMTAP_RELOAD_CLIP_SLAPIN_NEW

	m_aBoneEnableIndices_Scope,				// ANIMTAP_SCOPE_ATTACHING

	m_aBoneEnableIndices_WeaponSwitch,		// ANIMTAP_WEAPON_SWITCH_RELEASE_SINGLE,
	m_aBoneEnableIndices_WeaponSwitch,		// ANIMTAP_WEAPON_SWITCH_RELEASE_DUAL,
	m_aBoneEnableIndices_WeaponSwitch,		// ANIMTAP_WEAPON_SWITCH_RELEASE_SHOULDER_MOUNTED,
	m_aBoneEnableIndices_WeaponSwitch,		// ANIMTAP_WEAPON_SWITCH,

	m_aBoneEnableIndices_FullBody,			// ANIMTAP_LEECH
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_AIM_PILLBOX
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_DISASSEMBLE
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_ASSEMBLE
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_USE_CONSOLE

	m_aBoneEnableIndices_UpperBody,			// ANIMTAP_GSLAP_UPPER,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_GSLAP_LOWER,
	m_aBoneEnableIndices_UpperBody,			// ANIMTAP_SHOVE_UPPER,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_SHOVE_LOWER,

	m_aBoneEnableIndices_FullBody,			// ANIMTAP_RESPAWN,

	m_aBoneEnableIndices_FullBody,			// ANIMTAP_GETUP,
	m_aBoneEnableIndices_FullBody,			// ANIMTAP_RC_TETHER,

};


const u8 CBotGlitch::m_anEnableBoneNameIndexTableForSummer[] = {
	// Enable these bones to be driven by our summer:
	BONE_HEAD,
	BONE_TORSO,

	255
};


const u8 CBotGlitch::m_anTagPointBoneNameIndexArray[] = {
	BONE_HEAD,
	BONE_TORSO,
	BONE_LEFT_ARM_UPPER,
	BONE_RIGHT_SHOULDER,

	255
};


const u8 CBotGlitch::m_nApproxEyePointBoneNameIndex = BONE_HEAD;


BOOL CBotGlitch::_BuildAnimStackDef( void ) {
	CBotAnimStackDef::Init_t AnimStackDefInit;

	AnimStackDefInit.nUserCount = CBotAnimStackDef::ANIM_USER_COUNT;
	AnimStackDefInit.nBaseAnimNameCount = ANIM_BASE_COUNT;
	AnimStackDefInit.apszBaseAnimNameTable = m_apszBaseAnimNameTable;
	AnimStackDefInit.nIdleCount = m_nBotInfo_Idles;
	AnimStackDefInit.apszIdleAnimNameTable = m_apszIdleAnimNameTable;
	AnimStackDefInit.nBaseControlCount = ANIMCONTROL_BASE_COUNT;
	AnimStackDefInit.apszBaseControlNameTable = m_apszBaseControlNameTable;
	AnimStackDefInit.nBaseTapCount = ANIMTAP_BASE_COUNT;
	AnimStackDefInit.apszBaseTapNameTable = m_apszBaseTapNameTable;
	AnimStackDefInit.nBoneCount = BONE_COUNT;
	AnimStackDefInit.apszBoneNameTable = m_apszBoneNameTable;
	AnimStackDefInit.ppnEnableBoneNameIndexTableForEachBaseTap = m_apnEnableBoneNameIndexTableForEachBaseTap;
	AnimStackDefInit.ppnEnableBoneNameIndexTableForEachIdleTap = m_apnEnableBoneNameIndexTableForEachIdleTap;
	AnimStackDefInit.pnEnableBoneNameIndexTableForSummer = m_anEnableBoneNameIndexTableForSummer;
	AnimStackDefInit.pBaseAnimConfigNet = NULL;
	AnimStackDefInit.pBaseAnimConfigStack = m_aAnimCombinerConfigStack;
	AnimStackDefInit.pBaseAnimConfigTap = m_aAnimCombinerConfigTaps;
	AnimStackDefInit.pBaseAnimAttachList = m_aAnimAttach;
	AnimStackDefInit.nIdleStackConnectionControlIndex = ANIMCONTROL_STAND;
	AnimStackDefInit.nIdleStackConnectionControlInput = 0;

	return m_AnimStackDef.Create( &AnimStackDefInit );
}


// damage particle effects
cchar* CBotGlitch::m_apszDamageParticles[] = {
	"LimbSmoke1",		// 0
	"spark_burst",		// 1
	"OilSpurt2",		// 2
};


const u32 CBotGlitch::m_auDamageParticleTable[] = {
	BONE_GROIN, 			0,
	BONE_WAIST, 			0,
	BONE_TORSO, 			0,
	BONE_RIGHT_SHOULDER,	0,
	BONE_LEFT_ARM_UPPER,	0,
	BONE_GROIN,				1,
};


const CBotGlitch::LimbType_e CBotGlitch::m_aDamageLimbs[] = {
	LIMB_TYPE_SHOULDERPAD,
	LIMB_TYPE_ARMBAR,
	LIMB_TYPE_PICKAXE,
	LIMB_TYPE_FINGER,
	LIMB_TYPE_BELTPACK1,
	LIMB_TYPE_BELTPACK4,
	LIMB_TYPE_BELTPACK5,
	LIMB_TYPE_ANTENNA,
};
















