//////////////////////////////////////////////////////////////////////////////////////
// zombiebossGame.h
//
// Author: Scholz
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2003
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 03/24/03 Scholz		Created.
//////////////////////////////////////////////////////////////////////////////////////

#ifndef _ZOMBIEBOSSGAME_H_
#define _ZOMBIEBOSSGAME_H_ 1

#include "fang.h"
#include "fmath.h"
#include "level.h"
#include "botZombieBoss.h"

class CBot;
class CBotGrunt;
class CMeshEntity;
class CFWorldMesh;
class CEBoomer;
class CBotMozer;

FCLASS_ALIGN_PREFIX class CZombieBossGame 
{
//----------------------------------------------------------------------------------------------------------------------------------
// Public Definitions:
//----------------------------------------------------------------------------------------------------------------------------------
public:
//----------------------------------------------------------------------------------------------------------------------------------
// Protected Definitions:
//----------------------------------------------------------------------------------------------------------------------------------
protected:
//----------------------------------------------------------------------------------------------------------------------------------
// Private Definitions:
//----------------------------------------------------------------------------------------------------------------------------------
private:
//----------------------------------------------------------------------------------------------------------------------------------
// Public Data:
//----------------------------------------------------------------------------------------------------------------------------------
public:
//----------------------------------------------------------------------------------------------------------------------------------
// Private Data:
//----------------------------------------------------------------------------------------------------------------------------------
private:
	static CZombieBossGame* m_pZombieBossGame;
	CBotZombieBoss* m_pBossBot;
	CEBoomer  * m_pMozerCage;
	CBotMozer * m_pMozer;
	u32 m_nState;
	f32 m_fTimer;	// the global timer

//----------------------------------------------------------------------------------------------------------------------------------
// Public Functions:
//----------------------------------------------------------------------------------------------------------------------------------
public:
	static BOOL LoadLevel( LevelEvent_e eEvent );
	static void UnloadLevel( void );
	static void Work( void );
	static void Draw( void );
	static void Restore( void );

	void EndGame(void);

	BOOL Create (void);
	void Destroy(void);

//----------------------------------------------------------------------------------------------------------------------------------
// Protected Functions:
//----------------------------------------------------------------------------------------------------------------------------------
protected:

//----------------------------------------------------------------------------------------------------------------------------------
// Private Functions:
//----------------------------------------------------------------------------------------------------------------------------------
private:
	void _Work(void);

	FCLASS_STACKMEM_ALIGN(CZombieBossGame);
} FCLASS_ALIGN_SUFFIX;

// =============================================================================================================

#endif
