//////////////////////////////////////////////////////////////////////////////////////
// fdx8tex.cpp - Fang texture module (DX8 version).
//
// Author: Steve Ranck     
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2000
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 09/26/00 Ranck       Created.
//////////////////////////////////////////////////////////////////////////////////////

#include "fang.h"

#include "fdx8tex.h"
#include "fdx8vid.h"

#include "fmath.h"
#include "fresload.h"
#include "fsh.h"
#include "floop.h"
#include "fvis.h"
#include "fclib.h"
#include "fdatastreaming.h"

#include <xgraphics.h>

#if FANG_PLATFORM_WIN
	#include <d3dx8tex.h>
#endif



//////////////////////////////////////////////////////////////////////////////////////
// Local Defines:
//////////////////////////////////////////////////////////////////////////////////////

#define FTEX_HANDLE_RENDERTARGETS	1
#define MAX_RENDERTARGETS			30


//////////////////////////////////////////////////////////////////////////////////////
// Global variables:
//////////////////////////////////////////////////////////////////////////////////////

char FTex_szNewReflectMap[16];
char FTex_szOldReflectMap[16];

u32 FTex_nMaxTextureWidth;		// Maximum texture width allowed (for largest LOD)
u32 FTex_nMaxTextureHeight;		// Maximum texture height allowed (for largest LOD)
u32 FTex_nMaxAspect;			// Maximum allowed aspect ratio (width/height or height/width)

BOOL FTex_bMipmaps;				// TRUE=mipmaps are supported
BOOL FTex_bRenderTargets;		// TRUE=render targets are supported
BOOL FTex_bDynamicTextures;		// TRUE=dynamic textures are supported
BOOL FTex_bDynamicsCanBeLost;	// TRUE=dynamic textures can be lost on this platform (FALSE on PS2 and XB)


//////////////////////////////////////////////////////////////////////////////////////
// Local Structures:
//////////////////////////////////////////////////////////////////////////////////////

CFTexInst CFTexInst::NullTexInst;

typedef struct
{
	CFTexInst *pTexInst;
	ftex_RenderTarget_Callback pCallback;
	f32 fOOMaxRenderFreq;

	BOOL8 bAutoClearRGBA;
	BOOL8 bAutoClearDepth;
	BOOL8 bActive;
	BOOL8 bAllowLiquidRender;
	BOOL8 bRenderWorld;
	u8 uStagger;
	u8 nFace;
	u8 nPad8;

	f32 fCurrentRenderTime;

	void *pUserData;
} FTEX_RENDERTARGET;

typedef struct 
{
	FTexFmt_e nTexFmt;		// Fang texel format

	u8 nBitsPerTexel;		// Number of bits per texel
	u8 nAlphaBits;			// Number of bits in the alpha channel (0 for DXT textures)
	u8 nRedBits;			// Number of bits in the red channel (0 for DXT textures)
	u8 nGreenBits;			// Number of bits in the green channel (0 for DXT textrures)
	u8 nBlueBits;			// Number of bits in the blue channel (0 for DXT textures)
	u8 nDXT;				// DXT type (0=not a DXT texture, otherwise 1=DXT1, 3=DXT3, and 5=DXT5)
	u8 nMinDim;				// Minimum texture dimension (width and height)

	D3DFORMAT nSrcD3DFormat;// The D3D format that directly describes this Fang texel type
	D3DFORMAT nD3DFormat;	// The D3D format used to represent this texel format

	const D3DFORMAT *pnD3DFormatTable;	// Pointer to table of desired D3DFORMAT's that match this texel format
} _TexelInfo_t;


typedef struct 
{
	D3DFORMAT ColorFmt;		// D3DFORMAT to use for the color/alpha buffer of the render target
	D3DFORMAT DepthFmt;		// D3DFORMAT to use for the depth/stencil buffer of the render target
} _RenderTargetFormat_t;


typedef struct 
{
	D3DFORMAT DepthFmt;		// The D3D depth/stencil format
	u8 nDepthBitCount;		// Number of depth bits
	u8 nStencilBitCount;	// Number of stencil bits
} _D3DDepthStencilInfo_t;


typedef struct 
{
	CFTexInst TexInst;
	u32 nTCIndex;
	BOOL bStateCached;
} _SetTexState_t;


//////////////////////////////////////////////////////////////////////////////////////
// Local Variables:
//////////////////////////////////////////////////////////////////////////////////////

static FTEX_RENDERTARGET _aRenderTargets[MAX_RENDERTARGETS];
static u32 _nNumRenderTargets;
static BOOL _bRenderWorld=TRUE;

static BOOL _bModuleInitialized;
static BOOL _bWindowCreated;

static FResLoadReg_t _ResLoadRegistration;

static FLinkRoot_t _RootList;

static DWORD _nD3DSysLockFlag;

static _SetTexState_t _aSetTexState[FDX8_MAX_TEX_STAGES];

static LPDIRECT3DSURFACE8 _pDepthBuffer=NULL;

static LPDIRECT3DSURFACE8 _pSurface=NULL, _pDepth=NULL;
static FViewport_t *_TexViewport=NULL;
static FViewport_t *_pActiveViewport=NULL;
static FTexDef_t *_RTpTexDef=NULL;

static u8 _nFace = 0;

static BOOL _bCubeFace=FALSE;
static u8 _nCubeView;

void _RenderTexture_ViewportCallback(FViewport_t *pView);

static u32 _nTotalTextureBytes;

static const D3DFORMAT _aD3DFormatTable_A8R8G8B8[] = {
	D3DFMT_A8R8G8B8,
	D3DFMT_A4R4G4B4,
	D3DFMT_A1R5G5B5,
	D3DFMT_X8R8G8B8,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_X8R8G8B8[] = {
	D3DFMT_X8R8G8B8,
	D3DFMT_A8R8G8B8,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_A4R4G4B4[] = {
	D3DFMT_A4R4G4B4,
	D3DFMT_A8R8G8B8,
	D3DFMT_A1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_X8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_A1R5G5B5[] = {
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,
	D3DFMT_A8R8G8B8,
	D3DFMT_X1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_X8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_X1R5G5B5[] = {
	D3DFMT_X1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,
	D3DFMT_X8R8G8B8,
	D3DFMT_A8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_R5G6B5[] = {
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,
	D3DFMT_X8R8G8B8,
	D3DFMT_A8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_DXT1[] = {
	D3DFMT_DXT1,
	D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,
	D3DFMT_A8R8G8B8,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_X8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_DXT3[] = {
	D3DFMT_DXT3,
	D3DFMT_A8R8G8B8,
	D3DFMT_A4R4G4B4,
	D3DFMT_A1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_X8R8G8B8,

	D3DFMT_UNKNOWN
};

static const D3DFORMAT _aD3DFormatTable_DXT5[] = {
	D3DFMT_DXT5,
	D3DFMT_A8R8G8B8,
	D3DFMT_A4R4G4B4,
	D3DFMT_A1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_X1R5G5B5,
	D3DFMT_X8R8G8B8,

	D3DFMT_UNKNOWN
};

static _TexelInfo_t _aTexelInfoTable[FTEX_FMT_COUNT] = {
	FTEX_FMT_A8R8G8B8,	32,	8,	8,	8,	8,	0,	1,	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,	_aD3DFormatTable_A8R8G8B8,
	FTEX_FMT_X8R8G8B8,	32,	0,	8,	8,	8,	0,	1,	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,	_aD3DFormatTable_X8R8G8B8,
	FTEX_FMT_A4R4G4B4,	16,	4,	4,	4,	4,	0,	1,	D3DFMT_A4R4G4B4,	D3DFMT_UNKNOWN,	_aD3DFormatTable_A4R4G4B4,
	FTEX_FMT_A1R5G5B5,	16,	1,	5,	5,	5,	0,	1,	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,	_aD3DFormatTable_A1R5G5B5,
	FTEX_FMT_X1R5G5B5,	16,	0,	5,	5,	5,	0,	1,	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,	_aD3DFormatTable_X1R5G5B5,
	FTEX_FMT_R5G6B5,	16,	0,	5,	6,	5,	0,	1,	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,	_aD3DFormatTable_R5G6B5,
	FTEX_FMT_DXT1,		4,	0,	0,	0,	0,	1,	4,	D3DFMT_DXT1,		D3DFMT_UNKNOWN,	_aD3DFormatTable_DXT1,
	FTEX_FMT_DXT3,		8,	0,	0,	0,	0,	3,	4,	D3DFMT_DXT3,		D3DFMT_UNKNOWN,	_aD3DFormatTable_DXT3,
	FTEX_FMT_DXT5,		8,	0,	0,	0,	0,	5,	4,	D3DFMT_DXT5,		D3DFMT_UNKNOWN,	_aD3DFormatTable_DXT5,
	FTEX_FMT_X8L8V8U8,	32,	0,	0,	0,	0,	0,	1,	D3DFMT_X8L8V8U8,	D3DFMT_UNKNOWN,	_aD3DFormatTable_DXT5,
};

static D3DTEXTUREADDRESS _aDXTexAddress[2] = { D3DTADDRESS_WRAP, D3DTADDRESS_CLAMP };
static D3DTEXTUREFILTERTYPE _aDXTexFilter[2] = { D3DTEXF_POINT, D3DTEXF_LINEAR };



static const _RenderTargetFormat_t _aRenderTargetTrial_C16[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C16_D16[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C16_D15_S1[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,

	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C16_D32[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C16_D24_S8[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,

	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C15_A1[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C15_A1_D16[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C15_A1_D15_S1[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,

	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,

	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C15_A1_D32[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C15_A1_D24_S8[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,

	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,

	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,

	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,

	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C24_A8[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C24_A8_D16[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,

	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C24_A8_D15_S1[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,

	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,

	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,

	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,
	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,

	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,

	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,

	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,

	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,

	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,

	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C24_A8_D32[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,

	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,

	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,

	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,
	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
#else
	// Xbox:
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,

	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};

static const _RenderTargetFormat_t _aRenderTargetTrial_C24_A8_D24_S8[] = {
#if FANG_PLATFORM_WIN
	// Win:
	D3DFMT_A8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_A1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_A8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_A8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_A1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_A8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_A8R8G8B8,	D3DFMT_D32,
	D3DFMT_A8R8G8B8,	D3DFMT_D16,
	D3DFMT_A1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_A1R5G5B5,	D3DFMT_D32,
	D3DFMT_A1R5G5B5,	D3DFMT_D16,

	D3DFMT_R8G8B8,		D3DFMT_D24S8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24S8,
	D3DFMT_R5G6B5,		D3DFMT_D24S8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24S8,
	D3DFMT_R8G8B8,		D3DFMT_D24X4S4,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X4S4,
	D3DFMT_R5G6B5,		D3DFMT_D24X4S4,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X4S4,
	D3DFMT_R8G8B8,		D3DFMT_D15S1,
	D3DFMT_X8R8G8B8,	D3DFMT_D15S1,
	D3DFMT_R5G6B5,		D3DFMT_D15S1,
	D3DFMT_X1R5G5B5,	D3DFMT_D15S1,

	D3DFMT_R8G8B8,		D3DFMT_D24X8,
	D3DFMT_X8R8G8B8,	D3DFMT_D24X8,
	D3DFMT_R8G8B8,		D3DFMT_D32,
	D3DFMT_X8R8G8B8,	D3DFMT_D32,
	D3DFMT_R5G6B5,		D3DFMT_D24X8,
	D3DFMT_X1R5G5B5,	D3DFMT_D24X8,
	D3DFMT_R5G6B5,		D3DFMT_D32,
	D3DFMT_X1R5G5B5,	D3DFMT_D32,
	D3DFMT_R8G8B8,		D3DFMT_D16,
	D3DFMT_X8R8G8B8,	D3DFMT_D16,
	D3DFMT_R5G6B5,		D3DFMT_D16,
	D3DFMT_X1R5G5B5,	D3DFMT_D16,

	D3DFMT_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_A1R5G5B5,	D3DFMT_UNKNOWN,
	D3DFMT_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_X1R5G5B5,	D3DFMT_UNKNOWN,
#else
	// Xbox:
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D32,
	D3DFMT_LIN_A8R8G8B8,	D3DFMT_LIN_D16,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D32,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_LIN_D16,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24S8,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24S8,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24S8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X4S4,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D15S1,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D15S1,

//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D24X8,
//	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D32,
//	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D32,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_LIN_D16,
	D3DFMT_LIN_R5G6B5,		D3DFMT_LIN_D16,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_LIN_D16,

	D3DFMT_LIN_A8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_A1R5G5B5,	D3DFMT_UNKNOWN,
//	D3DFMT_LIN_R8G8B8,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X8R8G8B8,	D3DFMT_UNKNOWN,
	D3DFMT_LIN_R5G6B5,		D3DFMT_UNKNOWN,
	D3DFMT_LIN_X1R5G5B5,	D3DFMT_UNKNOWN,
#endif

	D3DFMT_UNKNOWN,		D3DFMT_UNKNOWN,
};


static const _RenderTargetFormat_t *_apRenderTargetFormatTrial[FTEX_RENDERTARGET_FMT_COUNT] = {
	_aRenderTargetTrial_C16,			// FTEX_RENDERTARGET_FMT_C16
	_aRenderTargetTrial_C16_D16,		// FTEX_RENDERTARGET_FMT_C16_D16
	_aRenderTargetTrial_C16_D15_S1,		// FTEX_RENDERTARGET_FMT_C16_D15_S1
	_aRenderTargetTrial_C16_D32,		// FTEX_RENDERTARGET_FMT_C16_D32
	_aRenderTargetTrial_C16_D24_S8,		// FTEX_RENDERTARGET_FMT_C16_D24_S8

	_aRenderTargetTrial_C15_A1,			// FTEX_RENDERTARGET_FMT_C15_A1
	_aRenderTargetTrial_C15_A1_D16,		// FTEX_RENDERTARGET_FMT_C15_A1_D16
	_aRenderTargetTrial_C15_A1_D15_S1,	// FTEX_RENDERTARGET_FMT_C15_A1_D15_S1
	_aRenderTargetTrial_C15_A1_D32,		// FTEX_RENDERTARGET_FMT_C15_A1_D32
	_aRenderTargetTrial_C15_A1_D24_S8,	// FTEX_RENDERTARGET_FMT_C15_A1_D24_S8

	_aRenderTargetTrial_C24_A8,			// FTEX_RENDERTARGET_FMT_C24_A8
	_aRenderTargetTrial_C24_A8_D16,		// FTEX_RENDERTARGET_FMT_C24_A8_D16
	_aRenderTargetTrial_C24_A8_D15_S1,	// FTEX_RENDERTARGET_FMT_C24_A8_D15_S1
	_aRenderTargetTrial_C24_A8_D32,		// FTEX_RENDERTARGET_FMT_C24_A8_D32
	_aRenderTargetTrial_C24_A8_D24_S8,	// FTEX_RENDERTARGET_FMT_C24_A8_D24_S8
};


static const _D3DDepthStencilInfo_t _aD3DDepthStencilInfo[] = {
#if FANG_PLATFORM_WIN
    D3DFMT_D32,			32,		0,
    D3DFMT_D15S1,		15,		1,
#endif
    D3DFMT_D24S8,		24,		8,
    D3DFMT_D16,			16,		0,
#if FANG_PLATFORM_WIN
    D3DFMT_D24X8,		24,		0,
    D3DFMT_D24X4S4,		24,		4,
#endif

	D3DFMT_UNKNOWN,		0,		0,
};


static _RenderTargetFormat_t _aRenderTargetFormat[FTEX_RENDERTARGET_FMT_COUNT];


//////////////////////////////////////////////////////////////////////////////////////
// Static Functions:
//////////////////////////////////////////////////////////////////////////////////////

static void _DXSetTexture( u32 nStageNum, FTexDef_t *pTexDef, u32 nTCIndex );
static void* _ResLoadAlloc( u32 nTextureBytes );
static void _ResLoadFree( void *pMemory );
static BOOL _ResLoadCreate( FResHandle_t hRes, void *pLoadedBase, u32 nLoadedBytes, cchar *pszResName );
static void _ResLoadDestroy( void *pBase );
static void _ReleaseAllRenderTargets( void );
static void _RebuildAllRenderTargets( void );
static void _RestoreTextureStateForStage( u32 nStageNum );
static void _RestoreTextureState( void );
static BOOL _WindowCreatedCallback( FDX8VidEvent_e nEvent );
static BOOL _DetermineRenderTargets( void );
static void _ComputeDepthStencilBitCount( D3DFORMAT nD3DFormat, u8 *pnDepthBitCount, u8 *pnStencilBitCount );
static BOOL _DetermineSupportedTexelFormats( void );
static void _ClearData( void );
static BOOL _IsD3DFormatDXT( D3DFORMAT nD3DFormat );
static u32 _ComputeMipmapLevelCount( BOOL bDXT, u32 nTexelsAcross, u32 nTexelsDown );
static u32 _ComputeTextureBytes( FTexDef_t *pTexDef );
static BOOL _CopyTextureImageToD3D( FTexData_t *pTexData, const void *pSrcImage );
static BOOL _CreateD3DTextureAndCopyImage( FTexData_t *pTexData, const void *pSrcImage );

static BOOL FTex_WorldCallbackFunc( FWorldEvent_e nEvent );

#if FANG_PLATFORM_WIN
	static BOOL _CopyMipmapToImage( IDirect3DTexture8 *pD3DTexture, void *pDstImage, FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight );
	static BOOL _CopyTextureToImage( IDirect3DTexture8 *pD3DTexture, void *pDstImage, FTexFmt_e nTexFmt, u32 nLod, u32 nWidth, u32 nHeight );
	static void _CopyPitchedToImage16( const u16 *pnSrc, u16 *pnDst, u32 nPitch16, u32 nShortsAcross, u32 nTexelsDown );
	static void _CopyPitchedToImage32( const u32 *pnSrc, u32 *pnDst, u32 nPitch32, u32 nWordsAcross, u32 nTexelsDown );
#endif

static BOOL _CopyImageToMipmap( FTexData_t *pTexData, const void *pSrcImage, FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight );
static BOOL _CopyImageToTexture( FTexData_t *pTexData, const void *pSrcImage, FTexFmt_e nTexFmt, u32 nLod, u32 nWidth, u32 nHeight );
static void _CopyImageToPitched16( const u16 *pnSrc, u16 *pnDst, u32 nPitch16, u32 nShortsAcross, u32 nTexelsDown );
static void _CopyImageToPitched32( const u32 *pnSrc, u32 *pnDst, u32 nPitch32, u32 nWordsAcross, u32 nTexelsDown );

static void _ResizeDimensionsIfRequired( FTexFmt_e nTexFmt, u16 *pnWidth, u16 *pnHeight );
static FTexFmt_e _ConvertD3DFormatToTexFmt( D3DFORMAT nD3DFormat );

#if FANG_PLATFORM_WIN
	static BOOL _ConvertAndCopyTextureImageToD3D( IDirect3DTexture8 *pD3DTexture, FTexFmt_e nSrcTexFmt, u32 nDstLodCount, u32 nSrcWidth, u32 nSrcHeight, const void *pSrcImage );
	static u32 _ComputeMipmapBytes( FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight );
#endif



//////////////////////////////////////////////////////////////////////////////////////
// Implementation:
//////////////////////////////////////////////////////////////////////////////////////

//
//
//
BOOL ftex_ModuleStartup( void ) 
{
	u32 i;

	FASSERT( !_bModuleInitialized );

	_bWindowCreated = FALSE;

	_ClearData();

	fdx8vid_RegisterWindowCallbackFunction( _WindowCreatedCallback );

	#if FANG_PLATFORM_WIN
		_nD3DSysLockFlag = Fang_ConfigDefs.bTex_D3DNoSysLock ? D3DLOCK_NOSYSLOCK : 0;
	#else
		_nD3DSysLockFlag = 0;
	#endif

	flinklist_InitRoot( &_RootList, (s32)FANG_OFFSETOF( FTexData_t, Link ) );

	fres_CopyType( _ResLoadRegistration.sResType, FTEX_RESNAME );
	_ResLoadRegistration.pszFileExtension = "tga";
	_ResLoadRegistration.nAlignment = 16;
	_ResLoadRegistration.pFcnCreate = _ResLoadCreate;
	_ResLoadRegistration.pFcnDestroy = _ResLoadDestroy;
#if FANG_PLATFORM_XB
	_ResLoadRegistration.nMemType = FRESLOAD_MEMTYPE_CUST;
	_ResLoadRegistration.pFcnAlloc = _ResLoadAlloc;
#else
	_ResLoadRegistration.nMemType = FRESLOAD_MEMTYPE_TEMP;
	_ResLoadRegistration.pFcnAlloc = NULL;
#endif

	if ( !fresload_RegisterHandler( &_ResLoadRegistration ) ) 
	{
		// Registration failed...
		DEVPRINTF( "ftex_ModuleStartup(): Could not register resource.\n" );
		return FALSE;
	}

	for ( i=0; i<FTEX_RENDERTARGET_FMT_COUNT; i++ ) 
	{
		_aRenderTargetFormat[i].ColorFmt = D3DFMT_UNKNOWN;
		_aRenderTargetFormat[i].DepthFmt = D3DFMT_UNKNOWN;
	}

	FTex_szNewReflectMap[0] = 0;
	FTex_szOldReflectMap[0] = 0;

	_nNumRenderTargets = 0;

	_nTotalTextureBytes = 0;
	_bModuleInitialized = TRUE;

	return TRUE;
}


//
//
//
void ftex_ModuleShutdown( void ) 
{
	FASSERT( _bModuleInitialized );

	fdx8vid_UnregisterWindowCallbackFunction( _WindowCreatedCallback );

	_ClearData();

	_bModuleInitialized = FALSE;
}


//
//
//
u32 ftex_ComputeMipmapLevelCount( FTexFmt_e nTexelFormat, u32 nTexelsAcross, u32 nTexelsDown ) 
{
	FASSERT( _bWindowCreated );
	FASSERT( nTexelFormat>=0 && nTexelFormat<FTEX_FMT_COUNT );

	#if FANG_PLATFORM_XB
		FASSERT( nTexelsAcross <= FTex_nMaxTextureWidth );
		FASSERT( nTexelsDown <= FTex_nMaxTextureHeight );
		FASSERT( ((u32)nTexelsAcross/(u32)nTexelsDown <= FTex_nMaxAspect) && ((u32)nTexelsDown/(u32)nTexelsAcross) <= FTex_nMaxAspect );
	#endif

	return _ComputeMipmapLevelCount( _aTexelInfoTable[nTexelFormat].nDXT, nTexelsAcross, nTexelsDown );
}


//
//
//
BOOL ftex_IsPointerValid( const FTexDef_t *pTexDef, BOOL bNullPointerIsValid ) 
{
	FASSERT( _bModuleInitialized );

	if( pTexDef == NULL ) 
	{
		return bNullPointerIsValid;
	}

	return (fres_FindHandle( pTexDef->pTexData ) != FRES_NULLHANDLE);
}


//
//
//
FTexDef_t *ftex_Find( cchar *pszName ) 
{
	FTexData_t *pTexData;

	FASSERT( _bModuleInitialized );

	pTexData = (FTexData_t *)fres_FindBase( FTEX_RESNAME, pszName );

	if( pTexData ) 
	{
		return &pTexData->TexDef;
	}

	return NULL;
}


//
//
//
FTexDef_t *ftex_CreateTexture( const FTexInfo_t *pTexInfo, const void *pSrcImage, const FTexPalette_t *pPalette, FResHandle_t hRes, FResHandle_t *phRes ) 
{
	FTexData_t *pTexData;
	FTexDef_t *pTexDef;
	FResFrame_t ResFrame;

	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
	FASSERT( pTexInfo );
	FASSERT( pPalette == NULL );
	FASSERT( fclib_IsStringNullTerminated( pTexInfo->szName, FDATA_TEXNAME_LEN ) );
	FASSERT( pTexInfo->nTexFmt>=0 && pTexInfo->nTexFmt<FTEX_FMT_COUNT );
	FASSERT( pTexInfo->nPalFmt>=0 && pTexInfo->nPalFmt<FTEX_PALFMT_COUNT );
	FASSERT( !(pTexInfo->nFlags & FTEX_FLAG_RENDERTARGET) );
	FASSERT( pTexInfo->nLodCount > 0 );
	FASSERT( !(pTexInfo->nFlags & FTEX_FLAG_DYNAMIC) || FTex_bDynamicTextures );
	FASSERT( fmath_IsPowerOf2( pTexInfo->nTexelsAcross, FALSE ) );
	FASSERT( fmath_IsPowerOf2( pTexInfo->nTexelsDown, FALSE ) );
	FASSERT( pTexInfo->nTexelsAcross >= _aTexelInfoTable[pTexInfo->nTexFmt].nMinDim );
	FASSERT( pTexInfo->nTexelsDown >= _aTexelInfoTable[pTexInfo->nTexFmt].nMinDim );

	#if FANG_PLATFORM_XB
		FASSERT( pTexInfo->nTexelsAcross <= FTex_nMaxTextureWidth );
		FASSERT( pTexInfo->nTexelsDown <= FTex_nMaxTextureHeight );
		FASSERT( ((u32)pTexInfo->nTexelsAcross/(u32)pTexInfo->nTexelsDown <= FTex_nMaxAspect) && ((u32)pTexInfo->nTexelsDown/(u32)pTexInfo->nTexelsAcross) <= FTex_nMaxAspect );
	#endif

	ResFrame = fres_GetFrame();

	// Build or retrieve our resource...
	if( hRes == FRES_NULLHANDLE ) 
	{
		// Resource handle not provided...

		pTexData = (FTexData_t *)fres_CreateAndAlloc( FTEX_RESNAME, pTexInfo->szName, _ResLoadDestroy, sizeof(FTexData_t), &hRes );
		if( pTexData == NULL ) 
		{
			// Could not create resource...
			goto _CreateTextureFailure;
		}
	} 
	else 
	{
		// Resource handle provided...

		pTexData = (FTexData_t *)fres_Alloc( sizeof(FTexData_t) );
		if( pTexData == NULL ) 
		{
			goto _CreateTextureFailure;
		}
	}

	pTexDef = &pTexData->TexDef;
	pTexDef->TexInfo = *pTexInfo;
	pTexDef->pTexData = pTexData;
	pTexDef->pTexData->pImageData = NULL;
	if ( pTexInfo->nFlags & FTEX_FLAG_LOAD_IN_PLACE )
	{
		pTexDef->pTexData->pImageData = (void *)pTexInfo;
	}

	pTexDef->TexInfo.nRenderTargetDepthBitCount = 0;
	pTexDef->TexInfo.nRenderTargetStencilBitCount = 0;

	pTexData->nD3DWidth = pTexDef->TexInfo.nTexelsAcross;
	pTexData->nD3DHeight = pTexDef->TexInfo.nTexelsDown;
	pTexData->nD3DFormatColor = _aTexelInfoTable[pTexDef->TexInfo.nTexFmt].nD3DFormat;
	pTexData->nD3DFormatDepth = D3DFMT_UNKNOWN;
	pTexData->pD3DDepthStencil = NULL;
	pTexData->nFlags = 0;

	if( (pTexData->nD3DFormatColor == D3DFMT_DXT1)
		 || (pTexData->nD3DFormatColor == D3DFMT_DXT2)
		 || (pTexData->nD3DFormatColor == D3DFMT_DXT3)
		 || (pTexData->nD3DFormatColor == D3DFMT_DXT4)
		 || (pTexData->nD3DFormatColor == D3DFMT_DXT5) ) 
	{
		// DXT texture...
		pTexData->nFlags |= FDX8TEXFLAGS_DXT;
	}

	#if FANG_PLATFORM_WIN
		_ResizeDimensionsIfRequired(
			(FTexFmt_e)pTexDef->TexInfo.nTexFmt,
			&pTexData->nD3DWidth,
			&pTexData->nD3DHeight
		);
	#endif

	pTexData->nD3DLodCount = (u8)_ComputeMipmapLevelCount( !!(pTexData->nFlags & FDX8TEXFLAGS_DXT), pTexData->nD3DWidth, pTexData->nD3DHeight );
	pTexData->nD3DLodCount = FMATH_MIN( pTexData->nD3DLodCount, pTexDef->TexInfo.nLodCount );

#if FANG_PLATFORM_XB
	if ( pTexInfo->nFlags & FTEX_FLAG_LOAD_IN_PLACE )
	{
		// Image data is already prepared to be registered as a texture (pre-swizzled or compressed)
		// Allocate a D3D Texture resource
		pTexData->pD3DTexture = (IDirect3DTexture8 *)fres_Alloc( sizeof( IDirect3DTexture8 ) );
		memset( pTexData->pD3DTexture, 0, sizeof( IDirect3DTexture8 ) );

		// Setup the texture header and register the data.
		XGSetTextureHeader( pTexData->nD3DWidth, pTexData->nD3DHeight, pTexDef->TexInfo.nLodCount, NULL, 
								(D3DFORMAT)pTexData->nD3DFormatColor, NULL, pTexData->pD3DTexture, NULL, 0 );

		if ( FResLoad_bLoadedForStreaming )
		{
			char szTextureName[16];
			fclib_strcpy( szTextureName, pTexDef->TexInfo.szName );
			fclib_strcat( szTextureName, ".tga" );
			pTexData->pStreamingHandle = FDS_StreamMgr.StreamFromMasterfile( szTextureName, 0/*FMATH_BYTE_ALIGN_UP( sizeof(FTexInfo_t), 128 )*/ );
			pTexData->TexDef.TexInfo.nFlags |= FTEX_FLAG_STREAMING;
			pTexData->nFlags |= FDX8TEXFLAGS_NOT_IN_CACHE;
		}
		else
		{
			pTexData->pD3DTexture->Register( (void *)pSrcImage );
		}
	}
	else if( !_CreateD3DTextureAndCopyImage( pTexData, pSrcImage ) ) 
	{
		// Failed...

		if( pTexData->nD3DLodCount == 1 ) 
		{
			// Failed to create texture...
			goto _CreateTextureFailure;
		}

		// Failed to create mipmap.
		// Try creating texture instead...

		pTexData->nD3DLodCount = 1;
		pTexDef->TexInfo.nLodCount = 1;

		if( !_CreateD3DTextureAndCopyImage( pTexData, pSrcImage ) ) 
		{
			// Failed to create texture...
			goto _CreateTextureFailure;
		}
	}

#else
	if( !_CreateD3DTextureAndCopyImage( pTexData, pSrcImage ) ) 
	{
		// Failed...

		if( pTexData->nD3DLodCount == 1 ) 
		{
			// Failed to create texture...
			goto _CreateTextureFailure;
		}

		// Failed to create mipmap.
		// Try creating texture instead...

		pTexData->nD3DLodCount = 1;
		pTexDef->TexInfo.nLodCount = 1;

		if( !_CreateD3DTextureAndCopyImage( pTexData, pSrcImage ) ) 
		{
			// Failed to create texture...
			goto _CreateTextureFailure;
		}
	}
#endif

#if FHEAP_TRACK_MEM_ALLOCATIONS
	u32 i, nAlloc = 0;
	for ( i = 0; i < pTexData->nD3DLodCount; i++ )
	{
		D3DSURFACE_DESC Desc;
		pTexData->pD3DTexture->GetLevelDesc( i, &Desc );
		nAlloc += Desc.Size;
	}

	if ( Fheap_nTexPoolCount < FHEAP_TEX_MEM_TRACKERS_POOL_SIZE )
	{
		TexMemTracker_t *pTexTracker = &Fheap_nTexTrackerPool[Fheap_nTexPoolCount++];
		pTexTracker->pTexInfo = &pTexData->TexDef.TexInfo;
		pTexTracker->nXBMemAllocated = nAlloc + sizeof(IDirect3DTexture8) + FMATH_BYTE_ALIGN_UP( sizeof(FTexInfo_t), 128 ); // Add in amount for the file and D3d headers
		pTexTracker->nPCMemAllocated = nAlloc;
		Fheap_nTotalXBTexMemTracked += nAlloc;
		Fheap_nTotalPCTexMemTracked += nAlloc;
		if ( pTexData->TexDef.TexInfo.nTexelsAcross > 128 || pTexData->TexDef.TexInfo.nTexelsDown > 128 )
		{
			pTexTracker->nGCMemAllocated = (nAlloc / 4);
			Fheap_nTotalGCTexMemTracked += (nAlloc / 4);
		}
		else
		{
			pTexTracker->nGCMemAllocated = nAlloc;
			Fheap_nTotalGCTexMemTracked += nAlloc;
		}

#if FHEAP_DETAILED_TRACKING
		pTexTracker->pszRequestingModuleName = Fheap_pszSecondaryFileName;
		switch ( pTexData->TexDef.TexInfo.nTexFmt )
		{
			case FTEX_FMT_A8R8G8B8:
				pTexTracker->pszFormatName = "FTEX_FMT_A8R8G8B8";
				break;
				
			case FTEX_FMT_X8R8G8B8:
				pTexTracker->pszFormatName = "FTEX_FMT_X8R8G8B8";
				break;
				
			case FTEX_FMT_A4R4G4B4:
				pTexTracker->pszFormatName = "FTEX_FMT_A4R4G4B4";
				break;
				
			case FTEX_FMT_A1R5G5B5:
				pTexTracker->pszFormatName = "FTEX_FMT_A1R5G5B5";
				break;
				
			case FTEX_FMT_X1R5G5B5:
				pTexTracker->pszFormatName = "FTEX_FMT_X1R5G5B5";
				break;
				
			case FTEX_FMT_R5G6B5:
				pTexTracker->pszFormatName = "FTEX_FMT_R5G6B5";
				break;
				
			case FTEX_FMT_DXT1:
				pTexTracker->pszFormatName = "FTEX_FMT_DXT1";
				break;
				
			case FTEX_FMT_DXT3:
				pTexTracker->pszFormatName = "FTEX_FMT_DXT3";
				break;
				
			case FTEX_FMT_DXT5:
				pTexTracker->pszFormatName = "FTEX_FMT_DXT5";
				break;
			case FTEX_FMT_X8L8V8U8:
				pTexTracker->pszFormatName = "FTEX_FMT_X8L8V8U8";
				break;
			default:
				pTexTracker->pszFormatName = "UNKNOWN";
				break;
		}
#endif // FHEAP_DETAILED_TRACKING
	}
#endif // FHEAP_TRACK_MEM_ALLOCATIONS

	// Success!

	pTexDef->TexInfo.nLodCount = pTexData->nD3DLodCount;
	pTexDef->TexInfo.nTexelsAcross = pTexData->nD3DWidth;
	pTexDef->TexInfo.nTexelsDown = pTexData->nD3DHeight;
	pTexDef->TexInfo.nTexFmt = (u8)_ConvertD3DFormatToTexFmt( pTexData->nD3DFormatColor );
	pTexData->nAttachedStages = 0;
	pTexData->nTextureBytes = _ComputeTextureBytes( pTexDef );
	#if FPERF_ENABLE
		pTexData->nPerfKey = 0;
	#endif

	flinklist_AddTail( &_RootList, pTexData );

	if( phRes ) 
	{
		*phRes = hRes;
	}

	_nTotalTextureBytes += pTexData->nTextureBytes;

	return pTexDef;

_CreateTextureFailure:
	// Failure...
	fres_ReleaseFrame( ResFrame );

	if( phRes ) {
		*phRes = FRES_NULLHANDLE;
	}

	return NULL;
}

#if FANG_PLATFORM_WIN
//
//
//
u32 ftex_ComputeConversion( FTexFmt_e nSrcTexFmt, u32 nSrcLodCount, u32 nSrcWidth, u32 nSrcHeight, FTexFmt_e *pnDstTexFmt, 
						   u32 *pnDstLodCount, u32 *pnDstWidth, u32 *pnDstHeight ) 
{
	u32 nDstLodCount;
	u16 nDstWidth, nDstHeight;
	D3DFORMAT nDstD3DFormat;
	FTexFmt_e nDstTexFmt;
	BOOL bDstDXT;

	FASSERT( _bWindowCreated );
	FASSERT( nSrcTexFmt>=0 && nSrcTexFmt<FTEX_FMT_COUNT );
	FASSERT( nSrcLodCount > 0 );
	FASSERT( fmath_IsPowerOf2( nSrcWidth, FALSE ) );
	FASSERT( fmath_IsPowerOf2( nSrcHeight, FALSE ) );

	nDstWidth = (u16)nSrcWidth;
	nDstHeight = (u16)nSrcHeight;

	nDstD3DFormat = _aTexelInfoTable[nSrcTexFmt].nD3DFormat;
	bDstDXT = _IsD3DFormatDXT( nDstD3DFormat );

	_ResizeDimensionsIfRequired( nSrcTexFmt, &nDstWidth, &nDstHeight );
	nDstLodCount = _ComputeMipmapLevelCount( bDstDXT, nDstWidth, nDstHeight );
	nDstLodCount = FMATH_MIN( nDstLodCount, nSrcLodCount );
	nDstTexFmt = _ConvertD3DFormatToTexFmt( nDstD3DFormat );

	if( pnDstTexFmt ) 
	{
		*pnDstTexFmt = nDstTexFmt;
	}
	if( pnDstLodCount ) 
	{
		*pnDstLodCount = nDstLodCount;
	}
	if( pnDstWidth ) 
	{
		*pnDstWidth = nDstWidth;
	}
	if( pnDstHeight ) 
	{
		*pnDstHeight = nDstHeight;
	}

	return _ComputeMipmapBytes( nDstTexFmt, nDstLodCount, nDstWidth, nDstHeight );
}


//
//
//
BOOL ftex_Convert( FTexFmt_e nSrcTexFmt, u32 nSrcLodCount, u32 nSrcWidth, u32 nSrcHeight, const void *pSrcImage,
				   FTexFmt_e nDstTexFmt, u32 nDstLodCount, u32 nDstWidth, u32 nDstHeight, void *pDstImage ) 
{
	IDirect3DTexture8 *pD3DTexture;
	u32 i, nWidth, nHeight, nBytes;
	const u8 *pnImage;

	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
	FASSERT( nSrcTexFmt>=0 && nSrcTexFmt<FTEX_FMT_COUNT );
	FASSERT( nSrcLodCount > 0 );
	FASSERT( fmath_IsPowerOf2( nSrcWidth, FALSE ) );
	FASSERT( fmath_IsPowerOf2( nSrcHeight, FALSE ) );
	FASSERT( pSrcImage );
	FASSERT( nDstTexFmt>=0 && nDstTexFmt<FTEX_FMT_COUNT );
	FASSERT( nDstLodCount > 0 );
	FASSERT( fmath_IsPowerOf2( nDstWidth, FALSE ) );
	FASSERT( fmath_IsPowerOf2( nDstHeight, FALSE ) );
	FASSERT( pDstImage );
	FASSERT( nDstLodCount <= nSrcLodCount );

	if( nSrcTexFmt == nDstTexFmt ) 
	{
		// Source and destination texel formats are the same...

		nWidth = nSrcWidth;
		nHeight = nSrcHeight;

		pnImage = (const u8 *)pSrcImage;

		for( i=0; i<nSrcLodCount; i++ ) 
		{
			if( nWidth==nDstWidth && nHeight==nDstHeight ) 
			{
				// Woohoo! We can do a fast conversion by just copying the data...

				nBytes = _ComputeMipmapBytes( nDstTexFmt, nDstLodCount, nDstWidth, nDstHeight );
				fang_MemCopy( pDstImage, pnImage, nBytes );
				return TRUE;
			}

			// Point to start of next source mipmap image...
			pnImage += ((nWidth * nHeight * _aTexelInfoTable[nSrcTexFmt].nBitsPerTexel) >> 3);

			// Compute dimensions of next source mipmap image...
			nWidth >>= 1;
			nHeight >>= 1;
			FMATH_CLAMPMIN( nWidth, _aTexelInfoTable[nSrcTexFmt].nMinDim );
			FMATH_CLAMPMIN( nHeight, _aTexelInfoTable[nSrcTexFmt].nMinDim );
		}
	}

	// We must convert the texture. This is slower, but necessary because
	// the source texture is stored in a format that's not compatible with
	// this particular 3D adapter.

	if( FAILED( FDX8_pDev->CreateTexture(
								nDstWidth,
								nDstHeight,
								nDstLodCount,
								0,
								_aTexelInfoTable[nDstTexFmt].nSrcD3DFormat,
								D3DPOOL_SYSTEMMEM,
								&pD3DTexture
							) ) ) 
	{
		// Could not create texture...
		return FALSE;
	}

	// We created our temporary texture surface!

	if( !_ConvertAndCopyTextureImageToD3D(
					pD3DTexture,
					nSrcTexFmt,
					nDstLodCount,
					nSrcWidth,
					nSrcHeight,
					pSrcImage
			) ) 
	{
		// Could not copy the texture...
		pD3DTexture->Release();
		return FALSE;
	}

	if( !_CopyMipmapToImage( pD3DTexture, pDstImage, nDstTexFmt, nDstLodCount, nDstWidth, nDstHeight ) ) {
		// Couldn't convert...
		pD3DTexture->Release();
		return FALSE;
	}

	pD3DTexture->Release();

	return TRUE;
}
#endif


//
//
//
BOOL ftex_ModifyTexture( FTexDef_t *pTexDef, const void *pSrcImage, const FTexPalette_t *pPalette ) 
{
	FTexData_t *pTexData;

	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
	FASSERT( ftex_IsPointerValid( pTexDef, TRUE ) );
	FASSERT( pPalette == NULL );

	if( pTexDef == NULL ) 
	{
		return TRUE;
	}
	if( pSrcImage == NULL ) 
	{
		return TRUE;
	}

	FASSERT( pTexDef->TexInfo.nFlags & FTEX_FLAG_DYNAMIC );

	pTexData = pTexDef->pTexData;

	return _CopyImageToMipmap(
				pTexData,
				pSrcImage,
				(FTexFmt_e)pTexDef->TexInfo.nTexFmt,
				pTexDef->TexInfo.nLodCount,
				pTexDef->TexInfo.nTexelsAcross,
				pTexDef->TexInfo.nTexelsDown
			);
}


//
//
//
void ftex_PreLoad( FTexDef_t *pTexDef ) 
{
	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
	FASSERT( ftex_IsPointerValid( pTexDef, TRUE ) );

	if( pTexDef == NULL ) 
	{
		return;
	}

	#if FANG_PLATFORM_WIN
		pTexDef->pTexData->pD3DTexture->PreLoad();
	#endif
}


//
//
//
void ftex_ReleaseTex(CFTexInst *pTex)
{
	u32 nCnt=0;
	FTexDef_t *pTexDef;
	if (pTex)
	{
		do
		{
			pTexDef = pTex->GetTexDef();
			if (pTexDef)
			{
				nCnt = pTexDef->pTexData->pD3DTexture->Release();
			}
		} while (nCnt);
	}
}


//
//
//
CFTexInst *ftex_CreateDynamicEMBM( u32 nTexelsAcross, u32 nTexelsDown, cchar *pszName, FResHandle_t hRes, FResHandle_t *phRes )
{
	FTexData_t *pTexData;
	FTexDef_t *pTexDef;
	FTexInfo_t *pTexInfo;
	FResFrame_t ResFrame;
	DWORD nUsage=0;

	CFTexInst *pCFTex = NULL;

	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
	FASSERT( strlen( pszName ) < FDATA_TEXNAME_LEN );

	ResFrame = fres_GetFrame();

	// Build or retrieve our resource...
	if( hRes == FRES_NULLHANDLE) 
	{
		// Resource handle not provided...

		pTexData = (FTexData_t *)fres_CreateAndAlloc( FTEX_RESNAME, pszName, NULL, sizeof(FTexData_t), &hRes );
		if( pTexData == NULL ) 
		{
			// Could not create resource...
			goto _CreateEMBMFailure;
		}
	} 
	else 
	{
		// Resource handle provided...

		pTexData = (FTexData_t *)fres_Alloc( sizeof(FTexData_t) );
		if( pTexData == NULL ) 
		{
			goto _CreateEMBMFailure;
		}
	}

	pTexDef = &pTexData->TexDef;
	pTexDef->pTexData = pTexData;
	pTexInfo = &pTexDef->TexInfo;

	D3DFORMAT nClrFormat;

	nClrFormat = D3DFMT_X8L8V8U8;

	pTexData->nD3DFormatColor = nClrFormat;
	pTexData->nD3DFormatDepth = (D3DFORMAT)0;

	fclib_strcpy( pTexInfo->szName, pszName );
	pTexInfo->pUserData = NULL;
	pTexInfo->nTexFmt = _ConvertD3DFormatToTexFmt( pTexData->nD3DFormatColor );
	pTexInfo->nPalFmt = FTEX_PALFMT_NONE;
	pTexInfo->nFlags = FTEX_FLAG_DYNAMIC;
	pTexInfo->nLodCount = 1;
	pTexInfo->nTexelsAcross = (u16)nTexelsAcross;
	pTexInfo->nTexelsDown = (u16)nTexelsDown;
	
	_ResizeDimensionsIfRequired(
		(FTexFmt_e)pTexInfo->nTexFmt,
		&pTexInfo->nTexelsAcross,
		&pTexInfo->nTexelsDown
	);

	pTexData->nFlags = 0;
	pTexData->nD3DLodCount = 1;
	pTexData->nD3DWidth = pTexInfo->nTexelsAcross;
	pTexData->nD3DHeight = pTexInfo->nTexelsDown;
	pTexData->pD3DDepthStencil = NULL;
	pTexData->nAttachedStages = 0;
	pTexData->nTextureBytes = _ComputeTextureBytes( pTexDef );

	#if FPERF_ENABLE
		pTexData->nPerfKey = 0;
	#endif

	nUsage = 0;//D3DUSAGE_DYNAMIC;
	
	HRESULT hr;
	D3DPOOL d3dPool;

	#if FANG_PLATFORM_XB
	d3dPool = D3DPOOL_DEFAULT;
	#else
	d3dPool = D3DPOOL_MANAGED;
	#endif

	if( FAILED( hr = FDX8_pDev->CreateTexture(
								pTexData->nD3DWidth,
								pTexData->nD3DHeight,
								1,
								nUsage,
								pTexData->nD3DFormatColor,
								d3dPool,
								&pTexData->pD3DTexture
							) ) ) 
	{
		goto _CreateEMBMFailure;
	}

	if( phRes ) 
	{
		*phRes = hRes;
	}

	_nTotalTextureBytes += pTexData->nTextureBytes;
	
	pCFTex = fnew CFTexInst;
	if ( !pCFTex )
	{
		goto _CreateEMBMFailure;
	}
	
	pCFTex->SetTexDef( pTexDef );
	pCFTex->SetFlag(0);
	
	return pCFTex;
	//return pTexDef;

_CreateEMBMFailure:
	// Failure...
	fres_ReleaseFrame( ResFrame );

	if( phRes ) 
	{
		*phRes = FRES_NULLHANDLE;
	}

	return (NULL);
}


//
//
//
u32 _VectorToRGBA( CFVec3 *v )
{
    u32 r = (u32)( 127.0f * v->x + 128.0f );
    u32 g = (u32)( 127.0f * v->y + 128.0f );
    u32 b = (u32)( 127.0f * v->z + 128.0f );
    u32 a = 0xff;
    
    return( (a<<24L) + (r<<16L) + (g<<8L) + (b<<0L) );
}


//
//
//
void ftex_HeightMapToEMBM(CFTexInst *pTex, f32 *pfData, BOOL bVec3)
{
	//16K buffer for texture modification (4*64*64)
	static u32 pBuffer[64*64];

	FTexDef_t *pTexDef = pTex->GetTexDef();
	FTexInfo_t *pTexInfo = &pTexDef->TexInfo;
	FTexData_t *pTexData = pTexDef->pTexData;

	u32 *pPixel32 = (u32*)pBuffer;
    s32 nX, nY;
	f32 fT00, fT01, fT10, fDX, fDY;
	
	if (bVec3)  //Create 3D normalmap, where each pixel is the 3D Normal(XYZ)
	{
		CFVec3A vN;
		u32 nYOffs0, nYOffs1;

		nYOffs0 = 0;
		nYOffs1 = pTexDef->TexInfo.nTexelsAcross;

		for( nY = 0; nY < pTexInfo->nTexelsDown; nY++ )
		{
			for( nX = 0; nX < pTexInfo->nTexelsAcross; nX++ )
			{
				fT00 = pfData[ nX + nYOffs0 ];
					
				vN.x = (fT00 - pfData[ nX + nYOffs1 ])*0.25f;
				vN.y = (fT00 - pfData[((nX+1)%pTexInfo->nTexelsAcross) + nYOffs0 ])*0.25f;
				vN.z = 1.0f;

				vN.Unitize();

				FMATH_CLAMP(vN.x, -1.0f, 1.0f);
				FMATH_CLAMP(vN.y, -1.0f, 1.0f);
				FMATH_CLAMP(vN.z, -1.0f, 1.0f);
				
				*pPixel32++ = ( 0xff000000 | ((u32)( 128.0f * vN.x + 127.0f )<<16L) | ((u32)( 128.0f * vN.y + 127.0f )<<8L) | ((u32)( 128.0f * vN.z + 127.0f )) );
			}

			nYOffs0 += pTexDef->TexInfo.nTexelsAcross;
			nYOffs1 = (nY < pTexInfo->nTexelsDown-1)?(nYOffs0+pTexDef->TexInfo.nTexelsAcross):(0);
		}
	}
	else	//Create 2D EnvMapBumpMap, where each pixel contains the normal displacements along the orthogonal tangents of the surface.
	{
		for( nY = 0; nY < pTexInfo->nTexelsDown; nY++ )
		{
			for( nX = 0; nX < pTexInfo->nTexelsAcross; nX++ )
			{
				if (nX < pTexInfo->nTexelsAcross-1 && nY < pTexInfo->nTexelsAcross-1)
				{
					fT00 = pfData[ nX + nY*pTexDef->TexInfo.nTexelsAcross ] * 0.25f;
					fT01 = pfData[nX+1+ nY*pTexDef->TexInfo.nTexelsAcross ] * 0.25f;
					fT10 = pfData[ nX +(nY+1)*pTexDef->TexInfo.nTexelsAcross] * 0.25f;

					fDX = fT00 - fT01;
					fDY = fT00 - fT10;
									
					fDX = fDX*128.0f + 127.0f;
					FMATH_CLAMP(fDX, 0.0f, 255.0f);
					fDY = fDY*128.0f + 127.0f;
					FMATH_CLAMP(fDY, 0.0f, 255.0f);
					
					*pPixel32++ = (0x00ff0000&((u8)(0xff)<<8)) | (0x0000ff00&((u8)(fDY)<<8)) | (0x000000ff&((u8)fDX<<0));
				}
				else
				{
					*pPixel32++ = 0x00808080;
				}
			}
		}
	}

	ftex_ModifyTexture(pTexDef, pBuffer, NULL);
}


//
//
//
void ftex_CreateSharedDepthBuffer(u8 nBPP, u32 nWidth, u32 nHeight)
{
	u32 nFormatDepth;

	if (nBPP == 16)
	{
#if FANG_PLATFORM_XB
		nFormatDepth = D3DFMT_LIN_D16;
#else
		nFormatDepth = D3DFMT_D16;
#endif
	}
	else
	{
		nFormatDepth = D3DFMT_D24S8;
	}

	if( FAILED( FDX8_pDev->CreateDepthStencilSurface(
								nWidth,
								nHeight,
								(D3DFORMAT)nFormatDepth,
								D3DMULTISAMPLE_NONE,
								&_pDepthBuffer
							) ) ) 
	{
		FASSERT_NOW_MSG("Create Shared Depth Buffer FAILED!");
		_pDepthBuffer = NULL;
	}
}


//
//
//
void ftex_ClearSharedDepthBuffer( void )
{
	_pDepthBuffer=NULL;
}


//
//
//
CFTexInst *ftex_CreateRenderTarget_FullScreen( FTexRenderTargetFmt_e nFormat, cchar *pszName, BOOL bPow2, FResHandle_t hRes, FResHandle_t *phRes, u32 nTexelsAcross, u32 nTexelsDown, FTextureType_e nType, BOOL bDoubleBuffer )
{
	#if FANG_PLATFORM_XB
	bPow2 = TRUE;
	#endif

	if (nTexelsAcross == 0 || nTexelsDown == 0)
	{
		if (bPow2)
		{
			nTexelsAcross = 512; nTexelsDown = 512;
		}
		else
		{
			nTexelsAcross = 640; nTexelsDown = 480;
		}
	}

	CFTexInst *pTexInst = ftex_CreateRenderTarget(nTexelsAcross, nTexelsDown, nFormat, pszName, bPow2, hRes, phRes, nType, bDoubleBuffer);
	if (pTexInst)
	{
		pTexInst->SetFlag(CFTexInst::FLAG_FULLSCREEN);
	}
	return (pTexInst);
}

#include <stdio.h>

//
//
//
CFTexInst *ftex_CreateRenderTarget( u32 nTexelsAcross, u32 nTexelsDown, FTexRenderTargetFmt_e nFormat, cchar *pszName, BOOL bPow2, FResHandle_t hRes, FResHandle_t *phRes, FTextureType_e nType, BOOL bDoubleBuffer ) 
{
	FTexDef_t *pTexDef;
	FTexData_t *pTexData[2];
	FTexInfo_t *pTexInfo;
	char szName2[64];
	FResFrame_t ResFrame;
	DWORD nUsage=0;

	CFTexInst *pCFTex = NULL;

	FASSERT( _bWindowCreated );
	FASSERT( !fdx8vid_bResetting );
#if FANG_ENABLE_FASSERT
	if (bPow2)
	{
		FASSERT( fmath_IsPowerOf2( nTexelsAcross, FALSE ) );
		FASSERT( fmath_IsPowerOf2( nTexelsDown, FALSE ) );
	}
#endif

	if( !FTex_bRenderTargets ) 
	{
		return NULL;
	}

	if( pszName == NULL ) 
	{
		pszName = FTEX_DEFAULT_RENDER_TARGET_NAME;
	}
	FASSERT( strlen( pszName ) < FDATA_TEXNAME_LEN );

	ResFrame = fres_GetFrame();

	// Build or retrieve our resource...
	if( hRes == FRES_NULLHANDLE) 
	{
		// Resource handle not provided...

		pTexData[0] = (FTexData_t *)fres_CreateAndAlloc( FTEX_RESNAME, pszName, NULL, sizeof(FTexData_t), &hRes );
		sprintf(szName2, "%s_2", pszName);
		pTexData[1] = (FTexData_t *)fres_CreateAndAlloc( FTEX_RESNAME, szName2, NULL, sizeof(FTexData_t), &hRes );
		if( pTexData[0] == NULL || pTexData[1] == NULL ) 
		{
			// Could not create resource...
			goto _CreateRenderTargetFailure;
		}
	} 
	else 
	{
		// Resource handle provided...

		pTexData[0] = (FTexData_t *)fres_Alloc( sizeof(FTexData_t) );
		pTexData[1] = (FTexData_t *)fres_Alloc( sizeof(FTexData_t) );
		if( pTexData == NULL ) 
		{
			goto _CreateRenderTargetFailure;
		}
	}

	pTexDef = &pTexData[0]->TexDef;
	pTexDef->pTexData = pTexData[0];
	pTexInfo = &pTexDef->TexInfo;

	D3DFORMAT nClrFormat, nDepthFormat;

#if FANG_PLATFORM_XB
	if (nFormat < FTEX_RENDERTARGET_FMT_C24_A8)
	{
		nClrFormat = D3DFMT_R5G6B5;
		nDepthFormat = D3DFMT_LIN_D16;
	}
	else
	{
		nClrFormat = D3DFMT_A8R8G8B8;
		nDepthFormat = D3DFMT_LIN_D24S8;
	}
#else
	nClrFormat = _aRenderTargetFormat[nFormat].ColorFmt;
	nDepthFormat = _aRenderTargetFormat[nFormat].DepthFmt;
#endif

	pTexData[0]->nD3DFormatColor = nClrFormat;
	pTexData[0]->nD3DFormatDepth = nDepthFormat;

	fclib_strcpy( pTexInfo->szName, pszName );
	pTexInfo->pUserData = NULL;
	pTexInfo->nTexFmt = _ConvertD3DFormatToTexFmt( pTexData[0]->nD3DFormatColor );
	pTexInfo->nPalFmt = FTEX_PALFMT_NONE;
	pTexInfo->nFlags = FTEX_FLAG_RENDERTARGET;
	pTexInfo->nLodCount = 1;
	pTexInfo->nTexelsAcross = (u16)nTexelsAcross;
	pTexInfo->nTexelsDown = (u16)nTexelsDown;
	_ComputeDepthStencilBitCount( pTexData[0]->nD3DFormatDepth, &pTexInfo->nRenderTargetDepthBitCount, &pTexInfo->nRenderTargetStencilBitCount );

	_ResizeDimensionsIfRequired(
		(FTexFmt_e)pTexInfo->nTexFmt,
		&pTexInfo->nTexelsAcross,
		&pTexInfo->nTexelsDown
	);

	pTexData[0]->nFlags = 0;
	pTexData[0]->nD3DLodCount = 1;
	pTexData[0]->nD3DWidth = pTexInfo->nTexelsAcross;
	pTexData[0]->nD3DHeight = pTexInfo->nTexelsDown;
	pTexData[0]->pD3DDepthStencil = NULL;
	pTexData[0]->nAttachedStages = 0;
	pTexData[0]->nTextureBytes = _ComputeTextureBytes( pTexDef );

	#if FPERF_ENABLE
		pTexData[0]->nPerfKey = 0;
		pTexData[1]->nPerfKey = 0;
	#endif

	if (!_pDepthBuffer)
	{
		if( pTexData[0]->nD3DFormatDepth != D3DFMT_UNKNOWN ) {
			if( FAILED( FDX8_pDev->CreateDepthStencilSurface(
									pTexData[0]->nD3DWidth,
									pTexData[0]->nD3DHeight,
									pTexData[0]->nD3DFormatDepth,
									D3DMULTISAMPLE_NONE,
									&pTexData[0]->pD3DDepthStencil
								) ) ) 
			{
				goto _CreateRenderTargetFailure;
			}
		}
	}
	else
	{
		pTexData[0]->pD3DDepthStencil = _pDepthBuffer;
	}

	nUsage = D3DUSAGE_RENDERTARGET;
	
	if (nType == FTEX_2D)
	{
		if( FAILED( FDX8_pDev->CreateTexture(
									pTexData[0]->nD3DWidth,
									pTexData[0]->nD3DHeight,
									1,
									nUsage,
									pTexData[0]->nD3DFormatColor,
									D3DPOOL_DEFAULT,
									&pTexData[0]->pD3DTexture
								) ) ) 
		{
			if (!_pDepthBuffer)
			{
				FDX8_SAFE_RELEASE( pTexData[0]->pD3DDepthStencil );
			}
			goto _CreateRenderTargetFailure;
		}
	}
	else if (nType == FTEX_CUBE)
	{
		if( FAILED( FDX8_pDev->CreateCubeTexture(
									pTexData[0]->nD3DWidth,
									1,
									nUsage,
									pTexData[0]->nD3DFormatColor,
									D3DPOOL_DEFAULT,
									(IDirect3DCubeTexture8**)&pTexData[0]->pD3DTexture
								) ) ) 
		{
            FDX8_SAFE_RELEASE( pTexData[0]->pD3DDepthStencil );
			goto _CreateRenderTargetFailure;
		}
	}

	//flinklist_AddTail( &_RootList, pTexData[0] );

	if (nType != FTEX_CUBE && bDoubleBuffer)
	{
		pTexDef = &pTexData[1]->TexDef;
		pTexDef->pTexData = pTexData[1];
		pTexInfo = &pTexDef->TexInfo;

		pTexData[1]->nD3DFormatColor = nClrFormat;
		pTexData[1]->nD3DFormatDepth = nDepthFormat;

		fclib_strcpy( pTexInfo->szName, pszName );
		pTexInfo->pUserData = NULL;
		pTexInfo->nTexFmt = _ConvertD3DFormatToTexFmt( pTexData[0]->nD3DFormatColor );
		pTexInfo->nPalFmt = FTEX_PALFMT_NONE;
		pTexInfo->nFlags = FTEX_FLAG_RENDERTARGET;
		pTexInfo->nLodCount = 1;
		pTexInfo->nTexelsAcross = (u16)nTexelsAcross;
		pTexInfo->nTexelsDown = (u16)nTexelsDown;

		pTexData[1]->nFlags = 0;
		pTexData[1]->nD3DLodCount = 1;
		pTexData[1]->nD3DWidth = pTexInfo->nTexelsAcross;
		pTexData[1]->nD3DHeight = pTexInfo->nTexelsDown;
		pTexData[1]->pD3DDepthStencil = NULL;
		pTexData[1]->nAttachedStages = 0;
		pTexData[1]->nTextureBytes = _ComputeTextureBytes( pTexDef );
		//pTexData[1] = pTexData[0];
		pTexData[1]->pD3DDepthStencil = pTexData[0]->pD3DDepthStencil;

		if (nType == FTEX_2D)
		{
			if( FAILED( FDX8_pDev->CreateTexture(
									pTexData[1]->nD3DWidth,
									pTexData[1]->nD3DHeight,
									1,
									nUsage,
									pTexData[1]->nD3DFormatColor,
									D3DPOOL_DEFAULT,
									&pTexData[1]->pD3DTexture
								) ) ) 
			{
				FDX8_SAFE_RELEASE( pTexData[0]->pD3DTexture );
				if (!_pDepthBuffer)
				{
					FDX8_SAFE_RELEASE( pTexData[0]->pD3DDepthStencil );
				}
				goto _CreateRenderTargetFailure;
			}
		}
		else if (nType == FTEX_CUBE)
		{
			if( FAILED( FDX8_pDev->CreateCubeTexture(
									pTexData[1]->nD3DWidth,
									1,
									nUsage,
									pTexData[1]->nD3DFormatColor,
									D3DPOOL_DEFAULT,
									(IDirect3DCubeTexture8**)&pTexData[1]->pD3DTexture
								) ) ) 
			{
				FDX8_SAFE_RELEASE( pTexData[0]->pD3DTexture );
				if (!_pDepthBuffer)
				{
					FDX8_SAFE_RELEASE( pTexData[0]->pD3DDepthStencil );
				}
				goto _CreateRenderTargetFailure;
			}
		}
	}


	//flinklist_AddTail( &_RootList, pTexData[1] );

	if( phRes ) 
	{
		*phRes = hRes;
	}

	_nTotalTextureBytes += pTexData[0]->nTextureBytes;
	if (nType != FTEX_CUBE && bDoubleBuffer)
	{
		_nTotalTextureBytes += pTexData[1]->nTextureBytes;
	}

	pCFTex = fnew CFTexInst;
	if ( !pCFTex )
	{
		goto _CreateRenderTargetFailure;
	}
	
	pCFTex->SetTexDef( pTexDef );
#if 1
	pCFTex->SetTexBufferData(pTexData[0], pTexData[1]);
#endif
	pCFTex->SetFlag(CFTexInst::FLAG_RENDERTARGET);
	if (bPow2)
	{
		pCFTex->SetFlag(CFTexInst::FLAG_POW2);
	}

	if (nType == FTEX_CUBE)
	{
		//pCFTex->SetFlag(FTEX_FLAG_CUBEMAP);
		pCFTex->SetFlag(CFTexInst::FLAG_CUBEMAP);
	}

	return pCFTex;
	//return pTexDef;

_CreateRenderTargetFailure:
	// Failure...
	fres_ReleaseFrame( ResFrame );

	if( phRes ) 
	{
		*phRes = FRES_NULLHANDLE;
	}

	return NULL;
}


//
//
//
void fdx8tex_UncacheSelected( void ) 
{
	u32 nStageNum, nWalkingBit;

	FASSERT( _bWindowCreated );

	for( nStageNum=0, nWalkingBit=1; nStageNum<FDX8_nStageCount; nStageNum++, nWalkingBit<<=1 ) 
	{
		if( _aSetTexState[nStageNum].TexInst.GetTexDef() ) 
		{
			_aSetTexState[nStageNum].TexInst.GetTexDef()->pTexData->nAttachedStages &= ~nWalkingBit;
		}

		_aSetTexState[nStageNum].bStateCached = FALSE;
	}
}

void ftex_SetTexAddress( u32 nStageNum, BOOL bWrapU, BOOL bWrapV, BOOL bWrapW )
{
	u32 nTexInstFlags;
	nTexInstFlags = (bWrapU ? CFTexInst::FLAG_WRAP_S:0);
	nTexInstFlags |= (bWrapV ? CFTexInst::FLAG_WRAP_T:0);
	nTexInstFlags |= (bWrapW ? CFTexInst::FLAG_WRAP_U:0);

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_S ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_S );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSU, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_S)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_T ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_T );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSV, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_T)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_U ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_U );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSW, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_U)] );
	}
}

//
//
//
void fdx8tex_SetTexture( u32 nStageNum, CFTexInst *pTexInst, u32 nTCIndex ) 
{
	u32 nTexInstFlags;
	f32 fMipmapBias;

	FASSERT( _bWindowCreated );
	FASSERT( nStageNum<FDX8_nStageCount && nStageNum<32 );

#if FANG_PLATFORM_XB
	if ( pTexInst && pTexInst->GetTexDef() && (pTexInst->GetTexDef()->TexInfo.nFlags & FTEX_FLAG_STREAMING) )
	{
		FTexData_t *pTexData = pTexInst->GetTexDef()->pTexData;
		if ( pTexData->nFlags & FDX8TEXFLAGS_NOT_IN_CACHE )
		{
			u8 *pCachedData = (u8 *)FDS_StreamMgr.AccessData( pTexData->pStreamingHandle );
			if ( !pCachedData )
			{
				// Streamed texture is not in the cache, yet
				pTexInst = NULL;
			}
			else
			{
				// Streamed texture just entered the cache, so register it with the texture header
				pTexData->pD3DTexture->BlockUntilNotBusy();
				pTexData->pD3DTexture->Lock = 0;
				pTexData->nFlags &= ~FDX8TEXFLAGS_NOT_IN_CACHE;
				pTexData->pD3DTexture->Register( pCachedData + 128 );
			}
		}
		else
		{
			void *pCachedData = FDS_StreamMgr.AccessData( pTexData->pStreamingHandle );
			if ( !pCachedData )
			{
				// Streamed texture is no longer in the local streaming cache
				pTexData->nFlags |= FDX8TEXFLAGS_NOT_IN_CACHE;
				pTexData->pD3DTexture->Data = NULL;
				pTexInst = NULL;
			}
		}
	}
#endif // FANG_PLATFORM_XB

	if( !_aSetTexState[nStageNum].bStateCached ) 
	{
		if( pTexInst == NULL ) 
		{
			pTexInst = &CFTexInst::NullTexInst;
		}

		_aSetTexState[nStageNum].nTCIndex = nTCIndex;
		_aSetTexState[nStageNum].TexInst = *pTexInst;

		_RestoreTextureStateForStage( nStageNum );

		if( pTexInst->GetTexDef() ) 
		{
			pTexInst->GetTexDef()->pTexData->nAttachedStages |= (1<<nStageNum);
		}

		return;
	}

	if( pTexInst ) 
	{
/*
#if FANG_PLATFORM_XB
		if ( pTexInst->GetTexDef() && pTexInst->GetTexDef()->TexInfo.nFlags & FTEX_FLAG_STREAMING )
		{
			FTexData_t *pTexData = pTexInst->GetTexDef()->pTexData;
			if ( pTexData->nFlags & FDX8TEXFLAGS_NOT_IN_CACHE )
			{
				void *pCachedData = FDS_StreamMgr.AccessData( pTexData->pStreamingHandle );
				if ( !pCachedData )
				{
					_DXSetTexture( nStageNum, NULL, nTCIndex );
					return;
				}
				else
				{
					pTexData->pD3DTexture->BlockUntilNotBusy();

					pTexData->pD3DTexture->Lock = 0;
					pTexData->nFlags &= ~FDX8TEXFLAGS_NOT_IN_CACHE;
					pTexData->pD3DTexture->Register( pCachedData );
					_DXSetTexture( nStageNum, pTexInst->GetTexDef(), nTCIndex );
				}
			}
			else
			{
				void *pCachedData = FDS_StreamMgr.AccessData( pTexData->pStreamingHandle );
				if ( !pCachedData )
				{
					pTexData->nFlags |= FDX8TEXFLAGS_NOT_IN_CACHE;
					pTexData->pD3DTexture->Data = NULL;
					_DXSetTexture( nStageNum, NULL, nTCIndex );
					return;
				}
				else
				{
					_DXSetTexture( nStageNum, pTexInst->GetTexDef(), nTCIndex );
				}
			}
		}
		else
#endif // FANG_PLATFORM_XB
*/
		{
			_DXSetTexture( nStageNum, pTexInst->GetTexDef(), nTCIndex );
		}
	} 
	else 
	{
		_DXSetTexture( nStageNum, NULL, nTCIndex );
		return;
	}

	if( pTexInst->GetTexDef() == NULL ) 
	{
		return;
	}

	nTexInstFlags = pTexInst->GetFlags();
	
	if( pTexInst->GetTexDef()->TexInfo.nFlags & FTEX_FLAG_RENDERTARGET ) 
	{
		// Cannot wrap render targets...
		nTexInstFlags &= ~(CFTexInst::FLAG_WRAP_S | CFTexInst::FLAG_WRAP_T | CFTexInst::FLAG_WRAP_U);
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_S ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_S );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSU, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_S)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_T ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_T );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSV, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_T)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_WRAP_U ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_WRAP_U );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSW, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_U)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_MAGFILTER_NO_BILINEAR ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_MAGFILTER_NO_BILINEAR );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MAGFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MAGFILTER_NO_BILINEAR)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_MINFILTER_NO_BILINEAR ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_MINFILTER_NO_BILINEAR );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MINFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MINFILTER_NO_BILINEAR)] );
	}

	if( (nTexInstFlags ^ _aSetTexState[nStageNum].TexInst.GetFlags()) & CFTexInst::FLAG_MINFILTER_NO_TRILINEAR ) 
	{
		_aSetTexState[nStageNum].TexInst.FlipFlags( CFTexInst::FLAG_MINFILTER_NO_TRILINEAR );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MIPFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MINFILTER_NO_TRILINEAR)] );
	}

	if( pTexInst->GetMipmapBias() != _aSetTexState[nStageNum].TexInst.GetMipmapBias() ) 
	{
		_aSetTexState[nStageNum].TexInst.SetMipmapBias( pTexInst->GetMipmapBias() );
		fMipmapBias = _aSetTexState[nStageNum].TexInst.GetMipmapBias();
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MIPMAPLODBIAS, *((DWORD *)(&fMipmapBias)) );
	}
}


//
//
//
void fdx8tex_CopyRectFromBackBuffer( s32 nSrcUpperLeftX, s32 nSrcUpperLeftY, FTexDef_t *pDstRenderTarget ) 
{
	RECT SourceRect;
	POINT DestUpperLeftPoint;
	IDirect3DSurface8 *pDstD3DSurface;
	s32 nWidth, nHeight, nSrcLowerRightX, nSrcLowerRightY, nScreenLowerRightX, nScreenLowerRightY, nPixelsOver;
	HRESULT hResult;

	FASSERT( _bWindowCreated );
	FASSERT( pDstRenderTarget->TexInfo.nFlags & FTEX_FLAG_RENDERTARGET );

	nWidth = pDstRenderTarget->pTexData->nD3DWidth;
	nHeight = pDstRenderTarget->pTexData->nD3DHeight;
	DestUpperLeftPoint.x = DestUpperLeftPoint.y = 0;

	// Clip to left of screen...
	if( nSrcUpperLeftX < 0 ) 
	{
		nWidth += nSrcUpperLeftX;
		if( nWidth <= 0 ) 
		{
			return;
		}

		DestUpperLeftPoint.x -= nSrcUpperLeftX;
		nSrcUpperLeftX = 0;
	}

	// Clip to top of screen...
	if( nSrcUpperLeftY < 0 ) 
	{
		nHeight += nSrcUpperLeftY;
		if( nHeight <= 0 ) 
		{
			return;
		}

		DestUpperLeftPoint.y -= nSrcUpperLeftY;
		nSrcUpperLeftY = 0;
	}

	nSrcLowerRightX = nSrcUpperLeftX + nWidth;
	nSrcLowerRightY = nSrcUpperLeftY + nHeight;
	nScreenLowerRightX = (s32)FVid_Mode.nPixelsAcross;
	nScreenLowerRightY = (s32)FVid_Mode.nPixelsDown;

	// Clip to right of screen...
	nPixelsOver = nSrcLowerRightX - nScreenLowerRightX;
	if( nPixelsOver > 0 ) 
	{
		nWidth -= nPixelsOver;
		if( nWidth <= 0 ) 
		{
			return;
		}

		nSrcLowerRightX = nScreenLowerRightX;
	}

	// Clip to bottom of screen...
	nPixelsOver = nSrcLowerRightY - nScreenLowerRightY;
	if( nPixelsOver > 0 ) 
	{
		nHeight -= nPixelsOver;
		if( nHeight <= 0 ) 
		{
			return;
		}

		nSrcLowerRightY = nScreenLowerRightY;
	}

	SourceRect.left = nSrcUpperLeftX;
	SourceRect.top = nSrcUpperLeftY;
	SourceRect.right = nSrcLowerRightX;
	SourceRect.bottom = nSrcLowerRightY;

	pDstRenderTarget->pTexData->pD3DTexture->GetSurfaceLevel( 0, &pDstD3DSurface );
	hResult = FDX8_pDev->CopyRects( FDX8_pSurfBack, &SourceRect, 1, pDstD3DSurface, &DestUpperLeftPoint );
	pDstD3DSurface->Release();
}


//
//
//
static void _DXSetTexture( u32 nStageNum, FTexDef_t *pTexDef, u32 nTCIndex ) 
{
	FASSERT( nStageNum<FDX8_nStageCount && nStageNum<32 );

	if( pTexDef != _aSetTexState[nStageNum].TexInst.GetTexDef() ) 
	{
		if( _aSetTexState[nStageNum].TexInst.GetTexDef() ) 
		{
			_aSetTexState[nStageNum].TexInst.GetTexDef()->pTexData->nAttachedStages &= ~(1<<nStageNum);
		}

		#if FPERF_ENABLE
			if( pTexDef && _aSetTexState[nStageNum].TexInst.GetTexDef() ) 
			{
				FPerf_nRawTexSwitchCount++;
				if( pTexDef->pTexData->nPerfKey != FPerf_nUpdateKey ) 
				{
					pTexDef->pTexData->nPerfKey = FPerf_nUpdateKey;
					FPerf_nUniqueTexturesUsed++;
				}
			}
		#endif

		_aSetTexState[nStageNum].TexInst.SetTexDef( pTexDef );

		if( pTexDef ) {
			pTexDef->pTexData->nAttachedStages |= (1<<nStageNum);
			FDX8_pDev->SetTexture( nStageNum, pTexDef->pTexData->pD3DTexture );
		} else {
			FDX8_pDev->SetTexture( nStageNum, NULL );
		}
	}

	if( nTCIndex != _aSetTexState[nStageNum].nTCIndex ) 
	{
		_aSetTexState[nStageNum].nTCIndex = nTCIndex;
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_TEXCOORDINDEX, _aSetTexState[nStageNum].nTCIndex );
	}
}


//
//
//
static void* _ResLoadAlloc( u32 nTextureBytes ) 
{
#if FANG_PLATFORM_XB
	nTextureBytes = FMATH_BYTE_ALIGN_UP( nTextureBytes, D3DTEXTURE_ALIGNMENT );
	return D3D_AllocContiguousMemory( nTextureBytes, D3DTEXTURE_ALIGNMENT );
#else
	return NULL;
#endif
}


//
//
//
static void _ResLoadFree( void *pMemory ) 
{
#if FANG_PLATFORM_XB
	if ( pMemory )
	{
		return D3D_FreeContiguousMemory( pMemory );
	}
#endif
}


//
//
//
static BOOL _ResLoadCreate( FResHandle_t hRes, void *pLoadedBase, u32 nLoadedBytes, cchar *pszResName ) 
{
	FTexDef_t *pTexDef;
	FTexInfo_t *pTexInfo;
	void *pSrcImage;

	FASSERT( _bWindowCreated );

	pTexInfo = (FTexInfo_t *)pLoadedBase;
	pSrcImage = (u8 *)pLoadedBase + FMATH_BYTE_ALIGN_UP( sizeof(FTexInfo_t), 128 );

	FASSERT( strlen( pszResName ) <= FDATA_TEXNAME_LEN );
	strcpy( pTexInfo->szName, pszResName );

	pTexDef = ftex_CreateTexture( pTexInfo, pSrcImage, NULL, hRes );
	if( pTexDef == NULL ) 
	{
		// Texture could not be created...
		return FALSE;
	}

	// Texture created successfully...

	fres_SetBase( hRes, pTexDef->pTexData );

	return TRUE;
}


//
//
//
static void _ResLoadDestroy( void *pBase ) 
{
	FTexData_t *pTexData, *pTexDataCurrentViewport;
	FViewport_t *pViewport;
	u32 i;

	pTexData = (FTexData_t *)pBase;
	pViewport = fviewport_GetActive();
	pTexDataCurrentViewport = NULL;

	_nTotalTextureBytes -= pTexData->nTextureBytes;

	// If we're deleting a render target that's currently set as the active
	// viewport, we must disable the current viewport...
	if( pTexData == pTexDataCurrentViewport ) 
	{
		if( !fdx8vid_bResetting ) 
		{
			fviewport_SetActive( NULL );
		}
	}

	if( pTexData->nAttachedStages ) 
	{
		// This texture is currently attached to one or more stages...

		for( i = 0; i < 32; i++ ) 
		{
			if( pTexData->nAttachedStages & (1<<i) ) 
			{
				if( !fdx8vid_bResetting ) 
				{
					FDX8_pDev->SetTexture( i, NULL );
				}

				//FASSERT( _aSetTexState[i].TexInst.GetTexDef() == &pTexData->TexDef );
				_aSetTexState[i].TexInst.SetTexDef( NULL );
			}
		}

		pTexData->nAttachedStages = 0;
	}

	//FDX8_SAFE_RELEASE( pTexData->pD3DTexture );
	//FDX8_SAFE_RELEASE( pTexData->pD3DDepthStencil );

	s32 nRelease;

	if (pTexData->pD3DTexture)
	{
#if FANG_PLATFORM_XB
		if ( (pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_LOAD_IN_PLACE) && !(pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_STREAMING) )
		{
			D3D_FreeContiguousMemory( (void *)pTexData->pImageData );
//			fdelete( pTexData->pD3DTexture );
		}
		else if ( !(pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_STREAMING) )
#endif // FANG_PLATFORM_XB
		{
			do
			{
				nRelease = pTexData->pD3DTexture->Release();
			} while (nRelease);
		}
	}

	if (pTexData->pD3DDepthStencil)
	{
		do
		{
			nRelease = pTexData->pD3DDepthStencil->Release();
		} while (nRelease);
	}

#if FHEAP_TRACK_MEM_ALLOCATIONS
	fheap_UnTrackTexMem( &pTexData->TexDef.TexInfo );
#endif
	
	flinklist_Remove( &_RootList, pTexData );

	//ftex_ClearRenderTargets();
}


//
//
//
static void _ReleaseAllRenderTargets( void ) 
{
	FTexData_t *pTexData;

	FASSERT( _bWindowCreated );

	// The video system is about to reset the device. For the reset to be successful,
	// we must Release all non-managed textures. Currently, these are only render
	// targets, all of which have been created in D3DPOOL_DEFAULT.

	for( pTexData=(FTexData_t *)flinklist_GetTail(&_RootList); pTexData; pTexData=(FTexData_t *)flinklist_GetPrev( &_RootList, pTexData ) ) 
	{
		if( pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_RENDERTARGET ) 
		{
			// We found a render target. Release the texture...

			FASSERT( pTexData->pD3DTexture );

			FDX8_SAFE_RELEASE( pTexData->pD3DTexture );
			FDX8_SAFE_RELEASE( pTexData->pD3DDepthStencil );
		}
	}
}


//
//
//
static void _RebuildAllRenderTargets( void ) 
{
	FTexData_t *pTexData;

	FASSERT( _bWindowCreated );

	for( pTexData=(FTexData_t *)flinklist_GetTail(&_RootList); pTexData; pTexData=(FTexData_t *)flinklist_GetPrev( &_RootList, pTexData ) ) 
	{
		if( pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_RENDERTARGET ) 
		{
			// We found a render target...

			FASSERT( !pTexData->pD3DTexture );

			// Re-create the render target...
			FDX8_pDev->CreateTexture(
							pTexData->nD3DWidth,
							pTexData->nD3DHeight,
							pTexData->nD3DLodCount,
							D3DUSAGE_RENDERTARGET,
							pTexData->nD3DFormatColor,
							D3DPOOL_DEFAULT,
							&pTexData->pD3DTexture
						);

			if( pTexData->nD3DFormatDepth != D3DFMT_UNKNOWN ) {
				FDX8_pDev->CreateDepthStencilSurface(
								pTexData->nD3DWidth,
								pTexData->nD3DHeight,
								pTexData->nD3DFormatDepth,
								D3DMULTISAMPLE_NONE,
								&pTexData->pD3DDepthStencil
							);
			}
		}
	}
}


//
//
//
static void _RestoreTextureStateForStage( u32 nStageNum ) 
{
	f32 fMipmapBias;

	FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_TEXCOORDINDEX, _aSetTexState[nStageNum].nTCIndex );

	if( _aSetTexState[nStageNum].TexInst.GetTexDef()==NULL || !(_aSetTexState[nStageNum].TexInst.GetTexDef()->TexInfo.nFlags & FTEX_FLAG_RENDERTARGET) ) {
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSU, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_S)] );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSV, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_T)] );
		FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_ADDRESSW, _aDXTexAddress[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_WRAP_U)] );
	} 
	else 
	{
		ftex_SetTexAddress(nStageNum, FALSE, FALSE, FALSE);
	}

	FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MAGFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MAGFILTER_NO_BILINEAR)] );
	FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MINFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MINFILTER_NO_BILINEAR)] );
	FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MIPFILTER, _aDXTexFilter[!(_aSetTexState[nStageNum].TexInst.GetFlags() & CFTexInst::FLAG_MINFILTER_NO_TRILINEAR)] );
	fMipmapBias = _aSetTexState[nStageNum].TexInst.GetMipmapBias();
	FDX8_pDev->SetTextureStageState( nStageNum, D3DTSS_MIPMAPLODBIAS, *((DWORD *)(&fMipmapBias)) );

	if( _aSetTexState[nStageNum].TexInst.GetTexDef() ) 
	{
		FDX8_pDev->SetTexture( nStageNum, _aSetTexState[nStageNum].TexInst.GetTexDef()->pTexData->pD3DTexture );
	} 
	else 
	{
		FDX8_pDev->SetTexture( nStageNum, NULL );
	}

	_aSetTexState[nStageNum].bStateCached = TRUE;
}


//
//
//
static void _RestoreTextureState( void ) 
{
	u32 nStageNum;

	for( nStageNum=0; nStageNum<FDX8_nStageCount; nStageNum++ ) 
	{
		_RestoreTextureStateForStage( nStageNum );
	}
}

BOOL FTex_WorldCallbackFunc( FWorldEvent_e nEvent )
{
	switch (nEvent)
	{
		case FWORLD_EVENT_WORLD_PRELOAD:
			ftex_ClearRenderTargets();
			break;
		case FWORLD_EVENT_WORLD_POSTDESTROY:
			ftex_ClearRenderTargets();
			break;
		case FWORLD_EVENT_WORLD_POSTLOAD:
			break;
		case FWORLD_EVENT_WORLD_PREDESTROY:
			break;
	};
	return TRUE;
}

//
//
//
static BOOL _WindowCreatedCallback( FDX8VidEvent_e nEvent ) 
{
	u32 i;

	FASSERT( _bModuleInitialized );
	FASSERT( nEvent>=0 && nEvent<FDX8VID_EVENT_COUNT );

	switch( nEvent ) 
	{
		case FDX8VID_EVENT_WINDOW_CREATED:
			_bWindowCreated = TRUE;

			_nTotalTextureBytes = 0;

			FTex_bRenderTargets = _DetermineRenderTargets();

			if( !_DetermineSupportedTexelFormats() ) 
			{
				_bWindowCreated = FALSE;
				return FALSE;
			}

			FTex_nMaxTextureWidth = FDX8_Caps.MaxTextureWidth ? FDX8_Caps.MaxTextureWidth : 256;
			FTex_nMaxTextureHeight = FDX8_Caps.MaxTextureHeight ? FDX8_Caps.MaxTextureHeight : 256;

			if( FDX8_Caps.MaxTextureAspectRatio ) 
			{
				FTex_nMaxAspect = FDX8_Caps.MaxTextureAspectRatio;
			} 
			else 
			{
				FTex_nMaxAspect = FMATH_MAX( FDX8_Caps.MaxTextureWidth, FDX8_Caps.MaxTextureHeight );
			}

			FTex_bMipmaps = !!(FDX8_Caps.TextureCaps & D3DPTEXTURECAPS_MIPMAP);
			FTex_bDynamicTextures = TRUE;
			FTex_bDynamicsCanBeLost = !!FANG_PLATFORM_WIN;

			for( i=0; i<FDX8_MAX_TEX_STAGES; i++ ) 
			{
				_aSetTexState[i].bStateCached = FALSE;
			}
			
			fworld_RegisterWorldCallbackFunction( FTex_WorldCallbackFunc );
			break;

		case FDX8VID_EVENT_WINDOW_DESTROYED:
			_ClearData();
			_bWindowCreated = FALSE;
			
			fworld_UnregisterWorldCallbackFunction( FTex_WorldCallbackFunc );
			break;

		case FDX8VID_EVENT_PRE_RESET:
			_ReleaseAllRenderTargets();
			break;

		case FDX8VID_EVENT_POST_RESET:
			_RebuildAllRenderTargets();
			_RestoreTextureState();
			break;
	}

	return TRUE;
}

#if 1

//
//
//
static BOOL _DetermineRenderTargets( void ) 
{
	const _RenderTargetFormat_t *pRenderTargetFormat;
	D3DFORMAT ColorFmt, DepthFmt;
	u32 i;

	for( i=0; i<FTEX_RENDERTARGET_FMT_COUNT; i++ ) 
	{
		for( pRenderTargetFormat=_apRenderTargetFormatTrial[i]; pRenderTargetFormat->ColorFmt!=D3DFMT_UNKNOWN; pRenderTargetFormat++ ) 
		{
			ColorFmt = pRenderTargetFormat->ColorFmt;
			DepthFmt = pRenderTargetFormat->DepthFmt;

			if( !fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, ColorFmt ) ) 
			{
				// Cannot use this color format as a texture render target...
				continue;
			}

			if( DepthFmt != D3DFMT_UNKNOWN ) 
			{
				if( !fdx8vid_CheckDeviceFormat( D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, DepthFmt ) ) 
				{
					// Cannot use this depth format as a texture depth buffer...
					continue;
				}

				if( !fdx8vid_CheckDepthStencilMatch( ColorFmt, DepthFmt ) ) 
				{
					// Formats are not compatible...
					continue;
				}
			}

			// Formats are compatible...

			_aRenderTargetFormat[i].ColorFmt = ColorFmt;
			_aRenderTargetFormat[i].DepthFmt = DepthFmt;
			break;
		}

		if( pRenderTargetFormat->ColorFmt == D3DFMT_UNKNOWN ) 
		{
			// Render targets are not supported...
			return FALSE;
		}
	}

	// Render targets are supported...

	return TRUE;
}


//
//
//
static void _ComputeDepthStencilBitCount( D3DFORMAT nD3DFormat, u8 *pnDepthBitCount, u8 *pnStencilBitCount ) 
{
	u32 i;

	for( i=0; _aD3DDepthStencilInfo[i].DepthFmt != D3DFMT_UNKNOWN; i++ ) 
	{
		if( _aD3DDepthStencilInfo[i].DepthFmt == nD3DFormat ) 
		{
			if( pnDepthBitCount ) 
			{
				*pnDepthBitCount = _aD3DDepthStencilInfo[i].nDepthBitCount;
			}

			if( pnStencilBitCount ) 
			{
				*pnStencilBitCount = _aD3DDepthStencilInfo[i].nStencilBitCount;
			}

			return;
		}
	}

	if( pnDepthBitCount ) 
	{
		*pnDepthBitCount = 0;
	}

	if( pnStencilBitCount ) 
	{
		*pnStencilBitCount = 0;
	}
}

#else
//
//
//
static BOOL _DetermineRenderTargets( void ) 
{
	D3DSURFACE_DESC D3DSurfaceDesc;

	// Find the backbuffer render target format...
	FDX8_pSurfBack->GetDesc( &D3DSurfaceDesc );
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DSurfaceDesc.Format ) ) 
	{
		_nD3DRenderFormatBB = D3DSurfaceDesc.Format;
	} 
	else 
	{
		// Back buffer format cannot be used as a texture render target...
		_nD3DRenderFormatBB = D3DFMT_UNKNOWN;
	}

	// Try to find a nice 16-bit render target format without alpha...
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_R5G6B5 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_R5G6B5;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_X1R5G5B5 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_X1R5G5B5;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A1R5G5B5 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_A1R5G5B5;
#if FANG_PLATFORM_WIN
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_R8G8B8 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_R8G8B8;
#endif
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_X8R8G8B8 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_X8R8G8B8;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A8R8G8B8 ) ) 
	{
		_nD3DRenderFormat16_NoAlpha = D3DFMT_A8R8G8B8;
	} 
	else 
	{
		// No render target formats at all...
		_nD3DRenderFormat16_NoAlpha = _nD3DRenderFormatBB;
	}

	// Try to find a nice 16-bit render target format with alpha...
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A1R5G5B5 ) ) 
	{
		_nD3DRenderFormat16_WithAlpha = D3DFMT_A1R5G5B5;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A8R8G8B8 ) ) 
	{
		_nD3DRenderFormat16_WithAlpha = D3DFMT_A8R8G8B8;
	} 
	else 
	{
		// No 16-bit render target formats with alpha...
		_nD3DRenderFormat16_WithAlpha = _nD3DRenderFormat16_NoAlpha;
	}

	// Try to find a nice 32-bit render target format without alpha...
#if FANG_PLATFORM_WIN
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_R8G8B8 ) ) 
	{
		_nD3DRenderFormat32_NoAlpha = D3DFMT_R8G8B8;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_X8R8G8B8 ) ) 
	{
		_nD3DRenderFormat32_NoAlpha = D3DFMT_X8R8G8B8;
#else
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_X8R8G8B8 ) ) 
	{
		_nD3DRenderFormat32_NoAlpha = D3DFMT_X8R8G8B8;
#endif
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A8R8G8B8 ) ) 
	{
		_nD3DRenderFormat32_NoAlpha = D3DFMT_A8R8G8B8;
	} 
	else 
	{
		// No 32-bit render target formats...
		_nD3DRenderFormat32_NoAlpha = _nD3DRenderFormat16_NoAlpha;
	}

	// Try to find a nice 32-bit render target format with alpha...
	if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A8R8G8B8 ) ) 
	{
		_nD3DRenderFormat32_WithAlpha = D3DFMT_A8R8G8B8;
	} 
	else if( fdx8vid_CheckDeviceFormat( D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, D3DFMT_A1R5G5B5 ) ) 
	{
		_nD3DRenderFormat32_WithAlpha = D3DFMT_A1R5G5B5;
	} 
	else 
	{
		// No 32-bit render target formats with alpha...
		_nD3DRenderFormat32_WithAlpha = _nD3DRenderFormat32_NoAlpha;
	}

	if( _nD3DRenderFormatBB == D3DFMT_UNKNOWN ) 
	{
		// If back buffer format cannot be used as a texture render target, try using another format...
		_nD3DRenderFormatBB = _nD3DRenderFormat32_NoAlpha;
	}

	if( _nD3DRenderFormatBB == D3DFMT_UNKNOWN ) 
	{
		// If back buffer format *STILL* cannot be used, this card doesn't support texture render targets...
		return FALSE;
	} 
	else
	{
		return TRUE;
	}
}
#endif


//
//
//
static BOOL _DetermineSupportedTexelFormats( void ) 
{
	D3DFORMAT nFormat;
	u32 i, j;

	for( i=0; i<FTEX_FMT_COUNT; i++ ) 
	{
		for( j=0; (nFormat = _aTexelInfoTable[i].pnD3DFormatTable[j])!=D3DFMT_UNKNOWN; j++ ) 
		{
			if( fdx8vid_CheckDeviceFormat( 0, D3DRTYPE_TEXTURE, nFormat ) ) 
			{
				// Found our D3DFORMAT for this Fang texel format...
				_aTexelInfoTable[i].nD3DFormat = nFormat;
				break;
			}

			// If this is an X-Box build, the first format in our table must be supported!
			FASSERT( !FANG_PLATFORM_XB );
		}
		if( nFormat == D3DFMT_UNKNOWN ) 
		{
			// What kind of piece of shit hardware is this?!?!
			return FALSE;
		}
	}

	return TRUE;
}


//
//
//
static void _ClearData( void ) 
{
	u32 i;

	FTex_nMaxTextureWidth = 0;
	FTex_nMaxTextureHeight = 0;
	FTex_nMaxAspect = 0;

	FTex_bMipmaps = FALSE;
	FTex_bRenderTargets = FALSE;
	FTex_bDynamicTextures = FALSE;
	FTex_bDynamicsCanBeLost = FALSE;

	for( i=0; i<FTEX_FMT_COUNT; i++ ) 
	{
		_aTexelInfoTable[i].nD3DFormat = D3DFMT_UNKNOWN;
	}
}


//
//
//
static BOOL _IsD3DFormatDXT( D3DFORMAT nD3DFormat ) 
{
	return (nD3DFormat == D3DFMT_DXT1)
		|| (nD3DFormat == D3DFMT_DXT2)
		|| (nD3DFormat == D3DFMT_DXT3)
		|| (nD3DFormat == D3DFMT_DXT4)
		|| (nD3DFormat == D3DFMT_DXT5);
}


//
//
//
static u32 _ComputeMipmapLevelCount( BOOL bDXT, u32 nTexelsAcross, u32 nTexelsDown ) 
{
	FASSERT( fmath_IsPowerOf2( nTexelsAcross, FALSE ) );
	FASSERT( fmath_IsPowerOf2( nTexelsDown, FALSE ) );
	FASSERT( (bDXT && (nTexelsAcross>=4)) || (!bDXT && (nTexelsAcross>=1)) );
	FASSERT( (bDXT && (nTexelsDown>=4)) || (!bDXT && (nTexelsDown>=1)) );

	if( !FTex_bMipmaps ) 
	{
		// Mipmaps are not supported...
		return 1;
	}

	if( !bDXT ) 
	{
		// Not a DXT texture...
		return (fmath_Log2( FMATH_MAX( nTexelsAcross, nTexelsDown ) ) + 1);
	} 
	else 
	{
		// DXT texture...
		return (fmath_Log2( FMATH_MAX( nTexelsAcross, nTexelsDown ) ) - 1);
	}
}


//
//
//
static u32 _ComputeTextureBytes( FTexDef_t *pTexDef ) 
{
	u32 nLod, nWidth, nHeight, nBitsPerTexel, nBitCount, nMinDim, nLodCount;

	nWidth = pTexDef->TexInfo.nTexelsAcross;
	nHeight = pTexDef->TexInfo.nTexelsDown;
	nLodCount = pTexDef->TexInfo.nLodCount;

	nBitsPerTexel = _aTexelInfoTable[ pTexDef->TexInfo.nTexFmt ].nBitsPerTexel;
	nMinDim = _aTexelInfoTable[ pTexDef->TexInfo.nTexFmt ].nMinDim;

	for( nLod=0, nBitCount=0; nLod<nLodCount; nLod++ ) 
	{
		nBitCount += (nWidth * nHeight * nBitsPerTexel);

		nWidth >>= 1;
		nHeight >>= 1;

		FMATH_CLAMPMIN( nWidth, nMinDim );
		FMATH_CLAMPMIN( nHeight, nMinDim );
	}

	return nBitCount >> 3;
}


//
//
//
static void _ResizeDimensionsIfRequired( FTexFmt_e nTexFmt, u16 *pnWidth, u16 *pnHeight ) 
{
	u32 nRatio, nWidth, nHeight, nMaxWidth, nMaxHeight, nMinDim;

	nWidth = *pnWidth;
	nHeight = *pnHeight;
	nMinDim = _aTexelInfoTable[nTexFmt].nMinDim;

	nMaxWidth = (FTex_nMaxTextureWidth < nMinDim) ? nMinDim : FTex_nMaxTextureWidth;
	nMaxHeight = (FTex_nMaxTextureHeight < nMinDim) ? nMinDim : FTex_nMaxTextureHeight;
	FASSERT( nMaxWidth );
	FASSERT( nMaxHeight );

	// Fixup width...
	nRatio = nWidth / nMaxWidth;
	if( nRatio > 1 ) 
	{
		// Texture is too wide...
		nWidth /= nRatio;
		nHeight /= nRatio;
		FMATH_CLAMPMIN( nWidth, nMinDim );
		FMATH_CLAMPMIN( nHeight, nMinDim );
	}

	// Fixup height...
	nRatio = nHeight / nMaxHeight;
	if( nRatio > 1 ) 
	{
		// Texture is too tall...
		nWidth /= nRatio;
		nHeight /= nRatio;
		FMATH_CLAMPMIN( nWidth, nMinDim );
		FMATH_CLAMPMIN( nHeight, nMinDim );
	}

	// Fixup aspect ratio...
	nRatio = nWidth / nHeight;
	if( nRatio > FTex_nMaxAspect ) 
	{
		// Texture too wide...
		nWidth = nHeight * nRatio;
	} 
	else 
	{
		nRatio = nHeight / nWidth;
		if( nRatio > FTex_nMaxAspect ) 
		{
			// Texture too tall...
			nHeight = nWidth * nRatio;
		}
	}

	*pnWidth = (u16)nWidth;
	*pnHeight = (u16)nHeight;
}

#if FANG_PLATFORM_WIN
//
//
//
static BOOL _ConvertAndCopyTextureImageToD3D( IDirect3DTexture8 *pD3DTexture, FTexFmt_e nSrcTexFmt, u32 nDstLodCount, u32 nSrcWidth, u32 nSrcHeight, const void *pSrcImage ) 
{
	IDirect3DSurface8 *pSurface;
	u32 i, nBytesPerColumn;
	D3DFORMAT nSrcD3DFormat;
	RECT SrcRect;
	const u8 *pnSrcImage;

	if( pSrcImage == NULL ) 
	{
		return TRUE;
	}

	pnSrcImage = (const u8 *)pSrcImage;
	nSrcD3DFormat = _aTexelInfoTable[nSrcTexFmt].nSrcD3DFormat;

	if( _aTexelInfoTable[nSrcTexFmt].nDXT ) 
	{
		// DXT texture...
		nBytesPerColumn = _aTexelInfoTable[nSrcTexFmt].nBitsPerTexel >> 1;
	} 
	else 
	{
		// Non-DXT texture...
		nBytesPerColumn = _aTexelInfoTable[nSrcTexFmt].nBitsPerTexel >> 3;
	}

	SrcRect.left = 0;
	SrcRect.top = 0;

	for( i=0; i<nDstLodCount; i++ ) 
	{
		if( FAILED( pD3DTexture->GetSurfaceLevel( i, &pSurface ) ) ) 
		{
			// Could not get surface...
			return FALSE;
		}

		SrcRect.right = nSrcWidth;
		SrcRect.bottom = nSrcHeight;

		if( FAILED( D3DXLoadSurfaceFromMemory(
							pSurface,
							NULL,
							NULL,
							pnSrcImage,
							nSrcD3DFormat,
							nBytesPerColumn * nSrcWidth,
							NULL,
							&SrcRect,
							D3DX_DEFAULT,
							(D3DCOLOR)0
						) ) ) 
		{
			// Could not load the image into the D3D texture...
			pSurface->Release();
			return FALSE;
		}

		pSurface->Release();

		// Point to start of next source mipmap image...
		pnSrcImage += ((nSrcWidth * nSrcHeight * _aTexelInfoTable[nSrcTexFmt].nBitsPerTexel) >> 3);

		// Compute dimensions of next source mipmap image...
		nSrcWidth >>= 1;
		nSrcHeight >>= 1;
		FMATH_CLAMPMIN( nSrcWidth, _aTexelInfoTable[nSrcTexFmt].nMinDim );
		FMATH_CLAMPMIN( nSrcHeight, _aTexelInfoTable[nSrcTexFmt].nMinDim );
	}

	return TRUE;
}


//
//
//
static BOOL _CopyTextureImageToD3D( FTexData_t *pTexData, const void *pSrcImage ) 
{
	FTexInfo_t *pTexInfo;
	u32 i, nSrcWidth, nSrcHeight;
	const u8 *pnSrcImage;

	if( pSrcImage == NULL ) 
	{
		return TRUE;
	}

	pTexInfo = &pTexData->TexDef.TexInfo;

	FASSERT( pTexData->nD3DLodCount <= pTexInfo->nLodCount );

	if( _aTexelInfoTable[pTexInfo->nTexFmt].nSrcD3DFormat == pTexData->nD3DFormatColor ) 
	{
		// Source and destination texel formats are the same...

		nSrcWidth = pTexInfo->nTexelsAcross;
		nSrcHeight = pTexInfo->nTexelsDown;

		pnSrcImage = (const u8 *)pSrcImage;

		for( i=0; i<pTexInfo->nLodCount; i++ ) 
		{
			if( nSrcWidth==pTexData->nD3DWidth && nSrcHeight==pTexData->nD3DHeight ) 
			{
				// Woohoo! We can do a fast copy into texture memory...

				return _CopyImageToMipmap(
							pTexData,
							pnSrcImage,
							(FTexFmt_e)pTexInfo->nTexFmt,
							pTexData->nD3DLodCount,
							nSrcWidth,
							nSrcHeight
						);
			}

			// Point to start of next source mipmap image...
			pnSrcImage += ((nSrcWidth * nSrcHeight * _aTexelInfoTable[pTexInfo->nTexFmt].nBitsPerTexel) >> 3);

			// Compute dimensions of next source mipmap image...
			nSrcWidth >>= 1;
			nSrcHeight >>= 1;
			FMATH_CLAMPMIN( nSrcWidth, _aTexelInfoTable[pTexInfo->nTexFmt].nMinDim );
			FMATH_CLAMPMIN( nSrcHeight, _aTexelInfoTable[pTexInfo->nTexFmt].nMinDim );
		}
	}

	// We must convert the texture. This is slower, but necessary because
	// the source texture is stored in a format that's not compatible with
	// this particular 3D adapter.

	return _ConvertAndCopyTextureImageToD3D(
				pTexData->pD3DTexture,
				(FTexFmt_e)pTexInfo->nTexFmt,
				pTexData->nD3DLodCount,
				pTexInfo->nTexelsAcross,
				pTexInfo->nTexelsDown,
				pSrcImage
			);
}


//
//
//
static u32 _ComputeMipmapBytes( FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight ) 
{
	u32 i, nBytes, nBitsPerTexel;

	FASSERT( nTexFmt>=0 && nTexFmt<FTEX_FMT_COUNT );
	FASSERT( nLodCount > 0 );
	FASSERT( fmath_IsPowerOf2( nWidth, FALSE ) );
	FASSERT( fmath_IsPowerOf2( nHeight, FALSE ) );
	FASSERT( nLodCount <= _ComputeMipmapLevelCount( (_aTexelInfoTable[nTexFmt].nDXT != 0), nWidth, nHeight ) );

	nBitsPerTexel = _aTexelInfoTable[nTexFmt].nBitsPerTexel;
	nBytes = 0;

	for( i=0; i<nLodCount; i++ ) 
	{
		nBytes += ((nWidth * nHeight * nBitsPerTexel) >> 3);

		nWidth >>= 1;
		nHeight >>= 1;
		FMATH_CLAMPMIN( nWidth, _aTexelInfoTable[nTexFmt].nMinDim );
		FMATH_CLAMPMIN( nHeight, _aTexelInfoTable[nTexFmt].nMinDim );
	}

	return nBytes;
}
#endif

#if FANG_PLATFORM_XB
//
//
//
static BOOL _CopyTextureImageToD3D( FTexData_t *pTexData, const void *pSrcImage ) 
{
	FTexInfo_t *pTexInfo;

	if( pSrcImage == NULL ) 
	{
		return TRUE;
	}

	pTexInfo = &pTexData->TexDef.TexInfo;

	FASSERT( pTexData->nD3DLodCount == pTexInfo->nLodCount );
	FASSERT( pTexData->nD3DWidth == pTexInfo->nTexelsAcross );
	FASSERT( pTexData->nD3DHeight == pTexInfo->nTexelsDown );

	return _CopyImageToMipmap( pTexData, pSrcImage, (FTexFmt_e)pTexInfo->nTexFmt, pTexInfo->nLodCount, pTexInfo->nTexelsAcross, pTexInfo->nTexelsDown );
}
#endif

//
//
//
static BOOL _CreateD3DTextureAndCopyImage( FTexData_t *pTexData, const void *pSrcImage ) 
{
	if( FAILED( FDX8_pDev->CreateTexture(
								pTexData->nD3DWidth,
								pTexData->nD3DHeight,
								pTexData->nD3DLodCount,
								0,
								pTexData->nD3DFormatColor,
								D3DPOOL_MANAGED,
								&pTexData->pD3DTexture
							) ) ) 
	{
		// Could not create texture...
		return FALSE;
	}

	// D3D8 texture created!

	if( !_CopyTextureImageToD3D( pTexData, pSrcImage ) ) 
	{
		// Could not copy data into texture surface...
		pTexData->pD3DTexture->Release();
		return FALSE;
	}

	// Success!

	return TRUE;
}


//
//
//
static BOOL _CopyImageToMipmap( FTexData_t *pTexData, const void *pSrcImage, FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight ) 
{
	u32 i;

	for( i=0; i<nLodCount; i++ ) 
	{
		if( !_CopyImageToTexture( pTexData, pSrcImage, nTexFmt, i, nWidth, nHeight ) ) 
		{
			// Failed to copy the image to the texture level...
			return FALSE;
		}

		pSrcImage = (void *)( (u32)pSrcImage + ((nWidth * nHeight * _aTexelInfoTable[nTexFmt].nBitsPerTexel)>>3) );

		nWidth >>= 1;
		nHeight >>= 1;
		FMATH_CLAMPMIN( nWidth, _aTexelInfoTable[nTexFmt].nMinDim );
		FMATH_CLAMPMIN( nHeight, _aTexelInfoTable[nTexFmt].nMinDim );
	}

	return TRUE;
}

#if FANG_PLATFORM_WIN
//
//
//
static BOOL _CopyMipmapToImage( IDirect3DTexture8 *pD3DTexture, void *pDstImage, FTexFmt_e nTexFmt, u32 nLodCount, u32 nWidth, u32 nHeight ) 
{
	u32 i;

	for( i=0; i<nLodCount; i++ ) 
	{
		if( !_CopyTextureToImage( pD3DTexture, pDstImage, nTexFmt, i, nWidth, nHeight ) ) 
		{
			// Failed to copy the texture level to the image...
			return FALSE;
		}

		pDstImage = (void *)( (u32)pDstImage + nWidth*nHeight * (_aTexelInfoTable[nTexFmt].nBitsPerTexel>>3) );

		nWidth >>= 1;
		nHeight >>= 1;
		FMATH_CLAMPMIN( nWidth, _aTexelInfoTable[nTexFmt].nMinDim );
		FMATH_CLAMPMIN( nHeight, _aTexelInfoTable[nTexFmt].nMinDim );
	}

	return TRUE;
}


//
//
//
static BOOL _CopyTextureToImage( IDirect3DTexture8 *pD3DTexture, void *pDstImage, FTexFmt_e nTexFmt, u32 nLod, u32 nWidth, u32 nHeight ) 
{
	D3DLOCKED_RECT LockedRect;

	if( FAILED( pD3DTexture->LockRect( nLod, &LockedRect, NULL, _nD3DSysLockFlag | D3DLOCK_READONLY ) ) ) 
	{
		// Failed to lock the level...
		return FALSE;
	}

	// Lock successful...

	if( _aTexelInfoTable[nTexFmt].nDXT == 0 ) 
	{
		// Non-DXT texture...

		switch( _aTexelInfoTable[nTexFmt].nBitsPerTexel ) 
		{
			case 16:
				// 16-bit copy...
				FASSERT( !(LockedRect.Pitch & 1) );
				_CopyPitchedToImage16( (const u16 *)LockedRect.pBits, (u16 *)pDstImage, LockedRect.Pitch>>1, nWidth, nHeight );
				break;

			case 32:
				// 32-bit copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				_CopyPitchedToImage32( (const u32 *)LockedRect.pBits, (u32 *)pDstImage, LockedRect.Pitch>>2, nWidth, nHeight );
				break;

			default:
				FASSERT_NOW;
		}
	} 
	else 
	{
		// DXT texture...

		switch( _aTexelInfoTable[nTexFmt].nDXT ) 
		{
			case 1:
				// DXT1 copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				FASSERT( !(nWidth & 1) );
				_CopyPitchedToImage32( (const u32 *)LockedRect.pBits, (u32 *)pDstImage, LockedRect.Pitch>>2, nWidth>>1, nHeight>>2 );
				break;

			case 3:
			case 5:
				// DXT3 or DXT5 copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				_CopyPitchedToImage32( (const u32 *)LockedRect.pBits, (u32 *)pDstImage, LockedRect.Pitch>>2, nWidth, nHeight>>2 );
				break;

			default:
				FASSERT_NOW;
		}
	}

	pD3DTexture->UnlockRect( nLod );

	return TRUE;
}


//
//
//
static void _CopyPitchedToImage16( const u16 *pnSrc, u16 *pnDst, u32 nPitch16, u32 nShortsAcross, u32 nTexelsDown ) 
{
	const u16 *pnSrcLeftEdge;
	u32 i, j;

	pnSrcLeftEdge = pnSrc;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<nShortsAcross; i++ ) 
		{
			*pnDst = *pnSrc;
			pnSrc++;
			pnDst++;
		}

		pnSrcLeftEdge += nPitch16;
		pnSrc = pnSrcLeftEdge;
	}
}


//
//
//
static void _CopyPitchedToImage32( const u32 *pnSrc, u32 *pnDst, u32 nPitch32, u32 nWordsAcross, u32 nTexelsDown ) 
{
	const u32 *pnSrcLeftEdge;
	u32 i, j;

	pnSrcLeftEdge = pnSrc;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<nWordsAcross; i++ ) 
		{
			*pnDst = *pnSrc;
			pnSrc++;
			pnDst++;
		}

		pnSrcLeftEdge += nPitch32;
		pnSrc = pnSrcLeftEdge;
	}
}
#endif


//
//
//
BOOL _CopyImageToTexture( FTexData_t *pTexData, const void *pSrcImage, FTexFmt_e nTexFmt, u32 nLod, u32 nWidth, u32 nHeight ) 
{
	D3DLOCKED_RECT LockedRect;

	if ( FAILED( pTexData->pD3DTexture->LockRect( nLod, &LockedRect, NULL, _nD3DSysLockFlag ) ) ) 
	{
		// Failed to lock the level...
		return FALSE;
	}

	// Lock successful...

#if FANG_PLATFORM_XB
	if( _aTexelInfoTable[nTexFmt].nDXT == 0 ) 
	{
		// Non-DXT texture...

		XGSwizzleRect( pSrcImage, 0, NULL, LockedRect.pBits, nWidth, nHeight, NULL, _aTexelInfoTable[nTexFmt].nBitsPerTexel>>3 );
	} 
	else 
	{
		// DXT texture...

		switch( _aTexelInfoTable[nTexFmt].nDXT ) {
		case 1:
			// DXT1 copy...
			FASSERT( !(LockedRect.Pitch & 3) );
			FASSERT( !(nWidth & 1) );
			_CopyImageToPitched32( (const u32 *)pSrcImage, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth>>1, nHeight>>2 );
			break;

		case 3:
		case 5:
			// DXT3 or DXT5 copy...
			FASSERT( !(LockedRect.Pitch & 3) );
			_CopyImageToPitched32( (const u32 *)pSrcImage, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth, nHeight>>2 );
			break;

		default:
			FASSERT_NOW;
		}
	}
#else
	if ( _aTexelInfoTable[nTexFmt].nDXT == 0 ) 
	{
		// Non-DXT texture...

		FMemFrame_t hMemFrame = fmem_GetFrame();
		u32 nWorkingMemSize = (nWidth * nHeight * _aTexelInfoTable[nTexFmt].nBitsPerTexel>>3) + 16;
		u8 *pTempMemory = (u8 *)fmem_Alloc( nWorkingMemSize );
		if ( !pTempMemory )
		{
			return FALSE;
		}
		fang_MemZero( pTempMemory, nWorkingMemSize );
		u8 *pAlignedTempMemory = (u8 *)FMATH_BYTE_ALIGN_UP( (u32)pTempMemory, 16 );

		switch( _aTexelInfoTable[nTexFmt].nBitsPerTexel ) 
		{
			case 16:
				// 16-bit copy...
				FASSERT( !(LockedRect.Pitch & 1) );
				if ( pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_LOAD_IN_PLACE )
				{
					XGUnswizzleRect( pSrcImage, nWidth, nHeight, NULL, pAlignedTempMemory, nWidth * 2, NULL, 2 );
					_CopyImageToPitched16( (const u16 *)pAlignedTempMemory, (u16 *)LockedRect.pBits, LockedRect.Pitch>>1, nWidth, nHeight );
				}
				else
				{
					_CopyImageToPitched16( (const u16 *)pSrcImage, (u16 *)LockedRect.pBits, LockedRect.Pitch>>1, nWidth, nHeight );
				}
				break;

			case 32:
				// 32-bit copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				if ( pTexData->TexDef.TexInfo.nFlags & FTEX_FLAG_LOAD_IN_PLACE )
				{
					XGUnswizzleRect( pSrcImage, nWidth, nHeight, NULL, pAlignedTempMemory, 0, NULL, 4 );
					_CopyImageToPitched32( (const u32 *)pAlignedTempMemory, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth, nHeight );
				}
				else
				{
					_CopyImageToPitched32( (const u32 *)pSrcImage, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth, nHeight );
				}
				break;

			default:
				FASSERT_NOW;
		}

		fmem_ReleaseFrame( hMemFrame );
	} 
	else 
	{
		// DXT texture...

		switch( _aTexelInfoTable[nTexFmt].nDXT ) 
		{
			case 1:
				// DXT1 copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				FASSERT( !(nWidth & 1) );
				_CopyImageToPitched32( (const u32 *)pSrcImage, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth>>1, nHeight>>2 );
				break;

			case 3:
			case 5:
				// DXT3 or DXT5 copy...
				FASSERT( !(LockedRect.Pitch & 3) );
				_CopyImageToPitched32( (const u32 *)pSrcImage, (u32 *)LockedRect.pBits, LockedRect.Pitch>>2, nWidth, nHeight>>2 );
				break;

			default:
				FASSERT_NOW;
		}
	}
#endif

	pTexData->pD3DTexture->UnlockRect( nLod );

	return TRUE;
}


//
//
//
static void _CopyImageToPitched16( const u16 *pnSrc, u16 *pnDst, u32 nPitch16, u32 nShortsAcross, u32 nTexelsDown ) 
{
	u16 *pnDstLeftEdge;
	u32 i, j;

	pnDstLeftEdge = pnDst;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<nShortsAcross; i++ ) 
		{
			*pnDst = *pnSrc;
			pnSrc++;
			pnDst++;
		}

		pnDstLeftEdge += nPitch16;
		pnDst = pnDstLeftEdge;
	}
}


#if 1
//
//
//
static void _CopyImageToPitched32( const u32 *pnSrc, u32 *pnDst, u32 nPitch32, u32 nWordsAcross, u32 nTexelsDown ) 
{
	u32 *pnDstLeftEdge, i, j;

	pnDstLeftEdge = pnDst;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<nWordsAcross; i++ ) 
		{
			*pnDst = *pnSrc;
			pnSrc++;
			pnDst++;
		}

		pnDstLeftEdge += nPitch32;
		pnDst = pnDstLeftEdge;
	}
}

#else
//
//
//
static void _CopyImageToPitched32( const u32 *pnSrc, u32 *pnDst, u32 nPitch32, u32 nWordsAcross, u32 nTexelsDown ) 
{
	u32 *pnDstLeftEdge, i, j;
	const u32 *pnSavedSrc = pnSrc;
	u8 *pnAlphaMap;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<(nWordsAcross>>2); i++ ) 
		{
			pnAlphaMap = (u8 *)pnSrc;

			DEVPRINTF(
				"d=%u, a0=%2x, a1=%2x, a2=%2x, a3=%2x, a4=%2x, a5=%2x, a6=%2x, a7=%2x\n",
				nTexelsDown*4,
				pnAlphaMap[0],
				pnAlphaMap[1],
				pnAlphaMap[2],
				pnAlphaMap[3],
				pnAlphaMap[4],
				pnAlphaMap[5],
				pnAlphaMap[6],
				pnAlphaMap[7]
			);

			pnSrc += 4;
		}
	}

	pnSrc = pnSavedSrc;

	pnDstLeftEdge = pnDst;

	for( j=0; j<nTexelsDown; j++ ) 
	{
		for( i=0; i<nWordsAcross; i++ ) 
		{
			*pnDst = *pnSrc;
			pnSrc++;
			pnDst++;
		}

		pnDstLeftEdge += nPitch32;
		pnDst = pnDstLeftEdge;
	}
}
#endif


//
//
//
static FTexFmt_e _ConvertD3DFormatToTexFmt( D3DFORMAT nD3DFormat ) 
{
	FTexFmt_e nTexFmt;

	switch( nD3DFormat ) 
	{
		case D3DFMT_A8R8G8B8:
			nTexFmt = FTEX_FMT_A8R8G8B8;
			break;

		case D3DFMT_X8R8G8B8:
			nTexFmt = FTEX_FMT_X8R8G8B8;
			break;

		case D3DFMT_A4R4G4B4:
			nTexFmt = FTEX_FMT_A4R4G4B4;
			break;

		case D3DFMT_A1R5G5B5:
			nTexFmt = FTEX_FMT_A1R5G5B5;
			break;

		case D3DFMT_X1R5G5B5:
			nTexFmt = FTEX_FMT_X1R5G5B5;
			break;

		case D3DFMT_R5G6B5:
			nTexFmt = FTEX_FMT_R5G6B5;
			break;

		case D3DFMT_DXT1:
			nTexFmt = FTEX_FMT_DXT1;
			break;

		case D3DFMT_DXT3:
			nTexFmt = FTEX_FMT_DXT3;
			break;

		case D3DFMT_DXT5:
			nTexFmt = FTEX_FMT_DXT5;
			break;
#if !FANG_PLATFORM_XB
		case D3DFMT_X8L8V8U8:
			nTexFmt = FTEX_FMT_X8L8V8U8;
			break;
#endif

#if FANG_PLATFORM_XB
		case D3DFMT_LIN_A8R8G8B8:
			nTexFmt = FTEX_FMT_A8R8G8B8;
			break;

		case D3DFMT_LIN_X8R8G8B8:
			nTexFmt = FTEX_FMT_X8R8G8B8;
			break;

		case D3DFMT_LIN_A4R4G4B4:
			nTexFmt = FTEX_FMT_A4R4G4B4;
			break;

		case D3DFMT_LIN_A1R5G5B5:
			nTexFmt = FTEX_FMT_A1R5G5B5;
			break;

		case D3DFMT_LIN_X1R5G5B5:
			nTexFmt = FTEX_FMT_X1R5G5B5;
			break;

		case D3DFMT_LIN_R5G6B5:
			nTexFmt = FTEX_FMT_R5G6B5;
			break;
#endif

		default:
			FASSERT_NOW;
	}

	return nTexFmt;
}


//
//
//
static void _RenderTexture_ViewportCallback(FViewport_t *pView)
{
	FTexDef_t *pTexDef = _RTpTexDef;

	switch (pView->nType)
	{
		case FVIEWPORT_TYPE_PERSPECTIVE:
			fviewport_InitPersp( _TexViewport, pView->fHalfFOVX, pView->fHalfFOVY, pView->fNearZ, pView->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
		case FVIEWPORT_TYPE_ORTHO2D:
			fviewport_InitOrtho2D( _TexViewport, pView->fNearZ, pView->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
        case FVIEWPORT_TYPE_ORTHO3D:
			fviewport_InitOrtho3D( _TexViewport, pView->fNearZ, pView->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
	};

	_pActiveViewport = pView;

	fviewport_SetCallback(NULL);
	fviewport_SetActive(_TexViewport);
	fviewport_SetCallback(_RenderTexture_ViewportCallback);
}

//FULLSCREEN
#if 1
//
//
//
BOOL fdx8tex_GetCubeMapParam(u8& nCubeView)
{
	nCubeView = _nCubeView;

	return (_bCubeFace);
}


//
//
//
BOOL CFTexInst::BeginRender_FullScreen()
{
#if !FANG_PLATFORM_XB
	if (GetFlags()&CFTexInst::FLAG_CUBEMAP)
	{
		return FALSE;
	}
#endif
	_pActiveViewport = fviewport_GetActive_Absolute();
	if( !_pActiveViewport ) {
		// _pActiveViewport can sometimes be NULL between levels - Starich
		return FALSE;
	}

	// Get Current RenderTarget and Save (will restore later).
	// Swap Buffers
	m_pTexDef = &m_pTexBuffer[m_nBufferIdx]->TexDef;
	if (GetFlags() & CFTexInst::FLAG_FLUSH_RENDERTARGET)
	{
		ClearFlag(CFTexInst::FLAG_FLUSH_RENDERTARGET);
	}
	else if ( !(GetFlags()&CFTexInst::FLAG_CUBEMAP) && !(GetFlags()&CFTexInst::FLAG_FORCENOLAG) )
	{
		m_nBufferIdx = (m_nBufferIdx + 1)%2;
	}
	// Set Render Target.
	LPDIRECT3DTEXTURE8 pTex = m_pTexBuffer[m_nBufferIdx]->pD3DTexture;
	LPDIRECT3DSURFACE8 pSurface, pDepth;
	pDepth = m_pTexBuffer[m_nBufferIdx]->pD3DDepthStencil;

	if (pDepth && pTex)
	{
		if (GetFlags()&CFTexInst::FLAG_CUBEMAP)
		{
			LPDIRECT3DCUBETEXTURE8 pCubeTex = (LPDIRECT3DCUBETEXTURE8)pTex;
			if ( SUCCEEDED(pCubeTex->GetCubeMapSurface((D3DCUBEMAP_FACES)_nFace, 0, &pSurface)) )
			{
				_nCubeView = _nFace;
				_nFace = (_nFace+1)%6;
				_bCubeFace = TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			if ( SUCCEEDED(pTex->GetSurfaceLevel(0, &pSurface)) )
			{
				_bCubeFace = FALSE;
			}
			else
			{
				return FALSE;
			}
		}
		if ( SUCCEEDED(FDX8_pDev->SetRenderTarget(pSurface, pDepth)) )
		{
			pSurface->Release();
		}
		else 
		{
			return FALSE;
		}
	}

	FTexDef_t *pTexDef = GetTexDef();
	_RTpTexDef = pTexDef;

	switch (_pActiveViewport->nType)
	{
		case FVIEWPORT_TYPE_PERSPECTIVE:
			fviewport_InitPersp( _TexViewport, _pActiveViewport->fHalfFOVX, _pActiveViewport->fHalfFOVY, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
		case FVIEWPORT_TYPE_ORTHO2D:
			fviewport_InitOrtho2D( _TexViewport, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
        case FVIEWPORT_TYPE_ORTHO3D:
			fviewport_InitOrtho3D( _TexViewport, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
	};

	fviewport_SetCallback(NULL);
	fviewport_SetActive(_TexViewport);
	fviewport_SetCallback(_RenderTexture_ViewportCallback);

	return TRUE;
}


//
//
//
void CFTexInst::EndRender_FullScreen(BOOL bAutoClearRGBA, BOOL bAutoClearDepth)
{
	FDX8_pDev->SetRenderTarget(_pSurface, _pDepth);
	
	//Restore Viewport
	fviewport_SetCallback(NULL);
	fviewport_SetActive(_pActiveViewport);
}


//
// SIDEBAR
//
BOOL CFTexInst::BeginRender()
{
	_bCubeFace = FALSE;
	// Get Current RenderTarget and Save (will restore later).
	// Swap Buffers
	m_pTexDef->pTexData = m_pTexBuffer[m_nBufferIdx];
	if (GetFlags() & CFTexInst::FLAG_FLUSH_RENDERTARGET)
	{
		ClearFlag(CFTexInst::FLAG_FLUSH_RENDERTARGET);
	}
	else
	{
		if ( !(GetFlags()&CFTexInst::FLAG_FORCENOLAG) )
		{
			m_nBufferIdx = (m_nBufferIdx + 1)%2;
		}
	}
	// Set Render Target.
	LPDIRECT3DTEXTURE8 pTex = m_pTexBuffer[m_nBufferIdx]->pD3DTexture;
	LPDIRECT3DSURFACE8 pSurface, pDepth;
	pDepth = m_pTexBuffer[m_nBufferIdx]->pD3DDepthStencil;

	if (pDepth && pTex)
	{
		if ( FAILED(pTex->GetSurfaceLevel(0, &pSurface)) )
		{
			return FALSE;
		}
		if (SUCCEEDED(FDX8_pDev->SetRenderTarget(pSurface, pDepth)))
		{
			pSurface->Release();
		}
		else
		{
			return FALSE;
		}
	}

	FTexDef_t *pTexDef = GetTexDef();
	_RTpTexDef = pTexDef;

	_pActiveViewport = fviewport_GetActive_Absolute();

	switch (_pActiveViewport->nType)
	{
		case FVIEWPORT_TYPE_PERSPECTIVE:
			fviewport_InitPersp( _TexViewport, _pActiveViewport->fHalfFOVX, _pActiveViewport->fHalfFOVY, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
		case FVIEWPORT_TYPE_ORTHO2D:
			fviewport_InitOrtho2D( _TexViewport, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
		case FVIEWPORT_TYPE_ORTHO3D:
			fviewport_InitOrtho3D( _TexViewport, _pActiveViewport->fNearZ, _pActiveViewport->fFarZ, 0, 0, pTexDef->TexInfo.nTexelsAcross, pTexDef->TexInfo.nTexelsDown );
			break;
	};

	fviewport_SetCallback(NULL);
	fviewport_SetActive(_TexViewport);
	fviewport_SetCallback(_RenderTexture_ViewportCallback);

	return TRUE;
}


//
//
//
void CFTexInst::EndRender(BOOL bAutoClearRGBA, BOOL bAutoClearDepth)
{
	FDX8_pDev->SetRenderTarget(_pSurface, _pDepth);

	//Restore Viewport
	fviewport_SetCallback(NULL);
	fviewport_SetActive(_pActiveViewport);
}


//
//
//
BOOL ftex_AddRenderTarget(CFTexInst *pTexInst, ftex_RenderTarget_Callback pCallback, BOOL bRenderWorld, u32 nMaxRenderFreq, BOOL bAutoClearColor, BOOL bAutoClearDepth, void *pUserData, BOOL bAllowLiquid, BOOL bForceNoLag)
{
	BOOL ret=FALSE;
	u32 n = _nNumRenderTargets;
	if (_nNumRenderTargets < MAX_RENDERTARGETS)
	{
		ret = TRUE;
		_nNumRenderTargets++;

		_aRenderTargets[n].pTexInst = pTexInst;
		_aRenderTargets[n].pCallback = pCallback;
		_aRenderTargets[n].bRenderWorld = bRenderWorld;
		if (nMaxRenderFreq > 0)
		{
			_aRenderTargets[n].fOOMaxRenderFreq = 1.0f/(f32)nMaxRenderFreq;
		}
		else
		{
			_aRenderTargets[n].fOOMaxRenderFreq = 0.0f;
		}
		_aRenderTargets[n].bAutoClearRGBA = bAutoClearColor;
		_aRenderTargets[n].bAutoClearDepth = bAutoClearDepth;
		if (bForceNoLag)
		{
			pTexInst->SetFlag(CFTexInst::FLAG_FORCENOLAG);
		}

		_aRenderTargets[n].bAllowLiquidRender = bAllowLiquid;

		_aRenderTargets[n].uStagger = 0;

		_aRenderTargets[n].pUserData = pUserData;
		ftex_ActivateRenderTarget(pTexInst, TRUE);
	}
	return (ret);
}

void ftex_StaggerRenderTarget(u8 nStaggerID)
{
	_aRenderTargets[_nNumRenderTargets-1].uStagger = nStaggerID;
}

//
//
//
void ftex_ActivateRenderTarget(CFTexInst *pTexInst, BOOL bActive)
{
	FTEX_RENDERTARGET *pTarget;
	u32 i;
	for (i=0; i<_nNumRenderTargets; i++)
	{
		pTarget = &_aRenderTargets[i];
		
		if (pTarget->pTexInst == pTexInst)
		{
			if (pTarget->bActive != bActive)
			{
				pTarget->bActive = bActive;
				if (bActive == TRUE)
				{
					ftex_FlushRenderTarget(pTexInst);
					pTarget->fCurrentRenderTime = 0.0f;
				}
			}
			return;
		}
	}
}


//
//
//
void ftex_SetUserData(CFTexInst *pTexInst, void *pUserData)
{
	FTEX_RENDERTARGET *pTarget;
	u32 i;
	for (i=0; i<_nNumRenderTargets; i++)
	{
		pTarget = &_aRenderTargets[i];
		
		if (pTarget->pTexInst == pTexInst)
		{
			pTarget->pUserData = pUserData;
			return;
		}
	}
}

void ftex_RenderTarget_SetAlphaTex(CFTexInst *pTexInst, CFTexInst *pAlphaTex)
{
}

//
//
//
BOOL ftex_HandleRenderTargets( void )
{
#if !FTEX_HANDLE_RENDERTARGETS
	return TRUE;
#endif
	u32 i;
	BOOL bRestoreRenderTarget=FALSE;
	u8 auStaggerRender[8]={0,0,0,0,0,0,0,0};
	_bRenderWorld=TRUE;
	FTEX_RENDERTARGET *pTarget;

	FVis_bInRenderTarget = TRUE;

	if (_nNumRenderTargets > 0)
	{
		FDX8_pDev->GetBackBuffer(0, D3DBACKBUFFER_TYPE_MONO, &_pSurface);
		FDX8_pDev->GetDepthStencilSurface(&_pDepth);

		if (!_TexViewport)
		{
			_TexViewport = fviewport_Create();
		}

		for (i=0; i<_nNumRenderTargets; i++)
		{
			pTarget = &_aRenderTargets[i];
			if (pTarget->bActive)
			{
				if (pTarget->fCurrentRenderTime == 0.0f)
				{
					if (pTarget->pTexInst->GetFlags() & CFTexInst::FLAG_FULLSCREEN)
					{
						fviewport_SetCallback(_RenderTexture_ViewportCallback);

						_nFace = pTarget->nFace;
						if ( pTarget->pTexInst->BeginRender_FullScreen() )
						{
							fvis_ToggleLiquidInRenderTarget( pTarget->bAllowLiquidRender );
							pTarget->pCallback(pTarget->pUserData);
							fvis_ToggleLiquidInRenderTarget( FALSE );
							pTarget->pTexInst->EndRender_FullScreen(pTarget->bAutoClearRGBA, pTarget->bAutoClearDepth);
                            pTarget->nFace = _nFace;

							bRestoreRenderTarget = TRUE;
						}
					}
					else
					{
						if ( pTarget->uStagger && !auStaggerRender[pTarget->uStagger] )
						{
							auStaggerRender[pTarget->uStagger] = 1;
						}
						else if ( pTarget->uStagger && auStaggerRender[pTarget->uStagger] )
						{
							continue;
						}
						fviewport_SetCallback(_RenderTexture_ViewportCallback);

						if ( pTarget->pTexInst->BeginRender() )
						{
							fvis_ToggleLiquidInRenderTarget( pTarget->bAllowLiquidRender );
							pTarget->pCallback(pTarget->pUserData);
							fvis_ToggleLiquidInRenderTarget( FALSE );
							pTarget->pTexInst->EndRender(pTarget->bAutoClearRGBA, pTarget->bAutoClearDepth);

							bRestoreRenderTarget = TRUE;
						}
					}

					if (!pTarget->bRenderWorld) _bRenderWorld=FALSE;
					pTarget->fCurrentRenderTime = pTarget->fOOMaxRenderFreq;
				}
				else
				{
					pTarget->fCurrentRenderTime-=FLoop_fPreviousLoopSecs;
			
					if (pTarget->fCurrentRenderTime < 0.0f) pTarget->fCurrentRenderTime = 0.0f;
				}
			}
		}

		fviewport_SetCallback(NULL);
		/*if (bRestoreRenderTarget)
		{
			FDX8_pDev->SetRenderTarget(_pSurface, _pDepth);
		}
		*/
		_pSurface->Release();
		_pDepth->Release();
	}
	fsh_ResetSReflect();

	FVis_bInRenderTarget = FALSE;

	return (_bRenderWorld);
}


//
//
//
FINLINE void ftex_FlushRenderTarget(CFTexInst *pTexInst)
{
	pTexInst->SetFlag( CFTexInst::FLAG_FLUSH_RENDERTARGET );
}


//
//
//
BOOL ftex_GetRenderWorldFlag( void )
{ 
	return (_bRenderWorld); 
}


//
//
//
void ftex_ClearRenderTargets( void )
{
	u32 i;
	FTexData_t *pTexDef;
	for (i=0; i<_nNumRenderTargets; i++)
	{
		if ( !(_aRenderTargets[i].pTexInst->GetFlags()&CFTexInst::FLAG_NORELEASE) )
		{
			pTexDef = _aRenderTargets[i].pTexInst->GetTexBuffer(0);
			if (pTexDef)
			{
				if (pTexDef->pD3DTexture) 
				{
					pTexDef->pD3DTexture->Release();
				}
				if (pTexDef->pD3DDepthStencil)
				{
					pTexDef->pD3DDepthStencil->Release();
				}
			}

			if ( !(_aRenderTargets[i].pTexInst->GetFlags()&CFTexInst::FLAG_FORCENOLAG) )
			{
				pTexDef = _aRenderTargets[i].pTexInst->GetTexBuffer(1);
				if (pTexDef)
				{
					if (pTexDef->pD3DTexture) 
					{
						pTexDef->pD3DTexture->Release();
					}
				}
			}
		}
	}

	_nNumRenderTargets = 0;
	_bRenderWorld=TRUE;
	_TexViewport = NULL;

	fsh_ClearSReflectTargets();
	//fsh_ResetFullScrRenderTarget();
}
#endif
//End RenderTarget API
