;Basic Vertex Lighting: 1 Directional + 1 Point Light

#include "fdx8vshader_const.h"

;Need to pass in the following:
; Point Light Color*MaterialColor	[CV_LIGHT1_DIFFUSE]
;			  Ambient				[CV_LIGHT1_AMBIENT]
;			  Position (xyz)		[CV_LIGHT1_POSITION]
;			  Attenuation (a0,a1,a2)[CV_LIGHT1_ATTENUATION]
; Directional Light Clr*Material	[CV_LIGHT2_DIFFUSE]
;			  Direction				[CV_LIGHT2_DIRECTION]

vs.1.0

#define V_POS v0
#define V_BLEND v1
#define V_NORMAL v2
#define V_COLOR v3
#define V_TEX0 v4
#define V_TEX1 v5
#define V_TEX2 v6
#define V_TEX3 v7

#define R_EYE_NORMAL r1
#define R_EYE_VERTEX r0
#define R_VERTEX_TO_LIGHT r9
#define R_TEMP r7
#define R_DIFFUSE r6

//Blend my vertex ;
dp4 r1.x, V_POS, c[CV_BONEMTX0_0]
dp4 r1.y, V_POS, c[CV_BONEMTX0_1]
dp4 r1.z, V_POS, c[CV_BONEMTX0_2]

//second bone results -> r2
dp4 r2.x, V_POS, c[CV_BONEMTX1_0]
dp4 r2.y, V_POS, c[CV_BONEMTX1_1]
dp4 r2.z, V_POS, c[CV_BONEMTX1_2]

//third bone results -> r3
dp4 r3.x, V_POS, c[CV_BONEMTX2_0]
dp4 r3.y, V_POS, c[CV_BONEMTX2_1]
dp4 r3.z, V_POS, c[CV_BONEMTX2_2]

//fourth bone results -> r4
dp4 r4.x, V_POS, c[CV_BONEMTX3_0]
dp4 r4.y, V_POS, c[CV_BONEMTX3_1]
dp4 r4.z, V_POS, c[CV_BONEMTX3_2]

//find fourth bone weight: w4 = 1 - (w1+w2+w3)
add r5.x, V_BLEND.x, V_BLEND.y
add r5.x, r5.x, V_BLEND.z
add r5.x, c[CV_ONE], -r5.x

//Blend verts by weight: v1*w1 + v2*w2 + v3*w3 + v4*w4 
mul r1.xyz, r1.xyz, V_BLEND.x
mad r2, r2.xyz, V_BLEND.y, r1.xyz
mad r3, r3.xyz, V_BLEND.z, r2.xyz
mad r4, r4.xyz, r5.x, r3.xyz

mov r4.w, c[CV_ONE].z //set w to one
//r4 now contains final position

; Transform position to clip space and output it
dp4 oPos.x, r4, c[CV_VIEWPROJ_0]
dp4 oPos.y, r4, c[CV_VIEWPROJ_1]
dp4 oPos.z, r4, c[CV_VIEWPROJ_2]
dp4 oPos.w, r4, c[CV_VIEWPROJ_3]

; Transform position to eye space
dp4 R_EYE_VERTEX.x, r4, c[CV_VIEW_0]
dp4 R_EYE_VERTEX.y, r4, c[CV_VIEW_1]
dp4 R_EYE_VERTEX.z, r4, c[CV_VIEW_2]
dp4 R_EYE_VERTEX.w, r4, c[CV_VIEW_3]

//Blend my normal
dp3 r1.x, V_NORMAL, c[CV_BONEMTX0_0]
dp3 r1.y, V_NORMAL, c[CV_BONEMTX0_1]
dp3 r1.z, V_NORMAL, c[CV_BONEMTX0_2]

//second bone results -> r2
dp3 r2.x, V_NORMAL, c[CV_BONEMTX1_0]
dp3 r2.y, V_NORMAL, c[CV_BONEMTX1_1]
dp3 r2.z, V_NORMAL, c[CV_BONEMTX1_2]

//third bone results -> r3
dp3 r3.x, V_NORMAL, c[CV_BONEMTX2_0]
dp3 r3.y, V_NORMAL, c[CV_BONEMTX2_1]
dp3 r3.z, V_NORMAL, c[CV_BONEMTX2_2]

//fourth bone results -> r4
dp3 r4.x, V_NORMAL, c[CV_BONEMTX3_0]
dp3 r4.y, V_NORMAL, c[CV_BONEMTX3_1]
dp3 r4.z, V_NORMAL, c[CV_BONEMTX3_2]

//find fourth bone weight: w4 = 1 - (w1+w2+w3)
add r5.x, V_BLEND.x, V_BLEND.y
add r5.x, r5.x, V_BLEND.z
add r5.x, c[CV_ONE], -r5.x

//Blend normals by weight: v1*w1 + v2*w2 + v3*w3 + v4*w4 
mul r1.xyz, r1.xyz, V_BLEND.x
mad r2, r2.xyz, V_BLEND.y, r1.xyz
mad r3, r3.xyz, V_BLEND.z, r2.xyz
mad r4, r4.xyz, r5.x, r3.xyz

; Transform normal to eye space
dp3 R_EYE_NORMAL.x, r4, c[CV_VIEW_0]
dp3 R_EYE_NORMAL.y, r4, c[CV_VIEW_1]
dp3 R_EYE_NORMAL.z, r4, c[CV_VIEW_2]

; Normalize transformed normal
dp3 R_EYE_NORMAL.w, R_EYE_NORMAL, R_EYE_NORMAL
rsq R_EYE_NORMAL.w, R_EYE_NORMAL.w	
mul R_EYE_NORMAL, R_EYE_NORMAL, R_EYE_NORMAL.w

mov R_DIFFUSE, c[CV_MAT_AMBIENT]
add R_DIFFUSE, R_DIFFUSE, V_COLOR
;mad R_DIFFUSE, V_COLOR, c[CV_HALF], R_DIFFUSE

; *************** Directional Light 1 ************************
dp3 r3.x, R_EYE_NORMAL, c[CV_LIGHT1_DIRECTION]
max r3.x, c[CV_ZERO], r3.x

; add the (diffuse color * diffuse light color * diffuse intensity(r3.x))
mul R_TEMP, c[CV_MAT_DIFFUSE], r3.xxxx
mad R_DIFFUSE, c[CV_LIGHT1_DIFFUSE], R_TEMP, R_DIFFUSE

; *************** Point Light 1 ************************
; Calculate vector from vertex to light in eye space
add R_VERTEX_TO_LIGHT, c[CV_LIGHT2_POSITION],-R_EYE_VERTEX
dp3 R_TEMP.w, R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT	
rsq R_VERTEX_TO_LIGHT.w, R_TEMP.w

; Get the attenuation
dst R_TEMP, R_TEMP.wwww, R_VERTEX_TO_LIGHT.wwww		; (1, d, d*d, 1/d)
dp3 R_TEMP.w, R_TEMP, c[CV_LIGHT2_ATTENUATION]		; (a0 + a1*d + a2*d2)
rcp r8.w, R_TEMP.w									; 1 / (a0 + a1*d + a2*d)	

; Normalize the vertex to the light vector
mul R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT.w

; Dot normal with light vector (from vertex to light)
; This is the intensity of the diffuse component
dp3 r4.x, R_EYE_NORMAL, R_VERTEX_TO_LIGHT
max r4.x, c[CV_ZERO], r4.x

; Scale the factors by the attenuation
mul r4.x, r4.x, r8.w

; add the (ambient color * ambient light color)
;mov R_DIFFUSE, c[CV_LIGHT2_AMBIENT]

; add the (diffuse color * diffuse light color * diffuse intensity(r4.x))
mul R_TEMP, c[CV_MAT_DIFFUSE], r4.xxxx
mad R_DIFFUSE, c[CV_LIGHT2_DIFFUSE], R_TEMP, R_DIFFUSE

max R_DIFFUSE, c[CV_ZERO], R_DIFFUSE

; *************** Point Light 2 ************************
; Calculate vector from vertex to light in eye space
add R_VERTEX_TO_LIGHT, c[CV_LIGHT3_POSITION],-R_EYE_VERTEX
dp3 R_TEMP.w, R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT	
rsq R_VERTEX_TO_LIGHT.w, R_TEMP.w

; Get the attenuation
dst R_TEMP, R_TEMP.wwww, R_VERTEX_TO_LIGHT.wwww		; (1, d, d*d, 1/d)
dp3 R_TEMP.w, R_TEMP, c[CV_LIGHT3_ATTENUATION]		; (a0 + a1*d + a2*d2)
rcp r8.w, R_TEMP.w									; 1 / (a0 + a1*d + a2*d)	

; Normalize the vertex to the light vector
mul R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT, R_VERTEX_TO_LIGHT.w

; Dot normal with light vector (from vertex to light)
; This is the intensity of the diffuse component
dp3 r4.x, R_EYE_NORMAL, R_VERTEX_TO_LIGHT
max r4.x, c[CV_ZERO], r4.x

; Scale the factors by the attenuation
mul r4.x, r4.x, r8.w

; add the (ambient color * ambient light color)
;mov R_DIFFUSE, c[CV_LIGHT3_AMBIENT]

; add the (diffuse color * diffuse light color * diffuse intensity(r4.x))
mul R_TEMP, c[CV_MAT_DIFFUSE], r4.xxxx
mad R_DIFFUSE, c[CV_LIGHT3_DIFFUSE], R_TEMP, R_DIFFUSE

; Clamp it just to be safe.
min R_DIFFUSE, c[CV_ONE], R_DIFFUSE
max R_DIFFUSE, c[CV_ZERO], R_DIFFUSE

mov oD0, R_DIFFUSE
mov oT0, V_TEX0
mov oT1, V_TEX0
mov oT2, c[CV_MAT_EMISSIVE]