//////////////////////////////////////////////////////////////////////////////////////
// fshaders.cpp - 
//
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2002
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 08/21/01 Lafleur		Created.
//////////////////////////////////////////////////////////////////////////////////////

#include "fshaders.h"
#include "fmesh.h"
#include "ftex.h"
#include "fresload.h"
#include "fdata.h"
#include "fvis.h"
#include "fclib.h"
#include "fsh.h"


FShaderType_e FSh_shaderType;
u32 FSh_anDynamicSurfaceRegisters[FDATA_MAX_SURFACE_SHADER_REGS];
u32 FSh_anDynamicLightRegisters[FDATA_MAX_LIGHT_SHADER_REGS + (FSH_MAX_LIGHTMAPS * 3)];
const u32 *FSh_pnSurfaceInputRegisters;				// Pointer to array of input registers
const u32 *FSh_pnLightInputRegisters;				// Pointer to array of input registers
const u32 *FSh_pnLightMapInputRegisters;			// Pointer to array of input registers

//Given a surface shader, this will be the version with a detailmap.
const FShaders_Types_e FShaders_anSurface_Detail[FSHADERS_SHADER_COUNT] =
{
	FSHADERS_oBASE_DETAIL,
	FSHADERS_cBASE_DETAIL,
	FSHADERS_tBASE_DETAIL,
	FSHADERS_etBASE_DETAIL,
	FSHADERS_tBASE_ADD_SPEC_DETAIL,
	FSHADERS_etBASE_ADD_SPEC_DETAIL,
	FSHADERS_etBASE_ADD_bSPEC_DETAIL,
	FSHADERS_ADD_BASE_DETAIL,
	FSHADERS_oBASE_LERP_tLAYER_DETAIL,
	FSHADERS_oBASE_LERP_vLAYER_DETAIL,
	FSHADERS_oBASE_LERP_pLAYER_DETAIL,
	FSHADERS_cBASE_LERP_tLAYER_DETAIL,
	FSHADERS_cBASE_LERP_vLAYER_DETAIL,
	FSHADERS_cBASE_LERP_pLAYER_DETAIL,
	FSHADERS_tBASE_LERP_tLAYER_DETAIL,
	FSHADERS_tBASE_ADD_SPEC_LERP_tLAYER_DETAIL,
	FSHADERS_oBASE_ADD_rbENV_DETAIL,
	FSHADERS_etBASE_ADD_rbENV_DETAIL,

	FSHADERS_oBASE_DETAIL,
	FSHADERS_cBASE_DETAIL,
	FSHADERS_tBASE_DETAIL,		//20
	FSHADERS_etBASE_DETAIL,
	FSHADERS_tBASE_ADD_SPEC_DETAIL,
	FSHADERS_etBASE_ADD_SPEC_DETAIL,
	FSHADERS_etBASE_ADD_bSPEC_DETAIL,
	FSHADERS_ADD_BASE_DETAIL,			//25
	FSHADERS_oBASE_LERP_tLAYER_DETAIL,
	FSHADERS_oBASE_LERP_vLAYER_DETAIL,
	FSHADERS_oBASE_LERP_pLAYER_DETAIL,
	FSHADERS_cBASE_LERP_tLAYER_DETAIL,
	FSHADERS_cBASE_LERP_vLAYER_DETAIL,	//30
	FSHADERS_cBASE_LERP_pLAYER_DETAIL,
	FSHADERS_tBASE_LERP_tLAYER_DETAIL,
	FSHADERS_tBASE_ADD_SPEC_LERP_tLAYER_DETAIL,
	FSHADERS_oBASE_ADD_rbENV_DETAIL,
	FSHADERS_etBASE_ADD_rbENV_DETAIL,	//35
	FSHADERS_oBASE_ADD_rbSREFLECT, //dynamic sphere reflect.
	FSHADERS_tBASE_vALPHA,		//37

	//Insert new shaders here if they go into PASM
	FSHADERS_LIQUID_ENV,		//38
	FSHADERS_LIQUID_LAYER_ENV,	//39
	FSHADERS_LIQUID_TEXTURE,
	FSHADERS_LIQUID_MOLTEN_1LAYER,
	FSHADERS_LIQUID_MOLTEN_2LAYER,

	FSHADERS_oBASE_LERP_tLAYER_ADD_rbENV_DETAIL,
	FSHADERS_oBASE_LERP_vLAYER_ADD_rbENV_DETAIL,
	FSHADERS_oBASE_LERP_pLAYER_ADD_rbENV_DETAIL
};


// Only the registers beyond the standard set of Light registers are listed.
// The standard set is:
//	0) Z Mask (tex)
//	1) Emissive Mask
//	2) Specular Mask
//	3) Diffuse Motif
//	4) Emissive Motif
//	5) Specular Color Motif
//	6) Specular Power
//	7) Lightmap count (if there are any lightmaps, they will follow)
const FLightShaderReg_t FShaders_aLightShaderRegs[FSHADERS_DIFFUSE_COUNT] = 
{
// FSHADERS_FULLBRIGHT
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
//	FSHADERS_FULLBRIGHT_CO
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
//	FSHADERS_VLIGHT_BASIC
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
//	FSHADERS_VLIGHT_BASIC_CO
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
//	FSHADERS_VLIGHT_MASK_EMISSIVE
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
//	FSHADERS_VLIGHT_MASK_EMISSIVE_CO
	10,
	FSHADERS_LIGHT_REG_ZMASK,
	FSHADERS_LIGHT_REG_EMASK,
	FSHADERS_LIGHT_REG_SMASK,
	FSHADERS_LIGHT_REG_BUMPMAP,
	FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR,
	FSHADERS_LIGHT_REG_DMOTIF,
	FSHADERS_LIGHT_REG_EMOTIF,
	FSHADERS_LIGHT_REG_SMOTIF,
	FSHADERS_LIGHT_REG_SEXP,
	FSHADERS_LIGHT_REG_LMCOUNT,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	FSHADERS_LIGHT_REG_NULL,
	
};

//
//
//
const FShaderReg_t FShaders_aShaderRegs[FSHADERS_SHADER_COUNT] = 
{
// FSHADERS_oBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_cBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_CUTOUT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_tBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_etBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_tBASE_ADD_SPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_etBASE_ADD_SPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_etBASE_ADD_bSPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_ADD_BASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_tLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_oBASE_LERP_vLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_pLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_cBASE_LERP_tLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_cBASE_LERP_vLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_cBASE_LERP_pLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_tBASE_LERP_tLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_tBASE_ADD_SPEC_LERP_tLAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_oBASE_ADD_rbENV
	5,
	2,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_etBASE_ADD_rbENV
	5,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_DETAIL
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_cBASE_DETAIL,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_CUTOUT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_tBASE_DETAIL,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_etBASE_DETAIL,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_tBASE_ADD_SPEC_DETAIL,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_etBASE_ADD_SPEC_DETAIL,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_etBASE_ADD_bSPEC_DETAIL|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_ADD_BASE_DETAIL|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	4,
	2,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_oBASE_LERP_tLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_oBASE_LERP_vLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_oBASE_LERP_pLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_cBASE_LERP_tLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_cBASE_LERP_vLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_cBASE_LERP_pLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_CUTOUT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_tBASE_LERP_tLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_tBASE_ADD_SPEC_LERP_tLAYER_DETAIL,
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
// FSHADERS_oBASE_ADD_rbENV_DETAIL,
	7,
	3,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
// FSHADERS_etBASE_ADD_rbENV_DETAIL,
	7,
	3,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,

#if FSH_DYNAMIC_SREFLECT
// FSHADERS_oBASE_ADD_rbSREFLECT
	5,
	2,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
#endif

// FSHADERS_tBASE_vALPHA
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_LIQUID_ENV
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_LIQUID_LAYER_ENV
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_LIQUID_TEXTURE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_LIQUID_MOLTEN_1LAYER
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_LIQUID_MOLTEN_2LAYER
	4,
	2,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_tLAYER_ADD_rbENV
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_vLAYER_ADD_rbENV
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_pLAYER_ADD_rbENV
	6,
	3,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_ENV_MOTIF,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

// FSHADERS_oBASE_LERP_tLAYER_ADD_rbENV_DETAIL
	8,
	4,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_ENV_MOTIF,

// FSHADERS_oBASE_LERP_vLAYER_ADD_rbENV_DETAIL
	8,
	4,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_ENV_MOTIF,

// FSHADERS_oBASE_LERP_pLAYER_ADD_rbENV_DETAIL
	8,
	4,
	2,
	FSHADERS_SURFACE_FLAG_OPAQUE|FSHADERS_SURFACE_FLAG_DETAIL_MAP,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_LAYER1,
	FSHADERS_REG_TC1,
	FSHADERS_REG_LAYER2,
	FSHADERS_REG_DETAILMAP,
	FSHADERS_REG_DETAILMAP_TILE_FACTOR,
	FSHADERS_REG_ENV_MOTIF,

// FSHADERS_pBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_epBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_pBASE_ADD_SPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_epBASE_ADD_SPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_epBASE_ADD_bSPEC
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	
// FSHADERS_ADD_vBASE
	2,
	1,
	1,
	FSHADERS_SURFACE_FLAG_TRANSLUCENT,
	FSHADERS_REG_LAYER0,
	FSHADERS_REG_TC0,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,
	FSHADERS_REG_NULL,

};


static void _FixupShTexInst( FShTexInst_t *pShTexInst, FMesh_t *pMesh, BOOL bLoadForStreaming );


//
//
//
BOOL fshaders_FixupLightRegisters( FMesh_t *pLoadBase, u32 nLightShaderIdx, u32 nSpecularShaderIdx, u32 *pnRegisters )
{
	if ( !pnRegisters )
	{
		FASSERT_NOW;
		return FALSE;
	}
	
	u32 i;
	for ( i = 0; i < FShaders_aLightShaderRegs[nLightShaderIdx].nRegisterCount; i++ )
	{
		switch ( FShaders_aLightShaderRegs[nLightShaderIdx].anRegType[i] )
		{
			case FSHADERS_LIGHT_REG_DMOTIF:
			case FSHADERS_LIGHT_REG_EMOTIF:
			case FSHADERS_LIGHT_REG_SMOTIF:
				if ( *pnRegisters )
				{
					(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
				}
				break;
	
			case FSHADERS_LIGHT_REG_ZMASK:
			case FSHADERS_LIGHT_REG_EMASK:
			case FSHADERS_LIGHT_REG_SMASK:
				if ( *pnRegisters )
				{
					(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
					_FixupShTexInst( (FShTexInst_t *)(*pnRegisters ), (pLoadBase), FALSE );
				}
				break;
			case FSHADERS_LIGHT_REG_BUMPMAP:
				if ( *pnRegisters )
				{
					(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
					_FixupShTexInst( (FShTexInst_t *)(*pnRegisters ), (pLoadBase), FALSE );
				}
				break;

			case FSHADERS_LIGHT_REG_SEXP:
			case FSHADERS_LIGHT_REG_LMCOUNT:
			case FSHADERS_LIGHT_REG_BUMPMAP_TILE_FACTOR:
				break;

			default:
				FASSERT_NOW;
				break;
		}

		pnRegisters++;
	}
	
	while ( *pnRegisters != 0xffffffff )
	{
		// Read in the lightmaps:
		FASSERT( *pnRegisters );
		(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
		_FixupShTexInst( (FShTexInst_t *)(*pnRegisters ), (pLoadBase), TRUE );
		pnRegisters++;

		// Next would be the ST index
		FASSERT( (*pnRegisters) != 0xffffffff );
		pnRegisters++;

		// Next would be the motif
		FASSERT( (*pnRegisters) != 0xffffffff );
		CFWorldLight *pLight;
		if ( *pnRegisters )
		{
			u32 nValue = *pnRegisters;
			if ( nValue & 0xffff0000 )
			{
				pLight = fvis_GetWorldLightByLightID( nValue >> 16 );
				if (pLight)
				{
					(*pnRegisters) = (u32)(&pLight->m_Light.m_Motif);
				}
				else
				{
					(*pnRegisters) = NULL;
				}
			}
			else
			{
				pLight = fvis_GetWorldLightByMotifIndex( nValue );
				if (pLight)
				{
					(*pnRegisters) = (u32)(&pLight->m_Light.m_Motif);
				}
				else
				{
					(*pnRegisters) = NULL;
				}
			}
		}
		pnRegisters++;
	}

	return TRUE;
}


//
//
//
BOOL fshaders_FixupSurfaceRegisters( FMesh_t *pLoadBase, u32 nShaderIdx, u32 *pnRegisters )
{
	if ( !pnRegisters )
	{
		FASSERT_NOW;
		return FALSE;
	}
	
	u32 i;
	for ( i = 0; i < FShaders_aShaderRegs[nShaderIdx].nRegisterCount; i++ )
	{
		switch ( FShaders_aShaderRegs[nShaderIdx].anRegType[i] )
		{
			case FSHADERS_REG_ENV_MOTIF:
				{
					if ( (*pnRegisters) )
					{
						(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
						CFColorMotif *pMotif = (CFColorMotif *)(*pnRegisters);
						FASSERT( pMotif->nMotifIndex == 0 );
					}
					else
					{
						(*pnRegisters) = NULL;
					}
				}
				break;
	
			case FSHADERS_REG_LAYER0:
			case FSHADERS_REG_LAYER1:
			case FSHADERS_REG_LAYER2:
			case FSHADERS_REG_LAYER3:
				(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
				_FixupShTexInst( (FShTexInst_t *)(*pnRegisters ), (pLoadBase), FALSE );
				break;

			case FSHADERS_REG_TC0:
			case FSHADERS_REG_TC1:
			case FSHADERS_REG_TC2:
			case FSHADERS_REG_TC3:
			case FSHADERS_REG_DETAILMAP_TILE_FACTOR:
				break;

			case FSHADERS_REG_DETAILMAP:
				(*pnRegisters) = (u32)pLoadBase + (u32)(*pnRegisters);
				_FixupShTexInst( (FShTexInst_t *)(*pnRegisters ), (pLoadBase), FALSE );
				break;

			default:
				FASSERT_NOW;
				break;
		}

		pnRegisters++;
	}
	
	return TRUE;
}


//
//
//
static void _FixupShTexInst( FShTexInst_t *pShTexInst, FMesh_t *pMesh, BOOL bLoadForStreaming ) 
{
	FASSERT( pShTexInst && pMesh );

	if ( pShTexInst->TexInst.GetTexDef() != NULL )
	{
		// Tex def has already been assigned
		return;
	}
	
	FASSERT( pShTexInst->nTextureNameOffset );
	
	// Get the texture name, the pointer to which was hidden away as the texdef
	char *pszTexResName = (char *)( (u32)pMesh + (u32)pShTexInst->nTextureNameOffset );
	if ( pszTexResName[0] == 0 )
	{
		return;
	}
	
	// Replace textures with demorefl with App specified reflection map (may differ on a level by level basis)
	if ( fclib_stricmp( pszTexResName, FTex_szOldReflectMap ) == 0 )
	{
		pszTexResName = FTex_szNewReflectMap;
	}

	FTexDef_t *pTexDef;
	if ( bLoadForStreaming )
	{
		pTexDef = (FTexDef_t *)fresload_LoadStreaming( FTEX_RESNAME, pszTexResName );
	}
	else
	{
		pTexDef = (FTexDef_t *)fresload_Load( FTEX_RESNAME, pszTexResName );
	}

	if ( pTexDef == NULL )
	{
		DEVPRINTF( "fshaders::_FixupShTexInst() - Could not load texture '%s' for object '%s'.\n", pszTexResName, pMesh->szName );
		return;
	}
		
	pShTexInst->TexInst.SetTexDef( pTexDef );
	
	if ( pShTexInst->nTexLayerID == 255 ) 
	{
		return;
	}
	
	// This shader texture has an ID so we need to handling flipping/scolling

	u32 j, k, nFlipPage, nFlipPageCount, nStringLen, nFlipPage10s;
	char szTexName[FDATA_TEXNAME_LEN+1], *pszFlipPageCode, c10s;
	FMeshTexLayerID_t *pTexLayerID;
	pTexLayerID = pMesh->pTexLayerIDArray;
	for ( j = 0; j < pMesh->nTexLayerIDCount; j++, pTexLayerID++ ) 
	{
		if ( pTexLayerID->nTexLayerID != pShTexInst->nTexLayerID ) 
		{
			continue;
		}
		
		// We found the shader's texture layer ID in the master ID table...

		if ( !(pTexLayerID->nFlags & FMESH_TEXLAYERIDFLAG_USE_FLIP_INFO) ) 
		{
			// This ID is not flagged for texture flipping so we do nothing more...
			return;
		}

		if ( pTexLayerID->apFlipPalette != NULL ) 
		{
			// We have already built a flip palette for this shader texture layer so we're done...
			return;
		}

		fclib_strcpy( szTexName, pszTexResName );

		nStringLen = fclib_strlen( szTexName );
		if ( nStringLen < 2 ) 
		{
			// Name is not at least 2 characters so we cannot process it...
			FASSERT_NOW;
			return;
		}

		pszFlipPageCode = szTexName + nStringLen - 2;

		c10s = fclib_toupper( pszFlipPageCode[0] );

		if ( c10s>='A' && c10s<='Z' ) 
		{
			nFlipPage = 10 + (c10s - 'A');
		} 
		else if( c10s>='0' && c10s<='9' ) 
		{
			nFlipPage = c10s - '0';
		} 
		else 
		{
			DEVPRINTF( "fshaders::_FixupShTexInst() - Invalid base texture flip name: '%s'.\n", pszTexResName );
			break;
		}

		if ( pszFlipPageCode[1]>='0' && pszFlipPageCode[1]<='9' ) 
		{
			nFlipPage += (pszFlipPageCode[1] - '0');
		} 
		else 
		{
			DEVPRINTF( "fshaders::_FixupShTexInst() - Invalid base texture flip name: '%s'.\n", pszTexResName );
			break;
		}

		nFlipPageCount = pTexLayerID->nFlipPageCount;
		FMATH_CLAMPMIN( nFlipPageCount, 1 );

		if ( nFlipPage >= nFlipPageCount ) 
		{
			DEVPRINTF( "fshaders::_FixupShTexInst() - Base texture flip name starts outside given range: '%s'.\n", pszTexResName );
			break;
		}

		// Allocate memory to store palette...
		pTexLayerID->apFlipPalette = (CFTexInst **)fres_Alloc( sizeof(CFTexInst *) * nFlipPageCount );
		if ( pTexLayerID->apFlipPalette == NULL ) 
		{
			break;
		}

		for ( k = 0; k < nFlipPageCount; k++ ) 
		{
			nFlipPage10s = nFlipPage / 10;
			
			if ( nFlipPage10s < 10 ) 
				pszFlipPageCode[0] = (char)(nFlipPage10s + '0');
			else
				pszFlipPageCode[0] = (char)(nFlipPage10s - 10 + 'A');

			pszFlipPageCode[1] = char((nFlipPage % 10) + '0');

			pTexDef = (FTexDef_t *)fresload_Load( FTEX_RESNAME, szTexName );
			
			pTexLayerID->apFlipPalette[k] = fnew CFTexInst;
			if ( !pTexLayerID->apFlipPalette[k] )
			{
				DEVPRINTF( "fshaders::_FixupShTexInst() - Could not allocate CFTexInst for flip textures.\n" );
				return;
			}
			
			pTexLayerID->apFlipPalette[k]->SetTexDef( pTexDef );

			if ( nFlipPage++ >= nFlipPageCount )
				nFlipPage = 0;
		}

		// Done processing the TextureID stuff
		return;
	}
}



