//////////////////////////////////////////////////////////////////////////////////////
// fsintbl.cpp - Sin/Cosine table.
//
// Author: Steve Ranck     
//////////////////////////////////////////////////////////////////////////////////////
// THIS CODE IS PROPRIETARY PROPERTY OF SWINGIN' APE STUDIOS, INC.
// Copyright (c) 2002
//
// The contents of this file may not be disclosed to third
// parties, copied or duplicated in any form, in whole or in part,
// without the prior written permission of Swingin' Ape Studios, Inc.
//////////////////////////////////////////////////////////////////////////////////////
// Modification History:
//
// Date     Who         Description
// -------- ----------  --------------------------------------------------------------
// 02/20/02 Ranck       Created.
//////////////////////////////////////////////////////////////////////////////////////

#include "fang.h"
#include "fsintbl.h"


const f32 SinTbl_afTable[16385] = {
   0.0000000000000000000000000000f,   //     0: sin( 0.0000000)
   0.0000958737990959773450000000f,   //     1: sin( 0.0054932)
   0.0001917475973107032900000000f,   //     2: sin( 0.0109863)
   0.0002876213937629265100000000f,   //     3: sin( 0.0164795)
   0.0003834951875713955600000000f,   //     4: sin( 0.0219727)
   0.0004793689778548591900000000f,   //     5: sin( 0.0274658)
   0.0005752427637320660900000000f,   //     6: sin( 0.0329590)
   0.0006711165443217648800000000f,   //     7: sin( 0.0384521)
   0.0007669903187427044900000000f,   //     8: sin( 0.0439453)
   0.0008628640861136336600000000f,   //     9: sin( 0.0494385)
   0.0009587378455533014000000000f,   //    10: sin( 0.0549316)
   0.0010546115961804566000000000f,   //    11: sin( 0.0604248)
   0.0011504853371138485000000000f,   //    12: sin( 0.0659180)
   0.0012463590674722260000000000f,   //    13: sin( 0.0714111)
   0.0013422327863743383000000000f,   //    14: sin( 0.0769043)
   0.0014381064929389349000000000f,   //    15: sin( 0.0823975)
   0.0015339801862847655000000000f,   //    16: sin( 0.0878906)
   0.0016298538655305796000000000f,   //    17: sin( 0.0933838)
   0.0017257275297951264000000000f,   //    18: sin( 0.0988770)
   0.0018216011781971562000000000f,   //    19: sin( 0.1043701)
   0.0019174748098554190000000000f,   //    20: sin( 0.1098633)
   0.0020133484238886649000000000f,   //    21: sin( 0.1153564)
   0.0021092220194156440000000000f,   //    22: sin( 0.1208496)
   0.0022050955955551072000000000f,   //    23: sin( 0.1263428)
   0.0023009691514258050000000000f,   //    24: sin( 0.1318359)
   0.0023968426861464883000000000f,   //    25: sin( 0.1373291)
   0.0024927161988359081000000000f,   //    26: sin( 0.1428223)
   0.0025885896886128153000000000f,   //    27: sin( 0.1483154)
   0.0026844631545959617000000000f,   //    28: sin( 0.1538086)
   0.0027803365959040991000000000f,   //    29: sin( 0.1593018)
   0.0028762100116559788000000000f,   //    30: sin( 0.1647949)
   0.0029720834009703536000000000f,   //    31: sin( 0.1702881)
   0.0030679567629659761000000000f,   //    32: sin( 0.1757813)
   0.0031638300967615982000000000f,   //    33: sin( 0.1812744)
   0.0032597034014759732000000000f,   //    34: sin( 0.1867676)
   0.0033555766762278540000000000f,   //    35: sin( 0.1922607)
   0.0034514499201359940000000000f,   //    36: sin( 0.1977539)
   0.0035473231323191476000000000f,   //    37: sin( 0.2032471)
   0.0036431963118960676000000000f,   //    38: sin( 0.2087402)
   0.0037390694579855096000000000f,   //    39: sin( 0.2142334)
   0.0038349425697062275000000000f,   //    40: sin( 0.2197266)
   0.0039308156461769763000000000f,   //    41: sin( 0.2252197)
   0.0040266886865165117000000000f,   //    42: sin( 0.2307129)
   0.0041225616898435888000000000f,   //    43: sin( 0.2362061)
   0.0042184346552769630000000000f,   //    44: sin( 0.2416992)
   0.0043143075819353921000000000f,   //    45: sin( 0.2471924)
   0.0044101804689376314000000000f,   //    46: sin( 0.2526855)
   0.0045060533154024389000000000f,   //    47: sin( 0.2581787)
   0.0046019261204485705000000000f,   //    48: sin( 0.2636719)
   0.0046977988831947851000000000f,   //    49: sin( 0.2691650)
   0.0047936716027598414000000000f,   //    50: sin( 0.2746582)
   0.0048895442782624964000000000f,   //    51: sin( 0.2801514)
   0.0049854169088215106000000000f,   //    52: sin( 0.2856445)
   0.0050812894935556418000000000f,   //    53: sin( 0.2911377)
   0.0051771620315836505000000000f,   //    54: sin( 0.2966309)
   0.0052730345220242981000000000f,   //    55: sin( 0.3021240)
   0.0053689069639963425000000000f,   //    56: sin( 0.3076172)
   0.0054647793566185475000000000f,   //    57: sin( 0.3131104)
   0.0055606516990096737000000000f,   //    58: sin( 0.3186035)
   0.0056565239902884824000000000f,   //    59: sin( 0.3240967)
   0.0057523962295737358000000000f,   //    60: sin( 0.3295898)
   0.0058482684159841996000000000f,   //    61: sin( 0.3350830)
   0.0059441405486386333000000000f,   //    62: sin( 0.3405762)
   0.0060400126266558045000000000f,   //    63: sin( 0.3460693)
   0.0061358846491544753000000000f,   //    64: sin( 0.3515625)
   0.0062317566152534105000000000f,   //    65: sin( 0.3570557)
   0.0063276285240713784000000000f,   //    66: sin( 0.3625488)
   0.0064235003747271412000000000f,   //    67: sin( 0.3680420)
   0.0065193721663394681000000000f,   //    68: sin( 0.3735352)
   0.0066152438980271247000000000f,   //    69: sin( 0.3790283)
   0.0067111155689088793000000000f,   //    70: sin( 0.3845215)
   0.0068069871781035003000000000f,   //    71: sin( 0.3900146)
   0.0069028587247297558000000000f,   //    72: sin( 0.3955078)
   0.0069987302079064151000000000f,   //    73: sin( 0.4010010)
   0.0070946016267522498000000000f,   //    74: sin( 0.4064941)
   0.0071904729803860274000000000f,   //    75: sin( 0.4119873)
   0.0072863442679265214000000000f,   //    76: sin( 0.4174805)
   0.0073822154884925035000000000f,   //    77: sin( 0.4229736)
   0.0074780866412027438000000000f,   //    78: sin( 0.4284668)
   0.0075739577251760174000000000f,   //    79: sin( 0.4339600)
   0.0076698287395310970000000000f,   //    80: sin( 0.4394531)
   0.0077656996833867569000000000f,   //    81: sin( 0.4449463)
   0.0078615705558617716000000000f,   //    82: sin( 0.4504395)
   0.0079574413560749187000000000f,   //    83: sin( 0.4559326)
   0.0080533120831449718000000000f,   //    84: sin( 0.4614258)
   0.0081491827361907087000000000f,   //    85: sin( 0.4669189)
   0.0082450533143309055000000000f,   //    86: sin( 0.4724121)
   0.0083409238166843435000000000f,   //    87: sin( 0.4779053)
   0.0084367942423697988000000000f,   //    88: sin( 0.4833984)
   0.0085326645905060543000000000f,   //    89: sin( 0.4888916)
   0.0086285348602118863000000000f,   //    90: sin( 0.4943848)
   0.0087244050506060777000000000f,   //    91: sin( 0.4998779)
   0.0088202751608074115000000000f,   //    92: sin( 0.5053711)
   0.0089161451899346673000000000f,   //    93: sin( 0.5108643)
   0.0090120151371066333000000000f,   //    94: sin( 0.5163574)
   0.0091078850014420891000000000f,   //    95: sin( 0.5218506)
   0.0092037547820598194000000000f,   //    96: sin( 0.5273438)
   0.0092996244780786108000000000f,   //    97: sin( 0.5328369)
   0.0093954940886172515000000000f,   //    98: sin( 0.5383301)
   0.0094913636127945279000000000f,   //    99: sin( 0.5438232)
   0.0095872330497292248000000000f,   //   100: sin( 0.5493164)
   0.0096831023985401339000000000f,   //   101: sin( 0.5548096)
   0.0097789716583460435000000000f,   //   102: sin( 0.5603027)
   0.0098748408282657452000000000f,   //   103: sin( 0.5657959)
   0.0099707099074180308000000000f,   //   104: sin( 0.5712891)
   0.0100665788949216880000000000f,   //   105: sin( 0.5767822)
   0.0101624477898955130000000000f,   //   106: sin( 0.5822754)
   0.0102583165914583010000000000f,   //   107: sin( 0.5877686)
   0.0103541852987288420000000000f,   //   108: sin( 0.5932617)
   0.0104500539108259360000000000f,   //   109: sin( 0.5987549)
   0.0105459224268683780000000000f,   //   110: sin( 0.6042480)
   0.0106417908459749640000000000f,   //   111: sin( 0.6097412)
   0.0107376591672644910000000000f,   //   112: sin( 0.6152344)
   0.0108335273898557600000000000f,   //   113: sin( 0.6207275)
   0.0109293955128675710000000000f,   //   114: sin( 0.6262207)
   0.0110252635354187250000000000f,   //   115: sin( 0.6317139)
   0.0111211314566280210000000000f,   //   116: sin( 0.6372070)
   0.0112169992756142640000000000f,   //   117: sin( 0.6427002)
   0.0113128669914962580000000000f,   //   118: sin( 0.6481934)
   0.0114087346033928050000000000f,   //   119: sin( 0.6536865)
   0.0115046021104227140000000000f,   //   120: sin( 0.6591797)
   0.0116004695117047900000000000f,   //   121: sin( 0.6646729)
   0.0116963368063578380000000000f,   //   122: sin( 0.6701660)
   0.0117922039935006700000000000f,   //   123: sin( 0.6756592)
   0.0118880710722520920000000000f,   //   124: sin( 0.6811523)
   0.0119839380417309170000000000f,   //   125: sin( 0.6866455)
   0.0120798049010559570000000000f,   //   126: sin( 0.6921387)
   0.0121756716493460220000000000f,   //   127: sin( 0.6976318)
   0.0122715382857199250000000000f,   //   128: sin( 0.7031250)
   0.0123674048092964840000000000f,   //   129: sin( 0.7086182)
   0.0124632712191945110000000000f,   //   130: sin( 0.7141113)
   0.0125591375145328260000000000f,   //   131: sin( 0.7196045)
   0.0126550036944302420000000000f,   //   132: sin( 0.7250977)
   0.0127508697580055800000000000f,   //   133: sin( 0.7305908)
   0.0128467357043776620000000000f,   //   134: sin( 0.7360840)
   0.0129426015326653040000000000f,   //   135: sin( 0.7415771)
   0.0130384672419873340000000000f,   //   136: sin( 0.7470703)
   0.0131343328314625690000000000f,   //   137: sin( 0.7525635)
   0.0132301983002098350000000000f,   //   138: sin( 0.7580566)
   0.0133260636473479590000000000f,   //   139: sin( 0.7635498)
   0.0134219288719957650000000000f,   //   140: sin( 0.7690430)
   0.0135177939732720830000000000f,   //   141: sin( 0.7745361)
   0.0136136589502957400000000000f,   //   142: sin( 0.7800293)
   0.0137095238021855660000000000f,   //   143: sin( 0.7855225)
   0.0138053885280603910000000000f,   //   144: sin( 0.7910156)
   0.0139012531270390470000000000f,   //   145: sin( 0.7965088)
   0.0139971175982403670000000000f,   //   146: sin( 0.8020020)
   0.0140929819407831900000000000f,   //   147: sin( 0.8074951)
   0.0141888461537863450000000000f,   //   148: sin( 0.8129883)
   0.0142847102363686700000000000f,   //   149: sin( 0.8184814)
   0.0143805741876490060000000000f,   //   150: sin( 0.8239746)
   0.0144764380067461900000000000f,   //   151: sin( 0.8294678)
   0.0145723016927790640000000000f,   //   152: sin( 0.8349609)
   0.0146681652448664690000000000f,   //   153: sin( 0.8404541)
   0.0147640286621272460000000000f,   //   154: sin( 0.8459473)
   0.0148598919436802400000000000f,   //   155: sin( 0.8514404)
   0.0149557550886442960000000000f,   //   156: sin( 0.8569336)
   0.0150516180961382620000000000f,   //   157: sin( 0.8624268)
   0.0151474809652809870000000000f,   //   158: sin( 0.8679199)
   0.0152433436951913150000000000f,   //   159: sin( 0.8734131)
   0.0153392062849881000000000000f,   //   160: sin( 0.8789063)
   0.0154350687337901930000000000f,   //   161: sin( 0.8843994)
   0.0155309310407164470000000000f,   //   162: sin( 0.8898926)
   0.0156267932048857160000000000f,   //   163: sin( 0.8953857)
   0.0157226552254168570000000000f,   //   164: sin( 0.9008789)
   0.0158185171014287240000000000f,   //   165: sin( 0.9063721)
   0.0159143788320401830000000000f,   //   166: sin( 0.9118652)
   0.0160102404163700790000000000f,   //   167: sin( 0.9173584)
   0.0161061018535372870000000000f,   //   168: sin( 0.9228516)
   0.0162019631426606610000000000f,   //   169: sin( 0.9283447)
   0.0162978242828590650000000000f,   //   170: sin( 0.9338379)
   0.0163936852732513680000000000f,   //   171: sin( 0.9393311)
   0.0164895461129564370000000000f,   //   172: sin( 0.9448242)
   0.0165854068010931330000000000f,   //   173: sin( 0.9503174)
   0.0166812673367803320000000000f,   //   174: sin( 0.9558105)
   0.0167771277191368990000000000f,   //   175: sin( 0.9613037)
   0.0168729879472817100000000000f,   //   176: sin( 0.9667969)
   0.0169688480203336430000000000f,   //   177: sin( 0.9722900)
   0.0170647079374115630000000000f,   //   178: sin( 0.9777832)
   0.0171605676976343480000000000f,   //   179: sin( 0.9832764)
   0.0172564273001208770000000000f,   //   180: sin( 0.9887695)
   0.0173522867439900340000000000f,   //   181: sin( 0.9942627)
   0.0174481460283606930000000000f,   //   182: sin( 0.9997559)
   0.0175440051523517400000000000f,   //   183: sin( 1.0052490)
   0.0176398641150820530000000000f,   //   184: sin( 1.0107422)
   0.0177357229156705240000000000f,   //   185: sin( 1.0162354)
   0.0178315815532360390000000000f,   //   186: sin( 1.0217285)
   0.0179274400268974840000000000f,   //   187: sin( 1.0272217)
   0.0180232983357737460000000000f,   //   188: sin( 1.0327148)
   0.0181191564789837150000000000f,   //   189: sin( 1.0382080)
   0.0182150144556462900000000000f,   //   190: sin( 1.0437012)
   0.0183108722648803600000000000f,   //   191: sin( 1.0491943)
   0.0184067299058048200000000000f,   //   192: sin( 1.0546875)
   0.0185025873775385710000000000f,   //   193: sin( 1.0601807)
   0.0185984446792005110000000000f,   //   194: sin( 1.0656738)
   0.0186943018099095390000000000f,   //   195: sin( 1.0711670)
   0.0187901587687845550000000000f,   //   196: sin( 1.0766602)
   0.0188860155549444680000000000f,   //   197: sin( 1.0821533)
   0.0189818721675081780000000000f,   //   198: sin( 1.0876465)
   0.0190777286055945940000000000f,   //   199: sin( 1.0931396)
   0.0191735848683226230000000000f,   //   200: sin( 1.0986328)
   0.0192694409548111730000000000f,   //   201: sin( 1.1041260)
   0.0193652968641791560000000000f,   //   202: sin( 1.1096191)
   0.0194611525955454900000000000f,   //   203: sin( 1.1151123)
   0.0195570081480290830000000000f,   //   204: sin( 1.1206055)
   0.0196528635207488570000000000f,   //   205: sin( 1.1260986)
   0.0197487187128237290000000000f,   //   206: sin( 1.1315918)
   0.0198445737233726130000000000f,   //   207: sin( 1.1370850)
   0.0199404285515144410000000000f,   //   208: sin( 1.1425781)
   0.0200362831963681250000000000f,   //   209: sin( 1.1480713)
   0.0201321376570525940000000000f,   //   210: sin( 1.1535645)
   0.0202279919326867760000000000f,   //   211: sin( 1.1590576)
   0.0203238460223895930000000000f,   //   212: sin( 1.1645508)
   0.0204196999252799840000000000f,   //   213: sin( 1.1700439)
   0.0205155536404768750000000000f,   //   214: sin( 1.1755371)
   0.0206114071670992010000000000f,   //   215: sin( 1.1810303)
   0.0207072605042658950000000000f,   //   216: sin( 1.1865234)
   0.0208031136510958940000000000f,   //   217: sin( 1.1920166)
   0.0208989666067081370000000000f,   //   218: sin( 1.1975098)
   0.0209948193702215700000000000f,   //   219: sin( 1.2030029)
   0.0210906719407551210000000000f,   //   220: sin( 1.2084961)
   0.0211865243174277490000000000f,   //   221: sin( 1.2139893)
   0.0212823764993583870000000000f,   //   222: sin( 1.2194824)
   0.0213782284856659930000000000f,   //   223: sin( 1.2249756)
   0.0214740802754695080000000000f,   //   224: sin( 1.2304688)
   0.0215699318678878840000000000f,   //   225: sin( 1.2359619)
   0.0216657832620400780000000000f,   //   226: sin( 1.2414551)
   0.0217616344570450430000000000f,   //   227: sin( 1.2469482)
   0.0218574854520217350000000000f,   //   228: sin( 1.2524414)
   0.0219533362460891110000000000f,   //   229: sin( 1.2579346)
   0.0220491868383661350000000000f,   //   230: sin( 1.2634277)
   0.0221450372279717620000000000f,   //   231: sin( 1.2689209)
   0.0222408874140249610000000000f,   //   232: sin( 1.2744141)
   0.0223367373956446960000000000f,   //   233: sin( 1.2799072)
   0.0224325871719499340000000000f,   //   234: sin( 1.2854004)
   0.0225284367420596450000000000f,   //   235: sin( 1.2908936)
   0.0226242861050928030000000000f,   //   236: sin( 1.2963867)
   0.0227201352601683790000000000f,   //   237: sin( 1.3018799)
   0.0228159842064053450000000000f,   //   238: sin( 1.3073730)
   0.0229118329429226840000000000f,   //   239: sin( 1.3128662)
   0.0230076814688393690000000000f,   //   240: sin( 1.3183594)
   0.0231035297832743910000000000f,   //   241: sin( 1.3238525)
   0.0231993778853467200000000000f,   //   242: sin( 1.3293457)
   0.0232952257741753480000000000f,   //   243: sin( 1.3348389)
   0.0233910734488792580000000000f,   //   244: sin( 1.3403320)
   0.0234869209085774440000000000f,   //   245: sin( 1.3458252)
   0.0235827681523888940000000000f,   //   246: sin( 1.3513184)
   0.0236786151794325970000000000f,   //   247: sin( 1.3568115)
   0.0237744619888275550000000000f,   //   248: sin( 1.3623047)
   0.0238703085796927590000000000f,   //   249: sin( 1.3677979)
   0.0239661549511472100000000000f,   //   250: sin( 1.3732910)
   0.0240620011023099140000000000f,   //   251: sin( 1.3787842)
   0.0241578470322998640000000000f,   //   252: sin( 1.3842773)
   0.0242536927402360670000000000f,   //   253: sin( 1.3897705)
   0.0243495382252375340000000000f,   //   254: sin( 1.3952637)
   0.0244453834864232670000000000f,   //   255: sin( 1.4007568)
   0.0245412285229122880000000000f,   //   256: sin( 1.4062500)
   0.0246370733338236000000000000f,   //   257: sin( 1.4117432)
   0.0247329179182762230000000000f,   //   258: sin( 1.4172363)
   0.0248287622753891710000000000f,   //   259: sin( 1.4227295)
   0.0249246064042814680000000000f,   //   260: sin( 1.4282227)
   0.0250204503040721280000000000f,   //   261: sin( 1.4337158)
   0.0251162939738801860000000000f,   //   262: sin( 1.4392090)
   0.0252121374128246550000000000f,   //   263: sin( 1.4447021)
   0.0253079806200245710000000000f,   //   264: sin( 1.4501953)
   0.0254038235945989590000000000f,   //   265: sin( 1.4556885)
   0.0254996663356668530000000000f,   //   266: sin( 1.4611816)
   0.0255955088423472850000000000f,   //   267: sin( 1.4666748)
   0.0256913511137592950000000000f,   //   268: sin( 1.4721680)
   0.0257871931490219200000000000f,   //   269: sin( 1.4776611)
   0.0258830349472541980000000000f,   //   270: sin( 1.4831543)
   0.0259788765075751780000000000f,   //   271: sin( 1.4886475)
   0.0260747178291039010000000000f,   //   272: sin( 1.4941406)
   0.0261705589109594120000000000f,   //   273: sin( 1.4996338)
   0.0262663997522607600000000000f,   //   274: sin( 1.5051270)
   0.0263622403521270000000000000f,   //   275: sin( 1.5106201)
   0.0264580807096771870000000000f,   //   276: sin( 1.5161133)
   0.0265539208240303730000000000f,   //   277: sin( 1.5216064)
   0.0266497606943056180000000000f,   //   278: sin( 1.5270996)
   0.0267456003196219830000000000f,   //   279: sin( 1.5325928)
   0.0268414396990985310000000000f,   //   280: sin( 1.5380859)
   0.0269372788318543240000000000f,   //   281: sin( 1.5435791)
   0.0270331177170084310000000000f,   //   282: sin( 1.5490723)
   0.0271289563536799250000000000f,   //   283: sin( 1.5545654)
   0.0272247947409878750000000000f,   //   284: sin( 1.5600586)
   0.0273206328780513510000000000f,   //   285: sin( 1.5655518)
   0.0274164707639894360000000000f,   //   286: sin( 1.5710449)
   0.0275123083979212060000000000f,   //   287: sin( 1.5765381)
   0.0276081457789657400000000000f,   //   288: sin( 1.5820313)
   0.0277039829062421250000000000f,   //   289: sin( 1.5875244)
   0.0277998197788694450000000000f,   //   290: sin( 1.5930176)
   0.0278956563959667880000000000f,   //   291: sin( 1.5985107)
   0.0279914927566532430000000000f,   //   292: sin( 1.6040039)
   0.0280873288600479060000000000f,   //   293: sin( 1.6094971)
   0.0281831647052698740000000000f,   //   294: sin( 1.6149902)
   0.0282790002914382370000000000f,   //   295: sin( 1.6204834)
   0.0283748356176720990000000000f,   //   296: sin( 1.6259766)
   0.0284706706830905600000000000f,   //   297: sin( 1.6314697)
   0.0285665054868127280000000000f,   //   298: sin( 1.6369629)
   0.0286623400279577100000000000f,   //   299: sin( 1.6424561)
   0.0287581743056446150000000000f,   //   300: sin( 1.6479492)
   0.0288540083189925520000000000f,   //   301: sin( 1.6534424)
   0.0289498420671206350000000000f,   //   302: sin( 1.6589355)
   0.0290456755491479870000000000f,   //   303: sin( 1.6644287)
   0.0291415087641937220000000000f,   //   304: sin( 1.6699219)
   0.0292373417113769640000000000f,   //   305: sin( 1.6754150)
   0.0293331743898168350000000000f,   //   306: sin( 1.6809082)
   0.0294290067986324630000000000f,   //   307: sin( 1.6864014)
   0.0295248389369429760000000000f,   //   308: sin( 1.6918945)
   0.0296206708038675090000000000f,   //   309: sin( 1.6973877)
   0.0297165023985251910000000000f,   //   310: sin( 1.7028809)
   0.0298123337200351600000000000f,   //   311: sin( 1.7083740)
   0.0299081647675165550000000000f,   //   312: sin( 1.7138672)
   0.0300039955400885210000000000f,   //   313: sin( 1.7193604)
   0.0300998260368701980000000000f,   //   314: sin( 1.7248535)
   0.0301956562569807400000000000f,   //   315: sin( 1.7303467)
   0.0302914861995392840000000000f,   //   316: sin( 1.7358398)
   0.0303873158636649920000000000f,   //   317: sin( 1.7413330)
   0.0304831452484770090000000000f,   //   318: sin( 1.7468262)
   0.0305789743530945030000000000f,   //   319: sin( 1.7523193)
   0.0306748031766366260000000000f,   //   320: sin( 1.7578125)
   0.0307706317182225400000000000f,   //   321: sin( 1.7633057)
   0.0308664599769714120000000000f,   //   322: sin( 1.7687988)
   0.0309622879520024090000000000f,   //   323: sin( 1.7742920)
   0.0310581156424347000000000000f,   //   324: sin( 1.7797852)
   0.0311539430473874580000000000f,   //   325: sin( 1.7852783)
   0.0312497701659798610000000000f,   //   326: sin( 1.7907715)
   0.0313455969973310820000000000f,   //   327: sin( 1.7962646)
   0.0314414235405603010000000000f,   //   328: sin( 1.8017578)
   0.0315372497947867050000000000f,   //   329: sin( 1.8072510)
   0.0316330757591294780000000000f,   //   330: sin( 1.8127441)
   0.0317289014327078040000000000f,   //   331: sin( 1.8182373)
   0.0318247268146408870000000000f,   //   332: sin( 1.8237305)
   0.0319205519040479040000000000f,   //   333: sin( 1.8292236)
   0.0320163767000480600000000000f,   //   334: sin( 1.8347168)
   0.0321122012017605530000000000f,   //   335: sin( 1.8402100)
   0.0322080254083045860000000000f,   //   336: sin( 1.8457031)
   0.0323038493187993580000000000f,   //   337: sin( 1.8511963)
   0.0323996729323640860000000000f,   //   338: sin( 1.8566895)
   0.0324954962481179620000000000f,   //   339: sin( 1.8621826)
   0.0325913192651802260000000000f,   //   340: sin( 1.8676758)
   0.0326871419826700660000000000f,   //   341: sin( 1.8731689)
   0.0327829643997067240000000000f,   //   342: sin( 1.8786621)
   0.0328787865154094100000000000f,   //   343: sin( 1.8841553)
   0.0329746083288973350000000000f,   //   344: sin( 1.8896484)
   0.0330704298392897470000000000f,   //   345: sin( 1.8951416)
   0.0331662510457058570000000000f,   //   346: sin( 1.9006348)
   0.0332620719472649170000000000f,   //   347: sin( 1.9061279)
   0.0333578925430861390000000000f,   //   348: sin( 1.9116211)
   0.0334537128322887830000000000f,   //   349: sin( 1.9171143)
   0.0335495328139920680000000000f,   //   350: sin( 1.9226074)
   0.0336453524873152540000000000f,   //   351: sin( 1.9281006)
   0.0337411718513775800000000000f,   //   352: sin( 1.9335937)
   0.0338369909052982990000000000f,   //   353: sin( 1.9390869)
   0.0339328096481966640000000000f,   //   354: sin( 1.9445801)
   0.0340286280791919150000000000f,   //   355: sin( 1.9500732)
   0.0341244461974033260000000000f,   //   356: sin( 1.9555664)
   0.0342202640019501420000000000f,   //   357: sin( 1.9610596)
   0.0343160814919516510000000000f,   //   358: sin( 1.9665527)
   0.0344118986665270940000000000f,   //   359: sin( 1.9720459)
   0.0345077155247957500000000000f,   //   360: sin( 1.9775391)
   0.0346035320658768940000000000f,   //   361: sin( 1.9830322)
   0.0346993482888897990000000000f,   //   362: sin( 1.9885254)
   0.0347951641929537470000000000f,   //   363: sin( 1.9940186)
   0.0348909797771880040000000000f,   //   364: sin( 1.9995117)
   0.0349867950407118660000000000f,   //   365: sin( 2.0050049)
   0.0350826099826446190000000000f,   //   366: sin( 2.0104980)
   0.0351784246021055530000000000f,   //   367: sin( 2.0159912)
   0.0352742388982139470000000000f,   //   368: sin( 2.0214844)
   0.0353700528700891180000000000f,   //   369: sin( 2.0269775)
   0.0354658665168503530000000000f,   //   370: sin( 2.0324707)
   0.0355616798376169540000000000f,   //   371: sin( 2.0379639)
   0.0356574928315082220000000000f,   //   372: sin( 2.0434570)
   0.0357533054976434740000000000f,   //   373: sin( 2.0489502)
   0.0358491178351420180000000000f,   //   374: sin( 2.0544434)
   0.0359449298431231620000000000f,   //   375: sin( 2.0599365)
   0.0360407415207062290000000000f,   //   376: sin( 2.0654297)
   0.0361365528670105280000000000f,   //   377: sin( 2.0709229)
   0.0362323638811553950000000000f,   //   378: sin( 2.0764160)
   0.0363281745622601390000000000f,   //   379: sin( 2.0819092)
   0.0364239849094441100000000000f,   //   380: sin( 2.0874023)
   0.0365197949218266230000000000f,   //   381: sin( 2.0928955)
   0.0366156045985270300000000000f,   //   382: sin( 2.0983887)
   0.0367114139386646440000000000f,   //   383: sin( 2.1038818)
   0.0368072229413588320000000000f,   //   384: sin( 2.1093750)
   0.0369030316057289210000000000f,   //   385: sin( 2.1148682)
   0.0369988399308942630000000000f,   //   386: sin( 2.1203613)
   0.0370946479159742150000000000f,   //   387: sin( 2.1258545)
   0.0371904555600881190000000000f,   //   388: sin( 2.1313477)
   0.0372862628623553400000000000f,   //   389: sin( 2.1368408)
   0.0373820698218952290000000000f,   //   390: sin( 2.1423340)
   0.0374778764378271640000000000f,   //   391: sin( 2.1478271)
   0.0375736827092704940000000000f,   //   392: sin( 2.1533203)
   0.0376694886353446110000000000f,   //   393: sin( 2.1588135)
   0.0377652942151688600000000000f,   //   394: sin( 2.1643066)
   0.0378610994478626380000000000f,   //   395: sin( 2.1697998)
   0.0379569043325453100000000000f,   //   396: sin( 2.1752930)
   0.0380527088683362620000000000f,   //   397: sin( 2.1807861)
   0.0381485130543548910000000000f,   //   398: sin( 2.1862793)
   0.0382443168897205680000000000f,   //   399: sin( 2.1917725)
   0.0383401203735526940000000000f,   //   400: sin( 2.1972656)
   0.0384359235049706590000000000f,   //   401: sin( 2.2027588)
   0.0385317262830938700000000000f,   //   402: sin( 2.2082520)
   0.0386275287070417180000000000f,   //   403: sin( 2.2137451)
   0.0387233307759336230000000000f,   //   404: sin( 2.2192383)
   0.0388191324888889700000000000f,   //   405: sin( 2.2247314)
   0.0389149338450271930000000000f,   //   406: sin( 2.2302246)
   0.0390107348434676900000000000f,   //   407: sin( 2.2357178)
   0.0391065354833298880000000000f,   //   408: sin( 2.2412109)
   0.0392023357637332000000000000f,   //   409: sin( 2.2467041)
   0.0392981356837970590000000000f,   //   410: sin( 2.2521973)
   0.0393939352426408910000000000f,   //   411: sin( 2.2576904)
   0.0394897344393841180000000000f,   //   412: sin( 2.2631836)
   0.0395855332731461920000000000f,   //   413: sin( 2.2686768)
   0.0396813317430465270000000000f,   //   414: sin( 2.2741699)
   0.0397771298482045910000000000f,   //   415: sin( 2.2796631)
   0.0398729275877398110000000000f,   //   416: sin( 2.2851563)
   0.0399687249607716330000000000f,   //   417: sin( 2.2906494)
   0.0400645219664195200000000000f,   //   418: sin( 2.2961426)
   0.0401603186038029110000000000f,   //   419: sin( 2.3016357)
   0.0402561148720412820000000000f,   //   420: sin( 2.3071289)
   0.0403519107702540810000000000f,   //   421: sin( 2.3126221)
   0.0404477062975607820000000000f,   //   422: sin( 2.3181152)
   0.0405435014530808390000000000f,   //   423: sin( 2.3236084)
   0.0406392962359337360000000000f,   //   424: sin( 2.3291016)
   0.0407350906452389400000000000f,   //   425: sin( 2.3345947)
   0.0408308846801159480000000000f,   //   426: sin( 2.3400879)
   0.0409266783396842190000000000f,   //   427: sin( 2.3455811)
   0.0410224716230632380000000000f,   //   428: sin( 2.3510742)
   0.0411182645293725130000000000f,   //   429: sin( 2.3565674)
   0.0412140570577315190000000000f,   //   430: sin( 2.3620605)
   0.0413098492072597680000000000f,   //   431: sin( 2.3675537)
   0.0414056409770767390000000000f,   //   432: sin( 2.3730469)
   0.0415014323663019520000000000f,   //   433: sin( 2.3785400)
   0.0415972233740548940000000000f,   //   434: sin( 2.3840332)
   0.0416930139994551030000000000f,   //   435: sin( 2.3895264)
   0.0417888042416220610000000000f,   //   436: sin( 2.3950195)
   0.0418845940996753070000000000f,   //   437: sin( 2.4005127)
   0.0419803835727343560000000000f,   //   438: sin( 2.4060059)
   0.0420761726599187260000000000f,   //   439: sin( 2.4114990)
   0.0421719613603479470000000000f,   //   440: sin( 2.4169922)
   0.0422677496731415500000000000f,   //   441: sin( 2.4224854)
   0.0423635375974190720000000000f,   //   442: sin( 2.4279785)
   0.0424593251323000450000000000f,   //   443: sin( 2.4334717)
   0.0425551122769040200000000000f,   //   444: sin( 2.4389648)
   0.0426508990303505270000000000f,   //   445: sin( 2.4444580)
   0.0427466853917591320000000000f,   //   446: sin( 2.4499512)
   0.0428424713602493720000000000f,   //   447: sin( 2.4554443)
   0.0429382569349408200000000000f,   //   448: sin( 2.4609375)
   0.0430340421149530280000000000f,   //   449: sin( 2.4664307)
   0.0431298268994055460000000000f,   //   450: sin( 2.4719238)
   0.0432256112874179620000000000f,   //   451: sin( 2.4774170)
   0.0433213952781098250000000000f,   //   452: sin( 2.4829102)
   0.0434171788706007310000000000f,   //   453: sin( 2.4884033)
   0.0435129620640102370000000000f,   //   454: sin( 2.4938965)
   0.0436087448574579430000000000f,   //   455: sin( 2.4993896)
   0.0437045272500634210000000000f,   //   456: sin( 2.5048828)
   0.0438003092409462650000000000f,   //   457: sin( 2.5103760)
   0.0438960908292260680000000000f,   //   458: sin( 2.5158691)
   0.0439918720140224300000000000f,   //   459: sin( 2.5213623)
   0.0440876527944549440000000000f,   //   460: sin( 2.5268555)
   0.0441834331696432100000000000f,   //   461: sin( 2.5323486)
   0.0442792131387068490000000000f,   //   462: sin( 2.5378418)
   0.0443749927007654620000000000f,   //   463: sin( 2.5433350)
   0.0444707718549386680000000000f,   //   464: sin( 2.5488281)
   0.0445665506003460750000000000f,   //   465: sin( 2.5543213)
   0.0446623289361073250000000000f,   //   466: sin( 2.5598145)
   0.0447581068613420240000000000f,   //   467: sin( 2.5653076)
   0.0448538843751698150000000000f,   //   468: sin( 2.5708008)
   0.0449496614767103260000000000f,   //   469: sin( 2.5762939)
   0.0450454381650831970000000000f,   //   470: sin( 2.5817871)
   0.0451412144394080780000000000f,   //   471: sin( 2.5872803)
   0.0452369902988045900000000000f,   //   472: sin( 2.5927734)
   0.0453327657423924020000000000f,   //   473: sin( 2.5982666)
   0.0454285407692911550000000000f,   //   474: sin( 2.6037598)
   0.0455243153786205200000000000f,   //   475: sin( 2.6092529)
   0.0456200895695001440000000000f,   //   476: sin( 2.6147461)
   0.0457158633410496980000000000f,   //   477: sin( 2.6202393)
   0.0458116366923888440000000000f,   //   478: sin( 2.6257324)
   0.0459074096226372640000000000f,   //   479: sin( 2.6312256)
   0.0460031821309146230000000000f,   //   480: sin( 2.6367188)
   0.0460989542163406100000000000f,   //   481: sin( 2.6422119)
   0.0461947258780349080000000000f,   //   482: sin( 2.6477051)
   0.0462904971151171870000000000f,   //   483: sin( 2.6531982)
   0.0463862679267071570000000000f,   //   484: sin( 2.6586914)
   0.0464820383119245100000000000f,   //   485: sin( 2.6641846)
   0.0465778082698889430000000000f,   //   486: sin( 2.6696777)
   0.0466735777997201520000000000f,   //   487: sin( 2.6751709)
   0.0467693469005378630000000000f,   //   488: sin( 2.6806641)
   0.0468651155714617660000000000f,   //   489: sin( 2.6861572)
   0.0469608838116115920000000000f,   //   490: sin( 2.6916504)
   0.0470566516201070540000000000f,   //   491: sin( 2.6971436)
   0.0471524189960678690000000000f,   //   492: sin( 2.7026367)
   0.0472481859386137680000000000f,   //   493: sin( 2.7081299)
   0.0473439524468644780000000000f,   //   494: sin( 2.7136230)
   0.0474397185199397500000000000f,   //   495: sin( 2.7191162)
   0.0475354841569593030000000000f,   //   496: sin( 2.7246094)
   0.0476312493570428890000000000f,   //   497: sin( 2.7301025)
   0.0477270141193102540000000000f,   //   498: sin( 2.7355957)
   0.0478227784428811520000000000f,   //   499: sin( 2.7410889)
   0.0479185423268753270000000000f,   //   500: sin( 2.7465820)
   0.0480143057704125600000000000f,   //   501: sin( 2.7520752)
   0.0481100687726125910000000000f,   //   502: sin( 2.7575684)
   0.0482058313325951920000000000f,   //   503: sin( 2.7630615)
   0.0483015934494801440000000000f,   //   504: sin( 2.7685547)
   0.0483973551223872080000000000f,   //   505: sin( 2.7740479)
   0.0484931163504361760000000000f,   //   506: sin( 2.7795410)
   0.0485888771327468230000000000f,   //   507: sin( 2.7850342)
   0.0486846374684389430000000000f,   //   508: sin( 2.7905273)
   0.0487803973566323240000000000f,   //   509: sin( 2.7960205)
   0.0488761567964467600000000000f,   //   510: sin( 2.8015137)
   0.0489719157870020520000000000f,   //   511: sin( 2.8070068)
   0.0490676743274180150000000000f,   //   512: sin( 2.8125000)
   0.0491634324168144370000000000f,   //   513: sin( 2.8179932)
   0.0492591900543111400000000000f,   //   514: sin( 2.8234863)
   0.0493549472390279460000000000f,   //   515: sin( 2.8289795)
   0.0494507039700846640000000000f,   //   516: sin( 2.8344727)
   0.0495464602466011290000000000f,   //   517: sin( 2.8399658)
   0.0496422160676971560000000000f,   //   518: sin( 2.8454590)
   0.0497379714324926030000000000f,   //   519: sin( 2.8509521)
   0.0498337263401072770000000000f,   //   520: sin( 2.8564453)
   0.0499294807896610430000000000f,   //   521: sin( 2.8619385)
   0.0500252347802737290000000000f,   //   522: sin( 2.8674316)
   0.0501209883110652070000000000f,   //   523: sin( 2.8729248)
   0.0502167413811553110000000000f,   //   524: sin( 2.8784180)
   0.0503124939896638990000000000f,   //   525: sin( 2.8839111)
   0.0504082461357108560000000000f,   //   526: sin( 2.8894043)
   0.0505039978184160170000000000f,   //   527: sin( 2.8948975)
   0.0505997490368992820000000000f,   //   528: sin( 2.9003906)
   0.0506954997902805060000000000f,   //   529: sin( 2.9058838)
   0.0507912500776795810000000000f,   //   530: sin( 2.9113770)
   0.0508869998982163780000000000f,   //   531: sin( 2.9168701)
   0.0509827492510108030000000000f,   //   532: sin( 2.9223633)
   0.0510784981351827330000000000f,   //   533: sin( 2.9278564)
   0.0511742465498520800000000000f,   //   534: sin( 2.9333496)
   0.0512699944941387290000000000f,   //   535: sin( 2.9388428)
   0.0513657419671625930000000000f,   //   536: sin( 2.9443359)
   0.0514614889680435820000000000f,   //   537: sin( 2.9498291)
   0.0515572354959016110000000000f,   //   538: sin( 2.9553223)
   0.0516529815498565980000000000f,   //   539: sin( 2.9608154)
   0.0517487271290284560000000000f,   //   540: sin( 2.9663086)
   0.0518444722325371310000000000f,   //   541: sin( 2.9718018)
   0.0519402168595025360000000000f,   //   542: sin( 2.9772949)
   0.0520359610090446250000000000f,   //   543: sin( 2.9827881)
   0.0521317046802833240000000000f,   //   544: sin( 2.9882813)
   0.0522274478723385800000000000f,   //   545: sin( 2.9937744)
   0.0523231905843303470000000000f,   //   546: sin( 2.9992676)
   0.0524189328153785720000000000f,   //   547: sin( 3.0047607)
   0.0525146745646032230000000000f,   //   548: sin( 3.0102539)
   0.0526104158311242460000000000f,   //   549: sin( 3.0157471)
   0.0527061566140616320000000000f,   //   550: sin( 3.0212402)
   0.0528018969125353260000000000f,   //   551: sin( 3.0267334)
   0.0528976367256653240000000000f,   //   552: sin( 3.0322266)
   0.0529933760525715950000000000f,   //   553: sin( 3.0377197)
   0.0530891148923741330000000000f,   //   554: sin( 3.0432129)
   0.0531848532441929200000000000f,   //   555: sin( 3.0487061)
   0.0532805911071479450000000000f,   //   556: sin( 3.0541992)
   0.0533763284803592180000000000f,   //   557: sin( 3.0596924)
   0.0534720653629467270000000000f,   //   558: sin( 3.0651855)
   0.0535678017540304960000000000f,   //   559: sin( 3.0706787)
   0.0536635376527305200000000000f,   //   560: sin( 3.0761719)
   0.0537592730581668360000000000f,   //   561: sin( 3.0816650)
   0.0538550079694594400000000000f,   //   562: sin( 3.0871582)
   0.0539507423857283760000000000f,   //   563: sin( 3.0926514)
   0.0540464763060936600000000000f,   //   564: sin( 3.0981445)
   0.0541422097296753450000000000f,   //   565: sin( 3.1036377)
   0.0542379426555934520000000000f,   //   566: sin( 3.1091309)
   0.0543336750829680330000000000f,   //   567: sin( 3.1146240)
   0.0544294070109191330000000000f,   //   568: sin( 3.1201172)
   0.0545251384385668020000000000f,   //   569: sin( 3.1256104)
   0.0546208693650311050000000000f,   //   570: sin( 3.1311035)
   0.0547165997894321010000000000f,   //   571: sin( 3.1365967)
   0.0548123297108898540000000000f,   //   572: sin( 3.1420898)
   0.0549080591285244290000000000f,   //   573: sin( 3.1475830)
   0.0550037880414559200000000000f,   //   574: sin( 3.1530762)
   0.0550995164488043910000000000f,   //   575: sin( 3.1585693)
   0.0551952443496899340000000000f,   //   576: sin( 3.1640625)
   0.0552909717432326430000000000f,   //   577: sin( 3.1695557)
   0.0553866986285525970000000000f,   //   578: sin( 3.1750488)
   0.0554824250047699160000000000f,   //   579: sin( 3.1805420)
   0.0555781508710046780000000000f,   //   580: sin( 3.1860352)
   0.0556738762263770180000000000f,   //   581: sin( 3.1915283)
   0.0557696010700070300000000000f,   //   582: sin( 3.1970215)
   0.0558653254010148400000000000f,   //   583: sin( 3.2025146)
   0.0559610492185205690000000000f,   //   584: sin( 3.2080078)
   0.0560567725216443440000000000f,   //   585: sin( 3.2135010)
   0.0561524953095062920000000000f,   //   586: sin( 3.2189941)
   0.0562482175812265630000000000f,   //   587: sin( 3.2244873)
   0.0563439393359252900000000000f,   //   588: sin( 3.2299805)
   0.0564396605727226150000000000f,   //   589: sin( 3.2354736)
   0.0565353812907387000000000000f,   //   590: sin( 3.2409668)
   0.0566311014890936850000000000f,   //   591: sin( 3.2464600)
   0.0567268211669077480000000000f,   //   592: sin( 3.2519531)
   0.0568225403233010360000000000f,   //   593: sin( 3.2574463)
   0.0569182589573937400000000000f,   //   594: sin( 3.2629395)
   0.0570139770683060140000000000f,   //   595: sin( 3.2684326)
   0.0571096946551580620000000000f,   //   596: sin( 3.2739258)
   0.0572054117170700400000000000f,   //   597: sin( 3.2794189)
   0.0573011282531621580000000000f,   //   598: sin( 3.2849121)
   0.0573968442625546050000000000f,   //   599: sin( 3.2904053)
   0.0574925597443675660000000000f,   //   600: sin( 3.2958984)
   0.0575882746977212710000000000f,   //   601: sin( 3.3013916)
   0.0576839891217359040000000000f,   //   602: sin( 3.3068848)
   0.0577797030155317030000000000f,   //   603: sin( 3.3123779)
   0.0578754163782288570000000000f,   //   604: sin( 3.3178711)
   0.0579711292089476190000000000f,   //   605: sin( 3.3233643)
   0.0580668415068081940000000000f,   //   606: sin( 3.3288574)
   0.0581625532709308320000000000f,   //   607: sin( 3.3343506)
   0.0582582645004357520000000000f,   //   608: sin( 3.3398438)
   0.0583539751944432210000000000f,   //   609: sin( 3.3453369)
   0.0584496853520734760000000000f,   //   610: sin( 3.3508301)
   0.0585453949724467560000000000f,   //   611: sin( 3.3563232)
   0.0586411040546833410000000000f,   //   612: sin( 3.3618164)
   0.0587368125979034690000000000f,   //   613: sin( 3.3673096)
   0.0588325206012274350000000000f,   //   614: sin( 3.3728027)
   0.0589282280637754910000000000f,   //   615: sin( 3.3782959)
   0.0590239349846679310000000000f,   //   616: sin( 3.3837891)
   0.0591196413630250200000000000f,   //   617: sin( 3.3892822)
   0.0592153471979670610000000000f,   //   618: sin( 3.3947754)
   0.0593110524886143390000000000f,   //   619: sin( 3.4002686)
   0.0594067572340871500000000000f,   //   620: sin( 3.4057617)
   0.0595024614335058000000000000f,   //   621: sin( 3.4112549)
   0.0595981650859905910000000000f,   //   622: sin( 3.4167480)
   0.0596938681906618450000000000f,   //   623: sin( 3.4222412)
   0.0597895707466398680000000000f,   //   624: sin( 3.4277344)
   0.0598852727530449980000000000f,   //   625: sin( 3.4332275)
   0.0599809742089975480000000000f,   //   626: sin( 3.4387207)
   0.0600766751136178610000000000f,   //   627: sin( 3.4442139)
   0.0601723754660262590000000000f,   //   628: sin( 3.4497070)
   0.0602680752653431130000000000f,   //   629: sin( 3.4552002)
   0.0603637745106887430000000000f,   //   630: sin( 3.4606934)
   0.0604594732011835140000000000f,   //   631: sin( 3.4661865)
   0.0605551713359477880000000000f,   //   632: sin( 3.4716797)
   0.0606508689141019160000000000f,   //   633: sin( 3.4771729)
   0.0607465659347662880000000000f,   //   634: sin( 3.4826660)
   0.0608422623970612460000000000f,   //   635: sin( 3.4881592)
   0.0609379583001072030000000000f,   //   636: sin( 3.4936523)
   0.0610336536430245160000000000f,   //   637: sin( 3.4991455)
   0.0611293484249335880000000000f,   //   638: sin( 3.5046387)
   0.0612250426449548050000000000f,   //   639: sin( 3.5101318)
   0.0613207363022085780000000000f,   //   640: sin( 3.5156250)
   0.0614164293958152990000000000f,   //   641: sin( 3.5211182)
   0.0615121219248953780000000000f,   //   642: sin( 3.5266113)
   0.0616078138885692430000000000f,   //   643: sin( 3.5321045)
   0.0617035052859572980000000000f,   //   644: sin( 3.5375977)
   0.0617991961161799830000000000f,   //   645: sin( 3.5430908)
   0.0618948863783577160000000000f,   //   646: sin( 3.5485840)
   0.0619905760716109380000000000f,   //   647: sin( 3.5540771)
   0.0620862651950600880000000000f,   //   648: sin( 3.5595703)
   0.0621819537478256190000000000f,   //   649: sin( 3.5650635)
   0.0622776417290279720000000000f,   //   650: sin( 3.5705566)
   0.0623733291377876130000000000f,   //   651: sin( 3.5760498)
   0.0624690159732249960000000000f,   //   652: sin( 3.5815430)
   0.0625647022344606040000000000f,   //   653: sin( 3.5870361)
   0.0626603879206148740000000000f,   //   654: sin( 3.5925293)
   0.0627560730308083240000000000f,   //   655: sin( 3.5980225)
   0.0628517575641614060000000000f,   //   656: sin( 3.6035156)
   0.0629474415197946450000000000f,   //   657: sin( 3.6090088)
   0.0630431248968284920000000000f,   //   658: sin( 3.6145020)
   0.0631388076943834590000000000f,   //   659: sin( 3.6199951)
   0.0632344899115800660000000000f,   //   660: sin( 3.6254883)
   0.0633301715475388240000000000f,   //   661: sin( 3.6309814)
   0.0634258526013802280000000000f,   //   662: sin( 3.6364746)
   0.0635215330722248140000000000f,   //   663: sin( 3.6419678)
   0.0636172129591931060000000000f,   //   664: sin( 3.6474609)
   0.0637128922614056130000000000f,   //   665: sin( 3.6529541)
   0.0638085709779828980000000000f,   //   666: sin( 3.6584473)
   0.0639042491080454860000000000f,   //   667: sin( 3.6639404)
   0.0639999266507139400000000000f,   //   668: sin( 3.6694336)
   0.0640956036051087970000000000f,   //   669: sin( 3.6749268)
   0.0641912799703506370000000000f,   //   670: sin( 3.6804199)
   0.0642869557455599950000000000f,   //   671: sin( 3.6859131)
   0.0643826309298574650000000000f,   //   672: sin( 3.6914063)
   0.0644783055223635960000000000f,   //   673: sin( 3.6968994)
   0.0645739795221989820000000000f,   //   674: sin( 3.7023926)
   0.0646696529284842280000000000f,   //   675: sin( 3.7078857)
   0.0647653257403398850000000000f,   //   676: sin( 3.7133789)
   0.0648609979568865600000000000f,   //   677: sin( 3.7188721)
   0.0649566695772448720000000000f,   //   678: sin( 3.7243652)
   0.0650523406005354410000000000f,   //   679: sin( 3.7298584)
   0.0651480110258788330000000000f,   //   680: sin( 3.7353516)
   0.0652436808523956800000000000f,   //   681: sin( 3.7408447)
   0.0653393500792066320000000000f,   //   682: sin( 3.7463379)
   0.0654350187054323070000000000f,   //   683: sin( 3.7518311)
   0.0655306867301933270000000000f,   //   684: sin( 3.7573242)
   0.0656263541526103390000000000f,   //   685: sin( 3.7628174)
   0.0657220209718039900000000000f,   //   686: sin( 3.7683105)
   0.0658176871868949300000000000f,   //   687: sin( 3.7738037)
   0.0659133527970038050000000000f,   //   688: sin( 3.7792969)
   0.0660090178012513050000000000f,   //   689: sin( 3.7847900)
   0.0661046821987580770000000000f,   //   690: sin( 3.7902832)
   0.0662003459886447850000000000f,   //   691: sin( 3.7957764)
   0.0662960091700321300000000000f,   //   692: sin( 3.8012695)
   0.0663916717420407890000000000f,   //   693: sin( 3.8067627)
   0.0664873337037914510000000000f,   //   694: sin( 3.8122559)
   0.0665829950544048060000000000f,   //   695: sin( 3.8177490)
   0.0666786557930015570000000000f,   //   696: sin( 3.8232422)
   0.0667743159187024340000000000f,   //   697: sin( 3.8287354)
   0.0668699754306281150000000000f,   //   698: sin( 3.8342285)
   0.0669656343278993430000000000f,   //   699: sin( 3.8397217)
   0.0670612926096368220000000000f,   //   700: sin( 3.8452148)
   0.0671569502749612970000000000f,   //   701: sin( 3.8507080)
   0.0672526073229934990000000000f,   //   702: sin( 3.8562012)
   0.0673482637528541730000000000f,   //   703: sin( 3.8616943)
   0.0674439195636640510000000000f,   //   704: sin( 3.8671875)
   0.0675395747545439050000000000f,   //   705: sin( 3.8726807)
   0.0676352293246144790000000000f,   //   706: sin( 3.8781738)
   0.0677308832729965480000000000f,   //   707: sin( 3.8836670)
   0.0678265365988108690000000000f,   //   708: sin( 3.8891602)
   0.0679221893011782290000000000f,   //   709: sin( 3.8946533)
   0.0680178413792193880000000000f,   //   710: sin( 3.9001465)
   0.0681134928320551590000000000f,   //   711: sin( 3.9056396)
   0.0682091436588063290000000000f,   //   712: sin( 3.9111328)
   0.0683047938585936710000000000f,   //   713: sin( 3.9166260)
   0.0684004434305380130000000000f,   //   714: sin( 3.9221191)
   0.0684960923737601840000000000f,   //   715: sin( 3.9276123)
   0.0685917406873809420000000000f,   //   716: sin( 3.9331055)
   0.0686873883705211570000000000f,   //   717: sin( 3.9385986)
   0.0687830354223016300000000000f,   //   718: sin( 3.9440918)
   0.0688786818418432310000000000f,   //   719: sin( 3.9495850)
   0.0689743276282667460000000000f,   //   720: sin( 3.9550781)
   0.0690699727806930450000000000f,   //   721: sin( 3.9605713)
   0.0691656172982429850000000000f,   //   722: sin( 3.9660645)
   0.0692612611800374200000000000f,   //   723: sin( 3.9715576)
   0.0693569044251972080000000000f,   //   724: sin( 3.9770508)
   0.0694525470328432040000000000f,   //   725: sin( 3.9825439)
   0.0695481890020963060000000000f,   //   726: sin( 3.9880371)
   0.0696438303320773690000000000f,   //   727: sin( 3.9935303)
   0.0697394710219073070000000000f,   //   728: sin( 3.9990234)
   0.0698351110707069730000000000f,   //   729: sin( 4.0045166)
   0.0699307504775973090000000000f,   //   730: sin( 4.0100098)
   0.0700263892416991970000000000f,   //   731: sin( 4.0155029)
   0.0701220273621335210000000000f,   //   732: sin( 4.0209961)
   0.0702176648380212350000000000f,   //   733: sin( 4.0264893)
   0.0703133016684832500000000000f,   //   734: sin( 4.0319824)
   0.0704089378526404770000000000f,   //   735: sin( 4.0374756)
   0.0705045733896138560000000000f,   //   736: sin( 4.0429688)
   0.0706002082785243400000000000f,   //   737: sin( 4.0484619)
   0.0706958425184928550000000000f,   //   738: sin( 4.0539551)
   0.0707914761086403530000000000f,   //   739: sin( 4.0594482)
   0.0708871090480878010000000000f,   //   740: sin( 4.0649414)
   0.0709827413359561680000000000f,   //   741: sin( 4.0704346)
   0.0710783729713664050000000000f,   //   742: sin( 4.0759277)
   0.0711740039534394800000000000f,   //   743: sin( 4.0814209)
   0.0712696342812964010000000000f,   //   744: sin( 4.0869141)
   0.0713652639540581360000000000f,   //   745: sin( 4.0924072)
   0.0714608929708456800000000000f,   //   746: sin( 4.0979004)
   0.0715565213307800400000000000f,   //   747: sin( 4.1033936)
   0.0716521490329822120000000000f,   //   748: sin( 4.1088867)
   0.0717477760765732050000000000f,   //   749: sin( 4.1143799)
   0.0718434024606740270000000000f,   //   750: sin( 4.1198730)
   0.0719390281844057290000000000f,   //   751: sin( 4.1253662)
   0.0720346532468893320000000000f,   //   752: sin( 4.1308594)
   0.0721302776472458470000000000f,   //   753: sin( 4.1363525)
   0.0722259013845963220000000000f,   //   754: sin( 4.1418457)
   0.0723215244580618230000000000f,   //   755: sin( 4.1473389)
   0.0724171468667634130000000000f,   //   756: sin( 4.1528320)
   0.0725127686098221010000000000f,   //   757: sin( 4.1583252)
   0.0726083896863589930000000000f,   //   758: sin( 4.1638184)
   0.0727040100954951670000000000f,   //   759: sin( 4.1693115)
   0.0727996298363516730000000000f,   //   760: sin( 4.1748047)
   0.0728952489080496040000000000f,   //   761: sin( 4.1802979)
   0.0729908673097100360000000000f,   //   762: sin( 4.1857910)
   0.0730864850404541190000000000f,   //   763: sin( 4.1912842)
   0.0731821020994028880000000000f,   //   764: sin( 4.1967773)
   0.0732777184856774900000000000f,   //   765: sin( 4.2022705)
   0.0733733341983990320000000000f,   //   766: sin( 4.2077637)
   0.0734689492366886330000000000f,   //   767: sin( 4.2132568)
   0.0735645635996674260000000000f,   //   768: sin( 4.2187500)
   0.0736601772864565190000000000f,   //   769: sin( 4.2242432)
   0.0737557902961770980000000000f,   //   770: sin( 4.2297363)
   0.0738514026279502720000000000f,   //   771: sin( 4.2352295)
   0.0739470142808972000000000000f,   //   772: sin( 4.2407227)
   0.0740426252541390440000000000f,   //   773: sin( 4.2462158)
   0.0741382355467969790000000000f,   //   774: sin( 4.2517090)
   0.0742338451579921540000000000f,   //   775: sin( 4.2572021)
   0.0743294540868457560000000000f,   //   776: sin( 4.2626953)
   0.0744250623324789750000000000f,   //   777: sin( 4.2681885)
   0.0745206698940130000000000000f,   //   778: sin( 4.2736816)
   0.0746162767705690070000000000f,   //   779: sin( 4.2791748)
   0.0747118829612682110000000000f,   //   780: sin( 4.2846680)
   0.0748074884652318440000000000f,   //   781: sin( 4.2901611)
   0.0749030932815810820000000000f,   //   782: sin( 4.2956543)
   0.0749986974094371540000000000f,   //   783: sin( 4.3011475)
   0.0750943008479213050000000000f,   //   784: sin( 4.3066406)
   0.0751899035961547810000000000f,   //   785: sin( 4.3121338)
   0.0752855056532587690000000000f,   //   786: sin( 4.3176270)
   0.0753811070183545570000000000f,   //   787: sin( 4.3231201)
   0.0754767076905633880000000000f,   //   788: sin( 4.3286133)
   0.0755723076690065360000000000f,   //   789: sin( 4.3341064)
   0.0756679069528052310000000000f,   //   790: sin( 4.3395996)
   0.0757635055410807720000000000f,   //   791: sin( 4.3450928)
   0.0758591034329544470000000000f,   //   792: sin( 4.3505859)
   0.0759547006275475140000000000f,   //   793: sin( 4.3560791)
   0.0760502971239812590000000000f,   //   794: sin( 4.3615723)
   0.0761458929213770090000000000f,   //   795: sin( 4.3670654)
   0.0762414880188560660000000000f,   //   796: sin( 4.3725586)
   0.0763370824155397140000000000f,   //   797: sin( 4.3780518)
   0.0764326761105492830000000000f,   //   798: sin( 4.3835449)
   0.0765282691030060860000000000f,   //   799: sin( 4.3890381)
   0.0766238613920314920000000000f,   //   800: sin( 4.3945313)
   0.0767194529767467880000000000f,   //   801: sin( 4.4000244)
   0.0768150438562733430000000000f,   //   802: sin( 4.4055176)
   0.0769106340297325140000000000f,   //   803: sin( 4.4110107)
   0.0770062234962456400000000000f,   //   804: sin( 4.4165039)
   0.0771018122549340800000000000f,   //   805: sin( 4.4219971)
   0.0771974003049192000000000000f,   //   806: sin( 4.4274902)
   0.0772929876453224140000000000f,   //   807: sin( 4.4329834)
   0.0773885742752650490000000000f,   //   808: sin( 4.4384766)
   0.0774841601938685290000000000f,   //   809: sin( 4.4439697)
   0.0775797454002542240000000000f,   //   810: sin( 4.4494629)
   0.0776753298935435740000000000f,   //   811: sin( 4.4549561)
   0.0777709136728579470000000000f,   //   812: sin( 4.4604492)
   0.0778664967373187830000000000f,   //   813: sin( 4.4659424)
   0.0779620790860474920000000000f,   //   814: sin( 4.4714355)
   0.0780576607181655000000000000f,   //   815: sin( 4.4769287)
   0.0781532416327942320000000000f,   //   816: sin( 4.4824219)
   0.0782488218290551540000000000f,   //   817: sin( 4.4879150)
   0.0783444013060697050000000000f,   //   818: sin( 4.4934082)
   0.0784399800629593250000000000f,   //   819: sin( 4.4989014)
   0.0785355580988454790000000000f,   //   820: sin( 4.5043945)
   0.0786311354128496340000000000f,   //   821: sin( 4.5098877)
   0.0787267120040932990000000000f,   //   822: sin( 4.5153809)
   0.0788222878716978990000000000f,   //   823: sin( 4.5208740)
   0.0789178630147849420000000000f,   //   824: sin( 4.5263672)
   0.0790134374324759500000000000f,   //   825: sin( 4.5318604)
   0.0791090111238923750000000000f,   //   826: sin( 4.5373535)
   0.0792045840881557550000000000f,   //   827: sin( 4.5428467)
   0.0793001563243875970000000000f,   //   828: sin( 4.5483398)
   0.0793957278317094370000000000f,   //   829: sin( 4.5538330)
   0.0794912986092427690000000000f,   //   830: sin( 4.5593262)
   0.0795868686561091440000000000f,   //   831: sin( 4.5648193)
   0.0796824379714301260000000000f,   //   832: sin( 4.5703125)
   0.0797780065543272220000000000f,   //   833: sin( 4.5758057)
   0.0798735744039219960000000000f,   //   834: sin( 4.5812988)
   0.0799691415193360260000000000f,   //   835: sin( 4.5867920)
   0.0800647078996908900000000000f,   //   836: sin( 4.5922852)
   0.0801602735441081240000000000f,   //   837: sin( 4.5977783)
   0.0802558384517093190000000000f,   //   838: sin( 4.6032715)
   0.0803514026216160800000000000f,   //   839: sin( 4.6087646)
   0.0804469660529500140000000000f,   //   840: sin( 4.6142578)
   0.0805425287448326700000000000f,   //   841: sin( 4.6197510)
   0.0806380906963857090000000000f,   //   842: sin( 4.6252441)
   0.0807336519067307220000000000f,   //   843: sin( 4.6307373)
   0.0808292123749893290000000000f,   //   844: sin( 4.6362305)
   0.0809247721002831630000000000f,   //   845: sin( 4.6417236)
   0.0810203310817338570000000000f,   //   846: sin( 4.6472168)
   0.0811158893184630720000000000f,   //   847: sin( 4.6527100)
   0.0812114468095924410000000000f,   //   848: sin( 4.6582031)
   0.0813070035542435980000000000f,   //   849: sin( 4.6636963)
   0.0814025595515382450000000000f,   //   850: sin( 4.6691895)
   0.0814981148005980430000000000f,   //   851: sin( 4.6746826)
   0.0815936693005446520000000000f,   //   852: sin( 4.6801758)
   0.0816892230504997620000000000f,   //   853: sin( 4.6856689)
   0.0817847760495850760000000000f,   //   854: sin( 4.6911621)
   0.0818803282969222810000000000f,   //   855: sin( 4.6966553)
   0.0819758797916330660000000000f,   //   856: sin( 4.7021484)
   0.0820714305328391760000000000f,   //   857: sin( 4.7076416)
   0.0821669805196623140000000000f,   //   858: sin( 4.7131348)
   0.0822625297512241810000000000f,   //   859: sin( 4.7186279)
   0.0823580782266465360000000000f,   //   860: sin( 4.7241211)
   0.0824536259450511230000000000f,   //   861: sin( 4.7296143)
   0.0825491729055596730000000000f,   //   862: sin( 4.7351074)
   0.0826447191072939430000000000f,   //   863: sin( 4.7406006)
   0.0827402645493756920000000000f,   //   864: sin( 4.7460938)
   0.0828358092309266910000000000f,   //   865: sin( 4.7515869)
   0.0829313531510686990000000000f,   //   866: sin( 4.7570801)
   0.0830268963089235150000000000f,   //   867: sin( 4.7625732)
   0.0831224387036129110000000000f,   //   868: sin( 4.7680664)
   0.0832179803342587150000000000f,   //   869: sin( 4.7735596)
   0.0833135211999826850000000000f,   //   870: sin( 4.7790527)
   0.0834090612999066480000000000f,   //   871: sin( 4.7845459)
   0.0835046006331524320000000000f,   //   872: sin( 4.7900391)
   0.0836001391988418500000000000f,   //   873: sin( 4.7955322)
   0.0836956769960967160000000000f,   //   874: sin( 4.8010254)
   0.0837912140240388850000000000f,   //   875: sin( 4.8065186)
   0.0838867502817902260000000000f,   //   876: sin( 4.8120117)
   0.0839822857684725250000000000f,   //   877: sin( 4.8175049)
   0.0840778204832076940000000000f,   //   878: sin( 4.8229980)
   0.0841733544251175860000000000f,   //   879: sin( 4.8284912)
   0.0842688875933240710000000000f,   //   880: sin( 4.8339844)
   0.0843644199869490190000000000f,   //   881: sin( 4.8394775)
   0.0844599516051143250000000000f,   //   882: sin( 4.8449707)
   0.0845554824469418880000000000f,   //   883: sin( 4.8504639)
   0.0846510125115536170000000000f,   //   884: sin( 4.8559570)
   0.0847465417980713810000000000f,   //   885: sin( 4.8614502)
   0.0848420703056171340000000000f,   //   886: sin( 4.8669434)
   0.0849375980333128000000000000f,   //   887: sin( 4.8724365)
   0.0850331249802802750000000000f,   //   888: sin( 4.8779297)
   0.0851286511456415260000000000f,   //   889: sin( 4.8834229)
   0.0852241765285184780000000000f,   //   890: sin( 4.8889160)
   0.0853197011280330960000000000f,   //   891: sin( 4.8944092)
   0.0854152249433073330000000000f,   //   892: sin( 4.8999023)
   0.0855107479734631550000000000f,   //   893: sin( 4.9053955)
   0.0856062702176225290000000000f,   //   894: sin( 4.9108887)
   0.0857017916749074490000000000f,   //   895: sin( 4.9163818)
   0.0857973123444398940000000000f,   //   896: sin( 4.9218750)
   0.0858928322253418450000000000f,   //   897: sin( 4.9273682)
   0.0859883513167353370000000000f,   //   898: sin( 4.9328613)
   0.0860838696177423370000000000f,   //   899: sin( 4.9383545)
   0.0861793871274848940000000000f,   //   900: sin( 4.9438477)
   0.0862749038450850160000000000f,   //   901: sin( 4.9493408)
   0.0863704197696647520000000000f,   //   902: sin( 4.9548340)
   0.0864659349003461110000000000f,   //   903: sin( 4.9603271)
   0.0865614492362511700000000000f,   //   904: sin( 4.9658203)
   0.0866569627765019500000000000f,   //   905: sin( 4.9713135)
   0.0867524755202205430000000000f,   //   906: sin( 4.9768066)
   0.0868479874665289840000000000f,   //   907: sin( 4.9822998)
   0.0869434986145493780000000000f,   //   908: sin( 4.9877930)
   0.0870390089634037880000000000f,   //   909: sin( 4.9932861)
   0.0871345185122143070000000000f,   //   910: sin( 4.9987793)
   0.0872300272601030240000000000f,   //   911: sin( 5.0042725)
   0.0873255352061920590000000000f,   //   912: sin( 5.0097656)
   0.0874210423496035310000000000f,   //   913: sin( 5.0152588)
   0.0875165486894595310000000000f,   //   914: sin( 5.0207520)
   0.0876120542248821910000000000f,   //   915: sin( 5.0262451)
   0.0877075589549936590000000000f,   //   916: sin( 5.0317383)
   0.0878030628789160800000000000f,   //   917: sin( 5.0372314)
   0.0878985659957715880000000000f,   //   918: sin( 5.0427246)
   0.0879940683046823300000000000f,   //   919: sin( 5.0482178)
   0.0880895698047705070000000000f,   //   920: sin( 5.0537109)
   0.0881850704951582380000000000f,   //   921: sin( 5.0592041)
   0.0882805703749677400000000000f,   //   922: sin( 5.0646973)
   0.0883760694433211870000000000f,   //   923: sin( 5.0701904)
   0.0884715676993407670000000000f,   //   924: sin( 5.0756836)
   0.0885670651421486820000000000f,   //   925: sin( 5.0811768)
   0.0886625617708671490000000000f,   //   926: sin( 5.0866699)
   0.0887580575846183690000000000f,   //   927: sin( 5.0921631)
   0.0888535525825246000000000000f,   //   928: sin( 5.0976563)
   0.0889490467637080170000000000f,   //   929: sin( 5.1031494)
   0.0890445401272908920000000000f,   //   930: sin( 5.1086426)
   0.0891400326723954810000000000f,   //   931: sin( 5.1141357)
   0.0892355243981440140000000000f,   //   932: sin( 5.1196289)
   0.0893310153036587510000000000f,   //   933: sin( 5.1251221)
   0.0894265053880619610000000000f,   //   934: sin( 5.1306152)
   0.0895219946504759580000000000f,   //   935: sin( 5.1361084)
   0.0896174830900229590000000000f,   //   936: sin( 5.1416016)
   0.0897129707058253040000000000f,   //   937: sin( 5.1470947)
   0.0898084574970052780000000000f,   //   938: sin( 5.1525879)
   0.0899039434626851960000000000f,   //   939: sin( 5.1580811)
   0.0899994286019873410000000000f,   //   940: sin( 5.1635742)
   0.0900949129140340700000000000f,   //   941: sin( 5.1690674)
   0.0901903963979476950000000000f,   //   942: sin( 5.1745605)
   0.0902858790528505430000000000f,   //   943: sin( 5.1800537)
   0.0903813608778649830000000000f,   //   944: sin( 5.1855469)
   0.0904768418721133280000000000f,   //   945: sin( 5.1910400)
   0.0905723220347179890000000000f,   //   946: sin( 5.1965332)
   0.0906678013648012930000000000f,   //   947: sin( 5.2020264)
   0.0907632798614856210000000000f,   //   948: sin( 5.2075195)
   0.0908587575238933710000000000f,   //   949: sin( 5.2130127)
   0.0909542343511469260000000000f,   //   950: sin( 5.2185059)
   0.0910497103423686670000000000f,   //   951: sin( 5.2239990)
   0.0911451854966810050000000000f,   //   952: sin( 5.2294922)
   0.0912406598132063930000000000f,   //   953: sin( 5.2349854)
   0.0913361332910671840000000000f,   //   954: sin( 5.2404785)
   0.0914316059293858590000000000f,   //   955: sin( 5.2459717)
   0.0915270777272848280000000000f,   //   956: sin( 5.2514648)
   0.0916225486838865430000000000f,   //   957: sin( 5.2569580)
   0.0917180187983134550000000000f,   //   958: sin( 5.2624512)
   0.0918134880696880320000000000f,   //   959: sin( 5.2679443)
   0.0919089564971327240000000000f,   //   960: sin( 5.2734375)
   0.0920044240797700250000000000f,   //   961: sin( 5.2789307)
   0.0920998908167223880000000000f,   //   962: sin( 5.2844238)
   0.0921953567071123330000000000f,   //   963: sin( 5.2899170)
   0.0922908217500623550000000000f,   //   964: sin( 5.2954102)
   0.0923862859446949320000000000f,   //   965: sin( 5.3009033)
   0.0924817492901326000000000000f,   //   966: sin( 5.3063965)
   0.0925772117854978820000000000f,   //   967: sin( 5.3118896)
   0.0926726734299133100000000000f,   //   968: sin( 5.3173828)
   0.0927681342225014080000000000f,   //   969: sin( 5.3228760)
   0.0928635941623847240000000000f,   //   970: sin( 5.3283691)
   0.0929590532486858220000000000f,   //   971: sin( 5.3338623)
   0.0930545114805272490000000000f,   //   972: sin( 5.3393555)
   0.0931499688570315700000000000f,   //   973: sin( 5.3448486)
   0.0932454253773213750000000000f,   //   974: sin( 5.3503418)
   0.0933408810405192550000000000f,   //   975: sin( 5.3558350)
   0.0934363358457477870000000000f,   //   976: sin( 5.3613281)
   0.0935317897921295600000000000f,   //   977: sin( 5.3668213)
   0.0936272428787871950000000000f,   //   978: sin( 5.3723145)
   0.0937226951048433230000000000f,   //   979: sin( 5.3778076)
   0.0938181464694205490000000000f,   //   980: sin( 5.3833008)
   0.0939135969716414910000000000f,   //   981: sin( 5.3887939)
   0.0940090466106288380000000000f,   //   982: sin( 5.3942871)
   0.0941044953855051800000000000f,   //   983: sin( 5.3997803)
   0.0941999432953932040000000000f,   //   984: sin( 5.4052734)
   0.0942953903394155580000000000f,   //   985: sin( 5.4107666)
   0.0943908365166949430000000000f,   //   986: sin( 5.4162598)
   0.0944862818263540040000000000f,   //   987: sin( 5.4217529)
   0.0945817262675154450000000000f,   //   988: sin( 5.4272461)
   0.0946771698393019530000000000f,   //   989: sin( 5.4327393)
   0.0947726125408362430000000000f,   //   990: sin( 5.4382324)
   0.0948680543712410170000000000f,   //   991: sin( 5.4437256)
   0.0949634953296389920000000000f,   //   992: sin( 5.4492188)
   0.0950589354151529090000000000f,   //   993: sin( 5.4547119)
   0.0951543746269054860000000000f,   //   994: sin( 5.4602051)
   0.0952498129640194790000000000f,   //   995: sin( 5.4656982)
   0.0953452504256176170000000000f,   //   996: sin( 5.4711914)
   0.0954406870108227000000000000f,   //   997: sin( 5.4766846)
   0.0955361227187574710000000000f,   //   998: sin( 5.4821777)
   0.0956315575485446880000000000f,   //   999: sin( 5.4876709)
   0.0957269914993071620000000000f,   //  1000: sin( 5.4931641)
   0.0958224245701676800000000000f,   //  1001: sin( 5.4986572)
   0.0959178567602490400000000000f,   //  1002: sin( 5.5041504)
   0.0960132880686740270000000000f,   //  1003: sin( 5.5096436)
   0.0961087184945655090000000000f,   //  1004: sin( 5.5151367)
   0.0962041480370462580000000000f,   //  1005: sin( 5.5206299)
   0.0962995766952391280000000000f,   //  1006: sin( 5.5261230)
   0.0963950044682669450000000000f,   //  1007: sin( 5.5316162)
   0.0964904313552525930000000000f,   //  1008: sin( 5.5371094)
   0.0965858573553188960000000000f,   //  1009: sin( 5.5426025)
   0.0966812824675887250000000000f,   //  1010: sin( 5.5480957)
   0.0967767066911849470000000000f,   //  1011: sin( 5.5535889)
   0.0968721300252304710000000000f,   //  1012: sin( 5.5590820)
   0.0969675524688481530000000000f,   //  1013: sin( 5.5645752)
   0.0970629740211609170000000000f,   //  1014: sin( 5.5700684)
   0.0971583946812916570000000000f,   //  1015: sin( 5.5755615)
   0.0972538144483632710000000000f,   //  1016: sin( 5.5810547)
   0.0973492333214986960000000000f,   //  1017: sin( 5.5865479)
   0.0974446512998208700000000000f,   //  1018: sin( 5.5920410)
   0.0975400683824527300000000000f,   //  1019: sin( 5.5975342)
   0.0976354845685172000000000000f,   //  1020: sin( 5.6030273)
   0.0977308998571372600000000000f,   //  1021: sin( 5.6085205)
   0.0978263142474358610000000000f,   //  1022: sin( 5.6140137)
   0.0979217277385359820000000000f,   //  1023: sin( 5.6195068)
   0.0980171403295606040000000000f,   //  1024: sin( 5.6250000)
   0.0981125520196326900000000000f,   //  1025: sin( 5.6304932)
   0.0982079628078752760000000000f,   //  1026: sin( 5.6359863)
   0.0983033726934113280000000000f,   //  1027: sin( 5.6414795)
   0.0983987816753638810000000000f,   //  1028: sin( 5.6469727)
   0.0984941897528559540000000000f,   //  1029: sin( 5.6524658)
   0.0985895969250105840000000000f,   //  1030: sin( 5.6579590)
   0.0986850031909507900000000000f,   //  1031: sin( 5.6634521)
   0.0987804085497996230000000000f,   //  1032: sin( 5.6689453)
   0.0988758130006801430000000000f,   //  1033: sin( 5.6744385)
   0.0989712165427154290000000000f,   //  1034: sin( 5.6799316)
   0.0990666191750285140000000000f,   //  1035: sin( 5.6854248)
   0.0991620208967425030000000000f,   //  1036: sin( 5.6909180)
   0.0992574217069804860000000000f,   //  1037: sin( 5.6964111)
   0.0993528216048655400000000000f,   //  1038: sin( 5.7019043)
   0.0994482205895207830000000000f,   //  1039: sin( 5.7073975)
   0.0995436186600693190000000000f,   //  1040: sin( 5.7128906)
   0.0996390158156343080000000000f,   //  1041: sin( 5.7183838)
   0.0997344120553388250000000000f,   //  1042: sin( 5.7238770)
   0.0998298073783060320000000000f,   //  1043: sin( 5.7293701)
   0.0999252017836590730000000000f,   //  1044: sin( 5.7348633)
   0.1000205952705211200000000000f,   //  1045: sin( 5.7403564)
   0.1001159878380153100000000000f,   //  1046: sin( 5.7458496)
   0.1002113794852648300000000000f,   //  1047: sin( 5.7513428)
   0.1003067702113928600000000000f,   //  1048: sin( 5.7568359)
   0.1004021600155225900000000000f,   //  1049: sin( 5.7623291)
   0.1004975488967772000000000000f,   //  1050: sin( 5.7678223)
   0.1005929368542799200000000000f,   //  1051: sin( 5.7733154)
   0.1006883238871539600000000000f,   //  1052: sin( 5.7788086)
   0.1007837099945225300000000000f,   //  1053: sin( 5.7843018)
   0.1008790951755088600000000000f,   //  1054: sin( 5.7897949)
   0.1009744794292362100000000000f,   //  1055: sin( 5.7952881)
   0.1010698627548278200000000000f,   //  1056: sin( 5.8007813)
   0.1011652451514069400000000000f,   //  1057: sin( 5.8062744)
   0.1012606266180968300000000000f,   //  1058: sin( 5.8117676)
   0.1013560071540207900000000000f,   //  1059: sin( 5.8172607)
   0.1014513867583020800000000000f,   //  1060: sin( 5.8227539)
   0.1015467654300639800000000000f,   //  1061: sin( 5.8282471)
   0.1016421431684298300000000000f,   //  1062: sin( 5.8337402)
   0.1017375199725229100000000000f,   //  1063: sin( 5.8392334)
   0.1018328958414665300000000000f,   //  1064: sin( 5.8447266)
   0.1019282707743840300000000000f,   //  1065: sin( 5.8502197)
   0.1020236447703987400000000000f,   //  1066: sin( 5.8557129)
   0.1021190178286340300000000000f,   //  1067: sin( 5.8612061)
   0.1022143899482132100000000000f,   //  1068: sin( 5.8666992)
   0.1023097611282596400000000000f,   //  1069: sin( 5.8721924)
   0.1024051313678967200000000000f,   //  1070: sin( 5.8776855)
   0.1025005006662478000000000000f,   //  1071: sin( 5.8831787)
   0.1025958690224362800000000000f,   //  1072: sin( 5.8886719)
   0.1026912364355855600000000000f,   //  1073: sin( 5.8941650)
   0.1027866029048190400000000000f,   //  1074: sin( 5.8996582)
   0.1028819684292601200000000000f,   //  1075: sin( 5.9051514)
   0.1029773330080322200000000000f,   //  1076: sin( 5.9106445)
   0.1030726966402587700000000000f,   //  1077: sin( 5.9161377)
   0.1031680593250632300000000000f,   //  1078: sin( 5.9216309)
   0.1032634210615690200000000000f,   //  1079: sin( 5.9271240)
   0.1033587818488996100000000000f,   //  1080: sin( 5.9326172)
   0.1034541416861784700000000000f,   //  1081: sin( 5.9381104)
   0.1035495005725290700000000000f,   //  1082: sin( 5.9436035)
   0.1036448585070748600000000000f,   //  1083: sin( 5.9490967)
   0.1037402154889393700000000000f,   //  1084: sin( 5.9545898)
   0.1038355715172460900000000000f,   //  1085: sin( 5.9600830)
   0.1039309265911185100000000000f,   //  1086: sin( 5.9655762)
   0.1040262807096801600000000000f,   //  1087: sin( 5.9710693)
   0.1041216338720545900000000000f,   //  1088: sin( 5.9765625)
   0.1042169860773652800000000000f,   //  1089: sin( 5.9820557)
   0.1043123373247358000000000000f,   //  1090: sin( 5.9875488)
   0.1044076876132897100000000000f,   //  1091: sin( 5.9930420)
   0.1045030369421505700000000000f,   //  1092: sin( 5.9985352)
   0.1045983853104419400000000000f,   //  1093: sin( 6.0040283)
   0.1046937327172873900000000000f,   //  1094: sin( 6.0095215)
   0.1047890791618105300000000000f,   //  1095: sin( 6.0150146)
   0.1048844246431349700000000000f,   //  1096: sin( 6.0205078)
   0.1049797691603842500000000000f,   //  1097: sin( 6.0260010)
   0.1050751127126820400000000000f,   //  1098: sin( 6.0314941)
   0.1051704552991519500000000000f,   //  1099: sin( 6.0369873)
   0.1052657969189176000000000000f,   //  1100: sin( 6.0424805)
   0.1053611375711026300000000000f,   //  1101: sin( 6.0479736)
   0.1054564772548307100000000000f,   //  1102: sin( 6.0534668)
   0.1055518159692254800000000000f,   //  1103: sin( 6.0589600)
   0.1056471537134106200000000000f,   //  1104: sin( 6.0644531)
   0.1057424904865097700000000000f,   //  1105: sin( 6.0699463)
   0.1058378262876466700000000000f,   //  1106: sin( 6.0754395)
   0.1059331611159449900000000000f,   //  1107: sin( 6.0809326)
   0.1060284949705284100000000000f,   //  1108: sin( 6.0864258)
   0.1061238278505206600000000000f,   //  1109: sin( 6.0919189)
   0.1062191597550454800000000000f,   //  1110: sin( 6.0974121)
   0.1063144906832265700000000000f,   //  1111: sin( 6.1029053)
   0.1064098206341876800000000000f,   //  1112: sin( 6.1083984)
   0.1065051496070525400000000000f,   //  1113: sin( 6.1138916)
   0.1066004776009449600000000000f,   //  1114: sin( 6.1193848)
   0.1066958046149886300000000000f,   //  1115: sin( 6.1248779)
   0.1067911306483073900000000000f,   //  1116: sin( 6.1303711)
   0.1068864557000249900000000000f,   //  1117: sin( 6.1358643)
   0.1069817797692652300000000000f,   //  1118: sin( 6.1413574)
   0.1070771028551519100000000000f,   //  1119: sin( 6.1468506)
   0.1071724249568088400000000000f,   //  1120: sin( 6.1523438)
   0.1072677460733598600000000000f,   //  1121: sin( 6.1578369)
   0.1073630662039287600000000000f,   //  1122: sin( 6.1633301)
   0.1074583853476393900000000000f,   //  1123: sin( 6.1688232)
   0.1075537035036156200000000000f,   //  1124: sin( 6.1743164)
   0.1076490206709813100000000000f,   //  1125: sin( 6.1798096)
   0.1077443368488602800000000000f,   //  1126: sin( 6.1853027)
   0.1078396520363764200000000000f,   //  1127: sin( 6.1907959)
   0.1079349662326536500000000000f,   //  1128: sin( 6.1962891)
   0.1080302794368158400000000000f,   //  1129: sin( 6.2017822)
   0.1081255916479868700000000000f,   //  1130: sin( 6.2072754)
   0.1082209028652906700000000000f,   //  1131: sin( 6.2127686)
   0.1083162130878511700000000000f,   //  1132: sin( 6.2182617)
   0.1084115223147922700000000000f,   //  1133: sin( 6.2237549)
   0.1085068305452379200000000000f,   //  1134: sin( 6.2292480)
   0.1086021377783120800000000000f,   //  1135: sin( 6.2347412)
   0.1086974440131387200000000000f,   //  1136: sin( 6.2402344)
   0.1087927492488417600000000000f,   //  1137: sin( 6.2457275)
   0.1088880534845451900000000000f,   //  1138: sin( 6.2512207)
   0.1089833567193730200000000000f,   //  1139: sin( 6.2567139)
   0.1090786589524492400000000000f,   //  1140: sin( 6.2622070)
   0.1091739601828978100000000000f,   //  1141: sin( 6.2677002)
   0.1092692604098427800000000000f,   //  1142: sin( 6.2731934)
   0.1093645596324081700000000000f,   //  1143: sin( 6.2786865)
   0.1094598578497179800000000000f,   //  1144: sin( 6.2841797)
   0.1095551550608962800000000000f,   //  1145: sin( 6.2896729)
   0.1096504512650671000000000000f,   //  1146: sin( 6.2951660)
   0.1097457464613545300000000000f,   //  1147: sin( 6.3006592)
   0.1098410406488826000000000000f,   //  1148: sin( 6.3061523)
   0.1099363338267753800000000000f,   //  1149: sin( 6.3116455)
   0.1100316259941570000000000000f,   //  1150: sin( 6.3171387)
   0.1101269171501515200000000000f,   //  1151: sin( 6.3226318)
   0.1102222072938830600000000000f,   //  1152: sin( 6.3281250)
   0.1103174964244757100000000000f,   //  1153: sin( 6.3336182)
   0.1104127845410536300000000000f,   //  1154: sin( 6.3391113)
   0.1105080716427409200000000000f,   //  1155: sin( 6.3446045)
   0.1106033577286617300000000000f,   //  1156: sin( 6.3500977)
   0.1106986427979402100000000000f,   //  1157: sin( 6.3555908)
   0.1107939268497005600000000000f,   //  1158: sin( 6.3610840)
   0.1108892098830668900000000000f,   //  1159: sin( 6.3665771)
   0.1109844918971633900000000000f,   //  1160: sin( 6.3720703)
   0.1110797728911142600000000000f,   //  1161: sin( 6.3775635)
   0.1111750528640437200000000000f,   //  1162: sin( 6.3830566)
   0.1112703318150759400000000000f,   //  1163: sin( 6.3885498)
   0.1113656097433351600000000000f,   //  1164: sin( 6.3940430)
   0.1114608866479456000000000000f,   //  1165: sin( 6.3995361)
   0.1115561625280314800000000000f,   //  1166: sin( 6.4050293)
   0.1116514373827170600000000000f,   //  1167: sin( 6.4105225)
   0.1117467112111265900000000000f,   //  1168: sin( 6.4160156)
   0.1118419840123843500000000000f,   //  1169: sin( 6.4215088)
   0.1119372557856145700000000000f,   //  1170: sin( 6.4270020)
   0.1120325265299415700000000000f,   //  1171: sin( 6.4324951)
   0.1121277962444896400000000000f,   //  1172: sin( 6.4379883)
   0.1122230649283830800000000000f,   //  1173: sin( 6.4434814)
   0.1123183325807461700000000000f,   //  1174: sin( 6.4489746)
   0.1124135992007032600000000000f,   //  1175: sin( 6.4544678)
   0.1125088647873786900000000000f,   //  1176: sin( 6.4599609)
   0.1126041293398967600000000000f,   //  1177: sin( 6.4654541)
   0.1126993928573818600000000000f,   //  1178: sin( 6.4709473)
   0.1127946553389583000000000000f,   //  1179: sin( 6.4764404)
   0.1128899167837505200000000000f,   //  1180: sin( 6.4819336)
   0.1129851771908828200000000000f,   //  1181: sin( 6.4874268)
   0.1130804365594796200000000000f,   //  1182: sin( 6.4929199)
   0.1131756948886653300000000000f,   //  1183: sin( 6.4984131)
   0.1132709521775643500000000000f,   //  1184: sin( 6.5039063)
   0.1133662084253010700000000000f,   //  1185: sin( 6.5093994)
   0.1134614636309999500000000000f,   //  1186: sin( 6.5148926)
   0.1135567177937854000000000000f,   //  1187: sin( 6.5203857)
   0.1136519709127818700000000000f,   //  1188: sin( 6.5258789)
   0.1137472229871138200000000000f,   //  1189: sin( 6.5313721)
   0.1138424740159057100000000000f,   //  1190: sin( 6.5368652)
   0.1139377239982820200000000000f,   //  1191: sin( 6.5423584)
   0.1140329729333672000000000000f,   //  1192: sin( 6.5478516)
   0.1141282208202857900000000000f,   //  1193: sin( 6.5533447)
   0.1142234676581622600000000000f,   //  1194: sin( 6.5588379)
   0.1143187134461211300000000000f,   //  1195: sin( 6.5643311)
   0.1144139581832869200000000000f,   //  1196: sin( 6.5698242)
   0.1145092018687841700000000000f,   //  1197: sin( 6.5753174)
   0.1146044445017374200000000000f,   //  1198: sin( 6.5808105)
   0.1146996860812711900000000000f,   //  1199: sin( 6.5863037)
   0.1147949266065100800000000000f,   //  1200: sin( 6.5917969)
   0.1148901660765786300000000000f,   //  1201: sin( 6.5972900)
   0.1149854044906014600000000000f,   //  1202: sin( 6.6027832)
   0.1150806418477031000000000000f,   //  1203: sin( 6.6082764)
   0.1151758781470081900000000000f,   //  1204: sin( 6.6137695)
   0.1152711133876413300000000000f,   //  1205: sin( 6.6192627)
   0.1153663475687271400000000000f,   //  1206: sin( 6.6247559)
   0.1154615806893902300000000000f,   //  1207: sin( 6.6302490)
   0.1155568127487552600000000000f,   //  1208: sin( 6.6357422)
   0.1156520437459468800000000000f,   //  1209: sin( 6.6412354)
   0.1157472736800897200000000000f,   //  1210: sin( 6.6467285)
   0.1158425025503084700000000000f,   //  1211: sin( 6.6522217)
   0.1159377303557277800000000000f,   //  1212: sin( 6.6577148)
   0.1160329570954723900000000000f,   //  1213: sin( 6.6632080)
   0.1161281827686669300000000000f,   //  1214: sin( 6.6687012)
   0.1162234073744361500000000000f,   //  1215: sin( 6.6741943)
   0.1163186309119047500000000000f,   //  1216: sin( 6.6796875)
   0.1164138533801974800000000000f,   //  1217: sin( 6.6851807)
   0.1165090747784390400000000000f,   //  1218: sin( 6.6906738)
   0.1166042951057541800000000000f,   //  1219: sin( 6.6961670)
   0.1166995143612676900000000000f,   //  1220: sin( 6.7016602)
   0.1167947325441043000000000000f,   //  1221: sin( 6.7071533)
   0.1168899496533887800000000000f,   //  1222: sin( 6.7126465)
   0.1169851656882459500000000000f,   //  1223: sin( 6.7181396)
   0.1170803806478005900000000000f,   //  1224: sin( 6.7236328)
   0.1171755945311774800000000000f,   //  1225: sin( 6.7291260)
   0.1172708073375014600000000000f,   //  1226: sin( 6.7346191)
   0.1173660190658973600000000000f,   //  1227: sin( 6.7401123)
   0.1174612297154899900000000000f,   //  1228: sin( 6.7456055)
   0.1175564392854042000000000000f,   //  1229: sin( 6.7510986)
   0.1176516477747648600000000000f,   //  1230: sin( 6.7565918)
   0.1177468551826968300000000000f,   //  1231: sin( 6.7620850)
   0.1178420615083249800000000000f,   //  1232: sin( 6.7675781)
   0.1179372667507741800000000000f,   //  1233: sin( 6.7730713)
   0.1180324709091693400000000000f,   //  1234: sin( 6.7785645)
   0.1181276739826353600000000000f,   //  1235: sin( 6.7840576)
   0.1182228759702971700000000000f,   //  1236: sin( 6.7895508)
   0.1183180768712796500000000000f,   //  1237: sin( 6.7950439)
   0.1184132766847077900000000000f,   //  1238: sin( 6.8005371)
   0.1185084754097064900000000000f,   //  1239: sin( 6.8060303)
   0.1186036730454007200000000000f,   //  1240: sin( 6.8115234)
   0.1186988695909154300000000000f,   //  1241: sin( 6.8170166)
   0.1187940650453756400000000000f,   //  1242: sin( 6.8225098)
   0.1188892594079062800000000000f,   //  1243: sin( 6.8280029)
   0.1189844526776323400000000000f,   //  1244: sin( 6.8334961)
   0.1190796448536788800000000000f,   //  1245: sin( 6.8389893)
   0.1191748359351708800000000000f,   //  1246: sin( 6.8444824)
   0.1192700259212333600000000000f,   //  1247: sin( 6.8499756)
   0.1193652148109913500000000000f,   //  1248: sin( 6.8554688)
   0.1194604026035699400000000000f,   //  1249: sin( 6.8609619)
   0.1195555892980941100000000000f,   //  1250: sin( 6.8664551)
   0.1196507748936889700000000000f,   //  1251: sin( 6.8719482)
   0.1197459593894796000000000000f,   //  1252: sin( 6.8774414)
   0.1198411427845910700000000000f,   //  1253: sin( 6.8829346)
   0.1199363250781484700000000000f,   //  1254: sin( 6.8884277)
   0.1200315062692769000000000000f,   //  1255: sin( 6.8939209)
   0.1201266863571015000000000000f,   //  1256: sin( 6.8994141)
   0.1202218653407474000000000000f,   //  1257: sin( 6.9049072)
   0.1203170432193396800000000000f,   //  1258: sin( 6.9104004)
   0.1204122199920035500000000000f,   //  1259: sin( 6.9158936)
   0.1205073956578641300000000000f,   //  1260: sin( 6.9213867)
   0.1206025702160465900000000000f,   //  1261: sin( 6.9268799)
   0.1206977436656761100000000000f,   //  1262: sin( 6.9323730)
   0.1207929160058778700000000000f,   //  1263: sin( 6.9378662)
   0.1208880872357770800000000000f,   //  1264: sin( 6.9433594)
   0.1209832573544989300000000000f,   //  1265: sin( 6.9488525)
   0.1210784263611686400000000000f,   //  1266: sin( 6.9543457)
   0.1211735942549114500000000000f,   //  1267: sin( 6.9598389)
   0.1212687610348526000000000000f,   //  1268: sin( 6.9653320)
   0.1213639267001173100000000000f,   //  1269: sin( 6.9708252)
   0.1214590912498308400000000000f,   //  1270: sin( 6.9763184)
   0.1215542546831185100000000000f,   //  1271: sin( 6.9818115)
   0.1216494169991055300000000000f,   //  1272: sin( 6.9873047)
   0.1217445781969172200000000000f,   //  1273: sin( 6.9927979)
   0.1218397382756788900000000000f,   //  1274: sin( 6.9982910)
   0.1219348972345158400000000000f,   //  1275: sin( 7.0037842)
   0.1220300550725533600000000000f,   //  1276: sin( 7.0092773)
   0.1221252117889168200000000000f,   //  1277: sin( 7.0147705)
   0.1222203673827315400000000000f,   //  1278: sin( 7.0202637)
   0.1223155218531228900000000000f,   //  1279: sin( 7.0257568)
   0.1224106751992162000000000000f,   //  1280: sin( 7.0312500)
   0.1225058274201368500000000000f,   //  1281: sin( 7.0367432)
   0.1226009785150102400000000000f,   //  1282: sin( 7.0422363)
   0.1226961284829617400000000000f,   //  1283: sin( 7.0477295)
   0.1227912773231167700000000000f,   //  1284: sin( 7.0532227)
   0.1228864250346007200000000000f,   //  1285: sin( 7.0587158)
   0.1229815716165390500000000000f,   //  1286: sin( 7.0642090)
   0.1230767170680571500000000000f,   //  1287: sin( 7.0697021)
   0.1231718613882804800000000000f,   //  1288: sin( 7.0751953)
   0.1232670045763344900000000000f,   //  1289: sin( 7.0806885)
   0.1233621466313446800000000000f,   //  1290: sin( 7.0861816)
   0.1234572875524364700000000000f,   //  1291: sin( 7.0916748)
   0.1235524273387353700000000000f,   //  1292: sin( 7.0971680)
   0.1236475659893668900000000000f,   //  1293: sin( 7.1026611)
   0.1237427035034565100000000000f,   //  1294: sin( 7.1081543)
   0.1238378398801297700000000000f,   //  1295: sin( 7.1136475)
   0.1239329751185121600000000000f,   //  1296: sin( 7.1191406)
   0.1240281092177292600000000000f,   //  1297: sin( 7.1246338)
   0.1241232421769066000000000000f,   //  1298: sin( 7.1301270)
   0.1242183739951697300000000000f,   //  1299: sin( 7.1356201)
   0.1243135046716442300000000000f,   //  1300: sin( 7.1411133)
   0.1244086342054556800000000000f,   //  1301: sin( 7.1466064)
   0.1245037625957296600000000000f,   //  1302: sin( 7.1520996)
   0.1245988898415917900000000000f,   //  1303: sin( 7.1575928)
   0.1246940159421676400000000000f,   //  1304: sin( 7.1630859)
   0.1247891408965828800000000000f,   //  1305: sin( 7.1685791)
   0.1248842647039631300000000000f,   //  1306: sin( 7.1740723)
   0.1249793873634339900000000000f,   //  1307: sin( 7.1795654)
   0.1250745088741211700000000000f,   //  1308: sin( 7.1850586)
   0.1251696292351502900000000000f,   //  1309: sin( 7.1905518)
   0.1252647484456470600000000000f,   //  1310: sin( 7.1960449)
   0.1253598665047371600000000000f,   //  1311: sin( 7.2015381)
   0.1254549834115462300000000000f,   //  1312: sin( 7.2070312)
   0.1255500991652000500000000000f,   //  1313: sin( 7.2125244)
   0.1256452137648242900000000000f,   //  1314: sin( 7.2180176)
   0.1257403272095447000000000000f,   //  1315: sin( 7.2235107)
   0.1258354394984870000000000000f,   //  1316: sin( 7.2290039)
   0.1259305506307769600000000000f,   //  1317: sin( 7.2344971)
   0.1260256606055403200000000000f,   //  1318: sin( 7.2399902)
   0.1261207694219028700000000000f,   //  1319: sin( 7.2454834)
   0.1262158770789903500000000000f,   //  1320: sin( 7.2509766)
   0.1263109835759286000000000000f,   //  1321: sin( 7.2564697)
   0.1264060889118433800000000000f,   //  1322: sin( 7.2619629)
   0.1265011930858605200000000000f,   //  1323: sin( 7.2674561)
   0.1265962960971058500000000000f,   //  1324: sin( 7.2729492)
   0.1266913979447052100000000000f,   //  1325: sin( 7.2784424)
   0.1267864986277844100000000000f,   //  1326: sin( 7.2839355)
   0.1268815981454693400000000000f,   //  1327: sin( 7.2894287)
   0.1269766964968858700000000000f,   //  1328: sin( 7.2949219)
   0.1270717936811598100000000000f,   //  1329: sin( 7.3004150)
   0.1271668896974171600000000000f,   //  1330: sin( 7.3059082)
   0.1272619845447836900000000000f,   //  1331: sin( 7.3114014)
   0.1273570782223854000000000000f,   //  1332: sin( 7.3168945)
   0.1274521707293482000000000000f,   //  1333: sin( 7.3223877)
   0.1275472620647979700000000000f,   //  1334: sin( 7.3278809)
   0.1276423522278606900000000000f,   //  1335: sin( 7.3333740)
   0.1277374412176623100000000000f,   //  1336: sin( 7.3388672)
   0.1278325290333287800000000000f,   //  1337: sin( 7.3443604)
   0.1279276156739860800000000000f,   //  1338: sin( 7.3498535)
   0.1280227011387602100000000000f,   //  1339: sin( 7.3553467)
   0.1281177854267771300000000000f,   //  1340: sin( 7.3608398)
   0.1282128685371628500000000000f,   //  1341: sin( 7.3663330)
   0.1283079504690434200000000000f,   //  1342: sin( 7.3718262)
   0.1284030312215448400000000000f,   //  1343: sin( 7.3773193)
   0.1284981107937931700000000000f,   //  1344: sin( 7.3828125)
   0.1285931891849144100000000000f,   //  1345: sin( 7.3883057)
   0.1286882663940346900000000000f,   //  1346: sin( 7.3937988)
   0.1287833424202800600000000000f,   //  1347: sin( 7.3992920)
   0.1288784172627765500000000000f,   //  1348: sin( 7.4047852)
   0.1289734909206503000000000000f,   //  1349: sin( 7.4102783)
   0.1290685633930274100000000000f,   //  1350: sin( 7.4157715)
   0.1291636346790339700000000000f,   //  1351: sin( 7.4212646)
   0.1292587047777961400000000000f,   //  1352: sin( 7.4267578)
   0.1293537736884400000000000000f,   //  1353: sin( 7.4322510)
   0.1294488414100917800000000000f,   //  1354: sin( 7.4377441)
   0.1295439079418775900000000000f,   //  1355: sin( 7.4432373)
   0.1296389732829235600000000000f,   //  1356: sin( 7.4487305)
   0.1297340374323559500000000000f,   //  1357: sin( 7.4542236)
   0.1298291003893009300000000000f,   //  1358: sin( 7.4597168)
   0.1299241621528846300000000000f,   //  1359: sin( 7.4652100)
   0.1300192227222333500000000000f,   //  1360: sin( 7.4707031)
   0.1301142820964732700000000000f,   //  1361: sin( 7.4761963)
   0.1302093402747306300000000000f,   //  1362: sin( 7.4816895)
   0.1303043972561317200000000000f,   //  1363: sin( 7.4871826)
   0.1303994530398026900000000000f,   //  1364: sin( 7.4926758)
   0.1304945076248699200000000000f,   //  1365: sin( 7.4981689)
   0.1305895610104596500000000000f,   //  1366: sin( 7.5036621)
   0.1306846131956981300000000000f,   //  1367: sin( 7.5091553)
   0.1307796641797117100000000000f,   //  1368: sin( 7.5146484)
   0.1308747139616267000000000000f,   //  1369: sin( 7.5201416)
   0.1309697625405693800000000000f,   //  1370: sin( 7.5256348)
   0.1310648099156661300000000000f,   //  1371: sin( 7.5311279)
   0.1311598560860432700000000000f,   //  1372: sin( 7.5366211)
   0.1312549010508271600000000000f,   //  1373: sin( 7.5421143)
   0.1313499448091441900000000000f,   //  1374: sin( 7.5476074)
   0.1314449873601207000000000000f,   //  1375: sin( 7.5531006)
   0.1315400287028831200000000000f,   //  1376: sin( 7.5585938)
   0.1316350688365578200000000000f,   //  1377: sin( 7.5640869)
   0.1317301077602711600000000000f,   //  1378: sin( 7.5695801)
   0.1318251454731496900000000000f,   //  1379: sin( 7.5750732)
   0.1319201819743197900000000000f,   //  1380: sin( 7.5805664)
   0.1320152172629078200000000000f,   //  1381: sin( 7.5860596)
   0.1321102513380403600000000000f,   //  1382: sin( 7.5915527)
   0.1322052841988438400000000000f,   //  1383: sin( 7.5970459)
   0.1323003158444446500000000000f,   //  1384: sin( 7.6025391)
   0.1323953462739694300000000000f,   //  1385: sin( 7.6080322)
   0.1324903754865445500000000000f,   //  1386: sin( 7.6135254)
   0.1325854034812965800000000000f,   //  1387: sin( 7.6190186)
   0.1326804302573520700000000000f,   //  1388: sin( 7.6245117)
   0.1327754558138374800000000000f,   //  1389: sin( 7.6300049)
   0.1328704801498794300000000000f,   //  1390: sin( 7.6354980)
   0.1329655032646044300000000000f,   //  1391: sin( 7.6409912)
   0.1330605251571390600000000000f,   //  1392: sin( 7.6464844)
   0.1331555458266099100000000000f,   //  1393: sin( 7.6519775)
   0.1332505652721435700000000000f,   //  1394: sin( 7.6574707)
   0.1333455834928666000000000000f,   //  1395: sin( 7.6629639)
   0.1334406004879056800000000000f,   //  1396: sin( 7.6684570)
   0.1335356162563873500000000000f,   //  1397: sin( 7.6739502)
   0.1336306307974383400000000000f,   //  1398: sin( 7.6794434)
   0.1337256441101852500000000000f,   //  1399: sin( 7.6849365)
   0.1338206561937547200000000000f,   //  1400: sin( 7.6904297)
   0.1339156670472734500000000000f,   //  1401: sin( 7.6959229)
   0.1340106766698681300000000000f,   //  1402: sin( 7.7014160)
   0.1341056850606653900000000000f,   //  1403: sin( 7.7069092)
   0.1342006922187920200000000000f,   //  1404: sin( 7.7124023)
   0.1342956981433746900000000000f,   //  1405: sin( 7.7178955)
   0.1343907028335400700000000000f,   //  1406: sin( 7.7233887)
   0.1344857062884150200000000000f,   //  1407: sin( 7.7288818)
   0.1345807085071261700000000000f,   //  1408: sin( 7.7343750)
   0.1346757094888003700000000000f,   //  1409: sin( 7.7398682)
   0.1347707092325643500000000000f,   //  1410: sin( 7.7453613)
   0.1348657077375448600000000000f,   //  1411: sin( 7.7508545)
   0.1349607050028687500000000000f,   //  1412: sin( 7.7563477)
   0.1350557010276628200000000000f,   //  1413: sin( 7.7618408)
   0.1351506958110538500000000000f,   //  1414: sin( 7.7673340)
   0.1352456893521687100000000000f,   //  1415: sin( 7.7728271)
   0.1353406816501342100000000000f,   //  1416: sin( 7.7783203)
   0.1354356727040772200000000000f,   //  1417: sin( 7.7838135)
   0.1355306625131245900000000000f,   //  1418: sin( 7.7893066)
   0.1356256510764032000000000000f,   //  1419: sin( 7.7947998)
   0.1357206383930399100000000000f,   //  1420: sin( 7.8002930)
   0.1358156244621616900000000000f,   //  1421: sin( 7.8057861)
   0.1359106092828953300000000000f,   //  1422: sin( 7.8112793)
   0.1360055928543678900000000000f,   //  1423: sin( 7.8167725)
   0.1361005751757062000000000000f,   //  1424: sin( 7.8222656)
   0.1361955562460372400000000000f,   //  1425: sin( 7.8277588)
   0.1362905360644879600000000000f,   //  1426: sin( 7.8332520)
   0.1363855146301853300000000000f,   //  1427: sin( 7.8387451)
   0.1364804919422562800000000000f,   //  1428: sin( 7.8442383)
   0.1365754679998278900000000000f,   //  1429: sin( 7.8497314)
   0.1366704428020270900000000000f,   //  1430: sin( 7.8552246)
   0.1367654163479808900000000000f,   //  1431: sin( 7.8607178)
   0.1368603886368163800000000000f,   //  1432: sin( 7.8662109)
   0.1369553596676605100000000000f,   //  1433: sin( 7.8717041)
   0.1370503294396404100000000000f,   //  1434: sin( 7.8771973)
   0.1371452979518830700000000000f,   //  1435: sin( 7.8826904)
   0.1372402652035155900000000000f,   //  1436: sin( 7.8881836)
   0.1373352311936650600000000000f,   //  1437: sin( 7.8936768)
   0.1374301959214585500000000000f,   //  1438: sin( 7.8991699)
   0.1375251593860231700000000000f,   //  1439: sin( 7.9046631)
   0.1376201215864860400000000000f,   //  1440: sin( 7.9101563)
   0.1377150825219743100000000000f,   //  1441: sin( 7.9156494)
   0.1378100421916150800000000000f,   //  1442: sin( 7.9211426)
   0.1379050005945355300000000000f,   //  1443: sin( 7.9266357)
   0.1379999577298627900000000000f,   //  1444: sin( 7.9321289)
   0.1380949135967240700000000000f,   //  1445: sin( 7.9376221)
   0.1381898681942465600000000000f,   //  1446: sin( 7.9431152)
   0.1382848215215574100000000000f,   //  1447: sin( 7.9486084)
   0.1383797735777838900000000000f,   //  1448: sin( 7.9541016)
   0.1384747243620531900000000000f,   //  1449: sin( 7.9595947)
   0.1385696738734925000000000000f,   //  1450: sin( 7.9650879)
   0.1386646221112291500000000000f,   //  1451: sin( 7.9705811)
   0.1387595690743903500000000000f,   //  1452: sin( 7.9760742)
   0.1388545147621033600000000000f,   //  1453: sin( 7.9815674)
   0.1389494591734954900000000000f,   //  1454: sin( 7.9870605)
   0.1390444023076939900000000000f,   //  1455: sin( 7.9925537)
   0.1391393441638262000000000000f,   //  1456: sin( 7.9980469)
   0.1392342847410194300000000000f,   //  1457: sin( 8.0035400)
   0.1393292240384009800000000000f,   //  1458: sin( 8.0090332)
   0.1394241620550982200000000000f,   //  1459: sin( 8.0145264)
   0.1395190987902384900000000000f,   //  1460: sin( 8.0200195)
   0.1396140342429491300000000000f,   //  1461: sin( 8.0255127)
   0.1397089684123575500000000000f,   //  1462: sin( 8.0310059)
   0.1398039012975911300000000000f,   //  1463: sin( 8.0364990)
   0.1398988328977772100000000000f,   //  1464: sin( 8.0419922)
   0.1399937632120432700000000000f,   //  1465: sin( 8.0474854)
   0.1400886922395166700000000000f,   //  1466: sin( 8.0529785)
   0.1401836199793249400000000000f,   //  1467: sin( 8.0584717)
   0.1402785464305954200000000000f,   //  1468: sin( 8.0639648)
   0.1403734715924556100000000000f,   //  1469: sin( 8.0694580)
   0.1404683954640330000000000000f,   //  1470: sin( 8.0749512)
   0.1405633180444550400000000000f,   //  1471: sin( 8.0804443)
   0.1406582393328492100000000000f,   //  1472: sin( 8.0859375)
   0.1407531593283430600000000000f,   //  1473: sin( 8.0914307)
   0.1408480780300640800000000000f,   //  1474: sin( 8.0969238)
   0.1409429954371397600000000000f,   //  1475: sin( 8.1024170)
   0.1410379115486977100000000000f,   //  1476: sin( 8.1079102)
   0.1411328263638654300000000000f,   //  1477: sin( 8.1134033)
   0.1412277398817705100000000000f,   //  1478: sin( 8.1188965)
   0.1413226521015405200000000000f,   //  1479: sin( 8.1243896)
   0.1414175630223030200000000000f,   //  1480: sin( 8.1298828)
   0.1415124726431856400000000000f,   //  1481: sin( 8.1353760)
   0.1416073809633160200000000000f,   //  1482: sin( 8.1408691)
   0.1417022879818216900000000000f,   //  1483: sin( 8.1463623)
   0.1417971936978303900000000000f,   //  1484: sin( 8.1518555)
   0.1418920981104697100000000000f,   //  1485: sin( 8.1573486)
   0.1419870012188672900000000000f,   //  1486: sin( 8.1628418)
   0.1420819030221508500000000000f,   //  1487: sin( 8.1683350)
   0.1421768035194480300000000000f,   //  1488: sin( 8.1738281)
   0.1422717027098865700000000000f,   //  1489: sin( 8.1793213)
   0.1423666005925941800000000000f,   //  1490: sin( 8.1848145)
   0.1424614971666984800000000000f,   //  1491: sin( 8.1903076)
   0.1425563924313273400000000000f,   //  1492: sin( 8.1958008)
   0.1426512863856084200000000000f,   //  1493: sin( 8.2012939)
   0.1427461790286694600000000000f,   //  1494: sin( 8.2067871)
   0.1428410703596383100000000000f,   //  1495: sin( 8.2122803)
   0.1429359603776426700000000000f,   //  1496: sin( 8.2177734)
   0.1430308490818103500000000000f,   //  1497: sin( 8.2232666)
   0.1431257364712691900000000000f,   //  1498: sin( 8.2287598)
   0.1432206225451469500000000000f,   //  1499: sin( 8.2342529)
   0.1433155073025715000000000000f,   //  1500: sin( 8.2397461)
   0.1434103907426706700000000000f,   //  1501: sin( 8.2452393)
   0.1435052728645722900000000000f,   //  1502: sin( 8.2507324)
   0.1436001536674042800000000000f,   //  1503: sin( 8.2562256)
   0.1436950331502944700000000000f,   //  1504: sin( 8.2617188)
   0.1437899113123707100000000000f,   //  1505: sin( 8.2672119)
   0.1438847881527609800000000000f,   //  1506: sin( 8.2727051)
   0.1439796636705931700000000000f,   //  1507: sin( 8.2781982)
   0.1440745378649951600000000000f,   //  1508: sin( 8.2836914)
   0.1441694107350949500000000000f,   //  1509: sin( 8.2891846)
   0.1442642822800204400000000000f,   //  1510: sin( 8.2946777)
   0.1443591524988996300000000000f,   //  1511: sin( 8.3001709)
   0.1444540213908604700000000000f,   //  1512: sin( 8.3056641)
   0.1445488889550309300000000000f,   //  1513: sin( 8.3111572)
   0.1446437551905390400000000000f,   //  1514: sin( 8.3166504)
   0.1447386200965128100000000000f,   //  1515: sin( 8.3221436)
   0.1448334836720802100000000000f,   //  1516: sin( 8.3276367)
   0.1449283459163693300000000000f,   //  1517: sin( 8.3331299)
   0.1450232068285082200000000000f,   //  1518: sin( 8.3386230)
   0.1451180664076249000000000000f,   //  1519: sin( 8.3441162)
   0.1452129246528474600000000000f,   //  1520: sin( 8.3496094)
   0.1453077815633039800000000000f,   //  1521: sin( 8.3551025)
   0.1454026371381225700000000000f,   //  1522: sin( 8.3605957)
   0.1454974913764313400000000000f,   //  1523: sin( 8.3660889)
   0.1455923442773583400000000000f,   //  1524: sin( 8.3715820)
   0.1456871958400318100000000000f,   //  1525: sin( 8.3770752)
   0.1457820460635798600000000000f,   //  1526: sin( 8.3825684)
   0.1458768949471305800000000000f,   //  1527: sin( 8.3880615)
   0.1459717424898122100000000000f,   //  1528: sin( 8.3935547)
   0.1460665886907529200000000000f,   //  1529: sin( 8.3990479)
   0.1461614335490809000000000000f,   //  1530: sin( 8.4045410)
   0.1462562770639243600000000000f,   //  1531: sin( 8.4100342)
   0.1463511192344114600000000000f,   //  1532: sin( 8.4155273)
   0.1464459600596705300000000000f,   //  1533: sin( 8.4210205)
   0.1465407995388297600000000000f,   //  1534: sin( 8.4265137)
   0.1466356376710173900000000000f,   //  1535: sin( 8.4320068)
   0.1467304744553617500000000000f,   //  1536: sin( 8.4375000)
   0.1468253098909910700000000000f,   //  1537: sin( 8.4429932)
   0.1469201439770336200000000000f,   //  1538: sin( 8.4484863)
   0.1470149767126177600000000000f,   //  1539: sin( 8.4539795)
   0.1471098080968718200000000000f,   //  1540: sin( 8.4594727)
   0.1472046381289240400000000000f,   //  1541: sin( 8.4649658)
   0.1472994668079028500000000000f,   //  1542: sin( 8.4704590)
   0.1473942941329365600000000000f,   //  1543: sin( 8.4759521)
   0.1474891201031535700000000000f,   //  1544: sin( 8.4814453)
   0.1475839447176822700000000000f,   //  1545: sin( 8.4869385)
   0.1476787679756509700000000000f,   //  1546: sin( 8.4924316)
   0.1477735898761881600000000000f,   //  1547: sin( 8.4979248)
   0.1478684104184222200000000000f,   //  1548: sin( 8.5034180)
   0.1479632296014815900000000000f,   //  1549: sin( 8.5089111)
   0.1480580474244947200000000000f,   //  1550: sin( 8.5144043)
   0.1481528638865900500000000000f,   //  1551: sin( 8.5198975)
   0.1482476789868960300000000000f,   //  1552: sin( 8.5253906)
   0.1483424927245412000000000000f,   //  1553: sin( 8.5308838)
   0.1484373050986539700000000000f,   //  1554: sin( 8.5363770)
   0.1485321161083629200000000000f,   //  1555: sin( 8.5418701)
   0.1486269257527965400000000000f,   //  1556: sin( 8.5473633)
   0.1487217340310833500000000000f,   //  1557: sin( 8.5528564)
   0.1488165409423519200000000000f,   //  1558: sin( 8.5583496)
   0.1489113464857307600000000000f,   //  1559: sin( 8.5638428)
   0.1490061506603484500000000000f,   //  1560: sin( 8.5693359)
   0.1491009534653336100000000000f,   //  1561: sin( 8.5748291)
   0.1491957548998148200000000000f,   //  1562: sin( 8.5803223)
   0.1492905549629206200000000000f,   //  1563: sin( 8.5858154)
   0.1493853536537797200000000000f,   //  1564: sin( 8.5913086)
   0.1494801509715207000000000000f,   //  1565: sin( 8.5968018)
   0.1495749469152722300000000000f,   //  1566: sin( 8.6022949)
   0.1496697414841629500000000000f,   //  1567: sin( 8.6077881)
   0.1497645346773215100000000000f,   //  1568: sin( 8.6132813)
   0.1498593264938766200000000000f,   //  1569: sin( 8.6187744)
   0.1499541169329569600000000000f,   //  1570: sin( 8.6242676)
   0.1500489059936912500000000000f,   //  1571: sin( 8.6297607)
   0.1501436936752081900000000000f,   //  1572: sin( 8.6352539)
   0.1502384799766365600000000000f,   //  1573: sin( 8.6407471)
   0.1503332648971050000000000000f,   //  1574: sin( 8.6462402)
   0.1504280484357423700000000000f,   //  1575: sin( 8.6517334)
   0.1505228305916774000000000000f,   //  1576: sin( 8.6572266)
   0.1506176113640388900000000000f,   //  1577: sin( 8.6627197)
   0.1507123907519556100000000000f,   //  1578: sin( 8.6682129)
   0.1508071687545563800000000000f,   //  1579: sin( 8.6737061)
   0.1509019453709700400000000000f,   //  1580: sin( 8.6791992)
   0.1509967206003254000000000000f,   //  1581: sin( 8.6846924)
   0.1510914944417513000000000000f,   //  1582: sin( 8.6901855)
   0.1511862668943766100000000000f,   //  1583: sin( 8.6956787)
   0.1512810379573302200000000000f,   //  1584: sin( 8.7011719)
   0.1513758076297409800000000000f,   //  1585: sin( 8.7066650)
   0.1514705759107378100000000000f,   //  1586: sin( 8.7121582)
   0.1515653427994496100000000000f,   //  1587: sin( 8.7176514)
   0.1516601082950053100000000000f,   //  1588: sin( 8.7231445)
   0.1517548723965338700000000000f,   //  1589: sin( 8.7286377)
   0.1518496351031641800000000000f,   //  1590: sin( 8.7341309)
   0.1519443964140252700000000000f,   //  1591: sin( 8.7396240)
   0.1520391563282460500000000000f,   //  1592: sin( 8.7451172)
   0.1521339148449555300000000000f,   //  1593: sin( 8.7506104)
   0.1522286719632827400000000000f,   //  1594: sin( 8.7561035)
   0.1523234276823566800000000000f,   //  1595: sin( 8.7615967)
   0.1524181820013063300000000000f,   //  1596: sin( 8.7670898)
   0.1525129349192608000000000000f,   //  1597: sin( 8.7725830)
   0.1526076864353490500000000000f,   //  1598: sin( 8.7780762)
   0.1527024365487002500000000000f,   //  1599: sin( 8.7835693)
   0.1527971852584434400000000000f,   //  1600: sin( 8.7890625)
   0.1528919325637076400000000000f,   //  1601: sin( 8.7945557)
   0.1529866784636220400000000000f,   //  1602: sin( 8.8000488)
   0.1530814229573157500000000000f,   //  1603: sin( 8.8055420)
   0.1531761660439178400000000000f,   //  1604: sin( 8.8110352)
   0.1532709077225575000000000000f,   //  1605: sin( 8.8165283)
   0.1533656479923638800000000000f,   //  1606: sin( 8.8220215)
   0.1534603868524661300000000000f,   //  1607: sin( 8.8275146)
   0.1535551243019934500000000000f,   //  1608: sin( 8.8330078)
   0.1536498603400750000000000000f,   //  1609: sin( 8.8385010)
   0.1537445949658400300000000000f,   //  1610: sin( 8.8439941)
   0.1538393281784177500000000000f,   //  1611: sin( 8.8494873)
   0.1539340599769373500000000000f,   //  1612: sin( 8.8549805)
   0.1540287903605281600000000000f,   //  1613: sin( 8.8604736)
   0.1541235193283193600000000000f,   //  1614: sin( 8.8659668)
   0.1542182468794402200000000000f,   //  1615: sin( 8.8714600)
   0.1543129730130201000000000000f,   //  1616: sin( 8.8769531)
   0.1544076977281882400000000000f,   //  1617: sin( 8.8824463)
   0.1545024210240739400000000000f,   //  1618: sin( 8.8879395)
   0.1545971428998065800000000000f,   //  1619: sin( 8.8934326)
   0.1546918633545154300000000000f,   //  1620: sin( 8.8989258)
   0.1547865823873299000000000000f,   //  1621: sin( 8.9044189)
   0.1548812999973793200000000000f,   //  1622: sin( 8.9099121)
   0.1549760161837930300000000000f,   //  1623: sin( 8.9154053)
   0.1550707309457005100000000000f,   //  1624: sin( 8.9208984)
   0.1551654442822311100000000000f,   //  1625: sin( 8.9263916)
   0.1552601561925142400000000000f,   //  1626: sin( 8.9318848)
   0.1553548666756793300000000000f,   //  1627: sin( 8.9373779)
   0.1554495757308558500000000000f,   //  1628: sin( 8.9428711)
   0.1555442833571731900000000000f,   //  1629: sin( 8.9483643)
   0.1556389895537609000000000000f,   //  1630: sin( 8.9538574)
   0.1557336943197484000000000000f,   //  1631: sin( 8.9593506)
   0.1558283976542652300000000000f,   //  1632: sin( 8.9648438)
   0.1559230995564408800000000000f,   //  1633: sin( 8.9703369)
   0.1560178000254048000000000000f,   //  1634: sin( 8.9758301)
   0.1561124990602866500000000000f,   //  1635: sin( 8.9813232)
   0.1562071966602159000000000000f,   //  1636: sin( 8.9868164)
   0.1563018928243221100000000000f,   //  1637: sin( 8.9923096)
   0.1563965875517348800000000000f,   //  1638: sin( 8.9978027)
   0.1564912808415838100000000000f,   //  1639: sin( 9.0032959)
   0.1565859726929984300000000000f,   //  1640: sin( 9.0087891)
   0.1566806631051084200000000000f,   //  1641: sin( 9.0142822)
   0.1567753520770433500000000000f,   //  1642: sin( 9.0197754)
   0.1568700396079329400000000000f,   //  1643: sin( 9.0252686)
   0.1569647256969067800000000000f,   //  1644: sin( 9.0307617)
   0.1570594103430945100000000000f,   //  1645: sin( 9.0362549)
   0.1571540935456259000000000000f,   //  1646: sin( 9.0417480)
   0.1572487753036305700000000000f,   //  1647: sin( 9.0472412)
   0.1573434556162382500000000000f,   //  1648: sin( 9.0527344)
   0.1574381344825786500000000000f,   //  1649: sin( 9.0582275)
   0.1575328119017815300000000000f,   //  1650: sin( 9.0637207)
   0.1576274878729765900000000000f,   //  1651: sin( 9.0692139)
   0.1577221623952936300000000000f,   //  1652: sin( 9.0747070)
   0.1578168354678623800000000000f,   //  1653: sin( 9.0802002)
   0.1579115070898126600000000000f,   //  1654: sin( 9.0856934)
   0.1580061772602742700000000000f,   //  1655: sin( 9.0911865)
   0.1581008459783769800000000000f,   //  1656: sin( 9.0966797)
   0.1581955132432506800000000000f,   //  1657: sin( 9.1021729)
   0.1582901790540251800000000000f,   //  1658: sin( 9.1076660)
   0.1583848434098303100000000000f,   //  1659: sin( 9.1131592)
   0.1584795063097959600000000000f,   //  1660: sin( 9.1186523)
   0.1585741677530520000000000000f,   //  1661: sin( 9.1241455)
   0.1586688277387283100000000000f,   //  1662: sin( 9.1296387)
   0.1587634862659548200000000000f,   //  1663: sin( 9.1351318)
   0.1588581433338614500000000000f,   //  1664: sin( 9.1406250)
   0.1589527989415781000000000000f,   //  1665: sin( 9.1461182)
   0.1590474530882347600000000000f,   //  1666: sin( 9.1516113)
   0.1591421057729613400000000000f,   //  1667: sin( 9.1571045)
   0.1592367569948878500000000000f,   //  1668: sin( 9.1625977)
   0.1593314067531442800000000000f,   //  1669: sin( 9.1680908)
   0.1594260550468605800000000000f,   //  1670: sin( 9.1735840)
   0.1595207018751668400000000000f,   //  1671: sin( 9.1790771)
   0.1596153472371930600000000000f,   //  1672: sin( 9.1845703)
   0.1597099911320692100000000000f,   //  1673: sin( 9.1900635)
   0.1598046335589254400000000000f,   //  1674: sin( 9.1955566)
   0.1598992745168917600000000000f,   //  1675: sin( 9.2010498)
   0.1599939140050982700000000000f,   //  1676: sin( 9.2065430)
   0.1600885520226750500000000000f,   //  1677: sin( 9.2120361)
   0.1601831885687522200000000000f,   //  1678: sin( 9.2175293)
   0.1602778236424599300000000000f,   //  1679: sin( 9.2230225)
   0.1603724572429282800000000000f,   //  1680: sin( 9.2285156)
   0.1604670893692873900000000000f,   //  1681: sin( 9.2340088)
   0.1605617200206674900000000000f,   //  1682: sin( 9.2395020)
   0.1606563491961987000000000000f,   //  1683: sin( 9.2449951)
   0.1607509768950112200000000000f,   //  1684: sin( 9.2504883)
   0.1608456031162352800000000000f,   //  1685: sin( 9.2559814)
   0.1609402278590010800000000000f,   //  1686: sin( 9.2614746)
   0.1610348511224388200000000000f,   //  1687: sin( 9.2669678)
   0.1611294729056788100000000000f,   //  1688: sin( 9.2724609)
   0.1612240932078512200000000000f,   //  1689: sin( 9.2779541)
   0.1613187120280864000000000000f,   //  1690: sin( 9.2834473)
   0.1614133293655146100000000000f,   //  1691: sin( 9.2889404)
   0.1615079452192661200000000000f,   //  1692: sin( 9.2944336)
   0.1616025595884712800000000000f,   //  1693: sin( 9.2999268)
   0.1616971724722604000000000000f,   //  1694: sin( 9.3054199)
   0.1617917838697637800000000000f,   //  1695: sin( 9.3109131)
   0.1618863937801118300000000000f,   //  1696: sin( 9.3164063)
   0.1619810022024349100000000000f,   //  1697: sin( 9.3218994)
   0.1620756091358633300000000000f,   //  1698: sin( 9.3273926)
   0.1621702145795276000000000000f,   //  1699: sin( 9.3328857)
   0.1622648185325580000000000000f,   //  1700: sin( 9.3383789)
   0.1623594209940850700000000000f,   //  1701: sin( 9.3438721)
   0.1624540219632391900000000000f,   //  1702: sin( 9.3493652)
   0.1625486214391507500000000000f,   //  1703: sin( 9.3548584)
   0.1626432194209503100000000000f,   //  1704: sin( 9.3603516)
   0.1627378159077683100000000000f,   //  1705: sin( 9.3658447)
   0.1628324108987352100000000000f,   //  1706: sin( 9.3713379)
   0.1629270043929815500000000000f,   //  1707: sin( 9.3768311)
   0.1630215963896378400000000000f,   //  1708: sin( 9.3823242)
   0.1631161868878345800000000000f,   //  1709: sin( 9.3878174)
   0.1632107758867023800000000000f,   //  1710: sin( 9.3933105)
   0.1633053633853717200000000000f,   //  1711: sin( 9.3988037)
   0.1633999493829732300000000000f,   //  1712: sin( 9.4042969)
   0.1634945338786374700000000000f,   //  1713: sin( 9.4097900)
   0.1635891168714950200000000000f,   //  1714: sin( 9.4152832)
   0.1636836983606765600000000000f,   //  1715: sin( 9.4207764)
   0.1637782783453126700000000000f,   //  1716: sin( 9.4262695)
   0.1638728568245339500000000000f,   //  1717: sin( 9.4317627)
   0.1639674337974711700000000000f,   //  1718: sin( 9.4372559)
   0.1640620092632549000000000000f,   //  1719: sin( 9.4427490)
   0.1641565832210158100000000000f,   //  1720: sin( 9.4482422)
   0.1642511556698846900000000000f,   //  1721: sin( 9.4537354)
   0.1643457266089921900000000000f,   //  1722: sin( 9.4592285)
   0.1644402960374690400000000000f,   //  1723: sin( 9.4647217)
   0.1645348639544460000000000000f,   //  1724: sin( 9.4702148)
   0.1646294303590537500000000000f,   //  1725: sin( 9.4757080)
   0.1647239952504231700000000000f,   //  1726: sin( 9.4812012)
   0.1648185586276849600000000000f,   //  1727: sin( 9.4866943)
   0.1649131204899698900000000000f,   //  1728: sin( 9.4921875)
   0.1650076808364088800000000000f,   //  1729: sin( 9.4976807)
   0.1651022396661326600000000000f,   //  1730: sin( 9.5031738)
   0.1651967969782720500000000000f,   //  1731: sin( 9.5086670)
   0.1652913527719580000000000000f,   //  1732: sin( 9.5141602)
   0.1653859070463212500000000000f,   //  1733: sin( 9.5196533)
   0.1654804598004927800000000000f,   //  1734: sin( 9.5251465)
   0.1655750110336034500000000000f,   //  1735: sin( 9.5306396)
   0.1656695607447841200000000000f,   //  1736: sin( 9.5361328)
   0.1657641089331657600000000000f,   //  1737: sin( 9.5416260)
   0.1658586555978793000000000000f,   //  1738: sin( 9.5471191)
   0.1659532007380556400000000000f,   //  1739: sin( 9.5526123)
   0.1660477443528257900000000000f,   //  1740: sin( 9.5581055)
   0.1661422864413207300000000000f,   //  1741: sin( 9.5635986)
   0.1662368270026714200000000000f,   //  1742: sin( 9.5690918)
   0.1663313660360088700000000000f,   //  1743: sin( 9.5745850)
   0.1664259035404641000000000000f,   //  1744: sin( 9.5800781)
   0.1665204395151681500000000000f,   //  1745: sin( 9.5855713)
   0.1666149739592520900000000000f,   //  1746: sin( 9.5910645)
   0.1667095068718469100000000000f,   //  1747: sin( 9.5965576)
   0.1668040382520837300000000000f,   //  1748: sin( 9.6020508)
   0.1668985680990936500000000000f,   //  1749: sin( 9.6075439)
   0.1669930964120077100000000000f,   //  1750: sin( 9.6130371)
   0.1670876231899571200000000000f,   //  1751: sin( 9.6185303)
   0.1671821484320729400000000000f,   //  1752: sin( 9.6240234)
   0.1672766721374863200000000000f,   //  1753: sin( 9.6295166)
   0.1673711943053284300000000000f,   //  1754: sin( 9.6350098)
   0.1674657149347304500000000000f,   //  1755: sin( 9.6405029)
   0.1675602340248235600000000000f,   //  1756: sin( 9.6459961)
   0.1676547515747390000000000000f,   //  1757: sin( 9.6514893)
   0.1677492675836078900000000000f,   //  1758: sin( 9.6569824)
   0.1678437820505615500000000000f,   //  1759: sin( 9.6624756)
   0.1679382949747311700000000000f,   //  1760: sin( 9.6679688)
   0.1680328063552480300000000000f,   //  1761: sin( 9.6734619)
   0.1681273161912434100000000000f,   //  1762: sin( 9.6789551)
   0.1682218244818485800000000000f,   //  1763: sin( 9.6844482)
   0.1683163312261948300000000000f,   //  1764: sin( 9.6899414)
   0.1684108364234135100000000000f,   //  1765: sin( 9.6954346)
   0.1685053400726359000000000000f,   //  1766: sin( 9.7009277)
   0.1685998421729934000000000000f,   //  1767: sin( 9.7064209)
   0.1686943427236173300000000000f,   //  1768: sin( 9.7119141)
   0.1687888417236390300000000000f,   //  1769: sin( 9.7174072)
   0.1688833391721899800000000000f,   //  1770: sin( 9.7229004)
   0.1689778350684015000000000000f,   //  1771: sin( 9.7283936)
   0.1690723294114050100000000000f,   //  1772: sin( 9.7338867)
   0.1691668222003319700000000000f,   //  1773: sin( 9.7393799)
   0.1692613134343138300000000000f,   //  1774: sin( 9.7448730)
   0.1693558031124819700000000000f,   //  1775: sin( 9.7503662)
   0.1694502912339679600000000000f,   //  1776: sin( 9.7558594)
   0.1695447777979032200000000000f,   //  1777: sin( 9.7613525)
   0.1696392628034192900000000000f,   //  1778: sin( 9.7668457)
   0.1697337462496476500000000000f,   //  1779: sin( 9.7723389)
   0.1698282281357198500000000000f,   //  1780: sin( 9.7778320)
   0.1699227084607674300000000000f,   //  1781: sin( 9.7833252)
   0.1700171872239219500000000000f,   //  1782: sin( 9.7888184)
   0.1701116644243149400000000000f,   //  1783: sin( 9.7943115)
   0.1702061400610780700000000000f,   //  1784: sin( 9.7998047)
   0.1703006141333428500000000000f,   //  1785: sin( 9.8052979)
   0.1703950866402409400000000000f,   //  1786: sin( 9.8107910)
   0.1704895575809040100000000000f,   //  1787: sin( 9.8162842)
   0.1705840269544635900000000000f,   //  1788: sin( 9.8217773)
   0.1706784947600514500000000000f,   //  1789: sin( 9.8272705)
   0.1707729609967992300000000000f,   //  1790: sin( 9.8327637)
   0.1708674256638385600000000000f,   //  1791: sin( 9.8382568)
   0.1709618887603012200000000000f,   //  1792: sin( 9.8437500)
   0.1710563502853189000000000000f,   //  1793: sin( 9.8492432)
   0.1711508102380232800000000000f,   //  1794: sin( 9.8547363)
   0.1712452686175461900000000000f,   //  1795: sin( 9.8602295)
   0.1713397254230193100000000000f,   //  1796: sin( 9.8657227)
   0.1714341806535744400000000000f,   //  1797: sin( 9.8712158)
   0.1715286343083434200000000000f,   //  1798: sin( 9.8767090)
   0.1716230863864579600000000000f,   //  1799: sin( 9.8822021)
   0.1717175368870499700000000000f,   //  1800: sin( 9.8876953)
   0.1718119858092512200000000000f,   //  1801: sin( 9.8931885)
   0.1719064331521935300000000000f,   //  1802: sin( 9.8986816)
   0.1720008789150088700000000000f,   //  1803: sin( 9.9041748)
   0.1720953230968290100000000000f,   //  1804: sin( 9.9096680)
   0.1721897656967858700000000000f,   //  1805: sin( 9.9151611)
   0.1722842067140113700000000000f,   //  1806: sin( 9.9206543)
   0.1723786461476374500000000000f,   //  1807: sin( 9.9261475)
   0.1724730839967959500000000000f,   //  1808: sin( 9.9316406)
   0.1725675202606189200000000000f,   //  1809: sin( 9.9371338)
   0.1726619549382382700000000000f,   //  1810: sin( 9.9426270)
   0.1727563880287859800000000000f,   //  1811: sin( 9.9481201)
   0.1728508195313940800000000000f,   //  1812: sin( 9.9536133)
   0.1729452494451945200000000000f,   //  1813: sin( 9.9591064)
   0.1730396777693193600000000000f,   //  1814: sin( 9.9645996)
   0.1731341045029006200000000000f,   //  1815: sin( 9.9700928)
   0.1732285296450703200000000000f,   //  1816: sin( 9.9755859)
   0.1733229531949605800000000000f,   //  1817: sin( 9.9810791)
   0.1734173751517034700000000000f,   //  1818: sin( 9.9865723)
   0.1735117955144310200000000000f,   //  1819: sin( 9.9920654)
   0.1736062142822754100000000000f,   //  1820: sin( 9.9975586)
   0.1737006314543687300000000000f,   //  1821: sin(10.0030518)
   0.1737950470298431600000000000f,   //  1822: sin(10.0085449)
   0.1738894610078307900000000000f,   //  1823: sin(10.0140381)
   0.1739838733874638200000000000f,   //  1824: sin(10.0195313)
   0.1740782841678744400000000000f,   //  1825: sin(10.0250244)
   0.1741726933481948200000000000f,   //  1826: sin(10.0305176)
   0.1742671009275571800000000000f,   //  1827: sin(10.0360107)
   0.1743615069050937500000000000f,   //  1828: sin(10.0415039)
   0.1744559112799367900000000000f,   //  1829: sin(10.0469971)
   0.1745503140512185100000000000f,   //  1830: sin(10.0524902)
   0.1746447152180712300000000000f,   //  1831: sin(10.0579834)
   0.1747391147796272000000000000f,   //  1832: sin(10.0634766)
   0.1748335127350187400000000000f,   //  1833: sin(10.0689697)
   0.1749279090833781600000000000f,   //  1834: sin(10.0744629)
   0.1750223038238377400000000000f,   //  1835: sin(10.0799561)
   0.1751166969555299200000000000f,   //  1836: sin(10.0854492)
   0.1752110884775869800000000000f,   //  1837: sin(10.0909424)
   0.1753054783891413200000000000f,   //  1838: sin(10.0964355)
   0.1753998666893253300000000000f,   //  1839: sin(10.1019287)
   0.1754942533772714300000000000f,   //  1840: sin(10.1074219)
   0.1755886384521119800000000000f,   //  1841: sin(10.1129150)
   0.1756830219129794900000000000f,   //  1842: sin(10.1184082)
   0.1757774037590063300000000000f,   //  1843: sin(10.1239014)
   0.1758717839893250400000000000f,   //  1844: sin(10.1293945)
   0.1759661626030680500000000000f,   //  1845: sin(10.1348877)
   0.1760605395993678200000000000f,   //  1846: sin(10.1403809)
   0.1761549149773569400000000000f,   //  1847: sin(10.1458740)
   0.1762492887361678800000000000f,   //  1848: sin(10.1513672)
   0.1763436608749331700000000000f,   //  1849: sin(10.1568604)
   0.1764380313927854100000000000f,   //  1850: sin(10.1623535)
   0.1765324002888571100000000000f,   //  1851: sin(10.1678467)
   0.1766267675622808800000000000f,   //  1852: sin(10.1733398)
   0.1767211332121893200000000000f,   //  1853: sin(10.1788330)
   0.1768154972377150000000000000f,   //  1854: sin(10.1843262)
   0.1769098596379906100000000000f,   //  1855: sin(10.1898193)
   0.1770042204121487500000000000f,   //  1856: sin(10.1953125)
   0.1770985795593220700000000000f,   //  1857: sin(10.2008057)
   0.1771929370786432800000000000f,   //  1858: sin(10.2062988)
   0.1772872929692450600000000000f,   //  1859: sin(10.2117920)
   0.1773816472302600400000000000f,   //  1860: sin(10.2172852)
   0.1774759998608210200000000000f,   //  1861: sin(10.2227783)
   0.1775703508600607100000000000f,   //  1862: sin(10.2282715)
   0.1776647002271118100000000000f,   //  1863: sin(10.2337646)
   0.1777590479611071700000000000f,   //  1864: sin(10.2392578)
   0.1778533940611794500000000000f,   //  1865: sin(10.2447510)
   0.1779477385264615600000000000f,   //  1866: sin(10.2502441)
   0.1780420813560862300000000000f,   //  1867: sin(10.2557373)
   0.1781364225491863000000000000f,   //  1868: sin(10.2612305)
   0.1782307621048946100000000000f,   //  1869: sin(10.2667236)
   0.1783251000223440000000000000f,   //  1870: sin(10.2722168)
   0.1784194363006673400000000000f,   //  1871: sin(10.2777100)
   0.1785137709389975100000000000f,   //  1872: sin(10.2832031)
   0.1786081039364674500000000000f,   //  1873: sin(10.2886963)
   0.1787024352922099700000000000f,   //  1874: sin(10.2941895)
   0.1787967650053581000000000000f,   //  1875: sin(10.2996826)
   0.1788910930750447200000000000f,   //  1876: sin(10.3051758)
   0.1789854195004028400000000000f,   //  1877: sin(10.3106689)
   0.1790797442805653900000000000f,   //  1878: sin(10.3161621)
   0.1791740674146653200000000000f,   //  1879: sin(10.3216553)
   0.1792683889018357500000000000f,   //  1880: sin(10.3271484)
   0.1793627087412095800000000000f,   //  1881: sin(10.3326416)
   0.1794570269319198900000000000f,   //  1882: sin(10.3381348)
   0.1795513434730997300000000000f,   //  1883: sin(10.3436279)
   0.1796456583638821600000000000f,   //  1884: sin(10.3491211)
   0.1797399716034002400000000000f,   //  1885: sin(10.3546143)
   0.1798342831907870900000000000f,   //  1886: sin(10.3601074)
   0.1799285931251757800000000000f,   //  1887: sin(10.3656006)
   0.1800229014056995100000000000f,   //  1888: sin(10.3710938)
   0.1801172080314913700000000000f,   //  1889: sin(10.3765869)
   0.1802115130016844500000000000f,   //  1890: sin(10.3820801)
   0.1803058163154120400000000000f,   //  1891: sin(10.3875732)
   0.1804001179718072400000000000f,   //  1892: sin(10.3930664)
   0.1804944179700032600000000000f,   //  1893: sin(10.3985596)
   0.1805887163091333400000000000f,   //  1894: sin(10.4040527)
   0.1806830129883307300000000000f,   //  1895: sin(10.4095459)
   0.1807773080067285900000000000f,   //  1896: sin(10.4150391)
   0.1808716013634602500000000000f,   //  1897: sin(10.4205322)
   0.1809658930576589800000000000f,   //  1898: sin(10.4260254)
   0.1810601830884580600000000000f,   //  1899: sin(10.4315186)
   0.1811544714549908100000000000f,   //  1900: sin(10.4370117)
   0.1812487581563904900000000000f,   //  1901: sin(10.4425049)
   0.1813430431917905400000000000f,   //  1902: sin(10.4479980)
   0.1814373265603242700000000000f,   //  1903: sin(10.4534912)
   0.1815316082611249700000000000f,   //  1904: sin(10.4589844)
   0.1816258882933261300000000000f,   //  1905: sin(10.4644775)
   0.1817201666560611100000000000f,   //  1906: sin(10.4699707)
   0.1818144433484633100000000000f,   //  1907: sin(10.4754639)
   0.1819087183696661600000000000f,   //  1908: sin(10.4809570)
   0.1820029917188031000000000000f,   //  1909: sin(10.4864502)
   0.1820972633950076500000000000f,   //  1910: sin(10.4919434)
   0.1821915333974132000000000000f,   //  1911: sin(10.4974365)
   0.1822858017251533000000000000f,   //  1912: sin(10.5029297)
   0.1823800683773614300000000000f,   //  1913: sin(10.5084229)
   0.1824743333531711200000000000f,   //  1914: sin(10.5139160)
   0.1825685966517158800000000000f,   //  1915: sin(10.5194092)
   0.1826628582721292700000000000f,   //  1916: sin(10.5249023)
   0.1827571182135449300000000000f,   //  1917: sin(10.5303955)
   0.1828513764750963300000000000f,   //  1918: sin(10.5358887)
   0.1829456330559171300000000000f,   //  1919: sin(10.5413818)
   0.1830398879551409500000000000f,   //  1920: sin(10.5468750)
   0.1831341411719014100000000000f,   //  1921: sin(10.5523682)
   0.1832283927053321400000000000f,   //  1922: sin(10.5578613)
   0.1833226425545667900000000000f,   //  1923: sin(10.5633545)
   0.1834168907187391000000000000f,   //  1924: sin(10.5688477)
   0.1835111371969827000000000000f,   //  1925: sin(10.5743408)
   0.1836053819884312700000000000f,   //  1926: sin(10.5798340)
   0.1836996250922186300000000000f,   //  1927: sin(10.5853271)
   0.1837938665074784500000000000f,   //  1928: sin(10.5908203)
   0.1838881062333444800000000000f,   //  1929: sin(10.5963135)
   0.1839823442689505200000000000f,   //  1930: sin(10.6018066)
   0.1840765806134303500000000000f,   //  1931: sin(10.6072998)
   0.1841708152659177200000000000f,   //  1932: sin(10.6127930)
   0.1842650482255465100000000000f,   //  1933: sin(10.6182861)
   0.1843592794914505100000000000f,   //  1934: sin(10.6237793)
   0.1844535090627635900000000000f,   //  1935: sin(10.6292725)
   0.1845477369386196200000000000f,   //  1936: sin(10.6347656)
   0.1846419631181524200000000000f,   //  1937: sin(10.6402588)
   0.1847361876004959500000000000f,   //  1938: sin(10.6457520)
   0.1848304103847841200000000000f,   //  1939: sin(10.6512451)
   0.1849246314701507900000000000f,   //  1940: sin(10.6567383)
   0.1850188508557299400000000000f,   //  1941: sin(10.6622314)
   0.1851130685406555400000000000f,   //  1942: sin(10.6677246)
   0.1852072845240615200000000000f,   //  1943: sin(10.6732178)
   0.1853014988050819000000000000f,   //  1944: sin(10.6787109)
   0.1853957113828506600000000000f,   //  1945: sin(10.6842041)
   0.1854899222565018800000000000f,   //  1946: sin(10.6896973)
   0.1855841314251695200000000000f,   //  1947: sin(10.6951904)
   0.1856783388879876300000000000f,   //  1948: sin(10.7006836)
   0.1857725446440903200000000000f,   //  1949: sin(10.7061768)
   0.1858667486926116600000000000f,   //  1950: sin(10.7116699)
   0.1859609510326857300000000000f,   //  1951: sin(10.7171631)
   0.1860551516634466300000000000f,   //  1952: sin(10.7226563)
   0.1861493505840285400000000000f,   //  1953: sin(10.7281494)
   0.1862435477935655600000000000f,   //  1954: sin(10.7336426)
   0.1863377432911918800000000000f,   //  1955: sin(10.7391357)
   0.1864319370760416100000000000f,   //  1956: sin(10.7446289)
   0.1865261291472490000000000000f,   //  1957: sin(10.7501221)
   0.1866203195039482800000000000f,   //  1958: sin(10.7556152)
   0.1867145081452736000000000000f,   //  1959: sin(10.7611084)
   0.1868086950703592700000000000f,   //  1960: sin(10.7666016)
   0.1869028802783394800000000000f,   //  1961: sin(10.7720947)
   0.1869970637683485400000000000f,   //  1962: sin(10.7775879)
   0.1870912455395207200000000000f,   //  1963: sin(10.7830811)
   0.1871854255909903300000000000f,   //  1964: sin(10.7885742)
   0.1872796039218916600000000000f,   //  1965: sin(10.7940674)
   0.1873737805313591100000000000f,   //  1966: sin(10.7995605)
   0.1874679554185269500000000000f,   //  1967: sin(10.8050537)
   0.1875621285825296000000000000f,   //  1968: sin(10.8105469)
   0.1876563000225014200000000000f,   //  1969: sin(10.8160400)
   0.1877504697375767800000000000f,   //  1970: sin(10.8215332)
   0.1878446377268901400000000000f,   //  1971: sin(10.8270264)
   0.1879388039895759100000000000f,   //  1972: sin(10.8325195)
   0.1880329685247685000000000000f,   //  1973: sin(10.8380127)
   0.1881271313316024200000000000f,   //  1974: sin(10.8435059)
   0.1882212924092121500000000000f,   //  1975: sin(10.8489990)
   0.1883154517567321200000000000f,   //  1976: sin(10.8544922)
   0.1884096093732969000000000000f,   //  1977: sin(10.8599854)
   0.1885037652580409400000000000f,   //  1978: sin(10.8654785)
   0.1885979194100988700000000000f,   //  1979: sin(10.8709717)
   0.1886920718286052300000000000f,   //  1980: sin(10.8764648)
   0.1887862225126945000000000000f,   //  1981: sin(10.8819580)
   0.1888803714615013800000000000f,   //  1982: sin(10.8874512)
   0.1889745186741604000000000000f,   //  1983: sin(10.8929443)
   0.1890686641498061900000000000f,   //  1984: sin(10.8984375)
   0.1891628078875734500000000000f,   //  1985: sin(10.9039307)
   0.1892569498865967500000000000f,   //  1986: sin(10.9094238)
   0.1893510901460107600000000000f,   //  1987: sin(10.9149170)
   0.1894452286649502300000000000f,   //  1988: sin(10.9204102)
   0.1895393654425497600000000000f,   //  1989: sin(10.9259033)
   0.1896335004779441900000000000f,   //  1990: sin(10.9313965)
   0.1897276337702681600000000000f,   //  1991: sin(10.9368896)
   0.1898217653186564100000000000f,   //  1992: sin(10.9423828)
   0.1899158951222437700000000000f,   //  1993: sin(10.9478760)
   0.1900100231801649900000000000f,   //  1994: sin(10.9533691)
   0.1901041494915548200000000000f,   //  1995: sin(10.9588623)
   0.1901982740555481500000000000f,   //  1996: sin(10.9643555)
   0.1902923968712797500000000000f,   //  1997: sin(10.9698486)
   0.1903865179378844700000000000f,   //  1998: sin(10.9753418)
   0.1904806372544971800000000000f,   //  1999: sin(10.9808350)
   0.1905747548202527400000000000f,   //  2000: sin(10.9863281)
   0.1906688706342860900000000000f,   //  2001: sin(10.9918213)
   0.1907629846957321100000000000f,   //  2002: sin(10.9973145)
   0.1908570970037256600000000000f,   //  2003: sin(11.0028076)
   0.1909512075574018000000000000f,   //  2004: sin(11.0083008)
   0.1910453163558954200000000000f,   //  2005: sin(11.0137939)
   0.1911394233983414500000000000f,   //  2006: sin(11.0192871)
   0.1912335286838749400000000000f,   //  2007: sin(11.0247803)
   0.1913276322116309000000000000f,   //  2008: sin(11.0302734)
   0.1914217339807443000000000000f,   //  2009: sin(11.0357666)
   0.1915158339903502100000000000f,   //  2010: sin(11.0412598)
   0.1916099322395837000000000000f,   //  2011: sin(11.0467529)
   0.1917040287275798000000000000f,   //  2012: sin(11.0522461)
   0.1917981234534736300000000000f,   //  2013: sin(11.0577393)
   0.1918922164164002200000000000f,   //  2014: sin(11.0632324)
   0.1919863076154948200000000000f,   //  2015: sin(11.0687256)
   0.1920803970498924400000000000f,   //  2016: sin(11.0742188)
   0.1921744847187282800000000000f,   //  2017: sin(11.0797119)
   0.1922685706211375000000000000f,   //  2018: sin(11.0852051)
   0.1923626547562553000000000000f,   //  2019: sin(11.0906982)
   0.1924567371232168400000000000f,   //  2020: sin(11.0961914)
   0.1925508177211573700000000000f,   //  2021: sin(11.1016846)
   0.1926448965492121000000000000f,   //  2022: sin(11.1071777)
   0.1927389736065163200000000000f,   //  2023: sin(11.1126709)
   0.1928330488922052300000000000f,   //  2024: sin(11.1181641)
   0.1929271224054141500000000000f,   //  2025: sin(11.1236572)
   0.1930211941452783800000000000f,   //  2026: sin(11.1291504)
   0.1931152641109332200000000000f,   //  2027: sin(11.1346436)
   0.1932093323015139600000000000f,   //  2028: sin(11.1401367)
   0.1933033987161560400000000000f,   //  2029: sin(11.1456299)
   0.1933974633539947400000000000f,   //  2030: sin(11.1511230)
   0.1934915262141654600000000000f,   //  2031: sin(11.1566162)
   0.1935855872958036100000000000f,   //  2032: sin(11.1621094)
   0.1936796465980445700000000000f,   //  2033: sin(11.1676025)
   0.1937737041200238200000000000f,   //  2034: sin(11.1730957)
   0.1938677598608767600000000000f,   //  2035: sin(11.1785889)
   0.1939618138197388400000000000f,   //  2036: sin(11.1840820)
   0.1940558659957455900000000000f,   //  2037: sin(11.1895752)
   0.1941499163880324500000000000f,   //  2038: sin(11.1950684)
   0.1942439649957349300000000000f,   //  2039: sin(11.2005615)
   0.1943380118179886000000000000f,   //  2040: sin(11.2060547)
   0.1944320568539290000000000000f,   //  2041: sin(11.2115479)
   0.1945261001026916100000000000f,   //  2042: sin(11.2170410)
   0.1946201415634120900000000000f,   //  2043: sin(11.2225342)
   0.1947141812352259600000000000f,   //  2044: sin(11.2280273)
   0.1948082191172689200000000000f,   //  2045: sin(11.2335205)
   0.1949022552086765200000000000f,   //  2046: sin(11.2390137)
   0.1949962895085843900000000000f,   //  2047: sin(11.2445068)
   0.1950903220161282500000000000f,   //  2048: sin(11.2500000)
   0.1951843527304437700000000000f,   //  2049: sin(11.2554932)
   0.1952783816506665500000000000f,   //  2050: sin(11.2609863)
   0.1953724087759324000000000000f,   //  2051: sin(11.2664795)
   0.1954664341053769800000000000f,   //  2052: sin(11.2719727)
   0.1955604576381360400000000000f,   //  2053: sin(11.2774658)
   0.1956544793733453700000000000f,   //  2054: sin(11.2829590)
   0.1957484993101407100000000000f,   //  2055: sin(11.2884521)
   0.1958425174476578500000000000f,   //  2056: sin(11.2939453)
   0.1959365337850326200000000000f,   //  2057: sin(11.2994385)
   0.1960305483214007900000000000f,   //  2058: sin(11.3049316)
   0.1961245610558982900000000000f,   //  2059: sin(11.3104248)
   0.1962185719876608800000000000f,   //  2060: sin(11.3159180)
   0.1963125811158244700000000000f,   //  2061: sin(11.3214111)
   0.1964065884395249700000000000f,   //  2062: sin(11.3269043)
   0.1965005939578982300000000000f,   //  2063: sin(11.3323975)
   0.1965945976700802200000000000f,   //  2064: sin(11.3378906)
   0.1966885995752068700000000000f,   //  2065: sin(11.3433838)
   0.1967825996724141000000000000f,   //  2066: sin(11.3488770)
   0.1968765979608379500000000000f,   //  2067: sin(11.3543701)
   0.1969705944396143400000000000f,   //  2068: sin(11.3598633)
   0.1970645891078793000000000000f,   //  2069: sin(11.3653564)
   0.1971585819647688800000000000f,   //  2070: sin(11.3708496)
   0.1972525730094190600000000000f,   //  2071: sin(11.3763428)
   0.1973465622409659200000000000f,   //  2072: sin(11.3818359)
   0.1974405496585455400000000000f,   //  2073: sin(11.3873291)
   0.1975345352612940300000000000f,   //  2074: sin(11.3928223)
   0.1976285190483474400000000000f,   //  2075: sin(11.3983154)
   0.1977225010188419200000000000f,   //  2076: sin(11.4038086)
   0.1978164811719136100000000000f,   //  2077: sin(11.4093018)
   0.1979104595066986700000000000f,   //  2078: sin(11.4147949)
   0.1980044360223332800000000000f,   //  2079: sin(11.4202881)
   0.1980984107179535600000000000f,   //  2080: sin(11.4257813)
   0.1981923835926958100000000000f,   //  2081: sin(11.4312744)
   0.1982863546456962200000000000f,   //  2082: sin(11.4367676)
   0.1983803238760909500000000000f,   //  2083: sin(11.4422607)
   0.1984742912830163900000000000f,   //  2084: sin(11.4477539)
   0.1985682568656087200000000000f,   //  2085: sin(11.4532471)
   0.1986622206230042000000000000f,   //  2086: sin(11.4587402)
   0.1987561825543392400000000000f,   //  2087: sin(11.4642334)
   0.1988501426587500900000000000f,   //  2088: sin(11.4697266)
   0.1989441009353731200000000000f,   //  2089: sin(11.4752197)
   0.1990380573833446800000000000f,   //  2090: sin(11.4807129)
   0.1991320120018011100000000000f,   //  2091: sin(11.4862061)
   0.1992259647898788300000000000f,   //  2092: sin(11.4916992)
   0.1993199157467142600000000000f,   //  2093: sin(11.4971924)
   0.1994138648714437700000000000f,   //  2094: sin(11.5026855)
   0.1995078121632038700000000000f,   //  2095: sin(11.5081787)
   0.1996017576211309700000000000f,   //  2096: sin(11.5136719)
   0.1996957012443615300000000000f,   //  2097: sin(11.5191650)
   0.1997896430320320900000000000f,   //  2098: sin(11.5246582)
   0.1998835829832791300000000000f,   //  2099: sin(11.5301514)
   0.1999775210972391500000000000f,   //  2100: sin(11.5356445)
   0.2000714573730487700000000000f,   //  2101: sin(11.5411377)
   0.2001653918098444400000000000f,   //  2102: sin(11.5466309)
   0.2002593244067628100000000000f,   //  2103: sin(11.5521240)
   0.2003532551629404500000000000f,   //  2104: sin(11.5576172)
   0.2004471840775139700000000000f,   //  2105: sin(11.5631104)
   0.2005411111496199800000000000f,   //  2106: sin(11.5686035)
   0.2006350363783951700000000000f,   //  2107: sin(11.5740967)
   0.2007289597629761400000000000f,   //  2108: sin(11.5795898)
   0.2008228813024996200000000000f,   //  2109: sin(11.5850830)
   0.2009168009961022300000000000f,   //  2110: sin(11.5905762)
   0.2010107188429207700000000000f,   //  2111: sin(11.5960693)
   0.2011046348420919000000000000f,   //  2112: sin(11.6015625)
   0.2011985489927523900000000000f,   //  2113: sin(11.6070557)
   0.2012924612940390200000000000f,   //  2114: sin(11.6125488)
   0.2013863717450885500000000000f,   //  2115: sin(11.6180420)
   0.2014802803450377300000000000f,   //  2116: sin(11.6235352)
   0.2015741870930234700000000000f,   //  2117: sin(11.6290283)
   0.2016680919881825300000000000f,   //  2118: sin(11.6345215)
   0.2017619950296517500000000000f,   //  2119: sin(11.6400146)
   0.2018558962165680500000000000f,   //  2120: sin(11.6455078)
   0.2019497955480682200000000000f,   //  2121: sin(11.6510010)
   0.2020436930232892600000000000f,   //  2122: sin(11.6564941)
   0.2021375886413680200000000000f,   //  2123: sin(11.6619873)
   0.2022314824014414500000000000f,   //  2124: sin(11.6674805)
   0.2023253743026465200000000000f,   //  2125: sin(11.6729736)
   0.2024192643441201600000000000f,   //  2126: sin(11.6784668)
   0.2025131525249993500000000000f,   //  2127: sin(11.6839600)
   0.2026070388444211300000000000f,   //  2128: sin(11.6894531)
   0.2027009233015224800000000000f,   //  2129: sin(11.6949463)
   0.2027948058954404400000000000f,   //  2130: sin(11.7004395)
   0.2028886866253120900000000000f,   //  2131: sin(11.7059326)
   0.2029825654902744400000000000f,   //  2132: sin(11.7114258)
   0.2030764424894646600000000000f,   //  2133: sin(11.7169189)
   0.2031703176220197900000000000f,   //  2134: sin(11.7224121)
   0.2032641908870769500000000000f,   //  2135: sin(11.7279053)
   0.2033580622837733200000000000f,   //  2136: sin(11.7333984)
   0.2034519318112460200000000000f,   //  2137: sin(11.7388916)
   0.2035457994686321900000000000f,   //  2138: sin(11.7443848)
   0.2036396652550691000000000000f,   //  2139: sin(11.7498779)
   0.2037335291696939200000000000f,   //  2140: sin(11.7553711)
   0.2038273912116438400000000000f,   //  2141: sin(11.7608643)
   0.2039212513800561200000000000f,   //  2142: sin(11.7663574)
   0.2040151096740680200000000000f,   //  2143: sin(11.7718506)
   0.2041089660928168700000000000f,   //  2144: sin(11.7773438)
   0.2042028206354398700000000000f,   //  2145: sin(11.7828369)
   0.2042966733010743700000000000f,   //  2146: sin(11.7883301)
   0.2043905240888577200000000000f,   //  2147: sin(11.7938232)
   0.2044843729979272400000000000f,   //  2148: sin(11.7993164)
   0.2045782200274202400000000000f,   //  2149: sin(11.8048096)
   0.2046720651764742100000000000f,   //  2150: sin(11.8103027)
   0.2047659084442264600000000000f,   //  2151: sin(11.8157959)
   0.2048597498298144200000000000f,   //  2152: sin(11.8212891)
   0.2049535893323755400000000000f,   //  2153: sin(11.8267822)
   0.2050474269510472500000000000f,   //  2154: sin(11.8322754)
   0.2051412626849670200000000000f,   //  2155: sin(11.8377686)
   0.2052350965332723500000000000f,   //  2156: sin(11.8432617)
   0.2053289284951006800000000000f,   //  2157: sin(11.8487549)
   0.2054227585695896100000000000f,   //  2158: sin(11.8542480)
   0.2055165867558766100000000000f,   //  2159: sin(11.8597412)
   0.2056104130530992400000000000f,   //  2160: sin(11.8652344)
   0.2057042374603951200000000000f,   //  2161: sin(11.8707275)
   0.2057980599769017900000000000f,   //  2162: sin(11.8762207)
   0.2058918806017568400000000000f,   //  2163: sin(11.8817139)
   0.2059856993340979100000000000f,   //  2164: sin(11.8872070)
   0.2060795161730626400000000000f,   //  2165: sin(11.8927002)
   0.2061733311177887100000000000f,   //  2166: sin(11.8981934)
   0.2062671441674137900000000000f,   //  2167: sin(11.9036865)
   0.2063609553210755100000000000f,   //  2168: sin(11.9091797)
   0.2064547645779116500000000000f,   //  2169: sin(11.9146729)
   0.2065485719370598900000000000f,   //  2170: sin(11.9201660)
   0.2066423773976579800000000000f,   //  2171: sin(11.9256592)
   0.2067361809588436900000000000f,   //  2172: sin(11.9311523)
   0.2068299826197548000000000000f,   //  2173: sin(11.9366455)
   0.2069237823795291000000000000f,   //  2174: sin(11.9421387)
   0.2070175802373044000000000000f,   //  2175: sin(11.9476318)
   0.2071113761922185600000000000f,   //  2176: sin(11.9531250)
   0.2072051702434093700000000000f,   //  2177: sin(11.9586182)
   0.2072989623900147500000000000f,   //  2178: sin(11.9641113)
   0.2073927526311725200000000000f,   //  2179: sin(11.9696045)
   0.2074865409660206500000000000f,   //  2180: sin(11.9750977)
   0.2075803273936970300000000000f,   //  2181: sin(11.9805908)
   0.2076741119133395700000000000f,   //  2182: sin(11.9860840)
   0.2077678945240862600000000000f,   //  2183: sin(11.9915771)
   0.2078616752250750700000000000f,   //  2184: sin(11.9970703)
   0.2079554540154439400000000000f,   //  2185: sin(12.0025635)
   0.2080492308943309400000000000f,   //  2186: sin(12.0080566)
   0.2081430058608740600000000000f,   //  2187: sin(12.0135498)
   0.2082367789142113300000000000f,   //  2188: sin(12.0190430)
   0.2083305500534808300000000000f,   //  2189: sin(12.0245361)
   0.2084243192778206000000000000f,   //  2190: sin(12.0300293)
   0.2085180865863688100000000000f,   //  2191: sin(12.0355225)
   0.2086118519782634900000000000f,   //  2192: sin(12.0410156)
   0.2087056154526428000000000000f,   //  2193: sin(12.0465088)
   0.2087993770086449000000000000f,   //  2194: sin(12.0520020)
   0.2088931366454079300000000000f,   //  2195: sin(12.0574951)
   0.2089868943620700700000000000f,   //  2196: sin(12.0629883)
   0.2090806501577695500000000000f,   //  2197: sin(12.0684814)
   0.2091744040316445800000000000f,   //  2198: sin(12.0739746)
   0.2092681559828333500000000000f,   //  2199: sin(12.0794678)
   0.2093619060104741600000000000f,   //  2200: sin(12.0849609)
   0.2094556541137052600000000000f,   //  2201: sin(12.0904541)
   0.2095494002916649400000000000f,   //  2202: sin(12.0959473)
   0.2096431445434915300000000000f,   //  2203: sin(12.1014404)
   0.2097368868683232900000000000f,   //  2204: sin(12.1069336)
   0.2098306272652986400000000000f,   //  2205: sin(12.1124268)
   0.2099243657335558800000000000f,   //  2206: sin(12.1179199)
   0.2100181022722333900000000000f,   //  2207: sin(12.1234131)
   0.2101118368804696100000000000f,   //  2208: sin(12.1289063)
   0.2102055695574029400000000000f,   //  2209: sin(12.1343994)
   0.2102993003021717300000000000f,   //  2210: sin(12.1398926)
   0.2103930291139145300000000000f,   //  2211: sin(12.1453857)
   0.2104867559917697200000000000f,   //  2212: sin(12.1508789)
   0.2105804809348758600000000000f,   //  2213: sin(12.1563721)
   0.2106742039423714400000000000f,   //  2214: sin(12.1618652)
   0.2107679250133948900000000000f,   //  2215: sin(12.1673584)
   0.2108616441470848600000000000f,   //  2216: sin(12.1728516)
   0.2109553613425798300000000000f,   //  2217: sin(12.1783447)
   0.2110490765990183900000000000f,   //  2218: sin(12.1838379)
   0.2111427899155391400000000000f,   //  2219: sin(12.1893311)
   0.2112365012912807100000000000f,   //  2220: sin(12.1948242)
   0.2113302107253816600000000000f,   //  2221: sin(12.2003174)
   0.2114239182169806700000000000f,   //  2222: sin(12.2058105)
   0.2115176237652164100000000000f,   //  2223: sin(12.2113037)
   0.2116113273692275500000000000f,   //  2224: sin(12.2167969)
   0.2117050290281528000000000000f,   //  2225: sin(12.2222900)
   0.2117987287411308400000000000f,   //  2226: sin(12.2277832)
   0.2118924265073004500000000000f,   //  2227: sin(12.2332764)
   0.2119861223258003300000000000f,   //  2228: sin(12.2387695)
   0.2120798161957692700000000000f,   //  2229: sin(12.2442627)
   0.2121735081163460800000000000f,   //  2230: sin(12.2497559)
   0.2122671980866695200000000000f,   //  2231: sin(12.2552490)
   0.2123608861058784200000000000f,   //  2232: sin(12.2607422)
   0.2124545721731116700000000000f,   //  2233: sin(12.2662354)
   0.2125482562875080600000000000f,   //  2234: sin(12.2717285)
   0.2126419384482065000000000000f,   //  2235: sin(12.2772217)
   0.2127356186543459300000000000f,   //  2236: sin(12.2827148)
   0.2128292969050651400000000000f,   //  2237: sin(12.2882080)
   0.2129229731995031800000000000f,   //  2238: sin(12.2937012)
   0.2130166475367989400000000000f,   //  2239: sin(12.2991943)
   0.2131103199160913600000000000f,   //  2240: sin(12.3046875)
   0.2132039903365194900000000000f,   //  2241: sin(12.3101807)
   0.2132976587972223200000000000f,   //  2242: sin(12.3156738)
   0.2133913252973387900000000000f,   //  2243: sin(12.3211670)
   0.2134849898360080500000000000f,   //  2244: sin(12.3266602)
   0.2135786524123690600000000000f,   //  2245: sin(12.3321533)
   0.2136723130255609700000000000f,   //  2246: sin(12.3376465)
   0.2137659716747228300000000000f,   //  2247: sin(12.3431396)
   0.2138596283589937500000000000f,   //  2248: sin(12.3486328)
   0.2139532830775128800000000000f,   //  2249: sin(12.3541260)
   0.2140469358294193600000000000f,   //  2250: sin(12.3596191)
   0.2141405866138523200000000000f,   //  2251: sin(12.3651123)
   0.2142342354299509900000000000f,   //  2252: sin(12.3706055)
   0.2143278822768545400000000000f,   //  2253: sin(12.3760986)
   0.2144215271537021600000000000f,   //  2254: sin(12.3815918)
   0.2145151700596331600000000000f,   //  2255: sin(12.3870850)
   0.2146088109937867600000000000f,   //  2256: sin(12.3925781)
   0.2147024499553022200000000000f,   //  2257: sin(12.3980713)
   0.2147960869433188600000000000f,   //  2258: sin(12.4035645)
   0.2148897219569759200000000000f,   //  2259: sin(12.4090576)
   0.2149833549954128200000000000f,   //  2260: sin(12.4145508)
   0.2150769860577688700000000000f,   //  2261: sin(12.4200439)
   0.2151706151431833900000000000f,   //  2262: sin(12.4255371)
   0.2152642422507958200000000000f,   //  2263: sin(12.4310303)
   0.2153578673797455500000000000f,   //  2264: sin(12.4365234)
   0.2154514905291719500000000000f,   //  2265: sin(12.4420166)
   0.2155451116982145000000000000f,   //  2266: sin(12.4475098)
   0.2156387308860126500000000000f,   //  2267: sin(12.4530029)
   0.2157323480917058800000000000f,   //  2268: sin(12.4584961)
   0.2158259633144336600000000000f,   //  2269: sin(12.4639893)
   0.2159195765533354900000000000f,   //  2270: sin(12.4694824)
   0.2160131878075509400000000000f,   //  2271: sin(12.4749756)
   0.2161067970762195200000000000f,   //  2272: sin(12.4804688)
   0.2162004043584807900000000000f,   //  2273: sin(12.4859619)
   0.2162940096534743400000000000f,   //  2274: sin(12.4914551)
   0.2163876129603398100000000000f,   //  2275: sin(12.4969482)
   0.2164812142782167300000000000f,   //  2276: sin(12.5024414)
   0.2165748136062448600000000000f,   //  2277: sin(12.5079346)
   0.2166684109435637300000000000f,   //  2278: sin(12.5134277)
   0.2167620062893131100000000000f,   //  2279: sin(12.5189209)
   0.2168555996426326200000000000f,   //  2280: sin(12.5244141)
   0.2169491910026620000000000000f,   //  2281: sin(12.5299072)
   0.2170427803685409900000000000f,   //  2282: sin(12.5354004)
   0.2171363677394093400000000000f,   //  2283: sin(12.5408936)
   0.2172299531144067900000000000f,   //  2284: sin(12.5463867)
   0.2173235364926731400000000000f,   //  2285: sin(12.5518799)
   0.2174171178733481900000000000f,   //  2286: sin(12.5573730)
   0.2175106972555717100000000000f,   //  2287: sin(12.5628662)
   0.2176042746384836400000000000f,   //  2288: sin(12.5683594)
   0.2176978500212237400000000000f,   //  2289: sin(12.5738525)
   0.2177914234029319500000000000f,   //  2290: sin(12.5793457)
   0.2178849947827481400000000000f,   //  2291: sin(12.5848389)
   0.2179785641598122000000000000f,   //  2292: sin(12.5903320)
   0.2180721315332641000000000000f,   //  2293: sin(12.5958252)
   0.2181656969022438000000000000f,   //  2294: sin(12.6013184)
   0.2182592602658911800000000000f,   //  2295: sin(12.6068115)
   0.2183528216233463200000000000f,   //  2296: sin(12.6123047)
   0.2184463809737491900000000000f,   //  2297: sin(12.6177979)
   0.2185399383162397700000000000f,   //  2298: sin(12.6232910)
   0.2186334936499581800000000000f,   //  2299: sin(12.6287842)
   0.2187270469740444400000000000f,   //  2300: sin(12.6342773)
   0.2188205982876386100000000000f,   //  2301: sin(12.6397705)
   0.2189141475898808400000000000f,   //  2302: sin(12.6452637)
   0.2190076948799111500000000000f,   //  2303: sin(12.6507568)
   0.2191012401568698000000000000f,   //  2304: sin(12.6562500)
   0.2191947834198968400000000000f,   //  2305: sin(12.6617432)
   0.2192883246681324700000000000f,   //  2306: sin(12.6672363)
   0.2193818639007169000000000000f,   //  2307: sin(12.6727295)
   0.2194754011167903100000000000f,   //  2308: sin(12.6782227)
   0.2195689363154929300000000000f,   //  2309: sin(12.6837158)
   0.2196624694959650500000000000f,   //  2310: sin(12.6892090)
   0.2197560006573468500000000000f,   //  2311: sin(12.6947021)
   0.2198495297987787000000000000f,   //  2312: sin(12.7001953)
   0.2199430569194008300000000000f,   //  2313: sin(12.7056885)
   0.2200365820183535800000000000f,   //  2314: sin(12.7111816)
   0.2201301050947773200000000000f,   //  2315: sin(12.7166748)
   0.2202236261478123800000000000f,   //  2316: sin(12.7221680)
   0.2203171451765990900000000000f,   //  2317: sin(12.7276611)
   0.2204106621802779400000000000f,   //  2318: sin(12.7331543)
   0.2205041771579892800000000000f,   //  2319: sin(12.7386475)
   0.2205976901088735100000000000f,   //  2320: sin(12.7441406)
   0.2206912010320711500000000000f,   //  2321: sin(12.7496338)
   0.2207847099267226100000000000f,   //  2322: sin(12.7551270)
   0.2208782167919684500000000000f,   //  2323: sin(12.7606201)
   0.2209717216269491100000000000f,   //  2324: sin(12.7661133)
   0.2210652244308050900000000000f,   //  2325: sin(12.7716064)
   0.2211587252026770100000000000f,   //  2326: sin(12.7770996)
   0.2212522239417054100000000000f,   //  2327: sin(12.7825928)
   0.2213457206470308100000000000f,   //  2328: sin(12.7880859)
   0.2214392153177939000000000000f,   //  2329: sin(12.7935791)
   0.2215327079531352300000000000f,   //  2330: sin(12.7990723)
   0.2216261985521954200000000000f,   //  2331: sin(12.8045654)
   0.2217196871141152200000000000f,   //  2332: sin(12.8100586)
   0.2218131736380351800000000000f,   //  2333: sin(12.8155518)
   0.2219066581230961000000000000f,   //  2334: sin(12.8210449)
   0.2220001405684386400000000000f,   //  2335: sin(12.8265381)
   0.2220936209732035100000000000f,   //  2336: sin(12.8320313)
   0.2221870993365315200000000000f,   //  2337: sin(12.8375244)
   0.2222805756575633700000000000f,   //  2338: sin(12.8430176)
   0.2223740499354398800000000000f,   //  2339: sin(12.8485107)
   0.2224675221693018800000000000f,   //  2340: sin(12.8540039)
   0.2225609923582901300000000000f,   //  2341: sin(12.8594971)
   0.2226544605015455000000000000f,   //  2342: sin(12.8649902)
   0.2227479265982088800000000000f,   //  2343: sin(12.8704834)
   0.2228413906474211200000000000f,   //  2344: sin(12.8759766)
   0.2229348526483231300000000000f,   //  2345: sin(12.8814697)
   0.2230283126000558200000000000f,   //  2346: sin(12.8869629)
   0.2231217705017601000000000000f,   //  2347: sin(12.8924561)
   0.2232152263525769800000000000f,   //  2348: sin(12.8979492)
   0.2233086801516474300000000000f,   //  2349: sin(12.9034424)
   0.2234021318981123700000000000f,   //  2350: sin(12.9089355)
   0.2234955815911129100000000000f,   //  2351: sin(12.9144287)
   0.2235890292297899900000000000f,   //  2352: sin(12.9199219)
   0.2236824748132847100000000000f,   //  2353: sin(12.9254150)
   0.2237759183407381500000000000f,   //  2354: sin(12.9309082)
   0.2238693598112913600000000000f,   //  2355: sin(12.9364014)
   0.2239627992240854600000000000f,   //  2356: sin(12.9418945)
   0.2240562365782616000000000000f,   //  2357: sin(12.9473877)
   0.2241496718729608700000000000f,   //  2358: sin(12.9528809)
   0.2242431051073244800000000000f,   //  2359: sin(12.9583740)
   0.2243365362804936000000000000f,   //  2360: sin(12.9638672)
   0.2244299653916094200000000000f,   //  2361: sin(12.9693604)
   0.2245233924398131700000000000f,   //  2362: sin(12.9748535)
   0.2246168174242461100000000000f,   //  2363: sin(12.9803467)
   0.2247102403440494300000000000f,   //  2364: sin(12.9858398)
   0.2248036611983644800000000000f,   //  2365: sin(12.9913330)
   0.2248970799863324900000000000f,   //  2366: sin(12.9968262)
   0.2249904967070948400000000000f,   //  2367: sin(13.0023193)
   0.2250839113597928300000000000f,   //  2368: sin(13.0078125)
   0.2251773239435677900000000000f,   //  2369: sin(13.0133057)
   0.2252707344575611600000000000f,   //  2370: sin(13.0187988)
   0.2253641429009142800000000000f,   //  2371: sin(13.0242920)
   0.2254575492727685400000000000f,   //  2372: sin(13.0297852)
   0.2255509535722654000000000000f,   //  2373: sin(13.0352783)
   0.2256443557985463300000000000f,   //  2374: sin(13.0407715)
   0.2257377559507527400000000000f,   //  2375: sin(13.0462646)
   0.2258311540280261700000000000f,   //  2376: sin(13.0517578)
   0.2259245500295080600000000000f,   //  2377: sin(13.0572510)
   0.2260179439543400200000000000f,   //  2378: sin(13.0627441)
   0.2261113358016635400000000000f,   //  2379: sin(13.0682373)
   0.2262047255706201900000000000f,   //  2380: sin(13.0737305)
   0.2262981132603515400000000000f,   //  2381: sin(13.0792236)
   0.2263914988699992400000000000f,   //  2382: sin(13.0847168)
   0.2264848823987048200000000000f,   //  2383: sin(13.0902100)
   0.2265782638456100000000000000f,   //  2384: sin(13.0957031)
   0.2266716432098564200000000000f,   //  2385: sin(13.1011963)
   0.2267650204905856900000000000f,   //  2386: sin(13.1066895)
   0.2268583956869396100000000000f,   //  2387: sin(13.1121826)
   0.2269517687980598100000000000f,   //  2388: sin(13.1176758)
   0.2270451398230881000000000000f,   //  2389: sin(13.1231689)
   0.2271385087611661700000000000f,   //  2390: sin(13.1286621)
   0.2272318756114358200000000000f,   //  2391: sin(13.1341553)
   0.2273252403730388600000000000f,   //  2392: sin(13.1396484)
   0.2274186030451170700000000000f,   //  2393: sin(13.1451416)
   0.2275119636268122800000000000f,   //  2394: sin(13.1506348)
   0.2276053221172663600000000000f,   //  2395: sin(13.1561279)
   0.2276986785156211700000000000f,   //  2396: sin(13.1616211)
   0.2277920328210185900000000000f,   //  2397: sin(13.1671143)
   0.2278853850326005300000000000f,   //  2398: sin(13.1726074)
   0.2279787351495089200000000000f,   //  2399: sin(13.1781006)
   0.2280720831708857300000000000f,   //  2400: sin(13.1835938)
   0.2281654290958729000000000000f,   //  2401: sin(13.1890869)
   0.2282587729236123800000000000f,   //  2402: sin(13.1945801)
   0.2283521146532462300000000000f,   //  2403: sin(13.2000732)
   0.2284454542839164700000000000f,   //  2404: sin(13.2055664)
   0.2285387918147651100000000000f,   //  2405: sin(13.2110596)
   0.2286321272449342300000000000f,   //  2406: sin(13.2165527)
   0.2287254605735659100000000000f,   //  2407: sin(13.2220459)
   0.2288187917998022200000000000f,   //  2408: sin(13.2275391)
   0.2289121209227853200000000000f,   //  2409: sin(13.2330322)
   0.2290054479416573400000000000f,   //  2410: sin(13.2385254)
   0.2290987728555604300000000000f,   //  2411: sin(13.2440186)
   0.2291920956636367700000000000f,   //  2412: sin(13.2495117)
   0.2292854163650285500000000000f,   //  2413: sin(13.2550049)
   0.2293787349588780100000000000f,   //  2414: sin(13.2604980)
   0.2294720514443273900000000000f,   //  2415: sin(13.2659912)
   0.2295653658205188700000000000f,   //  2416: sin(13.2714844)
   0.2296586780865948200000000000f,   //  2417: sin(13.2769775)
   0.2297519882416974900000000000f,   //  2418: sin(13.2824707)
   0.2298452962849691600000000000f,   //  2419: sin(13.2879639)
   0.2299386022155522100000000000f,   //  2420: sin(13.2934570)
   0.2300319060325889700000000000f,   //  2421: sin(13.2989502)
   0.2301252077352218500000000000f,   //  2422: sin(13.3044434)
   0.2302185073225932200000000000f,   //  2423: sin(13.3099365)
   0.2303118047938454400000000000f,   //  2424: sin(13.3154297)
   0.2304051001481210200000000000f,   //  2425: sin(13.3209229)
   0.2304983933845623500000000000f,   //  2426: sin(13.3264160)
   0.2305916845023119100000000000f,   //  2427: sin(13.3319092)
   0.2306849735005122000000000000f,   //  2428: sin(13.3374023)
   0.2307782603783057600000000000f,   //  2429: sin(13.3428955)
   0.2308715451348350200000000000f,   //  2430: sin(13.3483887)
   0.2309648277692426300000000000f,   //  2431: sin(13.3538818)
   0.2310581082806711100000000000f,   //  2432: sin(13.3593750)
   0.2311513866682630400000000000f,   //  2433: sin(13.3648682)
   0.2312446629311610500000000000f,   //  2434: sin(13.3703613)
   0.2313379370685077200000000000f,   //  2435: sin(13.3758545)
   0.2314312090794457500000000000f,   //  2436: sin(13.3813477)
   0.2315244789631177900000000000f,   //  2437: sin(13.3868408)
   0.2316177467186664700000000000f,   //  2438: sin(13.3923340)
   0.2317110123452345600000000000f,   //  2439: sin(13.3978271)
   0.2318042758419647800000000000f,   //  2440: sin(13.4033203)
   0.2318975372079998000000000000f,   //  2441: sin(13.4088135)
   0.2319907964424824400000000000f,   //  2442: sin(13.4143066)
   0.2320840535445555000000000000f,   //  2443: sin(13.4197998)
   0.2321773085133617100000000000f,   //  2444: sin(13.4252930)
   0.2322705613480439400000000000f,   //  2445: sin(13.4307861)
   0.2323638120477450300000000000f,   //  2446: sin(13.4362793)
   0.2324570606116078400000000000f,   //  2447: sin(13.4417725)
   0.2325503070387752400000000000f,   //  2448: sin(13.4472656)
   0.2326435513283901000000000000f,   //  2449: sin(13.4527588)
   0.2327367934795953900000000000f,   //  2450: sin(13.4582520)
   0.2328300334915340600000000000f,   //  2451: sin(13.4637451)
   0.2329232713633489800000000000f,   //  2452: sin(13.4692383)
   0.2330165070941832000000000000f,   //  2453: sin(13.4747314)
   0.2331097406831796900000000000f,   //  2454: sin(13.4802246)
   0.2332029721294814600000000000f,   //  2455: sin(13.4857178)
   0.2332962014322315900000000000f,   //  2456: sin(13.4912109)
   0.2333894285905731000000000000f,   //  2457: sin(13.4967041)
   0.2334826536036490900000000000f,   //  2458: sin(13.5021973)
   0.2335758764706026300000000000f,   //  2459: sin(13.5076904)
   0.2336690971905768200000000000f,   //  2460: sin(13.5131836)
   0.2337623157627148600000000000f,   //  2461: sin(13.5186768)
   0.2338555321861598400000000000f,   //  2462: sin(13.5241699)
   0.2339487464600549500000000000f,   //  2463: sin(13.5296631)
   0.2340419585835434300000000000f,   //  2464: sin(13.5351563)
   0.2341351685557684400000000000f,   //  2465: sin(13.5406494)
   0.2342283763758732100000000000f,   //  2466: sin(13.5461426)
   0.2343215820430010500000000000f,   //  2467: sin(13.5516357)
   0.2344147855562951600000000000f,   //  2468: sin(13.5571289)
   0.2345079869148989100000000000f,   //  2469: sin(13.5626221)
   0.2346011861179555500000000000f,   //  2470: sin(13.5681152)
   0.2346943831646084400000000000f,   //  2471: sin(13.5736084)
   0.2347875780540009700000000000f,   //  2472: sin(13.5791016)
   0.2348807707852764400000000000f,   //  2473: sin(13.5845947)
   0.2349739613575782500000000000f,   //  2474: sin(13.5900879)
   0.2350671497700498900000000000f,   //  2475: sin(13.5955811)
   0.2351603360218347300000000000f,   //  2476: sin(13.6010742)
   0.2352535201120762000000000000f,   //  2477: sin(13.6065674)
   0.2353467020399178400000000000f,   //  2478: sin(13.6120605)
   0.2354398818045030900000000000f,   //  2479: sin(13.6175537)
   0.2355330594049754900000000000f,   //  2480: sin(13.6230469)
   0.2356262348404785700000000000f,   //  2481: sin(13.6285400)
   0.2357194081101558200000000000f,   //  2482: sin(13.6340332)
   0.2358125792131509100000000000f,   //  2483: sin(13.6395264)
   0.2359057481486073700000000000f,   //  2484: sin(13.6450195)
   0.2359989149156688200000000000f,   //  2485: sin(13.6505127)
   0.2360920795134789100000000000f,   //  2486: sin(13.6560059)
   0.2361852419411812600000000000f,   //  2487: sin(13.6614990)
   0.2362784021979195700000000000f,   //  2488: sin(13.6669922)
   0.2363715602828375100000000000f,   //  2489: sin(13.6724854)
   0.2364647161950787800000000000f,   //  2490: sin(13.6779785)
   0.2365578699337871600000000000f,   //  2491: sin(13.6834717)
   0.2366510214981063800000000000f,   //  2492: sin(13.6889648)
   0.2367441708871801700000000000f,   //  2493: sin(13.6944580)
   0.2368373181001523800000000000f,   //  2494: sin(13.6999512)
   0.2369304631361667800000000000f,   //  2495: sin(13.7054443)
   0.2370236059943672000000000000f,   //  2496: sin(13.7109375)
   0.2371167466738975100000000000f,   //  2497: sin(13.7164307)
   0.2372098851739016000000000000f,   //  2498: sin(13.7219238)
   0.2373030214935233100000000000f,   //  2499: sin(13.7274170)
   0.2373961556319066100000000000f,   //  2500: sin(13.7329102)
   0.2374892875881953500000000000f,   //  2501: sin(13.7384033)
   0.2375824173615335700000000000f,   //  2502: sin(13.7438965)
   0.2376755449510651900000000000f,   //  2503: sin(13.7493896)
   0.2377686703559341900000000000f,   //  2504: sin(13.7548828)
   0.2378617935752846400000000000f,   //  2505: sin(13.7603760)
   0.2379549146082605400000000000f,   //  2506: sin(13.7658691)
   0.2380480334540058800000000000f,   //  2507: sin(13.7713623)
   0.2381411501116648400000000000f,   //  2508: sin(13.7768555)
   0.2382342645803814700000000000f,   //  2509: sin(13.7823486)
   0.2383273768592998100000000000f,   //  2510: sin(13.7878418)
   0.2384204869475641000000000000f,   //  2511: sin(13.7933350)
   0.2385135948443184200000000000f,   //  2512: sin(13.7988281)
   0.2386067005487069700000000000f,   //  2513: sin(13.8043213)
   0.2386998040598739800000000000f,   //  2514: sin(13.8098145)
   0.2387929053769635700000000000f,   //  2515: sin(13.8153076)
   0.2388860044991200400000000000f,   //  2516: sin(13.8208008)
   0.2389791014254876400000000000f,   //  2517: sin(13.8262939)
   0.2390721961552106100000000000f,   //  2518: sin(13.8317871)
   0.2391652886874333100000000000f,   //  2519: sin(13.8372803)
   0.2392583790212999800000000000f,   //  2520: sin(13.8427734)
   0.2393514671559549600000000000f,   //  2521: sin(13.8482666)
   0.2394445530905426300000000000f,   //  2522: sin(13.8537598)
   0.2395376368242073700000000000f,   //  2523: sin(13.8592529)
   0.2396307183560935600000000000f,   //  2524: sin(13.8647461)
   0.2397237976853456300000000000f,   //  2525: sin(13.8702393)
   0.2398168748111080000000000000f,   //  2526: sin(13.8757324)
   0.2399099497325251400000000000f,   //  2527: sin(13.8812256)
   0.2400030224487415000000000000f,   //  2528: sin(13.8867188)
   0.2400960929589015500000000000f,   //  2529: sin(13.8922119)
   0.2401891612621499000000000000f,   //  2530: sin(13.8977051)
   0.2402822273576310200000000000f,   //  2531: sin(13.9031982)
   0.2403752912444894500000000000f,   //  2532: sin(13.9086914)
   0.2404683529218698000000000000f,   //  2533: sin(13.9141846)
   0.2405614123889166500000000000f,   //  2534: sin(13.9196777)
   0.2406544696447746600000000000f,   //  2535: sin(13.9251709)
   0.2407475246885884300000000000f,   //  2536: sin(13.9306641)
   0.2408405775195026100000000000f,   //  2537: sin(13.9361572)
   0.2409336281366619100000000000f,   //  2538: sin(13.9416504)
   0.2410266765392110000000000000f,   //  2539: sin(13.9471436)
   0.2411197227262945900000000000f,   //  2540: sin(13.9526367)
   0.2412127666970574900000000000f,   //  2541: sin(13.9581299)
   0.2413058084506443700000000000f,   //  2542: sin(13.9636230)
   0.2413988479862000400000000000f,   //  2543: sin(13.9691162)
   0.2414918853028693300000000000f,   //  2544: sin(13.9746094)
   0.2415849203997970400000000000f,   //  2545: sin(13.9801025)
   0.2416779532761280100000000000f,   //  2546: sin(13.9855957)
   0.2417709839310071000000000000f,   //  2547: sin(13.9910889)
   0.2418640123635791800000000000f,   //  2548: sin(13.9965820)
   0.2419570385729892000000000000f,   //  2549: sin(14.0020752)
   0.2420500625583820700000000000f,   //  2550: sin(14.0075684)
   0.2421430843189026600000000000f,   //  2551: sin(14.0130615)
   0.2422361038536960100000000000f,   //  2552: sin(14.0185547)
   0.2423291211619071100000000000f,   //  2553: sin(14.0240479)
   0.2424221362426808900000000000f,   //  2554: sin(14.0295410)
   0.2425151490951624700000000000f,   //  2555: sin(14.0350342)
   0.2426081597184968100000000000f,   //  2556: sin(14.0405273)
   0.2427011681118290400000000000f,   //  2557: sin(14.0460205)
   0.2427941742743042200000000000f,   //  2558: sin(14.0515137)
   0.2428871782050674400000000000f,   //  2559: sin(14.0570068)
   0.2429801799032638700000000000f,   //  2560: sin(14.0625000)
   0.2430731793680386600000000000f,   //  2561: sin(14.0679932)
   0.2431661765985369000000000000f,   //  2562: sin(14.0734863)
   0.2432591715939038700000000000f,   //  2563: sin(14.0789795)
   0.2433521643532847400000000000f,   //  2564: sin(14.0844727)
   0.2434451548758247200000000000f,   //  2565: sin(14.0899658)
   0.2435381431606691300000000000f,   //  2566: sin(14.0954590)
   0.2436311292069631400000000000f,   //  2567: sin(14.1009521)
   0.2437241130138521600000000000f,   //  2568: sin(14.1064453)
   0.2438170945804814200000000000f,   //  2569: sin(14.1119385)
   0.2439100739059962600000000000f,   //  2570: sin(14.1174316)
   0.2440030509895420600000000000f,   //  2571: sin(14.1229248)
   0.2440960258302642100000000000f,   //  2572: sin(14.1284180)
   0.2441889984273080400000000000f,   //  2573: sin(14.1339111)
   0.2442819687798190300000000000f,   //  2574: sin(14.1394043)
   0.2443749368869425900000000000f,   //  2575: sin(14.1448975)
   0.2444679027478241500000000000f,   //  2576: sin(14.1503906)
   0.2445608663616092600000000000f,   //  2577: sin(14.1558838)
   0.2446538277274433200000000000f,   //  2578: sin(14.1613770)
   0.2447467868444719600000000000f,   //  2579: sin(14.1668701)
   0.2448397437118406700000000000f,   //  2580: sin(14.1723633)
   0.2449326983286949400000000000f,   //  2581: sin(14.1778564)
   0.2450256506941804700000000000f,   //  2582: sin(14.1833496)
   0.2451186008074428000000000000f,   //  2583: sin(14.1888428)
   0.2452115486676275400000000000f,   //  2584: sin(14.1943359)
   0.2453044942738803700000000000f,   //  2585: sin(14.1998291)
   0.2453974376253469600000000000f,   //  2586: sin(14.2053223)
   0.2454903787211729400000000000f,   //  2587: sin(14.2108154)
   0.2455833175605040600000000000f,   //  2588: sin(14.2163086)
   0.2456762541424860100000000000f,   //  2589: sin(14.2218018)
   0.2457691884662645800000000000f,   //  2590: sin(14.2272949)
   0.2458621205309855200000000000f,   //  2591: sin(14.2327881)
   0.2459550503357945900000000000f,   //  2592: sin(14.2382813)
   0.2460479778798376500000000000f,   //  2593: sin(14.2437744)
   0.2461409031622605300000000000f,   //  2594: sin(14.2492676)
   0.2462338261822090100000000000f,   //  2595: sin(14.2547607)
   0.2463267469388290300000000000f,   //  2596: sin(14.2602539)
   0.2464196654312664800000000000f,   //  2597: sin(14.2657471)
   0.2465125816586672100000000000f,   //  2598: sin(14.2712402)
   0.2466054956201772200000000000f,   //  2599: sin(14.2767334)
   0.2466984073149424100000000000f,   //  2600: sin(14.2822266)
   0.2467913167421088300000000000f,   //  2601: sin(14.2877197)
   0.2468842239008224300000000000f,   //  2602: sin(14.2932129)
   0.2469771287902292100000000000f,   //  2603: sin(14.2987061)
   0.2470700314094752500000000000f,   //  2604: sin(14.3041992)
   0.2471629317577065900000000000f,   //  2605: sin(14.3096924)
   0.2472558298340693000000000000f,   //  2606: sin(14.3151855)
   0.2473487256377094900000000000f,   //  2607: sin(14.3206787)
   0.2474416191677732700000000000f,   //  2608: sin(14.3261719)
   0.2475345104234068200000000000f,   //  2609: sin(14.3316650)
   0.2476273994037562800000000000f,   //  2610: sin(14.3371582)
   0.2477202861079678100000000000f,   //  2611: sin(14.3426514)
   0.2478131705351876700000000000f,   //  2612: sin(14.3481445)
   0.2479060526845619800000000000f,   //  2613: sin(14.3536377)
   0.2479989325552371100000000000f,   //  2614: sin(14.3591309)
   0.2480918101463592800000000000f,   //  2615: sin(14.3646240)
   0.2481846854570747800000000000f,   //  2616: sin(14.3701172)
   0.2482775584865299400000000000f,   //  2617: sin(14.3756104)
   0.2483704292338709800000000000f,   //  2618: sin(14.3811035)
   0.2484632976982444300000000000f,   //  2619: sin(14.3865967)
   0.2485561638787965600000000000f,   //  2620: sin(14.3920898)
   0.2486490277746737600000000000f,   //  2621: sin(14.3975830)
   0.2487418893850224800000000000f,   //  2622: sin(14.4030762)
   0.2488347487089891400000000000f,   //  2623: sin(14.4085693)
   0.2489276057457201500000000000f,   //  2624: sin(14.4140625)
   0.2490204604943620800000000000f,   //  2625: sin(14.4195557)
   0.2491133129540613600000000000f,   //  2626: sin(14.4250488)
   0.2492061631239645700000000000f,   //  2627: sin(14.4305420)
   0.2492990110032181900000000000f,   //  2628: sin(14.4360352)
   0.2493918565909687700000000000f,   //  2629: sin(14.4415283)
   0.2494846998863629600000000000f,   //  2630: sin(14.4470215)
   0.2495775408885473600000000000f,   //  2631: sin(14.4525146)
   0.2496703795966685700000000000f,   //  2632: sin(14.4580078)
   0.2497632160098732200000000000f,   //  2633: sin(14.4635010)
   0.2498560501273079900000000000f,   //  2634: sin(14.4689941)
   0.2499488819481195400000000000f,   //  2635: sin(14.4744873)
   0.2500417114714546500000000000f,   //  2636: sin(14.4799805)
   0.2501345386964600200000000000f,   //  2637: sin(14.4854736)
   0.2502273636222823700000000000f,   //  2638: sin(14.4909668)
   0.2503201862480685700000000000f,   //  2639: sin(14.4964600)
   0.2504130065729652200000000000f,   //  2640: sin(14.5019531)
   0.2505058245961193600000000000f,   //  2641: sin(14.5074463)
   0.2505986403166776700000000000f,   //  2642: sin(14.5129395)
   0.2506914537337871000000000000f,   //  2643: sin(14.5184326)
   0.2507842648465945000000000000f,   //  2644: sin(14.5239258)
   0.2508770736542467200000000000f,   //  2645: sin(14.5294189)
   0.2509698801558907200000000000f,   //  2646: sin(14.5349121)
   0.2510626843506734700000000000f,   //  2647: sin(14.5404053)
   0.2511554862377419200000000000f,   //  2648: sin(14.5458984)
   0.2512482858162430300000000000f,   //  2649: sin(14.5513916)
   0.2513410830853238800000000000f,   //  2650: sin(14.5568848)
   0.2514338780441313100000000000f,   //  2651: sin(14.5623779)
   0.2515266706918126100000000000f,   //  2652: sin(14.5678711)
   0.2516194610275147000000000000f,   //  2653: sin(14.5733643)
   0.2517122490503847000000000000f,   //  2654: sin(14.5788574)
   0.2518050347595697800000000000f,   //  2655: sin(14.5843506)
   0.2518978181542169700000000000f,   //  2656: sin(14.5898438)
   0.2519905992334734400000000000f,   //  2657: sin(14.5953369)
   0.2520833779964864500000000000f,   //  2658: sin(14.6008301)
   0.2521761544424032100000000000f,   //  2659: sin(14.6063232)
   0.2522689285703708100000000000f,   //  2660: sin(14.6118164)
   0.2523617003795365900000000000f,   //  2661: sin(14.6173096)
   0.2524544698690477400000000000f,   //  2662: sin(14.6228027)
   0.2525472370380516500000000000f,   //  2663: sin(14.6282959)
   0.2526400018856955200000000000f,   //  2664: sin(14.6337891)
   0.2527327644111267400000000000f,   //  2665: sin(14.6392822)
   0.2528255246134926100000000000f,   //  2666: sin(14.6447754)
   0.2529182824919405900000000000f,   //  2667: sin(14.6502686)
   0.2530110380456178600000000000f,   //  2668: sin(14.6557617)
   0.2531037912736721100000000000f,   //  2669: sin(14.6612549)
   0.2531965421752505600000000000f,   //  2670: sin(14.6667480)
   0.2532892907495007400000000000f,   //  2671: sin(14.6722412)
   0.2533820369955701600000000000f,   //  2672: sin(14.6777344)
   0.2534747809126062200000000000f,   //  2673: sin(14.6832275)
   0.2535675224997565600000000000f,   //  2674: sin(14.6887207)
   0.2536602617561686300000000000f,   //  2675: sin(14.6942139)
   0.2537529986809899900000000000f,   //  2676: sin(14.6997070)
   0.2538457332733682900000000000f,   //  2677: sin(14.7052002)
   0.2539384655324510900000000000f,   //  2678: sin(14.7106934)
   0.2540311954573859500000000000f,   //  2679: sin(14.7161865)
   0.2541239230473206200000000000f,   //  2680: sin(14.7216797)
   0.2542166483014027800000000000f,   //  2681: sin(14.7271729)
   0.2543093712187800000000000000f,   //  2682: sin(14.7326660)
   0.2544020917986001300000000000f,   //  2683: sin(14.7381592)
   0.2544948100400107300000000000f,   //  2684: sin(14.7436523)
   0.2545875259421597200000000000f,   //  2685: sin(14.7491455)
   0.2546802395041948300000000000f,   //  2686: sin(14.7546387)
   0.2547729507252638500000000000f,   //  2687: sin(14.7601318)
   0.2548656596045145700000000000f,   //  2688: sin(14.7656250)
   0.2549583661410948500000000000f,   //  2689: sin(14.7711182)
   0.2550510703341524700000000000f,   //  2690: sin(14.7766113)
   0.2551437721828355200000000000f,   //  2691: sin(14.7821045)
   0.2552364716862917100000000000f,   //  2692: sin(14.7875977)
   0.2553291688436690700000000000f,   //  2693: sin(14.7930908)
   0.2554218636541154600000000000f,   //  2694: sin(14.7985840)
   0.2555145561167788700000000000f,   //  2695: sin(14.8040771)
   0.2556072462308073800000000000f,   //  2696: sin(14.8095703)
   0.2556999339953489600000000000f,   //  2697: sin(14.8150635)
   0.2557926194095516100000000000f,   //  2698: sin(14.8205566)
   0.2558853024725634100000000000f,   //  2699: sin(14.8260498)
   0.2559779831835324300000000000f,   //  2700: sin(14.8315430)
   0.2560706615416066800000000000f,   //  2701: sin(14.8370361)
   0.2561633375459344600000000000f,   //  2702: sin(14.8425293)
   0.2562560111956638200000000000f,   //  2703: sin(14.8480225)
   0.2563486824899429100000000000f,   //  2704: sin(14.8535156)
   0.2564413514279199100000000000f,   //  2705: sin(14.8590088)
   0.2565340180087430400000000000f,   //  2706: sin(14.8645020)
   0.2566266822315605400000000000f,   //  2707: sin(14.8699951)
   0.2567193440955206600000000000f,   //  2708: sin(14.8754883)
   0.2568120035997716900000000000f,   //  2709: sin(14.8809814)
   0.2569046607434619100000000000f,   //  2710: sin(14.8864746)
   0.2569973155257396200000000000f,   //  2711: sin(14.8919678)
   0.2570899679457531200000000000f,   //  2712: sin(14.8974609)
   0.2571826180026508500000000000f,   //  2713: sin(14.9029541)
   0.2572752656955811200000000000f,   //  2714: sin(14.9084473)
   0.2573679110236924400000000000f,   //  2715: sin(14.9139404)
   0.2574605539861331000000000000f,   //  2716: sin(14.9194336)
   0.2575531945820515600000000000f,   //  2717: sin(14.9249268)
   0.2576458328105963900000000000f,   //  2718: sin(14.9304199)
   0.2577384686709160400000000000f,   //  2719: sin(14.9359131)
   0.2578311021621589900000000000f,   //  2720: sin(14.9414063)
   0.2579237332834737900000000000f,   //  2721: sin(14.9468994)
   0.2580163620340090200000000000f,   //  2722: sin(14.9523926)
   0.2581089884129131300000000000f,   //  2723: sin(14.9578857)
   0.2582016124193348700000000000f,   //  2724: sin(14.9633789)
   0.2582942340524228000000000000f,   //  2725: sin(14.9688721)
   0.2583868533113256000000000000f,   //  2726: sin(14.9743652)
   0.2584794701951919100000000000f,   //  2727: sin(14.9798584)
   0.2585720847031703400000000000f,   //  2728: sin(14.9853516)
   0.2586646968344096800000000000f,   //  2729: sin(14.9908447)
   0.2587573065880586800000000000f,   //  2730: sin(14.9963379)
   0.2588499139632660100000000000f,   //  2731: sin(15.0018311)
   0.2589425189591805200000000000f,   //  2732: sin(15.0073242)
   0.2590351215749510100000000000f,   //  2733: sin(15.0128174)
   0.2591277218097261500000000000f,   //  2734: sin(15.0183105)
   0.2592203196626549600000000000f,   //  2735: sin(15.0238037)
   0.2593129151328862300000000000f,   //  2736: sin(15.0292969)
   0.2594055082195688100000000000f,   //  2737: sin(15.0347900)
   0.2594980989218516600000000000f,   //  2738: sin(15.0402832)
   0.2595906872388836200000000000f,   //  2739: sin(15.0457764)
   0.2596832731698137700000000000f,   //  2740: sin(15.0512695)
   0.2597758567137910000000000000f,   //  2741: sin(15.0567627)
   0.2598684378699642700000000000f,   //  2742: sin(15.0622559)
   0.2599610166374826700000000000f,   //  2743: sin(15.0677490)
   0.2600535930154951900000000000f,   //  2744: sin(15.0732422)
   0.2601461670031508500000000000f,   //  2745: sin(15.0787354)
   0.2602387385995988400000000000f,   //  2746: sin(15.0842285)
   0.2603313078039881700000000000f,   //  2747: sin(15.0897217)
   0.2604238746154680100000000000f,   //  2748: sin(15.0952148)
   0.2605164390331875000000000000f,   //  2749: sin(15.1007080)
   0.2606090010562957500000000000f,   //  2750: sin(15.1062012)
   0.2607015606839420100000000000f,   //  2751: sin(15.1116943)
   0.2607941179152755100000000000f,   //  2752: sin(15.1171875)
   0.2608866727494454400000000000f,   //  2753: sin(15.1226807)
   0.2609792251856010700000000000f,   //  2754: sin(15.1281738)
   0.2610717752228916600000000000f,   //  2755: sin(15.1336670)
   0.2611643228604664800000000000f,   //  2756: sin(15.1391602)
   0.2612568680974749500000000000f,   //  2757: sin(15.1446533)
   0.2613494109330663500000000000f,   //  2758: sin(15.1501465)
   0.2614419513663900900000000000f,   //  2759: sin(15.1556396)
   0.2615344893965955200000000000f,   //  2760: sin(15.1611328)
   0.2616270250228319700000000000f,   //  2761: sin(15.1666260)
   0.2617195582442490300000000000f,   //  2762: sin(15.1721191)
   0.2618120890599960900000000000f,   //  2763: sin(15.1776123)
   0.2619046174692226100000000000f,   //  2764: sin(15.1831055)
   0.2619971434710780500000000000f,   //  2765: sin(15.1885986)
   0.2620896670647120400000000000f,   //  2766: sin(15.1940918)
   0.2621821882492740300000000000f,   //  2767: sin(15.1995850)
   0.2622747070239135900000000000f,   //  2768: sin(15.2050781)
   0.2623672233877804000000000000f,   //  2769: sin(15.2105713)
   0.2624597373400239800000000000f,   //  2770: sin(15.2160645)
   0.2625522488797940000000000000f,   //  2771: sin(15.2215576)
   0.2626447580062400400000000000f,   //  2772: sin(15.2270508)
   0.2627372647185118300000000000f,   //  2773: sin(15.2325439)
   0.2628297690157591600000000000f,   //  2774: sin(15.2380371)
   0.2629222708971316000000000000f,   //  2775: sin(15.2435303)
   0.2630147703617790000000000000f,   //  2776: sin(15.2490234)
   0.2631072674088510400000000000f,   //  2777: sin(15.2545166)
   0.2631997620374975600000000000f,   //  2778: sin(15.2600098)
   0.2632922542468683600000000000f,   //  2779: sin(15.2655029)
   0.2633847440361132800000000000f,   //  2780: sin(15.2709961)
   0.2634772314043821200000000000f,   //  2781: sin(15.2764893)
   0.2635697163508248800000000000f,   //  2782: sin(15.2819824)
   0.2636621988745912500000000000f,   //  2783: sin(15.2874756)
   0.2637546789748313500000000000f,   //  2784: sin(15.2929687)
   0.2638471566506950800000000000f,   //  2785: sin(15.2984619)
   0.2639396319013323500000000000f,   //  2786: sin(15.3039551)
   0.2640321047258931700000000000f,   //  2787: sin(15.3094482)
   0.2641245751235275500000000000f,   //  2788: sin(15.3149414)
   0.2642170430933854500000000000f,   //  2789: sin(15.3204346)
   0.2643095086346171100000000000f,   //  2790: sin(15.3259277)
   0.2644019717463724200000000000f,   //  2791: sin(15.3314209)
   0.2644944324278016300000000000f,   //  2792: sin(15.3369141)
   0.2645868906780547400000000000f,   //  2793: sin(15.3424072)
   0.2646793464962818900000000000f,   //  2794: sin(15.3479004)
   0.2647717998816333500000000000f,   //  2795: sin(15.3533936)
   0.2648642508332592600000000000f,   //  2796: sin(15.3588867)
   0.2649566993503098000000000000f,   //  2797: sin(15.3643799)
   0.2650491454319352500000000000f,   //  2798: sin(15.3698730)
   0.2651415890772858600000000000f,   //  2799: sin(15.3753662)
   0.2652340302855117900000000000f,   //  2800: sin(15.3808594)
   0.2653264690557635100000000000f,   //  2801: sin(15.3863525)
   0.2654189053871912600000000000f,   //  2802: sin(15.3918457)
   0.2655113392789454400000000000f,   //  2803: sin(15.3973389)
   0.2656037707301763300000000000f,   //  2804: sin(15.4028320)
   0.2656961997400343300000000000f,   //  2805: sin(15.4083252)
   0.2657886263076699200000000000f,   //  2806: sin(15.4138184)
   0.2658810504322335300000000000f,   //  2807: sin(15.4193115)
   0.2659734721128755900000000000f,   //  2808: sin(15.4248047)
   0.2660658913487465900000000000f,   //  2809: sin(15.4302979)
   0.2661583081389969900000000000f,   //  2810: sin(15.4357910)
   0.2662507224827773100000000000f,   //  2811: sin(15.4412842)
   0.2663431343792381800000000000f,   //  2812: sin(15.4467773)
   0.2664355438275301000000000000f,   //  2813: sin(15.4522705)
   0.2665279508268036900000000000f,   //  2814: sin(15.4577637)
   0.2666203553762095900000000000f,   //  2815: sin(15.4632568)
   0.2667127574748983700000000000f,   //  2816: sin(15.4687500)
   0.2668051571220207400000000000f,   //  2817: sin(15.4742432)
   0.2668975543167273500000000000f,   //  2818: sin(15.4797363)
   0.2669899490581689700000000000f,   //  2819: sin(15.4852295)
   0.2670823413454962400000000000f,   //  2820: sin(15.4907227)
   0.2671747311778600000000000000f,   //  2821: sin(15.4962158)
   0.2672671185544109300000000000f,   //  2822: sin(15.5017090)
   0.2673595034742998800000000000f,   //  2823: sin(15.5072021)
   0.2674518859366776200000000000f,   //  2824: sin(15.5126953)
   0.2675442659406950800000000000f,   //  2825: sin(15.5181885)
   0.2676366434855030900000000000f,   //  2826: sin(15.5236816)
   0.2677290185702525000000000000f,   //  2827: sin(15.5291748)
   0.2678213911940941500000000000f,   //  2828: sin(15.5346680)
   0.2679137613561791100000000000f,   //  2829: sin(15.5401611)
   0.2680061290556582900000000000f,   //  2830: sin(15.5456543)
   0.2680984942916826400000000000f,   //  2831: sin(15.5511475)
   0.2681908570634031800000000000f,   //  2832: sin(15.5566406)
   0.2682832173699709100000000000f,   //  2833: sin(15.5621338)
   0.2683755752105369000000000000f,   //  2834: sin(15.5676270)
   0.2684679305842521700000000000f,   //  2835: sin(15.5731201)
   0.2685602834902678900000000000f,   //  2836: sin(15.5786133)
   0.2686526339277351400000000000f,   //  2837: sin(15.5841064)
   0.2687449818958049800000000000f,   //  2838: sin(15.5895996)
   0.2688373273936285900000000000f,   //  2839: sin(15.5950928)
   0.2689296704203572600000000000f,   //  2840: sin(15.6005859)
   0.2690220109751421100000000000f,   //  2841: sin(15.6060791)
   0.2691143490571343800000000000f,   //  2842: sin(15.6115723)
   0.2692066846654853100000000000f,   //  2843: sin(15.6170654)
   0.2692990177993461200000000000f,   //  2844: sin(15.6225586)
   0.2693913484578682200000000000f,   //  2845: sin(15.6280518)
   0.2694836766402028400000000000f,   //  2846: sin(15.6335449)
   0.2695760023455013300000000000f,   //  2847: sin(15.6390381)
   0.2696683255729150900000000000f,   //  2848: sin(15.6445313)
   0.2697606463215955200000000000f,   //  2849: sin(15.6500244)
   0.2698529645906938600000000000f,   //  2850: sin(15.6555176)
   0.2699452803793617700000000000f,   //  2851: sin(15.6610107)
   0.2700375936867505700000000000f,   //  2852: sin(15.6665039)
   0.2701299045120118000000000000f,   //  2853: sin(15.6719971)
   0.2702222128542968700000000000f,   //  2854: sin(15.6774902)
   0.2703145187127573600000000000f,   //  2855: sin(15.6829834)
   0.2704068220865448200000000000f,   //  2856: sin(15.6884766)
   0.2704991229748108200000000000f,   //  2857: sin(15.6939697)
   0.2705914213767069400000000000f,   //  2858: sin(15.6994629)
   0.2706837172913848000000000000f,   //  2859: sin(15.7049561)
   0.2707760107179960100000000000f,   //  2860: sin(15.7104492)
   0.2708683016556922000000000000f,   //  2861: sin(15.7159424)
   0.2709605901036251700000000000f,   //  2862: sin(15.7214355)
   0.2710528760609465200000000000f,   //  2863: sin(15.7269287)
   0.2711451595268080100000000000f,   //  2864: sin(15.7324219)
   0.2712374405003614200000000000f,   //  2865: sin(15.7379150)
   0.2713297189807584200000000000f,   //  2866: sin(15.7434082)
   0.2714219949671509100000000000f,   //  2867: sin(15.7489014)
   0.2715142684586907000000000000f,   //  2868: sin(15.7543945)
   0.2716065394545296200000000000f,   //  2869: sin(15.7598877)
   0.2716988079538195100000000000f,   //  2870: sin(15.7653809)
   0.2717910739557122300000000000f,   //  2871: sin(15.7708740)
   0.2718833374593597200000000000f,   //  2872: sin(15.7763672)
   0.2719755984639140000000000000f,   //  2873: sin(15.7818604)
   0.2720678569685269200000000000f,   //  2874: sin(15.7873535)
   0.2721601129723504900000000000f,   //  2875: sin(15.7928467)
   0.2722523664745367100000000000f,   //  2876: sin(15.7983398)
   0.2723446174742375500000000000f,   //  2877: sin(15.8038330)
   0.2724368659706052400000000000f,   //  2878: sin(15.8093262)
   0.2725291119627916700000000000f,   //  2879: sin(15.8148193)
   0.2726213554499489800000000000f,   //  2880: sin(15.8203125)
   0.2727135964312293300000000000f,   //  2881: sin(15.8258057)
   0.2728058349057848100000000000f,   //  2882: sin(15.8312988)
   0.2728980708727675700000000000f,   //  2883: sin(15.8367920)
   0.2729903043313299200000000000f,   //  2884: sin(15.8422852)
   0.2730825352806239300000000000f,   //  2885: sin(15.8477783)
   0.2731747637198019300000000000f,   //  2886: sin(15.8532715)
   0.2732669896480161000000000000f,   //  2887: sin(15.8587646)
   0.2733592130644186800000000000f,   //  2888: sin(15.8642578)
   0.2734514339681621300000000000f,   //  2889: sin(15.8697510)
   0.2735436523583987300000000000f,   //  2890: sin(15.8752441)
   0.2736358682342807100000000000f,   //  2891: sin(15.8807373)
   0.2737280815949605400000000000f,   //  2892: sin(15.8862305)
   0.2738202924395906100000000000f,   //  2893: sin(15.8917236)
   0.2739125007673232600000000000f,   //  2894: sin(15.8972168)
   0.2740047065773110700000000000f,   //  2895: sin(15.9027100)
   0.2740969098687063800000000000f,   //  2896: sin(15.9082031)
   0.2741891106406617600000000000f,   //  2897: sin(15.9136963)
   0.2742813088923296600000000000f,   //  2898: sin(15.9191895)
   0.2743735046228625900000000000f,   //  2899: sin(15.9246826)
   0.2744656978314132200000000000f,   //  2900: sin(15.9301758)
   0.2745578885171340300000000000f,   //  2901: sin(15.9356689)
   0.2746500766791776800000000000f,   //  2902: sin(15.9411621)
   0.2747422623166967400000000000f,   //  2903: sin(15.9466553)
   0.2748344454288439400000000000f,   //  2904: sin(15.9521484)
   0.2749266260147718000000000000f,   //  2905: sin(15.9576416)
   0.2750188040736332200000000000f,   //  2906: sin(15.9631348)
   0.2751109796045808100000000000f,   //  2907: sin(15.9686279)
   0.2752031526067673100000000000f,   //  2908: sin(15.9741211)
   0.2752953230793455100000000000f,   //  2909: sin(15.9796143)
   0.2753874910214681400000000000f,   //  2910: sin(15.9851074)
   0.2754796564322880600000000000f,   //  2911: sin(15.9906006)
   0.2755718193109581400000000000f,   //  2912: sin(15.9960938)
   0.2756639796566312000000000000f,   //  2913: sin(16.0015869)
   0.2757561374684601200000000000f,   //  2914: sin(16.0070801)
   0.2758482927455978000000000000f,   //  2915: sin(16.0125732)
   0.2759404454871971500000000000f,   //  2916: sin(16.0180664)
   0.2760325956924111800000000000f,   //  2917: sin(16.0235596)
   0.2761247433603928300000000000f,   //  2918: sin(16.0290527)
   0.2762168884902951300000000000f,   //  2919: sin(16.0345459)
   0.2763090310812710800000000000f,   //  2920: sin(16.0400391)
   0.2764011711324736400000000000f,   //  2921: sin(16.0455322)
   0.2764933086430559900000000000f,   //  2922: sin(16.0510254)
   0.2765854436121712400000000000f,   //  2923: sin(16.0565186)
   0.2766775760389724200000000000f,   //  2924: sin(16.0620117)
   0.2767697059226126900000000000f,   //  2925: sin(16.0675049)
   0.2768618332622452800000000000f,   //  2926: sin(16.0729980)
   0.2769539580570232200000000000f,   //  2927: sin(16.0784912)
   0.2770460803060999000000000000f,   //  2928: sin(16.0839844)
   0.2771382000086284300000000000f,   //  2929: sin(16.0894775)
   0.2772303171637621700000000000f,   //  2930: sin(16.0949707)
   0.2773224317706543000000000000f,   //  2931: sin(16.1004639)
   0.2774145438284580900000000000f,   //  2932: sin(16.1059570)
   0.2775066533363270100000000000f,   //  2933: sin(16.1114502)
   0.2775987602934142900000000000f,   //  2934: sin(16.1169434)
   0.2776908646988733900000000000f,   //  2935: sin(16.1224365)
   0.2777829665518576900000000000f,   //  2936: sin(16.1279297)
   0.2778750658515205000000000000f,   //  2937: sin(16.1334229)
   0.2779671625970153700000000000f,   //  2938: sin(16.1389160)
   0.2780592567874957100000000000f,   //  2939: sin(16.1444092)
   0.2781513484221150900000000000f,   //  2940: sin(16.1499023)
   0.2782434375000270000000000000f,   //  2941: sin(16.1553955)
   0.2783355240203849200000000000f,   //  2942: sin(16.1608887)
   0.2784276079823424000000000000f,   //  2943: sin(16.1663818)
   0.2785196893850530600000000000f,   //  2944: sin(16.1718750)
   0.2786117682276705900000000000f,   //  2945: sin(16.1773682)
   0.2787038445093484900000000000f,   //  2946: sin(16.1828613)
   0.2787959182292404900000000000f,   //  2947: sin(16.1883545)
   0.2788879893865002800000000000f,   //  2948: sin(16.1938477)
   0.2789800579802814200000000000f,   //  2949: sin(16.1993408)
   0.2790721240097378000000000000f,   //  2950: sin(16.2048340)
   0.2791641874740231600000000000f,   //  2951: sin(16.2103271)
   0.2792562483722911800000000000f,   //  2952: sin(16.2158203)
   0.2793483067036957000000000000f,   //  2953: sin(16.2213135)
   0.2794403624673905100000000000f,   //  2954: sin(16.2268066)
   0.2795324156625295700000000000f,   //  2955: sin(16.2322998)
   0.2796244662882665900000000000f,   //  2956: sin(16.2377930)
   0.2797165143437555500000000000f,   //  2957: sin(16.2432861)
   0.2798085598281503900000000000f,   //  2958: sin(16.2487793)
   0.2799006027406049600000000000f,   //  2959: sin(16.2542725)
   0.2799926430802732200000000000f,   //  2960: sin(16.2597656)
   0.2800846808463092200000000000f,   //  2961: sin(16.2652588)
   0.2801767160378669800000000000f,   //  2962: sin(16.2707520)
   0.2802687486541005100000000000f,   //  2963: sin(16.2762451)
   0.2803607786941638100000000000f,   //  2964: sin(16.2817383)
   0.2804528061572110200000000000f,   //  2965: sin(16.2872314)
   0.2805448310423962500000000000f,   //  2966: sin(16.2927246)
   0.2806368533488735600000000000f,   //  2967: sin(16.2982178)
   0.2807288730757971900000000000f,   //  2968: sin(16.3037109)
   0.2808208902223212600000000000f,   //  2969: sin(16.3092041)
   0.2809129047876000000000000000f,   //  2970: sin(16.3146973)
   0.2810049167707875400000000000f,   //  2971: sin(16.3201904)
   0.2810969261710382600000000000f,   //  2972: sin(16.3256836)
   0.2811889329875063600000000000f,   //  2973: sin(16.3311768)
   0.2812809372193461100000000000f,   //  2974: sin(16.3366699)
   0.2813729388657119100000000000f,   //  2975: sin(16.3421631)
   0.2814649379257579400000000000f,   //  2976: sin(16.3476563)
   0.2815569343986387700000000000f,   //  2977: sin(16.3531494)
   0.2816489282835086300000000000f,   //  2978: sin(16.3586426)
   0.2817409195795220200000000000f,   //  2979: sin(16.3641357)
   0.2818329082858333500000000000f,   //  2980: sin(16.3696289)
   0.2819248944015970700000000000f,   //  2981: sin(16.3751221)
   0.2820168779259676400000000000f,   //  2982: sin(16.3806152)
   0.2821088588580996600000000000f,   //  2983: sin(16.3861084)
   0.2822008371971475600000000000f,   //  2984: sin(16.3916016)
   0.2822928129422659400000000000f,   //  2985: sin(16.3970947)
   0.2823847860926093600000000000f,   //  2986: sin(16.4025879)
   0.2824767566473324100000000000f,   //  2987: sin(16.4080811)
   0.2825687246055897400000000000f,   //  2988: sin(16.4135742)
   0.2826606899665360400000000000f,   //  2989: sin(16.4190674)
   0.2827526527293259300000000000f,   //  2990: sin(16.4245605)
   0.2828446128931141300000000000f,   //  2991: sin(16.4300537)
   0.2829365704570553900000000000f,   //  2992: sin(16.4355469)
   0.2830285254203043200000000000f,   //  2993: sin(16.4410400)
   0.2831204777820158200000000000f,   //  2994: sin(16.4465332)
   0.2832124275413446800000000000f,   //  2995: sin(16.4520264)
   0.2833043746974457400000000000f,   //  2996: sin(16.4575195)
   0.2833963192494737300000000000f,   //  2997: sin(16.4630127)
   0.2834882611965835500000000000f,   //  2998: sin(16.4685059)
   0.2835802005379301500000000000f,   //  2999: sin(16.4739990)
   0.2836721372726684300000000000f,   //  3000: sin(16.4794922)
   0.2837640713999533000000000000f,   //  3001: sin(16.4849854)
   0.2838560029189397500000000000f,   //  3002: sin(16.4904785)
   0.2839479318287827000000000000f,   //  3003: sin(16.4959717)
   0.2840398581286371900000000000f,   //  3004: sin(16.5014648)
   0.2841317818176583000000000000f,   //  3005: sin(16.5069580)
   0.2842237028950010400000000000f,   //  3006: sin(16.5124512)
   0.2843156213598205300000000000f,   //  3007: sin(16.5179443)
   0.2844075372112718800000000000f,   //  3008: sin(16.5234375)
   0.2844994504485100500000000000f,   //  3009: sin(16.5289307)
   0.2845913610706904400000000000f,   //  3010: sin(16.5344238)
   0.2846832690769681200000000000f,   //  3011: sin(16.5399170)
   0.2847751744664983000000000000f,   //  3012: sin(16.5454102)
   0.2848670772384361800000000000f,   //  3013: sin(16.5509033)
   0.2849589773919370400000000000f,   //  3014: sin(16.5563965)
   0.2850508749261560500000000000f,   //  3015: sin(16.5618896)
   0.2851427698402486700000000000f,   //  3016: sin(16.5673828)
   0.2852346621333701800000000000f,   //  3017: sin(16.5728760)
   0.2853265518046758700000000000f,   //  3018: sin(16.5783691)
   0.2854184388533210800000000000f,   //  3019: sin(16.5838623)
   0.2855103232784612600000000000f,   //  3020: sin(16.5893555)
   0.2856022050792518800000000000f,   //  3021: sin(16.5948486)
   0.2856940842548483200000000000f,   //  3022: sin(16.6003418)
   0.2857859608044061000000000000f,   //  3023: sin(16.6058350)
   0.2858778347270806200000000000f,   //  3024: sin(16.6113281)
   0.2859697060220274300000000000f,   //  3025: sin(16.6168213)
   0.2860615746884020400000000000f,   //  3026: sin(16.6223145)
   0.2861534407253600900000000000f,   //  3027: sin(16.6278076)
   0.2862453041320571200000000000f,   //  3028: sin(16.6333008)
   0.2863371649076488200000000000f,   //  3029: sin(16.6387939)
   0.2864290230512907000000000000f,   //  3030: sin(16.6442871)
   0.2865208785621384300000000000f,   //  3031: sin(16.6497803)
   0.2866127314393477900000000000f,   //  3032: sin(16.6552734)
   0.2867045816820744100000000000f,   //  3033: sin(16.6607666)
   0.2867964292894740800000000000f,   //  3034: sin(16.6662598)
   0.2868882742607025700000000000f,   //  3035: sin(16.6717529)
   0.2869801165949155700000000000f,   //  3036: sin(16.6772461)
   0.2870719562912688600000000000f,   //  3037: sin(16.6827393)
   0.2871637933489183900000000000f,   //  3038: sin(16.6882324)
   0.2872556277670200200000000000f,   //  3039: sin(16.6937256)
   0.2873474595447295100000000000f,   //  3040: sin(16.6992188)
   0.2874392886812028900000000000f,   //  3041: sin(16.7047119)
   0.2875311151755959300000000000f,   //  3042: sin(16.7102051)
   0.2876229390270647100000000000f,   //  3043: sin(16.7156982)
   0.2877147602347651700000000000f,   //  3044: sin(16.7211914)
   0.2878065787978533200000000000f,   //  3045: sin(16.7266846)
   0.2878983947154851700000000000f,   //  3046: sin(16.7321777)
   0.2879902079868167400000000000f,   //  3047: sin(16.7376709)
   0.2880820186110041300000000000f,   //  3048: sin(16.7431641)
   0.2881738265872034200000000000f,   //  3049: sin(16.7486572)
   0.2882656319145707700000000000f,   //  3050: sin(16.7541504)
   0.2883574345922623200000000000f,   //  3051: sin(16.7596436)
   0.2884492346194342200000000000f,   //  3052: sin(16.7651367)
   0.2885410319952426100000000000f,   //  3053: sin(16.7706299)
   0.2886328267188438300000000000f,   //  3054: sin(16.7761230)
   0.2887246187893939800000000000f,   //  3055: sin(16.7816162)
   0.2888164082060494800000000000f,   //  3056: sin(16.7871094)
   0.2889081949679664900000000000f,   //  3057: sin(16.7926025)
   0.2889999790743014200000000000f,   //  3058: sin(16.7980957)
   0.2890917605242104800000000000f,   //  3059: sin(16.8035889)
   0.2891835393168502000000000000f,   //  3060: sin(16.8090820)
   0.2892753154513769100000000000f,   //  3061: sin(16.8145752)
   0.2893670889269470100000000000f,   //  3062: sin(16.8200684)
   0.2894588597427169000000000000f,   //  3063: sin(16.8255615)
   0.2895506278978430300000000000f,   //  3064: sin(16.8310547)
   0.2896423933914820100000000000f,   //  3065: sin(16.8365479)
   0.2897341562227902500000000000f,   //  3066: sin(16.8420410)
   0.2898259163909243100000000000f,   //  3067: sin(16.8475342)
   0.2899176738950407500000000000f,   //  3068: sin(16.8530273)
   0.2900094287342961900000000000f,   //  3069: sin(16.8585205)
   0.2901011809078470900000000000f,   //  3070: sin(16.8640137)
   0.2901929304148502800000000000f,   //  3071: sin(16.8695068)
   0.2902846772544623300000000000f,   //  3072: sin(16.8750000)
   0.2903764214258399700000000000f,   //  3073: sin(16.8804932)
   0.2904681629281398200000000000f,   //  3074: sin(16.8859863)
   0.2905599017605186600000000000f,   //  3075: sin(16.8914795)
   0.2906516379221332200000000000f,   //  3076: sin(16.8969727)
   0.2907433714121403500000000000f,   //  3077: sin(16.9024658)
   0.2908351022296968300000000000f,   //  3078: sin(16.9079590)
   0.2909268303739594400000000000f,   //  3079: sin(16.9134521)
   0.2910185558440850900000000000f,   //  3080: sin(16.9189453)
   0.2911102786392305600000000000f,   //  3081: sin(16.9244385)
   0.2912019987585529000000000000f,   //  3082: sin(16.9299316)
   0.2912937162012089200000000000f,   //  3083: sin(16.9354248)
   0.2913854309663556600000000000f,   //  3084: sin(16.9409180)
   0.2914771430531500300000000000f,   //  3085: sin(16.9464111)
   0.2915688524607490400000000000f,   //  3086: sin(16.9519043)
   0.2916605591883098000000000000f,   //  3087: sin(16.9573975)
   0.2917522632349892600000000000f,   //  3088: sin(16.9628906)
   0.2918439645999445500000000000f,   //  3089: sin(16.9683838)
   0.2919356632823327800000000000f,   //  3090: sin(16.9738770)
   0.2920273592813110200000000000f,   //  3091: sin(16.9793701)
   0.2921190525960363800000000000f,   //  3092: sin(16.9848633)
   0.2922107432256662000000000000f,   //  3093: sin(16.9903564)
   0.2923024311693575600000000000f,   //  3094: sin(16.9958496)
   0.2923941164262676700000000000f,   //  3095: sin(17.0013428)
   0.2924857989955538800000000000f,   //  3096: sin(17.0068359)
   0.2925774788763733100000000000f,   //  3097: sin(17.0123291)
   0.2926691560678834600000000000f,   //  3098: sin(17.0178223)
   0.2927608305692414600000000000f,   //  3099: sin(17.0233154)
   0.2928525023796048100000000000f,   //  3100: sin(17.0288086)
   0.2929441714981307900000000000f,   //  3101: sin(17.0343018)
   0.2930358379239768100000000000f,   //  3102: sin(17.0397949)
   0.2931275016563002500000000000f,   //  3103: sin(17.0452881)
   0.2932191626942586300000000000f,   //  3104: sin(17.0507813)
   0.2933108210370094500000000000f,   //  3105: sin(17.0562744)
   0.2934024766837101100000000000f,   //  3106: sin(17.0617676)
   0.2934941296335181700000000000f,   //  3107: sin(17.0672607)
   0.2935857798855912000000000000f,   //  3108: sin(17.0727539)
   0.2936774274390867600000000000f,   //  3109: sin(17.0782471)
   0.2937690722931624000000000000f,   //  3110: sin(17.0837402)
   0.2938607144469758700000000000f,   //  3111: sin(17.0892334)
   0.2939523538996846600000000000f,   //  3112: sin(17.0947266)
   0.2940439906504465100000000000f,   //  3113: sin(17.1002197)
   0.2941356246984190300000000000f,   //  3114: sin(17.1057129)
   0.2942272560427601200000000000f,   //  3115: sin(17.1112061)
   0.2943188846826274000000000000f,   //  3116: sin(17.1166992)
   0.2944105106171786600000000000f,   //  3117: sin(17.1221924)
   0.2945021338455716700000000000f,   //  3118: sin(17.1276855)
   0.2945937543669642800000000000f,   //  3119: sin(17.1331787)
   0.2946853721805143300000000000f,   //  3120: sin(17.1386719)
   0.2947769872853797100000000000f,   //  3121: sin(17.1441650)
   0.2948685996807182700000000000f,   //  3122: sin(17.1496582)
   0.2949602093656879500000000000f,   //  3123: sin(17.1551514)
   0.2950518163394467200000000000f,   //  3124: sin(17.1606445)
   0.2951434206011524500000000000f,   //  3125: sin(17.1661377)
   0.2952350221499632200000000000f,   //  3126: sin(17.1716309)
   0.2953266209850370900000000000f,   //  3127: sin(17.1771240)
   0.2954182171055320100000000000f,   //  3128: sin(17.1826172)
   0.2955098105106061000000000000f,   //  3129: sin(17.1881104)
   0.2956014011994173600000000000f,   //  3130: sin(17.1936035)
   0.2956929891711240800000000000f,   //  3131: sin(17.1990967)
   0.2957845744248842600000000000f,   //  3132: sin(17.2045898)
   0.2958761569598561400000000000f,   //  3133: sin(17.2100830)
   0.2959677367751978900000000000f,   //  3134: sin(17.2155762)
   0.2960593138700676800000000000f,   //  3135: sin(17.2210693)
   0.2961508882436237900000000000f,   //  3136: sin(17.2265625)
   0.2962424598950245700000000000f,   //  3137: sin(17.2320557)
   0.2963340288234281900000000000f,   //  3138: sin(17.2375488)
   0.2964255950279930400000000000f,   //  3139: sin(17.2430420)
   0.2965171585078774700000000000f,   //  3140: sin(17.2485352)
   0.2966087192622397000000000000f,   //  3141: sin(17.2540283)
   0.2967002772902383500000000000f,   //  3142: sin(17.2595215)
   0.2967918325910317000000000000f,   //  3143: sin(17.2650146)
   0.2968833851637782700000000000f,   //  3144: sin(17.2705078)
   0.2969749350076364400000000000f,   //  3145: sin(17.2760010)
   0.2970664821217647300000000000f,   //  3146: sin(17.2814941)
   0.2971580265053216400000000000f,   //  3147: sin(17.2869873)
   0.2972495681574658400000000000f,   //  3148: sin(17.2924805)
   0.2973411070773557800000000000f,   //  3149: sin(17.2979736)
   0.2974326432641500300000000000f,   //  3150: sin(17.3034668)
   0.2975241767170073200000000000f,   //  3151: sin(17.3089600)
   0.2976157074350862000000000000f,   //  3152: sin(17.3144531)
   0.2977072354175454000000000000f,   //  3153: sin(17.3199463)
   0.2977987606635435500000000000f,   //  3154: sin(17.3254395)
   0.2978902831722394200000000000f,   //  3155: sin(17.3309326)
   0.2979818029427918100000000000f,   //  3156: sin(17.3364258)
   0.2980733199743593700000000000f,   //  3157: sin(17.3419189)
   0.2981648342661008500000000000f,   //  3158: sin(17.3474121)
   0.2982563458171753100000000000f,   //  3159: sin(17.3529053)
   0.2983478546267414000000000000f,   //  3160: sin(17.3583984)
   0.2984393606939580400000000000f,   //  3161: sin(17.3638916)
   0.2985308640179841200000000000f,   //  3162: sin(17.3693848)
   0.2986223645979785800000000000f,   //  3163: sin(17.3748779)
   0.2987138624331003300000000000f,   //  3164: sin(17.3803711)
   0.2988053575225084200000000000f,   //  3165: sin(17.3858643)
   0.2988968498653618000000000000f,   //  3166: sin(17.3913574)
   0.2989883394608194900000000000f,   //  3167: sin(17.3968506)
   0.2990798263080404800000000000f,   //  3168: sin(17.4023438)
   0.2991713104061838900000000000f,   //  3169: sin(17.4078369)
   0.2992627917544088400000000000f,   //  3170: sin(17.4133301)
   0.2993542703518745100000000000f,   //  3171: sin(17.4188232)
   0.2994457461977398900000000000f,   //  3172: sin(17.4243164)
   0.2995372192911642800000000000f,   //  3173: sin(17.4298096)
   0.2996286896313067900000000000f,   //  3174: sin(17.4353027)
   0.2997201572173267500000000000f,   //  3175: sin(17.4407959)
   0.2998116220483833500000000000f,   //  3176: sin(17.4462891)
   0.2999030841236358700000000000f,   //  3177: sin(17.4517822)
   0.2999945434422435800000000000f,   //  3178: sin(17.4572754)
   0.3000860000033658300000000000f,   //  3179: sin(17.4627686)
   0.3001774538061619500000000000f,   //  3180: sin(17.4682617)
   0.3002689048497914100000000000f,   //  3181: sin(17.4737549)
   0.3003603531334135300000000000f,   //  3182: sin(17.4792480)
   0.3004517986561877100000000000f,   //  3183: sin(17.4847412)
   0.3005432414172734500000000000f,   //  3184: sin(17.4902344)
   0.3006346814158302200000000000f,   //  3185: sin(17.4957275)
   0.3007261186510175000000000000f,   //  3186: sin(17.5012207)
   0.3008175531219949300000000000f,   //  3187: sin(17.5067139)
   0.3009089848279218900000000000f,   //  3188: sin(17.5122070)
   0.3010004137679581100000000000f,   //  3189: sin(17.5177002)
   0.3010918399412631000000000000f,   //  3190: sin(17.5231934)
   0.3011832633469964700000000000f,   //  3191: sin(17.5286865)
   0.3012746839843179500000000000f,   //  3192: sin(17.5341797)
   0.3013661018523872100000000000f,   //  3193: sin(17.5396729)
   0.3014575169503639400000000000f,   //  3194: sin(17.5451660)
   0.3015489292774079000000000000f,   //  3195: sin(17.5506592)
   0.3016403388326787700000000000f,   //  3196: sin(17.5561523)
   0.3017317456153364400000000000f,   //  3197: sin(17.5616455)
   0.3018231496245406500000000000f,   //  3198: sin(17.5671387)
   0.3019145508594512400000000000f,   //  3199: sin(17.5726318)
   0.3020059493192280800000000000f,   //  3200: sin(17.5781250)
   0.3020973450030310400000000000f,   //  3201: sin(17.5836182)
   0.3021887379100199900000000000f,   //  3202: sin(17.5891113)
   0.3022801280393550000000000000f,   //  3203: sin(17.5946045)
   0.3023715153901959700000000000f,   //  3204: sin(17.6000977)
   0.3024628999617027800000000000f,   //  3205: sin(17.6055908)
   0.3025542817530356100000000000f,   //  3206: sin(17.6110840)
   0.3026456607633543600000000000f,   //  3207: sin(17.6165771)
   0.3027370369918191400000000000f,   //  3208: sin(17.6220703)
   0.3028284104375901200000000000f,   //  3209: sin(17.6275635)
   0.3029197810998273100000000000f,   //  3210: sin(17.6330566)
   0.3030111489776908800000000000f,   //  3211: sin(17.6385498)
   0.3031025140703410600000000000f,   //  3212: sin(17.6440430)
   0.3031938763769379000000000000f,   //  3213: sin(17.6495361)
   0.3032852358966417500000000000f,   //  3214: sin(17.6550293)
   0.3033765926286127700000000000f,   //  3215: sin(17.6605225)
   0.3034679465720113200000000000f,   //  3216: sin(17.6660156)
   0.3035592977259976000000000000f,   //  3217: sin(17.6715088)
   0.3036506460897319100000000000f,   //  3218: sin(17.6770020)
   0.3037419916623747000000000000f,   //  3219: sin(17.6824951)
   0.3038333344430863600000000000f,   //  3220: sin(17.6879883)
   0.3039246744310271600000000000f,   //  3221: sin(17.6934814)
   0.3040160116253575700000000000f,   //  3222: sin(17.6989746)
   0.3041073460252380900000000000f,   //  3223: sin(17.7044678)
   0.3041986776298291100000000000f,   //  3224: sin(17.7099609)
   0.3042900064382911800000000000f,   //  3225: sin(17.7154541)
   0.3043813324497848800000000000f,   //  3226: sin(17.7209473)
   0.3044726556634706500000000000f,   //  3227: sin(17.7264404)
   0.3045639760785091000000000000f,   //  3228: sin(17.7319336)
   0.3046552936940608600000000000f,   //  3229: sin(17.7374268)
   0.3047466085092865300000000000f,   //  3230: sin(17.7429199)
   0.3048379205233468500000000000f,   //  3231: sin(17.7484131)
   0.3049292297354023700000000000f,   //  3232: sin(17.7539063)
   0.3050205361446139400000000000f,   //  3233: sin(17.7593994)
   0.3051118397501421100000000000f,   //  3234: sin(17.7648926)
   0.3052031405511477200000000000f,   //  3235: sin(17.7703857)
   0.3052944385467916700000000000f,   //  3236: sin(17.7758789)
   0.3053857337362346200000000000f,   //  3237: sin(17.7813721)
   0.3054770261186374200000000000f,   //  3238: sin(17.7868652)
   0.3055683156931610100000000000f,   //  3239: sin(17.7923584)
   0.3056596024589661200000000000f,   //  3240: sin(17.7978516)
   0.3057508864152138600000000000f,   //  3241: sin(17.8033447)
   0.3058421675610650800000000000f,   //  3242: sin(17.8088379)
   0.3059334458956807200000000000f,   //  3243: sin(17.8143311)
   0.3060247214182217900000000000f,   //  3244: sin(17.8198242)
   0.3061159941278492900000000000f,   //  3245: sin(17.8253174)
   0.3062072640237242200000000000f,   //  3246: sin(17.8308105)
   0.3062985311050077700000000000f,   //  3247: sin(17.8363037)
   0.3063897953708609200000000000f,   //  3248: sin(17.8417969)
   0.3064810568204448500000000000f,   //  3249: sin(17.8472900)
   0.3065723154529207400000000000f,   //  3250: sin(17.8527832)
   0.3066635712674495900000000000f,   //  3251: sin(17.8582764)
   0.3067548242631927800000000000f,   //  3252: sin(17.8637695)
   0.3068460744393114400000000000f,   //  3253: sin(17.8692627)
   0.3069373217949669100000000000f,   //  3254: sin(17.8747559)
   0.3070285663293203500000000000f,   //  3255: sin(17.8802490)
   0.3071198080415331000000000000f,   //  3256: sin(17.8857422)
   0.3072110469307664000000000000f,   //  3257: sin(17.8912354)
   0.3073022829961817900000000000f,   //  3258: sin(17.8967285)
   0.3073935162369405600000000000f,   //  3259: sin(17.9022217)
   0.3074847466522041000000000000f,   //  3260: sin(17.9077148)
   0.3075759742411338100000000000f,   //  3261: sin(17.9132080)
   0.3076671990028911900000000000f,   //  3262: sin(17.9187012)
   0.3077584209366376900000000000f,   //  3263: sin(17.9241943)
   0.3078496400415348700000000000f,   //  3264: sin(17.9296875)
   0.3079408563167442300000000000f,   //  3265: sin(17.9351807)
   0.3080320697614273300000000000f,   //  3266: sin(17.9406738)
   0.3081232803747457900000000000f,   //  3267: sin(17.9461670)
   0.3082144881558610500000000000f,   //  3268: sin(17.9516602)
   0.3083056931039350200000000000f,   //  3269: sin(17.9571533)
   0.3083968952181291900000000000f,   //  3270: sin(17.9626465)
   0.3084880944976052800000000000f,   //  3271: sin(17.9681396)
   0.3085792909415250900000000000f,   //  3272: sin(17.9736328)
   0.3086704845490501600000000000f,   //  3273: sin(17.9791260)
   0.3087616753193424500000000000f,   //  3274: sin(17.9846191)
   0.3088528632515636900000000000f,   //  3275: sin(17.9901123)
   0.3089440483448757100000000000f,   //  3276: sin(17.9956055)
   0.3090352305984403500000000000f,   //  3277: sin(18.0010986)
   0.3091264100114194400000000000f,   //  3278: sin(18.0065918)
   0.3092175865829748800000000000f,   //  3279: sin(18.0120850)
   0.3093087603122687300000000000f,   //  3280: sin(18.0175781)
   0.3093999311984627600000000000f,   //  3281: sin(18.0230713)
   0.3094910992407191000000000000f,   //  3282: sin(18.0285645)
   0.3095822644381996400000000000f,   //  3283: sin(18.0340576)
   0.3096734267900663800000000000f,   //  3284: sin(18.0395508)
   0.3097645862954815400000000000f,   //  3285: sin(18.0450439)
   0.3098557429536070700000000000f,   //  3286: sin(18.0505371)
   0.3099468967636051500000000000f,   //  3287: sin(18.0560303)
   0.3100380477246378900000000000f,   //  3288: sin(18.0615234)
   0.3101291958358674000000000000f,   //  3289: sin(18.0670166)
   0.3102203410964558500000000000f,   //  3290: sin(18.0725098)
   0.3103114835055655900000000000f,   //  3291: sin(18.0780029)
   0.3104026230623587200000000000f,   //  3292: sin(18.0834961)
   0.3104937597659975800000000000f,   //  3293: sin(18.0889893)
   0.3105848936156444500000000000f,   //  3294: sin(18.0944824)
   0.3106760246104616200000000000f,   //  3295: sin(18.0999756)
   0.3107671527496114700000000000f,   //  3296: sin(18.1054688)
   0.3108582780322563500000000000f,   //  3297: sin(18.1109619)
   0.3109494004575586400000000000f,   //  3298: sin(18.1164551)
   0.3110405200246808000000000000f,   //  3299: sin(18.1219482)
   0.3111316367327852700000000000f,   //  3300: sin(18.1274414)
   0.3112227505810344400000000000f,   //  3301: sin(18.1329346)
   0.3113138615685909200000000000f,   //  3302: sin(18.1384277)
   0.3114049696946172300000000000f,   //  3303: sin(18.1439209)
   0.3114960749582759100000000000f,   //  3304: sin(18.1494141)
   0.3115871773587294800000000000f,   //  3305: sin(18.1549072)
   0.3116782768951405500000000000f,   //  3306: sin(18.1604004)
   0.3117693735666718400000000000f,   //  3307: sin(18.1658936)
   0.3118604673724860200000000000f,   //  3308: sin(18.1713867)
   0.3119515583117456500000000000f,   //  3309: sin(18.1768799)
   0.3120426463836135100000000000f,   //  3310: sin(18.1823730)
   0.3121337315872523800000000000f,   //  3311: sin(18.1878662)
   0.3122248139218248800000000000f,   //  3312: sin(18.1933594)
   0.3123158933864940100000000000f,   //  3313: sin(18.1988525)
   0.3124069699804224400000000000f,   //  3314: sin(18.2043457)
   0.3124980437027730700000000000f,   //  3315: sin(18.2098389)
   0.3125891145527087100000000000f,   //  3316: sin(18.2153320)
   0.3126801825293922800000000000f,   //  3317: sin(18.2208252)
   0.3127712476319867700000000000f,   //  3318: sin(18.2263184)
   0.3128623098596551300000000000f,   //  3319: sin(18.2318115)
   0.3129533692115602000000000000f,   //  3320: sin(18.2373047)
   0.3130444256868651400000000000f,   //  3321: sin(18.2427979)
   0.3131354792847328400000000000f,   //  3322: sin(18.2482910)
   0.3132265300043264300000000000f,   //  3323: sin(18.2537842)
   0.3133175778448090100000000000f,   //  3324: sin(18.2592773)
   0.3134086228053436500000000000f,   //  3325: sin(18.2647705)
   0.3134996648850935100000000000f,   //  3326: sin(18.2702637)
   0.3135907040832217100000000000f,   //  3327: sin(18.2757568)
   0.3136817403988915200000000000f,   //  3328: sin(18.2812500)
   0.3137727738312659500000000000f,   //  3329: sin(18.2867432)
   0.3138638043795085000000000000f,   //  3330: sin(18.2922363)
   0.3139548320427823500000000000f,   //  3331: sin(18.2977295)
   0.3140458568202507100000000000f,   //  3332: sin(18.3032227)
   0.3141368787110769800000000000f,   //  3333: sin(18.3087158)
   0.3142278977144244400000000000f,   //  3334: sin(18.3142090)
   0.3143189138294565400000000000f,   //  3335: sin(18.3197021)
   0.3144099270553366600000000000f,   //  3336: sin(18.3251953)
   0.3145009373912282000000000000f,   //  3337: sin(18.3306885)
   0.3145919448362946600000000000f,   //  3338: sin(18.3361816)
   0.3146829493896994300000000000f,   //  3339: sin(18.3416748)
   0.3147739510506060700000000000f,   //  3340: sin(18.3471680)
   0.3148649498181780900000000000f,   //  3341: sin(18.3526611)
   0.3149559456915791400000000000f,   //  3342: sin(18.3581543)
   0.3150469386699726900000000000f,   //  3343: sin(18.3636475)
   0.3151379287525224400000000000f,   //  3344: sin(18.3691406)
   0.3152289159383918600000000000f,   //  3345: sin(18.3746338)
   0.3153199002267448900000000000f,   //  3346: sin(18.3801270)
   0.3154108816167450200000000000f,   //  3347: sin(18.3856201)
   0.3155018601075559900000000000f,   //  3348: sin(18.3911133)
   0.3155928356983416200000000000f,   //  3349: sin(18.3966064)
   0.3156838083882656500000000000f,   //  3350: sin(18.4020996)
   0.3157747781764917400000000000f,   //  3351: sin(18.4075928)
   0.3158657450621839600000000000f,   //  3352: sin(18.4130859)
   0.3159567090445060700000000000f,   //  3353: sin(18.4185791)
   0.3160476701226218600000000000f,   //  3354: sin(18.4240723)
   0.3161386282956953300000000000f,   //  3355: sin(18.4295654)
   0.3162295835628903300000000000f,   //  3356: sin(18.4350586)
   0.3163205359233708900000000000f,   //  3357: sin(18.4405518)
   0.3164114853763009800000000000f,   //  3358: sin(18.4460449)
   0.3165024319208446500000000000f,   //  3359: sin(18.4515381)
   0.3165933755561658500000000000f,   //  3360: sin(18.4570313)
   0.3166843162814287300000000000f,   //  3361: sin(18.4625244)
   0.3167752540957972700000000000f,   //  3362: sin(18.4680176)
   0.3168661889984357200000000000f,   //  3363: sin(18.4735107)
   0.3169571209885081500000000000f,   //  3364: sin(18.4790039)
   0.3170480500651787800000000000f,   //  3365: sin(18.4844971)
   0.3171389762276117800000000000f,   //  3366: sin(18.4899902)
   0.3172298994749712700000000000f,   //  3367: sin(18.4954834)
   0.3173208198064217400000000000f,   //  3368: sin(18.5009766)
   0.3174117372211273100000000000f,   //  3369: sin(18.5064697)
   0.3175026517182522600000000000f,   //  3370: sin(18.5119629)
   0.3175935632969610300000000000f,   //  3371: sin(18.5174561)
   0.3176844719564179700000000000f,   //  3372: sin(18.5229492)
   0.3177753776957872900000000000f,   //  3373: sin(18.5284424)
   0.3178662805142336600000000000f,   //  3374: sin(18.5339355)
   0.3179571804109213600000000000f,   //  3375: sin(18.5394287)
   0.3180480773850149500000000000f,   //  3376: sin(18.5449219)
   0.3181389714356788200000000000f,   //  3377: sin(18.5504150)
   0.3182298625620775300000000000f,   //  3378: sin(18.5559082)
   0.3183207507633756800000000000f,   //  3379: sin(18.5614014)
   0.3184116360387377900000000000f,   //  3380: sin(18.5668945)
   0.3185025183873285100000000000f,   //  3381: sin(18.5723877)
   0.3185933978083124200000000000f,   //  3382: sin(18.5778809)
   0.3186842743008542200000000000f,   //  3383: sin(18.5833740)
   0.3187751478641184800000000000f,   //  3384: sin(18.5888672)
   0.3188660184972700900000000000f,   //  3385: sin(18.5943604)
   0.3189568861994736500000000000f,   //  3386: sin(18.5998535)
   0.3190477509698940200000000000f,   //  3387: sin(18.6053467)
   0.3191386128076959000000000000f,   //  3388: sin(18.6108398)
   0.3192294717120441300000000000f,   //  3389: sin(18.6163330)
   0.3193203276821036100000000000f,   //  3390: sin(18.6218262)
   0.3194111807170391100000000000f,   //  3391: sin(18.6273193)
   0.3195020308160156900000000000f,   //  3392: sin(18.6328125)
   0.3195928779781981300000000000f,   //  3393: sin(18.6383057)
   0.3196837222027514300000000000f,   //  3394: sin(18.6437988)
   0.3197745634888404800000000000f,   //  3395: sin(18.6492920)
   0.3198654018356305000000000000f,   //  3396: sin(18.6547852)
   0.3199562372422863300000000000f,   //  3397: sin(18.6602783)
   0.3200470697079731400000000000f,   //  3398: sin(18.6657715)
   0.3201378992318559800000000000f,   //  3399: sin(18.6712646)
   0.3202287258130998600000000000f,   //  3400: sin(18.6767578)
   0.3203195494508701000000000000f,   //  3401: sin(18.6822510)
   0.3204103701443318200000000000f,   //  3402: sin(18.6877441)
   0.3205011878926501400000000000f,   //  3403: sin(18.6932373)
   0.3205920026949903300000000000f,   //  3404: sin(18.6987305)
   0.3206828145505176700000000000f,   //  3405: sin(18.7042236)
   0.3207736234583973300000000000f,   //  3406: sin(18.7097168)
   0.3208644294177947500000000000f,   //  3407: sin(18.7152100)
   0.3209552324278752100000000000f,   //  3408: sin(18.7207031)
   0.3210460324878040600000000000f,   //  3409: sin(18.7261963)
   0.3211368295967466600000000000f,   //  3410: sin(18.7316895)
   0.3212276237538684300000000000f,   //  3411: sin(18.7371826)
   0.3213184149583348500000000000f,   //  3412: sin(18.7426758)
   0.3214092032093113800000000000f,   //  3413: sin(18.7481689)
   0.3214999885059635100000000000f,   //  3414: sin(18.7536621)
   0.3215907708474566900000000000f,   //  3415: sin(18.7591553)
   0.3216815502329565800000000000f,   //  3416: sin(18.7646484)
   0.3217723266616286400000000000f,   //  3417: sin(18.7701416)
   0.3218631001326385800000000000f,   //  3418: sin(18.7756348)
   0.3219538706451519600000000000f,   //  3419: sin(18.7811279)
   0.3220446381983345100000000000f,   //  3420: sin(18.7866211)
   0.3221354027913518300000000000f,   //  3421: sin(18.7921143)
   0.3222261644233696000000000000f,   //  3422: sin(18.7976074)
   0.3223169230935537000000000000f,   //  3423: sin(18.8031006)
   0.3224076788010698500000000000f,   //  3424: sin(18.8085938)
   0.3224984315450837900000000000f,   //  3425: sin(18.8140869)
   0.3225891813247613300000000000f,   //  3426: sin(18.8195801)
   0.3226799281392683800000000000f,   //  3427: sin(18.8250732)
   0.3227706719877707100000000000f,   //  3428: sin(18.8305664)
   0.3228614128694343700000000000f,   //  3429: sin(18.8360596)
   0.3229521507834252600000000000f,   //  3430: sin(18.8415527)
   0.3230428857289092100000000000f,   //  3431: sin(18.8470459)
   0.3231336177050523300000000000f,   //  3432: sin(18.8525391)
   0.3232243467110205700000000000f,   //  3433: sin(18.8580322)
   0.3233150727459799800000000000f,   //  3434: sin(18.8635254)
   0.3234057958090966700000000000f,   //  3435: sin(18.8690186)
   0.3234965158995367100000000000f,   //  3436: sin(18.8745117)
   0.3235872330164661400000000000f,   //  3437: sin(18.8800049)
   0.3236779471590512400000000000f,   //  3438: sin(18.8854980)
   0.3237686583264580100000000000f,   //  3439: sin(18.8909912)
   0.3238593665178528500000000000f,   //  3440: sin(18.8964844)
   0.3239500717324019200000000000f,   //  3441: sin(18.9019775)
   0.3240407739692714500000000000f,   //  3442: sin(18.9074707)
   0.3241314732276277000000000000f,   //  3443: sin(18.9129639)
   0.3242221695066369600000000000f,   //  3444: sin(18.9184570)
   0.3243128628054657300000000000f,   //  3445: sin(18.9239502)
   0.3244035531232802300000000000f,   //  3446: sin(18.9294434)
   0.3244942404592469100000000000f,   //  3447: sin(18.9349365)
   0.3245849248125321500000000000f,   //  3448: sin(18.9404297)
   0.3246756061823024600000000000f,   //  3449: sin(18.9459229)
   0.3247662845677242200000000000f,   //  3450: sin(18.9514160)
   0.3248569599679640400000000000f,   //  3451: sin(18.9569092)
   0.3249476323821884300000000000f,   //  3452: sin(18.9624023)
   0.3250383018095638900000000000f,   //  3453: sin(18.9678955)
   0.3251289682492570800000000000f,   //  3454: sin(18.9733887)
   0.3252196317004345000000000000f,   //  3455: sin(18.9788818)
   0.3253102921622629300000000000f,   //  3456: sin(18.9843750)
   0.3254009496339089200000000000f,   //  3457: sin(18.9898682)
   0.3254916041145393100000000000f,   //  3458: sin(18.9953613)
   0.3255822556033206600000000000f,   //  3459: sin(19.0008545)
   0.3256729040994198500000000000f,   //  3460: sin(19.0063477)
   0.3257635496020034900000000000f,   //  3461: sin(19.0118408)
   0.3258541921102385800000000000f,   //  3462: sin(19.0173340)
   0.3259448316232919100000000000f,   //  3463: sin(19.0228271)
   0.3260354681403302400000000000f,   //  3464: sin(19.0283203)
   0.3261261016605205800000000000f,   //  3465: sin(19.0338135)
   0.3262167321830297100000000000f,   //  3466: sin(19.0393066)
   0.3263073597070246800000000000f,   //  3467: sin(19.0447998)
   0.3263979842316724900000000000f,   //  3468: sin(19.0502930)
   0.3264886057561400300000000000f,   //  3469: sin(19.0557861)
   0.3265792242795944000000000000f,   //  3470: sin(19.0612793)
   0.3266698398012026200000000000f,   //  3471: sin(19.0667725)
   0.3267604523201317300000000000f,   //  3472: sin(19.0722656)
   0.3268510618355490200000000000f,   //  3473: sin(19.0777588)
   0.3269416683466214200000000000f,   //  3474: sin(19.0832520)
   0.3270322718525162100000000000f,   //  3475: sin(19.0887451)
   0.3271228723524005100000000000f,   //  3476: sin(19.0942383)
   0.3272134698454415300000000000f,   //  3477: sin(19.0997314)
   0.3273040643308066700000000000f,   //  3478: sin(19.1052246)
   0.3273946558076630300000000000f,   //  3479: sin(19.1107178)
   0.3274852442751780000000000000f,   //  3480: sin(19.1162109)
   0.3275758297325189200000000000f,   //  3481: sin(19.1217041)
   0.3276664121788531200000000000f,   //  3482: sin(19.1271973)
   0.3277569916133479300000000000f,   //  3483: sin(19.1326904)
   0.3278475680351708400000000000f,   //  3484: sin(19.1381836)
   0.3279381414434892600000000000f,   //  3485: sin(19.1436768)
   0.3280287118374706800000000000f,   //  3486: sin(19.1491699)
   0.3281192792162826400000000000f,   //  3487: sin(19.1546631)
   0.3282098435790925000000000000f,   //  3488: sin(19.1601563)
   0.3283004049250679600000000000f,   //  3489: sin(19.1656494)
   0.3283909632533765800000000000f,   //  3490: sin(19.1711426)
   0.3284815185631859700000000000f,   //  3491: sin(19.1766357)
   0.3285720708536637400000000000f,   //  3492: sin(19.1821289)
   0.3286626201239775100000000000f,   //  3493: sin(19.1876221)
   0.3287531663732949900000000000f,   //  3494: sin(19.1931152)
   0.3288437096007840200000000000f,   //  3495: sin(19.1986084)
   0.3289342498056122000000000000f,   //  3496: sin(19.2041016)
   0.3290247869869473200000000000f,   //  3497: sin(19.2095947)
   0.3291153211439572500000000000f,   //  3498: sin(19.2150879)
   0.3292058522758097800000000000f,   //  3499: sin(19.2205811)
   0.3292963803816727500000000000f,   //  3500: sin(19.2260742)
   0.3293869054607141400000000000f,   //  3501: sin(19.2315674)
   0.3294774275121017400000000000f,   //  3502: sin(19.2370605)
   0.3295679465350035400000000000f,   //  3503: sin(19.2425537)
   0.3296584625285874900000000000f,   //  3504: sin(19.2480469)
   0.3297489754920215900000000000f,   //  3505: sin(19.2535400)
   0.3298394854244739400000000000f,   //  3506: sin(19.2590332)
   0.3299299923251125000000000000f,   //  3507: sin(19.2645264)
   0.3300204961931054200000000000f,   //  3508: sin(19.2700195)
   0.3301109970276207600000000000f,   //  3509: sin(19.2755127)
   0.3302014948278265700000000000f,   //  3510: sin(19.2810059)
   0.3302919895928911900000000000f,   //  3511: sin(19.2864990)
   0.3303824813219827800000000000f,   //  3512: sin(19.2919922)
   0.3304729700142694500000000000f,   //  3513: sin(19.2974854)
   0.3305634556689195400000000000f,   //  3514: sin(19.3029785)
   0.3306539382851012600000000000f,   //  3515: sin(19.3084717)
   0.3307444178619828900000000000f,   //  3516: sin(19.3139648)
   0.3308348943987328700000000000f,   //  3517: sin(19.3194580)
   0.3309253678945195400000000000f,   //  3518: sin(19.3249512)
   0.3310158383485112300000000000f,   //  3519: sin(19.3304443)
   0.3311063057598764300000000000f,   //  3520: sin(19.3359375)
   0.3311967701277834200000000000f,   //  3521: sin(19.3414307)
   0.3312872314514008200000000000f,   //  3522: sin(19.3469238)
   0.3313776897298971700000000000f,   //  3523: sin(19.3524170)
   0.3314681449624408700000000000f,   //  3524: sin(19.3579102)
   0.3315585971482005200000000000f,   //  3525: sin(19.3634033)
   0.3316490462863446700000000000f,   //  3526: sin(19.3688965)
   0.3317394923760420000000000000f,   //  3527: sin(19.3743896)
   0.3318299354164611100000000000f,   //  3528: sin(19.3798828)
   0.3319203754067706600000000000f,   //  3529: sin(19.3853760)
   0.3320108123461393800000000000f,   //  3530: sin(19.3908691)
   0.3321012462337359900000000000f,   //  3531: sin(19.3963623)
   0.3321916770687291500000000000f,   //  3532: sin(19.4018555)
   0.3322821048502877500000000000f,   //  3533: sin(19.4073486)
   0.3323725295775806200000000000f,   //  3534: sin(19.4128418)
   0.3324629512497764800000000000f,   //  3535: sin(19.4183350)
   0.3325533698660442200000000000f,   //  3536: sin(19.4238281)
   0.3326437854255528400000000000f,   //  3537: sin(19.4293213)
   0.3327341979274710500000000000f,   //  3538: sin(19.4348145)
   0.3328246073709680300000000000f,   //  3539: sin(19.4403076)
   0.3329150137552126500000000000f,   //  3540: sin(19.4458008)
   0.3330054170793738700000000000f,   //  3541: sin(19.4512939)
   0.3330958173426207800000000000f,   //  3542: sin(19.4567871)
   0.3331862145441223900000000000f,   //  3543: sin(19.4622803)
   0.3332766086830479300000000000f,   //  3544: sin(19.4677734)
   0.3333669997585663200000000000f,   //  3545: sin(19.4732666)
   0.3334573877698468500000000000f,   //  3546: sin(19.4787598)
   0.3335477727160586200000000000f,   //  3547: sin(19.4842529)
   0.3336381545963708600000000000f,   //  3548: sin(19.4897461)
   0.3337285334099527300000000000f,   //  3549: sin(19.4952393)
   0.3338189091559736200000000000f,   //  3550: sin(19.5007324)
   0.3339092818336027400000000000f,   //  3551: sin(19.5062256)
   0.3339996514420093800000000000f,   //  3552: sin(19.5117188)
   0.3340900179803629700000000000f,   //  3553: sin(19.5172119)
   0.3341803814478326900000000000f,   //  3554: sin(19.5227051)
   0.3342707418435881800000000000f,   //  3555: sin(19.5281982)
   0.3343610991667987400000000000f,   //  3556: sin(19.5336914)
   0.3344514534166337900000000000f,   //  3557: sin(19.5391846)
   0.3345418045922629000000000000f,   //  3558: sin(19.5446777)
   0.3346321526928555700000000000f,   //  3559: sin(19.5501709)
   0.3347224977175812200000000000f,   //  3560: sin(19.5556641)
   0.3348128396656096000000000000f,   //  3561: sin(19.5611572)
   0.3349031785361101800000000000f,   //  3562: sin(19.5666504)
   0.3349935143282526400000000000f,   //  3563: sin(19.5721436)
   0.3350838470412065800000000000f,   //  3564: sin(19.5776367)
   0.3351741766741417300000000000f,   //  3565: sin(19.5831299)
   0.3352645032262278100000000000f,   //  3566: sin(19.5886230)
   0.3353548266966345200000000000f,   //  3567: sin(19.5941162)
   0.3354451470845316000000000000f,   //  3568: sin(19.5996094)
   0.3355354643890889300000000000f,   //  3569: sin(19.6051025)
   0.3356257786094762900000000000f,   //  3570: sin(19.6105957)
   0.3357160897448635000000000000f,   //  3571: sin(19.6160889)
   0.3358063977944204500000000000f,   //  3572: sin(19.6215820)
   0.3358967027573170900000000000f,   //  3573: sin(19.6270752)
   0.3359870046327233500000000000f,   //  3574: sin(19.6325684)
   0.3360773034198091800000000000f,   //  3575: sin(19.6380615)
   0.3361675991177445200000000000f,   //  3576: sin(19.6435547)
   0.3362578917256994800000000000f,   //  3577: sin(19.6490479)
   0.3363481812428440500000000000f,   //  3578: sin(19.6545410)
   0.3364384676683483400000000000f,   //  3579: sin(19.6600342)
   0.3365287510013824100000000000f,   //  3580: sin(19.6655273)
   0.3366190312411164700000000000f,   //  3581: sin(19.6710205)
   0.3367093083867205800000000000f,   //  3582: sin(19.6765137)
   0.3367995824373650700000000000f,   //  3583: sin(19.6820068)
   0.3368898533922200500000000000f,   //  3584: sin(19.6875000)
   0.3369801212504557900000000000f,   //  3585: sin(19.6929932)
   0.3370703860112426200000000000f,   //  3586: sin(19.6984863)
   0.3371606476737507600000000000f,   //  3587: sin(19.7039795)
   0.3372509062371505900000000000f,   //  3588: sin(19.7094727)
   0.3373411617006125100000000000f,   //  3589: sin(19.7149658)
   0.3374314140633068400000000000f,   //  3590: sin(19.7204590)
   0.3375216633244040900000000000f,   //  3591: sin(19.7259521)
   0.3376119094830746200000000000f,   //  3592: sin(19.7314453)
   0.3377021525384888400000000000f,   //  3593: sin(19.7369385)
   0.3377923924898174600000000000f,   //  3594: sin(19.7424316)
   0.3378826293362309200000000000f,   //  3595: sin(19.7479248)
   0.3379728630768997200000000000f,   //  3596: sin(19.7534180)
   0.3380630937109945800000000000f,   //  3597: sin(19.7589111)
   0.3381533212376859300000000000f,   //  3598: sin(19.7644043)
   0.3382435456561445600000000000f,   //  3599: sin(19.7698975)
   0.3383337669655411300000000000f,   //  3600: sin(19.7753906)
   0.3384239851650463500000000000f,   //  3601: sin(19.7808838)
   0.3385142002538309400000000000f,   //  3602: sin(19.7863770)
   0.3386044122310656300000000000f,   //  3603: sin(19.7918701)
   0.3386946210959211900000000000f,   //  3604: sin(19.7973633)
   0.3387848268475685500000000000f,   //  3605: sin(19.8028564)
   0.3388750294851784500000000000f,   //  3606: sin(19.8083496)
   0.3389652290079218600000000000f,   //  3607: sin(19.8138428)
   0.3390554254149696400000000000f,   //  3608: sin(19.8193359)
   0.3391456187054926500000000000f,   //  3609: sin(19.8248291)
   0.3392358088786619500000000000f,   //  3610: sin(19.8303223)
   0.3393259959336485400000000000f,   //  3611: sin(19.8358154)
   0.3394161798696233600000000000f,   //  3612: sin(19.8413086)
   0.3395063606857575100000000000f,   //  3613: sin(19.8468018)
   0.3395965383812221100000000000f,   //  3614: sin(19.8522949)
   0.3396867129551881000000000000f,   //  3615: sin(19.8577881)
   0.3397768844068268500000000000f,   //  3616: sin(19.8632813)
   0.3398670527353093700000000000f,   //  3617: sin(19.8687744)
   0.3399572179398068800000000000f,   //  3618: sin(19.8742676)
   0.3400473800194905900000000000f,   //  3619: sin(19.8797607)
   0.3401375389735317200000000000f,   //  3620: sin(19.8852539)
   0.3402276948011016500000000000f,   //  3621: sin(19.8907471)
   0.3403178475013716700000000000f,   //  3622: sin(19.8962402)
   0.3404079970735130500000000000f,   //  3623: sin(19.9017334)
   0.3404981435166971600000000000f,   //  3624: sin(19.9072266)
   0.3405882868300954500000000000f,   //  3625: sin(19.9127197)
   0.3406784270128792000000000000f,   //  3626: sin(19.9182129)
   0.3407685640642200700000000000f,   //  3627: sin(19.9237061)
   0.3408586979832894400000000000f,   //  3628: sin(19.9291992)
   0.3409488287692588000000000000f,   //  3629: sin(19.9346924)
   0.3410389564212997200000000000f,   //  3630: sin(19.9401855)
   0.3411290809385836300000000000f,   //  3631: sin(19.9456787)
   0.3412192023202823600000000000f,   //  3632: sin(19.9511719)
   0.3413093205655674000000000000f,   //  3633: sin(19.9566650)
   0.3413994356736104200000000000f,   //  3634: sin(19.9621582)
   0.3414895476435830800000000000f,   //  3635: sin(19.9676514)
   0.3415796564746571600000000000f,   //  3636: sin(19.9731445)
   0.3416697621660042500000000000f,   //  3637: sin(19.9786377)
   0.3417598647167963100000000000f,   //  3638: sin(19.9841309)
   0.3418499641262050000000000000f,   //  3639: sin(19.9896240)
   0.3419400603934021900000000000f,   //  3640: sin(19.9951172)
   0.3420301535175597800000000000f,   //  3641: sin(20.0006104)
   0.3421202434978495300000000000f,   //  3642: sin(20.0061035)
   0.3422103303334434500000000000f,   //  3643: sin(20.0115967)
   0.3423004140235135200000000000f,   //  3644: sin(20.0170898)
   0.3423904945672316400000000000f,   //  3645: sin(20.0225830)
   0.3424805719637698000000000000f,   //  3646: sin(20.0280762)
   0.3425706462123000500000000000f,   //  3647: sin(20.0335693)
   0.3426607173119943800000000000f,   //  3648: sin(20.0390625)
   0.3427507852620250200000000000f,   //  3649: sin(20.0445557)
   0.3428408500615639500000000000f,   //  3650: sin(20.0500488)
   0.3429309117097834000000000000f,   //  3651: sin(20.0555420)
   0.3430209702058555400000000000f,   //  3652: sin(20.0610352)
   0.3431110255489524500000000000f,   //  3653: sin(20.0665283)
   0.3432010777382465400000000000f,   //  3654: sin(20.0720215)
   0.3432911267729099600000000000f,   //  3655: sin(20.0775146)
   0.3433811726521150400000000000f,   //  3656: sin(20.0830078)
   0.3434712153750340600000000000f,   //  3657: sin(20.0885010)
   0.3435612549408393900000000000f,   //  3658: sin(20.0939941)
   0.3436512913487033700000000000f,   //  3659: sin(20.0994873)
   0.3437413245977984900000000000f,   //  3660: sin(20.1049805)
   0.3438313546872970900000000000f,   //  3661: sin(20.1104736)
   0.3439213816163717000000000000f,   //  3662: sin(20.1159668)
   0.3440114053841947800000000000f,   //  3663: sin(20.1214600)
   0.3441014259899388100000000000f,   //  3664: sin(20.1269531)
   0.3441914434327764100000000000f,   //  3665: sin(20.1324463)
   0.3442814577118801800000000000f,   //  3666: sin(20.1379395)
   0.3443714688264226700000000000f,   //  3667: sin(20.1434326)
   0.3444614767755765400000000000f,   //  3668: sin(20.1489258)
   0.3445514815585143900000000000f,   //  3669: sin(20.1544189)
   0.3446414831744089600000000000f,   //  3670: sin(20.1599121)
   0.3447314816224330600000000000f,   //  3671: sin(20.1654053)
   0.3448214769017592900000000000f,   //  3672: sin(20.1708984)
   0.3449114690115605600000000000f,   //  3673: sin(20.1763916)
   0.3450014579510096700000000000f,   //  3674: sin(20.1818848)
   0.3450914437192793000000000000f,   //  3675: sin(20.1873779)
   0.3451814263155425500000000000f,   //  3676: sin(20.1928711)
   0.3452714057389721900000000000f,   //  3677: sin(20.1983643)
   0.3453613819887412200000000000f,   //  3678: sin(20.2038574)
   0.3454513550640224700000000000f,   //  3679: sin(20.2093506)
   0.3455413249639890900000000000f,   //  3680: sin(20.2148438)
   0.3456312916878139200000000000f,   //  3681: sin(20.2203369)
   0.3457212552346701200000000000f,   //  3682: sin(20.2258301)
   0.3458112156037307900000000000f,   //  3683: sin(20.2313232)
   0.3459011727941689900000000000f,   //  3684: sin(20.2368164)
   0.3459911268051578100000000000f,   //  3685: sin(20.2423096)
   0.3460810776358704300000000000f,   //  3686: sin(20.2478027)
   0.3461710252854801100000000000f,   //  3687: sin(20.2532959)
   0.3462609697531600100000000000f,   //  3688: sin(20.2587891)
   0.3463509110380833500000000000f,   //  3689: sin(20.2642822)
   0.3464408491394235200000000000f,   //  3690: sin(20.2697754)
   0.3465307840563537400000000000f,   //  3691: sin(20.2752686)
   0.3466207157880473200000000000f,   //  3692: sin(20.2807617)
   0.3467106443336777100000000000f,   //  3693: sin(20.2862549)
   0.3468005696924182900000000000f,   //  3694: sin(20.2917480)
   0.3468904918634424500000000000f,   //  3695: sin(20.2972412)
   0.3469804108459236800000000000f,   //  3696: sin(20.3027344)
   0.3470703266390353600000000000f,   //  3697: sin(20.3082275)
   0.3471602392419511600000000000f,   //  3698: sin(20.3137207)
   0.3472501486538445700000000000f,   //  3699: sin(20.3192139)
   0.3473400548738891400000000000f,   //  3700: sin(20.3247070)
   0.3474299579012584100000000000f,   //  3701: sin(20.3302002)
   0.3475198577351261100000000000f,   //  3702: sin(20.3356934)
   0.3476097543746658500000000000f,   //  3703: sin(20.3411865)
   0.3476996478190513800000000000f,   //  3704: sin(20.3466797)
   0.3477895380674563300000000000f,   //  3705: sin(20.3521729)
   0.3478794251190545100000000000f,   //  3706: sin(20.3576660)
   0.3479693089730197000000000000f,   //  3707: sin(20.3631592)
   0.3480591896285256100000000000f,   //  3708: sin(20.3686523)
   0.3481490670847461900000000000f,   //  3709: sin(20.3741455)
   0.3482389413408552600000000000f,   //  3710: sin(20.3796387)
   0.3483288123960267500000000000f,   //  3711: sin(20.3851318)
   0.3484186802494345600000000000f,   //  3712: sin(20.3906250)
   0.3485085449002526300000000000f,   //  3713: sin(20.3961182)
   0.3485984063476549300000000000f,   //  3714: sin(20.4016113)
   0.3486882645908155300000000000f,   //  3715: sin(20.4071045)
   0.3487781196289084200000000000f,   //  3716: sin(20.4125977)
   0.3488679714611077100000000000f,   //  3717: sin(20.4180908)
   0.3489578200865874900000000000f,   //  3718: sin(20.4235840)
   0.3490476655045218200000000000f,   //  3719: sin(20.4290771)
   0.3491375077140849700000000000f,   //  3720: sin(20.4345703)
   0.3492273467144510500000000000f,   //  3721: sin(20.4400635)
   0.3493171825047943800000000000f,   //  3722: sin(20.4455566)
   0.3494070150842891200000000000f,   //  3723: sin(20.4510498)
   0.3494968444521095500000000000f,   //  3724: sin(20.4565430)
   0.3495866706074299300000000000f,   //  3725: sin(20.4620361)
   0.3496764935494247600000000000f,   //  3726: sin(20.4675293)
   0.3497663132772682600000000000f,   //  3727: sin(20.4730225)
   0.3498561297901349200000000000f,   //  3728: sin(20.4785156)
   0.3499459430871991200000000000f,   //  3729: sin(20.4840088)
   0.3500357531676352400000000000f,   //  3730: sin(20.4895020)
   0.3501255600306179000000000000f,   //  3731: sin(20.4949951)
   0.3502153636753215800000000000f,   //  3732: sin(20.5004883)
   0.3503051641009208300000000000f,   //  3733: sin(20.5059814)
   0.3503949613065901500000000000f,   //  3734: sin(20.5114746)
   0.3504847552915041900000000000f,   //  3735: sin(20.5169678)
   0.3505745460548375100000000000f,   //  3736: sin(20.5224609)
   0.3506643335957649300000000000f,   //  3737: sin(20.5279541)
   0.3507541179134610600000000000f,   //  3738: sin(20.5334473)
   0.3508438990071006100000000000f,   //  3739: sin(20.5389404)
   0.3509336768758583600000000000f,   //  3740: sin(20.5444336)
   0.3510234515189090100000000000f,   //  3741: sin(20.5499268)
   0.3511132229354274600000000000f,   //  3742: sin(20.5554199)
   0.3512029911245885300000000000f,   //  3743: sin(20.5609131)
   0.3512927560855670900000000000f,   //  3744: sin(20.5664063)
   0.3513825178175380400000000000f,   //  3745: sin(20.5718994)
   0.3514722763196763100000000000f,   //  3746: sin(20.5773926)
   0.3515620315911567900000000000f,   //  3747: sin(20.5828857)
   0.3516517836311545700000000000f,   //  3748: sin(20.5883789)
   0.3517415324388446500000000000f,   //  3749: sin(20.5938721)
   0.3518312780134020300000000000f,   //  3750: sin(20.5993652)
   0.3519210203540018600000000000f,   //  3751: sin(20.6048584)
   0.3520107594598190800000000000f,   //  3752: sin(20.6103516)
   0.3521004953300290700000000000f,   //  3753: sin(20.6158447)
   0.3521902279638068300000000000f,   //  3754: sin(20.6213379)
   0.3522799573603276300000000000f,   //  3755: sin(20.6268311)
   0.3523696835187666300000000000f,   //  3756: sin(20.6323242)
   0.3524594064382992100000000000f,   //  3757: sin(20.6378174)
   0.3525491261181004600000000000f,   //  3758: sin(20.6433105)
   0.3526388425573458400000000000f,   //  3759: sin(20.6488037)
   0.3527285557552107300000000000f,   //  3760: sin(20.6542969)
   0.3528182657108703800000000000f,   //  3761: sin(20.6597900)
   0.3529079724235002500000000000f,   //  3762: sin(20.6652832)
   0.3529976758922757600000000000f,   //  3763: sin(20.6707764)
   0.3530873761163724800000000000f,   //  3764: sin(20.6762695)
   0.3531770730949657700000000000f,   //  3765: sin(20.6817627)
   0.3532667668272312400000000000f,   //  3766: sin(20.6872559)
   0.3533564573123443900000000000f,   //  3767: sin(20.6927490)
   0.3534461445494808100000000000f,   //  3768: sin(20.6982422)
   0.3535358285378160700000000000f,   //  3769: sin(20.7037354)
   0.3536255092765259700000000000f,   //  3770: sin(20.7092285)
   0.3537151867647860300000000000f,   //  3771: sin(20.7147217)
   0.3538048610017720500000000000f,   //  3772: sin(20.7202148)
   0.3538945319866597100000000000f,   //  3773: sin(20.7257080)
   0.3539841997186247700000000000f,   //  3774: sin(20.7312012)
   0.3540738641968430600000000000f,   //  3775: sin(20.7366943)
   0.3541635254204903400000000000f,   //  3776: sin(20.7421875)
   0.3542531833887425700000000000f,   //  3777: sin(20.7476807)
   0.3543428381007755500000000000f,   //  3778: sin(20.7531738)
   0.3544324895557652300000000000f,   //  3779: sin(20.7586670)
   0.3545221377528874300000000000f,   //  3780: sin(20.7641602)
   0.3546117826913183200000000000f,   //  3781: sin(20.7696533)
   0.3547014243702338300000000000f,   //  3782: sin(20.7751465)
   0.3547910627888099500000000000f,   //  3783: sin(20.7806396)
   0.3548806979462227900000000000f,   //  3784: sin(20.7861328)
   0.3549703298416483400000000000f,   //  3785: sin(20.7916260)
   0.3550599584742628600000000000f,   //  3786: sin(20.7971191)
   0.3551495838432424700000000000f,   //  3787: sin(20.8026123)
   0.3552392059477633100000000000f,   //  3788: sin(20.8081055)
   0.3553288247870016200000000000f,   //  3789: sin(20.8135986)
   0.3554184403601336500000000000f,   //  3790: sin(20.8190918)
   0.3555080526663356200000000000f,   //  3791: sin(20.8245850)
   0.3555976617047838500000000000f,   //  3792: sin(20.8300781)
   0.3556872674746547300000000000f,   //  3793: sin(20.8355713)
   0.3557768699751246400000000000f,   //  3794: sin(20.8410645)
   0.3558664692053698500000000000f,   //  3795: sin(20.8465576)
   0.3559560651645668500000000000f,   //  3796: sin(20.8520508)
   0.3560456578518921300000000000f,   //  3797: sin(20.8575439)
   0.3561352472665221300000000000f,   //  3798: sin(20.8630371)
   0.3562248334076333300000000000f,   //  3799: sin(20.8685303)
   0.3563144162744024100000000000f,   //  3800: sin(20.8740234)
   0.3564039958660058000000000000f,   //  3801: sin(20.8795166)
   0.3564935721816200900000000000f,   //  3802: sin(20.8850098)
   0.3565831452204220600000000000f,   //  3803: sin(20.8905029)
   0.3566727149815882600000000000f,   //  3804: sin(20.8959961)
   0.3567622814642954500000000000f,   //  3805: sin(20.9014893)
   0.3568518446677203000000000000f,   //  3806: sin(20.9069824)
   0.3569414045910395100000000000f,   //  3807: sin(20.9124756)
   0.3570309612334299800000000000f,   //  3808: sin(20.9179688)
   0.3571205145940685200000000000f,   //  3809: sin(20.9234619)
   0.3572100646721319600000000000f,   //  3810: sin(20.9289551)
   0.3572996114667971200000000000f,   //  3811: sin(20.9344482)
   0.3573891549772409400000000000f,   //  3812: sin(20.9399414)
   0.3574786952026403100000000000f,   //  3813: sin(20.9454346)
   0.3575682321421722600000000000f,   //  3814: sin(20.9509277)
   0.3576577657950137900000000000f,   //  3815: sin(20.9564209)
   0.3577472961603419000000000000f,   //  3816: sin(20.9619141)
   0.3578368232373336200000000000f,   //  3817: sin(20.9674072)
   0.3579263470251660100000000000f,   //  3818: sin(20.9729004)
   0.3580158675230163400000000000f,   //  3819: sin(20.9783936)
   0.3581053847300615900000000000f,   //  3820: sin(20.9838867)
   0.3581948986454790400000000000f,   //  3821: sin(20.9893799)
   0.3582844092684458500000000000f,   //  3822: sin(20.9948730)
   0.3583739165981392700000000000f,   //  3823: sin(21.0003662)
   0.3584634206337365400000000000f,   //  3824: sin(21.0058594)
   0.3585529213744150200000000000f,   //  3825: sin(21.0113525)
   0.3586424188193519900000000000f,   //  3826: sin(21.0168457)
   0.3587319129677247800000000000f,   //  3827: sin(21.0223389)
   0.3588214038187108600000000000f,   //  3828: sin(21.0278320)
   0.3589108913714875700000000000f,   //  3829: sin(21.0333252)
   0.3590003756252324600000000000f,   //  3830: sin(21.0388184)
   0.3590898565791229000000000000f,   //  3831: sin(21.0443115)
   0.3591793342323365000000000000f,   //  3832: sin(21.0498047)
   0.3592688085840506900000000000f,   //  3833: sin(21.0552979)
   0.3593582796334431300000000000f,   //  3834: sin(21.0607910)
   0.3594477473796913700000000000f,   //  3835: sin(21.0662842)
   0.3595372118219730700000000000f,   //  3836: sin(21.0717773)
   0.3596266729594659300000000000f,   //  3837: sin(21.0772705)
   0.3597161307913475700000000000f,   //  3838: sin(21.0827637)
   0.3598055853167956800000000000f,   //  3839: sin(21.0882568)
   0.3598950365349881100000000000f,   //  3840: sin(21.0937500)
   0.3599844844451026100000000000f,   //  3841: sin(21.0992432)
   0.3600739290463170200000000000f,   //  3842: sin(21.1047363)
   0.3601633703378091500000000000f,   //  3843: sin(21.1102295)
   0.3602528083187568900000000000f,   //  3844: sin(21.1157227)
   0.3603422429883381100000000000f,   //  3845: sin(21.1212158)
   0.3604316743457307000000000000f,   //  3846: sin(21.1267090)
   0.3605211023901128100000000000f,   //  3847: sin(21.1322021)
   0.3606105271206622700000000000f,   //  3848: sin(21.1376953)
   0.3606999485365571800000000000f,   //  3849: sin(21.1431885)
   0.3607893666369755800000000000f,   //  3850: sin(21.1486816)
   0.3608787814210955800000000000f,   //  3851: sin(21.1541748)
   0.3609681928880952300000000000f,   //  3852: sin(21.1596680)
   0.3610576010371527300000000000f,   //  3853: sin(21.1651611)
   0.3611470058674462500000000000f,   //  3854: sin(21.1706543)
   0.3612364073781540500000000000f,   //  3855: sin(21.1761475)
   0.3613258055684542800000000000f,   //  3856: sin(21.1816406)
   0.3614152004375252300000000000f,   //  3857: sin(21.1871338)
   0.3615045919845452600000000000f,   //  3858: sin(21.1926270)
   0.3615939802086927100000000000f,   //  3859: sin(21.1981201)
   0.3616833651091458400000000000f,   //  3860: sin(21.2036133)
   0.3617727466850831400000000000f,   //  3861: sin(21.2091064)
   0.3618621249356829800000000000f,   //  3862: sin(21.2145996)
   0.3619514998601238200000000000f,   //  3863: sin(21.2200928)
   0.3620408714575841800000000000f,   //  3864: sin(21.2255859)
   0.3621302397272425600000000000f,   //  3865: sin(21.2310791)
   0.3622196046682774600000000000f,   //  3866: sin(21.2365723)
   0.3623089662798675800000000000f,   //  3867: sin(21.2420654)
   0.3623983245611913100000000000f,   //  3868: sin(21.2475586)
   0.3624876795114275200000000000f,   //  3869: sin(21.2530518)
   0.3625770311297547600000000000f,   //  3870: sin(21.2585449)
   0.3626663794153517400000000000f,   //  3871: sin(21.2640381)
   0.3627557243673972300000000000f,   //  3872: sin(21.2695313)
   0.3628450659850699400000000000f,   //  3873: sin(21.2750244)
   0.3629344042675486400000000000f,   //  3874: sin(21.2805176)
   0.3630237392140122100000000000f,   //  3875: sin(21.2860107)
   0.3631130708236394700000000000f,   //  3876: sin(21.2915039)
   0.3632023990956093600000000000f,   //  3877: sin(21.2969971)
   0.3632917240291007600000000000f,   //  3878: sin(21.3024902)
   0.3633810456232925400000000000f,   //  3879: sin(21.3079834)
   0.3634703638773637600000000000f,   //  3880: sin(21.3134766)
   0.3635596787904934500000000000f,   //  3881: sin(21.3189697)
   0.3636489903618605500000000000f,   //  3882: sin(21.3244629)
   0.3637382985906442200000000000f,   //  3883: sin(21.3299561)
   0.3638276034760235000000000000f,   //  3884: sin(21.3354492)
   0.3639169050171774900000000000f,   //  3885: sin(21.3409424)
   0.3640062032132854700000000000f,   //  3886: sin(21.3464355)
   0.3640954980635265300000000000f,   //  3887: sin(21.3519287)
   0.3641847895670798900000000000f,   //  3888: sin(21.3574219)
   0.3642740777231248700000000000f,   //  3889: sin(21.3629150)
   0.3643633625308406200000000000f,   //  3890: sin(21.3684082)
   0.3644526439894066300000000000f,   //  3891: sin(21.3739014)
   0.3645419220980021200000000000f,   //  3892: sin(21.3793945)
   0.3646311968558065800000000000f,   //  3893: sin(21.3848877)
   0.3647204682619992800000000000f,   //  3894: sin(21.3903809)
   0.3648097363157596900000000000f,   //  3895: sin(21.3958740)
   0.3648990010162673200000000000f,   //  3896: sin(21.4013672)
   0.3649882623627016500000000000f,   //  3897: sin(21.4068604)
   0.3650775203542421800000000000f,   //  3898: sin(21.4123535)
   0.3651667749900685500000000000f,   //  3899: sin(21.4178467)
   0.3652560262693603200000000000f,   //  3900: sin(21.4233398)
   0.3653452741912969800000000000f,   //  3901: sin(21.4288330)
   0.3654345187550583900000000000f,   //  3902: sin(21.4343262)
   0.3655237599598241100000000000f,   //  3903: sin(21.4398193)
   0.3656129978047738500000000000f,   //  3904: sin(21.4453125)
   0.3657022322890874400000000000f,   //  3905: sin(21.4508057)
   0.3657914634119445700000000000f,   //  3906: sin(21.4562988)
   0.3658806911725250300000000000f,   //  3907: sin(21.4617920)
   0.3659699155700087400000000000f,   //  3908: sin(21.4672852)
   0.3660591366035755900000000000f,   //  3909: sin(21.4727783)
   0.3661483542724053300000000000f,   //  3910: sin(21.4782715)
   0.3662375685756780700000000000f,   //  3911: sin(21.4837646)
   0.3663267795125735900000000000f,   //  3912: sin(21.4892578)
   0.3664159870822720200000000000f,   //  3913: sin(21.4947510)
   0.3665051912839533700000000000f,   //  3914: sin(21.5002441)
   0.3665943921167976200000000000f,   //  3915: sin(21.5057373)
   0.3666835895799849300000000000f,   //  3916: sin(21.5112305)
   0.3667727836726953900000000000f,   //  3917: sin(21.5167236)
   0.3668619743941090600000000000f,   //  3918: sin(21.5222168)
   0.3669511617434063100000000000f,   //  3919: sin(21.5277100)
   0.3670403457197671800000000000f,   //  3920: sin(21.5332031)
   0.3671295263223720000000000000f,   //  3921: sin(21.5386963)
   0.3672187035504009800000000000f,   //  3922: sin(21.5441895)
   0.3673078774030343900000000000f,   //  3923: sin(21.5496826)
   0.3673970478794527100000000000f,   //  3924: sin(21.5551758)
   0.3674862149788362100000000000f,   //  3925: sin(21.5606689)
   0.3675753787003653300000000000f,   //  3926: sin(21.5661621)
   0.3676645390432203800000000000f,   //  3927: sin(21.5716553)
   0.3677536960065819800000000000f,   //  3928: sin(21.5771484)
   0.3678428495896304300000000000f,   //  3929: sin(21.5826416)
   0.3679319997915464500000000000f,   //  3930: sin(21.5881348)
   0.3680211466115104200000000000f,   //  3931: sin(21.5936279)
   0.3681102900487030500000000000f,   //  3932: sin(21.5991211)
   0.3681994301023049400000000000f,   //  3933: sin(21.6046143)
   0.3682885667714965700000000000f,   //  3934: sin(21.6101074)
   0.3683777000554588300000000000f,   //  3935: sin(21.6156006)
   0.3684668299533723200000000000f,   //  3936: sin(21.6210938)
   0.3685559564644178000000000000f,   //  3937: sin(21.6265869)
   0.3686450795877760400000000000f,   //  3938: sin(21.6320801)
   0.3687341993226278000000000000f,   //  3939: sin(21.6375732)
   0.3688233156681539100000000000f,   //  3940: sin(21.6430664)
   0.3689124286235352900000000000f,   //  3941: sin(21.6485596)
   0.3690015381879527800000000000f,   //  3942: sin(21.6540527)
   0.3690906443605874200000000000f,   //  3943: sin(21.6595459)
   0.3691797471406200200000000000f,   //  3944: sin(21.6650391)
   0.3692688465272315200000000000f,   //  3945: sin(21.6705322)
   0.3693579425196031300000000000f,   //  3946: sin(21.6760254)
   0.3694470351169158500000000000f,   //  3947: sin(21.6815186)
   0.3695361243183506500000000000f,   //  3948: sin(21.6870117)
   0.3696252101230887400000000000f,   //  3949: sin(21.6925049)
   0.3697142925303112400000000000f,   //  3950: sin(21.6979980)
   0.3698033715391992300000000000f,   //  3951: sin(21.7034912)
   0.3698924471489341000000000000f,   //  3952: sin(21.7089844)
   0.3699815193586969400000000000f,   //  3953: sin(21.7144775)
   0.3700705881676690800000000000f,   //  3954: sin(21.7199707)
   0.3701596535750317800000000000f,   //  3955: sin(21.7254639)
   0.3702487155799663600000000000f,   //  3956: sin(21.7309570)
   0.3703377741816542600000000000f,   //  3957: sin(21.7364502)
   0.3704268293792767900000000000f,   //  3958: sin(21.7419434)
   0.3705158811720154500000000000f,   //  3959: sin(21.7474365)
   0.3706049295590516700000000000f,   //  3960: sin(21.7529297)
   0.3706939745395668700000000000f,   //  3961: sin(21.7584229)
   0.3707830161127425600000000000f,   //  3962: sin(21.7639160)
   0.3708720542777604300000000000f,   //  3963: sin(21.7694092)
   0.3709610890338019800000000000f,   //  3964: sin(21.7749023)
   0.3710501203800488100000000000f,   //  3965: sin(21.7803955)
   0.3711391483156825700000000000f,   //  3966: sin(21.7858887)
   0.3712281728398848500000000000f,   //  3967: sin(21.7913818)
   0.3713171939518375400000000000f,   //  3968: sin(21.7968750)
   0.3714062116507222400000000000f,   //  3969: sin(21.8023682)
   0.3714952259357207600000000000f,   //  3970: sin(21.8078613)
   0.3715842368060149300000000000f,   //  3971: sin(21.8133545)
   0.3716732442607865200000000000f,   //  3972: sin(21.8188477)
   0.3717622482992173300000000000f,   //  3973: sin(21.8243408)
   0.3718512489204894900000000000f,   //  3974: sin(21.8298340)
   0.3719402461237846800000000000f,   //  3975: sin(21.8353271)
   0.3720292399082850100000000000f,   //  3976: sin(21.8408203)
   0.3721182302731724200000000000f,   //  3977: sin(21.8463135)
   0.3722072172176288400000000000f,   //  3978: sin(21.8518066)
   0.3722962007408364700000000000f,   //  3979: sin(21.8572998)
   0.3723851808419773600000000000f,   //  3980: sin(21.8627930)
   0.3724741575202335500000000000f,   //  3981: sin(21.8682861)
   0.3725631307747872500000000000f,   //  3982: sin(21.8737793)
   0.3726521006048205700000000000f,   //  3983: sin(21.8792725)
   0.3727410670095157600000000000f,   //  3984: sin(21.8847656)
   0.3728300299880550900000000000f,   //  3985: sin(21.8902588)
   0.3729189895396208300000000000f,   //  3986: sin(21.8957520)
   0.3730079456633952400000000000f,   //  3987: sin(21.9012451)
   0.3730968983585606400000000000f,   //  3988: sin(21.9067383)
   0.3731858476242994000000000000f,   //  3989: sin(21.9122314)
   0.3732747934597939700000000000f,   //  3990: sin(21.9177246)
   0.3733637358642268300000000000f,   //  3991: sin(21.9232178)
   0.3734526748367803000000000000f,   //  3992: sin(21.9287109)
   0.3735416103766369100000000000f,   //  3993: sin(21.9342041)
   0.3736305424829792800000000000f,   //  3994: sin(21.9396973)
   0.3737194711549898200000000000f,   //  3995: sin(21.9451904)
   0.3738083963918512100000000000f,   //  3996: sin(21.9506836)
   0.3738973181927460800000000000f,   //  3997: sin(21.9561768)
   0.3739862365568570300000000000f,   //  3998: sin(21.9616699)
   0.3740751514833667900000000000f,   //  3999: sin(21.9671631)
   0.3741640629714579300000000000f,   //  4000: sin(21.9726563)
   0.3742529710203134100000000000f,   //  4001: sin(21.9781494)
   0.3743418756291159200000000000f,   //  4002: sin(21.9836426)
   0.3744307767970482300000000000f,   //  4003: sin(21.9891357)
   0.3745196745232932100000000000f,   //  4004: sin(21.9946289)
   0.3746085688070336900000000000f,   //  4005: sin(22.0001221)
   0.3746974596474526000000000000f,   //  4006: sin(22.0056152)
   0.3747863470437329300000000000f,   //  4007: sin(22.0111084)
   0.3748752309950575400000000000f,   //  4008: sin(22.0166016)
   0.3749641115006095400000000000f,   //  4009: sin(22.0220947)
   0.3750529885595719200000000000f,   //  4010: sin(22.0275879)
   0.3751418621711276000000000000f,   //  4011: sin(22.0330811)
   0.3752307323344599200000000000f,   //  4012: sin(22.0385742)
   0.3753195990487518400000000000f,   //  4013: sin(22.0440674)
   0.3754084623131865900000000000f,   //  4014: sin(22.0495605)
   0.3754973221269473100000000000f,   //  4015: sin(22.0550537)
   0.3755861784892172200000000000f,   //  4016: sin(22.0605469)
   0.3756750313991795700000000000f,   //  4017: sin(22.0660400)
   0.3757638808560177000000000000f,   //  4018: sin(22.0715332)
   0.3758527268589148500000000000f,   //  4019: sin(22.0770264)
   0.3759415694070544200000000000f,   //  4020: sin(22.0825195)
   0.3760304084996198300000000000f,   //  4021: sin(22.0880127)
   0.3761192441357943400000000000f,   //  4022: sin(22.0935059)
   0.3762080763147615000000000000f,   //  4023: sin(22.0989990)
   0.3762969050357047900000000000f,   //  4024: sin(22.1044922)
   0.3763857302978077000000000000f,   //  4025: sin(22.1099854)
   0.3764745521002537700000000000f,   //  4026: sin(22.1154785)
   0.3765633704422265400000000000f,   //  4027: sin(22.1209717)
   0.3766521853229095600000000000f,   //  4028: sin(22.1264648)
   0.3767409967414865900000000000f,   //  4029: sin(22.1319580)
   0.3768298046971412800000000000f,   //  4030: sin(22.1374512)
   0.3769186091890572300000000000f,   //  4031: sin(22.1429443)
   0.3770074102164182600000000000f,   //  4032: sin(22.1484375)
   0.3770962077784080200000000000f,   //  4033: sin(22.1539307)
   0.3771850018742104500000000000f,   //  4034: sin(22.1594238)
   0.3772737925030092400000000000f,   //  4035: sin(22.1649170)
   0.3773625796639883400000000000f,   //  4036: sin(22.1704102)
   0.3774513633563316200000000000f,   //  4037: sin(22.1759033)
   0.3775401435792229400000000000f,   //  4038: sin(22.1813965)
   0.3776289203318462500000000000f,   //  4039: sin(22.1868896)
   0.3777176936133856400000000000f,   //  4040: sin(22.1923828)
   0.3778064634230250400000000000f,   //  4041: sin(22.1978760)
   0.3778952297599484900000000000f,   //  4042: sin(22.2033691)
   0.3779839926233401500000000000f,   //  4043: sin(22.2088623)
   0.3780727520123839900000000000f,   //  4044: sin(22.2143555)
   0.3781615079262643000000000000f,   //  4045: sin(22.2198486)
   0.3782502603641652000000000000f,   //  4046: sin(22.2253418)
   0.3783390093252708700000000000f,   //  4047: sin(22.2308350)
   0.3784277548087655600000000000f,   //  4048: sin(22.2363281)
   0.3785164968138335900000000000f,   //  4049: sin(22.2418213)
   0.3786052353396591200000000000f,   //  4050: sin(22.2473145)
   0.3786939703854266800000000000f,   //  4051: sin(22.2528076)
   0.3787827019503205400000000000f,   //  4052: sin(22.2583008)
   0.3788714300335250800000000000f,   //  4053: sin(22.2637939)
   0.3789601546342247200000000000f,   //  4054: sin(22.2692871)
   0.3790488757516039500000000000f,   //  4055: sin(22.2747803)
   0.3791375933848473200000000000f,   //  4056: sin(22.2802734)
   0.3792263075331393000000000000f,   //  4057: sin(22.2857666)
   0.3793150181956644300000000000f,   //  4058: sin(22.2912598)
   0.3794037253716073300000000000f,   //  4059: sin(22.2967529)
   0.3794924290601526300000000000f,   //  4060: sin(22.3022461)
   0.3795811292604848700000000000f,   //  4061: sin(22.3077393)
   0.3796698259717889400000000000f,   //  4062: sin(22.3132324)
   0.3797585191932494900000000000f,   //  4063: sin(22.3187256)
   0.3798472089240511600000000000f,   //  4064: sin(22.3242188)
   0.3799358951633788300000000000f,   //  4065: sin(22.3297119)
   0.3800245779104172700000000000f,   //  4066: sin(22.3352051)
   0.3801132571643514000000000000f,   //  4067: sin(22.3406982)
   0.3802019329243660500000000000f,   //  4068: sin(22.3461914)
   0.3802906051896461400000000000f,   //  4069: sin(22.3516846)
   0.3803792739593766000000000000f,   //  4070: sin(22.3571777)
   0.3804679392327424100000000000f,   //  4071: sin(22.3626709)
   0.3805566010089285200000000000f,   //  4072: sin(22.3681641)
   0.3806452592871200600000000000f,   //  4073: sin(22.3736572)
   0.3807339140665021400000000000f,   //  4074: sin(22.3791504)
   0.3808225653462597400000000000f,   //  4075: sin(22.3846436)
   0.3809112131255780700000000000f,   //  4076: sin(22.3901367)
   0.3809998574036422300000000000f,   //  4077: sin(22.3956299)
   0.3810884981796375200000000000f,   //  4078: sin(22.4011230)
   0.3811771354527491700000000000f,   //  4079: sin(22.4066162)
   0.3812657692221623800000000000f,   //  4080: sin(22.4121094)
   0.3813543994870624600000000000f,   //  4081: sin(22.4176025)
   0.3814430262466347300000000000f,   //  4082: sin(22.4230957)
   0.3815316495000645200000000000f,   //  4083: sin(22.4285889)
   0.3816202692465373600000000000f,   //  4084: sin(22.4340820)
   0.3817088854852385700000000000f,   //  4085: sin(22.4395752)
   0.3817974982153536400000000000f,   //  4086: sin(22.4450684)
   0.3818861074360679900000000000f,   //  4087: sin(22.4505615)
   0.3819747131465672200000000000f,   //  4088: sin(22.4560547)
   0.3820633153460368800000000000f,   //  4089: sin(22.4615479)
   0.3821519140336626100000000000f,   //  4090: sin(22.4670410)
   0.3822405092086299000000000000f,   //  4091: sin(22.4725342)
   0.3823291008701245100000000000f,   //  4092: sin(22.4780273)
   0.3824176890173320300000000000f,   //  4093: sin(22.4835205)
   0.3825062736494382300000000000f,   //  4094: sin(22.4890137)
   0.3825948547656288800000000000f,   //  4095: sin(22.4945068)
   0.3826834323650897800000000000f,   //  4096: sin(22.5000000)
   0.3827720064470066500000000000f,   //  4097: sin(22.5054932)
   0.3828605770105654200000000000f,   //  4098: sin(22.5109863)
   0.3829491440549519000000000000f,   //  4099: sin(22.5164795)
   0.3830377075793520200000000000f,   //  4100: sin(22.5219727)
   0.3831262675829518200000000000f,   //  4101: sin(22.5274658)
   0.3832148240649371800000000000f,   //  4102: sin(22.5329590)
   0.3833033770244940700000000000f,   //  4103: sin(22.5384521)
   0.3833919264608086600000000000f,   //  4104: sin(22.5439453)
   0.3834804723730668700000000000f,   //  4105: sin(22.5494385)
   0.3835690147604549100000000000f,   //  4106: sin(22.5549316)
   0.3836575536221589200000000000f,   //  4107: sin(22.5604248)
   0.3837460889573650100000000000f,   //  4108: sin(22.5659180)
   0.3838346207652594300000000000f,   //  4109: sin(22.5714111)
   0.3839231490450283900000000000f,   //  4110: sin(22.5769043)
   0.3840116737958581500000000000f,   //  4111: sin(22.5823975)
   0.3841001950169350400000000000f,   //  4112: sin(22.5878906)
   0.3841887127074453700000000000f,   //  4113: sin(22.5933838)
   0.3842772268665755100000000000f,   //  4114: sin(22.5988770)
   0.3843657374935118800000000000f,   //  4115: sin(22.6043701)
   0.3844542445874408200000000000f,   //  4116: sin(22.6098633)
   0.3845427481475489100000000000f,   //  4117: sin(22.6153564)
   0.3846312481730225800000000000f,   //  4118: sin(22.6208496)
   0.3847197446630484200000000000f,   //  4119: sin(22.6263428)
   0.3848082376168128800000000000f,   //  4120: sin(22.6318359)
   0.3848967270335025800000000000f,   //  4121: sin(22.6373291)
   0.3849852129123042000000000000f,   //  4122: sin(22.6428223)
   0.3850736952524044200000000000f,   //  4123: sin(22.6483154)
   0.3851621740529898600000000000f,   //  4124: sin(22.6538086)
   0.3852506493132472100000000000f,   //  4125: sin(22.6593018)
   0.3853391210323633400000000000f,   //  4126: sin(22.6647949)
   0.3854275892095249100000000000f,   //  4127: sin(22.6702881)
   0.3855160538439188500000000000f,   //  4128: sin(22.6757813)
   0.3856045149347319700000000000f,   //  4129: sin(22.6812744)
   0.3856929724811511400000000000f,   //  4130: sin(22.6867676)
   0.3857814264823632400000000000f,   //  4131: sin(22.6922607)
   0.3858698769375553100000000000f,   //  4132: sin(22.6977539)
   0.3859583238459142800000000000f,   //  4133: sin(22.7032471)
   0.3860467672066271700000000000f,   //  4134: sin(22.7087402)
   0.3861352070188810400000000000f,   //  4135: sin(22.7142334)
   0.3862236432818629800000000000f,   //  4136: sin(22.7197266)
   0.3863120759947600800000000000f,   //  4137: sin(22.7252197)
   0.3864005051567594400000000000f,   //  4138: sin(22.7307129)
   0.3864889307670483200000000000f,   //  4139: sin(22.7362061)
   0.3865773528248139200000000000f,   //  4140: sin(22.7416992)
   0.3866657713292434600000000000f,   //  4141: sin(22.7471924)
   0.3867541862795241800000000000f,   //  4142: sin(22.7526855)
   0.3868425976748434100000000000f,   //  4143: sin(22.7581787)
   0.3869310055143885800000000000f,   //  4144: sin(22.7636719)
   0.3870194097973469500000000000f,   //  4145: sin(22.7691650)
   0.3871078105229059900000000000f,   //  4146: sin(22.7746582)
   0.3871962076902531500000000000f,   //  4147: sin(22.7801514)
   0.3872846012985758400000000000f,   //  4148: sin(22.7856445)
   0.3873729913470614900000000000f,   //  4149: sin(22.7911377)
   0.3874613778348978700000000000f,   //  4150: sin(22.7966309)
   0.3875497607612724000000000000f,   //  4151: sin(22.8021240)
   0.3876381401253727300000000000f,   //  4152: sin(22.8076172)
   0.3877265159263864600000000000f,   //  4153: sin(22.8131104)
   0.3878148881635011800000000000f,   //  4154: sin(22.8186035)
   0.3879032568359047600000000000f,   //  4155: sin(22.8240967)
   0.3879916219427848600000000000f,   //  4156: sin(22.8295898)
   0.3880799834833292800000000000f,   //  4157: sin(22.8350830)
   0.3881683414567257400000000000f,   //  4158: sin(22.8405762)
   0.3882566958621621600000000000f,   //  4159: sin(22.8460693)
   0.3883450466988262500000000000f,   //  4160: sin(22.8515625)
   0.3884333939659060900000000000f,   //  4161: sin(22.8570557)
   0.3885217376625895700000000000f,   //  4162: sin(22.8625488)
   0.3886100777880646100000000000f,   //  4163: sin(22.8680420)
   0.3886984143415191900000000000f,   //  4164: sin(22.8735352)
   0.3887867473221413600000000000f,   //  4165: sin(22.8790283)
   0.3888750767291192500000000000f,   //  4166: sin(22.8845215)
   0.3889634025616408600000000000f,   //  4167: sin(22.8900146)
   0.3890517248188943800000000000f,   //  4168: sin(22.8955078)
   0.3891400435000679200000000000f,   //  4169: sin(22.9010010)
   0.3892283586043497300000000000f,   //  4170: sin(22.9064941)
   0.3893166701309279100000000000f,   //  4171: sin(22.9119873)
   0.3894049780789909400000000000f,   //  4172: sin(22.9174805)
   0.3894932824477269100000000000f,   //  4173: sin(22.9229736)
   0.3895815832363243000000000000f,   //  4174: sin(22.9284668)
   0.3896698804439713300000000000f,   //  4175: sin(22.9339600)
   0.3897581740698564100000000000f,   //  4176: sin(22.9394531)
   0.3898464641131680900000000000f,   //  4177: sin(22.9449463)
   0.3899347505730947300000000000f,   //  4178: sin(22.9504395)
   0.3900230334488248300000000000f,   //  4179: sin(22.9559326)
   0.3901113127395469100000000000f,   //  4180: sin(22.9614258)
   0.3901995884444495200000000000f,   //  4181: sin(22.9669189)
   0.3902878605627211900000000000f,   //  4182: sin(22.9724121)
   0.3903761290935506800000000000f,   //  4183: sin(22.9779053)
   0.3904643940361265900000000000f,   //  4184: sin(22.9833984)
   0.3905526553896376300000000000f,   //  4185: sin(22.9888916)
   0.3906409131532724300000000000f,   //  4186: sin(22.9943848)
   0.3907291673262197600000000000f,   //  4187: sin(22.9998779)
   0.3908174179076685000000000000f,   //  4188: sin(23.0053711)
   0.3909056648968074500000000000f,   //  4189: sin(23.0108643)
   0.3909939082928253800000000000f,   //  4190: sin(23.0163574)
   0.3910821480949112100000000000f,   //  4191: sin(23.0218506)
   0.3911703843022538700000000000f,   //  4192: sin(23.0273438)
   0.3912586169140422900000000000f,   //  4193: sin(23.0328369)
   0.3913468459294655600000000000f,   //  4194: sin(23.0383301)
   0.3914350713477125500000000000f,   //  4195: sin(23.0438232)
   0.3915232931679724100000000000f,   //  4196: sin(23.0493164)
   0.3916115113894341700000000000f,   //  4197: sin(23.0548096)
   0.3916997260112869400000000000f,   //  4198: sin(23.0603027)
   0.3917879370327199700000000000f,   //  4199: sin(23.0657959)
   0.3918761444529223500000000000f,   //  4200: sin(23.0712891)
   0.3919643482710832800000000000f,   //  4201: sin(23.0767822)
   0.3920525484863920900000000000f,   //  4202: sin(23.0822754)
   0.3921407450980379800000000000f,   //  4203: sin(23.0877686)
   0.3922289381052103100000000000f,   //  4204: sin(23.0932617)
   0.3923171275070984100000000000f,   //  4205: sin(23.0987549)
   0.3924053133028916900000000000f,   //  4206: sin(23.1042480)
   0.3924934954917795900000000000f,   //  4207: sin(23.1097412)
   0.3925816740729514700000000000f,   //  4208: sin(23.1152344)
   0.3926698490455968700000000000f,   //  4209: sin(23.1207275)
   0.3927580204089052800000000000f,   //  4210: sin(23.1262207)
   0.3928461881620662900000000000f,   //  4211: sin(23.1317139)
   0.3929343523042694900000000000f,   //  4212: sin(23.1372070)
   0.3930225128347044100000000000f,   //  4213: sin(23.1427002)
   0.3931106697525607600000000000f,   //  4214: sin(23.1481934)
   0.3931988230570281400000000000f,   //  4215: sin(23.1536865)
   0.3932869727472964000000000000f,   //  4216: sin(23.1591797)
   0.3933751188225552100000000000f,   //  4217: sin(23.1646729)
   0.3934632612819943300000000000f,   //  4218: sin(23.1701660)
   0.3935514001248036600000000000f,   //  4219: sin(23.1756592)
   0.3936395353501728800000000000f,   //  4220: sin(23.1811523)
   0.3937276669572920600000000000f,   //  4221: sin(23.1866455)
   0.3938157949453510200000000000f,   //  4222: sin(23.1921387)
   0.3939039193135396900000000000f,   //  4223: sin(23.1976318)
   0.3939920400610481000000000000f,   //  4224: sin(23.2031250)
   0.3940801571870662400000000000f,   //  4225: sin(23.2086182)
   0.3941682706907840800000000000f,   //  4226: sin(23.2141113)
   0.3942563805713919000000000000f,   //  4227: sin(23.2196045)
   0.3943444868280796000000000000f,   //  4228: sin(23.2250977)
   0.3944325894600374500000000000f,   //  4229: sin(23.2305908)
   0.3945206884664556000000000000f,   //  4230: sin(23.2360840)
   0.3946087838465242000000000000f,   //  4231: sin(23.2415771)
   0.3946968755994335600000000000f,   //  4232: sin(23.2470703)
   0.3947849637243739900000000000f,   //  4233: sin(23.2525635)
   0.3948730482205357600000000000f,   //  4234: sin(23.2580566)
   0.3949611290871092300000000000f,   //  4235: sin(23.2635498)
   0.3950492063232847700000000000f,   //  4236: sin(23.2690430)
   0.3951372799282527600000000000f,   //  4237: sin(23.2745361)
   0.3952253499012036700000000000f,   //  4238: sin(23.2800293)
   0.3953134162413280400000000000f,   //  4239: sin(23.2855225)
   0.3954014789478163500000000000f,   //  4240: sin(23.2910156)
   0.3954895380198590900000000000f,   //  4241: sin(23.2965088)
   0.3955775934566468400000000000f,   //  4242: sin(23.3020020)
   0.3956656452573703000000000000f,   //  4243: sin(23.3074951)
   0.3957536934212200800000000000f,   //  4244: sin(23.3129883)
   0.3958417379473868100000000000f,   //  4245: sin(23.3184814)
   0.3959297788350612500000000000f,   //  4246: sin(23.3239746)
   0.3960178160834341700000000000f,   //  4247: sin(23.3294678)
   0.3961058496916962700000000000f,   //  4248: sin(23.3349609)
   0.3961938796590384600000000000f,   //  4249: sin(23.3404541)
   0.3962819059846515200000000000f,   //  4250: sin(23.3459473)
   0.3963699286677263600000000000f,   //  4251: sin(23.3514404)
   0.3964579477074539100000000000f,   //  4252: sin(23.3569336)
   0.3965459631030250300000000000f,   //  4253: sin(23.3624268)
   0.3966339748536308300000000000f,   //  4254: sin(23.3679199)
   0.3967219829584622300000000000f,   //  4255: sin(23.3734131)
   0.3968099874167103100000000000f,   //  4256: sin(23.3789063)
   0.3968979882275661700000000000f,   //  4257: sin(23.3843994)
   0.3969859853902209000000000000f,   //  4258: sin(23.3898926)
   0.3970739789038656400000000000f,   //  4259: sin(23.3953857)
   0.3971619687676916100000000000f,   //  4260: sin(23.4008789)
   0.3972499549808900000000000000f,   //  4261: sin(23.4063721)
   0.3973379375426520600000000000f,   //  4262: sin(23.4118652)
   0.3974259164521690700000000000f,   //  4263: sin(23.4173584)
   0.3975138917086323300000000000f,   //  4264: sin(23.4228516)
   0.3976018633112332100000000000f,   //  4265: sin(23.4283447)
   0.3976898312591631800000000000f,   //  4266: sin(23.4338379)
   0.3977777955516135200000000000f,   //  4267: sin(23.4393311)
   0.3978657561877757500000000000f,   //  4268: sin(23.4448242)
   0.3979537131668413600000000000f,   //  4269: sin(23.4503174)
   0.3980416664880017700000000000f,   //  4270: sin(23.4558105)
   0.3981296161504486700000000000f,   //  4271: sin(23.4613037)
   0.3982175621533735600000000000f,   //  4272: sin(23.4667969)
   0.3983055044959681300000000000f,   //  4273: sin(23.4722900)
   0.3983934431774239800000000000f,   //  4274: sin(23.4777832)
   0.3984813781969327500000000000f,   //  4275: sin(23.4832764)
   0.3985693095536863000000000000f,   //  4276: sin(23.4887695)
   0.3986572372468762400000000000f,   //  4277: sin(23.4942627)
   0.3987451612756944300000000000f,   //  4278: sin(23.4997559)
   0.3988330816393327300000000000f,   //  4279: sin(23.5052490)
   0.3989209983369829100000000000f,   //  4280: sin(23.5107422)
   0.3990089113678368400000000000f,   //  4281: sin(23.5162354)
   0.3990968207310865400000000000f,   //  4282: sin(23.5217285)
   0.3991847264259239000000000000f,   //  4283: sin(23.5272217)
   0.3992726284515409900000000000f,   //  4284: sin(23.5327148)
   0.3993605268071296900000000000f,   //  4285: sin(23.5382080)
   0.3994484214918821400000000000f,   //  4286: sin(23.5437012)
   0.3995363125049905000000000000f,   //  4287: sin(23.5491943)
   0.3996241998456467900000000000f,   //  4288: sin(23.5546875)
   0.3997120835130432100000000000f,   //  4289: sin(23.5601807)
   0.3997999635063719800000000000f,   //  4290: sin(23.5656738)
   0.3998878398248252900000000000f,   //  4291: sin(23.5711670)
   0.3999757124675953300000000000f,   //  4292: sin(23.5766602)
   0.4000635814338744900000000000f,   //  4293: sin(23.5821533)
   0.4001514467228551300000000000f,   //  4294: sin(23.5876465)
   0.4002393083337295000000000000f,   //  4295: sin(23.5931396)
   0.4003271662656900900000000000f,   //  4296: sin(23.5986328)
   0.4004150205179292100000000000f,   //  4297: sin(23.6041260)
   0.4005028710896395000000000000f,   //  4298: sin(23.6096191)
   0.4005907179800133300000000000f,   //  4299: sin(23.6151123)
   0.4006785611882432400000000000f,   //  4300: sin(23.6206055)
   0.4007664007135218200000000000f,   //  4301: sin(23.6260986)
   0.4008542365550416500000000000f,   //  4302: sin(23.6315918)
   0.4009420687119953400000000000f,   //  4303: sin(23.6370850)
   0.4010298971835756200000000000f,   //  4304: sin(23.6425781)
   0.4011177219689751600000000000f,   //  4305: sin(23.6480713)
   0.4012055430673867100000000000f,   //  4306: sin(23.6535645)
   0.4012933604780030100000000000f,   //  4307: sin(23.6590576)
   0.4013811742000167900000000000f,   //  4308: sin(23.6645508)
   0.4014689842326210600000000000f,   //  4309: sin(23.6700439)
   0.4015567905750085400000000000f,   //  4310: sin(23.6755371)
   0.4016445932263722500000000000f,   //  4311: sin(23.6810303)
   0.4017323921859050100000000000f,   //  4312: sin(23.6865234)
   0.4018201874527998500000000000f,   //  4313: sin(23.6920166)
   0.4019079790262497000000000000f,   //  4314: sin(23.6975098)
   0.4019957669054477500000000000f,   //  4315: sin(23.7030029)
   0.4020835510895869900000000000f,   //  4316: sin(23.7084961)
   0.4021713315778605000000000000f,   //  4317: sin(23.7139893)
   0.4022591083694614900000000000f,   //  4318: sin(23.7194824)
   0.4023468814635829900000000000f,   //  4319: sin(23.7249756)
   0.4024346508594184300000000000f,   //  4320: sin(23.7304688)
   0.4025224165561608900000000000f,   //  4321: sin(23.7359619)
   0.4026101785530036800000000000f,   //  4322: sin(23.7414551)
   0.4026979368491401300000000000f,   //  4323: sin(23.7469482)
   0.4027856914437635300000000000f,   //  4324: sin(23.7524414)
   0.4028734423360673100000000000f,   //  4325: sin(23.7579346)
   0.4029611895252449000000000000f,   //  4326: sin(23.7634277)
   0.4030489330104897200000000000f,   //  4327: sin(23.7689209)
   0.4031366727909953000000000000f,   //  4328: sin(23.7744141)
   0.4032244088659550600000000000f,   //  4329: sin(23.7799072)
   0.4033121412345625500000000000f,   //  4330: sin(23.7854004)
   0.4033998698960114500000000000f,   //  4331: sin(23.7908936)
   0.4034875948494953100000000000f,   //  4332: sin(23.7963867)
   0.4035753160942078300000000000f,   //  4333: sin(23.8018799)
   0.4036630336293426400000000000f,   //  4334: sin(23.8073730)
   0.4037507474540935100000000000f,   //  4335: sin(23.8128662)
   0.4038384575676540700000000000f,   //  4336: sin(23.8183594)
   0.4039261639692182700000000000f,   //  4337: sin(23.8238525)
   0.4040138666579798900000000000f,   //  4338: sin(23.8293457)
   0.4041015656331327100000000000f,   //  4339: sin(23.8348389)
   0.4041892608938706900000000000f,   //  4340: sin(23.8403320)
   0.4042769524393877200000000000f,   //  4341: sin(23.8458252)
   0.4043646402688778100000000000f,   //  4342: sin(23.8513184)
   0.4044523243815348900000000000f,   //  4343: sin(23.8568115)
   0.4045400047765530000000000000f,   //  4344: sin(23.8623047)
   0.4046276814531262200000000000f,   //  4345: sin(23.8677979)
   0.4047153544104486500000000000f,   //  4346: sin(23.8732910)
   0.4048030236477143700000000000f,   //  4347: sin(23.8787842)
   0.4048906891641175800000000000f,   //  4348: sin(23.8842773)
   0.4049783509588525400000000000f,   //  4349: sin(23.8897705)
   0.4050660090311133400000000000f,   //  4350: sin(23.8952637)
   0.4051536633800944000000000000f,   //  4351: sin(23.9007568)
   0.4052413140049898600000000000f,   //  4352: sin(23.9062500)
   0.4053289609049941500000000000f,   //  4353: sin(23.9117432)
   0.4054166040793016300000000000f,   //  4354: sin(23.9172363)
   0.4055042435271067300000000000f,   //  4355: sin(23.9227295)
   0.4055918792476038700000000000f,   //  4356: sin(23.9282227)
   0.4056795112399874700000000000f,   //  4357: sin(23.9337158)
   0.4057671395034520600000000000f,   //  4358: sin(23.9392090)
   0.4058547640371922300000000000f,   //  4359: sin(23.9447021)
   0.4059423848404025100000000000f,   //  4360: sin(23.9501953)
   0.4060300019122775100000000000f,   //  4361: sin(23.9556885)
   0.4061176152520118400000000000f,   //  4362: sin(23.9611816)
   0.4062052248588002800000000000f,   //  4363: sin(23.9666748)
   0.4062928307318373600000000000f,   //  4364: sin(23.9721680)
   0.4063804328703180500000000000f,   //  4365: sin(23.9776611)
   0.4064680312734370000000000000f,   //  4366: sin(23.9831543)
   0.4065556259403890200000000000f,   //  4367: sin(23.9886475)
   0.4066432168703690300000000000f,   //  4368: sin(23.9941406)
   0.4067308040625717800000000000f,   //  4369: sin(23.9996338)
   0.4068183875161923100000000000f,   //  4370: sin(24.0051270)
   0.4069059672304256000000000000f,   //  4371: sin(24.0106201)
   0.4069935432044665100000000000f,   //  4372: sin(24.0161133)
   0.4070811154375101900000000000f,   //  4373: sin(24.0216064)
   0.4071686839287515500000000000f,   //  4374: sin(24.0270996)
   0.4072562486773857500000000000f,   //  4375: sin(24.0325928)
   0.4073438096826079700000000000f,   //  4376: sin(24.0380859)
   0.4074313669436133200000000000f,   //  4377: sin(24.0435791)
   0.4075189204595969200000000000f,   //  4378: sin(24.0490723)
   0.4076064702297541600000000000f,   //  4379: sin(24.0545654)
   0.4076940162532801100000000000f,   //  4380: sin(24.0600586)
   0.4077815585293702000000000000f,   //  4381: sin(24.0655518)
   0.4078690970572198000000000000f,   //  4382: sin(24.0710449)
   0.4079566318360241500000000000f,   //  4383: sin(24.0765381)
   0.4080441628649786900000000000f,   //  4384: sin(24.0820313)
   0.4081316901432788800000000000f,   //  4385: sin(24.0875244)
   0.4082192136701201000000000000f,   //  4386: sin(24.0930176)
   0.4083067334446979800000000000f,   //  4387: sin(24.0985107)
   0.4083942494662080000000000000f,   //  4388: sin(24.1040039)
   0.4084817617338457100000000000f,   //  4389: sin(24.1094971)
   0.4085692702468067800000000000f,   //  4390: sin(24.1149902)
   0.4086567750042867100000000000f,   //  4391: sin(24.1204834)
   0.4087442760054813600000000000f,   //  4392: sin(24.1259766)
   0.4088317732495863600000000000f,   //  4393: sin(24.1314697)
   0.4089192667357974300000000000f,   //  4394: sin(24.1369629)
   0.4090067564633103600000000000f,   //  4395: sin(24.1424561)
   0.4090942424313209800000000000f,   //  4396: sin(24.1479492)
   0.4091817246390250800000000000f,   //  4397: sin(24.1534424)
   0.4092692030856185900000000000f,   //  4398: sin(24.1589355)
   0.4093566777702974900000000000f,   //  4399: sin(24.1644287)
   0.4094441486922575900000000000f,   //  4400: sin(24.1699219)
   0.4095316158506950300000000000f,   //  4401: sin(24.1754150)
   0.4096190792448056700000000000f,   //  4402: sin(24.1809082)
   0.4097065388737857200000000000f,   //  4403: sin(24.1864014)
   0.4097939947368311500000000000f,   //  4404: sin(24.1918945)
   0.4098814468331381500000000000f,   //  4405: sin(24.1973877)
   0.4099688951619028800000000000f,   //  4406: sin(24.2028809)
   0.4100563397223215300000000000f,   //  4407: sin(24.2083740)
   0.4101437805135902400000000000f,   //  4408: sin(24.2138672)
   0.4102312175349053800000000000f,   //  4409: sin(24.2193604)
   0.4103186507854632600000000000f,   //  4410: sin(24.2248535)
   0.4104060802644601300000000000f,   //  4411: sin(24.2303467)
   0.4104935059710924100000000000f,   //  4412: sin(24.2358398)
   0.4105809279045564100000000000f,   //  4413: sin(24.2413330)
   0.4106683460640487300000000000f,   //  4414: sin(24.2468262)
   0.4107557604487657200000000000f,   //  4415: sin(24.2523193)
   0.4108431710579039100000000000f,   //  4416: sin(24.2578125)
   0.4109305778906599000000000000f,   //  4417: sin(24.2633057)
   0.4110179809462302100000000000f,   //  4418: sin(24.2687988)
   0.4111053802238113800000000000f,   //  4419: sin(24.2742920)
   0.4111927757226001600000000000f,   //  4420: sin(24.2797852)
   0.4112801674417931900000000000f,   //  4421: sin(24.2852783)
   0.4113675553805872200000000000f,   //  4422: sin(24.2907715)
   0.4114549395381790200000000000f,   //  4423: sin(24.2962646)
   0.4115423199137652200000000000f,   //  4424: sin(24.3017578)
   0.4116296965065428000000000000f,   //  4425: sin(24.3072510)
   0.4117170693157085600000000000f,   //  4426: sin(24.3127441)
   0.4118044383404593800000000000f,   //  4427: sin(24.3182373)
   0.4118918035799921700000000000f,   //  4428: sin(24.3237305)
   0.4119791650335039000000000000f,   //  4429: sin(24.3292236)
   0.4120665227001915600000000000f,   //  4430: sin(24.3347168)
   0.4121538765792521800000000000f,   //  4431: sin(24.3402100)
   0.4122412266698828900000000000f,   //  4432: sin(24.3457031)
   0.4123285729712806700000000000f,   //  4433: sin(24.3511963)
   0.4124159154826427300000000000f,   //  4434: sin(24.3566895)
   0.4125032542031661400000000000f,   //  4435: sin(24.3621826)
   0.4125905891320482100000000000f,   //  4436: sin(24.3676758)
   0.4126779202684862100000000000f,   //  4437: sin(24.3731689)
   0.4127652476116772700000000000f,   //  4438: sin(24.3786621)
   0.4128525711608187500000000000f,   //  4439: sin(24.3841553)
   0.4129398909151080800000000000f,   //  4440: sin(24.3896484)
   0.4130272068737424500000000000f,   //  4441: sin(24.3951416)
   0.4131145190359194500000000000f,   //  4442: sin(24.4006348)
   0.4132018274008364400000000000f,   //  4443: sin(24.4061279)
   0.4132891319676909600000000000f,   //  4444: sin(24.4116211)
   0.4133764327356804200000000000f,   //  4445: sin(24.4171143)
   0.4134637297040024100000000000f,   //  4446: sin(24.4226074)
   0.4135510228718545800000000000f,   //  4447: sin(24.4281006)
   0.4136383122384345000000000000f,   //  4448: sin(24.4335938)
   0.4137255978029398800000000000f,   //  4449: sin(24.4390869)
   0.4138128795645683000000000000f,   //  4450: sin(24.4445801)
   0.4139001575225175800000000000f,   //  4451: sin(24.4500732)
   0.4139874316759854000000000000f,   //  4452: sin(24.4555664)
   0.4140747020241696300000000000f,   //  4453: sin(24.4610596)
   0.4141619685662680800000000000f,   //  4454: sin(24.4665527)
   0.4142492313014786200000000000f,   //  4455: sin(24.4720459)
   0.4143364902289991000000000000f,   //  4456: sin(24.4775391)
   0.4144237453480275100000000000f,   //  4457: sin(24.4830322)
   0.4145109966577617500000000000f,   //  4458: sin(24.4885254)
   0.4145982441573999300000000000f,   //  4459: sin(24.4940186)
   0.4146854878461400100000000000f,   //  4460: sin(24.4995117)
   0.4147727277231801300000000000f,   //  4461: sin(24.5050049)
   0.4148599637877183300000000000f,   //  4462: sin(24.5104980)
   0.4149471960389527500000000000f,   //  4463: sin(24.5159912)
   0.4150344244760816300000000000f,   //  4464: sin(24.5214844)
   0.4151216490983031200000000000f,   //  4465: sin(24.5269775)
   0.4152088699048155900000000000f,   //  4466: sin(24.5324707)
   0.4152960868948171700000000000f,   //  4467: sin(24.5379639)
   0.4153833000675062300000000000f,   //  4468: sin(24.5434570)
   0.4154705094220811900000000000f,   //  4469: sin(24.5489502)
   0.4155577149577404100000000000f,   //  4470: sin(24.5544434)
   0.4156449166736823100000000000f,   //  4471: sin(24.5599365)
   0.4157321145691053600000000000f,   //  4472: sin(24.5654297)
   0.4158193086432079900000000000f,   //  4473: sin(24.5709229)
   0.4159064988951887700000000000f,   //  4474: sin(24.5764160)
   0.4159936853242463000000000000f,   //  4475: sin(24.5819092)
   0.4160808679295792100000000000f,   //  4476: sin(24.5874023)
   0.4161680467103860400000000000f,   //  4477: sin(24.5928955)
   0.4162552216658654800000000000f,   //  4478: sin(24.5983887)
   0.4163423927952162900000000000f,   //  4479: sin(24.6038818)
   0.4164295600976371500000000000f,   //  4480: sin(24.6093750)
   0.4165167235723268900000000000f,   //  4481: sin(24.6148682)
   0.4166038832184843500000000000f,   //  4482: sin(24.6203613)
   0.4166910390353083000000000000f,   //  4483: sin(24.6258545)
   0.4167781910219976500000000000f,   //  4484: sin(24.6313477)
   0.4168653391777512600000000000f,   //  4485: sin(24.6368408)
   0.4169524835017681700000000000f,   //  4486: sin(24.6423340)
   0.4170396239932474000000000000f,   //  4487: sin(24.6478271)
   0.4171267606513878700000000000f,   //  4488: sin(24.6533203)
   0.4172138934753886800000000000f,   //  4489: sin(24.6588135)
   0.4173010224644488900000000000f,   //  4490: sin(24.6643066)
   0.4173881476177677100000000000f,   //  4491: sin(24.6697998)
   0.4174752689345442900000000000f,   //  4492: sin(24.6752930)
   0.4175623864139778000000000000f,   //  4493: sin(24.6807861)
   0.4176495000552674100000000000f,   //  4494: sin(24.6862793)
   0.4177366098576125200000000000f,   //  4495: sin(24.6917725)
   0.4178237158202122700000000000f,   //  4496: sin(24.6972656)
   0.4179108179422662000000000000f,   //  4497: sin(24.7027588)
   0.4179979162229735500000000000f,   //  4498: sin(24.7082520)
   0.4180850106615337500000000000f,   //  4499: sin(24.7137451)
   0.4181721012571463200000000000f,   //  4500: sin(24.7192383)
   0.4182591880090105700000000000f,   //  4501: sin(24.7247314)
   0.4183462709163262600000000000f,   //  4502: sin(24.7302246)
   0.4184333499782927300000000000f,   //  4503: sin(24.7357178)
   0.4185204251941097000000000000f,   //  4504: sin(24.7412109)
   0.4186074965629767400000000000f,   //  4505: sin(24.7467041)
   0.4186945640840935600000000000f,   //  4506: sin(24.7521973)
   0.4187816277566597200000000000f,   //  4507: sin(24.7576904)
   0.4188686875798750500000000000f,   //  4508: sin(24.7631836)
   0.4189557435529393500000000000f,   //  4509: sin(24.7686768)
   0.4190427956750523700000000000f,   //  4510: sin(24.7741699)
   0.4191298439454139700000000000f,   //  4511: sin(24.7796631)
   0.4192168883632239100000000000f,   //  4512: sin(24.7851563)
   0.4193039289276822600000000000f,   //  4513: sin(24.7906494)
   0.4193909656379888900000000000f,   //  4514: sin(24.7961426)
   0.4194779984933437700000000000f,   //  4515: sin(24.8016357)
   0.4195650274929468800000000000f,   //  4516: sin(24.8071289)
   0.4196520526359983600000000000f,   //  4517: sin(24.8126221)
   0.4197390739216981800000000000f,   //  4518: sin(24.8181152)
   0.4198260913492465900000000000f,   //  4519: sin(24.8236084)
   0.4199131049178436200000000000f,   //  4520: sin(24.8291016)
   0.4200001146266895700000000000f,   //  4521: sin(24.8345947)
   0.4200871204749845300000000000f,   //  4522: sin(24.8400879)
   0.4201741224619288700000000000f,   //  4523: sin(24.8455811)
   0.4202611205867228800000000000f,   //  4524: sin(24.8510742)
   0.4203481148485668800000000000f,   //  4525: sin(24.8565674)
   0.4204351052466611700000000000f,   //  4526: sin(24.8620605)
   0.4205220917802062800000000000f,   //  4527: sin(24.8675537)
   0.4206090744484025100000000000f,   //  4528: sin(24.8730469)
   0.4206960532504504000000000000f,   //  4529: sin(24.8785400)
   0.4207830281855505200000000000f,   //  4530: sin(24.8840332)
   0.4208699992529033000000000000f,   //  4531: sin(24.8895264)
   0.4209569664517094400000000000f,   //  4532: sin(24.8950195)
   0.4210439297811694500000000000f,   //  4533: sin(24.9005127)
   0.4211308892404839700000000000f,   //  4534: sin(24.9060059)
   0.4212178448288538300000000000f,   //  4535: sin(24.9114990)
   0.4213047965454796400000000000f,   //  4536: sin(24.9169922)
   0.4213917443895621700000000000f,   //  4537: sin(24.9224854)
   0.4214786883603022800000000000f,   //  4538: sin(24.9279785)
   0.4215656284569007100000000000f,   //  4539: sin(24.9334717)
   0.4216525646785583300000000000f,   //  4540: sin(24.9389648)
   0.4217394970244761100000000000f,   //  4541: sin(24.9444580)
   0.4218264254938549100000000000f,   //  4542: sin(24.9499512)
   0.4219133500858957600000000000f,   //  4543: sin(24.9554443)
   0.4220002707997996800000000000f,   //  4544: sin(24.9609375)
   0.4220871876347676000000000000f,   //  4545: sin(24.9664307)
   0.4221741005900007700000000000f,   //  4546: sin(24.9719238)
   0.4222610096647002000000000000f,   //  4547: sin(24.9774170)
   0.4223479148580670500000000000f,   //  4548: sin(24.9829102)
   0.4224348161693025100000000000f,   //  4549: sin(24.9884033)
   0.4225217135976078200000000000f,   //  4550: sin(24.9938965)
   0.4226086071421841800000000000f,   //  4551: sin(24.9993896)
   0.4226954968022329500000000000f,   //  4552: sin(25.0048828)
   0.4227823825769554400000000000f,   //  4553: sin(25.0103760)
   0.4228692644655530600000000000f,   //  4554: sin(25.0158691)
   0.4229561424672271300000000000f,   //  4555: sin(25.0213623)
   0.4230430165811790400000000000f,   //  4556: sin(25.0268555)
   0.4231298868066104000000000000f,   //  4557: sin(25.0323486)
   0.4232167531427226100000000000f,   //  4558: sin(25.0378418)
   0.4233036155887173200000000000f,   //  4559: sin(25.0433350)
   0.4233904741437960500000000000f,   //  4560: sin(25.0488281)
   0.4234773288071603800000000000f,   //  4561: sin(25.0543213)
   0.4235641795780119600000000000f,   //  4562: sin(25.0598145)
   0.4236510264555525300000000000f,   //  4563: sin(25.0653076)
   0.4237378694389838400000000000f,   //  4564: sin(25.0708008)
   0.4238247085275075900000000000f,   //  4565: sin(25.0762939)
   0.4239115437203255800000000000f,   //  4566: sin(25.0817871)
   0.4239983750166395600000000000f,   //  4567: sin(25.0872803)
   0.4240852024156515600000000000f,   //  4568: sin(25.0927734)
   0.4241720259165633900000000000f,   //  4569: sin(25.0982666)
   0.4242588455185769500000000000f,   //  4570: sin(25.1037598)
   0.4243456612208943400000000000f,   //  4571: sin(25.1092529)
   0.4244324730227174200000000000f,   //  4572: sin(25.1147461)
   0.4245192809232483100000000000f,   //  4573: sin(25.1202393)
   0.4246060849216891100000000000f,   //  4574: sin(25.1257324)
   0.4246928850172418900000000000f,   //  4575: sin(25.1312256)
   0.4247796812091088100000000000f,   //  4576: sin(25.1367188)
   0.4248664734964920900000000000f,   //  4577: sin(25.1422119)
   0.4249532618785938900000000000f,   //  4578: sin(25.1477051)
   0.4250400463546165600000000000f,   //  4579: sin(25.1531982)
   0.4251268269237623600000000000f,   //  4580: sin(25.1586914)
   0.4252136035852335800000000000f,   //  4581: sin(25.1641846)
   0.4253003763382326400000000000f,   //  4582: sin(25.1696777)
   0.4253871451819619100000000000f,   //  4583: sin(25.1751709)
   0.4254739101156238000000000000f,   //  4584: sin(25.1806641)
   0.4255606711384208900000000000f,   //  4585: sin(25.1861572)
   0.4256474282495555900000000000f,   //  4586: sin(25.1916504)
   0.4257341814482305500000000000f,   //  4587: sin(25.1971436)
   0.4258209307336482400000000000f,   //  4588: sin(25.2026367)
   0.4259076761050112300000000000f,   //  4589: sin(25.2081299)
   0.4259944175615224000000000000f,   //  4590: sin(25.2136230)
   0.4260811551023842600000000000f,   //  4591: sin(25.2191162)
   0.4261678887267996200000000000f,   //  4592: sin(25.2246094)
   0.4262546184339712200000000000f,   //  4593: sin(25.2301025)
   0.4263413442231018300000000000f,   //  4594: sin(25.2355957)
   0.4264280660933942900000000000f,   //  4595: sin(25.2410889)
   0.4265147840440515200000000000f,   //  4596: sin(25.2465820)
   0.4266014980742763900000000000f,   //  4597: sin(25.2520752)
   0.4266882081832718600000000000f,   //  4598: sin(25.2575684)
   0.4267749143702409000000000000f,   //  4599: sin(25.2630615)
   0.4268616166343864300000000000f,   //  4600: sin(25.2685547)
   0.4269483149749117000000000000f,   //  4601: sin(25.2740479)
   0.4270350093910196800000000000f,   //  4602: sin(25.2795410)
   0.4271216998819135100000000000f,   //  4603: sin(25.2850342)
   0.4272083864467963200000000000f,   //  4604: sin(25.2905273)
   0.4272950690848713600000000000f,   //  4605: sin(25.2960205)
   0.4273817477953417700000000000f,   //  4606: sin(25.3015137)
   0.4274684225774109100000000000f,   //  4607: sin(25.3070068)
   0.4275550934302820800000000000f,   //  4608: sin(25.3125000)
   0.4276417603531586000000000000f,   //  4609: sin(25.3179932)
   0.4277284233452438000000000000f,   //  4610: sin(25.3234863)
   0.4278150824057411200000000000f,   //  4611: sin(25.3289795)
   0.4279017375338540800000000000f,   //  4612: sin(25.3344727)
   0.4279883887287861400000000000f,   //  4613: sin(25.3399658)
   0.4280750359897407300000000000f,   //  4614: sin(25.3454590)
   0.4281616793159214700000000000f,   //  4615: sin(25.3509521)
   0.4282483187065319600000000000f,   //  4616: sin(25.3564453)
   0.4283349541607757700000000000f,   //  4617: sin(25.3619385)
   0.4284215856778566500000000000f,   //  4618: sin(25.3674316)
   0.4285082132569783000000000000f,   //  4619: sin(25.3729248)
   0.4285948368973444000000000000f,   //  4620: sin(25.3784180)
   0.4286814565981587600000000000f,   //  4621: sin(25.3839111)
   0.4287680723586250700000000000f,   //  4622: sin(25.3894043)
   0.4288546841779474200000000000f,   //  4623: sin(25.3948975)
   0.4289412920553294900000000000f,   //  4624: sin(25.4003906)
   0.4290278959899753200000000000f,   //  4625: sin(25.4058838)
   0.4291144959810887500000000000f,   //  4626: sin(25.4113770)
   0.4292010920278738800000000000f,   //  4627: sin(25.4168701)
   0.4292876841295346100000000000f,   //  4628: sin(25.4223633)
   0.4293742722852751400000000000f,   //  4629: sin(25.4278564)
   0.4294608564942994900000000000f,   //  4630: sin(25.4333496)
   0.4295474367558118600000000000f,   //  4631: sin(25.4388428)
   0.4296340130690163800000000000f,   //  4632: sin(25.4443359)
   0.4297205854331172000000000000f,   //  4633: sin(25.4498291)
   0.4298071538473187100000000000f,   //  4634: sin(25.4553223)
   0.4298937183108250700000000000f,   //  4635: sin(25.4608154)
   0.4299802788228406200000000000f,   //  4636: sin(25.4663086)
   0.4300668353825697900000000000f,   //  4637: sin(25.4718018)
   0.4301533879892168700000000000f,   //  4638: sin(25.4772949)
   0.4302399366419862900000000000f,   //  4639: sin(25.4827881)
   0.4303264813400826100000000000f,   //  4640: sin(25.4882813)
   0.4304130220827102600000000000f,   //  4641: sin(25.4937744)
   0.4304995588690738200000000000f,   //  4642: sin(25.4992676)
   0.4305860916983778000000000000f,   //  4643: sin(25.5047607)
   0.4306726205698268000000000000f,   //  4644: sin(25.5102539)
   0.4307591454826255600000000000f,   //  4645: sin(25.5157471)
   0.4308456664359787100000000000f,   //  4646: sin(25.5212402)
   0.4309321834290909500000000000f,   //  4647: sin(25.5267334)
   0.4310186964611670300000000000f,   //  4648: sin(25.5322266)
   0.4311052055314117900000000000f,   //  4649: sin(25.5377197)
   0.4311917106390299500000000000f,   //  4650: sin(25.5432129)
   0.4312782117832265600000000000f,   //  4651: sin(25.5487061)
   0.4313647089632063300000000000f,   //  4652: sin(25.5541992)
   0.4314512021781743400000000000f,   //  4653: sin(25.5596924)
   0.4315376914273355000000000000f,   //  4654: sin(25.5651855)
   0.4316241767098947200000000000f,   //  4655: sin(25.5706787)
   0.4317106580250572600000000000f,   //  4656: sin(25.5761719)
   0.4317971353720280200000000000f,   //  4657: sin(25.5816650)
   0.4318836087500122500000000000f,   //  4658: sin(25.5871582)
   0.4319700781582149800000000000f,   //  4659: sin(25.5926514)
   0.4320565435958415000000000000f,   //  4660: sin(25.5981445)
   0.4321430050620969600000000000f,   //  4661: sin(25.6036377)
   0.4322294625561867200000000000f,   //  4662: sin(25.6091309)
   0.4323159160773160100000000000f,   //  4663: sin(25.6146240)
   0.4324023656246901400000000000f,   //  4664: sin(25.6201172)
   0.4324888111975145900000000000f,   //  4665: sin(25.6256104)
   0.4325752527949946500000000000f,   //  4666: sin(25.6311035)
   0.4326616904163359000000000000f,   //  4667: sin(25.6365967)
   0.4327481240607437000000000000f,   //  4668: sin(25.6420898)
   0.4328345537274236300000000000f,   //  4669: sin(25.6475830)
   0.4329209794155812800000000000f,   //  4670: sin(25.6530762)
   0.4330074011244221500000000000f,   //  4671: sin(25.6585693)
   0.4330938188531519600000000000f,   //  4672: sin(25.6640625)
   0.4331802326009763200000000000f,   //  4673: sin(25.6695557)
   0.4332666423671009400000000000f,   //  4674: sin(25.6750488)
   0.4333530481507316100000000000f,   //  4675: sin(25.6805420)
   0.4334394499510740900000000000f,   //  4676: sin(25.6860352)
   0.4335258477673341000000000000f,   //  4677: sin(25.6915283)
   0.4336122415987175800000000000f,   //  4678: sin(25.6970215)
   0.4336986314444304400000000000f,   //  4679: sin(25.7025146)
   0.4337850173036785200000000000f,   //  4680: sin(25.7080078)
   0.4338713991756678600000000000f,   //  4681: sin(25.7135010)
   0.4339577770596044200000000000f,   //  4682: sin(25.7189941)
   0.4340441509546941700000000000f,   //  4683: sin(25.7244873)
   0.4341305208601433100000000000f,   //  4684: sin(25.7299805)
   0.4342168867751578500000000000f,   //  4685: sin(25.7354736)
   0.4343032486989439900000000000f,   //  4686: sin(25.7409668)
   0.4343896066307078600000000000f,   //  4687: sin(25.7464600)
   0.4344759605696556500000000000f,   //  4688: sin(25.7519531)
   0.4345623105149937200000000000f,   //  4689: sin(25.7574463)
   0.4346486564659283200000000000f,   //  4690: sin(25.7629395)
   0.4347349984216656900000000000f,   //  4691: sin(25.7684326)
   0.4348213363814122900000000000f,   //  4692: sin(25.7739258)
   0.4349076703443745000000000000f,   //  4693: sin(25.7794189)
   0.4349940003097587100000000000f,   //  4694: sin(25.7849121)
   0.4350803262767714600000000000f,   //  4695: sin(25.7904053)
   0.4351666482446192600000000000f,   //  4696: sin(25.7958984)
   0.4352529662125085900000000000f,   //  4697: sin(25.8013916)
   0.4353392801796460700000000000f,   //  4698: sin(25.8068848)
   0.4354255901452382900000000000f,   //  4699: sin(25.8123779)
   0.4355118961084920000000000000f,   //  4700: sin(25.8178711)
   0.4355981980686138300000000000f,   //  4701: sin(25.8233643)
   0.4356844960248104600000000000f,   //  4702: sin(25.8288574)
   0.4357707899762887600000000000f,   //  4703: sin(25.8343506)
   0.4358570799222554700000000000f,   //  4704: sin(25.8398438)
   0.4359433658619174500000000000f,   //  4705: sin(25.8453369)
   0.4360296477944815600000000000f,   //  4706: sin(25.8508301)
   0.4361159257191547500000000000f,   //  4707: sin(25.8563232)
   0.4362021996351439500000000000f,   //  4708: sin(25.8618164)
   0.4362884695416561800000000000f,   //  4709: sin(25.8673096)
   0.4363747354378983400000000000f,   //  4710: sin(25.8728027)
   0.4364609973230776900000000000f,   //  4711: sin(25.8782959)
   0.4365472551964012000000000000f,   //  4712: sin(25.8837891)
   0.4366335090570760400000000000f,   //  4713: sin(25.8892822)
   0.4367197589043093600000000000f,   //  4714: sin(25.8947754)
   0.4368060047373084100000000000f,   //  4715: sin(25.9002686)
   0.4368922465552803600000000000f,   //  4716: sin(25.9057617)
   0.4369784843574325800000000000f,   //  4717: sin(25.9112549)
   0.4370647181429723700000000000f,   //  4718: sin(25.9167480)
   0.4371509479111070900000000000f,   //  4719: sin(25.9222412)
   0.4372371736610440900000000000f,   //  4720: sin(25.9277344)
   0.4373233953919908300000000000f,   //  4721: sin(25.9332275)
   0.4374096131031547900000000000f,   //  4722: sin(25.9387207)
   0.4374958267937434900000000000f,   //  4723: sin(25.9442139)
   0.4375820364629644000000000000f,   //  4724: sin(25.9497070)
   0.4376682421100252000000000000f,   //  4725: sin(25.9552002)
   0.4377544437341334100000000000f,   //  4726: sin(25.9606934)
   0.4378406413344967400000000000f,   //  4727: sin(25.9661865)
   0.4379268349103228600000000000f,   //  4728: sin(25.9716797)
   0.4380130244608195200000000000f,   //  4729: sin(25.9771729)
   0.4380992099851944700000000000f,   //  4730: sin(25.9826660)
   0.4381853914826555100000000000f,   //  4731: sin(25.9881592)
   0.4382715689524104300000000000f,   //  4732: sin(25.9936523)
   0.4383577423936672000000000000f,   //  4733: sin(25.9991455)
   0.4384439118056336900000000000f,   //  4734: sin(26.0046387)
   0.4385300771875178500000000000f,   //  4735: sin(26.0101318)
   0.4386162385385276600000000000f,   //  4736: sin(26.0156250)
   0.4387023958578711300000000000f,   //  4737: sin(26.0211182)
   0.4387885491447562900000000000f,   //  4738: sin(26.0266113)
   0.4388746983983913300000000000f,   //  4739: sin(26.0321045)
   0.4389608436179843200000000000f,   //  4740: sin(26.0375977)
   0.4390469848027434600000000000f,   //  4741: sin(26.0430908)
   0.4391331219518769300000000000f,   //  4742: sin(26.0485840)
   0.4392192550645929700000000000f,   //  4743: sin(26.0540771)
   0.4393053841400999500000000000f,   //  4744: sin(26.0595703)
   0.4393915091776060500000000000f,   //  4745: sin(26.0650635)
   0.4394776301763198000000000000f,   //  4746: sin(26.0705566)
   0.4395637471354494300000000000f,   //  4747: sin(26.0760498)
   0.4396498600542034800000000000f,   //  4748: sin(26.0815430)
   0.4397359689317902900000000000f,   //  4749: sin(26.0870361)
   0.4398220737674185000000000000f,   //  4750: sin(26.0925293)
   0.4399081745602966300000000000f,   //  4751: sin(26.0980225)
   0.4399942713096332600000000000f,   //  4752: sin(26.1035156)
   0.4400803640146369000000000000f,   //  4753: sin(26.1090088)
   0.4401664526745163200000000000f,   //  4754: sin(26.1145020)
   0.4402525372884801800000000000f,   //  4755: sin(26.1199951)
   0.4403386178557372500000000000f,   //  4756: sin(26.1254883)
   0.4404246943754962000000000000f,   //  4757: sin(26.1309814)
   0.4405107668469659400000000000f,   //  4758: sin(26.1364746)
   0.4405968352693552200000000000f,   //  4759: sin(26.1419678)
   0.4406828996418729000000000000f,   //  4760: sin(26.1474609)
   0.4407689599637280000000000000f,   //  4761: sin(26.1529541)
   0.4408550162341294300000000000f,   //  4762: sin(26.1584473)
   0.4409410684522861400000000000f,   //  4763: sin(26.1639404)
   0.4410271166174072300000000000f,   //  4764: sin(26.1694336)
   0.4411131607287016600000000000f,   //  4765: sin(26.1749268)
   0.4411992007853786600000000000f,   //  4766: sin(26.1804199)
   0.4412852367866472700000000000f,   //  4767: sin(26.1859131)
   0.4413712687317166700000000000f,   //  4768: sin(26.1914063)
   0.4414572966197961600000000000f,   //  4769: sin(26.1968994)
   0.4415433204500948700000000000f,   //  4770: sin(26.2023926)
   0.4416293402218221000000000000f,   //  4771: sin(26.2078857)
   0.4417153559341873100000000000f,   //  4772: sin(26.2133789)
   0.4418013675863997600000000000f,   //  4773: sin(26.2188721)
   0.4418873751776688500000000000f,   //  4774: sin(26.2243652)
   0.4419733787072040500000000000f,   //  4775: sin(26.2298584)
   0.4420593781742147000000000000f,   //  4776: sin(26.2353516)
   0.4421453735779105100000000000f,   //  4777: sin(26.2408447)
   0.4422313649175009800000000000f,   //  4778: sin(26.2463379)
   0.4423173521921955900000000000f,   //  4779: sin(26.2518311)
   0.4424033354012040800000000000f,   //  4780: sin(26.2573242)
   0.4424893145437360200000000000f,   //  4781: sin(26.2628174)
   0.4425752896190011700000000000f,   //  4782: sin(26.2683105)
   0.4426612606262092500000000000f,   //  4783: sin(26.2738037)
   0.4427472275645700200000000000f,   //  4784: sin(26.2792969)
   0.4428331904332933300000000000f,   //  4785: sin(26.2847900)
   0.4429191492315889800000000000f,   //  4786: sin(26.2902832)
   0.4430051039586668200000000000f,   //  4787: sin(26.2957764)
   0.4430910546137368800000000000f,   //  4788: sin(26.3012695)
   0.4431770011960090600000000000f,   //  4789: sin(26.3067627)
   0.4432629437046933200000000000f,   //  4790: sin(26.3122559)
   0.4433488821389998100000000000f,   //  4791: sin(26.3177490)
   0.4434348164981384800000000000f,   //  4792: sin(26.3232422)
   0.4435207467813194700000000000f,   //  4793: sin(26.3287354)
   0.4436066729877529700000000000f,   //  4794: sin(26.3342285)
   0.4436925951166491600000000000f,   //  4795: sin(26.3397217)
   0.4437785131672182200000000000f,   //  4796: sin(26.3452148)
   0.4438644271386704700000000000f,   //  4797: sin(26.3507080)
   0.4439503370302161400000000000f,   //  4798: sin(26.3562012)
   0.4440362428410655800000000000f,   //  4799: sin(26.3616943)
   0.4441221445704292000000000000f,   //  4800: sin(26.3671875)
   0.4442080422175174200000000000f,   //  4801: sin(26.3726807)
   0.4442939357815405800000000000f,   //  4802: sin(26.3781738)
   0.4443798252617093300000000000f,   //  4803: sin(26.3836670)
   0.4444657106572340000000000000f,   //  4804: sin(26.3891602)
   0.4445515919673253000000000000f,   //  4805: sin(26.3946533)
   0.4446374691911937900000000000f,   //  4806: sin(26.4001465)
   0.4447233423280501100000000000f,   //  4807: sin(26.4056396)
   0.4448092113771048800000000000f,   //  4808: sin(26.4111328)
   0.4448950763375688100000000000f,   //  4809: sin(26.4166260)
   0.4449809372086527300000000000f,   //  4810: sin(26.4221191)
   0.4450667939895673900000000000f,   //  4811: sin(26.4276123)
   0.4451526466795236400000000000f,   //  4812: sin(26.4331055)
   0.4452384952777322400000000000f,   //  4813: sin(26.4385986)
   0.4453243397834041900000000000f,   //  4814: sin(26.4440918)
   0.4454101801957502900000000000f,   //  4815: sin(26.4495850)
   0.4454960165139817400000000000f,   //  4816: sin(26.4550781)
   0.4455818487373093800000000000f,   //  4817: sin(26.4605713)
   0.4456676768649443000000000000f,   //  4818: sin(26.4660645)
   0.4457535008960975500000000000f,   //  4819: sin(26.4715576)
   0.4458393208299802900000000000f,   //  4820: sin(26.4770508)
   0.4459251366658036900000000000f,   //  4821: sin(26.4825439)
   0.4460109484027789400000000000f,   //  4822: sin(26.4880371)
   0.4460967560401173400000000000f,   //  4823: sin(26.4935303)
   0.4461825595770300700000000000f,   //  4824: sin(26.4990234)
   0.4462683590127284300000000000f,   //  4825: sin(26.5045166)
   0.4463541543464238400000000000f,   //  4826: sin(26.5100098)
   0.4464399455773276300000000000f,   //  4827: sin(26.5155029)
   0.4465257327046513500000000000f,   //  4828: sin(26.5209961)
   0.4466115157276062700000000000f,   //  4829: sin(26.5264893)
   0.4466972946454040900000000000f,   //  4830: sin(26.5319824)
   0.4467830694572561500000000000f,   //  4831: sin(26.5374756)
   0.4468688401623741600000000000f,   //  4832: sin(26.5429688)
   0.4469546067599697300000000000f,   //  4833: sin(26.5484619)
   0.4470403692492544400000000000f,   //  4834: sin(26.5539551)
   0.4471261276294401000000000000f,   //  4835: sin(26.5594482)
   0.4472118818997383200000000000f,   //  4836: sin(26.5649414)
   0.4472976320593608500000000000f,   //  4837: sin(26.5704346)
   0.4473833781075196000000000000f,   //  4838: sin(26.5759277)
   0.4474691200434263200000000000f,   //  4839: sin(26.5814209)
   0.4475548578662930100000000000f,   //  4840: sin(26.5869141)
   0.4476405915753314300000000000f,   //  4841: sin(26.5924072)
   0.4477263211697535800000000000f,   //  4842: sin(26.5979004)
   0.4478120466487715600000000000f,   //  4843: sin(26.6033936)
   0.4478977680115973100000000000f,   //  4844: sin(26.6088867)
   0.4479834852574428600000000000f,   //  4845: sin(26.6143799)
   0.4480691983855204000000000000f,   //  4846: sin(26.6198730)
   0.4481549073950420500000000000f,   //  4847: sin(26.6253662)
   0.4482406122852198900000000000f,   //  4848: sin(26.6308594)
   0.4483263130552662700000000000f,   //  4849: sin(26.6363525)
   0.4484120097043934300000000000f,   //  4850: sin(26.6418457)
   0.4484977022318136200000000000f,   //  4851: sin(26.6473389)
   0.4485833906367392400000000000f,   //  4852: sin(26.6528320)
   0.4486690749183824800000000000f,   //  4853: sin(26.6583252)
   0.4487547550759559700000000000f,   //  4854: sin(26.6638184)
   0.4488404311086721100000000000f,   //  4855: sin(26.6693115)
   0.4489261030157432600000000000f,   //  4856: sin(26.6748047)
   0.4490117707963821000000000000f,   //  4857: sin(26.6802979)
   0.4490974344498010500000000000f,   //  4858: sin(26.6857910)
   0.4491830939752127200000000000f,   //  4859: sin(26.6912842)
   0.4492687493718299200000000000f,   //  4860: sin(26.6967773)
   0.4493544006388651100000000000f,   //  4861: sin(26.7022705)
   0.4494400477755311500000000000f,   //  4862: sin(26.7077637)
   0.4495256907810407100000000000f,   //  4863: sin(26.7132568)
   0.4496113296546065400000000000f,   //  4864: sin(26.7187500)
   0.4496969643954416000000000000f,   //  4865: sin(26.7242432)
   0.4497825950027586900000000000f,   //  4866: sin(26.7297363)
   0.4498682214757706600000000000f,   //  4867: sin(26.7352295)
   0.4499538438136905200000000000f,   //  4868: sin(26.7407227)
   0.4500394620157312000000000000f,   //  4869: sin(26.7462158)
   0.4501250760811056900000000000f,   //  4870: sin(26.7517090)
   0.4502106860090271900000000000f,   //  4871: sin(26.7572021)
   0.4502962917987086100000000000f,   //  4872: sin(26.7626953)
   0.4503818934493632500000000000f,   //  4873: sin(26.7681885)
   0.4504674909602041100000000000f,   //  4874: sin(26.7736816)
   0.4505530843304445000000000000f,   //  4875: sin(26.7791748)
   0.4506386735592976000000000000f,   //  4876: sin(26.7846680)
   0.4507242586459767600000000000f,   //  4877: sin(26.7901611)
   0.4508098395896952800000000000f,   //  4878: sin(26.7956543)
   0.4508954163896665100000000000f,   //  4879: sin(26.8011475)
   0.4509809890451038600000000000f,   //  4880: sin(26.8066406)
   0.4510665575552206800000000000f,   //  4881: sin(26.8121338)
   0.4511521219192306000000000000f,   //  4882: sin(26.8176270)
   0.4512376821363470200000000000f,   //  4883: sin(26.8231201)
   0.4513232382057835200000000000f,   //  4884: sin(26.8286133)
   0.4514087901267536700000000000f,   //  4885: sin(26.8341064)
   0.4514943378984711000000000000f,   //  4886: sin(26.8395996)
   0.4515798815201494400000000000f,   //  4887: sin(26.8450928)
   0.4516654209910024900000000000f,   //  4888: sin(26.8505859)
   0.4517509563102439200000000000f,   //  4889: sin(26.8560791)
   0.4518364874770874900000000000f,   //  4890: sin(26.8615723)
   0.4519220144907470900000000000f,   //  4891: sin(26.8670654)
   0.4520075373504364200000000000f,   //  4892: sin(26.8725586)
   0.4520930560553695900000000000f,   //  4893: sin(26.8780518)
   0.4521785706047603500000000000f,   //  4894: sin(26.8835449)
   0.4522640809978227800000000000f,   //  4895: sin(26.8890381)
   0.4523495872337708900000000000f,   //  4896: sin(26.8945313)
   0.4524350893118186400000000000f,   //  4897: sin(26.9000244)
   0.4525205872311800500000000000f,   //  4898: sin(26.9055176)
   0.4526060809910694700000000000f,   //  4899: sin(26.9110107)
   0.4526915705907009200000000000f,   //  4900: sin(26.9165039)
   0.4527770560292885800000000000f,   //  4901: sin(26.9219971)
   0.4528625373060467500000000000f,   //  4902: sin(26.9274902)
   0.4529480144201896200000000000f,   //  4903: sin(26.9329834)
   0.4530334873709315800000000000f,   //  4904: sin(26.9384766)
   0.4531189561574869900000000000f,   //  4905: sin(26.9439697)
   0.4532044207790701900000000000f,   //  4906: sin(26.9494629)
   0.4532898812348956100000000000f,   //  4907: sin(26.9549561)
   0.4533753375241777500000000000f,   //  4908: sin(26.9604492)
   0.4534607896461310100000000000f,   //  4909: sin(26.9659424)
   0.4535462375999700900000000000f,   //  4910: sin(26.9714355)
   0.4536316813849095000000000000f,   //  4911: sin(26.9769287)
   0.4537171210001638700000000000f,   //  4912: sin(26.9824219)
   0.4538025564449478200000000000f,   //  4913: sin(26.9879150)
   0.4538879877184760500000000000f,   //  4914: sin(26.9934082)
   0.4539734148199633400000000000f,   //  4915: sin(26.9989014)
   0.4540588377486244300000000000f,   //  4916: sin(27.0043945)
   0.4541442565036741300000000000f,   //  4917: sin(27.0098877)
   0.4542296710843273200000000000f,   //  4918: sin(27.0153809)
   0.4543150814897988200000000000f,   //  4919: sin(27.0208740)
   0.4544004877193035800000000000f,   //  4920: sin(27.0263672)
   0.4544858897720566200000000000f,   //  4921: sin(27.0318604)
   0.4545712876472729500000000000f,   //  4922: sin(27.0373535)
   0.4546566813441675300000000000f,   //  4923: sin(27.0428467)
   0.4547420708619554500000000000f,   //  4924: sin(27.0483398)
   0.4548274561998518800000000000f,   //  4925: sin(27.0538330)
   0.4549128373570719400000000000f,   //  4926: sin(27.0593262)
   0.4549982143328308300000000000f,   //  4927: sin(27.0648193)
   0.4550835871263438400000000000f,   //  4928: sin(27.0703125)
   0.4551689557368261400000000000f,   //  4929: sin(27.0758057)
   0.4552543201634931000000000000f,   //  4930: sin(27.0812988)
   0.4553396804055600000000000000f,   //  4931: sin(27.0867920)
   0.4554250364622423600000000000f,   //  4932: sin(27.0922852)
   0.4555103883327555300000000000f,   //  4933: sin(27.0977783)
   0.4555957360163149800000000000f,   //  4934: sin(27.1032715)
   0.4556810795121361600000000000f,   //  4935: sin(27.1087646)
   0.4557664188194346400000000000f,   //  4936: sin(27.1142578)
   0.4558517539374260500000000000f,   //  4937: sin(27.1197510)
   0.4559370848653260300000000000f,   //  4938: sin(27.1252441)
   0.4560224116023501300000000000f,   //  4939: sin(27.1307373)
   0.4561077341477141100000000000f,   //  4940: sin(27.1362305)
   0.4561930525006336900000000000f,   //  4941: sin(27.1417236)
   0.4562783666603246200000000000f,   //  4942: sin(27.1472168)
   0.4563636766260027500000000000f,   //  4943: sin(27.1527100)
   0.4564489823968839200000000000f,   //  4944: sin(27.1582031)
   0.4565342839721839900000000000f,   //  4945: sin(27.1636963)
   0.4566195813511189100000000000f,   //  4946: sin(27.1691895)
   0.4567048745329046500000000000f,   //  4947: sin(27.1746826)
   0.4567901635167571600000000000f,   //  4948: sin(27.1801758)
   0.4568754483018925800000000000f,   //  4949: sin(27.1856689)
   0.4569607288875269800000000000f,   //  4950: sin(27.1911621)
   0.4570460052728763700000000000f,   //  4951: sin(27.1966553)
   0.4571312774571569800000000000f,   //  4952: sin(27.2021484)
   0.4572165454395849500000000000f,   //  4953: sin(27.2076416)
   0.4573018092193766300000000000f,   //  4954: sin(27.2131348)
   0.4573870687957482500000000000f,   //  4955: sin(27.2186279)
   0.4574723241679160600000000000f,   //  4956: sin(27.2241211)
   0.4575575753350964400000000000f,   //  4957: sin(27.2296143)
   0.4576428222965057700000000000f,   //  4958: sin(27.2351074)
   0.4577280650513605400000000000f,   //  4959: sin(27.2406006)
   0.4578133035988771700000000000f,   //  4960: sin(27.2460938)
   0.4578985379382722300000000000f,   //  4961: sin(27.2515869)
   0.4579837680687621200000000000f,   //  4962: sin(27.2570801)
   0.4580689939895635800000000000f,   //  4963: sin(27.2625732)
   0.4581542156998930600000000000f,   //  4964: sin(27.2680664)
   0.4582394331989674300000000000f,   //  4965: sin(27.2735596)
   0.4583246464860032400000000000f,   //  4966: sin(27.2790527)
   0.4584098555602172400000000000f,   //  4967: sin(27.2845459)
   0.4584950604208262700000000000f,   //  4968: sin(27.2900391)
   0.4585802610670470800000000000f,   //  4969: sin(27.2955322)
   0.4586654574980965600000000000f,   //  4970: sin(27.3010254)
   0.4587506497131916300000000000f,   //  4971: sin(27.3065186)
   0.4588358377115491200000000000f,   //  4972: sin(27.3120117)
   0.4589210214923861200000000000f,   //  4973: sin(27.3175049)
   0.4590062010549196300000000000f,   //  4974: sin(27.3229980)
   0.4590913763983665000000000000f,   //  4975: sin(27.3284912)
   0.4591765475219440900000000000f,   //  4976: sin(27.3339844)
   0.4592617144248694000000000000f,   //  4977: sin(27.3394775)
   0.4593468771063596300000000000f,   //  4978: sin(27.3449707)
   0.4594320355656318900000000000f,   //  4979: sin(27.3504639)
   0.4595171898019034800000000000f,   //  4980: sin(27.3559570)
   0.4596023398143916900000000000f,   //  4981: sin(27.3614502)
   0.4596874856023138700000000000f,   //  4982: sin(27.3669434)
   0.4597726271648873700000000000f,   //  4983: sin(27.3724365)
   0.4598577645013295400000000000f,   //  4984: sin(27.3779297)
   0.4599428976108578300000000000f,   //  4985: sin(27.3834229)
   0.4600280264926896500000000000f,   //  4986: sin(27.3889160)
   0.4601131511460426200000000000f,   //  4987: sin(27.3944092)
   0.4601982715701343200000000000f,   //  4988: sin(27.3999023)
   0.4602833877641822100000000000f,   //  4989: sin(27.4053955)
   0.4603684997274040100000000000f,   //  4990: sin(27.4108887)
   0.4604536074590173700000000000f,   //  4991: sin(27.4163818)
   0.4605387109582400100000000000f,   //  4992: sin(27.4218750)
   0.4606238102242896600000000000f,   //  4993: sin(27.4273682)
   0.4607089052563840800000000000f,   //  4994: sin(27.4328613)
   0.4607939960537411600000000000f,   //  4995: sin(27.4383545)
   0.4608790826155786900000000000f,   //  4996: sin(27.4438477)
   0.4609641649411145800000000000f,   //  4997: sin(27.4493408)
   0.4610492430295669000000000000f,   //  4998: sin(27.4548340)
   0.4611343168801534900000000000f,   //  4999: sin(27.4603271)
   0.4612193864920923800000000000f,   //  5000: sin(27.4658203)
   0.4613044518646016700000000000f,   //  5001: sin(27.4713135)
   0.4613895129968994500000000000f,   //  5002: sin(27.4768066)
   0.4614745698882038400000000000f,   //  5003: sin(27.4822998)
   0.4615596225377330800000000000f,   //  5004: sin(27.4877930)
   0.4616446709447052900000000000f,   //  5005: sin(27.4932861)
   0.4617297151083387700000000000f,   //  5006: sin(27.4987793)
   0.4618147550278518500000000000f,   //  5007: sin(27.5042725)
   0.4618997907024627300000000000f,   //  5008: sin(27.5097656)
   0.4619848221313899200000000000f,   //  5009: sin(27.5152588)
   0.4620698493138517500000000000f,   //  5010: sin(27.5207520)
   0.4621548722490667600000000000f,   //  5011: sin(27.5262451)
   0.4622398909362533400000000000f,   //  5012: sin(27.5317383)
   0.4623249053746300000000000000f,   //  5013: sin(27.5372314)
   0.4624099155634154300000000000f,   //  5014: sin(27.5427246)
   0.4624949215018281400000000000f,   //  5015: sin(27.5482178)
   0.4625799231890868100000000000f,   //  5016: sin(27.5537109)
   0.4626649206244101100000000000f,   //  5017: sin(27.5592041)
   0.4627499138070167400000000000f,   //  5018: sin(27.5646973)
   0.4628349027361254300000000000f,   //  5019: sin(27.5701904)
   0.4629198874109550800000000000f,   //  5020: sin(27.5756836)
   0.4630048678307245300000000000f,   //  5021: sin(27.5811768)
   0.4630898439946525300000000000f,   //  5022: sin(27.5866699)
   0.4631748159019581400000000000f,   //  5023: sin(27.5921631)
   0.4632597835518601500000000000f,   //  5024: sin(27.5976563)
   0.4633447469435777500000000000f,   //  5025: sin(27.6031494)
   0.4634297060763298300000000000f,   //  5026: sin(27.6086426)
   0.4635146609493355800000000000f,   //  5027: sin(27.6141357)
   0.4635996115618140100000000000f,   //  5028: sin(27.6196289)
   0.4636845579129843000000000000f,   //  5029: sin(27.6251221)
   0.4637695000020656300000000000f,   //  5030: sin(27.6306152)
   0.4638544378282772900000000000f,   //  5031: sin(27.6361084)
   0.4639393713908385200000000000f,   //  5032: sin(27.6416016)
   0.4640243006889686100000000000f,   //  5033: sin(27.6470947)
   0.4641092257218869500000000000f,   //  5034: sin(27.6525879)
   0.4641941464888128000000000000f,   //  5035: sin(27.6580811)
   0.4642790629889657600000000000f,   //  5036: sin(27.6635742)
   0.4643639752215652000000000000f,   //  5037: sin(27.6690674)
   0.4644488831858306600000000000f,   //  5038: sin(27.6745605)
   0.4645337868809816800000000000f,   //  5039: sin(27.6800537)
   0.4646186863062378200000000000f,   //  5040: sin(27.6855469)
   0.4647035814608186900000000000f,   //  5041: sin(27.6910400)
   0.4647884723439439900000000000f,   //  5042: sin(27.6965332)
   0.4648733589548333900000000000f,   //  5043: sin(27.7020264)
   0.4649582412927066900000000000f,   //  5044: sin(27.7075195)
   0.4650431193567836100000000000f,   //  5045: sin(27.7130127)
   0.4651279931462839500000000000f,   //  5046: sin(27.7185059)
   0.4652128626604276600000000000f,   //  5047: sin(27.7239990)
   0.4652977278984346000000000000f,   //  5048: sin(27.7294922)
   0.4653825888595246600000000000f,   //  5049: sin(27.7349854)
   0.4654674455429178000000000000f,   //  5050: sin(27.7404785)
   0.4655522979478341500000000000f,   //  5051: sin(27.7459717)
   0.4656371460734936600000000000f,   //  5052: sin(27.7514648)
   0.4657219899191164500000000000f,   //  5053: sin(27.7569580)
   0.4658068294839227100000000000f,   //  5054: sin(27.7624512)
   0.4658916647671325100000000000f,   //  5055: sin(27.7679443)
   0.4659764957679661800000000000f,   //  5056: sin(27.7734375)
   0.4660613224856438600000000000f,   //  5057: sin(27.7789307)
   0.4661461449193858900000000000f,   //  5058: sin(27.7844238)
   0.4662309630684126600000000000f,   //  5059: sin(27.7899170)
   0.4663157769319444300000000000f,   //  5060: sin(27.7954102)
   0.4664005865092016900000000000f,   //  5061: sin(27.8009033)
   0.4664853917994049000000000000f,   //  5062: sin(27.8063965)
   0.4665701928017744200000000000f,   //  5063: sin(27.8118896)
   0.4666549895155309200000000000f,   //  5064: sin(27.8173828)
   0.4667397819398949000000000000f,   //  5065: sin(27.8228760)
   0.4668245700740869500000000000f,   //  5066: sin(27.8283691)
   0.4669093539173278000000000000f,   //  5067: sin(27.8338623)
   0.4669941334688380000000000000f,   //  5068: sin(27.8393555)
   0.4670789087278384200000000000f,   //  5069: sin(27.8448486)
   0.4671636796935497700000000000f,   //  5070: sin(27.8503418)
   0.4672484463651928000000000000f,   //  5071: sin(27.8558350)
   0.4673332087419884200000000000f,   //  5072: sin(27.8613281)
   0.4674179668231575000000000000f,   //  5073: sin(27.8668213)
   0.4675027206079209200000000000f,   //  5074: sin(27.8723145)
   0.4675874700954996700000000000f,   //  5075: sin(27.8778076)
   0.4676722152851147700000000000f,   //  5076: sin(27.8833008)
   0.4677569561759872300000000000f,   //  5077: sin(27.8887939)
   0.4678416927673381700000000000f,   //  5078: sin(27.8942871)
   0.4679264250583886100000000000f,   //  5079: sin(27.8997803)
   0.4680111530483598300000000000f,   //  5080: sin(27.9052734)
   0.4680958767364729600000000000f,   //  5081: sin(27.9107666)
   0.4681805961219492900000000000f,   //  5082: sin(27.9162598)
   0.4682653112040100500000000000f,   //  5083: sin(27.9217529)
   0.4683500219818765300000000000f,   //  5084: sin(27.9272461)
   0.4684347284547701300000000000f,   //  5085: sin(27.9327393)
   0.4685194306219123100000000000f,   //  5086: sin(27.9382324)
   0.4686041284825244200000000000f,   //  5087: sin(27.9437256)
   0.4686888220358279000000000000f,   //  5088: sin(27.9492188)
   0.4687735112810443900000000000f,   //  5089: sin(27.9547119)
   0.4688581962173953300000000000f,   //  5090: sin(27.9602051)
   0.4689428768441023500000000000f,   //  5091: sin(27.9656982)
   0.4690275531603871300000000000f,   //  5092: sin(27.9711914)
   0.4691122251654713000000000000f,   //  5093: sin(27.9766846)
   0.4691968928585765800000000000f,   //  5094: sin(27.9821777)
   0.4692815562389247600000000000f,   //  5095: sin(27.9876709)
   0.4693662153057375200000000000f,   //  5096: sin(27.9931641)
   0.4694508700582367700000000000f,   //  5097: sin(27.9986572)
   0.4695355204956444500000000000f,   //  5098: sin(28.0041504)
   0.4696201666171823700000000000f,   //  5099: sin(28.0096436)
   0.4697048084220724600000000000f,   //  5100: sin(28.0151367)
   0.4697894459095368100000000000f,   //  5101: sin(28.0206299)
   0.4698740790787973600000000000f,   //  5102: sin(28.0261230)
   0.4699587079290762900000000000f,   //  5103: sin(28.0316162)
   0.4700433324595956200000000000f,   //  5104: sin(28.0371094)
   0.4701279526695775200000000000f,   //  5105: sin(28.0426025)
   0.4702125685582441700000000000f,   //  5106: sin(28.0480957)
   0.4702971801248177500000000000f,   //  5107: sin(28.0535889)
   0.4703817873685206500000000000f,   //  5108: sin(28.0590820)
   0.4704663902885751200000000000f,   //  5109: sin(28.0645752)
   0.4705509888842035500000000000f,   //  5110: sin(28.0700684)
   0.4706355831546282200000000000f,   //  5111: sin(28.0755615)
   0.4707201730990716000000000000f,   //  5112: sin(28.0810547)
   0.4708047587167562000000000000f,   //  5113: sin(28.0865479)
   0.4708893400069045200000000000f,   //  5114: sin(28.0920410)
   0.4709739169687390800000000000f,   //  5115: sin(28.0975342)
   0.4710584896014825000000000000f,   //  5116: sin(28.1030273)
   0.4711430579043574000000000000f,   //  5117: sin(28.1085205)
   0.4712276218765863400000000000f,   //  5118: sin(28.1140137)
   0.4713121815173921800000000000f,   //  5119: sin(28.1195068)
   0.4713967368259976400000000000f,   //  5120: sin(28.1250000)
   0.4714812878016254000000000000f,   //  5121: sin(28.1304932)
   0.4715658344434984200000000000f,   //  5122: sin(28.1359863)
   0.4716503767508394300000000000f,   //  5123: sin(28.1414795)
   0.4717349147228714300000000000f,   //  5124: sin(28.1469727)
   0.4718194483588173900000000000f,   //  5125: sin(28.1524658)
   0.4719039776579002100000000000f,   //  5126: sin(28.1579590)
   0.4719885026193429400000000000f,   //  5127: sin(28.1634521)
   0.4720730232423686600000000000f,   //  5128: sin(28.1689453)
   0.4721575395262004300000000000f,   //  5129: sin(28.1744385)
   0.4722420514700614900000000000f,   //  5130: sin(28.1799316)
   0.4723265590731749500000000000f,   //  5131: sin(28.1854248)
   0.4724110623347640400000000000f,   //  5132: sin(28.1909180)
   0.4724955612540520700000000000f,   //  5133: sin(28.1964111)
   0.4725800558302622500000000000f,   //  5134: sin(28.2019043)
   0.4726645460626180400000000000f,   //  5135: sin(28.2073975)
   0.4727490319503427900000000000f,   //  5136: sin(28.2128906)
   0.4728335134926598400000000000f,   //  5137: sin(28.2183838)
   0.4729179906887927600000000000f,   //  5138: sin(28.2238770)
   0.4730024635379649900000000000f,   //  5139: sin(28.2293701)
   0.4730869320394000500000000000f,   //  5140: sin(28.2348633)
   0.4731713961923216200000000000f,   //  5141: sin(28.2403564)
   0.4732558559959533200000000000f,   //  5142: sin(28.2458496)
   0.4733403114495187100000000000f,   //  5143: sin(28.2513428)
   0.4734247625522415300000000000f,   //  5144: sin(28.2568359)
   0.4735092093033455600000000000f,   //  5145: sin(28.2623291)
   0.4735936517020545300000000000f,   //  5146: sin(28.2678223)
   0.4736780897475923500000000000f,   //  5147: sin(28.2733154)
   0.4737625234391828500000000000f,   //  5148: sin(28.2788086)
   0.4738469527760498800000000000f,   //  5149: sin(28.2843018)
   0.4739313777574174500000000000f,   //  5150: sin(28.2897949)
   0.4740157983825094000000000000f,   //  5151: sin(28.2952881)
   0.4741002146505499700000000000f,   //  5152: sin(28.3007813)
   0.4741846265607631600000000000f,   //  5153: sin(28.3062744)
   0.4742690341123729800000000000f,   //  5154: sin(28.3117676)
   0.4743534373046036100000000000f,   //  5155: sin(28.3172607)
   0.4744378361366792300000000000f,   //  5156: sin(28.3227539)
   0.4745222306078241700000000000f,   //  5157: sin(28.3282471)
   0.4746066207172625600000000000f,   //  5158: sin(28.3337402)
   0.4746910064642187500000000000f,   //  5159: sin(28.3392334)
   0.4747753878479171200000000000f,   //  5160: sin(28.3447266)
   0.4748597648675820200000000000f,   //  5161: sin(28.3502197)
   0.4749441375224378000000000000f,   //  5162: sin(28.3557129)
   0.4750285058117090800000000000f,   //  5163: sin(28.3612061)
   0.4751128697346203000000000000f,   //  5164: sin(28.3666992)
   0.4751972292903959800000000000f,   //  5165: sin(28.3721924)
   0.4752815844782607400000000000f,   //  5166: sin(28.3776855)
   0.4753659352974390900000000000f,   //  5167: sin(28.3831787)
   0.4754502817471558700000000000f,   //  5168: sin(28.3886719)
   0.4755346238266356900000000000f,   //  5169: sin(28.3941650)
   0.4756189615351033000000000000f,   //  5170: sin(28.3996582)
   0.4757032948717835300000000000f,   //  5171: sin(28.4051514)
   0.4757876238359011200000000000f,   //  5172: sin(28.4106445)
   0.4758719484266809600000000000f,   //  5173: sin(28.4161377)
   0.4759562686433480600000000000f,   //  5174: sin(28.4216309)
   0.4760405844851272600000000000f,   //  5175: sin(28.4271240)
   0.4761248959512435800000000000f,   //  5176: sin(28.4326172)
   0.4762092030409220700000000000f,   //  5177: sin(28.4381104)
   0.4762935057533876900000000000f,   //  5178: sin(28.4436035)
   0.4763778040878657300000000000f,   //  5179: sin(28.4490967)
   0.4764620980435811900000000000f,   //  5180: sin(28.4545898)
   0.4765463876197593200000000000f,   //  5181: sin(28.4600830)
   0.4766306728156253200000000000f,   //  5182: sin(28.4655762)
   0.4767149536304045000000000000f,   //  5183: sin(28.4710693)
   0.4767992300633220900000000000f,   //  5184: sin(28.4765625)
   0.4768835021136035300000000000f,   //  5185: sin(28.4820557)
   0.4769677697804741700000000000f,   //  5186: sin(28.4875488)
   0.4770520330631594600000000000f,   //  5187: sin(28.4930420)
   0.4771362919608848100000000000f,   //  5188: sin(28.4985352)
   0.4772205464728757600000000000f,   //  5189: sin(28.5040283)
   0.4773047965983578900000000000f,   //  5190: sin(28.5095215)
   0.4773890423365567700000000000f,   //  5191: sin(28.5150146)
   0.4774732836866980600000000000f,   //  5192: sin(28.5205078)
   0.4775575206480073800000000000f,   //  5193: sin(28.5260010)
   0.4776417532197104700000000000f,   //  5194: sin(28.5314941)
   0.4777259814010330600000000000f,   //  5195: sin(28.5369873)
   0.4778102051912009900000000000f,   //  5196: sin(28.5424805)
   0.4778944245894400400000000000f,   //  5197: sin(28.5479736)
   0.4779786395949761600000000000f,   //  5198: sin(28.5534668)
   0.4780628502070351500000000000f,   //  5199: sin(28.5589600)
   0.4781470564248430100000000000f,   //  5200: sin(28.5644531)
   0.4782312582476258000000000000f,   //  5201: sin(28.5699463)
   0.4783154556746094800000000000f,   //  5202: sin(28.5754395)
   0.4783996487050201600000000000f,   //  5203: sin(28.5809326)
   0.4784838373380839700000000000f,   //  5204: sin(28.5864258)
   0.4785680215730270200000000000f,   //  5205: sin(28.5919189)
   0.4786522014090755000000000000f,   //  5206: sin(28.5974121)
   0.4787363768454557200000000000f,   //  5207: sin(28.6029053)
   0.4788205478813938900000000000f,   //  5208: sin(28.6083984)
   0.4789047145161163800000000000f,   //  5209: sin(28.6138916)
   0.4789888767488494900000000000f,   //  5210: sin(28.6193848)
   0.4790730345788196700000000000f,   //  5211: sin(28.6248779)
   0.4791571880052533100000000000f,   //  5212: sin(28.6303711)
   0.4792413370273769200000000000f,   //  5213: sin(28.6358643)
   0.4793254816444170700000000000f,   //  5214: sin(28.6413574)
   0.4794096218556002100000000000f,   //  5215: sin(28.6468506)
   0.4794937576601530100000000000f,   //  5216: sin(28.6523437)
   0.4795778890573021400000000000f,   //  5217: sin(28.6578369)
   0.4796620160462741800000000000f,   //  5218: sin(28.6633301)
   0.4797461386262960000000000000f,   //  5219: sin(28.6688232)
   0.4798302567965941900000000000f,   //  5220: sin(28.6743164)
   0.4799143705563956300000000000f,   //  5221: sin(28.6798096)
   0.4799984799049272800000000000f,   //  5222: sin(28.6853027)
   0.4800825848414158600000000000f,   //  5223: sin(28.6907959)
   0.4801666853650883900000000000f,   //  5224: sin(28.6962891)
   0.4802507814751717500000000000f,   //  5225: sin(28.7017822)
   0.4803348731708930200000000000f,   //  5226: sin(28.7072754)
   0.4804189604514793000000000000f,   //  5227: sin(28.7127686)
   0.4805030433161575100000000000f,   //  5228: sin(28.7182617)
   0.4805871217641549700000000000f,   //  5229: sin(28.7237549)
   0.4806711957946986400000000000f,   //  5230: sin(28.7292480)
   0.4807552654070158500000000000f,   //  5231: sin(28.7347412)
   0.4808393306003339600000000000f,   //  5232: sin(28.7402344)
   0.4809233913738800200000000000f,   //  5233: sin(28.7457275)
   0.4810074477268815900000000000f,   //  5234: sin(28.7512207)
   0.4810914996585658500000000000f,   //  5235: sin(28.7567139)
   0.4811755471681603000000000000f,   //  5236: sin(28.7622070)
   0.4812595902548925100000000000f,   //  5237: sin(28.7677002)
   0.4813436289179897100000000000f,   //  5238: sin(28.7731934)
   0.4814276631566797300000000000f,   //  5239: sin(28.7786865)
   0.4815116929701898600000000000f,   //  5240: sin(28.7841797)
   0.4815957183577480000000000000f,   //  5241: sin(28.7896729)
   0.4816797393185814900000000000f,   //  5242: sin(28.7951660)
   0.4817637558519182700000000000f,   //  5243: sin(28.8006592)
   0.4818477679569860300000000000f,   //  5244: sin(28.8061523)
   0.4819317756330124800000000000f,   //  5245: sin(28.8116455)
   0.4820157788792255900000000000f,   //  5246: sin(28.8171387)
   0.4820997776948529600000000000f,   //  5247: sin(28.8226318)
   0.4821837720791227200000000000f,   //  5248: sin(28.8281250)
   0.4822677620312627600000000000f,   //  5249: sin(28.8336182)
   0.4823517475505009800000000000f,   //  5250: sin(28.8391113)
   0.4824357286360655400000000000f,   //  5251: sin(28.8446045)
   0.4825197052871843500000000000f,   //  5252: sin(28.8500977)
   0.4826036775030855800000000000f,   //  5253: sin(28.8555908)
   0.4826876452829974600000000000f,   //  5254: sin(28.8610840)
   0.4827716086261480400000000000f,   //  5255: sin(28.8665771)
   0.4828555675317656700000000000f,   //  5256: sin(28.8720703)
   0.4829395219990785200000000000f,   //  5257: sin(28.8775635)
   0.4830234720273148800000000000f,   //  5258: sin(28.8830566)
   0.4831074176157032500000000000f,   //  5259: sin(28.8885498)
   0.4831913587634718600000000000f,   //  5260: sin(28.8940430)
   0.4832752954698492600000000000f,   //  5261: sin(28.8995361)
   0.4833592277340638100000000000f,   //  5262: sin(28.9050293)
   0.4834431555553441700000000000f,   //  5263: sin(28.9105225)
   0.4835270789329187400000000000f,   //  5264: sin(28.9160156)
   0.4836109978660161300000000000f,   //  5265: sin(28.9215088)
   0.4836949123538651400000000000f,   //  5266: sin(28.9270020)
   0.4837788223956942000000000000f,   //  5267: sin(28.9324951)
   0.4838627279907322700000000000f,   //  5268: sin(28.9379883)
   0.4839466291382079100000000000f,   //  5269: sin(28.9434814)
   0.4840305258373500100000000000f,   //  5270: sin(28.9489746)
   0.4841144180873874800000000000f,   //  5271: sin(28.9544678)
   0.4841983058875490300000000000f,   //  5272: sin(28.9599609)
   0.4842821892370637300000000000f,   //  5273: sin(28.9654541)
   0.4843660681351604200000000000f,   //  5274: sin(28.9709473)
   0.4844499425810682200000000000f,   //  5275: sin(28.9764404)
   0.4845338125740161800000000000f,   //  5276: sin(28.9819336)
   0.4846176781132332000000000000f,   //  5277: sin(28.9874268)
   0.4847015391979486700000000000f,   //  5278: sin(28.9929199)
   0.4847853958273915000000000000f,   //  5279: sin(28.9984131)
   0.4848692480007910600000000000f,   //  5280: sin(29.0039062)
   0.4849530957173766000000000000f,   //  5281: sin(29.0093994)
   0.4850369389763772900000000000f,   //  5282: sin(29.0148926)
   0.4851207777770226700000000000f,   //  5283: sin(29.0203857)
   0.4852046121185418200000000000f,   //  5284: sin(29.0258789)
   0.4852884420001644700000000000f,   //  5285: sin(29.0313721)
   0.4853722674211197700000000000f,   //  5286: sin(29.0368652)
   0.4854560883806374200000000000f,   //  5287: sin(29.0423584)
   0.4855399048779469600000000000f,   //  5288: sin(29.0478516)
   0.4856237169122777900000000000f,   //  5289: sin(29.0533447)
   0.4857075244828597500000000000f,   //  5290: sin(29.0588379)
   0.4857913275889222900000000000f,   //  5291: sin(29.0643311)
   0.4858751262296952500000000000f,   //  5292: sin(29.0698242)
   0.4859589204044084100000000000f,   //  5293: sin(29.0753174)
   0.4860427101122913300000000000f,   //  5294: sin(29.0808105)
   0.4861264953525741300000000000f,   //  5295: sin(29.0863037)
   0.4862102761244864200000000000f,   //  5296: sin(29.0917969)
   0.4862940524272581500000000000f,   //  5297: sin(29.0972900)
   0.4863778242601194400000000000f,   //  5298: sin(29.1027832)
   0.4864615916223001300000000000f,   //  5299: sin(29.1082764)
   0.4865453545130302700000000000f,   //  5300: sin(29.1137695)
   0.4866291129315399300000000000f,   //  5301: sin(29.1192627)
   0.4867128668770591700000000000f,   //  5302: sin(29.1247559)
   0.4867966163488183200000000000f,   //  5303: sin(29.1302490)
   0.4868803613460473400000000000f,   //  5304: sin(29.1357422)
   0.4869641018679766700000000000f,   //  5305: sin(29.1412354)
   0.4870478379138363800000000000f,   //  5306: sin(29.1467285)
   0.4871315694828570200000000000f,   //  5307: sin(29.1522217)
   0.4872152965742687600000000000f,   //  5308: sin(29.1577148)
   0.4872990191873020100000000000f,   //  5309: sin(29.1632080)
   0.4873827373211873600000000000f,   //  5310: sin(29.1687012)
   0.4874664509751551200000000000f,   //  5311: sin(29.1741943)
   0.4875501601484360000000000000f,   //  5312: sin(29.1796875)
   0.4876338648402603300000000000f,   //  5313: sin(29.1851807)
   0.4877175650498588000000000000f,   //  5314: sin(29.1906738)
   0.4878012607764622400000000000f,   //  5315: sin(29.1961670)
   0.4878849520193010400000000000f,   //  5316: sin(29.2016602)
   0.4879686387776062100000000000f,   //  5317: sin(29.2071533)
   0.4880523210506082500000000000f,   //  5318: sin(29.2126465)
   0.4881359988375381100000000000f,   //  5319: sin(29.2181396)
   0.4882196721376267900000000000f,   //  5320: sin(29.2236328)
   0.4883033409501048600000000000f,   //  5321: sin(29.2291260)
   0.4883870052742035300000000000f,   //  5322: sin(29.2346191)
   0.4884706651091536000000000000f,   //  5323: sin(29.2401123)
   0.4885543204541861800000000000f,   //  5324: sin(29.2456055)
   0.4886379713085323200000000000f,   //  5325: sin(29.2510986)
   0.4887216176714230800000000000f,   //  5326: sin(29.2565918)
   0.4888052595420897000000000000f,   //  5327: sin(29.2620850)
   0.4888888969197631700000000000f,   //  5328: sin(29.2675781)
   0.4889725298036748900000000000f,   //  5329: sin(29.2730713)
   0.4890561581930560300000000000f,   //  5330: sin(29.2785645)
   0.4891397820871378800000000000f,   //  5331: sin(29.2840576)
   0.4892234014851519800000000000f,   //  5332: sin(29.2895508)
   0.4893070163863294500000000000f,   //  5333: sin(29.2950439)
   0.4893906267899019200000000000f,   //  5334: sin(29.3005371)
   0.4894742326951007100000000000f,   //  5335: sin(29.3060303)
   0.4895578341011574400000000000f,   //  5336: sin(29.3115234)
   0.4896414310073036700000000000f,   //  5337: sin(29.3170166)
   0.4897250234127709100000000000f,   //  5338: sin(29.3225098)
   0.4898086113167908800000000000f,   //  5339: sin(29.3280029)
   0.4898921947185951900000000000f,   //  5340: sin(29.3334961)
   0.4899757736174155100000000000f,   //  5341: sin(29.3389893)
   0.4900593480124838500000000000f,   //  5342: sin(29.3444824)
   0.4901429179030317200000000000f,   //  5343: sin(29.3499756)
   0.4902264832882911600000000000f,   //  5344: sin(29.3554688)
   0.4903100441674939100000000000f,   //  5345: sin(29.3609619)
   0.4903936005398719700000000000f,   //  5346: sin(29.3664551)
   0.4904771524046573900000000000f,   //  5347: sin(29.3719482)
   0.4905606997610820200000000000f,   //  5348: sin(29.3774414)
   0.4906442426083780200000000000f,   //  5349: sin(29.3829346)
   0.4907277809457774000000000000f,   //  5350: sin(29.3884277)
   0.4908113147725124400000000000f,   //  5351: sin(29.3939209)
   0.4908948440878150900000000000f,   //  5352: sin(29.3994141)
   0.4909783688909177300000000000f,   //  5353: sin(29.4049072)
   0.4910618891810526500000000000f,   //  5354: sin(29.4104004)
   0.4911454049574520100000000000f,   //  5355: sin(29.4158936)
   0.4912289162193482800000000000f,   //  5356: sin(29.4213867)
   0.4913124229659737200000000000f,   //  5357: sin(29.4268799)
   0.4913959251965607800000000000f,   //  5358: sin(29.4323730)
   0.4914794229103420800000000000f,   //  5359: sin(29.4378662)
   0.4915629161065499000000000000f,   //  5360: sin(29.4433594)
   0.4916464047844170100000000000f,   //  5361: sin(29.4488525)
   0.4917298889431757600000000000f,   //  5362: sin(29.4543457)
   0.4918133685820589300000000000f,   //  5363: sin(29.4598389)
   0.4918968437002992900000000000f,   //  5364: sin(29.4653320)
   0.4919803142971293500000000000f,   //  5365: sin(29.4708252)
   0.4920637803717820000000000000f,   //  5366: sin(29.4763184)
   0.4921472419234899100000000000f,   //  5367: sin(29.4818115)
   0.4922306989514860200000000000f,   //  5368: sin(29.4873047)
   0.4923141514550032300000000000f,   //  5369: sin(29.4927979)
   0.4923975994332743800000000000f,   //  5370: sin(29.4982910)
   0.4924810428855325700000000000f,   //  5371: sin(29.5037842)
   0.4925644818110105900000000000f,   //  5372: sin(29.5092773)
   0.4926479162089417200000000000f,   //  5373: sin(29.5147705)
   0.4927313460785588400000000000f,   //  5374: sin(29.5202637)
   0.4928147714190951900000000000f,   //  5375: sin(29.5257568)
   0.4928981922297840400000000000f,   //  5376: sin(29.5312500)
   0.4929816085098583900000000000f,   //  5377: sin(29.5367432)
   0.4930650202585517000000000000f,   //  5378: sin(29.5422363)
   0.4931484274750970700000000000f,   //  5379: sin(29.5477295)
   0.4932318301587279000000000000f,   //  5380: sin(29.5532227)
   0.4933152283086777400000000000f,   //  5381: sin(29.5587158)
   0.4933986219241797700000000000f,   //  5382: sin(29.5642090)
   0.4934820110044677000000000000f,   //  5383: sin(29.5697021)
   0.4935653955487747700000000000f,   //  5384: sin(29.5751953)
   0.4936487755563346300000000000f,   //  5385: sin(29.5806885)
   0.4937321510263810200000000000f,   //  5386: sin(29.5861816)
   0.4938155219581473200000000000f,   //  5387: sin(29.5916748)
   0.4938988883508674800000000000f,   //  5388: sin(29.5971680)
   0.4939822502037749500000000000f,   //  5389: sin(29.6026611)
   0.4940656075161035700000000000f,   //  5390: sin(29.6081543)
   0.4941489602870872700000000000f,   //  5391: sin(29.6136475)
   0.4942323085159596700000000000f,   //  5392: sin(29.6191406)
   0.4943156522019548900000000000f,   //  5393: sin(29.6246338)
   0.4943989913443066500000000000f,   //  5394: sin(29.6301270)
   0.4944823259422490600000000000f,   //  5395: sin(29.6356201)
   0.4945656559950159500000000000f,   //  5396: sin(29.6411133)
   0.4946489815018415000000000000f,   //  5397: sin(29.6466064)
   0.4947323024619598700000000000f,   //  5398: sin(29.6520996)
   0.4948156188746049600000000000f,   //  5399: sin(29.6575928)
   0.4948989307390112600000000000f,   //  5400: sin(29.6630859)
   0.4949822380544126600000000000f,   //  5401: sin(29.6685791)
   0.4950655408200435600000000000f,   //  5402: sin(29.6740723)
   0.4951488390351383400000000000f,   //  5403: sin(29.6795654)
   0.4952321326989311800000000000f,   //  5404: sin(29.6850586)
   0.4953154218106566900000000000f,   //  5405: sin(29.6905518)
   0.4953987063695490200000000000f,   //  5406: sin(29.6960449)
   0.4954819863748427500000000000f,   //  5407: sin(29.7015381)
   0.4955652618257725400000000000f,   //  5408: sin(29.7070313)
   0.4956485327215726700000000000f,   //  5409: sin(29.7125244)
   0.4957317990614779600000000000f,   //  5410: sin(29.7180176)
   0.4958150608447228800000000000f,   //  5411: sin(29.7235107)
   0.4958983180705421900000000000f,   //  5412: sin(29.7290039)
   0.4959815707381706700000000000f,   //  5413: sin(29.7344971)
   0.4960648188468428900000000000f,   //  5414: sin(29.7399902)
   0.4961480623957938400000000000f,   //  5415: sin(29.7454834)
   0.4962313013842582500000000000f,   //  5416: sin(29.7509766)
   0.4963145358114711100000000000f,   //  5417: sin(29.7564697)
   0.4963977656766671600000000000f,   //  5418: sin(29.7619629)
   0.4964809909790815500000000000f,   //  5419: sin(29.7674561)
   0.4965642117179492900000000000f,   //  5420: sin(29.7729492)
   0.4966474278925052700000000000f,   //  5421: sin(29.7784424)
   0.4967306395019847600000000000f,   //  5422: sin(29.7839355)
   0.4968138465456227700000000000f,   //  5423: sin(29.7894287)
   0.4968970490226544700000000000f,   //  5424: sin(29.7949219)
   0.4969802469323152900000000000f,   //  5425: sin(29.8004150)
   0.4970634402738402500000000000f,   //  5426: sin(29.8059082)
   0.4971466290464648400000000000f,   //  5427: sin(29.8114014)
   0.4972298132494242200000000000f,   //  5428: sin(29.8168945)
   0.4973129928819538500000000000f,   //  5429: sin(29.8223877)
   0.4973961679432892800000000000f,   //  5430: sin(29.8278809)
   0.4974793384326658400000000000f,   //  5431: sin(29.8333740)
   0.4975625043493191500000000000f,   //  5432: sin(29.8388672)
   0.4976456656924846400000000000f,   //  5433: sin(29.8443604)
   0.4977288224613979400000000000f,   //  5434: sin(29.8498535)
   0.4978119746552948600000000000f,   //  5435: sin(29.8553467)
   0.4978951222734108700000000000f,   //  5436: sin(29.8608398)
   0.4979782653149818500000000000f,   //  5437: sin(29.8663330)
   0.4980614037792434100000000000f,   //  5438: sin(29.8718262)
   0.4981445376654314900000000000f,   //  5439: sin(29.8773193)
   0.4982276669727818700000000000f,   //  5440: sin(29.8828125)
   0.4983107917005303900000000000f,   //  5441: sin(29.8883057)
   0.4983939118479132100000000000f,   //  5442: sin(29.8937988)
   0.4984770274141660500000000000f,   //  5443: sin(29.8992920)
   0.4985601383985251400000000000f,   //  5444: sin(29.9047852)
   0.4986432448002263700000000000f,   //  5445: sin(29.9102783)
   0.4987263466185059000000000000f,   //  5446: sin(29.9157715)
   0.4988094438525999500000000000f,   //  5447: sin(29.9212646)
   0.4988925365017445900000000000f,   //  5448: sin(29.9267578)
   0.4989756245651761900000000000f,   //  5449: sin(29.9322510)
   0.4990587080421308700000000000f,   //  5450: sin(29.9377441)
   0.4991417869318450200000000000f,   //  5451: sin(29.9432373)
   0.4992248612335550800000000000f,   //  5452: sin(29.9487305)
   0.4993079309464972200000000000f,   //  5453: sin(29.9542236)
   0.4993909960699081700000000000f,   //  5454: sin(29.9597168)
   0.4994740566030241900000000000f,   //  5455: sin(29.9652100)
   0.4995571125450818400000000000f,   //  5456: sin(29.9707031)
   0.4996401638953177900000000000f,   //  5457: sin(29.9761963)
   0.4997232106529685400000000000f,   //  5458: sin(29.9816895)
   0.4998062528172709200000000000f,   //  5459: sin(29.9871826)
   0.4998892903874613300000000000f,   //  5460: sin(29.9926758)
   0.4999723233627768000000000000f,   //  5461: sin(29.9981689)
   0.5000553517424538600000000000f,   //  5462: sin(30.0036621)
   0.5001383755257294800000000000f,   //  5463: sin(30.0091553)
   0.5002213947118406800000000000f,   //  5464: sin(30.0146484)
   0.5003044093000239600000000000f,   //  5465: sin(30.0201416)
   0.5003874192895165800000000000f,   //  5466: sin(30.0256348)
   0.5004704246795553800000000000f,   //  5467: sin(30.0311279)
   0.5005534254693774200000000000f,   //  5468: sin(30.0366211)
   0.5006364216582199800000000000f,   //  5469: sin(30.0421143)
   0.5007194132453198800000000000f,   //  5470: sin(30.0476074)
   0.5008024002299144000000000000f,   //  5471: sin(30.0531006)
   0.5008853826112407100000000000f,   //  5472: sin(30.0585938)
   0.5009683603885362000000000000f,   //  5473: sin(30.0640869)
   0.5010513335610380400000000000f,   //  5474: sin(30.0695801)
   0.5011343021279833800000000000f,   //  5475: sin(30.0750732)
   0.5012172660886099500000000000f,   //  5476: sin(30.0805664)
   0.5013002254421549100000000000f,   //  5477: sin(30.0860596)
   0.5013831801878557700000000000f,   //  5478: sin(30.0915527)
   0.5014661303249501300000000000f,   //  5479: sin(30.0970459)
   0.5015490758526753900000000000f,   //  5480: sin(30.1025391)
   0.5016320167702692500000000000f,   //  5481: sin(30.1080322)
   0.5017149530769691200000000000f,   //  5482: sin(30.1135254)
   0.5017978847720130400000000000f,   //  5483: sin(30.1190186)
   0.5018808118546382900000000000f,   //  5484: sin(30.1245117)
   0.5019637343240829200000000000f,   //  5485: sin(30.1300049)
   0.5020466521795846600000000000f,   //  5486: sin(30.1354980)
   0.5021295654203813400000000000f,   //  5487: sin(30.1409912)
   0.5022124740457107900000000000f,   //  5488: sin(30.1464844)
   0.5022953780548109500000000000f,   //  5489: sin(30.1519775)
   0.5023782774469197600000000000f,   //  5490: sin(30.1574707)
   0.5024611722212754000000000000f,   //  5491: sin(30.1629639)
   0.5025440623771156900000000000f,   //  5492: sin(30.1684570)
   0.5026269479136789000000000000f,   //  5493: sin(30.1739502)
   0.5027098288302029900000000000f,   //  5494: sin(30.1794434)
   0.5027927051259262200000000000f,   //  5495: sin(30.1849365)
   0.5028755768000869900000000000f,   //  5496: sin(30.1904297)
   0.5029584438519231200000000000f,   //  5497: sin(30.1959229)
   0.5030413062806734500000000000f,   //  5498: sin(30.2014160)
   0.5031241640855758100000000000f,   //  5499: sin(30.2069092)
   0.5032070172658689200000000000f,   //  5500: sin(30.2124023)
   0.5032898658207912700000000000f,   //  5501: sin(30.2178955)
   0.5033727097495810400000000000f,   //  5502: sin(30.2233887)
   0.5034555490514770500000000000f,   //  5503: sin(30.2288818)
   0.5035383837257175800000000000f,   //  5504: sin(30.2343750)
   0.5036212137715413400000000000f,   //  5505: sin(30.2398682)
   0.5037040391881870700000000000f,   //  5506: sin(30.2453613)
   0.5037868599748932500000000000f,   //  5507: sin(30.2508545)
   0.5038696761308989500000000000f,   //  5508: sin(30.2563477)
   0.5039524876554425400000000000f,   //  5509: sin(30.2618408)
   0.5040352945477631900000000000f,   //  5510: sin(30.2673340)
   0.5041180968070994000000000000f,   //  5511: sin(30.2728271)
   0.5042008944326903400000000000f,   //  5512: sin(30.2783203)
   0.5042836874237749400000000000f,   //  5513: sin(30.2838135)
   0.5043664757795920400000000000f,   //  5514: sin(30.2893066)
   0.5044492594993809100000000000f,   //  5515: sin(30.2947998)
   0.5045320385823802700000000000f,   //  5516: sin(30.3002930)
   0.5046148130278294000000000000f,   //  5517: sin(30.3057861)
   0.5046975828349675700000000000f,   //  5518: sin(30.3112793)
   0.5047803480030338400000000000f,   //  5519: sin(30.3167725)
   0.5048631085312675900000000000f,   //  5520: sin(30.3222656)
   0.5049458644189078700000000000f,   //  5521: sin(30.3277588)
   0.5050286156651940800000000000f,   //  5522: sin(30.3332520)
   0.5051113622693658200000000000f,   //  5523: sin(30.3387451)
   0.5051941042306622400000000000f,   //  5524: sin(30.3442383)
   0.5052768415483229700000000000f,   //  5525: sin(30.3497314)
   0.5053595742215872800000000000f,   //  5526: sin(30.3552246)
   0.5054423022496950000000000000f,   //  5527: sin(30.3607178)
   0.5055250256318853900000000000f,   //  5528: sin(30.3662109)
   0.5056077443673983000000000000f,   //  5529: sin(30.3717041)
   0.5056904584554734500000000000f,   //  5530: sin(30.3771973)
   0.5057731678953503200000000000f,   //  5531: sin(30.3826904)
   0.5058558726862688600000000000f,   //  5532: sin(30.3881836)
   0.5059385728274686800000000000f,   //  5533: sin(30.3936768)
   0.5060212683181897200000000000f,   //  5534: sin(30.3991699)
   0.5061039591576720300000000000f,   //  5535: sin(30.4046631)
   0.5061866453451552300000000000f,   //  5536: sin(30.4101563)
   0.5062693268798795800000000000f,   //  5537: sin(30.4156494)
   0.5063520037610848000000000000f,   //  5538: sin(30.4211426)
   0.5064346759880110600000000000f,   //  5539: sin(30.4266357)
   0.5065173435598985300000000000f,   //  5540: sin(30.4321289)
   0.5066000064759872400000000000f,   //  5541: sin(30.4376221)
   0.5066826647355176000000000000f,   //  5542: sin(30.4431152)
   0.5067653183377294200000000000f,   //  5543: sin(30.4486084)
   0.5068479672818632100000000000f,   //  5544: sin(30.4541016)
   0.5069306115671594600000000000f,   //  5545: sin(30.4595947)
   0.5070132511928582300000000000f,   //  5546: sin(30.4650879)
   0.5070958861582000000000000000f,   //  5547: sin(30.4705811)
   0.5071785164624251800000000000f,   //  5548: sin(30.4760742)
   0.5072611421047743500000000000f,   //  5549: sin(30.4815674)
   0.5073437630844879200000000000f,   //  5550: sin(30.4870605)
   0.5074263794008065900000000000f,   //  5551: sin(30.4925537)
   0.5075089910529708700000000000f,   //  5552: sin(30.4980469)
   0.5075915980402213600000000000f,   //  5553: sin(30.5035400)
   0.5076742003617988900000000000f,   //  5554: sin(30.5090332)
   0.5077567980169440700000000000f,   //  5555: sin(30.5145264)
   0.5078393910048977200000000000f,   //  5556: sin(30.5200195)
   0.5079219793249008000000000000f,   //  5557: sin(30.5255127)
   0.5080045629761940100000000000f,   //  5558: sin(30.5310059)
   0.5080871419580183000000000000f,   //  5559: sin(30.5364990)
   0.5081697162696146000000000000f,   //  5560: sin(30.5419922)
   0.5082522859102239800000000000f,   //  5561: sin(30.5474854)
   0.5083348508790873600000000000f,   //  5562: sin(30.5529785)
   0.5084174111754459200000000000f,   //  5563: sin(30.5584717)
   0.5084999667985409300000000000f,   //  5564: sin(30.5639648)
   0.5085825177476130900000000000f,   //  5565: sin(30.5694580)
   0.5086650640219040300000000000f,   //  5566: sin(30.5749512)
   0.5087476056206550200000000000f,   //  5567: sin(30.5804443)
   0.5088301425431069900000000000f,   //  5568: sin(30.5859375)
   0.5089126747885016600000000000f,   //  5569: sin(30.5914307)
   0.5089952023560800900000000000f,   //  5570: sin(30.5969238)
   0.5090777252450839900000000000f,   //  5571: sin(30.6024170)
   0.5091602434547546400000000000f,   //  5572: sin(30.6079102)
   0.5092427569843336300000000000f,   //  5573: sin(30.6134033)
   0.5093252658330624800000000000f,   //  5574: sin(30.6188965)
   0.5094077700001827800000000000f,   //  5575: sin(30.6243896)
   0.5094902694849363600000000000f,   //  5576: sin(30.6298828)
   0.5095727642865645100000000000f,   //  5577: sin(30.6353760)
   0.5096552544043092500000000000f,   //  5578: sin(30.6408691)
   0.5097377398374123300000000000f,   //  5579: sin(30.6463623)
   0.5098202205851154500000000000f,   //  5580: sin(30.6518555)
   0.5099026966466605500000000000f,   //  5581: sin(30.6573486)
   0.5099851680212894600000000000f,   //  5582: sin(30.6628418)
   0.5100676347082442300000000000f,   //  5583: sin(30.6683350)
   0.5101500967067668100000000000f,   //  5584: sin(30.6738281)
   0.5102325540160990200000000000f,   //  5585: sin(30.6793213)
   0.5103150066354832400000000000f,   //  5586: sin(30.6848145)
   0.5103974545641614100000000000f,   //  5587: sin(30.6903076)
   0.5104798978013757000000000000f,   //  5588: sin(30.6958008)
   0.5105623363463683800000000000f,   //  5589: sin(30.7012939)
   0.5106447701983816100000000000f,   //  5590: sin(30.7067871)
   0.5107271993566577800000000000f,   //  5591: sin(30.7122803)
   0.5108096238204390400000000000f,   //  5592: sin(30.7177734)
   0.5108920435889680000000000000f,   //  5593: sin(30.7232666)
   0.5109744586614868300000000000f,   //  5594: sin(30.7287598)
   0.5110568690372381300000000000f,   //  5595: sin(30.7342529)
   0.5111392747154643900000000000f,   //  5596: sin(30.7397461)
   0.5112216756954081100000000000f,   //  5597: sin(30.7452393)
   0.5113040719763120000000000000f,   //  5598: sin(30.7507324)
   0.5113864635574184600000000000f,   //  5599: sin(30.7562256)
   0.5114688504379703000000000000f,   //  5600: sin(30.7617187)
   0.5115512326172104700000000000f,   //  5601: sin(30.7672119)
   0.5116336100943812400000000000f,   //  5602: sin(30.7727051)
   0.5117159828687258800000000000f,   //  5603: sin(30.7781982)
   0.5117983509394868900000000000f,   //  5604: sin(30.7836914)
   0.5118807143059073100000000000f,   //  5605: sin(30.7891846)
   0.5119630729672302000000000000f,   //  5606: sin(30.7946777)
   0.5120454269226982800000000000f,   //  5607: sin(30.8001709)
   0.5121277761715546900000000000f,   //  5608: sin(30.8056641)
   0.5122101207130425000000000000f,   //  5609: sin(30.8111572)
   0.5122924605464048700000000000f,   //  5610: sin(30.8166504)
   0.5123747956708849500000000000f,   //  5611: sin(30.8221436)
   0.5124571260857256900000000000f,   //  5612: sin(30.8276367)
   0.5125394517901706900000000000f,   //  5613: sin(30.8331299)
   0.5126217727834629900000000000f,   //  5614: sin(30.8386230)
   0.5127040890648459900000000000f,   //  5615: sin(30.8441162)
   0.5127864006335629600000000000f,   //  5616: sin(30.8496094)
   0.5128687074888574900000000000f,   //  5617: sin(30.8551025)
   0.5129510096299729800000000000f,   //  5618: sin(30.8605957)
   0.5130333070561526900000000000f,   //  5619: sin(30.8660889)
   0.5131155997666405600000000000f,   //  5620: sin(30.8715820)
   0.5131978877606798700000000000f,   //  5621: sin(30.8770752)
   0.5132801710375142200000000000f,   //  5622: sin(30.8825684)
   0.5133624495963876600000000000f,   //  5623: sin(30.8880615)
   0.5134447234365434600000000000f,   //  5624: sin(30.8935547)
   0.5135269925572256700000000000f,   //  5625: sin(30.8990479)
   0.5136092569576777800000000000f,   //  5626: sin(30.9045410)
   0.5136915166371439600000000000f,   //  5627: sin(30.9100342)
   0.5137737715948680300000000000f,   //  5628: sin(30.9155273)
   0.5138560218300938200000000000f,   //  5629: sin(30.9210205)
   0.5139382673420653800000000000f,   //  5630: sin(30.9265137)
   0.5140205081300266400000000000f,   //  5631: sin(30.9320068)
   0.5141027441932216600000000000f,   //  5632: sin(30.9375000)
   0.5141849755308947100000000000f,   //  5633: sin(30.9429932)
   0.5142672021422897100000000000f,   //  5634: sin(30.9484863)
   0.5143494240266510700000000000f,   //  5635: sin(30.9539795)
   0.5144316411832228200000000000f,   //  5636: sin(30.9594727)
   0.5145138536112494600000000000f,   //  5637: sin(30.9649658)
   0.5145960613099750400000000000f,   //  5638: sin(30.9704590)
   0.5146782642786441600000000000f,   //  5639: sin(30.9759521)
   0.5147604625165012000000000000f,   //  5640: sin(30.9814453)
   0.5148426560227903300000000000f,   //  5641: sin(30.9869385)
   0.5149248447967564900000000000f,   //  5642: sin(30.9924316)
   0.5150070288376439300000000000f,   //  5643: sin(30.9979248)
   0.5150892081446971600000000000f,   //  5644: sin(31.0034180)
   0.5151713827171611200000000000f,   //  5645: sin(31.0089111)
   0.5152535525542801800000000000f,   //  5646: sin(31.0144043)
   0.5153357176552992900000000000f,   //  5647: sin(31.0198975)
   0.5154178780194629300000000000f,   //  5648: sin(31.0253906)
   0.5155000336460161500000000000f,   //  5649: sin(31.0308838)
   0.5155821845342037900000000000f,   //  5650: sin(31.0363770)
   0.5156643306832704400000000000f,   //  5651: sin(31.0418701)
   0.5157464720924613800000000000f,   //  5652: sin(31.0473633)
   0.5158286087610214300000000000f,   //  5653: sin(31.0528564)
   0.5159107406881956500000000000f,   //  5654: sin(31.0583496)
   0.5159928678732289600000000000f,   //  5655: sin(31.0638428)
   0.5160749903153666300000000000f,   //  5656: sin(31.0693359)
   0.5161571080138537300000000000f,   //  5657: sin(31.0748291)
   0.5162392209679355100000000000f,   //  5658: sin(31.0803223)
   0.5163213291768572500000000000f,   //  5659: sin(31.0858154)
   0.5164034326398639900000000000f,   //  5660: sin(31.0913086)
   0.5164855313562012300000000000f,   //  5661: sin(31.0968018)
   0.5165676253251143500000000000f,   //  5662: sin(31.1022949)
   0.5166497145458487400000000000f,   //  5663: sin(31.1077881)
   0.5167317990176498700000000000f,   //  5664: sin(31.1132813)
   0.5168138787397631400000000000f,   //  5665: sin(31.1187744)
   0.5168959537114341500000000000f,   //  5666: sin(31.1242676)
   0.5169780239319086100000000000f,   //  5667: sin(31.1297607)
   0.5170600894004319100000000000f,   //  5668: sin(31.1352539)
   0.5171421501162499800000000000f,   //  5669: sin(31.1407471)
   0.5172242060786083100000000000f,   //  5670: sin(31.1462402)
   0.5173062572867526100000000000f,   //  5671: sin(31.1517334)
   0.5173883037399290600000000000f,   //  5672: sin(31.1572266)
   0.5174703454373831300000000000f,   //  5673: sin(31.1627197)
   0.5175523823783608800000000000f,   //  5674: sin(31.1682129)
   0.5176344145621082400000000000f,   //  5675: sin(31.1737061)
   0.5177164419878711500000000000f,   //  5676: sin(31.1791992)
   0.5177984646548955400000000000f,   //  5677: sin(31.1846924)
   0.5178804825624276900000000000f,   //  5678: sin(31.1901855)
   0.5179624957097136400000000000f,   //  5679: sin(31.1956787)
   0.5180445040959993400000000000f,   //  5680: sin(31.2011719)
   0.5181265077205312600000000000f,   //  5681: sin(31.2066650)
   0.5182085065825554600000000000f,   //  5682: sin(31.2121582)
   0.5182905006813183200000000000f,   //  5683: sin(31.2176514)
   0.5183724900160661100000000000f,   //  5684: sin(31.2231445)
   0.5184544745860452100000000000f,   //  5685: sin(31.2286377)
   0.5185364543905022200000000000f,   //  5686: sin(31.2341309)
   0.5186184294286831900000000000f,   //  5687: sin(31.2396240)
   0.5187003996998349500000000000f,   //  5688: sin(31.2451172)
   0.5187823652032040900000000000f,   //  5689: sin(31.2506104)
   0.5188643259380368900000000000f,   //  5690: sin(31.2561035)
   0.5189462819035803900000000000f,   //  5691: sin(31.2615967)
   0.5190282330990808600000000000f,   //  5692: sin(31.2670898)
   0.5191101795237851300000000000f,   //  5693: sin(31.2725830)
   0.5191921211769402500000000000f,   //  5694: sin(31.2780762)
   0.5192740580577927000000000000f,   //  5695: sin(31.2835693)
   0.5193559901655896400000000000f,   //  5696: sin(31.2890625)
   0.5194379174995775700000000000f,   //  5697: sin(31.2945557)
   0.5195198400590037600000000000f,   //  5698: sin(31.3000488)
   0.5196017578431150200000000000f,   //  5699: sin(31.3055420)
   0.5196836708511584100000000000f,   //  5700: sin(31.3110352)
   0.5197655790823811900000000000f,   //  5701: sin(31.3165283)
   0.5198474825360301900000000000f,   //  5702: sin(31.3220215)
   0.5199293812113527900000000000f,   //  5703: sin(31.3275146)
   0.5200112751075960400000000000f,   //  5704: sin(31.3330078)
   0.5200931642240072000000000000f,   //  5705: sin(31.3385010)
   0.5201750485598337600000000000f,   //  5706: sin(31.3439941)
   0.5202569281143227800000000000f,   //  5707: sin(31.3494873)
   0.5203388028867219600000000000f,   //  5708: sin(31.3549805)
   0.5204206728762783600000000000f,   //  5709: sin(31.3604736)
   0.5205025380822396700000000000f,   //  5710: sin(31.3659668)
   0.5205843985038535200000000000f,   //  5711: sin(31.3714600)
   0.5206662541403671600000000000f,   //  5712: sin(31.3769531)
   0.5207481049910284200000000000f,   //  5713: sin(31.3824463)
   0.5208299510550846700000000000f,   //  5714: sin(31.3879395)
   0.5209117923317839700000000000f,   //  5715: sin(31.3934326)
   0.5209936288203739200000000000f,   //  5716: sin(31.3989258)
   0.5210754605201021200000000000f,   //  5717: sin(31.4044189)
   0.5211572874302166100000000000f,   //  5718: sin(31.4099121)
   0.5212391095499651100000000000f,   //  5719: sin(31.4154053)
   0.5213209268785956600000000000f,   //  5720: sin(31.4208984)
   0.5214027394153560900000000000f,   //  5721: sin(31.4263916)
   0.5214845471594943300000000000f,   //  5722: sin(31.4318848)
   0.5215663501102587600000000000f,   //  5723: sin(31.4373779)
   0.5216481482668970900000000000f,   //  5724: sin(31.4428711)
   0.5217299416286577100000000000f,   //  5725: sin(31.4483643)
   0.5218117301947885500000000000f,   //  5726: sin(31.4538574)
   0.5218935139645379800000000000f,   //  5727: sin(31.4593506)
   0.5219752929371543900000000000f,   //  5728: sin(31.4648438)
   0.5220570671118857100000000000f,   //  5729: sin(31.4703369)
   0.5221388364879807600000000000f,   //  5730: sin(31.4758301)
   0.5222206010646874800000000000f,   //  5731: sin(31.4813232)
   0.5223023608412545900000000000f,   //  5732: sin(31.4868164)
   0.5223841158169305600000000000f,   //  5733: sin(31.4923096)
   0.5224658659909637800000000000f,   //  5734: sin(31.4978027)
   0.5225476113626029700000000000f,   //  5735: sin(31.5032959)
   0.5226293519310966100000000000f,   //  5736: sin(31.5087891)
   0.5227110876956934100000000000f,   //  5737: sin(31.5142822)
   0.5227928186556420900000000000f,   //  5738: sin(31.5197754)
   0.5228745448101913600000000000f,   //  5739: sin(31.5252686)
   0.5229562661585901400000000000f,   //  5740: sin(31.5307617)
   0.5230379827000870600000000000f,   //  5741: sin(31.5362549)
   0.5231196944339312500000000000f,   //  5742: sin(31.5417480)
   0.5232014013593713200000000000f,   //  5743: sin(31.5472412)
   0.5232831034756564300000000000f,   //  5744: sin(31.5527344)
   0.5233648007820356200000000000f,   //  5745: sin(31.5582275)
   0.5234464932777578300000000000f,   //  5746: sin(31.5637207)
   0.5235281809620722100000000000f,   //  5747: sin(31.5692139)
   0.5236098638342279200000000000f,   //  5748: sin(31.5747070)
   0.5236915418934741100000000000f,   //  5749: sin(31.5802002)
   0.5237732151390601700000000000f,   //  5750: sin(31.5856934)
   0.5238548835702351300000000000f,   //  5751: sin(31.5911865)
   0.5239365471862486000000000000f,   //  5752: sin(31.5966797)
   0.5240182059863496300000000000f,   //  5753: sin(31.6021729)
   0.5240998599697877000000000000f,   //  5754: sin(31.6076660)
   0.5241815091358125200000000000f,   //  5755: sin(31.6131592)
   0.5242631534836733600000000000f,   //  5756: sin(31.6186523)
   0.5243447930126198300000000000f,   //  5757: sin(31.6241455)
   0.5244264277219014000000000000f,   //  5758: sin(31.6296387)
   0.5245080576107679100000000000f,   //  5759: sin(31.6351318)
   0.5245896826784689500000000000f,   //  5760: sin(31.6406250)
   0.5246713029242540100000000000f,   //  5761: sin(31.6461182)
   0.5247529183473733600000000000f,   //  5762: sin(31.6516113)
   0.5248345289470762700000000000f,   //  5763: sin(31.6571045)
   0.5249161347226130000000000000f,   //  5764: sin(31.6625977)
   0.5249977356732331600000000000f,   //  5765: sin(31.6680908)
   0.5250793317981867800000000000f,   //  5766: sin(31.6735840)
   0.5251609230967240200000000000f,   //  5767: sin(31.6790771)
   0.5252425095680947100000000000f,   //  5768: sin(31.6845703)
   0.5253240912115489900000000000f,   //  5769: sin(31.6900635)
   0.5254056680263369300000000000f,   //  5770: sin(31.6955566)
   0.5254872400117086600000000000f,   //  5771: sin(31.7010498)
   0.5255688071669146800000000000f,   //  5772: sin(31.7065430)
   0.5256503694912048100000000000f,   //  5773: sin(31.7120361)
   0.5257319269838297600000000000f,   //  5774: sin(31.7175293)
   0.5258134796440394600000000000f,   //  5775: sin(31.7230225)
   0.5258950274710846300000000000f,   //  5776: sin(31.7285156)
   0.5259765704642156400000000000f,   //  5777: sin(31.7340088)
   0.5260581086226827600000000000f,   //  5778: sin(31.7395020)
   0.5261396419457368100000000000f,   //  5779: sin(31.7449951)
   0.5262211704326280600000000000f,   //  5780: sin(31.7504883)
   0.5263026940826072100000000000f,   //  5781: sin(31.7559814)
   0.5263842128949251000000000000f,   //  5782: sin(31.7614746)
   0.5264657268688322000000000000f,   //  5783: sin(31.7669678)
   0.5265472360035794400000000000f,   //  5784: sin(31.7724609)
   0.5266287402984173300000000000f,   //  5785: sin(31.7779541)
   0.5267102397525970100000000000f,   //  5786: sin(31.7834473)
   0.5267917343653690800000000000f,   //  5787: sin(31.7889404)
   0.5268732241359845900000000000f,   //  5788: sin(31.7944336)
   0.5269547090636946800000000000f,   //  5789: sin(31.7999268)
   0.5270361891477500800000000000f,   //  5790: sin(31.8054199)
   0.5271176643874019300000000000f,   //  5791: sin(31.8109131)
   0.5271991347819012800000000000f,   //  5792: sin(31.8164063)
   0.5272806003304993900000000000f,   //  5793: sin(31.8218994)
   0.5273620610324475400000000000f,   //  5794: sin(31.8273926)
   0.5274435168869966400000000000f,   //  5795: sin(31.8328857)
   0.5275249678933982000000000000f,   //  5796: sin(31.8383789)
   0.5276064140509033600000000000f,   //  5797: sin(31.8438721)
   0.5276878553587637200000000000f,   //  5798: sin(31.8493652)
   0.5277692918162305600000000000f,   //  5799: sin(31.8548584)
   0.5278507234225552300000000000f,   //  5800: sin(31.8603516)
   0.5279321501769895800000000000f,   //  5801: sin(31.8658447)
   0.5280135720787846300000000000f,   //  5802: sin(31.8713379)
   0.5280949891271924400000000000f,   //  5803: sin(31.8768311)
   0.5281764013214643700000000000f,   //  5804: sin(31.8823242)
   0.5282578086608521500000000000f,   //  5805: sin(31.8878174)
   0.5283392111446076900000000000f,   //  5806: sin(31.8933105)
   0.5284206087719824900000000000f,   //  5807: sin(31.8988037)
   0.5285020015422284800000000000f,   //  5808: sin(31.9042969)
   0.5285833894545974900000000000f,   //  5809: sin(31.9097900)
   0.5286647725083413200000000000f,   //  5810: sin(31.9152832)
   0.5287461507027122500000000000f,   //  5811: sin(31.9207764)
   0.5288275240369618700000000000f,   //  5812: sin(31.9262695)
   0.5289088925103425700000000000f,   //  5813: sin(31.9317627)
   0.5289902561221060400000000000f,   //  5814: sin(31.9372559)
   0.5290716148715046700000000000f,   //  5815: sin(31.9427490)
   0.5291529687577906100000000000f,   //  5816: sin(31.9482422)
   0.5292343177802160100000000000f,   //  5817: sin(31.9537354)
   0.5293156619380332600000000000f,   //  5818: sin(31.9592285)
   0.5293970012304943800000000000f,   //  5819: sin(31.9647217)
   0.5294783356568519800000000000f,   //  5820: sin(31.9702148)
   0.5295596652163583300000000000f,   //  5821: sin(31.9757080)
   0.5296409899082659100000000000f,   //  5822: sin(31.9812012)
   0.5297223097318272100000000000f,   //  5823: sin(31.9866943)
   0.5298036246862946100000000000f,   //  5824: sin(31.9921875)
   0.5298849347709209100000000000f,   //  5825: sin(31.9976807)
   0.5299662399849586200000000000f,   //  5826: sin(32.0031738)
   0.5300475403276603300000000000f,   //  5827: sin(32.0086670)
   0.5301288357982789600000000000f,   //  5828: sin(32.0141602)
   0.5302101263960669100000000000f,   //  5829: sin(32.0196533)
   0.5302914121202773100000000000f,   //  5830: sin(32.0251465)
   0.5303726929701627600000000000f,   //  5831: sin(32.0306396)
   0.5304539689449763200000000000f,   //  5832: sin(32.0361328)
   0.5305352400439709000000000000f,   //  5833: sin(32.0416260)
   0.5306165062663993300000000000f,   //  5834: sin(32.0471191)
   0.5306977676115147700000000000f,   //  5835: sin(32.0526123)
   0.5307790240785701400000000000f,   //  5836: sin(32.0581055)
   0.5308602756668187000000000000f,   //  5837: sin(32.0635986)
   0.5309415223755136200000000000f,   //  5838: sin(32.0690918)
   0.5310227642039079300000000000f,   //  5839: sin(32.0745850)
   0.5311040011512550000000000000f,   //  5840: sin(32.0800781)
   0.5311852332168079900000000000f,   //  5841: sin(32.0855713)
   0.5312664603998203900000000000f,   //  5842: sin(32.0910645)
   0.5313476826995455800000000000f,   //  5843: sin(32.0965576)
   0.5314289001152368000000000000f,   //  5844: sin(32.1020508)
   0.5315101126461476700000000000f,   //  5845: sin(32.1075439)
   0.5315913202915316700000000000f,   //  5846: sin(32.1130371)
   0.5316725230506422800000000000f,   //  5847: sin(32.1185303)
   0.5317537209227333200000000000f,   //  5848: sin(32.1240234)
   0.5318349139070581700000000000f,   //  5849: sin(32.1295166)
   0.5319161020028706500000000000f,   //  5850: sin(32.1350098)
   0.5319972852094244600000000000f,   //  5851: sin(32.1405029)
   0.5320784635259735400000000000f,   //  5852: sin(32.1459961)
   0.5321596369517714900000000000f,   //  5853: sin(32.1514893)
   0.5322408054860722200000000000f,   //  5854: sin(32.1569824)
   0.5323219691281297900000000000f,   //  5855: sin(32.1624756)
   0.5324031278771979000000000000f,   //  5856: sin(32.1679688)
   0.5324842817325309300000000000f,   //  5857: sin(32.1734619)
   0.5325654306933825800000000000f,   //  5858: sin(32.1789551)
   0.5326465747590071200000000000f,   //  5859: sin(32.1844482)
   0.5327277139286588100000000000f,   //  5860: sin(32.1899414)
   0.5328088482015915800000000000f,   //  5861: sin(32.1954346)
   0.5328899775770598000000000000f,   //  5862: sin(32.2009277)
   0.5329711020543176400000000000f,   //  5863: sin(32.2064209)
   0.5330522216326194500000000000f,   //  5864: sin(32.2119141)
   0.5331333363112198400000000000f,   //  5865: sin(32.2174072)
   0.5332144460893729600000000000f,   //  5866: sin(32.2229004)
   0.5332955509663333000000000000f,   //  5867: sin(32.2283936)
   0.5333766509413553300000000000f,   //  5868: sin(32.2338867)
   0.5334577460136937800000000000f,   //  5869: sin(32.2393799)
   0.5335388361826031200000000000f,   //  5870: sin(32.2448730)
   0.5336199214473378300000000000f,   //  5871: sin(32.2503662)
   0.5337010018071529600000000000f,   //  5872: sin(32.2558594)
   0.5337820772613028900000000000f,   //  5873: sin(32.2613525)
   0.5338631478090426500000000000f,   //  5874: sin(32.2668457)
   0.5339442134496268400000000000f,   //  5875: sin(32.2723389)
   0.5340252741823103800000000000f,   //  5876: sin(32.2778320)
   0.5341063300063483300000000000f,   //  5877: sin(32.2833252)
   0.5341873809209953800000000000f,   //  5878: sin(32.2888184)
   0.5342684269255068000000000000f,   //  5879: sin(32.2943115)
   0.5343494680191375200000000000f,   //  5880: sin(32.2998047)
   0.5344305042011424600000000000f,   //  5881: sin(32.3052979)
   0.5345115354707771200000000000f,   //  5882: sin(32.3107910)
   0.5345925618272963100000000000f,   //  5883: sin(32.3162842)
   0.5346735832699555100000000000f,   //  5884: sin(32.3217773)
   0.5347545997980097700000000000f,   //  5885: sin(32.3272705)
   0.5348356114107145600000000000f,   //  5886: sin(32.3327637)
   0.5349166181073252700000000000f,   //  5887: sin(32.3382568)
   0.5349976198870971500000000000f,   //  5888: sin(32.3437500)
   0.5350786167492858100000000000f,   //  5889: sin(32.3492432)
   0.5351596086931466000000000000f,   //  5890: sin(32.3547363)
   0.5352405957179351400000000000f,   //  5891: sin(32.3602295)
   0.5353215778229071200000000000f,   //  5892: sin(32.3657227)
   0.5354025550073178200000000000f,   //  5893: sin(32.3712158)
   0.5354835272704233700000000000f,   //  5894: sin(32.3767090)
   0.5355644946114791500000000000f,   //  5895: sin(32.3822021)
   0.5356454570297410900000000000f,   //  5896: sin(32.3876953)
   0.5357264145244649000000000000f,   //  5897: sin(32.3931885)
   0.5358073670949063900000000000f,   //  5898: sin(32.3986816)
   0.5358883147403218400000000000f,   //  5899: sin(32.4041748)
   0.5359692574599667100000000000f,   //  5900: sin(32.4096680)
   0.5360501952530972700000000000f,   //  5901: sin(32.4151611)
   0.5361311281189694600000000000f,   //  5902: sin(32.4206543)
   0.5362120560568393000000000000f,   //  5903: sin(32.4261475)
   0.5362929790659631800000000000f,   //  5904: sin(32.4316406)
   0.5363738971455969100000000000f,   //  5905: sin(32.4371338)
   0.5364548102949970900000000000f,   //  5906: sin(32.4426270)
   0.5365357185134196300000000000f,   //  5907: sin(32.4481201)
   0.5366166218001210400000000000f,   //  5908: sin(32.4536133)
   0.5366975201543576800000000000f,   //  5909: sin(32.4591064)
   0.5367784135753859200000000000f,   //  5910: sin(32.4645996)
   0.5368593020624622400000000000f,   //  5911: sin(32.4700928)
   0.5369401856148429100000000000f,   //  5912: sin(32.4755859)
   0.5370210642317846400000000000f,   //  5913: sin(32.4810791)
   0.5371019379125441300000000000f,   //  5914: sin(32.4865723)
   0.5371828066563778500000000000f,   //  5915: sin(32.4920654)
   0.5372636704625425300000000000f,   //  5916: sin(32.4975586)
   0.5373445293302947500000000000f,   //  5917: sin(32.5030518)
   0.5374253832588915500000000000f,   //  5918: sin(32.5085449)
   0.5375062322475894200000000000f,   //  5919: sin(32.5140381)
   0.5375870762956453900000000000f,   //  5920: sin(32.5195313)
   0.5376679154023165100000000000f,   //  5921: sin(32.5250244)
   0.5377487495668593600000000000f,   //  5922: sin(32.5305176)
   0.5378295787885312200000000000f,   //  5923: sin(32.5360107)
   0.5379104030665888800000000000f,   //  5924: sin(32.5415039)
   0.5379912224002896300000000000f,   //  5925: sin(32.5469971)
   0.5380720367888906000000000000f,   //  5926: sin(32.5524902)
   0.5381528462316488300000000000f,   //  5927: sin(32.5579834)
   0.5382336507278217000000000000f,   //  5928: sin(32.5634766)
   0.5383144502766662500000000000f,   //  5929: sin(32.5689697)
   0.5383952448774399500000000000f,   //  5930: sin(32.5744629)
   0.5384760345294001800000000000f,   //  5931: sin(32.5799561)
   0.5385568192318041000000000000f,   //  5932: sin(32.5854492)
   0.5386375989839095000000000000f,   //  5933: sin(32.5909424)
   0.5387183737849735600000000000f,   //  5934: sin(32.5964355)
   0.5387991436342539600000000000f,   //  5935: sin(32.6019287)
   0.5388799085310084200000000000f,   //  5936: sin(32.6074219)
   0.5389606684744943100000000000f,   //  5937: sin(32.6129150)
   0.5390414234639694400000000000f,   //  5938: sin(32.6184082)
   0.5391221734986915100000000000f,   //  5939: sin(32.6239014)
   0.5392029185779182400000000000f,   //  5940: sin(32.6293945)
   0.5392836587009074400000000000f,   //  5941: sin(32.6348877)
   0.5393643938669170400000000000f,   //  5942: sin(32.6403809)
   0.5394451240752049500000000000f,   //  5943: sin(32.6458740)
   0.5395258493250288900000000000f,   //  5944: sin(32.6513672)
   0.5396065696156472400000000000f,   //  5945: sin(32.6568604)
   0.5396872849463175700000000000f,   //  5946: sin(32.6623535)
   0.5397679953162983800000000000f,   //  5947: sin(32.6678467)
   0.5398487007248475900000000000f,   //  5948: sin(32.6733398)
   0.5399294011712233400000000000f,   //  5949: sin(32.6788330)
   0.5400100966546840200000000000f,   //  5950: sin(32.6843262)
   0.5400907871744877700000000000f,   //  5951: sin(32.6898193)
   0.5401714727298928500000000000f,   //  5952: sin(32.6953125)
   0.5402521533201577500000000000f,   //  5953: sin(32.7008057)
   0.5403328289445407100000000000f,   //  5954: sin(32.7062988)
   0.5404134996023004500000000000f,   //  5955: sin(32.7117920)
   0.5404941652926952300000000000f,   //  5956: sin(32.7172852)
   0.5405748260149835200000000000f,   //  5957: sin(32.7227783)
   0.5406554817684241500000000000f,   //  5958: sin(32.7282715)
   0.5407361325522755900000000000f,   //  5959: sin(32.7337646)
   0.5408167783657966700000000000f,   //  5960: sin(32.7392578)
   0.5408974192082458600000000000f,   //  5961: sin(32.7447510)
   0.5409780550788820800000000000f,   //  5962: sin(32.7502441)
   0.5410586859769641600000000000f,   //  5963: sin(32.7557373)
   0.5411393119017508000000000000f,   //  5964: sin(32.7612305)
   0.5412199328525012500000000000f,   //  5965: sin(32.7667236)
   0.5413005488284741200000000000f,   //  5966: sin(32.7722168)
   0.5413811598289285400000000000f,   //  5967: sin(32.7777100)
   0.5414617658531234400000000000f,   //  5968: sin(32.7832031)
   0.5415423669003181000000000000f,   //  5969: sin(32.7886963)
   0.5416229629697715300000000000f,   //  5970: sin(32.7941895)
   0.5417035540607428900000000000f,   //  5971: sin(32.7996826)
   0.5417841401724915500000000000f,   //  5972: sin(32.8051758)
   0.5418647213042765400000000000f,   //  5973: sin(32.8106689)
   0.5419452974553573600000000000f,   //  5974: sin(32.8161621)
   0.5420258686249934700000000000f,   //  5975: sin(32.8216553)
   0.5421064348124439200000000000f,   //  5976: sin(32.8271484)
   0.5421869960169685100000000000f,   //  5977: sin(32.8326416)
   0.5422675522378265200000000000f,   //  5978: sin(32.8381348)
   0.5423481034742775300000000000f,   //  5979: sin(32.8436279)
   0.5424286497255812500000000000f,   //  5980: sin(32.8491211)
   0.5425091909909972600000000000f,   //  5981: sin(32.8546143)
   0.5425897272697852700000000000f,   //  5982: sin(32.8601074)
   0.5426702585612047700000000000f,   //  5983: sin(32.8656006)
   0.5427507848645158900000000000f,   //  5984: sin(32.8710938)
   0.5428313061789782300000000000f,   //  5985: sin(32.8765869)
   0.5429118225038517300000000000f,   //  5986: sin(32.8820801)
   0.5429923338383962900000000000f,   //  5987: sin(32.8875732)
   0.5430728401818717400000000000f,   //  5988: sin(32.8930664)
   0.5431533415335383400000000000f,   //  5989: sin(32.8985596)
   0.5432338378926558900000000000f,   //  5990: sin(32.9040527)
   0.5433143292584846600000000000f,   //  5991: sin(32.9095459)
   0.5433948156302848000000000000f,   //  5992: sin(32.9150391)
   0.5434752970073163400000000000f,   //  5993: sin(32.9205322)
   0.5435557733888395400000000000f,   //  5994: sin(32.9260254)
   0.5436362447741147600000000000f,   //  5995: sin(32.9315186)
   0.5437167111624022800000000000f,   //  5996: sin(32.9370117)
   0.5437971725529626700000000000f,   //  5997: sin(32.9425049)
   0.5438776289450559800000000000f,   //  5998: sin(32.9479980)
   0.5439580803379429100000000000f,   //  5999: sin(32.9534912)
   0.5440385267308838200000000000f,   //  6000: sin(32.9589844)
   0.5441189681231394200000000000f,   //  6001: sin(32.9644775)
   0.5441994045139703100000000000f,   //  6002: sin(32.9699707)
   0.5442798359026370700000000000f,   //  6003: sin(32.9754639)
   0.5443602622884004000000000000f,   //  6004: sin(32.9809570)
   0.5444406836705209000000000000f,   //  6005: sin(32.9864502)
   0.5445211000482596000000000000f,   //  6006: sin(32.9919434)
   0.5446015114208772000000000000f,   //  6007: sin(32.9974365)
   0.5446819177876345300000000000f,   //  6008: sin(33.0029297)
   0.5447623191477926100000000000f,   //  6009: sin(33.0084229)
   0.5448427155006123600000000000f,   //  6010: sin(33.0139160)
   0.5449231068453549400000000000f,   //  6011: sin(33.0194092)
   0.5450034931812811600000000000f,   //  6012: sin(33.0249023)
   0.5450838745076521700000000000f,   //  6013: sin(33.0303955)
   0.5451642508237293200000000000f,   //  6014: sin(33.0358887)
   0.5452446221287735600000000000f,   //  6015: sin(33.0413818)
   0.5453249884220464600000000000f,   //  6016: sin(33.0468750)
   0.5454053497028089600000000000f,   //  6017: sin(33.0523682)
   0.5454857059703225300000000000f,   //  6018: sin(33.0578613)
   0.5455660572238486500000000000f,   //  6019: sin(33.0633545)
   0.5456464034626485900000000000f,   //  6020: sin(33.0688477)
   0.5457267446859839200000000000f,   //  6021: sin(33.0743408)
   0.5458070808931161400000000000f,   //  6022: sin(33.0798340)
   0.5458874120833068200000000000f,   //  6023: sin(33.0853271)
   0.5459677382558175700000000000f,   //  6024: sin(33.0908203)
   0.5460480594099099700000000000f,   //  6025: sin(33.0963135)
   0.5461283755448459500000000000f,   //  6026: sin(33.1018066)
   0.5462086866598870900000000000f,   //  6027: sin(33.1072998)
   0.5462889927542952100000000000f,   //  6028: sin(33.1127930)
   0.5463692938273320100000000000f,   //  6029: sin(33.1182861)
   0.5464495898782596500000000000f,   //  6030: sin(33.1237793)
   0.5465298809063400300000000000f,   //  6031: sin(33.1292725)
   0.5466101669108348600000000000f,   //  6032: sin(33.1347656)
   0.5466904478910065100000000000f,   //  6033: sin(33.1402588)
   0.5467707238461168000000000000f,   //  6034: sin(33.1457520)
   0.5468509947754278700000000000f,   //  6035: sin(33.1512451)
   0.5469312606782021900000000000f,   //  6036: sin(33.1567383)
   0.5470115215537014700000000000f,   //  6037: sin(33.1622314)
   0.5470917774011885300000000000f,   //  6038: sin(33.1677246)
   0.5471720282199251700000000000f,   //  6039: sin(33.1732178)
   0.5472522740091740900000000000f,   //  6040: sin(33.1787109)
   0.5473325147681975500000000000f,   //  6041: sin(33.1842041)
   0.5474127504962579300000000000f,   //  6042: sin(33.1896973)
   0.5474929811926179100000000000f,   //  6043: sin(33.1951904)
   0.5475732068565397600000000000f,   //  6044: sin(33.2006836)
   0.5476534274872862900000000000f,   //  6045: sin(33.2061768)
   0.5477336430841200900000000000f,   //  6046: sin(33.2116699)
   0.5478138536463037500000000000f,   //  6047: sin(33.2171631)
   0.5478940591731001900000000000f,   //  6048: sin(33.2226563)
   0.5479742596637718900000000000f,   //  6049: sin(33.2281494)
   0.5480544551175818800000000000f,   //  6050: sin(33.2336426)
   0.5481346455337928700000000000f,   //  6051: sin(33.2391357)
   0.5482148309116677800000000000f,   //  6052: sin(33.2446289)
   0.5482950112504697500000000000f,   //  6053: sin(33.2501221)
   0.5483751865494616000000000000f,   //  6054: sin(33.2556152)
   0.5484553568079064700000000000f,   //  6055: sin(33.2611084)
   0.5485355220250673900000000000f,   //  6056: sin(33.2666016)
   0.5486156822002075100000000000f,   //  6057: sin(33.2720947)
   0.5486958373325900900000000000f,   //  6058: sin(33.2775879)
   0.5487759874214781500000000000f,   //  6059: sin(33.2830811)
   0.5488561324661352900000000000f,   //  6060: sin(33.2885742)
   0.5489362724658245500000000000f,   //  6061: sin(33.2940674)
   0.5490164074198093900000000000f,   //  6062: sin(33.2995605)
   0.5490965373273533100000000000f,   //  6063: sin(33.3050537)
   0.5491766621877196600000000000f,   //  6064: sin(33.3105469)
   0.5492567820001721400000000000f,   //  6065: sin(33.3160400)
   0.5493368967639740100000000000f,   //  6066: sin(33.3215332)
   0.5494170064783889800000000000f,   //  6067: sin(33.3270264)
   0.5494971111426809600000000000f,   //  6068: sin(33.3325195)
   0.5495772107561132100000000000f,   //  6069: sin(33.3380127)
   0.5496573053179498700000000000f,   //  6070: sin(33.3435059)
   0.5497373948274544300000000000f,   //  6071: sin(33.3489990)
   0.5498174792838909100000000000f,   //  6072: sin(33.3544922)
   0.5498975586865231200000000000f,   //  6073: sin(33.3599854)
   0.5499776330346148900000000000f,   //  6074: sin(33.3654785)
   0.5500577023274304500000000000f,   //  6075: sin(33.3709717)
   0.5501377665642336300000000000f,   //  6076: sin(33.3764648)
   0.5502178257442884600000000000f,   //  6077: sin(33.3819580)
   0.5502978798668591900000000000f,   //  6078: sin(33.3874512)
   0.5503779289312098500000000000f,   //  6079: sin(33.3929443)
   0.5504579729366048100000000000f,   //  6080: sin(33.3984375)
   0.5505380118823081100000000000f,   //  6081: sin(33.4039307)
   0.5506180457675843300000000000f,   //  6082: sin(33.4094238)
   0.5506980745916975100000000000f,   //  6083: sin(33.4149170)
   0.5507780983539121200000000000f,   //  6084: sin(33.4204102)
   0.5508581170534928600000000000f,   //  6085: sin(33.4259033)
   0.5509381306897038800000000000f,   //  6086: sin(33.4313965)
   0.5510181392618098700000000000f,   //  6087: sin(33.4368896)
   0.5510981427690754300000000000f,   //  6088: sin(33.4423828)
   0.5511781412107650300000000000f,   //  6089: sin(33.4478760)
   0.5512581345861435900000000000f,   //  6090: sin(33.4533691)
   0.5513381228944755900000000000f,   //  6091: sin(33.4588623)
   0.5514181061350260600000000000f,   //  6092: sin(33.4643555)
   0.5514980843070594900000000000f,   //  6093: sin(33.4698486)
   0.5515780574098410000000000000f,   //  6094: sin(33.4753418)
   0.5516580254426352000000000000f,   //  6095: sin(33.4808350)
   0.5517379884047073400000000000f,   //  6096: sin(33.4863281)
   0.5518179462953224400000000000f,   //  6097: sin(33.4918213)
   0.5518978991137452100000000000f,   //  6098: sin(33.4973145)
   0.5519778468592411200000000000f,   //  6099: sin(33.5028076)
   0.5520577895310749800000000000f,   //  6100: sin(33.5083008)
   0.5521377271285121700000000000f,   //  6101: sin(33.5137939)
   0.5522176596508179300000000000f,   //  6102: sin(33.5192871)
   0.5522975870972574000000000000f,   //  6103: sin(33.5247803)
   0.5523775094670960700000000000f,   //  6104: sin(33.5302734)
   0.5524574267595990800000000000f,   //  6105: sin(33.5357666)
   0.5525373389740321200000000000f,   //  6106: sin(33.5412598)
   0.5526172461096605600000000000f,   //  6107: sin(33.5467529)
   0.5526971481657497700000000000f,   //  6108: sin(33.5522461)
   0.5527770451415655600000000000f,   //  6109: sin(33.5577393)
   0.5528569370363732900000000000f,   //  6110: sin(33.5632324)
   0.5529368238494386500000000000f,   //  6111: sin(33.5687256)
   0.5530167055800274700000000000f,   //  6112: sin(33.5742188)
   0.5530965822274054300000000000f,   //  6113: sin(33.5797119)
   0.5531764537908383500000000000f,   //  6114: sin(33.5852051)
   0.5532563202695920400000000000f,   //  6115: sin(33.5906982)
   0.5533361816629323000000000000f,   //  6116: sin(33.5961914)
   0.5534160379701251700000000000f,   //  6117: sin(33.6016846)
   0.5534958891904365700000000000f,   //  6118: sin(33.6071777)
   0.5535757353231326400000000000f,   //  6119: sin(33.6126709)
   0.5536555763674793100000000000f,   //  6120: sin(33.6181641)
   0.5537354123227427000000000000f,   //  6121: sin(33.6236572)
   0.5538152431881890900000000000f,   //  6122: sin(33.6291504)
   0.5538950689630846000000000000f,   //  6123: sin(33.6346436)
   0.5539748896466955000000000000f,   //  6124: sin(33.6401367)
   0.5540547052382881500000000000f,   //  6125: sin(33.6456299)
   0.5541345157371289100000000000f,   //  6126: sin(33.6511230)
   0.5542143211424840300000000000f,   //  6127: sin(33.6566162)
   0.5542941214536200000000000000f,   //  6128: sin(33.6621094)
   0.5543739166698036200000000000f,   //  6129: sin(33.6676025)
   0.5544537067903009300000000000f,   //  6130: sin(33.6730957)
   0.5545334918143789400000000000f,   //  6131: sin(33.6785889)
   0.5546132717413040400000000000f,   //  6132: sin(33.6840820)
   0.5546930465703429100000000000f,   //  6133: sin(33.6895752)
   0.5547728163007624700000000000f,   //  6134: sin(33.6950684)
   0.5548525809318293200000000000f,   //  6135: sin(33.7005615)
   0.5549323404628103700000000000f,   //  6136: sin(33.7060547)
   0.5550120948929723200000000000f,   //  6137: sin(33.7115479)
   0.5550918442215824200000000000f,   //  6138: sin(33.7170410)
   0.5551715884479072600000000000f,   //  6139: sin(33.7225342)
   0.5552513275712139800000000000f,   //  6140: sin(33.7280273)
   0.5553310615907698400000000000f,   //  6141: sin(33.7335205)
   0.5554107905058416300000000000f,   //  6142: sin(33.7390137)
   0.5554905143156967400000000000f,   //  6143: sin(33.7445068)
   0.5555702330196021800000000000f,   //  6144: sin(33.7500000)
   0.5556499466168253200000000000f,   //  6145: sin(33.7554932)
   0.5557296551066334100000000000f,   //  6146: sin(33.7609863)
   0.5558093584882937100000000000f,   //  6147: sin(33.7664795)
   0.5558890567610738100000000000f,   //  6148: sin(33.7719727)
   0.5559687499242409500000000000f,   //  6149: sin(33.7774658)
   0.5560484379770626000000000000f,   //  6150: sin(33.7829590)
   0.5561281209188064800000000000f,   //  6151: sin(33.7884521)
   0.5562077987487399300000000000f,   //  6152: sin(33.7939453)
   0.5562874714661307800000000000f,   //  6153: sin(33.7994385)
   0.5563671390702463700000000000f,   //  6154: sin(33.8049316)
   0.5564468015603548600000000000f,   //  6155: sin(33.8104248)
   0.5565264589357236100000000000f,   //  6156: sin(33.8159180)
   0.5566061111956206500000000000f,   //  6157: sin(33.8214111)
   0.5566857583393138900000000000f,   //  6158: sin(33.8269043)
   0.5567654003660710300000000000f,   //  6159: sin(33.8323975)
   0.5568450372751601000000000000f,   //  6160: sin(33.8378906)
   0.5569246690658490300000000000f,   //  6161: sin(33.8433838)
   0.5570042957374059500000000000f,   //  6162: sin(33.8488770)
   0.5570839172890991200000000000f,   //  6163: sin(33.8543701)
   0.5571635337201962200000000000f,   //  6164: sin(33.8598633)
   0.5572431450299659700000000000f,   //  6165: sin(33.8653564)
   0.5573227512176761600000000000f,   //  6166: sin(33.8708496)
   0.5574023522825951600000000000f,   //  6167: sin(33.8763428)
   0.5574819482239915500000000000f,   //  6168: sin(33.8818359)
   0.5575615390411333700000000000f,   //  6169: sin(33.8873291)
   0.5576411247332894200000000000f,   //  6170: sin(33.8928223)
   0.5577207052997277300000000000f,   //  6171: sin(33.8983154)
   0.5578002807397169900000000000f,   //  6172: sin(33.9038086)
   0.5578798510525259100000000000f,   //  6173: sin(33.9093018)
   0.5579594162374229600000000000f,   //  6174: sin(33.9147949)
   0.5580389762936768200000000000f,   //  6175: sin(33.9202881)
   0.5581185312205561000000000000f,   //  6176: sin(33.9257813)
   0.5581980810173297100000000000f,   //  6177: sin(33.9312744)
   0.5582776256832663300000000000f,   //  6178: sin(33.9367676)
   0.5583571652176347900000000000f,   //  6179: sin(33.9422607)
   0.5584366996197041000000000000f,   //  6180: sin(33.9477539)
   0.5585162288887429700000000000f,   //  6181: sin(33.9532471)
   0.5585957530240207600000000000f,   //  6182: sin(33.9587402)
   0.5586752720248061600000000000f,   //  6183: sin(33.9642334)
   0.5587547858903683100000000000f,   //  6184: sin(33.9697266)
   0.5588342946199764700000000000f,   //  6185: sin(33.9752197)
   0.5589137982128997700000000000f,   //  6186: sin(33.9807129)
   0.5589932966684073600000000000f,   //  6187: sin(33.9862061)
   0.5590727899857684800000000000f,   //  6188: sin(33.9916992)
   0.5591522781642525000000000000f,   //  6189: sin(33.9971924)
   0.5592317612031289000000000000f,   //  6190: sin(34.0026855)
   0.5593112391016669100000000000f,   //  6191: sin(34.0081787)
   0.5593907118591361400000000000f,   //  6192: sin(34.0136719)
   0.5594701794748058200000000000f,   //  6193: sin(34.0191650)
   0.5595496419479457600000000000f,   //  6194: sin(34.0246582)
   0.5596290992778255600000000000f,   //  6195: sin(34.0301514)
   0.5597085514637146800000000000f,   //  6196: sin(34.0356445)
   0.5597879985048831400000000000f,   //  6197: sin(34.0411377)
   0.5598674404006002100000000000f,   //  6198: sin(34.0466309)
   0.5599468771501361400000000000f,   //  6199: sin(34.0521240)
   0.5600263087527603800000000000f,   //  6200: sin(34.0576172)
   0.5601057352077429800000000000f,   //  6201: sin(34.0631104)
   0.5601851565143540800000000000f,   //  6202: sin(34.0686035)
   0.5602645726718632500000000000f,   //  6203: sin(34.0740967)
   0.5603439836795408600000000000f,   //  6204: sin(34.0795898)
   0.5604233895366567100000000000f,   //  6205: sin(34.0850830)
   0.5605027902424810600000000000f,   //  6206: sin(34.0905762)
   0.5605821857962841600000000000f,   //  6207: sin(34.0960693)
   0.5606615761973360300000000000f,   //  6208: sin(34.1015625)
   0.5607409614449070400000000000f,   //  6209: sin(34.1070557)
   0.5608203415382674300000000000f,   //  6210: sin(34.1125488)
   0.5608997164766876800000000000f,   //  6211: sin(34.1180420)
   0.5609790862594381500000000000f,   //  6212: sin(34.1235352)
   0.5610584508857892100000000000f,   //  6213: sin(34.1290283)
   0.5611378103550114200000000000f,   //  6214: sin(34.1345215)
   0.5612171646663752800000000000f,   //  6215: sin(34.1400146)
   0.5612965138191514700000000000f,   //  6216: sin(34.1455078)
   0.5613758578126105700000000000f,   //  6217: sin(34.1510010)
   0.5614551966460232800000000000f,   //  6218: sin(34.1564941)
   0.5615345303186603000000000000f,   //  6219: sin(34.1619873)
   0.5616138588297924200000000000f,   //  6220: sin(34.1674805)
   0.5616931821786905800000000000f,   //  6221: sin(34.1729736)
   0.5617725003646253400000000000f,   //  6222: sin(34.1784668)
   0.5618518133868679600000000000f,   //  6223: sin(34.1839600)
   0.5619311212446894700000000000f,   //  6224: sin(34.1894531)
   0.5620104239373604500000000000f,   //  6225: sin(34.1949463)
   0.5620897214641524800000000000f,   //  6226: sin(34.2004395)
   0.5621690138243362600000000000f,   //  6227: sin(34.2059326)
   0.5622483010171831500000000000f,   //  6228: sin(34.2114258)
   0.5623275830419644000000000000f,   //  6229: sin(34.2169189)
   0.5624068598979511400000000000f,   //  6230: sin(34.2224121)
   0.5624861315844147400000000000f,   //  6231: sin(34.2279053)
   0.5625653981006265600000000000f,   //  6232: sin(34.2333984)
   0.5626446594458578400000000000f,   //  6233: sin(34.2388916)
   0.5627239156193804000000000000f,   //  6234: sin(34.2443848)
   0.5628031666204653700000000000f,   //  6235: sin(34.2498779)
   0.5628824124483844400000000000f,   //  6236: sin(34.2553711)
   0.5629616531024092000000000000f,   //  6237: sin(34.2608643)
   0.5630408885818112300000000000f,   //  6238: sin(34.2663574)
   0.5631201188858623300000000000f,   //  6239: sin(34.2718506)
   0.5631993440138340900000000000f,   //  6240: sin(34.2773438)
   0.5632785639649984200000000000f,   //  6241: sin(34.2828369)
   0.5633577787386270200000000000f,   //  6242: sin(34.2883301)
   0.5634369883339919200000000000f,   //  6243: sin(34.2938232)
   0.5635161927503648000000000000f,   //  6244: sin(34.2993164)
   0.5635953919870179100000000000f,   //  6245: sin(34.3048096)
   0.5636745860432230700000000000f,   //  6246: sin(34.3103027)
   0.5637537749182524000000000000f,   //  6247: sin(34.3157959)
   0.5638329586113781700000000000f,   //  6248: sin(34.3212891)
   0.5639121371218722700000000000f,   //  6249: sin(34.3267822)
   0.5639913104490069700000000000f,   //  6250: sin(34.3322754)
   0.5640704785920547200000000000f,   //  6251: sin(34.3377686)
   0.5641496415502876800000000000f,   //  6252: sin(34.3432617)
   0.5642287993229782000000000000f,   //  6253: sin(34.3487549)
   0.5643079519093986400000000000f,   //  6254: sin(34.3542480)
   0.5643870993088215800000000000f,   //  6255: sin(34.3597412)
   0.5644662415205195000000000000f,   //  6256: sin(34.3652344)
   0.5645453785437647400000000000f,   //  6257: sin(34.3707275)
   0.5646245103778301200000000000f,   //  6258: sin(34.3762207)
   0.5647036370219880000000000000f,   //  6259: sin(34.3817139)
   0.5647827584755114000000000000f,   //  6260: sin(34.3872070)
   0.5648618747376729100000000000f,   //  6261: sin(34.3927002)
   0.5649409858077452100000000000f,   //  6262: sin(34.3981934)
   0.5650200916850013400000000000f,   //  6263: sin(34.4036865)
   0.5650991923687139800000000000f,   //  6264: sin(34.4091797)
   0.5651782878581562700000000000f,   //  6265: sin(34.4146729)
   0.5652573781526008000000000000f,   //  6266: sin(34.4201660)
   0.5653364632513209200000000000f,   //  6267: sin(34.4256592)
   0.5654155431535896600000000000f,   //  6268: sin(34.4311523)
   0.5654946178586800500000000000f,   //  6269: sin(34.4366455)
   0.5655736873658653300000000000f,   //  6270: sin(34.4421387)
   0.5656527516744185300000000000f,   //  6271: sin(34.4476318)
   0.5657318107836131200000000000f,   //  6272: sin(34.4531250)
   0.5658108646927224600000000000f,   //  6273: sin(34.4586182)
   0.5658899134010195700000000000f,   //  6274: sin(34.4641113)
   0.5659689569077781500000000000f,   //  6275: sin(34.4696045)
   0.5660479952122714500000000000f,   //  6276: sin(34.4750977)
   0.5661270283137731500000000000f,   //  6277: sin(34.4805908)
   0.5662060562115567300000000000f,   //  6278: sin(34.4860840)
   0.5662850789048956600000000000f,   //  6279: sin(34.4915771)
   0.5663640963930638400000000000f,   //  6280: sin(34.4970703)
   0.5664431086753346500000000000f,   //  6281: sin(34.5025635)
   0.5665221157509821000000000000f,   //  6282: sin(34.5080566)
   0.5666011176192797800000000000f,   //  6283: sin(34.5135498)
   0.5666801142795016000000000000f,   //  6284: sin(34.5190430)
   0.5667591057309214800000000000f,   //  6285: sin(34.5245361)
   0.5668380919728133200000000000f,   //  6286: sin(34.5300293)
   0.5669170730044510400000000000f,   //  6287: sin(34.5355225)
   0.5669960488251086800000000000f,   //  6288: sin(34.5410156)
   0.5670750194340602500000000000f,   //  6289: sin(34.5465088)
   0.5671539848305801000000000000f,   //  6290: sin(34.5520020)
   0.5672329450139421700000000000f,   //  6291: sin(34.5574951)
   0.5673118999834208000000000000f,   //  6292: sin(34.5629883)
   0.5673908497382901300000000000f,   //  6293: sin(34.5684814)
   0.5674697942778245100000000000f,   //  6294: sin(34.5739746)
   0.5675487336012985400000000000f,   //  6295: sin(34.5794678)
   0.5676276677079862300000000000f,   //  6296: sin(34.5849609)
   0.5677065965971622700000000000f,   //  6297: sin(34.5904541)
   0.5677855202681011400000000000f,   //  6298: sin(34.5959473)
   0.5678644387200773000000000000f,   //  6299: sin(34.6014404)
   0.5679433519523655600000000000f,   //  6300: sin(34.6069336)
   0.5680222599642403800000000000f,   //  6301: sin(34.6124268)
   0.5681011627549764600000000000f,   //  6302: sin(34.6179199)
   0.5681800603238486000000000000f,   //  6303: sin(34.6234131)
   0.5682589526701314900000000000f,   //  6304: sin(34.6289063)
   0.5683378397931001500000000000f,   //  6305: sin(34.6343994)
   0.5684167216920292800000000000f,   //  6306: sin(34.6398926)
   0.5684955983661940100000000000f,   //  6307: sin(34.6453857)
   0.5685744698148691400000000000f,   //  6308: sin(34.6508789)
   0.5686533360373299300000000000f,   //  6309: sin(34.6563721)
   0.5687321970328510500000000000f,   //  6310: sin(34.6618652)
   0.5688110528007079800000000000f,   //  6311: sin(34.6673584)
   0.5688899033401758600000000000f,   //  6312: sin(34.6728516)
   0.5689687486505298200000000000f,   //  6313: sin(34.6783447)
   0.5690475887310451100000000000f,   //  6314: sin(34.6838379)
   0.5691264235809970800000000000f,   //  6315: sin(34.6893311)
   0.5692052531996612000000000000f,   //  6316: sin(34.6948242)
   0.5692840775863127200000000000f,   //  6317: sin(34.7003174)
   0.5693628967402272200000000000f,   //  6318: sin(34.7058105)
   0.5694417106606802800000000000f,   //  6319: sin(34.7113037)
   0.5695205193469471400000000000f,   //  6320: sin(34.7167969)
   0.5695993227983037200000000000f,   //  6321: sin(34.7222900)
   0.5696781210140256000000000000f,   //  6322: sin(34.7277832)
   0.5697569139933884600000000000f,   //  6323: sin(34.7332764)
   0.5698357017356680000000000000f,   //  6324: sin(34.7387695)
   0.5699144842401401300000000000f,   //  6325: sin(34.7442627)
   0.5699932615060805400000000000f,   //  6326: sin(34.7497559)
   0.5700720335327653700000000000f,   //  6327: sin(34.7552490)
   0.5701508003194703000000000000f,   //  6328: sin(34.7607422)
   0.5702295618654715800000000000f,   //  6329: sin(34.7662354)
   0.5703083181700449000000000000f,   //  6330: sin(34.7717285)
   0.5703870692324667400000000000f,   //  6331: sin(34.7772217)
   0.5704658150520129900000000000f,   //  6332: sin(34.7827148)
   0.5705445556279599200000000000f,   //  6333: sin(34.7882080)
   0.5706232909595837500000000000f,   //  6334: sin(34.7937012)
   0.5707020210461607500000000000f,   //  6335: sin(34.7991943)
   0.5707807458869672600000000000f,   //  6336: sin(34.8046875)
   0.5708594654812796400000000000f,   //  6337: sin(34.8101807)
   0.5709381798283743600000000000f,   //  6338: sin(34.8156738)
   0.5710168889275278900000000000f,   //  6339: sin(34.8211670)
   0.5710955927780166900000000000f,   //  6340: sin(34.8266602)
   0.5711742913791174600000000000f,   //  6341: sin(34.8321533)
   0.5712529847301066600000000000f,   //  6342: sin(34.8376465)
   0.5713316728302609800000000000f,   //  6343: sin(34.8431396)
   0.5714103556788572300000000000f,   //  6344: sin(34.8486328)
   0.5714890332751720900000000000f,   //  6345: sin(34.8541260)
   0.5715677056184825800000000000f,   //  6346: sin(34.8596191)
   0.5716463727080651800000000000f,   //  6347: sin(34.8651123)
   0.5717250345431971200000000000f,   //  6348: sin(34.8706055)
   0.5718036911231553200000000000f,   //  6349: sin(34.8760986)
   0.5718823424472165900000000000f,   //  6350: sin(34.8815918)
   0.5719609885146581500000000000f,   //  6351: sin(34.8870850)
   0.5720396293247570500000000000f,   //  6352: sin(34.8925781)
   0.5721182648767905200000000000f,   //  6353: sin(34.8980713)
   0.5721968951700355800000000000f,   //  6354: sin(34.9035645)
   0.5722755202037695900000000000f,   //  6355: sin(34.9090576)
   0.5723541399772699200000000000f,   //  6356: sin(34.9145508)
   0.5724327544898137900000000000f,   //  6357: sin(34.9200439)
   0.5725113637406787900000000000f,   //  6358: sin(34.9255371)
   0.5725899677291420600000000000f,   //  6359: sin(34.9310303)
   0.5726685664544811600000000000f,   //  6360: sin(34.9365234)
   0.5727471599159739100000000000f,   //  6361: sin(34.9420166)
   0.5728257481128975500000000000f,   //  6362: sin(34.9475098)
   0.5729043310445298700000000000f,   //  6363: sin(34.9530029)
   0.5729829087101485600000000000f,   //  6364: sin(34.9584961)
   0.5730614811090313200000000000f,   //  6365: sin(34.9639893)
   0.5731400482404559500000000000f,   //  6366: sin(34.9694824)
   0.5732186101037002300000000000f,   //  6367: sin(34.9749756)
   0.5732971666980422000000000000f,   //  6368: sin(34.9804688)
   0.5733757180227595500000000000f,   //  6369: sin(34.9859619)
   0.5734542640771304000000000000f,   //  6370: sin(34.9914551)
   0.5735328048604326800000000000f,   //  6371: sin(34.9969482)
   0.5736113403719446100000000000f,   //  6372: sin(35.0024414)
   0.5736898706109441200000000000f,   //  6373: sin(35.0079346)
   0.5737683955767095600000000000f,   //  6374: sin(35.0134277)
   0.5738469152685189400000000000f,   //  6375: sin(35.0189209)
   0.5739254296856507500000000000f,   //  6376: sin(35.0244141)
   0.5740039388273831000000000000f,   //  6377: sin(35.0299072)
   0.5740824426929944700000000000f,   //  6378: sin(35.0354004)
   0.5741609412817632000000000000f,   //  6379: sin(35.0408936)
   0.5742394345929678900000000000f,   //  6380: sin(35.0463867)
   0.5743179226258868800000000000f,   //  6381: sin(35.0518799)
   0.5743964053797987500000000000f,   //  6382: sin(35.0573730)
   0.5744748828539821800000000000f,   //  6383: sin(35.0628662)
   0.5745533550477157600000000000f,   //  6384: sin(35.0683594)
   0.5746318219602782900000000000f,   //  6385: sin(35.0738525)
   0.5747102835909483300000000000f,   //  6386: sin(35.0793457)
   0.5747887399390048100000000000f,   //  6387: sin(35.0848389)
   0.5748671910037267400000000000f,   //  6388: sin(35.0903320)
   0.5749456367843925900000000000f,   //  6389: sin(35.0958252)
   0.5750240772802817100000000000f,   //  6390: sin(35.1013184)
   0.5751025124906727900000000000f,   //  6391: sin(35.1068115)
   0.5751809424148450800000000000f,   //  6392: sin(35.1123047)
   0.5752593670520777000000000000f,   //  6393: sin(35.1177979)
   0.5753377864016494500000000000f,   //  6394: sin(35.1232910)
   0.5754162004628400300000000000f,   //  6395: sin(35.1287842)
   0.5754946092349281200000000000f,   //  6396: sin(35.1342773)
   0.5755730127171935200000000000f,   //  6397: sin(35.1397705)
   0.5756514109089151400000000000f,   //  6398: sin(35.1452637)
   0.5757298038093725500000000000f,   //  6399: sin(35.1507568)
   0.5758081914178453400000000000f,   //  6400: sin(35.1562500)
   0.5758865737336126300000000000f,   //  6401: sin(35.1617432)
   0.5759649507559542200000000000f,   //  6402: sin(35.1672363)
   0.5760433224841495800000000000f,   //  6403: sin(35.1727295)
   0.5761216889174782800000000000f,   //  6404: sin(35.1782227)
   0.5762000500552202400000000000f,   //  6405: sin(35.1837158)
   0.5762784058966549100000000000f,   //  6406: sin(35.1892090)
   0.5763567564410622100000000000f,   //  6407: sin(35.1947021)
   0.5764351016877218300000000000f,   //  6408: sin(35.2001953)
   0.5765134416359136700000000000f,   //  6409: sin(35.2056885)
   0.5765917762849177600000000000f,   //  6410: sin(35.2111816)
   0.5766701056340140000000000000f,   //  6411: sin(35.2166748)
   0.5767484296824824100000000000f,   //  6412: sin(35.2221680)
   0.5768267484296030200000000000f,   //  6413: sin(35.2276611)
   0.5769050618746559600000000000f,   //  6414: sin(35.2331543)
   0.5769833700169213500000000000f,   //  6415: sin(35.2386475)
   0.5770616728556794400000000000f,   //  6416: sin(35.2441406)
   0.5771399703902105900000000000f,   //  6417: sin(35.2496338)
   0.5772182626197949200000000000f,   //  6418: sin(35.2551270)
   0.5772965495437129000000000000f,   //  6419: sin(35.2606201)
   0.5773748311612448800000000000f,   //  6420: sin(35.2661133)
   0.5774531074716713300000000000f,   //  6421: sin(35.2716064)
   0.5775313784742727200000000000f,   //  6422: sin(35.2770996)
   0.5776096441683297200000000000f,   //  6423: sin(35.2825928)
   0.5776879045531228000000000000f,   //  6424: sin(35.2880859)
   0.5777661596279325400000000000f,   //  6425: sin(35.2935791)
   0.5778444093920398500000000000f,   //  6426: sin(35.2990723)
   0.5779226538447254100000000000f,   //  6427: sin(35.3045654)
   0.5780008929852699100000000000f,   //  6428: sin(35.3100586)
   0.5780791268129542600000000000f,   //  6429: sin(35.3155518)
   0.5781573553270593600000000000f,   //  6430: sin(35.3210449)
   0.5782355785268660200000000000f,   //  6431: sin(35.3265381)
   0.5783137964116555900000000000f,   //  6432: sin(35.3320313)
   0.5783920089807086400000000000f,   //  6433: sin(35.3375244)
   0.5784702162333066300000000000f,   //  6434: sin(35.3430176)
   0.5785484181687304800000000000f,   //  6435: sin(35.3485107)
   0.5786266147862614300000000000f,   //  6436: sin(35.3540039)
   0.5787048060851808200000000000f,   //  6437: sin(35.3594971)
   0.5787829920647696900000000000f,   //  6438: sin(35.3649902)
   0.5788611727243095900000000000f,   //  6439: sin(35.3704834)
   0.5789393480630817800000000000f,   //  6440: sin(35.3759766)
   0.5790175180803679400000000000f,   //  6441: sin(35.3814697)
   0.5790956827754490900000000000f,   //  6442: sin(35.3869629)
   0.5791738421476071400000000000f,   //  6443: sin(35.3924561)
   0.5792519961961235500000000000f,   //  6444: sin(35.3979492)
   0.5793301449202797900000000000f,   //  6445: sin(35.4034424)
   0.5794082883193578700000000000f,   //  6446: sin(35.4089355)
   0.5794864263926392500000000000f,   //  6447: sin(35.4144287)
   0.5795645591394056300000000000f,   //  6448: sin(35.4199219)
   0.5796426865589392500000000000f,   //  6449: sin(35.4254150)
   0.5797208086505214500000000000f,   //  6450: sin(35.4309082)
   0.5797989254134345800000000000f,   //  6451: sin(35.4364014)
   0.5798770368469603500000000000f,   //  6452: sin(35.4418945)
   0.5799551429503807500000000000f,   //  6453: sin(35.4473877)
   0.5800332437229781500000000000f,   //  6454: sin(35.4528809)
   0.5801113391640343500000000000f,   //  6455: sin(35.4583740)
   0.5801894292728316800000000000f,   //  6456: sin(35.4638672)
   0.5802675140486521800000000000f,   //  6457: sin(35.4693604)
   0.5803455934907783000000000000f,   //  6458: sin(35.4748535)
   0.5804236675984922900000000000f,   //  6459: sin(35.4803467)
   0.5805017363710764900000000000f,   //  6460: sin(35.4858398)
   0.5805797998078133800000000000f,   //  6461: sin(35.4913330)
   0.5806578579079853000000000000f,   //  6462: sin(35.4968262)
   0.5807359106708749300000000000f,   //  6463: sin(35.5023193)
   0.5808139580957645300000000000f,   //  6464: sin(35.5078125)
   0.5808920001819368700000000000f,   //  6465: sin(35.5133057)
   0.5809700369286747700000000000f,   //  6466: sin(35.5187988)
   0.5810480683352606800000000000f,   //  6467: sin(35.5242920)
   0.5811260944009776200000000000f,   //  6468: sin(35.5297852)
   0.5812041151251080600000000000f,   //  6469: sin(35.5352783)
   0.5812821305069350000000000000f,   //  6470: sin(35.5407715)
   0.5813601405457414800000000000f,   //  6471: sin(35.5462646)
   0.5814381452408101700000000000f,   //  6472: sin(35.5517578)
   0.5815161445914244200000000000f,   //  6473: sin(35.5572510)
   0.5815941385968669300000000000f,   //  6474: sin(35.5627441)
   0.5816721272564209200000000000f,   //  6475: sin(35.5682373)
   0.5817501105693696500000000000f,   //  6476: sin(35.5737305)
   0.5818280885349961200000000000f,   //  6477: sin(35.5792236)
   0.5819060611525838100000000000f,   //  6478: sin(35.5847168)
   0.5819840284214158300000000000f,   //  6479: sin(35.5902100)
   0.5820619903407754400000000000f,   //  6480: sin(35.5957031)
   0.5821399469099463000000000000f,   //  6481: sin(35.6011963)
   0.5822178981282116700000000000f,   //  6482: sin(35.6066895)
   0.5822958439948551200000000000f,   //  6483: sin(35.6121826)
   0.5823737845091601100000000000f,   //  6484: sin(35.6176758)
   0.5824517196704103200000000000f,   //  6485: sin(35.6231689)
   0.5825296494778893200000000000f,   //  6486: sin(35.6286621)
   0.5826075739308807000000000000f,   //  6487: sin(35.6341553)
   0.5826854930286684600000000000f,   //  6488: sin(35.6396484)
   0.5827634067705360600000000000f,   //  6489: sin(35.6451416)
   0.5828413151557676500000000000f,   //  6490: sin(35.6506348)
   0.5829192181836468900000000000f,   //  6491: sin(35.6561279)
   0.5829971158534577000000000000f,   //  6492: sin(35.6616211)
   0.5830750081644843200000000000f,   //  6493: sin(35.6671143)
   0.5831528951160104300000000000f,   //  6494: sin(35.6726074)
   0.5832307767073204900000000000f,   //  6495: sin(35.6781006)
   0.5833086529376982900000000000f,   //  6496: sin(35.6835938)
   0.5833865238064280800000000000f,   //  6497: sin(35.6890869)
   0.5834643893127943200000000000f,   //  6498: sin(35.6945801)
   0.5835422494560810200000000000f,   //  6499: sin(35.7000732)
   0.5836201042355727600000000000f,   //  6500: sin(35.7055664)
   0.5836979536505535500000000000f,   //  6501: sin(35.7110596)
   0.5837757977003080700000000000f,   //  6502: sin(35.7165527)
   0.5838536363841209100000000000f,   //  6503: sin(35.7220459)
   0.5839314697012761800000000000f,   //  6504: sin(35.7275391)
   0.5840092976510589100000000000f,   //  6505: sin(35.7330322)
   0.5840871202327534400000000000f,   //  6506: sin(35.7385254)
   0.5841649374456445700000000000f,   //  6507: sin(35.7440186)
   0.5842427492890169800000000000f,   //  6508: sin(35.7495117)
   0.5843205557621553600000000000f,   //  6509: sin(35.7550049)
   0.5843983568643446000000000000f,   //  6510: sin(35.7604980)
   0.5844761525948696200000000000f,   //  6511: sin(35.7659912)
   0.5845539429530153300000000000f,   //  6512: sin(35.7714844)
   0.5846317279380665000000000000f,   //  6513: sin(35.7769775)
   0.5847095075493083900000000000f,   //  6514: sin(35.7824707)
   0.5847872817860261300000000000f,   //  6515: sin(35.7879639)
   0.5848650506475044900000000000f,   //  6516: sin(35.7934570)
   0.5849428141330289500000000000f,   //  6517: sin(35.7989502)
   0.5850205722418845300000000000f,   //  6518: sin(35.8044434)
   0.5850983249733564500000000000f,   //  6519: sin(35.8099365)
   0.5851760723267304100000000000f,   //  6520: sin(35.8154297)
   0.5852538143012913100000000000f,   //  6521: sin(35.8209229)
   0.5853315508963249400000000000f,   //  6522: sin(35.8264160)
   0.5854092821111164200000000000f,   //  6523: sin(35.8319092)
   0.5854870079449513400000000000f,   //  6524: sin(35.8374023)
   0.5855647283971156000000000000f,   //  6525: sin(35.8428955)
   0.5856424434668944200000000000f,   //  6526: sin(35.8483887)
   0.5857201531535736200000000000f,   //  6527: sin(35.8538818)
   0.5857978574564388600000000000f,   //  6528: sin(35.8593750)
   0.5858755563747759500000000000f,   //  6529: sin(35.8648682)
   0.5859532499078705700000000000f,   //  6530: sin(35.8703613)
   0.5860309380550087200000000000f,   //  6531: sin(35.8758545)
   0.5861086208154764300000000000f,   //  6532: sin(35.8813477)
   0.5861862981885592700000000000f,   //  6533: sin(35.8868408)
   0.5862639701735435900000000000f,   //  6534: sin(35.8923340)
   0.5863416367697152900000000000f,   //  6535: sin(35.8978271)
   0.5864192979763605000000000000f,   //  6536: sin(35.9033203)
   0.5864969537927654500000000000f,   //  6537: sin(35.9088135)
   0.5865746042182161700000000000f,   //  6538: sin(35.9143066)
   0.5866522492519991000000000000f,   //  6539: sin(35.9197998)
   0.5867298888934003900000000000f,   //  6540: sin(35.9252930)
   0.5868075231417064800000000000f,   //  6541: sin(35.9307861)
   0.5868851519962039500000000000f,   //  6542: sin(35.9362793)
   0.5869627754561788100000000000f,   //  6543: sin(35.9417725)
   0.5870403935209179700000000000f,   //  6544: sin(35.9472656)
   0.5871180061897077800000000000f,   //  6545: sin(35.9527588)
   0.5871956134618348000000000000f,   //  6546: sin(35.9582520)
   0.5872732153365859400000000000f,   //  6547: sin(35.9637451)
   0.5873508118132476600000000000f,   //  6548: sin(35.9692383)
   0.5874284028911067600000000000f,   //  6549: sin(35.9747314)
   0.5875059885694500200000000000f,   //  6550: sin(35.9802246)
   0.5875835688475644600000000000f,   //  6551: sin(35.9857178)
   0.5876611437247366600000000000f,   //  6552: sin(35.9912109)
   0.5877387132002538400000000000f,   //  6553: sin(35.9967041)
   0.5878162772734029100000000000f,   //  6554: sin(36.0021973)
   0.5878938359434708900000000000f,   //  6555: sin(36.0076904)
   0.5879713892097450100000000000f,   //  6556: sin(36.0131836)
   0.5880489370715122900000000000f,   //  6557: sin(36.0186768)
   0.5881264795280598500000000000f,   //  6558: sin(36.0241699)
   0.5882040165786751600000000000f,   //  6559: sin(36.0296631)
   0.5882815482226452200000000000f,   //  6560: sin(36.0351563)
   0.5883590744592577200000000000f,   //  6561: sin(36.0406494)
   0.5884365952877997900000000000f,   //  6562: sin(36.0461426)
   0.5885141107075589900000000000f,   //  6563: sin(36.0516357)
   0.5885916207178228900000000000f,   //  6564: sin(36.0571289)
   0.5886691253178788500000000000f,   //  6565: sin(36.0626221)
   0.5887466245070145400000000000f,   //  6566: sin(36.0681152)
   0.5888241182845176400000000000f,   //  6567: sin(36.0736084)
   0.5889016066496757200000000000f,   //  6568: sin(36.0791016)
   0.5889790896017768100000000000f,   //  6569: sin(36.0845947)
   0.5890565671401084600000000000f,   //  6570: sin(36.0900879)
   0.5891340392639585800000000000f,   //  6571: sin(36.0955811)
   0.5892115059726149600000000000f,   //  6572: sin(36.1010742)
   0.5892889672653657300000000000f,   //  6573: sin(36.1065674)
   0.5893664231414987900000000000f,   //  6574: sin(36.1120605)
   0.5894438736003020400000000000f,   //  6575: sin(36.1175537)
   0.5895213186410639400000000000f,   //  6576: sin(36.1230469)
   0.5895987582630721800000000000f,   //  6577: sin(36.1285400)
   0.5896761924656154200000000000f,   //  6578: sin(36.1340332)
   0.5897536212479814700000000000f,   //  6579: sin(36.1395264)
   0.5898310446094587900000000000f,   //  6580: sin(36.1450195)
   0.5899084625493358200000000000f,   //  6581: sin(36.1505127)
   0.5899858750669009200000000000f,   //  6582: sin(36.1560059)
   0.5900632821614424400000000000f,   //  6583: sin(36.1614990)
   0.5901406838322488200000000000f,   //  6584: sin(36.1669922)
   0.5902180800786087600000000000f,   //  6585: sin(36.1724854)
   0.5902954708998108300000000000f,   //  6586: sin(36.1779785)
   0.5903728562951435800000000000f,   //  6587: sin(36.1834717)
   0.5904502362638958100000000000f,   //  6588: sin(36.1889648)
   0.5905276108053561000000000000f,   //  6589: sin(36.1944580)
   0.5906049799188133300000000000f,   //  6590: sin(36.1999512)
   0.5906823436035565400000000000f,   //  6591: sin(36.2054443)
   0.5907597018588741600000000000f,   //  6592: sin(36.2109375)
   0.5908370546840555600000000000f,   //  6593: sin(36.2164307)
   0.5909144020783895200000000000f,   //  6594: sin(36.2219238)
   0.5909917440411651700000000000f,   //  6595: sin(36.2274170)
   0.5910690805716714000000000000f,   //  6596: sin(36.2329102)
   0.5911464116691975700000000000f,   //  6597: sin(36.2384033)
   0.5912237373330329100000000000f,   //  6598: sin(36.2438965)
   0.5913010575624664300000000000f,   //  6599: sin(36.2493896)
   0.5913783723567875800000000000f,   //  6600: sin(36.2548828)
   0.5914556817152856200000000000f,   //  6601: sin(36.2603760)
   0.5915329856372499900000000000f,   //  6602: sin(36.2658691)
   0.5916102841219701400000000000f,   //  6603: sin(36.2713623)
   0.5916875771687354300000000000f,   //  6604: sin(36.2768555)
   0.5917648647768356500000000000f,   //  6605: sin(36.2823486)
   0.5918421469455601400000000000f,   //  6606: sin(36.2878418)
   0.5919194236741987000000000000f,   //  6607: sin(36.2933350)
   0.5919966949620409900000000000f,   //  6608: sin(36.2988281)
   0.5920739608083766000000000000f,   //  6609: sin(36.3043213)
   0.5921512212124955300000000000f,   //  6610: sin(36.3098145)
   0.5922284761736874600000000000f,   //  6611: sin(36.3153076)
   0.5923057256912422900000000000f,   //  6612: sin(36.3208008)
   0.5923829697644502600000000000f,   //  6613: sin(36.3262939)
   0.5924602083926008300000000000f,   //  6614: sin(36.3317871)
   0.5925374415749845600000000000f,   //  6615: sin(36.3372803)
   0.5926146693108911300000000000f,   //  6616: sin(36.3427734)
   0.5926918915996110000000000000f,   //  6617: sin(36.3482666)
   0.5927691084404340700000000000f,   //  6618: sin(36.3537598)
   0.5928463198326506800000000000f,   //  6619: sin(36.3592529)
   0.5929235257755513000000000000f,   //  6620: sin(36.3647461)
   0.5930007262684260400000000000f,   //  6621: sin(36.3702393)
   0.5930779213105654700000000000f,   //  6622: sin(36.3757324)
   0.5931551109012598300000000000f,   //  6623: sin(36.3812256)
   0.5932322950397998000000000000f,   //  6624: sin(36.3867188)
   0.5933094737254758200000000000f,   //  6625: sin(36.3922119)
   0.5933866469575784800000000000f,   //  6626: sin(36.3977051)
   0.5934638147353984400000000000f,   //  6627: sin(36.4031982)
   0.5935409770582263900000000000f,   //  6628: sin(36.4086914)
   0.5936181339253530100000000000f,   //  6629: sin(36.4141846)
   0.5936952853360691900000000000f,   //  6630: sin(36.4196777)
   0.5937724312896657300000000000f,   //  6631: sin(36.4251709)
   0.5938495717854336300000000000f,   //  6632: sin(36.4306641)
   0.5939267068226635700000000000f,   //  6633: sin(36.4361572)
   0.5940038364006466900000000000f,   //  6634: sin(36.4416504)
   0.5940809605186740900000000000f,   //  6635: sin(36.4471436)
   0.5941580791760368000000000000f,   //  6636: sin(36.4526367)
   0.5942351923720260400000000000f,   //  6637: sin(36.4581299)
   0.5943123001059328300000000000f,   //  6638: sin(36.4636230)
   0.5943894023770486300000000000f,   //  6639: sin(36.4691162)
   0.5944664991846644300000000000f,   //  6640: sin(36.4746094)
   0.5945435905280718200000000000f,   //  6641: sin(36.4801025)
   0.5946206764065622400000000000f,   //  6642: sin(36.4855957)
   0.5946977568194269400000000000f,   //  6643: sin(36.4910889)
   0.5947748317659575800000000000f,   //  6644: sin(36.4965820)
   0.5948519012454455100000000000f,   //  6645: sin(36.5020752)
   0.5949289652571824200000000000f,   //  6646: sin(36.5075684)
   0.5950060238004600800000000000f,   //  6647: sin(36.5130615)
   0.5950830768745699600000000000f,   //  6648: sin(36.5185547)
   0.5951601244788039500000000000f,   //  6649: sin(36.5240479)
   0.5952371666124538500000000000f,   //  6650: sin(36.5295410)
   0.5953142032748114400000000000f,   //  6651: sin(36.5350342)
   0.5953912344651687300000000000f,   //  6652: sin(36.5405273)
   0.5954682601828174000000000000f,   //  6653: sin(36.5460205)
   0.5955452804270497900000000000f,   //  6654: sin(36.5515137)
   0.5956222951971577000000000000f,   //  6655: sin(36.5570068)
   0.5956993044924333600000000000f,   //  6656: sin(36.5625000)
   0.5957763083121687700000000000f,   //  6657: sin(36.5679932)
   0.5958533066556562800000000000f,   //  6658: sin(36.5734863)
   0.5959302995221881200000000000f,   //  6659: sin(36.5789795)
   0.5960072869110565300000000000f,   //  6660: sin(36.5844727)
   0.5960842688215538500000000000f,   //  6661: sin(36.5899658)
   0.5961612452529725400000000000f,   //  6662: sin(36.5954590)
   0.5962382162046049300000000000f,   //  6663: sin(36.6009521)
   0.5963151816757437100000000000f,   //  6664: sin(36.6064453)
   0.5963921416656813300000000000f,   //  6665: sin(36.6119385)
   0.5964690961737103600000000000f,   //  6666: sin(36.6174316)
   0.5965460451991233500000000000f,   //  6667: sin(36.6229248)
   0.5966229887412132200000000000f,   //  6668: sin(36.6284180)
   0.5966999267992727500000000000f,   //  6669: sin(36.6339111)
   0.5967768593725943900000000000f,   //  6670: sin(36.6394043)
   0.5968537864604714900000000000f,   //  6671: sin(36.6448975)
   0.5969307080621965000000000000f,   //  6672: sin(36.6503906)
   0.5970076241770625500000000000f,   //  6673: sin(36.6558838)
   0.5970845348043627400000000000f,   //  6674: sin(36.6613770)
   0.5971614399433898800000000000f,   //  6675: sin(36.6668701)
   0.5972383395934374200000000000f,   //  6676: sin(36.6723633)
   0.5973152337537982500000000000f,   //  6677: sin(36.6778564)
   0.5973921224237657100000000000f,   //  6678: sin(36.6833496)
   0.5974690056026328300000000000f,   //  6679: sin(36.6888428)
   0.5975458832896931600000000000f,   //  6680: sin(36.6943359)
   0.5976227554842401500000000000f,   //  6681: sin(36.6998291)
   0.5976996221855668300000000000f,   //  6682: sin(36.7053223)
   0.5977764833929669600000000000f,   //  6683: sin(36.7108154)
   0.5978533391057339100000000000f,   //  6684: sin(36.7163086)
   0.5979301893231612200000000000f,   //  6685: sin(36.7218018)
   0.5980070340445427000000000000f,   //  6686: sin(36.7272949)
   0.5980838732691717800000000000f,   //  6687: sin(36.7327881)
   0.5981607069963422700000000000f,   //  6688: sin(36.7382813)
   0.5982375352253479500000000000f,   //  6689: sin(36.7437744)
   0.5983143579554826000000000000f,   //  6690: sin(36.7492676)
   0.5983911751860401300000000000f,   //  6691: sin(36.7547607)
   0.5984679869163143100000000000f,   //  6692: sin(36.7602539)
   0.5985447931455992700000000000f,   //  6693: sin(36.7657471)
   0.5986215938731889200000000000f,   //  6694: sin(36.7712402)
   0.5986983890983773600000000000f,   //  6695: sin(36.7767334)
   0.5987751788204587200000000000f,   //  6696: sin(36.7822266)
   0.5988519630387271200000000000f,   //  6697: sin(36.7877197)
   0.5989287417524769000000000000f,   //  6698: sin(36.7932129)
   0.5990055149610020700000000000f,   //  6699: sin(36.7987061)
   0.5990822826635973100000000000f,   //  6700: sin(36.8041992)
   0.5991590448595566200000000000f,   //  6701: sin(36.8096924)
   0.5992358015481745700000000000f,   //  6702: sin(36.8151855)
   0.5993125527287457300000000000f,   //  6703: sin(36.8206787)
   0.5993892984005645400000000000f,   //  6704: sin(36.8261719)
   0.5994660385629255700000000000f,   //  6705: sin(36.8316650)
   0.5995427732151233900000000000f,   //  6706: sin(36.8371582)
   0.5996195023564526700000000000f,   //  6707: sin(36.8426514)
   0.5996962259862083100000000000f,   //  6708: sin(36.8481445)
   0.5997729441036847600000000000f,   //  6709: sin(36.8536377)
   0.5998496567081772500000000000f,   //  6710: sin(36.8591309)
   0.5999263637989803400000000000f,   //  6711: sin(36.8646240)
   0.6000030653753889400000000000f,   //  6712: sin(36.8701172)
   0.6000797614366983900000000000f,   //  6713: sin(36.8756104)
   0.6001564519822032400000000000f,   //  6714: sin(36.8811035)
   0.6002331370111989600000000000f,   //  6715: sin(36.8865967)
   0.6003098165229804300000000000f,   //  6716: sin(36.8920898)
   0.6003864905168427900000000000f,   //  6717: sin(36.8975830)
   0.6004631589920815800000000000f,   //  6718: sin(36.9030762)
   0.6005398219479918300000000000f,   //  6719: sin(36.9085693)
   0.6006164793838689700000000000f,   //  6720: sin(36.9140625)
   0.6006931312990082500000000000f,   //  6721: sin(36.9195557)
   0.6007697776927052300000000000f,   //  6722: sin(36.9250488)
   0.6008464185642553600000000000f,   //  6723: sin(36.9305420)
   0.6009230539129540900000000000f,   //  6724: sin(36.9360352)
   0.6009996837380972000000000000f,   //  6725: sin(36.9415283)
   0.6010763080389801600000000000f,   //  6726: sin(36.9470215)
   0.6011529268148987400000000000f,   //  6727: sin(36.9525146)
   0.6012295400651485000000000000f,   //  6728: sin(36.9580078)
   0.6013061477890254700000000000f,   //  6729: sin(36.9635010)
   0.6013827499858254200000000000f,   //  6730: sin(36.9689941)
   0.6014593466548441300000000000f,   //  6731: sin(36.9744873)
   0.6015359377953777300000000000f,   //  6732: sin(36.9799805)
   0.6016125234067218900000000000f,   //  6733: sin(36.9854736)
   0.6016891034881729500000000000f,   //  6734: sin(36.9909668)
   0.6017656780390270300000000000f,   //  6735: sin(36.9964600)
   0.6018422470585800300000000000f,   //  6736: sin(37.0019531)
   0.6019188105461283900000000000f,   //  6737: sin(37.0074463)
   0.6019953685009680200000000000f,   //  6738: sin(37.0129395)
   0.6020719209223955900000000000f,   //  6739: sin(37.0184326)
   0.6021484678097072100000000000f,   //  6740: sin(37.0239258)
   0.6022250091621993400000000000f,   //  6741: sin(37.0294189)
   0.6023015449791685500000000000f,   //  6742: sin(37.0349121)
   0.6023780752599111600000000000f,   //  6743: sin(37.0404053)
   0.6024546000037237500000000000f,   //  6744: sin(37.0458984)
   0.6025311192099029900000000000f,   //  6745: sin(37.0513916)
   0.6026076328777454400000000000f,   //  6746: sin(37.0568848)
   0.6026841410065479900000000000f,   //  6747: sin(37.0623779)
   0.6027606435956072200000000000f,   //  6748: sin(37.0678711)
   0.6028371406442200000000000000f,   //  6749: sin(37.0733643)
   0.6029136321516830300000000000f,   //  6750: sin(37.0788574)
   0.6029901181172934200000000000f,   //  6751: sin(37.0843506)
   0.6030665985403481600000000000f,   //  6752: sin(37.0898438)
   0.6031430734201440600000000000f,   //  6753: sin(37.0953369)
   0.6032195427559784400000000000f,   //  6754: sin(37.1008301)
   0.6032960065471481000000000000f,   //  6755: sin(37.1063232)
   0.6033724647929502600000000000f,   //  6756: sin(37.1118164)
   0.6034489174926824800000000000f,   //  6757: sin(37.1173096)
   0.6035253646456415500000000000f,   //  6758: sin(37.1228027)
   0.6036018062511251400000000000f,   //  6759: sin(37.1282959)
   0.6036782423084303700000000000f,   //  6760: sin(37.1337891)
   0.6037546728168548000000000000f,   //  6761: sin(37.1392822)
   0.6038310977756958800000000000f,   //  6762: sin(37.1447754)
   0.6039075171842510600000000000f,   //  6763: sin(37.1502686)
   0.6039839310418180200000000000f,   //  6764: sin(37.1557617)
   0.6040603393476942100000000000f,   //  6765: sin(37.1612549)
   0.6041367421011775200000000000f,   //  6766: sin(37.1667480)
   0.6042131393015655000000000000f,   //  6767: sin(37.1722412)
   0.6042895309481559600000000000f,   //  6768: sin(37.1777344)
   0.6043659170402468900000000000f,   //  6769: sin(37.1832275)
   0.6044422975771358600000000000f,   //  6770: sin(37.1887207)
   0.6045186725581210800000000000f,   //  6771: sin(37.1942139)
   0.6045950419825003600000000000f,   //  6772: sin(37.1997070)
   0.6046714058495716900000000000f,   //  6773: sin(37.2052002)
   0.6047477641586334100000000000f,   //  6774: sin(37.2106934)
   0.6048241169089833000000000000f,   //  6775: sin(37.2161865)
   0.6049004640999198200000000000f,   //  6776: sin(37.2216797)
   0.6049768057307410900000000000f,   //  6777: sin(37.2271729)
   0.6050531418007453200000000000f,   //  6778: sin(37.2326660)
   0.6051294723092310900000000000f,   //  6779: sin(37.2381592)
   0.6052057972554965000000000000f,   //  6780: sin(37.2436523)
   0.6052821166388402400000000000f,   //  6781: sin(37.2491455)
   0.6053584304585605300000000000f,   //  6782: sin(37.2546387)
   0.6054347387139560300000000000f,   //  6783: sin(37.2601318)
   0.6055110414043255500000000000f,   //  6784: sin(37.2656250)
   0.6055873385289672900000000000f,   //  6785: sin(37.2711182)
   0.6056636300871803800000000000f,   //  6786: sin(37.2766113)
   0.6057399160782632700000000000f,   //  6787: sin(37.2821045)
   0.6058161965015149700000000000f,   //  6788: sin(37.2875977)
   0.6058924713562341400000000000f,   //  6789: sin(37.2930908)
   0.6059687406417196800000000000f,   //  6790: sin(37.2985840)
   0.6060450043572708200000000000f,   //  6791: sin(37.3040771)
   0.6061212625021861200000000000f,   //  6792: sin(37.3095703)
   0.6061975150757650300000000000f,   //  6793: sin(37.3150635)
   0.6062737620773064300000000000f,   //  6794: sin(37.3205566)
   0.6063500035061094600000000000f,   //  6795: sin(37.3260498)
   0.6064262393614735500000000000f,   //  6796: sin(37.3315430)
   0.6065024696426976100000000000f,   //  6797: sin(37.3370361)
   0.6065786943490812900000000000f,   //  6798: sin(37.3425293)
   0.6066549134799237300000000000f,   //  6799: sin(37.3480225)
   0.6067311270345244800000000000f,   //  6800: sin(37.3535156)
   0.6068073350121828700000000000f,   //  6801: sin(37.3590088)
   0.6068835374121984700000000000f,   //  6802: sin(37.3645020)
   0.6069597342338709500000000000f,   //  6803: sin(37.3699951)
   0.6070359254764996500000000000f,   //  6804: sin(37.3754883)
   0.6071121111393844600000000000f,   //  6805: sin(37.3809814)
   0.6071882912218251600000000000f,   //  6806: sin(37.3864746)
   0.6072644657231213200000000000f,   //  6807: sin(37.3919678)
   0.6073406346425729300000000000f,   //  6808: sin(37.3974609)
   0.6074167979794795600000000000f,   //  6809: sin(37.4029541)
   0.6074929557331415500000000000f,   //  6810: sin(37.4084473)
   0.6075691079028586700000000000f,   //  6811: sin(37.4139404)
   0.6076452544879308300000000000f,   //  6812: sin(37.4194336)
   0.6077213954876583600000000000f,   //  6813: sin(37.4249268)
   0.6077975309013411400000000000f,   //  6814: sin(37.4304199)
   0.6078736607282795300000000000f,   //  6815: sin(37.4359131)
   0.6079497849677736300000000000f,   //  6816: sin(37.4414063)
   0.6080259036191237900000000000f,   //  6817: sin(37.4468994)
   0.6081020166816304400000000000f,   //  6818: sin(37.4523926)
   0.6081781241545938200000000000f,   //  6819: sin(37.4578857)
   0.6082542260373144900000000000f,   //  6820: sin(37.4633789)
   0.6083303223290926800000000000f,   //  6821: sin(37.4688721)
   0.6084064130292291500000000000f,   //  6822: sin(37.4743652)
   0.6084824981370246000000000000f,   //  6823: sin(37.4798584)
   0.6085585776517794500000000000f,   //  6824: sin(37.4853516)
   0.6086346515727945100000000000f,   //  6825: sin(37.4908447)
   0.6087107198993703100000000000f,   //  6826: sin(37.4963379)
   0.6087867826308078800000000000f,   //  6827: sin(37.5018311)
   0.6088628397664082000000000000f,   //  6828: sin(37.5073242)
   0.6089388913054717400000000000f,   //  6829: sin(37.5128174)
   0.6090149372472998300000000000f,   //  6830: sin(37.5183105)
   0.6090909775911932400000000000f,   //  6831: sin(37.5238037)
   0.6091670123364532100000000000f,   //  6832: sin(37.5292969)
   0.6092430414823806200000000000f,   //  6833: sin(37.5347900)
   0.6093190650282768200000000000f,   //  6834: sin(37.5402832)
   0.6093950829734429100000000000f,   //  6835: sin(37.5457764)
   0.6094710953171802400000000000f,   //  6836: sin(37.5512695)
   0.6095471020587901500000000000f,   //  6837: sin(37.5567627)
   0.6096231031975737300000000000f,   //  6838: sin(37.5622559)
   0.6096990987328326800000000000f,   //  6839: sin(37.5677490)
   0.6097750886638684300000000000f,   //  6840: sin(37.5732422)
   0.6098510729899823100000000000f,   //  6841: sin(37.5787354)
   0.6099270517104761200000000000f,   //  6842: sin(37.5842285)
   0.6100030248246513000000000000f,   //  6843: sin(37.5897217)
   0.6100789923318096200000000000f,   //  6844: sin(37.5952148)
   0.6101549542312528800000000000f,   //  6845: sin(37.6007080)
   0.6102309105222826200000000000f,   //  6846: sin(37.6062012)
   0.6103068612042008600000000000f,   //  6847: sin(37.6116943)
   0.6103828062763094800000000000f,   //  6848: sin(37.6171875)
   0.6104587457379101500000000000f,   //  6849: sin(37.6226807)
   0.6105346795883053200000000000f,   //  6850: sin(37.6281738)
   0.6106106078267965500000000000f,   //  6851: sin(37.6336670)
   0.6106865304526862800000000000f,   //  6852: sin(37.6391602)
   0.6107624474652763000000000000f,   //  6853: sin(37.6446533)
   0.6108383588638691700000000000f,   //  6854: sin(37.6501465)
   0.6109142646477668800000000000f,   //  6855: sin(37.6556396)
   0.6109901648162716600000000000f,   //  6856: sin(37.6611328)
   0.6110660593686861900000000000f,   //  6857: sin(37.6666260)
   0.6111419483043125700000000000f,   //  6858: sin(37.6721191)
   0.6112178316224533600000000000f,   //  6859: sin(37.6776123)
   0.6112937093224108900000000000f,   //  6860: sin(37.6831055)
   0.6113695814034879600000000000f,   //  6861: sin(37.6885986)
   0.6114454478649870000000000000f,   //  6862: sin(37.6940918)
   0.6115213087062108000000000000f,   //  6863: sin(37.6995850)
   0.6115971639264619100000000000f,   //  6864: sin(37.7050781)
   0.6116730135250431100000000000f,   //  6865: sin(37.7105713)
   0.6117488575012572900000000000f,   //  6866: sin(37.7160645)
   0.6118246958544073500000000000f,   //  6867: sin(37.7215576)
   0.6119005285837960700000000000f,   //  6868: sin(37.7270508)
   0.6119763556887264400000000000f,   //  6869: sin(37.7325439)
   0.6120521771685014700000000000f,   //  6870: sin(37.7380371)
   0.6121279930224242700000000000f,   //  6871: sin(37.7435303)
   0.6122038032497979500000000000f,   //  6872: sin(37.7490234)
   0.6122796078499256300000000000f,   //  6873: sin(37.7545166)
   0.6123554068221106500000000000f,   //  6874: sin(37.7600098)
   0.6124312001656561100000000000f,   //  6875: sin(37.7655029)
   0.6125069878798655700000000000f,   //  6876: sin(37.7709961)
   0.6125827699640420400000000000f,   //  6877: sin(37.7764893)
   0.6126585464174892900000000000f,   //  6878: sin(37.7819824)
   0.6127343172395106600000000000f,   //  6879: sin(37.7874756)
   0.6128100824294097100000000000f,   //  6880: sin(37.7929688)
   0.6128858419864899900000000000f,   //  6881: sin(37.7984619)
   0.6129615959100551700000000000f,   //  6882: sin(37.8039551)
   0.6130373441994088100000000000f,   //  6883: sin(37.8094482)
   0.6131130868538549100000000000f,   //  6884: sin(37.8149414)
   0.6131888238726970200000000000f,   //  6885: sin(37.8204346)
   0.6132645552552390400000000000f,   //  6886: sin(37.8259277)
   0.6133402810007849700000000000f,   //  6887: sin(37.8314209)
   0.6134160011086385900000000000f,   //  6888: sin(37.8369141)
   0.6134917155781041100000000000f,   //  6889: sin(37.8424072)
   0.6135674244084853300000000000f,   //  6890: sin(37.8479004)
   0.6136431275990865700000000000f,   //  6891: sin(37.8533936)
   0.6137188251492117200000000000f,   //  6892: sin(37.8588867)
   0.6137945170581652300000000000f,   //  6893: sin(37.8643799)
   0.6138702033252513300000000000f,   //  6894: sin(37.8698730)
   0.6139458839497742300000000000f,   //  6895: sin(37.8753662)
   0.6140215589310383800000000000f,   //  6896: sin(37.8808594)
   0.6140972282683481200000000000f,   //  6897: sin(37.8863525)
   0.6141728919610079900000000000f,   //  6898: sin(37.8918457)
   0.6142485500083223500000000000f,   //  6899: sin(37.8973389)
   0.6143242024095959500000000000f,   //  6900: sin(37.9028320)
   0.6143998491641332600000000000f,   //  6901: sin(37.9083252)
   0.6144754902712390400000000000f,   //  6902: sin(37.9138184)
   0.6145511257302180800000000000f,   //  6903: sin(37.9193115)
   0.6146267555403750500000000000f,   //  6904: sin(37.9248047)
   0.6147023797010147100000000000f,   //  6905: sin(37.9302979)
   0.6147779982114420800000000000f,   //  6906: sin(37.9357910)
   0.6148536110709620400000000000f,   //  6907: sin(37.9412842)
   0.6149292182788795900000000000f,   //  6908: sin(37.9467773)
   0.6150048198344997300000000000f,   //  6909: sin(37.9522705)
   0.6150804157371274600000000000f,   //  6910: sin(37.9577637)
   0.6151560059860681200000000000f,   //  6911: sin(37.9632568)
   0.6152315905806268200000000000f,   //  6912: sin(37.9687500)
   0.6153071695201087800000000000f,   //  6913: sin(37.9742432)
   0.6153827428038192200000000000f,   //  6914: sin(37.9797363)
   0.6154583104310635800000000000f,   //  6915: sin(37.9852295)
   0.6155338724011473200000000000f,   //  6916: sin(37.9907227)
   0.6156094287133757600000000000f,   //  6917: sin(37.9962158)
   0.6156849793670545700000000000f,   //  6918: sin(38.0017090)
   0.6157605243614890900000000000f,   //  6919: sin(38.0072021)
   0.6158360636959850900000000000f,   //  6920: sin(38.0126953)
   0.6159115973698480200000000000f,   //  6921: sin(38.0181885)
   0.6159871253823837600000000000f,   //  6922: sin(38.0236816)
   0.6160626477328982100000000000f,   //  6923: sin(38.0291748)
   0.6161381644206969100000000000f,   //  6924: sin(38.0346680)
   0.6162136754450858700000000000f,   //  6925: sin(38.0401611)
   0.6162891808053709800000000000f,   //  6926: sin(38.0456543)
   0.6163646805008581300000000000f,   //  6927: sin(38.0511475)
   0.6164401745308536500000000000f,   //  6928: sin(38.0566406)
   0.6165156628946632000000000000f,   //  6929: sin(38.0621338)
   0.6165911455915931100000000000f,   //  6930: sin(38.0676270)
   0.6166666226209496200000000000f,   //  6931: sin(38.0731201)
   0.6167420939820387200000000000f,   //  6932: sin(38.0786133)
   0.6168175596741670700000000000f,   //  6933: sin(38.0841064)
   0.6168930196966406800000000000f,   //  6934: sin(38.0895996)
   0.6169684740487662000000000000f,   //  6935: sin(38.0950928)
   0.6170439227298497600000000000f,   //  6936: sin(38.1005859)
   0.6171193657391980100000000000f,   //  6937: sin(38.1060791)
   0.6171948030761176300000000000f,   //  6938: sin(38.1115723)
   0.6172702347399149400000000000f,   //  6939: sin(38.1170654)
   0.6173456607298968300000000000f,   //  6940: sin(38.1225586)
   0.6174210810453698600000000000f,   //  6941: sin(38.1280518)
   0.6174964956856409100000000000f,   //  6942: sin(38.1335449)
   0.6175719046500165500000000000f,   //  6943: sin(38.1390381)
   0.6176473079378038700000000000f,   //  6944: sin(38.1445313)
   0.6177227055483097700000000000f,   //  6945: sin(38.1500244)
   0.6177980974808410200000000000f,   //  6946: sin(38.1555176)
   0.6178734837347048500000000000f,   //  6947: sin(38.1610107)
   0.6179488643092081500000000000f,   //  6948: sin(38.1665039)
   0.6180242392036581200000000000f,   //  6949: sin(38.1719971)
   0.6180996084173620000000000000f,   //  6950: sin(38.1774902)
   0.6181749719496268900000000000f,   //  6951: sin(38.1829834)
   0.6182503297997602500000000000f,   //  6952: sin(38.1884766)
   0.6183256819670690500000000000f,   //  6953: sin(38.1939697)
   0.6184010284508609800000000000f,   //  6954: sin(38.1994629)
   0.6184763692504434700000000000f,   //  6955: sin(38.2049561)
   0.6185517043651237400000000000f,   //  6956: sin(38.2104492)
   0.6186270337942096900000000000f,   //  6957: sin(38.2159424)
   0.6187023575370085300000000000f,   //  6958: sin(38.2214355)
   0.6187776755928281500000000000f,   //  6959: sin(38.2269287)
   0.6188529879609763200000000000f,   //  6960: sin(38.2324219)
   0.6189282946407604900000000000f,   //  6961: sin(38.2379150)
   0.6190035956314886600000000000f,   //  6962: sin(38.2434082)
   0.6190788909324686000000000000f,   //  6963: sin(38.2489014)
   0.6191541805430084100000000000f,   //  6964: sin(38.2543945)
   0.6192294644624156700000000000f,   //  6965: sin(38.2598877)
   0.6193047426899986900000000000f,   //  6966: sin(38.2653809)
   0.6193800152250654700000000000f,   //  6967: sin(38.2708740)
   0.6194552820669240200000000000f,   //  6968: sin(38.2763672)
   0.6195305432148825500000000000f,   //  6969: sin(38.2818604)
   0.6196057986682492700000000000f,   //  6970: sin(38.2873535)
   0.6196810484263325400000000000f,   //  6971: sin(38.2928467)
   0.6197562924884406600000000000f,   //  6972: sin(38.2983398)
   0.6198315308538818700000000000f,   //  6973: sin(38.3038330)
   0.6199067635219647200000000000f,   //  6974: sin(38.3093262)
   0.6199819904919976500000000000f,   //  6975: sin(38.3148193)
   0.6200572117632891000000000000f,   //  6976: sin(38.3203125)
   0.6201324273351478400000000000f,   //  6977: sin(38.3258057)
   0.6202076372068824300000000000f,   //  6978: sin(38.3312988)
   0.6202828413778014300000000000f,   //  6979: sin(38.3367920)
   0.6203580398472137200000000000f,   //  6980: sin(38.3422852)
   0.6204332326144280700000000000f,   //  6981: sin(38.3477783)
   0.6205084196787533600000000000f,   //  6982: sin(38.3532715)
   0.6205836010394982800000000000f,   //  6983: sin(38.3587646)
   0.6206587766959721400000000000f,   //  6984: sin(38.3642578)
   0.6207339466474834900000000000f,   //  6985: sin(38.3697510)
   0.6208091108933419000000000000f,   //  6986: sin(38.3752441)
   0.6208842694328560200000000000f,   //  6987: sin(38.3807373)
   0.6209594222653351800000000000f,   //  6988: sin(38.3862305)
   0.6210345693900887200000000000f,   //  6989: sin(38.3917236)
   0.6211097108064256300000000000f,   //  6990: sin(38.3972168)
   0.6211848465136555800000000000f,   //  6991: sin(38.4027100)
   0.6212599765110875500000000000f,   //  6992: sin(38.4082031)
   0.6213351007980312300000000000f,   //  6993: sin(38.4136963)
   0.6214102193737961500000000000f,   //  6994: sin(38.4191895)
   0.6214853322376915300000000000f,   //  6995: sin(38.4246826)
   0.6215604393890272700000000000f,   //  6996: sin(38.4301758)
   0.6216355408271127000000000000f,   //  6997: sin(38.4356689)
   0.6217106365512576900000000000f,   //  6998: sin(38.4411621)
   0.6217857265607720200000000000f,   //  6999: sin(38.4466553)
   0.6218608108549653600000000000f,   //  7000: sin(38.4521484)
   0.6219358894331475900000000000f,   //  7001: sin(38.4576416)
   0.6220109622946286000000000000f,   //  7002: sin(38.4631348)
   0.6220860294387182700000000000f,   //  7003: sin(38.4686279)
   0.6221610908647268200000000000f,   //  7004: sin(38.4741211)
   0.6222361465719641300000000000f,   //  7005: sin(38.4796143)
   0.6223111965597403200000000000f,   //  7006: sin(38.4851074)
   0.6223862408273654900000000000f,   //  7007: sin(38.4906006)
   0.6224612793741499700000000000f,   //  7008: sin(38.4960938)
   0.6225363121994039700000000000f,   //  7009: sin(38.5015869)
   0.6226113393024377300000000000f,   //  7010: sin(38.5070801)
   0.6226863606825617800000000000f,   //  7011: sin(38.5125732)
   0.6227613763390863500000000000f,   //  7012: sin(38.5180664)
   0.6228363862713221000000000000f,   //  7013: sin(38.5235596)
   0.6229113904785794600000000000f,   //  7014: sin(38.5290527)
   0.6229863889601688900000000000f,   //  7015: sin(38.5345459)
   0.6230613817154012600000000000f,   //  7016: sin(38.5400391)
   0.6231363687435871300000000000f,   //  7017: sin(38.5455322)
   0.6232113500440372700000000000f,   //  7018: sin(38.5510254)
   0.6232863256160623400000000000f,   //  7019: sin(38.5565186)
   0.6233612954589732300000000000f,   //  7020: sin(38.5620117)
   0.6234362595720810400000000000f,   //  7021: sin(38.5675049)
   0.6235112179546964400000000000f,   //  7022: sin(38.5729980)
   0.6235861706061306400000000000f,   //  7023: sin(38.5784912)
   0.6236611175256945300000000000f,   //  7024: sin(38.5839844)
   0.6237360587126993300000000000f,   //  7025: sin(38.5894775)
   0.6238109941664561300000000000f,   //  7026: sin(38.5949707)
   0.6238859238862761700000000000f,   //  7027: sin(38.6004639)
   0.6239608478714706600000000000f,   //  7028: sin(38.6059570)
   0.6240357661213509200000000000f,   //  7029: sin(38.6114502)
   0.6241106786352285100000000000f,   //  7030: sin(38.6169434)
   0.6241855854124145300000000000f,   //  7031: sin(38.6224365)
   0.6242604864522206500000000000f,   //  7032: sin(38.6279297)
   0.6243353817539584200000000000f,   //  7033: sin(38.6334229)
   0.6244102713169392700000000000f,   //  7034: sin(38.6389160)
   0.6244851551404750900000000000f,   //  7035: sin(38.6444092)
   0.6245600332238772100000000000f,   //  7036: sin(38.6499023)
   0.6246349055664576200000000000f,   //  7037: sin(38.6553955)
   0.6247097721675281000000000000f,   //  7038: sin(38.6608887)
   0.6247846330264003000000000000f,   //  7039: sin(38.6663818)
   0.6248594881423863400000000000f,   //  7040: sin(38.6718750)
   0.6249343375147981000000000000f,   //  7041: sin(38.6773682)
   0.6250091811429474600000000000f,   //  7042: sin(38.6828613)
   0.6250840190261466300000000000f,   //  7043: sin(38.6883545)
   0.6251588511637076200000000000f,   //  7044: sin(38.6938477)
   0.6252336775549427500000000000f,   //  7045: sin(38.6993408)
   0.6253084981991640100000000000f,   //  7046: sin(38.7048340)
   0.6253833130956837300000000000f,   //  7047: sin(38.7103271)
   0.6254581222438143600000000000f,   //  7048: sin(38.7158203)
   0.6255329256428680000000000000f,   //  7049: sin(38.7213135)
   0.6256077232921574100000000000f,   //  7050: sin(38.7268066)
   0.6256825151909948300000000000f,   //  7051: sin(38.7322998)
   0.6257573013386929000000000000f,   //  7052: sin(38.7377930)
   0.6258320817345640600000000000f,   //  7053: sin(38.7432861)
   0.6259068563779210900000000000f,   //  7054: sin(38.7487793)
   0.6259816252680767700000000000f,   //  7055: sin(38.7542725)
   0.6260563884043435200000000000f,   //  7056: sin(38.7597656)
   0.6261311457860344600000000000f,   //  7057: sin(38.7652588)
   0.6262058974124621300000000000f,   //  7058: sin(38.7707520)
   0.6262806432829396400000000000f,   //  7059: sin(38.7762451)
   0.6263553833967799900000000000f,   //  7060: sin(38.7817383)
   0.6264301177532959300000000000f,   //  7061: sin(38.7872314)
   0.6265048463518008100000000000f,   //  7062: sin(38.7927246)
   0.6265795691916076200000000000f,   //  7063: sin(38.7982178)
   0.6266542862720293500000000000f,   //  7064: sin(38.8037109)
   0.6267289975923795400000000000f,   //  7065: sin(38.8092041)
   0.6268037031519712000000000000f,   //  7066: sin(38.8146973)
   0.6268784029501178700000000000f,   //  7067: sin(38.8201904)
   0.6269530969861326600000000000f,   //  7068: sin(38.8256836)
   0.6270277852593292300000000000f,   //  7069: sin(38.8311768)
   0.6271024677690209000000000000f,   //  7070: sin(38.8366699)
   0.6271771445145213300000000000f,   //  7071: sin(38.8421631)
   0.6272518154951440800000000000f,   //  7072: sin(38.8476563)
   0.6273264807102026900000000000f,   //  7073: sin(38.8531494)
   0.6274011401590110500000000000f,   //  7074: sin(38.8586426)
   0.6274757938408827000000000000f,   //  7075: sin(38.8641357)
   0.6275504417551315300000000000f,   //  7076: sin(38.8696289)
   0.6276250839010714100000000000f,   //  7077: sin(38.8751221)
   0.6276997202780162400000000000f,   //  7078: sin(38.8806152)
   0.6277743508852800000000000000f,   //  7079: sin(38.8861084)
   0.6278489757221764600000000000f,   //  7080: sin(38.8916016)
   0.6279235947880200700000000000f,   //  7081: sin(38.8970947)
   0.6279982080821247000000000000f,   //  7082: sin(38.9025879)
   0.6280728156038045700000000000f,   //  7083: sin(38.9080811)
   0.6281474173523740000000000000f,   //  7084: sin(38.9135742)
   0.6282220133271471100000000000f,   //  7085: sin(38.9190674)
   0.6282966035274383200000000000f,   //  7086: sin(38.9245605)
   0.6283711879525620800000000000f,   //  7087: sin(38.9300537)
   0.6284457666018327100000000000f,   //  7088: sin(38.9355469)
   0.6285203394745647600000000000f,   //  7089: sin(38.9410400)
   0.6285949065700725500000000000f,   //  7090: sin(38.9465332)
   0.6286694678876710900000000000f,   //  7091: sin(38.9520264)
   0.6287440234266746800000000000f,   //  7092: sin(38.9575195)
   0.6288185731863982200000000000f,   //  7093: sin(38.9630127)
   0.6288931171661564800000000000f,   //  7094: sin(38.9685059)
   0.6289676553652640000000000000f,   //  7095: sin(38.9739990)
   0.6290421877830360000000000000f,   //  7096: sin(38.9794922)
   0.6291167144187870300000000000f,   //  7097: sin(38.9849854)
   0.6291912352718322900000000000f,   //  7098: sin(38.9904785)
   0.6292657503414869100000000000f,   //  7099: sin(38.9959717)
   0.6293402596270656300000000000f,   //  7100: sin(39.0014648)
   0.6294147631278839100000000000f,   //  7101: sin(39.0069580)
   0.6294892608432566300000000000f,   //  7102: sin(39.0124512)
   0.6295637527724992100000000000f,   //  7103: sin(39.0179443)
   0.6296382389149269800000000000f,   //  7104: sin(39.0234375)
   0.6297127192698551700000000000f,   //  7105: sin(39.0289307)
   0.6297871938365992000000000000f,   //  7106: sin(39.0344238)
   0.6298616626144744000000000000f,   //  7107: sin(39.0399170)
   0.6299361256027964400000000000f,   //  7108: sin(39.0454102)
   0.6300105828008809600000000000f,   //  7109: sin(39.0509033)
   0.6300850342080431800000000000f,   //  7110: sin(39.0563965)
   0.6301594798235992100000000000f,   //  7111: sin(39.0618896)
   0.6302339196468643700000000000f,   //  7112: sin(39.0673828)
   0.6303083536771546500000000000f,   //  7113: sin(39.0728760)
   0.6303827819137859400000000000f,   //  7114: sin(39.0783691)
   0.6304572043560738900000000000f,   //  7115: sin(39.0838623)
   0.6305316210033346000000000000f,   //  7116: sin(39.0893555)
   0.6306060318548839500000000000f,   //  7117: sin(39.0948486)
   0.6306804369100379400000000000f,   //  7118: sin(39.1003418)
   0.6307548361681127900000000000f,   //  7119: sin(39.1058350)
   0.6308292296284244700000000000f,   //  7120: sin(39.1113281)
   0.6309036172902894300000000000f,   //  7121: sin(39.1168213)
   0.6309779991530235500000000000f,   //  7122: sin(39.1223145)
   0.6310523752159434800000000000f,   //  7123: sin(39.1278076)
   0.6311267454783653400000000000f,   //  7124: sin(39.1333008)
   0.6312011099396055400000000000f,   //  7125: sin(39.1387939)
   0.6312754685989807600000000000f,   //  7126: sin(39.1442871)
   0.6313498214558073100000000000f,   //  7127: sin(39.1497803)
   0.6314241685094018600000000000f,   //  7128: sin(39.1552734)
   0.6314985097590808400000000000f,   //  7129: sin(39.1607666)
   0.6315728452041610200000000000f,   //  7130: sin(39.1662598)
   0.6316471748439593800000000000f,   //  7131: sin(39.1717529)
   0.6317214986777922600000000000f,   //  7132: sin(39.1772461)
   0.6317958167049768600000000000f,   //  7133: sin(39.1827393)
   0.6318701289248298500000000000f,   //  7134: sin(39.1882324)
   0.6319444353366682200000000000f,   //  7135: sin(39.1937256)
   0.6320187359398090600000000000f,   //  7136: sin(39.1992188)
   0.6320930307335691500000000000f,   //  7137: sin(39.2047119)
   0.6321673197172659200000000000f,   //  7138: sin(39.2102051)
   0.6322416028902162500000000000f,   //  7139: sin(39.2156982)
   0.6323158802517375700000000000f,   //  7140: sin(39.2211914)
   0.6323901518011469900000000000f,   //  7141: sin(39.2266846)
   0.6324644175377618400000000000f,   //  7142: sin(39.2321777)
   0.6325386774608995300000000000f,   //  7143: sin(39.2376709)
   0.6326129315698774100000000000f,   //  7144: sin(39.2431641)
   0.6326871798640131300000000000f,   //  7145: sin(39.2486572)
   0.6327614223426240000000000000f,   //  7146: sin(39.2541504)
   0.6328356590050275800000000000f,   //  7147: sin(39.2596436)
   0.6329098898505417500000000000f,   //  7148: sin(39.2651367)
   0.6329841148784840500000000000f,   //  7149: sin(39.2706299)
   0.6330583340881721400000000000f,   //  7150: sin(39.2761230)
   0.6331325474789238900000000000f,   //  7151: sin(39.2816162)
   0.6332067550500571900000000000f,   //  7152: sin(39.2871094)
   0.6332809568008899200000000000f,   //  7153: sin(39.2926025)
   0.6333551527307399500000000000f,   //  7154: sin(39.2980957)
   0.6334293428389254900000000000f,   //  7155: sin(39.3035889)
   0.6335035271247643200000000000f,   //  7156: sin(39.3090820)
   0.6335777055875746500000000000f,   //  7157: sin(39.3145752)
   0.6336518782266749000000000000f,   //  7158: sin(39.3200684)
   0.6337260450413828600000000000f,   //  7159: sin(39.3255615)
   0.6338002060310172800000000000f,   //  7160: sin(39.3310547)
   0.6338743611948960400000000000f,   //  7161: sin(39.3365479)
   0.6339485105323378100000000000f,   //  7162: sin(39.3420410)
   0.6340226540426607800000000000f,   //  7163: sin(39.3475342)
   0.6340967917251837400000000000f,   //  7164: sin(39.3530273)
   0.6341709235792251100000000000f,   //  7165: sin(39.3585205)
   0.6342450496041033300000000000f,   //  7166: sin(39.3640137)
   0.6343191697991372700000000000f,   //  7167: sin(39.3695068)
   0.6343932841636454900000000000f,   //  7168: sin(39.3750000)
   0.6344673926969467400000000000f,   //  7169: sin(39.3804932)
   0.6345414953983600200000000000f,   //  7170: sin(39.3859863)
   0.6346155922672039900000000000f,   //  7171: sin(39.3914795)
   0.6346896833027977400000000000f,   //  7172: sin(39.3969727)
   0.6347637685044600400000000000f,   //  7173: sin(39.4024658)
   0.6348378478715099900000000000f,   //  7174: sin(39.4079590)
   0.6349119214032668000000000000f,   //  7175: sin(39.4134521)
   0.6349859890990494600000000000f,   //  7176: sin(39.4189453)
   0.6350600509581771900000000000f,   //  7177: sin(39.4244385)
   0.6351341069799691900000000000f,   //  7178: sin(39.4299316)
   0.6352081571637449000000000000f,   //  7179: sin(39.4354248)
   0.6352822015088234200000000000f,   //  7180: sin(39.4409180)
   0.6353562400145244000000000000f,   //  7181: sin(39.4464111)
   0.6354302726801671600000000000f,   //  7182: sin(39.4519043)
   0.6355042995050711500000000000f,   //  7183: sin(39.4573975)
   0.6355783204885561100000000000f,   //  7184: sin(39.4628906)
   0.6356523356299415000000000000f,   //  7185: sin(39.4683838)
   0.6357263449285470700000000000f,   //  7186: sin(39.4738770)
   0.6358003483836925900000000000f,   //  7187: sin(39.4793701)
   0.6358743459946977200000000000f,   //  7188: sin(39.4848633)
   0.6359483377608823300000000000f,   //  7189: sin(39.4903564)
   0.6360223236815663000000000000f,   //  7190: sin(39.4958496)
   0.6360963037560695100000000000f,   //  7191: sin(39.5013428)
   0.6361702779837121700000000000f,   //  7192: sin(39.5068359)
   0.6362442463638140500000000000f,   //  7193: sin(39.5123291)
   0.6363182088956954600000000000f,   //  7194: sin(39.5178223)
   0.6363921655786763900000000000f,   //  7195: sin(39.5233154)
   0.6364661164120771800000000000f,   //  7196: sin(39.5288086)
   0.6365400613952180200000000000f,   //  7197: sin(39.5343018)
   0.6366140005274191200000000000f,   //  7198: sin(39.5397949)
   0.6366879338080011500000000000f,   //  7199: sin(39.5452881)
   0.6367618612362842000000000000f,   //  7200: sin(39.5507813)
   0.6368357828115890400000000000f,   //  7201: sin(39.5562744)
   0.6369096985332358700000000000f,   //  7202: sin(39.5617676)
   0.6369836084005454600000000000f,   //  7203: sin(39.5672607)
   0.6370575124128385900000000000f,   //  7204: sin(39.5727539)
   0.6371314105694356700000000000f,   //  7205: sin(39.5782471)
   0.6372053028696576000000000000f,   //  7206: sin(39.5837402)
   0.6372791893128251200000000000f,   //  7207: sin(39.5892334)
   0.6373530698982591300000000000f,   //  7208: sin(39.5947266)
   0.6374269446252804900000000000f,   //  7209: sin(39.6002197)
   0.6375008134932101900000000000f,   //  7210: sin(39.6057129)
   0.6375746765013693400000000000f,   //  7211: sin(39.6112061)
   0.6376485336490788100000000000f,   //  7212: sin(39.6166992)
   0.6377223849356598000000000000f,   //  7213: sin(39.6221924)
   0.6377962303604335400000000000f,   //  7214: sin(39.6276855)
   0.6378700699227211100000000000f,   //  7215: sin(39.6331787)
   0.6379439036218440600000000000f,   //  7216: sin(39.6386719)
   0.6380177314571234800000000000f,   //  7217: sin(39.6441650)
   0.6380915534278808200000000000f,   //  7218: sin(39.6496582)
   0.6381653695334376100000000000f,   //  7219: sin(39.6551514)
   0.6382391797731152800000000000f,   //  7220: sin(39.6606445)
   0.6383129841462355000000000000f,   //  7221: sin(39.6661377)
   0.6383867826521195700000000000f,   //  7222: sin(39.6716309)
   0.6384605752900894800000000000f,   //  7223: sin(39.6771240)
   0.6385343620594667900000000000f,   //  7224: sin(39.6826172)
   0.6386081429595732400000000000f,   //  7225: sin(39.6881104)
   0.6386819179897307300000000000f,   //  7226: sin(39.6936035)
   0.6387556871492611200000000000f,   //  7227: sin(39.6990967)
   0.6388294504374862900000000000f,   //  7228: sin(39.7045898)
   0.6389032078537283400000000000f,   //  7229: sin(39.7100830)
   0.6389769593973091400000000000f,   //  7230: sin(39.7155762)
   0.6390507050675509100000000000f,   //  7231: sin(39.7210693)
   0.6391244448637757300000000000f,   //  7232: sin(39.7265625)
   0.6391981787853058300000000000f,   //  7233: sin(39.7320557)
   0.6392719068314635100000000000f,   //  7234: sin(39.7375488)
   0.6393456290015708800000000000f,   //  7235: sin(39.7430420)
   0.6394193452949507000000000000f,   //  7236: sin(39.7485352)
   0.6394930557109249600000000000f,   //  7237: sin(39.7540283)
   0.6395667602488163100000000000f,   //  7238: sin(39.7595215)
   0.6396404589079473000000000000f,   //  7239: sin(39.7650146)
   0.6397141516876404500000000000f,   //  7240: sin(39.7705078)
   0.6397878385872184400000000000f,   //  7241: sin(39.7760010)
   0.6398615196060039000000000000f,   //  7242: sin(39.7814941)
   0.6399351947433197200000000000f,   //  7243: sin(39.7869873)
   0.6400088639984884400000000000f,   //  7244: sin(39.7924805)
   0.6400825273708331500000000000f,   //  7245: sin(39.7979736)
   0.6401561848596765100000000000f,   //  7246: sin(39.8034668)
   0.6402298364643417300000000000f,   //  7247: sin(39.8089600)
   0.6403034821841516700000000000f,   //  7248: sin(39.8144531)
   0.6403771220184294500000000000f,   //  7249: sin(39.8199463)
   0.6404507559664981400000000000f,   //  7250: sin(39.8254395)
   0.6405243840276808600000000000f,   //  7251: sin(39.8309326)
   0.6405980062013010300000000000f,   //  7252: sin(39.8364258)
   0.6406716224866817500000000000f,   //  7253: sin(39.8419189)
   0.6407452328831464400000000000f,   //  7254: sin(39.8474121)
   0.6408188373900185500000000000f,   //  7255: sin(39.8529053)
   0.6408924360066213800000000000f,   //  7256: sin(39.8583984)
   0.6409660287322783700000000000f,   //  7257: sin(39.8638916)
   0.6410396155663133900000000000f,   //  7258: sin(39.8693848)
   0.6411131965080497700000000000f,   //  7259: sin(39.8748779)
   0.6411867715568112500000000000f,   //  7260: sin(39.8803711)
   0.6412603407119215100000000000f,   //  7261: sin(39.8858643)
   0.6413339039727042900000000000f,   //  7262: sin(39.8913574)
   0.6414074613384835900000000000f,   //  7263: sin(39.8968506)
   0.6414810128085831600000000000f,   //  7264: sin(39.9023438)
   0.6415545583823268900000000000f,   //  7265: sin(39.9078369)
   0.6416280980590387500000000000f,   //  7266: sin(39.9133301)
   0.6417016318380430700000000000f,   //  7267: sin(39.9188232)
   0.6417751597186635000000000000f,   //  7268: sin(39.9243164)
   0.6418486817002244700000000000f,   //  7269: sin(39.9298096)
   0.6419221977820501700000000000f,   //  7270: sin(39.9353027)
   0.6419957079634647200000000000f,   //  7271: sin(39.9407959)
   0.6420692122437925400000000000f,   //  7272: sin(39.9462891)
   0.6421427106223579500000000000f,   //  7273: sin(39.9517822)
   0.6422162030984853700000000000f,   //  7274: sin(39.9572754)
   0.6422896896714993500000000000f,   //  7275: sin(39.9627686)
   0.6423631703407243200000000000f,   //  7276: sin(39.9682617)
   0.6424366451054849300000000000f,   //  7277: sin(39.9737549)
   0.6425101139651057100000000000f,   //  7278: sin(39.9792480)
   0.6425835769189114400000000000f,   //  7279: sin(39.9847412)
   0.6426570339662268600000000000f,   //  7280: sin(39.9902344)
   0.6427304851063767600000000000f,   //  7281: sin(39.9957275)
   0.6428039303386859900000000000f,   //  7282: sin(40.0012207)
   0.6428773696624794400000000000f,   //  7283: sin(40.0067139)
   0.6429508030770820800000000000f,   //  7284: sin(40.0122070)
   0.6430242305818190100000000000f,   //  7285: sin(40.0177002)
   0.6430976521760151100000000000f,   //  7286: sin(40.0231934)
   0.6431710678589956900000000000f,   //  7287: sin(40.0286865)
   0.6432444776300858500000000000f,   //  7288: sin(40.0341797)
   0.6433178814886108000000000000f,   //  7289: sin(40.0396729)
   0.6433912794338958500000000000f,   //  7290: sin(40.0451660)
   0.6434646714652663100000000000f,   //  7291: sin(40.0506592)
   0.6435380575820477400000000000f,   //  7292: sin(40.0561523)
   0.6436114377835653300000000000f,   //  7293: sin(40.0616455)
   0.6436848120691448500000000000f,   //  7294: sin(40.0671387)
   0.6437581804381116200000000000f,   //  7295: sin(40.0726318)
   0.6438315428897913900000000000f,   //  7296: sin(40.0781250)
   0.6439048994235099200000000000f,   //  7297: sin(40.0836182)
   0.6439782500385926600000000000f,   //  7298: sin(40.0891113)
   0.6440515947343655700000000000f,   //  7299: sin(40.0946045)
   0.6441249335101545400000000000f,   //  7300: sin(40.1000977)
   0.6441982663652852100000000000f,   //  7301: sin(40.1055908)
   0.6442715932990837900000000000f,   //  7302: sin(40.1110840)
   0.6443449143108761500000000000f,   //  7303: sin(40.1165771)
   0.6444182293999883800000000000f,   //  7304: sin(40.1220703)
   0.6444915385657464800000000000f,   //  7305: sin(40.1275635)
   0.6445648418074766400000000000f,   //  7306: sin(40.1330566)
   0.6446381391245052900000000000f,   //  7307: sin(40.1385498)
   0.6447114305161583100000000000f,   //  7308: sin(40.1440430)
   0.6447847159817624600000000000f,   //  7309: sin(40.1495361)
   0.6448579955206437100000000000f,   //  7310: sin(40.1550293)
   0.6449312691321287300000000000f,   //  7311: sin(40.1605225)
   0.6450045368155439300000000000f,   //  7312: sin(40.1660156)
   0.6450777985702158500000000000f,   //  7313: sin(40.1715088)
   0.6451510543954711600000000000f,   //  7314: sin(40.1770020)
   0.6452243042906363700000000000f,   //  7315: sin(40.1824951)
   0.6452975482550383800000000000f,   //  7316: sin(40.1879883)
   0.6453707862880037100000000000f,   //  7317: sin(40.1934814)
   0.6454440183888592300000000000f,   //  7318: sin(40.1989746)
   0.6455172445569320500000000000f,   //  7319: sin(40.2044678)
   0.6455904647915486900000000000f,   //  7320: sin(40.2099609)
   0.6456636790920364800000000000f,   //  7321: sin(40.2154541)
   0.6457368874577222900000000000f,   //  7322: sin(40.2209473)
   0.6458100898879330900000000000f,   //  7323: sin(40.2264404)
   0.6458832863819963200000000000f,   //  7324: sin(40.2319336)
   0.6459564769392389700000000000f,   //  7325: sin(40.2374268)
   0.6460296615589883300000000000f,   //  7326: sin(40.2429199)
   0.6461028402405716300000000000f,   //  7327: sin(40.2484131)
   0.6461760129833162800000000000f,   //  7328: sin(40.2539063)
   0.6462491797865498300000000000f,   //  7329: sin(40.2593994)
   0.6463223406495994800000000000f,   //  7330: sin(40.2648926)
   0.6463954955717929900000000000f,   //  7331: sin(40.2703857)
   0.6464686445524577800000000000f,   //  7332: sin(40.2758789)
   0.6465417875909216200000000000f,   //  7333: sin(40.2813721)
   0.6466149246865120500000000000f,   //  7334: sin(40.2868652)
   0.6466880558385568200000000000f,   //  7335: sin(40.2923584)
   0.6467611810463839200000000000f,   //  7336: sin(40.2978516)
   0.6468343003093208800000000000f,   //  7337: sin(40.3033447)
   0.6469074136266960200000000000f,   //  7338: sin(40.3088379)
   0.6469805209978367600000000000f,   //  7339: sin(40.3143311)
   0.6470536224220715400000000000f,   //  7340: sin(40.3198242)
   0.6471267178987284400000000000f,   //  7341: sin(40.3253174)
   0.6471998074271352300000000000f,   //  7342: sin(40.3308105)
   0.6472728910066204400000000000f,   //  7343: sin(40.3363037)
   0.6473459686365120600000000000f,   //  7344: sin(40.3417969)
   0.6474190403161385100000000000f,   //  7345: sin(40.3472900)
   0.6474921060448281000000000000f,   //  7346: sin(40.3527832)
   0.6475651658219091500000000000f,   //  7347: sin(40.3582764)
   0.6476382196467103100000000000f,   //  7348: sin(40.3637695)
   0.6477112675185599000000000000f,   //  7349: sin(40.3692627)
   0.6477843094367864400000000000f,   //  7350: sin(40.3747559)
   0.6478573454007188200000000000f,   //  7351: sin(40.3802490)
   0.6479303754096853400000000000f,   //  7352: sin(40.3857422)
   0.6480033994630151100000000000f,   //  7353: sin(40.3912354)
   0.6480764175600365300000000000f,   //  7354: sin(40.3967285)
   0.6481494297000787200000000000f,   //  7355: sin(40.4022217)
   0.6482224358824704200000000000f,   //  7356: sin(40.4077148)
   0.6482954361065406100000000000f,   //  7357: sin(40.4132080)
   0.6483684303716182900000000000f,   //  7358: sin(40.4187012)
   0.6484414186770325300000000000f,   //  7359: sin(40.4241943)
   0.6485144010221124400000000000f,   //  7360: sin(40.4296875)
   0.6485873774061871000000000000f,   //  7361: sin(40.4351807)
   0.6486603478285858400000000000f,   //  7362: sin(40.4406738)
   0.6487333122886379500000000000f,   //  7363: sin(40.4461670)
   0.6488062707856725500000000000f,   //  7364: sin(40.4516602)
   0.6488792233190192600000000000f,   //  7365: sin(40.4571533)
   0.6489521698880073000000000000f,   //  7366: sin(40.4626465)
   0.6490251104919664300000000000f,   //  7367: sin(40.4681396)
   0.6490980451302259500000000000f,   //  7368: sin(40.4736328)
   0.6491709738021155300000000000f,   //  7369: sin(40.4791260)
   0.6492438965069649000000000000f,   //  7370: sin(40.4846191)
   0.6493168132441037300000000000f,   //  7371: sin(40.4901123)
   0.6493897240128616600000000000f,   //  7372: sin(40.4956055)
   0.6494626288125687800000000000f,   //  7373: sin(40.5010986)
   0.6495355276425547300000000000f,   //  7374: sin(40.5065918)
   0.6496084205021496200000000000f,   //  7375: sin(40.5120850)
   0.6496813073906831900000000000f,   //  7376: sin(40.5175781)
   0.6497541883074856600000000000f,   //  7377: sin(40.5230713)
   0.6498270632518871000000000000f,   //  7378: sin(40.5285645)
   0.6498999322232176200000000000f,   //  7379: sin(40.5340576)
   0.6499727952208075300000000000f,   //  7380: sin(40.5395508)
   0.6500456522439869200000000000f,   //  7381: sin(40.5450439)
   0.6501185032920862000000000000f,   //  7382: sin(40.5505371)
   0.6501913483644357100000000000f,   //  7383: sin(40.5560303)
   0.6502641874603658500000000000f,   //  7384: sin(40.5615234)
   0.6503370205792072800000000000f,   //  7385: sin(40.5670166)
   0.6504098477202903100000000000f,   //  7386: sin(40.5725098)
   0.6504826688829457000000000000f,   //  7387: sin(40.5780029)
   0.6505554840665038800000000000f,   //  7388: sin(40.5834961)
   0.6506282932702958100000000000f,   //  7389: sin(40.5889893)
   0.6507010964936520400000000000f,   //  7390: sin(40.5944824)
   0.6507738937359034400000000000f,   //  7391: sin(40.5999756)
   0.6508466849963808800000000000f,   //  7392: sin(40.6054688)
   0.6509194702744153200000000000f,   //  7393: sin(40.6109619)
   0.6509922495693376600000000000f,   //  7394: sin(40.6164551)
   0.6510650228804789600000000000f,   //  7395: sin(40.6219482)
   0.6511377902071703300000000000f,   //  7396: sin(40.6274414)
   0.6512105515487428600000000000f,   //  7397: sin(40.6329346)
   0.6512833069045277400000000000f,   //  7398: sin(40.6384277)
   0.6513560562738564000000000000f,   //  7399: sin(40.6439209)
   0.6514287996560598200000000000f,   //  7400: sin(40.6494141)
   0.6515015370504695400000000000f,   //  7401: sin(40.6549072)
   0.6515742684564169700000000000f,   //  7402: sin(40.6604004)
   0.6516469938732335500000000000f,   //  7403: sin(40.6658936)
   0.6517197133002509100000000000f,   //  7404: sin(40.6713867)
   0.6517924267368004900000000000f,   //  7405: sin(40.6768799)
   0.6518651341822139200000000000f,   //  7406: sin(40.6823730)
   0.6519378356358230800000000000f,   //  7407: sin(40.6878662)
   0.6520105310969595000000000000f,   //  7408: sin(40.6933594)
   0.6520832205649551600000000000f,   //  7409: sin(40.6988525)
   0.6521559040391415900000000000f,   //  7410: sin(40.7043457)
   0.6522285815188509900000000000f,   //  7411: sin(40.7098389)
   0.6523012530034154600000000000f,   //  7412: sin(40.7153320)
   0.6523739184921665300000000000f,   //  7413: sin(40.7208252)
   0.6524465779844367300000000000f,   //  7414: sin(40.7263184)
   0.6525192314795579300000000000f,   //  7415: sin(40.7318115)
   0.6525918789768624400000000000f,   //  7416: sin(40.7373047)
   0.6526645204756825700000000000f,   //  7417: sin(40.7427979)
   0.6527371559753503100000000000f,   //  7418: sin(40.7482910)
   0.6528097854751984100000000000f,   //  7419: sin(40.7537842)
   0.6528824089745588500000000000f,   //  7420: sin(40.7592773)
   0.6529550264727644900000000000f,   //  7421: sin(40.7647705)
   0.6530276379691475300000000000f,   //  7422: sin(40.7702637)
   0.6531002434630407400000000000f,   //  7423: sin(40.7757568)
   0.6531728429537767600000000000f,   //  7424: sin(40.7812500)
   0.6532454364406881100000000000f,   //  7425: sin(40.7867432)
   0.6533180239231076700000000000f,   //  7426: sin(40.7922363)
   0.6533906054003680900000000000f,   //  7427: sin(40.7977295)
   0.6534631808718023300000000000f,   //  7428: sin(40.8032227)
   0.6535357503367432700000000000f,   //  7429: sin(40.8087158)
   0.6536083137945238900000000000f,   //  7430: sin(40.8142090)
   0.6536808712444771600000000000f,   //  7431: sin(40.8197021)
   0.6537534226859360600000000000f,   //  7432: sin(40.8251953)
   0.6538259681182339000000000000f,   //  7433: sin(40.8306885)
   0.6538985075407037800000000000f,   //  7434: sin(40.8361816)
   0.6539710409526788800000000000f,   //  7435: sin(40.8416748)
   0.6540435683534926400000000000f,   //  7436: sin(40.8471680)
   0.6541160897424781500000000000f,   //  7437: sin(40.8526611)
   0.6541886051189690400000000000f,   //  7438: sin(40.8581543)
   0.6542611144822986200000000000f,   //  7439: sin(40.8636475)
   0.6543336178318004400000000000f,   //  7440: sin(40.8691406)
   0.6544061151668082400000000000f,   //  7441: sin(40.8746338)
   0.6544786064866553500000000000f,   //  7442: sin(40.8801270)
   0.6545510917906756100000000000f,   //  7443: sin(40.8856201)
   0.6546235710782026800000000000f,   //  7444: sin(40.8911133)
   0.6546960443485703200000000000f,   //  7445: sin(40.8966064)
   0.6547685116011126000000000000f,   //  7446: sin(40.9020996)
   0.6548409728351631800000000000f,   //  7447: sin(40.9075928)
   0.6549134280500560300000000000f,   //  7448: sin(40.9130859)
   0.6549858772451252500000000000f,   //  7449: sin(40.9185791)
   0.6550583204197049100000000000f,   //  7450: sin(40.9240723)
   0.6551307575731290000000000000f,   //  7451: sin(40.9295654)
   0.6552031887047318200000000000f,   //  7452: sin(40.9350586)
   0.6552756138138475800000000000f,   //  7453: sin(40.9405518)
   0.6553480328998104700000000000f,   //  7454: sin(40.9460449)
   0.6554204459619549200000000000f,   //  7455: sin(40.9515381)
   0.6554928529996153500000000000f,   //  7456: sin(40.9570313)
   0.6555652540121260600000000000f,   //  7457: sin(40.9625244)
   0.6556376489988218200000000000f,   //  7458: sin(40.9680176)
   0.6557100379590369300000000000f,   //  7459: sin(40.9735107)
   0.6557824208921060300000000000f,   //  7460: sin(40.9790039)
   0.6558547977973640000000000000f,   //  7461: sin(40.9844971)
   0.6559271686741453600000000000f,   //  7462: sin(40.9899902)
   0.6559995335217849700000000000f,   //  7463: sin(40.9954834)
   0.6560718923396176000000000000f,   //  7464: sin(41.0009766)
   0.6561442451269783300000000000f,   //  7465: sin(41.0064697)
   0.6562165918832019200000000000f,   //  7466: sin(41.0119629)
   0.6562889326076234400000000000f,   //  7467: sin(41.0174561)
   0.6563612672995780000000000000f,   //  7468: sin(41.0229492)
   0.6564335959584005600000000000f,   //  7469: sin(41.0284424)
   0.6565059185834265500000000000f,   //  7470: sin(41.0339355)
   0.6565782351739908300000000000f,   //  7471: sin(41.0394287)
   0.6566505457294289400000000000f,   //  7472: sin(41.0449219)
   0.6567228502490762800000000000f,   //  7473: sin(41.0504150)
   0.6567951487322680700000000000f,   //  7474: sin(41.0559082)
   0.6568674411783398400000000000f,   //  7475: sin(41.0614014)
   0.6569397275866271100000000000f,   //  7476: sin(41.0668945)
   0.6570120079564653000000000000f,   //  7477: sin(41.0723877)
   0.6570842822871901800000000000f,   //  7478: sin(41.0778809)
   0.6571565505781373800000000000f,   //  7479: sin(41.0833740)
   0.6572288128286425400000000000f,   //  7480: sin(41.0888672)
   0.6573010690380415300000000000f,   //  7481: sin(41.0943604)
   0.6573733192056702100000000000f,   //  7482: sin(41.0998535)
   0.6574455633308644600000000000f,   //  7483: sin(41.1053467)
   0.6575178014129601200000000000f,   //  7484: sin(41.1108398)
   0.6575900334512933000000000000f,   //  7485: sin(41.1163330)
   0.6576622594452000700000000000f,   //  7486: sin(41.1218262)
   0.6577344793940164100000000000f,   //  7487: sin(41.1273193)
   0.6578066932970786400000000000f,   //  7488: sin(41.1328125)
   0.6578789011537229400000000000f,   //  7489: sin(41.1383057)
   0.6579511029632855200000000000f,   //  7490: sin(41.1437988)
   0.6580232987251027900000000000f,   //  7491: sin(41.1492920)
   0.6580954884385111800000000000f,   //  7492: sin(41.1547852)
   0.6581676721028471000000000000f,   //  7493: sin(41.1602783)
   0.6582398497174468700000000000f,   //  7494: sin(41.1657715)
   0.6583120212816474500000000000f,   //  7495: sin(41.1712646)
   0.6583841867947850500000000000f,   //  7496: sin(41.1767578)
   0.6584563462561966500000000000f,   //  7497: sin(41.1822510)
   0.6585284996652186500000000000f,   //  7498: sin(41.1877441)
   0.6586006470211881500000000000f,   //  7499: sin(41.1932373)
   0.6586727883234418900000000000f,   //  7500: sin(41.1987305)
   0.6587449235713166400000000000f,   //  7501: sin(41.2042236)
   0.6588170527641494800000000000f,   //  7502: sin(41.2097168)
   0.6588891759012772700000000000f,   //  7503: sin(41.2152100)
   0.6589612929820373200000000000f,   //  7504: sin(41.2207031)
   0.6590334040057664900000000000f,   //  7505: sin(41.2261963)
   0.6591055089718020900000000000f,   //  7506: sin(41.2316895)
   0.6591776078794814300000000000f,   //  7507: sin(41.2371826)
   0.6592497007281414900000000000f,   //  7508: sin(41.2426758)
   0.6593217875171198900000000000f,   //  7509: sin(41.2481689)
   0.6593938682457538600000000000f,   //  7510: sin(41.2536621)
   0.6594659429133809000000000000f,   //  7511: sin(41.2591553)
   0.6595380115193386600000000000f,   //  7512: sin(41.2646484)
   0.6596100740629644600000000000f,   //  7513: sin(41.2701416)
   0.6596821305435961500000000000f,   //  7514: sin(41.2756348)
   0.6597541809605711500000000000f,   //  7515: sin(41.2811279)
   0.6598262253132273200000000000f,   //  7516: sin(41.2866211)
   0.6598982636009025300000000000f,   //  7517: sin(41.2921143)
   0.6599702958229345400000000000f,   //  7518: sin(41.2976074)
   0.6600423219786612000000000000f,   //  7519: sin(41.3031006)
   0.6601143420674204800000000000f,   //  7520: sin(41.3085938)
   0.6601863560885503600000000000f,   //  7521: sin(41.3140869)
   0.6602583640413890500000000000f,   //  7522: sin(41.3195801)
   0.6603303659252745000000000000f,   //  7523: sin(41.3250732)
   0.6604023617395450300000000000f,   //  7524: sin(41.3305664)
   0.6604743514835386100000000000f,   //  7525: sin(41.3360596)
   0.6605463351565938900000000000f,   //  7526: sin(41.3415527)
   0.6606183127580489400000000000f,   //  7527: sin(41.3470459)
   0.6606902842872423000000000000f,   //  7528: sin(41.3525391)
   0.6607622497435123900000000000f,   //  7529: sin(41.3580322)
   0.6608342091261976100000000000f,   //  7530: sin(41.3635254)
   0.6609061624346366200000000000f,   //  7531: sin(41.3690186)
   0.6609781096681680600000000000f,   //  7532: sin(41.3745117)
   0.6610500508261305500000000000f,   //  7533: sin(41.3800049)
   0.6611219859078628600000000000f,   //  7534: sin(41.3854980)
   0.6611939149127038500000000000f,   //  7535: sin(41.3909912)
   0.6612658378399922700000000000f,   //  7536: sin(41.3964844)
   0.6613377546890668600000000000f,   //  7537: sin(41.4019775)
   0.6614096654592669400000000000f,   //  7538: sin(41.4074707)
   0.6614815701499312500000000000f,   //  7539: sin(41.4129639)
   0.6615534687603988900000000000f,   //  7540: sin(41.4184570)
   0.6616253612900091500000000000f,   //  7541: sin(41.4239502)
   0.6616972477381010100000000000f,   //  7542: sin(41.4294434)
   0.6617691281040137800000000000f,   //  7543: sin(41.4349365)
   0.6618410023870868700000000000f,   //  7544: sin(41.4404297)
   0.6619128705866593700000000000f,   //  7545: sin(41.4459229)
   0.6619847327020709200000000000f,   //  7546: sin(41.4514160)
   0.6620565887326608200000000000f,   //  7547: sin(41.4569092)
   0.6621284386777687200000000000f,   //  7548: sin(41.4624023)
   0.6622002825367341300000000000f,   //  7549: sin(41.4678955)
   0.6622721203088965900000000000f,   //  7550: sin(41.4733887)
   0.6623439519935958600000000000f,   //  7551: sin(41.4788818)
   0.6624157775901717800000000000f,   //  7552: sin(41.4843750)
   0.6624875970979640100000000000f,   //  7553: sin(41.4898682)
   0.6625594105163122900000000000f,   //  7554: sin(41.4953613)
   0.6626312178445568100000000000f,   //  7555: sin(41.5008545)
   0.6627030190820374400000000000f,   //  7556: sin(41.5063477)
   0.6627748142280940300000000000f,   //  7557: sin(41.5118408)
   0.6628466032820669000000000000f,   //  7558: sin(41.5173340)
   0.6629183862432959100000000000f,   //  7559: sin(41.5228271)
   0.6629901631111214700000000000f,   //  7560: sin(41.5283203)
   0.6630619338848837700000000000f,   //  7561: sin(41.5338135)
   0.6631336985639230100000000000f,   //  7562: sin(41.5393066)
   0.6632054571475797200000000000f,   //  7563: sin(41.5447998)
   0.6632772096351941000000000000f,   //  7564: sin(41.5502930)
   0.6633489560261067700000000000f,   //  7565: sin(41.5557861)
   0.6634206963196582800000000000f,   //  7566: sin(41.5612793)
   0.6634924305151890200000000000f,   //  7567: sin(41.5667725)
   0.6635641586120397700000000000f,   //  7568: sin(41.5722656)
   0.6636358806095512500000000000f,   //  7569: sin(41.5777588)
   0.6637075965070640100000000000f,   //  7570: sin(41.5832520)
   0.6637793063039192400000000000f,   //  7571: sin(41.5887451)
   0.6638510099994573400000000000f,   //  7572: sin(41.5942383)
   0.6639227075930195200000000000f,   //  7573: sin(41.5997314)
   0.6639943990839466400000000000f,   //  7574: sin(41.6052246)
   0.6640660844715797800000000000f,   //  7575: sin(41.6107178)
   0.6641377637552600100000000000f,   //  7576: sin(41.6162109)
   0.6642094369343283200000000000f,   //  7577: sin(41.6217041)
   0.6642811040081262300000000000f,   //  7578: sin(41.6271973)
   0.6643527649759947100000000000f,   //  7579: sin(41.6326904)
   0.6644244198372751800000000000f,   //  7580: sin(41.6381836)
   0.6644960685913089400000000000f,   //  7581: sin(41.6436768)
   0.6645677112374375200000000000f,   //  7582: sin(41.6491699)
   0.6646393477750023300000000000f,   //  7583: sin(41.6546631)
   0.6647109782033447900000000000f,   //  7584: sin(41.6601563)
   0.6647826025218067600000000000f,   //  7585: sin(41.6656494)
   0.6648542207297296600000000000f,   //  7586: sin(41.6711426)
   0.6649258328264552300000000000f,   //  7587: sin(41.6766357)
   0.6649974388113253400000000000f,   //  7588: sin(41.6821289)
   0.6650690386836816100000000000f,   //  7589: sin(41.6876221)
   0.6651406324428661400000000000f,   //  7590: sin(41.6931152)
   0.6652122200882205600000000000f,   //  7591: sin(41.6986084)
   0.6652838016190871800000000000f,   //  7592: sin(41.7041016)
   0.6653553770348078500000000000f,   //  7593: sin(41.7095947)
   0.6654269463347246600000000000f,   //  7594: sin(41.7150879)
   0.6654985095181797900000000000f,   //  7595: sin(41.7205811)
   0.6655700665845154500000000000f,   //  7596: sin(41.7260742)
   0.6656416175330740500000000000f,   //  7597: sin(41.7315674)
   0.6657131623631975500000000000f,   //  7598: sin(41.7370605)
   0.6657847010742286000000000000f,   //  7599: sin(41.7425537)
   0.6658562336655097200000000000f,   //  7600: sin(41.7480469)
   0.6659277601363831100000000000f,   //  7601: sin(41.7535400)
   0.6659992804861915000000000000f,   //  7602: sin(41.7590332)
   0.6660707947142774400000000000f,   //  7603: sin(41.7645264)
   0.6661423028199835400000000000f,   //  7604: sin(41.7700195)
   0.6662138048026525800000000000f,   //  7605: sin(41.7755127)
   0.6662853006616272800000000000f,   //  7606: sin(41.7810059)
   0.6663567903962506200000000000f,   //  7607: sin(41.7864990)
   0.6664282740058652400000000000f,   //  7608: sin(41.7919922)
   0.6664997514898142200000000000f,   //  7609: sin(41.7974854)
   0.6665712228474406400000000000f,   //  7610: sin(41.8029785)
   0.6666426880780873500000000000f,   //  7611: sin(41.8084717)
   0.6667141471810976700000000000f,   //  7612: sin(41.8139648)
   0.6667856001558144500000000000f,   //  7613: sin(41.8194580)
   0.6668570470015812200000000000f,   //  7614: sin(41.8249512)
   0.6669284877177411600000000000f,   //  7615: sin(41.8304443)
   0.6669999223036374700000000000f,   //  7616: sin(41.8359375)
   0.6670713507586137900000000000f,   //  7617: sin(41.8414307)
   0.6671427730820133100000000000f,   //  7618: sin(41.8469238)
   0.6672141892731796600000000000f,   //  7619: sin(41.8524170)
   0.6672855993314563700000000000f,   //  7620: sin(41.8579102)
   0.6673570032561870800000000000f,   //  7621: sin(41.8634033)
   0.6674284010467155200000000000f,   //  7622: sin(41.8688965)
   0.6674997927023853500000000000f,   //  7623: sin(41.8743896)
   0.6675711782225403100000000000f,   //  7624: sin(41.8798828)
   0.6676425576065242500000000000f,   //  7625: sin(41.8853760)
   0.6677139308536810300000000000f,   //  7626: sin(41.8908691)
   0.6677852979633548400000000000f,   //  7627: sin(41.8963623)
   0.6678566589348893200000000000f,   //  7628: sin(41.9018555)
   0.6679280137676288900000000000f,   //  7629: sin(41.9073486)
   0.6679993624609174000000000000f,   //  7630: sin(41.9128418)
   0.6680707050140991500000000000f,   //  7631: sin(41.9183350)
   0.6681420414265184500000000000f,   //  7632: sin(41.9238281)
   0.6682133716975194900000000000f,   //  7633: sin(41.9293213)
   0.6682846958264466700000000000f,   //  7634: sin(41.9348145)
   0.6683560138126442000000000000f,   //  7635: sin(41.9403076)
   0.6684273256554568200000000000f,   //  7636: sin(41.9458008)
   0.6684986313542289300000000000f,   //  7637: sin(41.9512939)
   0.6685699309083049700000000000f,   //  7638: sin(41.9567871)
   0.6686412243170298800000000000f,   //  7639: sin(41.9622803)
   0.6687125115797479800000000000f,   //  7640: sin(41.9677734)
   0.6687837926958043500000000000f,   //  7641: sin(41.9732666)
   0.6688550676645436100000000000f,   //  7642: sin(41.9787598)
   0.6689263364853105200000000000f,   //  7643: sin(41.9842529)
   0.6689975991574502700000000000f,   //  7644: sin(41.9897461)
   0.6690688556803076100000000000f,   //  7645: sin(41.9952393)
   0.6691401060532276000000000000f,   //  7646: sin(42.0007324)
   0.6692113502755553400000000000f,   //  7647: sin(42.0062256)
   0.6692825883466360100000000000f,   //  7648: sin(42.0117188)
   0.6693538202658148000000000000f,   //  7649: sin(42.0172119)
   0.6694250460324369100000000000f,   //  7650: sin(42.0227051)
   0.6694962656458477400000000000f,   //  7651: sin(42.0281982)
   0.6695674791053924900000000000f,   //  7652: sin(42.0336914)
   0.6696386864104166800000000000f,   //  7653: sin(42.0391846)
   0.6697098875602658400000000000f,   //  7654: sin(42.0446777)
   0.6697810825542853700000000000f,   //  7655: sin(42.0501709)
   0.6698522713918210200000000000f,   //  7656: sin(42.0556641)
   0.6699234540722183200000000000f,   //  7657: sin(42.0611572)
   0.6699946305948230000000000000f,   //  7658: sin(42.0666504)
   0.6700658009589809400000000000f,   //  7659: sin(42.0721436)
   0.6701369651640376500000000000f,   //  7660: sin(42.0776367)
   0.6702081232093394200000000000f,   //  7661: sin(42.0831299)
   0.6702792750942318000000000000f,   //  7662: sin(42.0886230)
   0.6703504208180610700000000000f,   //  7663: sin(42.0941162)
   0.6704215603801730900000000000f,   //  7664: sin(42.0996094)
   0.6704926937799139400000000000f,   //  7665: sin(42.1051025)
   0.6705638210166300400000000000f,   //  7666: sin(42.1105957)
   0.6706349420896672300000000000f,   //  7667: sin(42.1160889)
   0.6707060569983721600000000000f,   //  7668: sin(42.1215820)
   0.6707771657420907900000000000f,   //  7669: sin(42.1270752)
   0.6708482683201696400000000000f,   //  7670: sin(42.1325684)
   0.6709193647319553500000000000f,   //  7671: sin(42.1380615)
   0.6709904549767942200000000000f,   //  7672: sin(42.1435547)
   0.6710615390540328700000000000f,   //  7673: sin(42.1490479)
   0.6711326169630177400000000000f,   //  7674: sin(42.1545410)
   0.6712036887030956600000000000f,   //  7675: sin(42.1600342)
   0.6712747542736134900000000000f,   //  7676: sin(42.1655273)
   0.6713458136739177700000000000f,   //  7677: sin(42.1710205)
   0.6714168669033554500000000000f,   //  7678: sin(42.1765137)
   0.6714879139612732800000000000f,   //  7679: sin(42.1820068)
   0.6715589548470183300000000000f,   //  7680: sin(42.1875000)
   0.6716299895599376900000000000f,   //  7681: sin(42.1929932)
   0.6717010180993783200000000000f,   //  7682: sin(42.1984863)
   0.6717720404646874100000000000f,   //  7683: sin(42.2039795)
   0.6718430566552119300000000000f,   //  7684: sin(42.2094727)
   0.6719140666702994000000000000f,   //  7685: sin(42.2149658)
   0.6719850705092969000000000000f,   //  7686: sin(42.2204590)
   0.6720560681715518300000000000f,   //  7687: sin(42.2259521)
   0.6721270596564117300000000000f,   //  7688: sin(42.2314453)
   0.6721980449632238800000000000f,   //  7689: sin(42.2369385)
   0.6722690240913359300000000000f,   //  7690: sin(42.2424316)
   0.6723399970400953900000000000f,   //  7691: sin(42.2479248)
   0.6724109638088497900000000000f,   //  7692: sin(42.2534180)
   0.6724819243969470900000000000f,   //  7693: sin(42.2589111)
   0.6725528788037347100000000000f,   //  7694: sin(42.2644043)
   0.6726238270285608300000000000f,   //  7695: sin(42.2698975)
   0.6726947690707728600000000000f,   //  7696: sin(42.2753906)
   0.6727657049297191000000000000f,   //  7697: sin(42.2808838)
   0.6728366346047473000000000000f,   //  7698: sin(42.2863770)
   0.6729075580952055300000000000f,   //  7699: sin(42.2918701)
   0.6729784754004420900000000000f,   //  7700: sin(42.2973633)
   0.6730493865198047300000000000f,   //  7701: sin(42.3028564)
   0.6731202914526420700000000000f,   //  7702: sin(42.3083496)
   0.6731911901983019800000000000f,   //  7703: sin(42.3138428)
   0.6732620827561329700000000000f,   //  7704: sin(42.3193359)
   0.6733329691254834600000000000f,   //  7705: sin(42.3248291)
   0.6734038493057017400000000000f,   //  7706: sin(42.3303223)
   0.6734747232961365600000000000f,   //  7707: sin(42.3358154)
   0.6735455910961361000000000000f,   //  7708: sin(42.3413086)
   0.6736164527050491100000000000f,   //  7709: sin(42.3468018)
   0.6736873081222243300000000000f,   //  7710: sin(42.3522949)
   0.6737581573470103900000000000f,   //  7711: sin(42.3577881)
   0.6738290003787560400000000000f,   //  7712: sin(42.3632813)
   0.6738998372168101300000000000f,   //  7713: sin(42.3687744)
   0.6739706678605216200000000000f,   //  7714: sin(42.3742676)
   0.6740414923092393800000000000f,   //  7715: sin(42.3797607)
   0.6741123105623123600000000000f,   //  7716: sin(42.3852539)
   0.6741831226190897500000000000f,   //  7717: sin(42.3907471)
   0.6742539284789204100000000000f,   //  7718: sin(42.3962402)
   0.6743247281411537400000000000f,   //  7719: sin(42.4017334)
   0.6743955216051390500000000000f,   //  7720: sin(42.4072266)
   0.6744663088702253000000000000f,   //  7721: sin(42.4127197)
   0.6745370899357620000000000000f,   //  7722: sin(42.4182129)
   0.6746078648010985800000000000f,   //  7723: sin(42.4237061)
   0.6746786334655845400000000000f,   //  7724: sin(42.4291992)
   0.6747493959285692000000000000f,   //  7725: sin(42.4346924)
   0.6748201521894021700000000000f,   //  7726: sin(42.4401855)
   0.6748909022474333100000000000f,   //  7727: sin(42.4456787)
   0.6749616461020119300000000000f,   //  7728: sin(42.4511719)
   0.6750323837524882000000000000f,   //  7729: sin(42.4566650)
   0.6751031151982114200000000000f,   //  7730: sin(42.4621582)
   0.6751738404385317900000000000f,   //  7731: sin(42.4676514)
   0.6752445594727992700000000000f,   //  7732: sin(42.4731445)
   0.6753152723003635900000000000f,   //  7733: sin(42.4786377)
   0.6753859789205748400000000000f,   //  7734: sin(42.4841309)
   0.6754566793327830800000000000f,   //  7735: sin(42.4896240)
   0.6755273735363385200000000000f,   //  7736: sin(42.4951172)
   0.6755980615305914300000000000f,   //  7737: sin(42.5006104)
   0.6756687433148919100000000000f,   //  7738: sin(42.5061035)
   0.6757394188885903500000000000f,   //  7739: sin(42.5115967)
   0.6758100882510369400000000000f,   //  7740: sin(42.5170898)
   0.6758807514015823200000000000f,   //  7741: sin(42.5225830)
   0.6759514083395770100000000000f,   //  7742: sin(42.5280762)
   0.6760220590643712900000000000f,   //  7743: sin(42.5335693)
   0.6760927035753159200000000000f,   //  7744: sin(42.5390625)
   0.6761633418717615300000000000f,   //  7745: sin(42.5445557)
   0.6762339739530589500000000000f,   //  7746: sin(42.5500488)
   0.6763045998185586200000000000f,   //  7747: sin(42.5555420)
   0.6763752194676115900000000000f,   //  7748: sin(42.5610352)
   0.6764458328995688300000000000f,   //  7749: sin(42.5665283)
   0.6765164401137810900000000000f,   //  7750: sin(42.5720215)
   0.6765870411095994400000000000f,   //  7751: sin(42.5775146)
   0.6766576358863749500000000000f,   //  7752: sin(42.5830078)
   0.6767282244434585900000000000f,   //  7753: sin(42.5885010)
   0.6767988067802017700000000000f,   //  7754: sin(42.5939941)
   0.6768693828959554400000000000f,   //  7755: sin(42.5994873)
   0.6769399527900711300000000000f,   //  7756: sin(42.6049805)
   0.6770105164619000200000000000f,   //  7757: sin(42.6104736)
   0.6770810739107935300000000000f,   //  7758: sin(42.6159668)
   0.6771516251361031600000000000f,   //  7759: sin(42.6214600)
   0.6772221701371803300000000000f,   //  7760: sin(42.6269531)
   0.6772927089133767800000000000f,   //  7761: sin(42.6324463)
   0.6773632414640439200000000000f,   //  7762: sin(42.6379395)
   0.6774337677885334800000000000f,   //  7763: sin(42.6434326)
   0.6775042878861974300000000000f,   //  7764: sin(42.6489258)
   0.6775748017563871800000000000f,   //  7765: sin(42.6544189)
   0.6776453093984549100000000000f,   //  7766: sin(42.6599121)
   0.6777158108117522500000000000f,   //  7767: sin(42.6654053)
   0.6777863059956315000000000000f,   //  7768: sin(42.6708984)
   0.6778567949494444000000000000f,   //  7769: sin(42.6763916)
   0.6779272776725430200000000000f,   //  7770: sin(42.6818848)
   0.6779977541642797600000000000f,   //  7771: sin(42.6873779)
   0.6780682244240066000000000000f,   //  7772: sin(42.6928711)
   0.6781386884510758300000000000f,   //  7773: sin(42.6983643)
   0.6782091462448398600000000000f,   //  7774: sin(42.7038574)
   0.6782795978046508600000000000f,   //  7775: sin(42.7093506)
   0.6783500431298614700000000000f,   //  7776: sin(42.7148438)
   0.6784204822198239800000000000f,   //  7777: sin(42.7203369)
   0.6784909150738911400000000000f,   //  7778: sin(42.7258301)
   0.6785613416914153500000000000f,   //  7779: sin(42.7313232)
   0.6786317620717493600000000000f,   //  7780: sin(42.7368164)
   0.6787021762142458900000000000f,   //  7781: sin(42.7423096)
   0.6787725841182576900000000000f,   //  7782: sin(42.7478027)
   0.6788429857831376200000000000f,   //  7783: sin(42.7532959)
   0.6789133812082384100000000000f,   //  7784: sin(42.7587891)
   0.6789837703929131300000000000f,   //  7785: sin(42.7642822)
   0.6790541533365148700000000000f,   //  7786: sin(42.7697754)
   0.6791245300383964600000000000f,   //  7787: sin(42.7752686)
   0.6791949004979112000000000000f,   //  7788: sin(42.7807617)
   0.6792652647144120600000000000f,   //  7789: sin(42.7862549)
   0.6793356226872525600000000000f,   //  7790: sin(42.7917480)
   0.6794059744157857600000000000f,   //  7791: sin(42.7972412)
   0.6794763198993649700000000000f,   //  7792: sin(42.8027344)
   0.6795466591373438000000000000f,   //  7793: sin(42.8082275)
   0.6796169921290755600000000000f,   //  7794: sin(42.8137207)
   0.6796873188739137600000000000f,   //  7795: sin(42.8192139)
   0.6797576393712120300000000000f,   //  7796: sin(42.8247070)
   0.6798279536203238900000000000f,   //  7797: sin(42.8302002)
   0.6798982616206032900000000000f,   //  7798: sin(42.8356934)
   0.6799685633714036600000000000f,   //  7799: sin(42.8411865)
   0.6800388588720789300000000000f,   //  7800: sin(42.8466797)
   0.6801091481219829800000000000f,   //  7801: sin(42.8521729)
   0.6801794311204697500000000000f,   //  7802: sin(42.8576660)
   0.6802497078668932100000000000f,   //  7803: sin(42.8631592)
   0.6803199783606072000000000000f,   //  7804: sin(42.8686523)
   0.6803902426009661400000000000f,   //  7805: sin(42.8741455)
   0.6804605005873238800000000000f,   //  7806: sin(42.8796387)
   0.6805307523190347000000000000f,   //  7807: sin(42.8851318)
   0.6806009977954530200000000000f,   //  7808: sin(42.8906250)
   0.6806712370159330200000000000f,   //  7809: sin(42.8961182)
   0.6807414699798290900000000000f,   //  7810: sin(42.9016113)
   0.6808116966864956600000000000f,   //  7811: sin(42.9071045)
   0.6808819171352872300000000000f,   //  7812: sin(42.9125977)
   0.6809521313255583200000000000f,   //  7813: sin(42.9180908)
   0.6810223392566636700000000000f,   //  7814: sin(42.9235840)
   0.6810925409279577900000000000f,   //  7815: sin(42.9290771)
   0.6811627363387954300000000000f,   //  7816: sin(42.9345703)
   0.6812329254885314300000000000f,   //  7817: sin(42.9400635)
   0.6813031083765205300000000000f,   //  7818: sin(42.9455566)
   0.6813732850021176900000000000f,   //  7819: sin(42.9510498)
   0.6814434553646778700000000000f,   //  7820: sin(42.9565430)
   0.6815136194635560400000000000f,   //  7821: sin(42.9620361)
   0.6815837772981074800000000000f,   //  7822: sin(42.9675293)
   0.6816539288676869400000000000f,   //  7823: sin(42.9730225)
   0.6817240741716497100000000000f,   //  7824: sin(42.9785156)
   0.6817942132093513000000000000f,   //  7825: sin(42.9840088)
   0.6818643459801466700000000000f,   //  7826: sin(42.9895020)
   0.6819344724833914500000000000f,   //  7827: sin(42.9949951)
   0.6820045927184408300000000000f,   //  7828: sin(43.0004883)
   0.6820747066846503100000000000f,   //  7829: sin(43.0059814)
   0.6821448143813756400000000000f,   //  7830: sin(43.0114746)
   0.6822149158079721100000000000f,   //  7831: sin(43.0169678)
   0.6822850109637955700000000000f,   //  7832: sin(43.0224609)
   0.6823550998482015300000000000f,   //  7833: sin(43.0279541)
   0.6824251824605460600000000000f,   //  7834: sin(43.0334473)
   0.6824952588001845800000000000f,   //  7835: sin(43.0389404)
   0.6825653288664732500000000000f,   //  7836: sin(43.0444336)
   0.6826353926587679400000000000f,   //  7837: sin(43.0499268)
   0.6827054501764245900000000000f,   //  7838: sin(43.0554199)
   0.6827755014187992800000000000f,   //  7839: sin(43.0609131)
   0.6828455463852480800000000000f,   //  7840: sin(43.0664063)
   0.6829155850751270600000000000f,   //  7841: sin(43.0718994)
   0.6829856174877927400000000000f,   //  7842: sin(43.0773926)
   0.6830556436226011800000000000f,   //  7843: sin(43.0828857)
   0.6831256634789086800000000000f,   //  7844: sin(43.0883789)
   0.6831956770560717600000000000f,   //  7845: sin(43.0938721)
   0.6832656843534467000000000000f,   //  7846: sin(43.0993652)
   0.6833356853703902400000000000f,   //  7847: sin(43.1048584)
   0.6834056801062586800000000000f,   //  7848: sin(43.1103516)
   0.6834756685604089800000000000f,   //  7849: sin(43.1158447)
   0.6835456507321975300000000000f,   //  7850: sin(43.1213379)
   0.6836156266209810800000000000f,   //  7851: sin(43.1268311)
   0.6836855962261165800000000000f,   //  7852: sin(43.1323242)
   0.6837555595469608800000000000f,   //  7853: sin(43.1378174)
   0.6838255165828707200000000000f,   //  7854: sin(43.1433105)
   0.6838954673332032800000000000f,   //  7855: sin(43.1488037)
   0.6839654117973154000000000000f,   //  7856: sin(43.1542969)
   0.6840353499745642800000000000f,   //  7857: sin(43.1597900)
   0.6841052818643070800000000000f,   //  7858: sin(43.1652832)
   0.6841752074659008800000000000f,   //  7859: sin(43.1707764)
   0.6842451267787030800000000000f,   //  7860: sin(43.1762695)
   0.6843150398020708700000000000f,   //  7861: sin(43.1817627)
   0.6843849465353617500000000000f,   //  7862: sin(43.1872559)
   0.6844548469779330200000000000f,   //  7863: sin(43.1927490)
   0.6845247411291423000000000000f,   //  7864: sin(43.1982422)
   0.6845946289883470000000000000f,   //  7865: sin(43.2037354)
   0.6846645105549049600000000000f,   //  7866: sin(43.2092285)
   0.6847343858281734800000000000f,   //  7867: sin(43.2147217)
   0.6848042548075106200000000000f,   //  7868: sin(43.2202148)
   0.6848741174922740000000000000f,   //  7869: sin(43.2257080)
   0.6849439738818214900000000000f,   //  7870: sin(43.2312012)
   0.6850138239755109200000000000f,   //  7871: sin(43.2366943)
   0.6850836677727003600000000000f,   //  7872: sin(43.2421875)
   0.6851535052727477600000000000f,   //  7873: sin(43.2476807)
   0.6852233364750112100000000000f,   //  7874: sin(43.2531738)
   0.6852931613788487700000000000f,   //  7875: sin(43.2586670)
   0.6853629799836187300000000000f,   //  7876: sin(43.2641602)
   0.6854327922886791500000000000f,   //  7877: sin(43.2696533)
   0.6855025982933885500000000000f,   //  7878: sin(43.2751465)
   0.6855723979971052300000000000f,   //  7879: sin(43.2806396)
   0.6856421913991874700000000000f,   //  7880: sin(43.2861328)
   0.6857119784989939000000000000f,   //  7881: sin(43.2916260)
   0.6857817592958830300000000000f,   //  7882: sin(43.2971191)
   0.6858515337892133700000000000f,   //  7883: sin(43.3026123)
   0.6859213019783435600000000000f,   //  7884: sin(43.3081055)
   0.6859910638626324200000000000f,   //  7885: sin(43.3135986)
   0.6860608194414387100000000000f,   //  7886: sin(43.3190918)
   0.6861305687141210400000000000f,   //  7887: sin(43.3245850)
   0.6862003116800385900000000000f,   //  7888: sin(43.3300781)
   0.6862700483385501000000000000f,   //  7889: sin(43.3355713)
   0.6863397786890145200000000000f,   //  7890: sin(43.3410645)
   0.6864095027307911500000000000f,   //  7891: sin(43.3465576)
   0.6864792204632389500000000000f,   //  7892: sin(43.3520508)
   0.6865489318857170800000000000f,   //  7893: sin(43.3575439)
   0.6866186369975846300000000000f,   //  7894: sin(43.3630371)
   0.6866883357982011000000000000f,   //  7895: sin(43.3685303)
   0.6867580282869258900000000000f,   //  7896: sin(43.3740234)
   0.6868277144631181900000000000f,   //  7897: sin(43.3795166)
   0.6868973943261376100000000000f,   //  7898: sin(43.3850098)
   0.6869670678753434500000000000f,   //  7899: sin(43.3905029)
   0.6870367351100956600000000000f,   //  7900: sin(43.3959961)
   0.6871063960297535400000000000f,   //  7901: sin(43.4014893)
   0.6871760506336768200000000000f,   //  7902: sin(43.4069824)
   0.6872456989212254500000000000f,   //  7903: sin(43.4124756)
   0.6873153408917590500000000000f,   //  7904: sin(43.4179688)
   0.6873849765446377000000000000f,   //  7905: sin(43.4234619)
   0.6874546058792210300000000000f,   //  7906: sin(43.4289551)
   0.6875242288948690800000000000f,   //  7907: sin(43.4344482)
   0.6875938455909421700000000000f,   //  7908: sin(43.4399414)
   0.6876634559668001200000000000f,   //  7909: sin(43.4454346)
   0.6877330600218032300000000000f,   //  7910: sin(43.4509277)
   0.6878026577553115800000000000f,   //  7911: sin(43.4564209)
   0.6878722491666855500000000000f,   //  7912: sin(43.4619141)
   0.6879418342552854300000000000f,   //  7913: sin(43.4674072)
   0.6880114130204716400000000000f,   //  7914: sin(43.4729004)
   0.6880809854616045700000000000f,   //  7915: sin(43.4783936)
   0.6881505515780448300000000000f,   //  7916: sin(43.4838867)
   0.6882201113691528400000000000f,   //  7917: sin(43.4893799)
   0.6882896648342893300000000000f,   //  7918: sin(43.4948730)
   0.6883592119728149100000000000f,   //  7919: sin(43.5003662)
   0.6884287527840904400000000000f,   //  7920: sin(43.5058594)
   0.6884982872674765300000000000f,   //  7921: sin(43.5113525)
   0.6885678154223342500000000000f,   //  7922: sin(43.5168457)
   0.6886373372480243400000000000f,   //  7923: sin(43.5223389)
   0.6887068527439077500000000000f,   //  7924: sin(43.5278320)
   0.6887763619093456600000000000f,   //  7925: sin(43.5333252)
   0.6888458647436990200000000000f,   //  7926: sin(43.5388184)
   0.6889153612463291300000000000f,   //  7927: sin(43.5443115)
   0.6889848514165970400000000000f,   //  7928: sin(43.5498047)
   0.6890543352538640600000000000f,   //  7929: sin(43.5552979)
   0.6891238127574915700000000000f,   //  7930: sin(43.5607910)
   0.6891932839268408700000000000f,   //  7931: sin(43.5662842)
   0.6892627487612734700000000000f,   //  7932: sin(43.5717773)
   0.6893322072601507600000000000f,   //  7933: sin(43.5772705)
   0.6894016594228342700000000000f,   //  7934: sin(43.5827637)
   0.6894711052486858200000000000f,   //  7935: sin(43.5882568)
   0.6895405447370668300000000000f,   //  7936: sin(43.5937500)
   0.6896099778873393500000000000f,   //  7937: sin(43.5992432)
   0.6896794046988648000000000000f,   //  7938: sin(43.6047363)
   0.6897488251710051100000000000f,   //  7939: sin(43.6102295)
   0.6898182393031224700000000000f,   //  7940: sin(43.6157227)
   0.6898876470945785000000000000f,   //  7941: sin(43.6212158)
   0.6899570485447353900000000000f,   //  7942: sin(43.6267090)
   0.6900264436529550700000000000f,   //  7943: sin(43.6322021)
   0.6900958324185999500000000000f,   //  7944: sin(43.6376953)
   0.6901652148410318800000000000f,   //  7945: sin(43.6431885)
   0.6902345909196133700000000000f,   //  7946: sin(43.6486816)
   0.6903039606537066900000000000f,   //  7947: sin(43.6541748)
   0.6903733240426740400000000000f,   //  7948: sin(43.6596680)
   0.6904426810858780300000000000f,   //  7949: sin(43.6651611)
   0.6905120317826810600000000000f,   //  7950: sin(43.6706543)
   0.6905813761324457500000000000f,   //  7951: sin(43.6761475)
   0.6906507141345346000000000000f,   //  7952: sin(43.6816406)
   0.6907200457883103700000000000f,   //  7953: sin(43.6871338)
   0.6907893710931356500000000000f,   //  7954: sin(43.6926270)
   0.6908586900483733000000000000f,   //  7955: sin(43.6981201)
   0.6909280026533861600000000000f,   //  7956: sin(43.7036133)
   0.6909973089075371900000000000f,   //  7957: sin(43.7091064)
   0.6910666088101892200000000000f,   //  7958: sin(43.7145996)
   0.6911359023607053200000000000f,   //  7959: sin(43.7200928)
   0.6912051895584484500000000000f,   //  7960: sin(43.7255859)
   0.6912744704027817800000000000f,   //  7961: sin(43.7310791)
   0.6913437448930687100000000000f,   //  7962: sin(43.7365723)
   0.6914130130286722000000000000f,   //  7963: sin(43.7420654)
   0.6914822748089558500000000000f,   //  7964: sin(43.7475586)
   0.6915515302332826400000000000f,   //  7965: sin(43.7530518)
   0.6916207793010162900000000000f,   //  7966: sin(43.7585449)
   0.6916900220115200800000000000f,   //  7967: sin(43.7640381)
   0.6917592583641577500000000000f,   //  7968: sin(43.7695313)
   0.6918284883582928000000000000f,   //  7969: sin(43.7750244)
   0.6918977119932887600000000000f,   //  7970: sin(43.7805176)
   0.6919669292685095600000000000f,   //  7971: sin(43.7860107)
   0.6920361401833187200000000000f,   //  7972: sin(43.7915039)
   0.6921053447370803000000000000f,   //  7973: sin(43.7969971)
   0.6921745429291581400000000000f,   //  7974: sin(43.8024902)
   0.6922437347589159900000000000f,   //  7975: sin(43.8079834)
   0.6923129202257182200000000000f,   //  7976: sin(43.8134766)
   0.6923820993289284700000000000f,   //  7977: sin(43.8189697)
   0.6924512720679111300000000000f,   //  7978: sin(43.8244629)
   0.6925204384420303700000000000f,   //  7979: sin(43.8299561)
   0.6925895984506503800000000000f,   //  7980: sin(43.8354492)
   0.6926587520931354300000000000f,   //  7981: sin(43.8409424)
   0.6927278993688498200000000000f,   //  7982: sin(43.8464355)
   0.6927970402771580500000000000f,   //  7983: sin(43.8519287)
   0.6928661748174246300000000000f,   //  7984: sin(43.8574219)
   0.6929353029890140700000000000f,   //  7985: sin(43.8629150)
   0.6930044247912908700000000000f,   //  7986: sin(43.8684082)
   0.6930735402236197800000000000f,   //  7987: sin(43.8739014)
   0.6931426492853654000000000000f,   //  7988: sin(43.8793945)
   0.6932117519758925800000000000f,   //  7989: sin(43.8848877)
   0.6932808482945660400000000000f,   //  7990: sin(43.8903809)
   0.6933499382407508600000000000f,   //  7991: sin(43.8958740)
   0.6934190218138117600000000000f,   //  7992: sin(43.9013672)
   0.6934880990131139200000000000f,   //  7993: sin(43.9068604)
   0.6935571698380222900000000000f,   //  7994: sin(43.9123535)
   0.6936262342879019300000000000f,   //  7995: sin(43.9178467)
   0.6936952923621182400000000000f,   //  7996: sin(43.9233398)
   0.6937643440600362900000000000f,   //  7997: sin(43.9288330)
   0.6938333893810213500000000000f,   //  7998: sin(43.9343262)
   0.6939024283244387100000000000f,   //  7999: sin(43.9398193)
   0.6939714608896540000000000000f,   //  8000: sin(43.9453125)
   0.6940404870760325000000000000f,   //  8001: sin(43.9508057)
   0.6941095068829398200000000000f,   //  8002: sin(43.9562988)
   0.6941785203097415900000000000f,   //  8003: sin(43.9617920)
   0.6942475273558033100000000000f,   //  8004: sin(43.9672852)
   0.6943165280204907100000000000f,   //  8005: sin(43.9727783)
   0.6943855223031697400000000000f,   //  8006: sin(43.9782715)
   0.6944545102032060300000000000f,   //  8007: sin(43.9837646)
   0.6945234917199655200000000000f,   //  8008: sin(43.9892578)
   0.6945924668528140600000000000f,   //  8009: sin(43.9947510)
   0.6946614356011178200000000000f,   //  8010: sin(44.0002441)
   0.6947303979642427400000000000f,   //  8011: sin(44.0057373)
   0.6947993539415549000000000000f,   //  8012: sin(44.0112305)
   0.6948683035324205700000000000f,   //  8013: sin(44.0167236)
   0.6949372467362058300000000000f,   //  8014: sin(44.0222168)
   0.6950061835522772800000000000f,   //  8015: sin(44.0277100)
   0.6950751139800008800000000000f,   //  8016: sin(44.0332031)
   0.6951440380187432500000000000f,   //  8017: sin(44.0386963)
   0.6952129556678707800000000000f,   //  8018: sin(44.0441895)
   0.6952818669267500900000000000f,   //  8019: sin(44.0496826)
   0.6953507717947476900000000000f,   //  8020: sin(44.0551758)
   0.6954196702712303100000000000f,   //  8021: sin(44.0606689)
   0.6954885623555644400000000000f,   //  8022: sin(44.0661621)
   0.6955574480471170600000000000f,   //  8023: sin(44.0716553)
   0.6956263273452548700000000000f,   //  8024: sin(44.0771484)
   0.6956952002493448400000000000f,   //  8025: sin(44.0826416)
   0.6957640667587536900000000000f,   //  8026: sin(44.0881348)
   0.6958329268728487000000000000f,   //  8027: sin(44.0936279)
   0.6959017805909968300000000000f,   //  8028: sin(44.0991211)
   0.6959706279125650300000000000f,   //  8029: sin(44.1046143)
   0.6960394688369206900000000000f,   //  8030: sin(44.1101074)
   0.6961083033634308800000000000f,   //  8031: sin(44.1156006)
   0.6961771314914629900000000000f,   //  8032: sin(44.1210938)
   0.6962459532203841800000000000f,   //  8033: sin(44.1265869)
   0.6963147685495620900000000000f,   //  8034: sin(44.1320801)
   0.6963835774783642100000000000f,   //  8035: sin(44.1375732)
   0.6964523800061578300000000000f,   //  8036: sin(44.1430664)
   0.6965211761323106800000000000f,   //  8037: sin(44.1485596)
   0.6965899658561903700000000000f,   //  8038: sin(44.1540527)
   0.6966587491771645300000000000f,   //  8039: sin(44.1595459)
   0.6967275260946012000000000000f,   //  8040: sin(44.1650391)
   0.6967962966078677900000000000f,   //  8041: sin(44.1705322)
   0.6968650607163324700000000000f,   //  8042: sin(44.1760254)
   0.6969338184193629700000000000f,   //  8043: sin(44.1815186)
   0.6970025697163274600000000000f,   //  8044: sin(44.1870117)
   0.6970713146065938800000000000f,   //  8045: sin(44.1925049)
   0.6971400530895304200000000000f,   //  8046: sin(44.1979980)
   0.6972087851645052400000000000f,   //  8047: sin(44.2034912)
   0.6972775108308865200000000000f,   //  8048: sin(44.2089844)
   0.6973462300880425300000000000f,   //  8049: sin(44.2144775)
   0.6974149429353417900000000000f,   //  8050: sin(44.2199707)
   0.6974836493721524600000000000f,   //  8051: sin(44.2254639)
   0.6975523493978431600000000000f,   //  8052: sin(44.2309570)
   0.6976210430117824000000000000f,   //  8053: sin(44.2364502)
   0.6976897302133388000000000000f,   //  8054: sin(44.2419434)
   0.6977584110018807400000000000f,   //  8055: sin(44.2474365)
   0.6978270853767772900000000000f,   //  8056: sin(44.2529297)
   0.6978957533373970600000000000f,   //  8057: sin(44.2584229)
   0.6979644148831086700000000000f,   //  8058: sin(44.2639160)
   0.6980330700132814100000000000f,   //  8059: sin(44.2694092)
   0.6981017187272837700000000000f,   //  8060: sin(44.2749023)
   0.6981703610244850400000000000f,   //  8061: sin(44.2803955)
   0.6982389969042542800000000000f,   //  8062: sin(44.2858887)
   0.6983076263659604400000000000f,   //  8063: sin(44.2913818)
   0.6983762494089729200000000000f,   //  8064: sin(44.2968750)
   0.6984448660326605400000000000f,   //  8065: sin(44.3023682)
   0.6985134762363930400000000000f,   //  8066: sin(44.3078613)
   0.6985820800195395900000000000f,   //  8067: sin(44.3133545)
   0.6986506773814694600000000000f,   //  8068: sin(44.3188477)
   0.6987192683215524000000000000f,   //  8069: sin(44.3243408)
   0.6987878528391576700000000000f,   //  8070: sin(44.3298340)
   0.6988564309336550200000000000f,   //  8071: sin(44.3353271)
   0.6989250026044141500000000000f,   //  8072: sin(44.3408203)
   0.6989935678508044600000000000f,   //  8073: sin(44.3463135)
   0.6990621266721961400000000000f,   //  8074: sin(44.3518066)
   0.6991306790679586700000000000f,   //  8075: sin(44.3572998)
   0.6991992250374621200000000000f,   //  8076: sin(44.3627930)
   0.6992677645800762200000000000f,   //  8077: sin(44.3682861)
   0.6993362976951711400000000000f,   //  8078: sin(44.3737793)
   0.6994048243821170400000000000f,   //  8079: sin(44.3792725)
   0.6994733446402837700000000000f,   //  8080: sin(44.3847656)
   0.6995418584690417100000000000f,   //  8081: sin(44.3902588)
   0.6996103658677610400000000000f,   //  8082: sin(44.3957520)
   0.6996788668358119300000000000f,   //  8083: sin(44.4012451)
   0.6997473613725649900000000000f,   //  8084: sin(44.4067383)
   0.6998158494773903900000000000f,   //  8085: sin(44.4122314)
   0.6998843311496587600000000000f,   //  8086: sin(44.4177246)
   0.6999528063887404700000000000f,   //  8087: sin(44.4232178)
   0.7000212751940062500000000000f,   //  8088: sin(44.4287109)
   0.7000897375648268400000000000f,   //  8089: sin(44.4342041)
   0.7001581935005727300000000000f,   //  8090: sin(44.4396973)
   0.7002266430006147700000000000f,   //  8091: sin(44.4451904)
   0.7002950860643237800000000000f,   //  8092: sin(44.4506836)
   0.7003635226910706100000000000f,   //  8093: sin(44.4561768)
   0.7004319528802264200000000000f,   //  8094: sin(44.4616699)
   0.7005003766311619400000000000f,   //  8095: sin(44.4671631)
   0.7005687939432483400000000000f,   //  8096: sin(44.4726563)
   0.7006372048158567800000000000f,   //  8097: sin(44.4781494)
   0.7007056092483584500000000000f,   //  8098: sin(44.4836426)
   0.7007740072401244000000000000f,   //  8099: sin(44.4891357)
   0.7008423987905261200000000000f,   //  8100: sin(44.4946289)
   0.7009107838989350200000000000f,   //  8101: sin(44.5001221)
   0.7009791625647223700000000000f,   //  8102: sin(44.5056152)
   0.7010475347872597900000000000f,   //  8103: sin(44.5111084)
   0.7011159005659186600000000000f,   //  8104: sin(44.5166016)
   0.7011842599000706100000000000f,   //  8105: sin(44.5220947)
   0.7012526127890874600000000000f,   //  8106: sin(44.5275879)
   0.7013209592323406100000000000f,   //  8107: sin(44.5330811)
   0.7013892992292022300000000000f,   //  8108: sin(44.5385742)
   0.7014576327790438300000000000f,   //  8109: sin(44.5440674)
   0.7015259598812373400000000000f,   //  8110: sin(44.5495605)
   0.7015942805351550500000000000f,   //  8111: sin(44.5550537)
   0.7016625947401684500000000000f,   //  8112: sin(44.5605469)
   0.7017309024956500700000000000f,   //  8113: sin(44.5660400)
   0.7017992038009717200000000000f,   //  8114: sin(44.5715332)
   0.7018674986555056800000000000f,   //  8115: sin(44.5770264)
   0.7019357870586243600000000000f,   //  8116: sin(44.5825195)
   0.7020040690096998000000000000f,   //  8117: sin(44.5880127)
   0.7020723445081046300000000000f,   //  8118: sin(44.5935059)
   0.7021406135532111100000000000f,   //  8119: sin(44.5989990)
   0.7022088761443918700000000000f,   //  8120: sin(44.6044922)
   0.7022771322810191800000000000f,   //  8121: sin(44.6099854)
   0.7023453819624658800000000000f,   //  8122: sin(44.6154785)
   0.7024136251881045700000000000f,   //  8123: sin(44.6209717)
   0.7024818619573080000000000000f,   //  8124: sin(44.6264648)
   0.7025500922694488700000000000f,   //  8125: sin(44.6319580)
   0.7026183161239001300000000000f,   //  8126: sin(44.6374512)
   0.7026865335200345200000000000f,   //  8127: sin(44.6429443)
   0.7027547444572253000000000000f,   //  8128: sin(44.6484375)
   0.7028229489348452000000000000f,   //  8129: sin(44.6539307)
   0.7028911469522674000000000000f,   //  8130: sin(44.6594238)
   0.7029593385088650500000000000f,   //  8131: sin(44.6649170)
   0.7030275236040112200000000000f,   //  8132: sin(44.6704102)
   0.7030957022370794000000000000f,   //  8133: sin(44.6759033)
   0.7031638744074427700000000000f,   //  8134: sin(44.6813965)
   0.7032320401144747100000000000f,   //  8135: sin(44.6868896)
   0.7033001993575487300000000000f,   //  8136: sin(44.6923828)
   0.7033683521360381000000000000f,   //  8137: sin(44.6978760)
   0.7034364984493166600000000000f,   //  8138: sin(44.7033691)
   0.7035046382967579100000000000f,   //  8139: sin(44.7088623)
   0.7035727716777355800000000000f,   //  8140: sin(44.7143555)
   0.7036408985916231500000000000f,   //  8141: sin(44.7198486)
   0.7037090190377948100000000000f,   //  8142: sin(44.7253418)
   0.7037771330156240600000000000f,   //  8143: sin(44.7308350)
   0.7038452405244849400000000000f,   //  8144: sin(44.7363281)
   0.7039133415637515200000000000f,   //  8145: sin(44.7418213)
   0.7039814361327976200000000000f,   //  8146: sin(44.7473145)
   0.7040495242309976500000000000f,   //  8147: sin(44.7528076)
   0.7041176058577253100000000000f,   //  8148: sin(44.7583008)
   0.7041856810123552400000000000f,   //  8149: sin(44.7637939)
   0.7042537496942614700000000000f,   //  8150: sin(44.7692871)
   0.7043218119028184000000000000f,   //  8151: sin(44.7747803)
   0.7043898676374004100000000000f,   //  8152: sin(44.7802734)
   0.7044579168973819100000000000f,   //  8153: sin(44.7857666)
   0.7045259596821373800000000000f,   //  8154: sin(44.7912598)
   0.7045939959910415600000000000f,   //  8155: sin(44.7967529)
   0.7046620258234688200000000000f,   //  8156: sin(44.8022461)
   0.7047300491787941200000000000f,   //  8157: sin(44.8077393)
   0.7047980660563919500000000000f,   //  8158: sin(44.8132324)
   0.7048660764556372600000000000f,   //  8159: sin(44.8187256)
   0.7049340803759048800000000000f,   //  8160: sin(44.8242188)
   0.7050020778165697600000000000f,   //  8161: sin(44.8297119)
   0.7050700687770068400000000000f,   //  8162: sin(44.8352051)
   0.7051380532565910700000000000f,   //  8163: sin(44.8406982)
   0.7052060312546978300000000000f,   //  8164: sin(44.8461914)
   0.7052740027707019600000000000f,   //  8165: sin(44.8516846)
   0.7053419678039788400000000000f,   //  8166: sin(44.8571777)
   0.7054099263539038700000000000f,   //  8167: sin(44.8626709)
   0.7054778784198521000000000000f,   //  8168: sin(44.8681641)
   0.7055458240011992500000000000f,   //  8169: sin(44.8736572)
   0.7056137630973204900000000000f,   //  8170: sin(44.8791504)
   0.7056816957075914300000000000f,   //  8171: sin(44.8846436)
   0.7057496218313877900000000000f,   //  8172: sin(44.8901367)
   0.7058175414680850600000000000f,   //  8173: sin(44.8956299)
   0.7058854546170589800000000000f,   //  8174: sin(44.9011230)
   0.7059533612776852700000000000f,   //  8175: sin(44.9066162)
   0.7060212614493397400000000000f,   //  8176: sin(44.9121094)
   0.7060891551313983600000000000f,   //  8177: sin(44.9176025)
   0.7061570423232370600000000000f,   //  8178: sin(44.9230957)
   0.7062249230242317900000000000f,   //  8179: sin(44.9285889)
   0.7062927972337584800000000000f,   //  8180: sin(44.9340820)
   0.7063606649511934300000000000f,   //  8181: sin(44.9395752)
   0.7064285261759127900000000000f,   //  8182: sin(44.9450684)
   0.7064963809072927200000000000f,   //  8183: sin(44.9505615)
   0.7065642291447095100000000000f,   //  8184: sin(44.9560547)
   0.7066320708875395400000000000f,   //  8185: sin(44.9615479)
   0.7066999061351594300000000000f,   //  8186: sin(44.9670410)
   0.7067677348869452200000000000f,   //  8187: sin(44.9725342)
   0.7068355571422737500000000000f,   //  8188: sin(44.9780273)
   0.7069033729005216300000000000f,   //  8189: sin(44.9835205)
   0.7069711821610653600000000000f,   //  8190: sin(44.9890137)
   0.7070389849232817700000000000f,   //  8191: sin(44.9945068)
   0.7071067811865474600000000000f,   //  8192: sin(45.0000000)
   0.7071745709502395000000000000f,   //  8193: sin(45.0054932)
   0.7072423542137346000000000000f,   //  8194: sin(45.0109863)
   0.7073101309764098200000000000f,   //  8195: sin(45.0164795)
   0.7073779012376421000000000000f,   //  8196: sin(45.0219727)
   0.7074456649968085000000000000f,   //  8197: sin(45.0274658)
   0.7075134222532861700000000000f,   //  8198: sin(45.0329590)
   0.7075811730064524000000000000f,   //  8199: sin(45.0384521)
   0.7076489172556843500000000000f,   //  8200: sin(45.0439453)
   0.7077166550003593000000000000f,   //  8201: sin(45.0494385)
   0.7077843862398546200000000000f,   //  8202: sin(45.0549316)
   0.7078521109735478300000000000f,   //  8203: sin(45.0604248)
   0.7079198292008163100000000000f,   //  8204: sin(45.0659180)
   0.7079875409210375500000000000f,   //  8205: sin(45.0714111)
   0.7080552461335895000000000000f,   //  8206: sin(45.0769043)
   0.7081229448378494300000000000f,   //  8207: sin(45.0823975)
   0.7081906370331952900000000000f,   //  8208: sin(45.0878906)
   0.7082583227190048000000000000f,   //  8209: sin(45.0933838)
   0.7083260018946557800000000000f,   //  8210: sin(45.0988770)
   0.7083936745595262900000000000f,   //  8211: sin(45.1043701)
   0.7084613407129940500000000000f,   //  8212: sin(45.1098633)
   0.7085290003544373300000000000f,   //  8213: sin(45.1153564)
   0.7085966534832340800000000000f,   //  8214: sin(45.1208496)
   0.7086643000987623600000000000f,   //  8215: sin(45.1263428)
   0.7087319402004006500000000000f,   //  8216: sin(45.1318359)
   0.7087995737875270000000000000f,   //  8217: sin(45.1373291)
   0.7088672008595198200000000000f,   //  8218: sin(45.1428223)
   0.7089348214157573700000000000f,   //  8219: sin(45.1483154)
   0.7090024354556182500000000000f,   //  8220: sin(45.1538086)
   0.7090700429784809700000000000f,   //  8221: sin(45.1593018)
   0.7091376439837239200000000000f,   //  8222: sin(45.1647949)
   0.7092052384707260300000000000f,   //  8223: sin(45.1702881)
   0.7092728264388655800000000000f,   //  8224: sin(45.1757813)
   0.7093404078875217300000000000f,   //  8225: sin(45.1812744)
   0.7094079828160729800000000000f,   //  8226: sin(45.1867676)
   0.7094755512238982700000000000f,   //  8227: sin(45.1922607)
   0.7095431131103767700000000000f,   //  8228: sin(45.1977539)
   0.7096106684748870700000000000f,   //  8229: sin(45.2032471)
   0.7096782173168084700000000000f,   //  8230: sin(45.2087402)
   0.7097457596355200000000000000f,   //  8231: sin(45.2142334)
   0.7098132954304008400000000000f,   //  8232: sin(45.2197266)
   0.7098808247008302500000000000f,   //  8233: sin(45.2252197)
   0.7099483474461874000000000000f,   //  8234: sin(45.2307129)
   0.7100158636658517900000000000f,   //  8235: sin(45.2362061)
   0.7100833733592026900000000000f,   //  8236: sin(45.2416992)
   0.7101508765256195900000000000f,   //  8237: sin(45.2471924)
   0.7102183731644822200000000000f,   //  8238: sin(45.2526855)
   0.7102858632751698500000000000f,   //  8239: sin(45.2581787)
   0.7103533468570623100000000000f,   //  8240: sin(45.2636719)
   0.7104208239095393100000000000f,   //  8241: sin(45.2691650)
   0.7104882944319804700000000000f,   //  8242: sin(45.2746582)
   0.7105557584237658400000000000f,   //  8243: sin(45.2801514)
   0.7106232158842750200000000000f,   //  8244: sin(45.2856445)
   0.7106906668128882800000000000f,   //  8245: sin(45.2911377)
   0.7107581112089853500000000000f,   //  8246: sin(45.2966309)
   0.7108255490719465100000000000f,   //  8247: sin(45.3021240)
   0.7108929804011516800000000000f,   //  8248: sin(45.3076172)
   0.7109604051959811400000000000f,   //  8249: sin(45.3131104)
   0.7110278234558152800000000000f,   //  8250: sin(45.3186035)
   0.7110952351800341500000000000f,   //  8251: sin(45.3240967)
   0.7111626403680183500000000000f,   //  8252: sin(45.3295898)
   0.7112300390191480500000000000f,   //  8253: sin(45.3350830)
   0.7112974311328039700000000000f,   //  8254: sin(45.3405762)
   0.7113648167083666000000000000f,   //  8255: sin(45.3460693)
   0.7114321957452164300000000000f,   //  8256: sin(45.3515625)
   0.7114995682427343000000000000f,   //  8257: sin(45.3570557)
   0.7115669342003007000000000000f,   //  8258: sin(45.3625488)
   0.7116342936172966900000000000f,   //  8259: sin(45.3680420)
   0.7117016464931029700000000000f,   //  8260: sin(45.3735352)
   0.7117689928271003800000000000f,   //  8261: sin(45.3790283)
   0.7118363326186700800000000000f,   //  8262: sin(45.3845215)
   0.7119036658671928900000000000f,   //  8263: sin(45.3900146)
   0.7119709925720499900000000000f,   //  8264: sin(45.3955078)
   0.7120383127326226400000000000f,   //  8265: sin(45.4010010)
   0.7121056263482918900000000000f,   //  8266: sin(45.4064941)
   0.7121729334184391200000000000f,   //  8267: sin(45.4119873)
   0.7122402339424455100000000000f,   //  8268: sin(45.4174805)
   0.7123075279196926500000000000f,   //  8269: sin(45.4229736)
   0.7123748153495617100000000000f,   //  8270: sin(45.4284668)
   0.7124420962314344000000000000f,   //  8271: sin(45.4339600)
   0.7125093705646923200000000000f,   //  8272: sin(45.4394531)
   0.7125766383487169800000000000f,   //  8273: sin(45.4449463)
   0.7126438995828902100000000000f,   //  8274: sin(45.4504395)
   0.7127111542665934800000000000f,   //  8275: sin(45.4559326)
   0.7127784023992088700000000000f,   //  8276: sin(45.4614258)
   0.7128456439801182900000000000f,   //  8277: sin(45.4669189)
   0.7129128790087033700000000000f,   //  8278: sin(45.4724121)
   0.7129801074843463700000000000f,   //  8279: sin(45.4779053)
   0.7130473294064292300000000000f,   //  8280: sin(45.4833984)
   0.7131145447743341100000000000f,   //  8281: sin(45.4888916)
   0.7131817535874430700000000000f,   //  8282: sin(45.4943848)
   0.7132489558451384800000000000f,   //  8283: sin(45.4998779)
   0.7133161515468026100000000000f,   //  8284: sin(45.5053711)
   0.7133833406918176400000000000f,   //  8285: sin(45.5108643)
   0.7134505232795661500000000000f,   //  8286: sin(45.5163574)
   0.7135176993094306500000000000f,   //  8287: sin(45.5218506)
   0.7135848687807935200000000000f,   //  8288: sin(45.5273438)
   0.7136520316930375900000000000f,   //  8289: sin(45.5328369)
   0.7137191880455451300000000000f,   //  8290: sin(45.5383301)
   0.7137863378376992900000000000f,   //  8291: sin(45.5438232)
   0.7138534810688824700000000000f,   //  8292: sin(45.5493164)
   0.7139206177384775900000000000f,   //  8293: sin(45.5548096)
   0.7139877478458678300000000000f,   //  8294: sin(45.5603027)
   0.7140548713904357700000000000f,   //  8295: sin(45.5657959)
   0.7141219883715647100000000000f,   //  8296: sin(45.5712891)
   0.7141890987886375700000000000f,   //  8297: sin(45.5767822)
   0.7142562026410374000000000000f,   //  8298: sin(45.5822754)
   0.7143232999281476900000000000f,   //  8299: sin(45.5877686)
   0.7143903906493513900000000000f,   //  8300: sin(45.5932617)
   0.7144574748040319900000000000f,   //  8301: sin(45.5987549)
   0.7145245523915728600000000000f,   //  8302: sin(45.6042480)
   0.7145916234113572900000000000f,   //  8303: sin(45.6097412)
   0.7146586878627689800000000000f,   //  8304: sin(45.6152344)
   0.7147257457451914300000000000f,   //  8305: sin(45.6207275)
   0.7147927970580081300000000000f,   //  8306: sin(45.6262207)
   0.7148598418006029100000000000f,   //  8307: sin(45.6317139)
   0.7149268799723593700000000000f,   //  8308: sin(45.6372070)
   0.7149939115726615700000000000f,   //  8309: sin(45.6427002)
   0.7150609366008929800000000000f,   //  8310: sin(45.6481934)
   0.7151279550564378900000000000f,   //  8311: sin(45.6536865)
   0.7151949669386800100000000000f,   //  8312: sin(45.6591797)
   0.7152619722470036100000000000f,   //  8313: sin(45.6646729)
   0.7153289709807926200000000000f,   //  8314: sin(45.6701660)
   0.7153959631394312100000000000f,   //  8315: sin(45.6756592)
   0.7154629487223036500000000000f,   //  8316: sin(45.6811523)
   0.7155299277287943100000000000f,   //  8317: sin(45.6866455)
   0.7155969001582873600000000000f,   //  8318: sin(45.6921387)
   0.7156638660101672900000000000f,   //  8319: sin(45.6976318)
   0.7157308252838185900000000000f,   //  8320: sin(45.7031250)
   0.7157977779786258700000000000f,   //  8321: sin(45.7086182)
   0.7158647240939733900000000000f,   //  8322: sin(45.7141113)
   0.7159316636292462100000000000f,   //  8323: sin(45.7196045)
   0.7159985965838286900000000000f,   //  8324: sin(45.7250977)
   0.7160655229571057900000000000f,   //  8325: sin(45.7305908)
   0.7161324427484623300000000000f,   //  8326: sin(45.7360840)
   0.7161993559572830100000000000f,   //  8327: sin(45.7415771)
   0.7162662625829531200000000000f,   //  8328: sin(45.7470703)
   0.7163331626248573600000000000f,   //  8329: sin(45.7525635)
   0.7164000560823808900000000000f,   //  8330: sin(45.7580566)
   0.7164669429549089800000000000f,   //  8331: sin(45.7635498)
   0.7165338232418265700000000000f,   //  8332: sin(45.7690430)
   0.7166006969425191600000000000f,   //  8333: sin(45.7745361)
   0.7166675640563718900000000000f,   //  8334: sin(45.7800293)
   0.7167344245827702600000000000f,   //  8335: sin(45.7855225)
   0.7168012785210995400000000000f,   //  8336: sin(45.7910156)
   0.7168681258707452200000000000f,   //  8337: sin(45.7965088)
   0.7169349666310931300000000000f,   //  8338: sin(45.8020020)
   0.7170018008015286400000000000f,   //  8339: sin(45.8074951)
   0.7170686283814374800000000000f,   //  8340: sin(45.8129883)
   0.7171354493702053500000000000f,   //  8341: sin(45.8184814)
   0.7172022637672180700000000000f,   //  8342: sin(45.8239746)
   0.7172690715718615900000000000f,   //  8343: sin(45.8294678)
   0.7173358727835217300000000000f,   //  8344: sin(45.8349609)
   0.7174026674015844300000000000f,   //  8345: sin(45.8404541)
   0.7174694554254358300000000000f,   //  8346: sin(45.8459473)
   0.7175362368544620000000000000f,   //  8347: sin(45.8514404)
   0.7176030116880490800000000000f,   //  8348: sin(45.8569336)
   0.7176697799255832300000000000f,   //  8349: sin(45.8624268)
   0.7177365415664508400000000000f,   //  8350: sin(45.8679199)
   0.7178032966100381700000000000f,   //  8351: sin(45.8734131)
   0.7178700450557317100000000000f,   //  8352: sin(45.8789063)
   0.7179367869029178500000000000f,   //  8353: sin(45.8843994)
   0.7180035221509830600000000000f,   //  8354: sin(45.8898926)
   0.7180702507993141900000000000f,   //  8355: sin(45.8953857)
   0.7181369728472974900000000000f,   //  8356: sin(45.9008789)
   0.7182036882943200200000000000f,   //  8357: sin(45.9063721)
   0.7182703971397682600000000000f,   //  8358: sin(45.9118652)
   0.7183370993830291400000000000f,   //  8359: sin(45.9173584)
   0.7184037950234897200000000000f,   //  8360: sin(45.9228516)
   0.7184704840605367100000000000f,   //  8361: sin(45.9283447)
   0.7185371664935573700000000000f,   //  8362: sin(45.9338379)
   0.7186038423219384100000000000f,   //  8363: sin(45.9393311)
   0.7186705115450672300000000000f,   //  8364: sin(45.9448242)
   0.7187371741623309600000000000f,   //  8365: sin(45.9503174)
   0.7188038301731168900000000000f,   //  8366: sin(45.9558105)
   0.7188704795768122700000000000f,   //  8367: sin(45.9613037)
   0.7189371223728043800000000000f,   //  8368: sin(45.9667969)
   0.7190037585604808200000000000f,   //  8369: sin(45.9722900)
   0.7190703881392291900000000000f,   //  8370: sin(45.9777832)
   0.7191370111084366400000000000f,   //  8371: sin(45.9832764)
   0.7192036274674912200000000000f,   //  8372: sin(45.9887695)
   0.7192702372157803200000000000f,   //  8373: sin(45.9942627)
   0.7193368403526917400000000000f,   //  8374: sin(45.9997559)
   0.7194034368776134300000000000f,   //  8375: sin(46.0052490)
   0.7194700267899329900000000000f,   //  8376: sin(46.0107422)
   0.7195366100890385800000000000f,   //  8377: sin(46.0162354)
   0.7196031867743180000000000000f,   //  8378: sin(46.0217285)
   0.7196697568451595500000000000f,   //  8379: sin(46.0272217)
   0.7197363203009510300000000000f,   //  8380: sin(46.0327148)
   0.7198028771410806000000000000f,   //  8381: sin(46.0382080)
   0.7198694273649368600000000000f,   //  8382: sin(46.0437012)
   0.7199359709719076500000000000f,   //  8383: sin(46.0491943)
   0.7200025079613816500000000000f,   //  8384: sin(46.0546875)
   0.7200690383327470500000000000f,   //  8385: sin(46.0601807)
   0.7201355620853923100000000000f,   //  8386: sin(46.0656738)
   0.7202020792187062700000000000f,   //  8387: sin(46.0711670)
   0.7202685897320770800000000000f,   //  8388: sin(46.0766602)
   0.7203350936248937900000000000f,   //  8389: sin(46.0821533)
   0.7204015908965447600000000000f,   //  8390: sin(46.0876465)
   0.7204680815464189500000000000f,   //  8391: sin(46.0931396)
   0.7205345655739052700000000000f,   //  8392: sin(46.0986328)
   0.7206010429783923400000000000f,   //  8393: sin(46.1041260)
   0.7206675137592694100000000000f,   //  8394: sin(46.1096191)
   0.7207339779159253100000000000f,   //  8395: sin(46.1151123)
   0.7208004354477491900000000000f,   //  8396: sin(46.1206055)
   0.7208668863541302100000000000f,   //  8397: sin(46.1260986)
   0.7209333306344575300000000000f,   //  8398: sin(46.1315918)
   0.7209997682881204000000000000f,   //  8399: sin(46.1370850)
   0.7210661993145081100000000000f,   //  8400: sin(46.1425781)
   0.7211326237130101200000000000f,   //  8401: sin(46.1480713)
   0.7211990414830157200000000000f,   //  8402: sin(46.1535645)
   0.7212654526239145000000000000f,   //  8403: sin(46.1590576)
   0.7213318571350961800000000000f,   //  8404: sin(46.1645508)
   0.7213982550159502300000000000f,   //  8405: sin(46.1700439)
   0.7214646462658663700000000000f,   //  8406: sin(46.1755371)
   0.7215310308842342000000000000f,   //  8407: sin(46.1810303)
   0.7215974088704436600000000000f,   //  8408: sin(46.1865234)
   0.7216637802238847800000000000f,   //  8409: sin(46.1920166)
   0.7217301449439471600000000000f,   //  8410: sin(46.1975098)
   0.7217965030300210700000000000f,   //  8411: sin(46.2030029)
   0.7218628544814963400000000000f,   //  8412: sin(46.2084961)
   0.7219291992977632200000000000f,   //  8413: sin(46.2139893)
   0.7219955374782118800000000000f,   //  8414: sin(46.2194824)
   0.7220618690222324600000000000f,   //  8415: sin(46.2249756)
   0.7221281939292153500000000000f,   //  8416: sin(46.2304688)
   0.7221945121985508000000000000f,   //  8417: sin(46.2359619)
   0.7222608238296293100000000000f,   //  8418: sin(46.2414551)
   0.7223271288218414700000000000f,   //  8419: sin(46.2469482)
   0.7223934271745775500000000000f,   //  8420: sin(46.2524414)
   0.7224597188872283700000000000f,   //  8421: sin(46.2579346)
   0.7225260039591844300000000000f,   //  8422: sin(46.2634277)
   0.7225922823898366400000000000f,   //  8423: sin(46.2689209)
   0.7226585541785756100000000000f,   //  8424: sin(46.2744141)
   0.7227248193247922700000000000f,   //  8425: sin(46.2799072)
   0.7227910778278775500000000000f,   //  8426: sin(46.2854004)
   0.7228573296872222700000000000f,   //  8427: sin(46.2908936)
   0.7229235749022177000000000000f,   //  8428: sin(46.2963867)
   0.7229898134722546600000000000f,   //  8429: sin(46.3018799)
   0.7230560453967244100000000000f,   //  8430: sin(46.3073730)
   0.7231222706750183300000000000f,   //  8431: sin(46.3128662)
   0.7231884893065273500000000000f,   //  8432: sin(46.3183594)
   0.7232547012906431800000000000f,   //  8433: sin(46.3238525)
   0.7233209066267568500000000000f,   //  8434: sin(46.3293457)
   0.7233871053142600900000000000f,   //  8435: sin(46.3348389)
   0.7234532973525443800000000000f,   //  8436: sin(46.3403320)
   0.7235194827410010900000000000f,   //  8437: sin(46.3458252)
   0.7235856614790220400000000000f,   //  8438: sin(46.3513184)
   0.7236518335659989400000000000f,   //  8439: sin(46.3568115)
   0.7237179990013233900000000000f,   //  8440: sin(46.3623047)
   0.7237841577843874300000000000f,   //  8441: sin(46.3677979)
   0.7238503099145828800000000000f,   //  8442: sin(46.3732910)
   0.7239164553913015600000000000f,   //  8443: sin(46.3787842)
   0.7239825942139355200000000000f,   //  8444: sin(46.3842773)
   0.7240487263818768900000000000f,   //  8445: sin(46.3897705)
   0.7241148518945178500000000000f,   //  8446: sin(46.3952637)
   0.7241809707512503200000000000f,   //  8447: sin(46.4007568)
   0.7242470829514668900000000000f,   //  8448: sin(46.4062500)
   0.7243131884945596100000000000f,   //  8449: sin(46.4117432)
   0.7243792873799210800000000000f,   //  8450: sin(46.4172363)
   0.7244453796069435500000000000f,   //  8451: sin(46.4227295)
   0.7245114651750195200000000000f,   //  8452: sin(46.4282227)
   0.7245775440835416900000000000f,   //  8453: sin(46.4337158)
   0.7246436163319025500000000000f,   //  8454: sin(46.4392090)
   0.7247096819194949200000000000f,   //  8455: sin(46.4447021)
   0.7247757408457112800000000000f,   //  8456: sin(46.4501953)
   0.7248417931099445700000000000f,   //  8457: sin(46.4556885)
   0.7249078387115878200000000000f,   //  8458: sin(46.4611816)
   0.7249738776500336300000000000f,   //  8459: sin(46.4666748)
   0.7250399099246753700000000000f,   //  8460: sin(46.4721680)
   0.7251059355349056500000000000f,   //  8461: sin(46.4776611)
   0.7251719544801178400000000000f,   //  8462: sin(46.4831543)
   0.7252379667597052000000000000f,   //  8463: sin(46.4886475)
   0.7253039723730606600000000000f,   //  8464: sin(46.4941406)
   0.7253699713195778100000000000f,   //  8465: sin(46.4996338)
   0.7254359635986498100000000000f,   //  8466: sin(46.5051270)
   0.7255019492096701500000000000f,   //  8467: sin(46.5106201)
   0.7255679281520323000000000000f,   //  8468: sin(46.5161133)
   0.7256339004251296500000000000f,   //  8469: sin(46.5216064)
   0.7256998660283561200000000000f,   //  8470: sin(46.5270996)
   0.7257658249611049800000000000f,   //  8471: sin(46.5325928)
   0.7258317772227703700000000000f,   //  8472: sin(46.5380859)
   0.7258977228127456700000000000f,   //  8473: sin(46.5435791)
   0.7259636617304249300000000000f,   //  8474: sin(46.5490723)
   0.7260295939752020600000000000f,   //  8475: sin(46.5545654)
   0.7260955195464708900000000000f,   //  8476: sin(46.5600586)
   0.7261614384436256800000000000f,   //  8477: sin(46.5655518)
   0.7262273506660602600000000000f,   //  8478: sin(46.5710449)
   0.7262932562131689800000000000f,   //  8479: sin(46.5765381)
   0.7263591550843460100000000000f,   //  8480: sin(46.5820313)
   0.7264250472789854900000000000f,   //  8481: sin(46.5875244)
   0.7264909327964819100000000000f,   //  8482: sin(46.5930176)
   0.7265568116362295400000000000f,   //  8483: sin(46.5985107)
   0.7266226837976228500000000000f,   //  8484: sin(46.6040039)
   0.7266885492800565500000000000f,   //  8485: sin(46.6094971)
   0.7267544080829249100000000000f,   //  8486: sin(46.6149902)
   0.7268202602056228500000000000f,   //  8487: sin(46.6204834)
   0.7268861056475449700000000000f,   //  8488: sin(46.6259766)
   0.7269519444080859700000000000f,   //  8489: sin(46.6314697)
   0.7270177764866406800000000000f,   //  8490: sin(46.6369629)
   0.7270836018826040100000000000f,   //  8491: sin(46.6424561)
   0.7271494205953710200000000000f,   //  8492: sin(46.6479492)
   0.7272152326243365200000000000f,   //  8493: sin(46.6534424)
   0.7272810379688957600000000000f,   //  8494: sin(46.6589355)
   0.7273468366284437900000000000f,   //  8495: sin(46.6644287)
   0.7274126286023757700000000000f,   //  8496: sin(46.6699219)
   0.7274784138900870500000000000f,   //  8497: sin(46.6754150)
   0.7275441924909728000000000000f,   //  8498: sin(46.6809082)
   0.7276099644044284900000000000f,   //  8499: sin(46.6864014)
   0.7276757296298496100000000000f,   //  8500: sin(46.6918945)
   0.7277414881666315300000000000f,   //  8501: sin(46.6973877)
   0.7278072400141699600000000000f,   //  8502: sin(46.7028809)
   0.7278729851718603900000000000f,   //  8503: sin(46.7083740)
   0.7279387236390986200000000000f,   //  8504: sin(46.7138672)
   0.7280044554152802500000000000f,   //  8505: sin(46.7193604)
   0.7280701804998012100000000000f,   //  8506: sin(46.7248535)
   0.7281358988920573200000000000f,   //  8507: sin(46.7303467)
   0.7282016105914445000000000000f,   //  8508: sin(46.7358398)
   0.7282673155973589100000000000f,   //  8509: sin(46.7413330)
   0.7283330139091963600000000000f,   //  8510: sin(46.7468262)
   0.7283987055263531100000000000f,   //  8511: sin(46.7523193)
   0.7284643904482252000000000000f,   //  8512: sin(46.7578125)
   0.7285300686742090000000000000f,   //  8513: sin(46.7633057)
   0.7285957402037007700000000000f,   //  8514: sin(46.7687988)
   0.7286614050360968900000000000f,   //  8515: sin(46.7742920)
   0.7287270631707937200000000000f,   //  8516: sin(46.7797852)
   0.7287927146071878600000000000f,   //  8517: sin(46.7852783)
   0.7288583593446756900000000000f,   //  8518: sin(46.7907715)
   0.7289239973826540100000000000f,   //  8519: sin(46.7962646)
   0.7289896287205193100000000000f,   //  8520: sin(46.8017578)
   0.7290552533576685200000000000f,   //  8521: sin(46.8072510)
   0.7291208712934982300000000000f,   //  8522: sin(46.8127441)
   0.7291864825274053700000000000f,   //  8523: sin(46.8182373)
   0.7292520870587869700000000000f,   //  8524: sin(46.8237305)
   0.7293176848870397400000000000f,   //  8525: sin(46.8292236)
   0.7293832760115610500000000000f,   //  8526: sin(46.8347168)
   0.7294488604317476100000000000f,   //  8527: sin(46.8402100)
   0.7295144381469969000000000000f,   //  8528: sin(46.8457031)
   0.7295800091567061800000000000f,   //  8529: sin(46.8511963)
   0.7296455734602724800000000000f,   //  8530: sin(46.8566895)
   0.7297111310570932900000000000f,   //  8531: sin(46.8621826)
   0.7297766819465659700000000000f,   //  8532: sin(46.8676758)
   0.7298422261280881300000000000f,   //  8533: sin(46.8731689)
   0.7299077636010571400000000000f,   //  8534: sin(46.8786621)
   0.7299732943648705700000000000f,   //  8535: sin(46.8841553)
   0.7300388184189261500000000000f,   //  8536: sin(46.8896484)
   0.7301043357626216800000000000f,   //  8537: sin(46.8951416)
   0.7301698463953548700000000000f,   //  8538: sin(46.9006348)
   0.7302353503165234200000000000f,   //  8539: sin(46.9061279)
   0.7303008475255253800000000000f,   //  8540: sin(46.9116211)
   0.7303663380217587700000000000f,   //  8541: sin(46.9171143)
   0.7304318218046215200000000000f,   //  8542: sin(46.9226074)
   0.7304972988735117800000000000f,   //  8543: sin(46.9281006)
   0.7305627692278275900000000000f,   //  8544: sin(46.9335938)
   0.7306282328669671000000000000f,   //  8545: sin(46.9390869)
   0.7306936897903288900000000000f,   //  8546: sin(46.9445801)
   0.7307591399973110100000000000f,   //  8547: sin(46.9500732)
   0.7308245834873120500000000000f,   //  8548: sin(46.9555664)
   0.7308900202597302700000000000f,   //  8549: sin(46.9610596)
   0.7309554503139643600000000000f,   //  8550: sin(46.9665527)
   0.7310208736494128200000000000f,   //  8551: sin(46.9720459)
   0.7310862902654742300000000000f,   //  8552: sin(46.9775391)
   0.7311517001615475100000000000f,   //  8553: sin(46.9830322)
   0.7312171033370311600000000000f,   //  8554: sin(46.9885254)
   0.7312824997913243100000000000f,   //  8555: sin(46.9940186)
   0.7313478895238254600000000000f,   //  8556: sin(46.9995117)
   0.7314132725339338400000000000f,   //  8557: sin(47.0050049)
   0.7314786488210485200000000000f,   //  8558: sin(47.0104980)
   0.7315440183845682800000000000f,   //  8559: sin(47.0159912)
   0.7316093812238925200000000000f,   //  8560: sin(47.0214844)
   0.7316747373384203700000000000f,   //  8561: sin(47.0269775)
   0.7317400867275509800000000000f,   //  8562: sin(47.0324707)
   0.7318054293906838300000000000f,   //  8563: sin(47.0379639)
   0.7318707653272182900000000000f,   //  8564: sin(47.0434570)
   0.7319360945365537300000000000f,   //  8565: sin(47.0489502)
   0.7320014170180895200000000000f,   //  8566: sin(47.0544434)
   0.7320667327712255800000000000f,   //  8567: sin(47.0599365)
   0.7321320417953612900000000000f,   //  8568: sin(47.0654297)
   0.7321973440898963400000000000f,   //  8569: sin(47.0709229)
   0.7322626396542306600000000000f,   //  8570: sin(47.0764160)
   0.7323279284877639600000000000f,   //  8571: sin(47.0819092)
   0.7323932105898960400000000000f,   //  8572: sin(47.0874023)
   0.7324584859600269400000000000f,   //  8573: sin(47.0928955)
   0.7325237545975565900000000000f,   //  8574: sin(47.0983887)
   0.7325890165018852400000000000f,   //  8575: sin(47.1038818)
   0.7326542716724128200000000000f,   //  8576: sin(47.1093750)
   0.7327195201085395800000000000f,   //  8577: sin(47.1148682)
   0.7327847618096657900000000000f,   //  8578: sin(47.1203613)
   0.7328499967751916900000000000f,   //  8579: sin(47.1258545)
   0.7329152250045177800000000000f,   //  8580: sin(47.1313477)
   0.7329804464970443000000000000f,   //  8581: sin(47.1368408)
   0.7330456612521719700000000000f,   //  8582: sin(47.1423340)
   0.7331108692693012500000000000f,   //  8583: sin(47.1478271)
   0.7331760705478327400000000000f,   //  8584: sin(47.1533203)
   0.7332412650871671400000000000f,   //  8585: sin(47.1588135)
   0.7333064528867052600000000000f,   //  8586: sin(47.1643066)
   0.7333716339458478100000000000f,   //  8587: sin(47.1697998)
   0.7334368082639957100000000000f,   //  8588: sin(47.1752930)
   0.7335019758405498800000000000f,   //  8589: sin(47.1807861)
   0.7335671366749113600000000000f,   //  8590: sin(47.1862793)
   0.7336322907664810700000000000f,   //  8591: sin(47.1917725)
   0.7336974381146602600000000000f,   //  8592: sin(47.1972656)
   0.7337625787188500900000000000f,   //  8593: sin(47.2027588)
   0.7338277125784517000000000000f,   //  8594: sin(47.2082520)
   0.7338928396928665600000000000f,   //  8595: sin(47.2137451)
   0.7339579600614959400000000000f,   //  8596: sin(47.2192383)
   0.7340230736837413100000000000f,   //  8597: sin(47.2247314)
   0.7340881805590040400000000000f,   //  8598: sin(47.2302246)
   0.7341532806866858400000000000f,   //  8599: sin(47.2357178)
   0.7342183740661881700000000000f,   //  8600: sin(47.2412109)
   0.7342834606969128600000000000f,   //  8601: sin(47.2467041)
   0.7343485405782616000000000000f,   //  8602: sin(47.2521973)
   0.7344136137096360900000000000f,   //  8603: sin(47.2576904)
   0.7344786800904383700000000000f,   //  8604: sin(47.2631836)
   0.7345437397200701400000000000f,   //  8605: sin(47.2686768)
   0.7346087925979335500000000000f,   //  8606: sin(47.2741699)
   0.7346738387234306200000000000f,   //  8607: sin(47.2796631)
   0.7347388780959633900000000000f,   //  8608: sin(47.2851563)
   0.7348039107149342300000000000f,   //  8609: sin(47.2906494)
   0.7348689365797450600000000000f,   //  8610: sin(47.2961426)
   0.7349339556897984700000000000f,   //  8611: sin(47.3016357)
   0.7349989680444966000000000000f,   //  8612: sin(47.3071289)
   0.7350639736432420500000000000f,   //  8613: sin(47.3126221)
   0.7351289724854371800000000000f,   //  8614: sin(47.3181152)
   0.7351939645704845800000000000f,   //  8615: sin(47.3236084)
   0.7352589498977867300000000000f,   //  8616: sin(47.3291016)
   0.7353239284667466600000000000f,   //  8617: sin(47.3345947)
   0.7353889002767666200000000000f,   //  8618: sin(47.3400879)
   0.7354538653272498800000000000f,   //  8619: sin(47.3455811)
   0.7355188236175989000000000000f,   //  8620: sin(47.3510742)
   0.7355837751472167300000000000f,   //  8621: sin(47.3565674)
   0.7356487199155064000000000000f,   //  8622: sin(47.3620605)
   0.7357136579218709300000000000f,   //  8623: sin(47.3675537)
   0.7357785891657134800000000000f,   //  8624: sin(47.3730469)
   0.7358435136464370800000000000f,   //  8625: sin(47.3785400)
   0.7359084313634451900000000000f,   //  8626: sin(47.3840332)
   0.7359733423161407600000000000f,   //  8627: sin(47.3895264)
   0.7360382465039273500000000000f,   //  8628: sin(47.3950195)
   0.7361031439262084600000000000f,   //  8629: sin(47.4005127)
   0.7361680345823873300000000000f,   //  8630: sin(47.4060059)
   0.7362329184718677800000000000f,   //  8631: sin(47.4114990)
   0.7362977955940530600000000000f,   //  8632: sin(47.4169922)
   0.7363626659483470900000000000f,   //  8633: sin(47.4224854)
   0.7364275295341536900000000000f,   //  8634: sin(47.4279785)
   0.7364923863508763300000000000f,   //  8635: sin(47.4334717)
   0.7365572363979191500000000000f,   //  8636: sin(47.4389648)
   0.7366220796746858500000000000f,   //  8637: sin(47.4444580)
   0.7366869161805804600000000000f,   //  8638: sin(47.4499512)
   0.7367517459150071400000000000f,   //  8639: sin(47.4554443)
   0.7368165688773697900000000000f,   //  8640: sin(47.4609375)
   0.7368813850670727900000000000f,   //  8641: sin(47.4664307)
   0.7369461944835201700000000000f,   //  8642: sin(47.4719238)
   0.7370109971261164000000000000f,   //  8643: sin(47.4774170)
   0.7370757929942656200000000000f,   //  8644: sin(47.4829102)
   0.7371405820873724300000000000f,   //  8645: sin(47.4884033)
   0.7372053644048411900000000000f,   //  8646: sin(47.4938965)
   0.7372701399460763700000000000f,   //  8647: sin(47.4993896)
   0.7373349087104827900000000000f,   //  8648: sin(47.5048828)
   0.7373996706974649300000000000f,   //  8649: sin(47.5103760)
   0.7374644259064275800000000000f,   //  8650: sin(47.5158691)
   0.7375291743367754500000000000f,   //  8651: sin(47.5213623)
   0.7375939159879134600000000000f,   //  8652: sin(47.5268555)
   0.7376586508592466500000000000f,   //  8653: sin(47.5323486)
   0.7377233789501795900000000000f,   //  8654: sin(47.5378418)
   0.7377881002601176500000000000f,   //  8655: sin(47.5433350)
   0.7378528147884659800000000000f,   //  8656: sin(47.5488281)
   0.7379175225346295000000000000f,   //  8657: sin(47.5543213)
   0.7379822234980135700000000000f,   //  8658: sin(47.5598145)
   0.7380469176780233300000000000f,   //  8659: sin(47.5653076)
   0.7381116050740642600000000000f,   //  8660: sin(47.5708008)
   0.7381762856855418300000000000f,   //  8661: sin(47.5762939)
   0.7382409595118613100000000000f,   //  8662: sin(47.5817871)
   0.7383056265524283700000000000f,   //  8663: sin(47.5872803)
   0.7383702868066485100000000000f,   //  8664: sin(47.5927734)
   0.7384349402739276400000000000f,   //  8665: sin(47.5982666)
   0.7384995869536711300000000000f,   //  8666: sin(47.6037598)
   0.7385642268452848900000000000f,   //  8667: sin(47.6092529)
   0.7386288599481748400000000000f,   //  8668: sin(47.6147461)
   0.7386934862617468000000000000f,   //  8669: sin(47.6202393)
   0.7387581057854069000000000000f,   //  8670: sin(47.6257324)
   0.7388227185185609600000000000f,   //  8671: sin(47.6312256)
   0.7388873244606151100000000000f,   //  8672: sin(47.6367188)
   0.7389519236109756100000000000f,   //  8673: sin(47.6422119)
   0.7390165159690486000000000000f,   //  8674: sin(47.6477051)
   0.7390811015342404500000000000f,   //  8675: sin(47.6531982)
   0.7391456803059574000000000000f,   //  8676: sin(47.6586914)
   0.7392102522836059300000000000f,   //  8677: sin(47.6641846)
   0.7392748174665925200000000000f,   //  8678: sin(47.6696777)
   0.7393393758543235200000000000f,   //  8679: sin(47.6751709)
   0.7394039274462057600000000000f,   //  8680: sin(47.6806641)
   0.7394684722416456900000000000f,   //  8681: sin(47.6861572)
   0.7395330102400502500000000000f,   //  8682: sin(47.6916504)
   0.7395975414408260100000000000f,   //  8683: sin(47.6971436)
   0.7396620658433799000000000000f,   //  8684: sin(47.7026367)
   0.7397265834471189500000000000f,   //  8685: sin(47.7081299)
   0.7397910942514499500000000000f,   //  8686: sin(47.7136230)
   0.7398555982557799600000000000f,   //  8687: sin(47.7191162)
   0.7399200954595160900000000000f,   //  8688: sin(47.7246094)
   0.7399845858620655000000000000f,   //  8689: sin(47.7301025)
   0.7400490694628355500000000000f,   //  8690: sin(47.7355957)
   0.7401135462612332700000000000f,   //  8691: sin(47.7410889)
   0.7401780162566662400000000000f,   //  8692: sin(47.7465820)
   0.7402424794485416000000000000f,   //  8693: sin(47.7520752)
   0.7403069358362669400000000000f,   //  8694: sin(47.7575684)
   0.7403713854192499600000000000f,   //  8695: sin(47.7630615)
   0.7404358281968980200000000000f,   //  8696: sin(47.7685547)
   0.7405002641686189200000000000f,   //  8697: sin(47.7740479)
   0.7405646933338202500000000000f,   //  8698: sin(47.7795410)
   0.7406291156919098100000000000f,   //  8699: sin(47.7850342)
   0.7406935312422956400000000000f,   //  8700: sin(47.7905273)
   0.7407579399843854400000000000f,   //  8701: sin(47.7960205)
   0.7408223419175873300000000000f,   //  8702: sin(47.8015137)
   0.7408867370413091400000000000f,   //  8703: sin(47.8070068)
   0.7409511253549591100000000000f,   //  8704: sin(47.8125000)
   0.7410155068579453700000000000f,   //  8705: sin(47.8179932)
   0.7410798815496760800000000000f,   //  8706: sin(47.8234863)
   0.7411442494295595900000000000f,   //  8707: sin(47.8289795)
   0.7412086104970042600000000000f,   //  8708: sin(47.8344727)
   0.7412729647514184600000000000f,   //  8709: sin(47.8399658)
   0.7413373121922106600000000000f,   //  8710: sin(47.8454590)
   0.7414016528187893400000000000f,   //  8711: sin(47.8509521)
   0.7414659866305632900000000000f,   //  8712: sin(47.8564453)
   0.7415303136269408800000000000f,   //  8713: sin(47.8619385)
   0.7415946338073311500000000000f,   //  8714: sin(47.8674316)
   0.7416589471711425600000000000f,   //  8715: sin(47.8729248)
   0.7417232537177841400000000000f,   //  8716: sin(47.8784180)
   0.7417875534466648000000000000f,   //  8717: sin(47.8839111)
   0.7418518463571934800000000000f,   //  8718: sin(47.8894043)
   0.7419161324487791900000000000f,   //  8719: sin(47.8948975)
   0.7419804117208309600000000000f,   //  8720: sin(47.9003906)
   0.7420446841727581500000000000f,   //  8721: sin(47.9058838)
   0.7421089498039698000000000000f,   //  8722: sin(47.9113770)
   0.7421732086138752600000000000f,   //  8723: sin(47.9168701)
   0.7422374606018840000000000000f,   //  8724: sin(47.9223633)
   0.7423017057674051700000000000f,   //  8725: sin(47.9278564)
   0.7423659441098484600000000000f,   //  8726: sin(47.9333496)
   0.7424301756286232300000000000f,   //  8727: sin(47.9388428)
   0.7424944003231391800000000000f,   //  8728: sin(47.9443359)
   0.7425586181928061100000000000f,   //  8729: sin(47.9498291)
   0.7426228292370333800000000000f,   //  8730: sin(47.9553223)
   0.7426870334552311300000000000f,   //  8731: sin(47.9608154)
   0.7427512308468090500000000000f,   //  8732: sin(47.9663086)
   0.7428154214111769600000000000f,   //  8733: sin(47.9718018)
   0.7428796051477450900000000000f,   //  8734: sin(47.9772949)
   0.7429437820559232600000000000f,   //  8735: sin(47.9827881)
   0.7430079521351217200000000000f,   //  8736: sin(47.9882813)
   0.7430721153847504900000000000f,   //  8737: sin(47.9937744)
   0.7431362718042198200000000000f,   //  8738: sin(47.9992676)
   0.7432004213929400700000000000f,   //  8739: sin(48.0047607)
   0.7432645641503214900000000000f,   //  8740: sin(48.0102539)
   0.7433287000757746700000000000f,   //  8741: sin(48.0157471)
   0.7433928291687099700000000000f,   //  8742: sin(48.0212402)
   0.7434569514285378500000000000f,   //  8743: sin(48.0267334)
   0.7435210668546691200000000000f,   //  8744: sin(48.0322266)
   0.7435851754465141500000000000f,   //  8745: sin(48.0377197)
   0.7436492772034840600000000000f,   //  8746: sin(48.0432129)
   0.7437133721249892200000000000f,   //  8747: sin(48.0487061)
   0.7437774602104407800000000000f,   //  8748: sin(48.0541992)
   0.7438415414592495200000000000f,   //  8749: sin(48.0596924)
   0.7439056158708264900000000000f,   //  8750: sin(48.0651855)
   0.7439696834445827000000000000f,   //  8751: sin(48.0706787)
   0.7440337441799291800000000000f,   //  8752: sin(48.0761719)
   0.7440977980762772900000000000f,   //  8753: sin(48.0816650)
   0.7441618451330380700000000000f,   //  8754: sin(48.0871582)
   0.7442258853496228600000000000f,   //  8755: sin(48.0926514)
   0.7442899187254431400000000000f,   //  8756: sin(48.0981445)
   0.7443539452599101700000000000f,   //  8757: sin(48.1036377)
   0.7444179649524356200000000000f,   //  8758: sin(48.1091309)
   0.7444819778024307500000000000f,   //  8759: sin(48.1146240)
   0.7445459838093072500000000000f,   //  8760: sin(48.1201172)
   0.7446099829724770500000000000f,   //  8761: sin(48.1256104)
   0.7446739752913516000000000000f,   //  8762: sin(48.1311035)
   0.7447379607653429300000000000f,   //  8763: sin(48.1365967)
   0.7448019393938626300000000000f,   //  8764: sin(48.1420898)
   0.7448659111763227300000000000f,   //  8765: sin(48.1475830)
   0.7449298761121353500000000000f,   //  8766: sin(48.1530762)
   0.7449938342007123000000000000f,   //  8767: sin(48.1585693)
   0.7450577854414659500000000000f,   //  8768: sin(48.1640625)
   0.7451217298338083100000000000f,   //  8769: sin(48.1695557)
   0.7451856673771516400000000000f,   //  8770: sin(48.1750488)
   0.7452495980709081800000000000f,   //  8771: sin(48.1805420)
   0.7453135219144904100000000000f,   //  8772: sin(48.1860352)
   0.7453774389073107900000000000f,   //  8773: sin(48.1915283)
   0.7454413490487816800000000000f,   //  8774: sin(48.1970215)
   0.7455052523383156600000000000f,   //  8775: sin(48.2025146)
   0.7455691487753254300000000000f,   //  8776: sin(48.2080078)
   0.7456330383592234500000000000f,   //  8777: sin(48.2135010)
   0.7456969210894227600000000000f,   //  8778: sin(48.2189941)
   0.7457607969653359300000000000f,   //  8779: sin(48.2244873)
   0.7458246659863759800000000000f,   //  8780: sin(48.2299805)
   0.7458885281519557200000000000f,   //  8781: sin(48.2354736)
   0.7459523834614881800000000000f,   //  8782: sin(48.2409668)
   0.7460162319143866000000000000f,   //  8783: sin(48.2464600)
   0.7460800735100637800000000000f,   //  8784: sin(48.2519531)
   0.7461439082479330900000000000f,   //  8785: sin(48.2574463)
   0.7462077361274076500000000000f,   //  8786: sin(48.2629395)
   0.7462715571479009400000000000f,   //  8787: sin(48.2684326)
   0.7463353713088263200000000000f,   //  8788: sin(48.2739258)
   0.7463991786095970400000000000f,   //  8789: sin(48.2794189)
   0.7464629790496267700000000000f,   //  8790: sin(48.2849121)
   0.7465267726283288900000000000f,   //  8791: sin(48.2904053)
   0.7465905593451173100000000000f,   //  8792: sin(48.2958984)
   0.7466543391994053800000000000f,   //  8793: sin(48.3013916)
   0.7467181121906070200000000000f,   //  8794: sin(48.3068848)
   0.7467818783181361400000000000f,   //  8795: sin(48.3123779)
   0.7468456375814065400000000000f,   //  8796: sin(48.3178711)
   0.7469093899798320300000000000f,   //  8797: sin(48.3233643)
   0.7469731355128267400000000000f,   //  8798: sin(48.3288574)
   0.7470368741798046900000000000f,   //  8799: sin(48.3343506)
   0.7471006059801801300000000000f,   //  8800: sin(48.3398438)
   0.7471643309133670900000000000f,   //  8801: sin(48.3453369)
   0.7472280489787799200000000000f,   //  8802: sin(48.3508301)
   0.7472917601758327600000000000f,   //  8803: sin(48.3563232)
   0.7473554645039401900000000000f,   //  8804: sin(48.3618164)
   0.7474191619625166800000000000f,   //  8805: sin(48.3673096)
   0.7474828525509765700000000000f,   //  8806: sin(48.3728027)
   0.7475465362687345700000000000f,   //  8807: sin(48.3782959)
   0.7476102131152051500000000000f,   //  8808: sin(48.3837891)
   0.7476738830898030900000000000f,   //  8809: sin(48.3892822)
   0.7477375461919433300000000000f,   //  8810: sin(48.3947754)
   0.7478012024210404200000000000f,   //  8811: sin(48.4002686)
   0.7478648517765094100000000000f,   //  8812: sin(48.4057617)
   0.7479284942577650900000000000f,   //  8813: sin(48.4112549)
   0.7479921298642227000000000000f,   //  8814: sin(48.4167480)
   0.7480557585952971600000000000f,   //  8815: sin(48.4222412)
   0.7481193804504034900000000000f,   //  8816: sin(48.4277344)
   0.7481829954289572800000000000f,   //  8817: sin(48.4332275)
   0.7482466035303734200000000000f,   //  8818: sin(48.4387207)
   0.7483102047540674000000000000f,   //  8819: sin(48.4442139)
   0.7483737990994545600000000000f,   //  8820: sin(48.4497070)
   0.7484373865659503800000000000f,   //  8821: sin(48.4552002)
   0.7485009671529704300000000000f,   //  8822: sin(48.4606934)
   0.7485645408599300700000000000f,   //  8823: sin(48.4661865)
   0.7486281076862453300000000000f,   //  8824: sin(48.4716797)
   0.7486916676313315500000000000f,   //  8825: sin(48.4771729)
   0.7487552206946047600000000000f,   //  8826: sin(48.4826660)
   0.7488187668754806600000000000f,   //  8827: sin(48.4881592)
   0.7488823061733750300000000000f,   //  8828: sin(48.4936523)
   0.7489458385877041400000000000f,   //  8829: sin(48.4991455)
   0.7490093641178837700000000000f,   //  8830: sin(48.5046387)
   0.7490728827633300600000000000f,   //  8831: sin(48.5101318)
   0.7491363945234592600000000000f,   //  8832: sin(48.5156250)
   0.7491998993976875000000000000f,   //  8833: sin(48.5211182)
   0.7492633973854310200000000000f,   //  8834: sin(48.5266113)
   0.7493268884861061800000000000f,   //  8835: sin(48.5321045)
   0.7493903726991295600000000000f,   //  8836: sin(48.5375977)
   0.7494538500239172900000000000f,   //  8837: sin(48.5430908)
   0.7495173204598861700000000000f,   //  8838: sin(48.5485840)
   0.7495807840064526700000000000f,   //  8839: sin(48.5540771)
   0.7496442406630334800000000000f,   //  8840: sin(48.5595703)
   0.7497076904290453900000000000f,   //  8841: sin(48.5650635)
   0.7497711333039049900000000000f,   //  8842: sin(48.5705566)
   0.7498345692870293000000000000f,   //  8843: sin(48.5760498)
   0.7498979983778352200000000000f,   //  8844: sin(48.5815430)
   0.7499614205757396700000000000f,   //  8845: sin(48.5870361)
   0.7500248358801597800000000000f,   //  8846: sin(48.5925293)
   0.7500882442905124600000000000f,   //  8847: sin(48.5980225)
   0.7501516458062149600000000000f,   //  8848: sin(48.6035156)
   0.7502150404266846300000000000f,   //  8849: sin(48.6090088)
   0.7502784281513386100000000000f,   //  8850: sin(48.6145020)
   0.7503418089795944600000000000f,   //  8851: sin(48.6199951)
   0.7504051829108692200000000000f,   //  8852: sin(48.6254883)
   0.7504685499445806800000000000f,   //  8853: sin(48.6309814)
   0.7505319100801464100000000000f,   //  8854: sin(48.6364746)
   0.7505952633169837900000000000f,   //  8855: sin(48.6419678)
   0.7506586096545105900000000000f,   //  8856: sin(48.6474609)
   0.7507219490921446200000000000f,   //  8857: sin(48.6529541)
   0.7507852816293035800000000000f,   //  8858: sin(48.6584473)
   0.7508486072654053700000000000f,   //  8859: sin(48.6639404)
   0.7509119259998678900000000000f,   //  8860: sin(48.6694336)
   0.7509752378321092900000000000f,   //  8861: sin(48.6749268)
   0.7510385427615472500000000000f,   //  8862: sin(48.6804199)
   0.7511018407876003400000000000f,   //  8863: sin(48.6859131)
   0.7511651319096863700000000000f,   //  8864: sin(48.6914063)
   0.7512284161272238000000000000f,   //  8865: sin(48.6968994)
   0.7512916934396308700000000000f,   //  8866: sin(48.7023926)
   0.7513549638463258300000000000f,   //  8867: sin(48.7078857)
   0.7514182273467273600000000000f,   //  8868: sin(48.7133789)
   0.7514814839402537100000000000f,   //  8869: sin(48.7188721)
   0.7515447336263235700000000000f,   //  8870: sin(48.7243652)
   0.7516079764043556200000000000f,   //  8871: sin(48.7298584)
   0.7516712122737684300000000000f,   //  8872: sin(48.7353516)
   0.7517344412339808100000000000f,   //  8873: sin(48.7408447)
   0.7517976632844114400000000000f,   //  8874: sin(48.7463379)
   0.7518608784244793500000000000f,   //  8875: sin(48.7518311)
   0.7519240866536035500000000000f,   //  8876: sin(48.7573242)
   0.7519872879712027300000000000f,   //  8877: sin(48.7628174)
   0.7520504823766963600000000000f,   //  8878: sin(48.7683105)
   0.7521136698695032300000000000f,   //  8879: sin(48.7738037)
   0.7521768504490427000000000000f,   //  8880: sin(48.7792969)
   0.7522400241147340100000000000f,   //  8881: sin(48.7847900)
   0.7523031908659964000000000000f,   //  8882: sin(48.7902832)
   0.7523663507022494400000000000f,   //  8883: sin(48.7957764)
   0.7524295036229123900000000000f,   //  8884: sin(48.8012695)
   0.7524926496274048100000000000f,   //  8885: sin(48.8067627)
   0.7525557887151463900000000000f,   //  8886: sin(48.8122559)
   0.7526189208855566000000000000f,   //  8887: sin(48.8177490)
   0.7526820461380552300000000000f,   //  8888: sin(48.8232422)
   0.7527451644720620800000000000f,   //  8889: sin(48.8287354)
   0.7528082758869969500000000000f,   //  8890: sin(48.8342285)
   0.7528713803822796300000000000f,   //  8891: sin(48.8397217)
   0.7529344779573301500000000000f,   //  8892: sin(48.8452148)
   0.7529975686115686400000000000f,   //  8893: sin(48.8507080)
   0.7530606523444151000000000000f,   //  8894: sin(48.8562012)
   0.7531237291552895800000000000f,   //  8895: sin(48.8616943)
   0.7531867990436124100000000000f,   //  8896: sin(48.8671875)
   0.7532498620088038400000000000f,   //  8897: sin(48.8726807)
   0.7533129180502843300000000000f,   //  8898: sin(48.8781738)
   0.7533759671674740100000000000f,   //  8899: sin(48.8836670)
   0.7534390093597935800000000000f,   //  8900: sin(48.8891602)
   0.7535020446266633700000000000f,   //  8901: sin(48.8946533)
   0.7535650729675041900000000000f,   //  8902: sin(48.9001465)
   0.7536280943817366100000000000f,   //  8903: sin(48.9056396)
   0.7536911088687812100000000000f,   //  8904: sin(48.9111328)
   0.7537541164280590100000000000f,   //  8905: sin(48.9166260)
   0.7538171170589906800000000000f,   //  8906: sin(48.9221191)
   0.7538801107609972600000000000f,   //  8907: sin(48.9276123)
   0.7539430975334996400000000000f,   //  8908: sin(48.9331055)
   0.7540060773759188500000000000f,   //  8909: sin(48.9385986)
   0.7540690502876761200000000000f,   //  8910: sin(48.9440918)
   0.7541320162681923700000000000f,   //  8911: sin(48.9495850)
   0.7541949753168891700000000000f,   //  8912: sin(48.9550781)
   0.7542579274331874300000000000f,   //  8913: sin(48.9605713)
   0.7543208726165088200000000000f,   //  8914: sin(48.9660645)
   0.7543838108662747100000000000f,   //  8915: sin(48.9715576)
   0.7544467421819063300000000000f,   //  8916: sin(48.9770508)
   0.7545096665628255900000000000f,   //  8917: sin(48.9825439)
   0.7545725840084538400000000000f,   //  8918: sin(48.9880371)
   0.7546354945182128800000000000f,   //  8919: sin(48.9935303)
   0.7546983980915243900000000000f,   //  8920: sin(48.9990234)
   0.7547612947278102800000000000f,   //  8921: sin(49.0045166)
   0.7548241844264922400000000000f,   //  8922: sin(49.0100098)
   0.7548870671869923900000000000f,   //  8923: sin(49.0155029)
   0.7549499430087326400000000000f,   //  8924: sin(49.0209961)
   0.7550128118911348900000000000f,   //  8925: sin(49.0264893)
   0.7550756738336215100000000000f,   //  8926: sin(49.0319824)
   0.7551385288356147200000000000f,   //  8927: sin(49.0374756)
   0.7552013768965365500000000000f,   //  8928: sin(49.0429688)
   0.7552642180158093400000000000f,   //  8929: sin(49.0484619)
   0.7553270521928555600000000000f,   //  8930: sin(49.0539551)
   0.7553898794270976800000000000f,   //  8931: sin(49.0594482)
   0.7554526997179581400000000000f,   //  8932: sin(49.0649414)
   0.7555155130648595300000000000f,   //  8933: sin(49.0704346)
   0.7555783194672245400000000000f,   //  8934: sin(49.0759277)
   0.7556411189244757200000000000f,   //  8935: sin(49.0814209)
   0.7557039114360358800000000000f,   //  8936: sin(49.0869141)
   0.7557666970013279300000000000f,   //  8937: sin(49.0924072)
   0.7558294756197747600000000000f,   //  8938: sin(49.0979004)
   0.7558922472907991800000000000f,   //  8939: sin(49.1033936)
   0.7559550120138243100000000000f,   //  8940: sin(49.1088867)
   0.7560177697882732900000000000f,   //  8941: sin(49.1143799)
   0.7560805206135691200000000000f,   //  8942: sin(49.1198730)
   0.7561432644891350500000000000f,   //  8943: sin(49.1253662)
   0.7562060014143945400000000000f,   //  8944: sin(49.1308594)
   0.7562687313887706000000000000f,   //  8945: sin(49.1363525)
   0.7563314544116869200000000000f,   //  8946: sin(49.1418457)
   0.7563941704825667400000000000f,   //  8947: sin(49.1473389)
   0.7564568796008336300000000000f,   //  8948: sin(49.1528320)
   0.7565195817659113900000000000f,   //  8949: sin(49.1583252)
   0.7565822769772234700000000000f,   //  8950: sin(49.1638184)
   0.7566449652341936700000000000f,   //  8951: sin(49.1693115)
   0.7567076465362456700000000000f,   //  8952: sin(49.1748047)
   0.7567703208828033800000000000f,   //  8953: sin(49.1802979)
   0.7568329882732908200000000000f,   //  8954: sin(49.1857910)
   0.7568956487071317700000000000f,   //  8955: sin(49.1912842)
   0.7569583021837504900000000000f,   //  8956: sin(49.1967773)
   0.7570209487025708600000000000f,   //  8957: sin(49.2022705)
   0.7570835882630171400000000000f,   //  8958: sin(49.2077637)
   0.7571462208645136600000000000f,   //  8959: sin(49.2132568)
   0.7572088465064844600000000000f,   //  8960: sin(49.2187500)
   0.7572714651883542000000000000f,   //  8961: sin(49.2242432)
   0.7573340769095471300000000000f,   //  8962: sin(49.2297363)
   0.7573966816694877000000000000f,   //  8963: sin(49.2352295)
   0.7574592794676007200000000000f,   //  8964: sin(49.2407227)
   0.7575218703033104200000000000f,   //  8965: sin(49.2462158)
   0.7575844541760418100000000000f,   //  8966: sin(49.2517090)
   0.7576470310852193600000000000f,   //  8967: sin(49.2572021)
   0.7577096010302680800000000000f,   //  8968: sin(49.2626953)
   0.7577721640106127600000000000f,   //  8969: sin(49.2681885)
   0.7578347200256783100000000000f,   //  8970: sin(49.2736816)
   0.7578972690748898600000000000f,   //  8971: sin(49.2791748)
   0.7579598111576723000000000000f,   //  8972: sin(49.2846680)
   0.7580223462734508900000000000f,   //  8973: sin(49.2901611)
   0.7580848744216506200000000000f,   //  8974: sin(49.2956543)
   0.7581473956016969700000000000f,   //  8975: sin(49.3011475)
   0.7582099098130152800000000000f,   //  8976: sin(49.3066406)
   0.7582724170550306800000000000f,   //  8977: sin(49.3121338)
   0.7583349173271689600000000000f,   //  8978: sin(49.3176270)
   0.7583974106288552400000000000f,   //  8979: sin(49.3231201)
   0.7584598969595153200000000000f,   //  8980: sin(49.3286133)
   0.7585223763185748900000000000f,   //  8981: sin(49.3341064)
   0.7585848487054595000000000000f,   //  8982: sin(49.3395996)
   0.7586473141195951800000000000f,   //  8983: sin(49.3450928)
   0.7587097725604073900000000000f,   //  8984: sin(49.3505859)
   0.7587722240273221400000000000f,   //  8985: sin(49.3560791)
   0.7588346685197656600000000000f,   //  8986: sin(49.3615723)
   0.7588971060371636500000000000f,   //  8987: sin(49.3670654)
   0.7589595365789424400000000000f,   //  8988: sin(49.3725586)
   0.7590219601445279400000000000f,   //  8989: sin(49.3780518)
   0.7590843767333465000000000000f,   //  8990: sin(49.3835449)
   0.7591467863448244600000000000f,   //  8991: sin(49.3890381)
   0.7592091889783879600000000000f,   //  8992: sin(49.3945313)
   0.7592715846334636700000000000f,   //  8993: sin(49.4000244)
   0.7593339733094779400000000000f,   //  8994: sin(49.4055176)
   0.7593963550058572300000000000f,   //  8995: sin(49.4110107)
   0.7594587297220282100000000000f,   //  8996: sin(49.4165039)
   0.7595210974574175800000000000f,   //  8997: sin(49.4219971)
   0.7595834582114520100000000000f,   //  8998: sin(49.4274902)
   0.7596458119835582900000000000f,   //  8999: sin(49.4329834)
   0.7597081587731634400000000000f,   //  9000: sin(49.4384766)
   0.7597704985796941400000000000f,   //  9001: sin(49.4439697)
   0.7598328314025774000000000000f,   //  9002: sin(49.4494629)
   0.7598951572412404600000000000f,   //  9003: sin(49.4549561)
   0.7599574760951103300000000000f,   //  9004: sin(49.4604492)
   0.7600197879636142500000000000f,   //  9005: sin(49.4659424)
   0.7600820928461792200000000000f,   //  9006: sin(49.4714355)
   0.7601443907422328300000000000f,   //  9007: sin(49.4769287)
   0.7602066816512024200000000000f,   //  9008: sin(49.4824219)
   0.7602689655725152200000000000f,   //  9009: sin(49.4879150)
   0.7603312425055990300000000000f,   //  9010: sin(49.4934082)
   0.7603935124498810700000000000f,   //  9011: sin(49.4989014)
   0.7604557754047892600000000000f,   //  9012: sin(49.5043945)
   0.7605180313697510500000000000f,   //  9013: sin(49.5098877)
   0.7605802803441943400000000000f,   //  9014: sin(49.5153809)
   0.7606425223275470300000000000f,   //  9015: sin(49.5208740)
   0.7607047573192369200000000000f,   //  9016: sin(49.5263672)
   0.7607669853186919100000000000f,   //  9017: sin(49.5318604)
   0.7608292063253400100000000000f,   //  9018: sin(49.5373535)
   0.7608914203386093500000000000f,   //  9019: sin(49.5428467)
   0.7609536273579280400000000000f,   //  9020: sin(49.5483398)
   0.7610158273827243300000000000f,   //  9021: sin(49.5538330)
   0.7610780204124265600000000000f,   //  9022: sin(49.5593262)
   0.7611402064464628500000000000f,   //  9023: sin(49.5648193)
   0.7612023854842617800000000000f,   //  9024: sin(49.5703125)
   0.7612645575252517900000000000f,   //  9025: sin(49.5758057)
   0.7613267225688612500000000000f,   //  9026: sin(49.5812988)
   0.7613888806145190400000000000f,   //  9027: sin(49.5867920)
   0.7614510316616535100000000000f,   //  9028: sin(49.5922852)
   0.7615131757096935700000000000f,   //  9029: sin(49.5977783)
   0.7615753127580680000000000000f,   //  9030: sin(49.6032715)
   0.7616374428062056000000000000f,   //  9031: sin(49.6087646)
   0.7616995658535352700000000000f,   //  9032: sin(49.6142578)
   0.7617616818994860100000000000f,   //  9033: sin(49.6197510)
   0.7618237909434868400000000000f,   //  9034: sin(49.6252441)
   0.7618858929849668900000000000f,   //  9035: sin(49.6307373)
   0.7619479880233553900000000000f,   //  9036: sin(49.6362305)
   0.7620100760580815800000000000f,   //  9037: sin(49.6417236)
   0.7620721570885745600000000000f,   //  9038: sin(49.6472168)
   0.7621342311142639300000000000f,   //  9039: sin(49.6527100)
   0.7621962981345789000000000000f,   //  9040: sin(49.6582031)
   0.7622583581489491600000000000f,   //  9041: sin(49.6636963)
   0.7623204111568041600000000000f,   //  9042: sin(49.6691895)
   0.7623824571575735800000000000f,   //  9043: sin(49.6746826)
   0.7624444961506871000000000000f,   //  9044: sin(49.6801758)
   0.7625065281355744000000000000f,   //  9045: sin(49.6856689)
   0.7625685531116653800000000000f,   //  9046: sin(49.6911621)
   0.7626305710783899400000000000f,   //  9047: sin(49.6966553)
   0.7626925820351778700000000000f,   //  9048: sin(49.7021484)
   0.7627545859814594000000000000f,   //  9049: sin(49.7076416)
   0.7628165829166643200000000000f,   //  9050: sin(49.7131348)
   0.7628785728402230900000000000f,   //  9051: sin(49.7186279)
   0.7629405557515657200000000000f,   //  9052: sin(49.7241211)
   0.7630025316501224400000000000f,   //  9053: sin(49.7296143)
   0.7630645005353237100000000000f,   //  9054: sin(49.7351074)
   0.7631264624065997600000000000f,   //  9055: sin(49.7406006)
   0.7631884172633812700000000000f,   //  9056: sin(49.7460938)
   0.7632503651050985800000000000f,   //  9057: sin(49.7515869)
   0.7633123059311823800000000000f,   //  9058: sin(49.7570801)
   0.7633742397410633300000000000f,   //  9059: sin(49.7625732)
   0.7634361665341720100000000000f,   //  9060: sin(49.7680664)
   0.7634980863099394300000000000f,   //  9061: sin(49.7735596)
   0.7635599990677961500000000000f,   //  9062: sin(49.7790527)
   0.7636219048071732900000000000f,   //  9063: sin(49.7845459)
   0.7636838035275018700000000000f,   //  9064: sin(49.7900391)
   0.7637456952282126700000000000f,   //  9065: sin(49.7955322)
   0.7638075799087371600000000000f,   //  9066: sin(49.8010254)
   0.7638694575685061100000000000f,   //  9067: sin(49.8065186)
   0.7639313282069510900000000000f,   //  9068: sin(49.8120117)
   0.7639931918235032300000000000f,   //  9069: sin(49.8175049)
   0.7640550484175938600000000000f,   //  9070: sin(49.8229980)
   0.7641168979886545600000000000f,   //  9071: sin(49.8284912)
   0.7641787405361166700000000000f,   //  9072: sin(49.8339844)
   0.7642405760594118700000000000f,   //  9073: sin(49.8394775)
   0.7643024045579717200000000000f,   //  9074: sin(49.8449707)
   0.7643642260312277800000000000f,   //  9075: sin(49.8504639)
   0.7644260404786120700000000000f,   //  9076: sin(49.8559570)
   0.7644878478995561500000000000f,   //  9077: sin(49.8614502)
   0.7645496482934921500000000000f,   //  9078: sin(49.8669434)
   0.7646114416598517300000000000f,   //  9079: sin(49.8724365)
   0.7646732279980671400000000000f,   //  9080: sin(49.8779297)
   0.7647350073075703800000000000f,   //  9081: sin(49.8834229)
   0.7647967795877934600000000000f,   //  9082: sin(49.8889160)
   0.7648585448381687300000000000f,   //  9083: sin(49.8944092)
   0.7649203030581284100000000000f,   //  9084: sin(49.8999023)
   0.7649820542471048600000000000f,   //  9085: sin(49.9053955)
   0.7650437984045304100000000000f,   //  9086: sin(49.9108887)
   0.7651055355298376200000000000f,   //  9087: sin(49.9163818)
   0.7651672656224589600000000000f,   //  9088: sin(49.9218750)
   0.7652289886818269800000000000f,   //  9089: sin(49.9273682)
   0.7652907047073742600000000000f,   //  9090: sin(49.9328613)
   0.7653524136985338000000000000f,   //  9091: sin(49.9383545)
   0.7654141156547381600000000000f,   //  9092: sin(49.9438477)
   0.7654758105754203600000000000f,   //  9093: sin(49.9493408)
   0.7655374984600130700000000000f,   //  9094: sin(49.9548340)
   0.7655991793079494100000000000f,   //  9095: sin(49.9603271)
   0.7656608531186623900000000000f,   //  9096: sin(49.9658203)
   0.7657225198915852400000000000f,   //  9097: sin(49.9713135)
   0.7657841796261509700000000000f,   //  9098: sin(49.9768066)
   0.7658458323217928200000000000f,   //  9099: sin(49.9822998)
   0.7659074779779442300000000000f,   //  9100: sin(49.9877930)
   0.7659691165940384300000000000f,   //  9101: sin(49.9932861)
   0.7660307481695090000000000000f,   //  9102: sin(49.9987793)
   0.7660923727037892700000000000f,   //  9103: sin(50.0042725)
   0.7661539901963128100000000000f,   //  9104: sin(50.0097656)
   0.7662156006465135100000000000f,   //  9105: sin(50.0152588)
   0.7662772040538247100000000000f,   //  9106: sin(50.0207520)
   0.7663388004176802100000000000f,   //  9107: sin(50.0262451)
   0.7664003897375141200000000000f,   //  9108: sin(50.0317383)
   0.7664619720127601200000000000f,   //  9109: sin(50.0372314)
   0.7665235472428521000000000000f,   //  9110: sin(50.0427246)
   0.7665851154272241800000000000f,   //  9111: sin(50.0482178)
   0.7666466765653103800000000000f,   //  9112: sin(50.0537109)
   0.7667082306565449200000000000f,   //  9113: sin(50.0592041)
   0.7667697777003619200000000000f,   //  9114: sin(50.0646973)
   0.7668313176961957200000000000f,   //  9115: sin(50.0701904)
   0.7668928506434806700000000000f,   //  9116: sin(50.0756836)
   0.7669543765416510000000000000f,   //  9117: sin(50.0811768)
   0.7670158953901414800000000000f,   //  9118: sin(50.0866699)
   0.7670774071883863500000000000f,   //  9119: sin(50.0921631)
   0.7671389119358204000000000000f,   //  9120: sin(50.0976563)
   0.7672004096318780800000000000f,   //  9121: sin(50.1031494)
   0.7672619002759943900000000000f,   //  9122: sin(50.1086426)
   0.7673233838676040100000000000f,   //  9123: sin(50.1141357)
   0.7673848604061416200000000000f,   //  9124: sin(50.1196289)
   0.7674463298910424400000000000f,   //  9125: sin(50.1251221)
   0.7675077923217412700000000000f,   //  9126: sin(50.1306152)
   0.7675692476976732100000000000f,   //  9127: sin(50.1361084)
   0.7676306960182732700000000000f,   //  9128: sin(50.1416016)
   0.7676921372829768100000000000f,   //  9129: sin(50.1470947)
   0.7677535714912190300000000000f,   //  9130: sin(50.1525879)
   0.7678149986424350800000000000f,   //  9131: sin(50.1580811)
   0.7678764187360606100000000000f,   //  9132: sin(50.1635742)
   0.7679378317715307400000000000f,   //  9133: sin(50.1690674)
   0.7679992377482812700000000000f,   //  9134: sin(50.1745605)
   0.7680606366657476400000000000f,   //  9135: sin(50.1800537)
   0.7681220285233653100000000000f,   //  9136: sin(50.1855469)
   0.7681834133205703900000000000f,   //  9137: sin(50.1910400)
   0.7682447910567982200000000000f,   //  9138: sin(50.1965332)
   0.7683061617314849200000000000f,   //  9139: sin(50.2020264)
   0.7683675253440662700000000000f,   //  9140: sin(50.2075195)
   0.7684288818939781800000000000f,   //  9141: sin(50.2130127)
   0.7684902313806567500000000000f,   //  9142: sin(50.2185059)
   0.7685515738035381100000000000f,   //  9143: sin(50.2239990)
   0.7686129091620582700000000000f,   //  9144: sin(50.2294922)
   0.7686742374556535500000000000f,   //  9145: sin(50.2349854)
   0.7687355586837603100000000000f,   //  9146: sin(50.2404785)
   0.7687968728458147700000000000f,   //  9147: sin(50.2459717)
   0.7688581799412532700000000000f,   //  9148: sin(50.2514648)
   0.7689194799695124900000000000f,   //  9149: sin(50.2569580)
   0.7689807729300288700000000000f,   //  9150: sin(50.2624512)
   0.7690420588222389700000000000f,   //  9151: sin(50.2679443)
   0.7691033376455795900000000000f,   //  9152: sin(50.2734375)
   0.7691646093994873900000000000f,   //  9153: sin(50.2789307)
   0.7692258740833992600000000000f,   //  9154: sin(50.2844238)
   0.7692871316967518900000000000f,   //  9155: sin(50.2899170)
   0.7693483822389822800000000000f,   //  9156: sin(50.2954102)
   0.7694096257095275300000000000f,   //  9157: sin(50.3009033)
   0.7694708621078245600000000000f,   //  9158: sin(50.3063965)
   0.7695320914333106900000000000f,   //  9159: sin(50.3118896)
   0.7695933136854229400000000000f,   //  9160: sin(50.3173828)
   0.7696545288635985300000000000f,   //  9161: sin(50.3228760)
   0.7697157369672750200000000000f,   //  9162: sin(50.3283691)
   0.7697769379958896400000000000f,   //  9163: sin(50.3338623)
   0.7698381319488798400000000000f,   //  9164: sin(50.3393555)
   0.7698993188256831900000000000f,   //  9165: sin(50.3448486)
   0.7699604986257372300000000000f,   //  9166: sin(50.3503418)
   0.7700216713484795400000000000f,   //  9167: sin(50.3558350)
   0.7700828369933479000000000000f,   //  9168: sin(50.3613281)
   0.7701439955597801900000000000f,   //  9169: sin(50.3668213)
   0.7702051470472141000000000000f,   //  9170: sin(50.3723145)
   0.7702662914550877400000000000f,   //  9171: sin(50.3778076)
   0.7703274287828387700000000000f,   //  9172: sin(50.3833008)
   0.7703885590299055500000000000f,   //  9173: sin(50.3887939)
   0.7704496821957259600000000000f,   //  9174: sin(50.3942871)
   0.7705107982797382300000000000f,   //  9175: sin(50.3997803)
   0.7705719072813807000000000000f,   //  9176: sin(50.4052734)
   0.7706330092000914800000000000f,   //  9177: sin(50.4107666)
   0.7706941040353091400000000000f,   //  9178: sin(50.4162598)
   0.7707551917864720000000000000f,   //  9179: sin(50.4217529)
   0.7708162724530184300000000000f,   //  9180: sin(50.4272461)
   0.7708773460343872900000000000f,   //  9181: sin(50.4327393)
   0.7709384125300169400000000000f,   //  9182: sin(50.4382324)
   0.7709994719393461500000000000f,   //  9183: sin(50.4437256)
   0.7710605242618137100000000000f,   //  9184: sin(50.4492188)
   0.7711215694968585100000000000f,   //  9185: sin(50.4547119)
   0.7711826076439192200000000000f,   //  9186: sin(50.4602051)
   0.7712436387024349500000000000f,   //  9187: sin(50.4656982)
   0.7713046626718447200000000000f,   //  9188: sin(50.4711914)
   0.7713656795515875200000000000f,   //  9189: sin(50.4766846)
   0.7714266893411025900000000000f,   //  9190: sin(50.4821777)
   0.7714876920398291400000000000f,   //  9191: sin(50.4876709)
   0.7715486876472063000000000000f,   //  9192: sin(50.4931641)
   0.7716096761626736200000000000f,   //  9193: sin(50.4986572)
   0.7716706575856703300000000000f,   //  9194: sin(50.5041504)
   0.7717316319156359800000000000f,   //  9195: sin(50.5096436)
   0.7717925991520101500000000000f,   //  9196: sin(50.5151367)
   0.7718535592942323800000000000f,   //  9197: sin(50.5206299)
   0.7719145123417423500000000000f,   //  9198: sin(50.5261230)
   0.7719754582939797300000000000f,   //  9199: sin(50.5316162)
   0.7720363971503844100000000000f,   //  9200: sin(50.5371094)
   0.7720973289103962900000000000f,   //  9201: sin(50.5426025)
   0.7721582535734552400000000000f,   //  9202: sin(50.5480957)
   0.7722191711390011800000000000f,   //  9203: sin(50.5535889)
   0.7722800816064743200000000000f,   //  9204: sin(50.5590820)
   0.7723409849753145600000000000f,   //  9205: sin(50.5645752)
   0.7724018812449623400000000000f,   //  9206: sin(50.5700684)
   0.7724627704148577800000000000f,   //  9207: sin(50.5755615)
   0.7725236524844413300000000000f,   //  9208: sin(50.5810547)
   0.7725845274531530900000000000f,   //  9209: sin(50.5865479)
   0.7726453953204338600000000000f,   //  9210: sin(50.5920410)
   0.7727062560857238500000000000f,   //  9211: sin(50.5975342)
   0.7727671097484637400000000000f,   //  9212: sin(50.6030273)
   0.7728279563080943100000000000f,   //  9213: sin(50.6085205)
   0.7728887957640562200000000000f,   //  9214: sin(50.6140137)
   0.7729496281157901500000000000f,   //  9215: sin(50.6195068)
   0.7730104533627369900000000000f,   //  9216: sin(50.6250000)
   0.7730712715043375200000000000f,   //  9217: sin(50.6304932)
   0.7731320825400330700000000000f,   //  9218: sin(50.6359863)
   0.7731928864692643200000000000f,   //  9219: sin(50.6414795)
   0.7732536832914725900000000000f,   //  9220: sin(50.6469727)
   0.7733144730060987900000000000f,   //  9221: sin(50.6524658)
   0.7733752556125844700000000000f,   //  9222: sin(50.6579590)
   0.7734360311103708500000000000f,   //  9223: sin(50.6634521)
   0.7734967994988990500000000000f,   //  9224: sin(50.6689453)
   0.7735575607776108400000000000f,   //  9225: sin(50.6744385)
   0.7736183149459474600000000000f,   //  9226: sin(50.6799316)
   0.7736790620033505700000000000f,   //  9227: sin(50.6854248)
   0.7737398019492618400000000000f,   //  9228: sin(50.6909180)
   0.7738005347831228300000000000f,   //  9229: sin(50.6964111)
   0.7738612605043755400000000000f,   //  9230: sin(50.7019043)
   0.7739219791124615200000000000f,   //  9231: sin(50.7073975)
   0.7739826906068227900000000000f,   //  9232: sin(50.7128906)
   0.7740433949869013300000000000f,   //  9233: sin(50.7183838)
   0.7741040922521389400000000000f,   //  9234: sin(50.7238770)
   0.7741647824019780600000000000f,   //  9235: sin(50.7293701)
   0.7742254654358605700000000000f,   //  9236: sin(50.7348633)
   0.7742861413532289300000000000f,   //  9237: sin(50.7403564)
   0.7743468101535250200000000000f,   //  9238: sin(50.7458496)
   0.7744074718361915200000000000f,   //  9239: sin(50.7513428)
   0.7744681264006708600000000000f,   //  9240: sin(50.7568359)
   0.7745287738464052800000000000f,   //  9241: sin(50.7623291)
   0.7745894141728375500000000000f,   //  9242: sin(50.7678223)
   0.7746500473794100100000000000f,   //  9243: sin(50.7733154)
   0.7747106734655655500000000000f,   //  9244: sin(50.7788086)
   0.7747712924307469400000000000f,   //  9245: sin(50.7843018)
   0.7748319042743968500000000000f,   //  9246: sin(50.7897949)
   0.7748925089959581800000000000f,   //  9247: sin(50.7952881)
   0.7749531065948738200000000000f,   //  9248: sin(50.8007813)
   0.7750136970705869800000000000f,   //  9249: sin(50.8062744)
   0.7750742804225404500000000000f,   //  9250: sin(50.8117676)
   0.7751348566501774500000000000f,   //  9251: sin(50.8172607)
   0.7751954257529413100000000000f,   //  9252: sin(50.8227539)
   0.7752559877302751500000000000f,   //  9253: sin(50.8282471)
   0.7753165425816224100000000000f,   //  9254: sin(50.8337402)
   0.7753770903064263200000000000f,   //  9255: sin(50.8392334)
   0.7754376309041304300000000000f,   //  9256: sin(50.8447266)
   0.7754981643741784000000000000f,   //  9257: sin(50.8502197)
   0.7755586907160135800000000000f,   //  9258: sin(50.8557129)
   0.7756192099290797300000000000f,   //  9259: sin(50.8612061)
   0.7756797220128205400000000000f,   //  9260: sin(50.8666992)
   0.7757402269666798800000000000f,   //  9261: sin(50.8721924)
   0.7758007247901015400000000000f,   //  9262: sin(50.8776855)
   0.7758612154825295100000000000f,   //  9263: sin(50.8831787)
   0.7759216990434075800000000000f,   //  9264: sin(50.8886719)
   0.7759821754721799600000000000f,   //  9265: sin(50.8941650)
   0.7760426447682907700000000000f,   //  9266: sin(50.8996582)
   0.7761031069311841200000000000f,   //  9267: sin(50.9051514)
   0.7761635619603043400000000000f,   //  9268: sin(50.9106445)
   0.7762240098550956500000000000f,   //  9269: sin(50.9161377)
   0.7762844506150024000000000000f,   //  9270: sin(50.9216309)
   0.7763448842394692400000000000f,   //  9271: sin(50.9271240)
   0.7764053107279403900000000000f,   //  9272: sin(50.9326172)
   0.7764657300798605300000000000f,   //  9273: sin(50.9381104)
   0.7765261422946744300000000000f,   //  9274: sin(50.9436035)
   0.7765865473718266400000000000f,   //  9275: sin(50.9490967)
   0.7766469453107620600000000000f,   //  9276: sin(50.9545898)
   0.7767073361109253500000000000f,   //  9277: sin(50.9600830)
   0.7767677197717615100000000000f,   //  9278: sin(50.9655762)
   0.7768280962927155400000000000f,   //  9279: sin(50.9710693)
   0.7768884656732324400000000000f,   //  9280: sin(50.9765625)
   0.7769488279127573200000000000f,   //  9281: sin(50.9820557)
   0.7770091830107352900000000000f,   //  9282: sin(50.9875488)
   0.7770695309666115800000000000f,   //  9283: sin(50.9930420)
   0.7771298717798316200000000000f,   //  9284: sin(50.9985352)
   0.7771902054498406300000000000f,   //  9285: sin(51.0040283)
   0.7772505319760840700000000000f,   //  9286: sin(51.0095215)
   0.7773108513580073700000000000f,   //  9287: sin(51.0150146)
   0.7773711635950562000000000000f,   //  9288: sin(51.0205078)
   0.7774314686866762300000000000f,   //  9289: sin(51.0260010)
   0.7774917666323129000000000000f,   //  9290: sin(51.0314941)
   0.7775520574314123100000000000f,   //  9291: sin(51.0369873)
   0.7776123410834199200000000000f,   //  9292: sin(51.0424805)
   0.7776726175877819400000000000f,   //  9293: sin(51.0479736)
   0.7777328869439440500000000000f,   //  9294: sin(51.0534668)
   0.7777931491513523400000000000f,   //  9295: sin(51.0589600)
   0.7778534042094530400000000000f,   //  9296: sin(51.0644531)
   0.7779136521176921400000000000f,   //  9297: sin(51.0699463)
   0.7779738928755159900000000000f,   //  9298: sin(51.0754395)
   0.7780341264823708000000000000f,   //  9299: sin(51.0809326)
   0.7780943529377027900000000000f,   //  9300: sin(51.0864258)
   0.7781545722409585200000000000f,   //  9301: sin(51.0919189)
   0.7782147843915844200000000000f,   //  9302: sin(51.0974121)
   0.7782749893890271700000000000f,   //  9303: sin(51.1029053)
   0.7783351872327330900000000000f,   //  9304: sin(51.1083984)
   0.7783953779221490800000000000f,   //  9305: sin(51.1138916)
   0.7784555614567219000000000000f,   //  9306: sin(51.1193848)
   0.7785157378358982200000000000f,   //  9307: sin(51.1248779)
   0.7785759070591249400000000000f,   //  9308: sin(51.1303711)
   0.7786360691258490400000000000f,   //  9309: sin(51.1358643)
   0.7786962240355175300000000000f,   //  9310: sin(51.1413574)
   0.7787563717875775100000000000f,   //  9311: sin(51.1468506)
   0.7788165123814758700000000000f,   //  9312: sin(51.1523438)
   0.7788766458166601600000000000f,   //  9313: sin(51.1578369)
   0.7789367720925775000000000000f,   //  9314: sin(51.1633301)
   0.7789968912086752100000000000f,   //  9315: sin(51.1688232)
   0.7790570031644006300000000000f,   //  9316: sin(51.1743164)
   0.7791171079592011900000000000f,   //  9317: sin(51.1798096)
   0.7791772055925246800000000000f,   //  9318: sin(51.1853027)
   0.7792372960638184200000000000f,   //  9319: sin(51.1907959)
   0.7792973793725303000000000000f,   //  9320: sin(51.1962891)
   0.7793574555181078700000000000f,   //  9321: sin(51.2017822)
   0.7794175244999989000000000000f,   //  9322: sin(51.2072754)
   0.7794775863176514100000000000f,   //  9323: sin(51.2127686)
   0.7795376409705131500000000000f,   //  9324: sin(51.2182617)
   0.7795976884580323500000000000f,   //  9325: sin(51.2237549)
   0.7796577287796567800000000000f,   //  9326: sin(51.2292480)
   0.7797177619348347700000000000f,   //  9327: sin(51.2347412)
   0.7797777879230144400000000000f,   //  9328: sin(51.2402344)
   0.7798378067436440000000000000f,   //  9329: sin(51.2457275)
   0.7798978183961718900000000000f,   //  9330: sin(51.2512207)
   0.7799578228800464500000000000f,   //  9331: sin(51.2567139)
   0.7800178201947159900000000000f,   //  9332: sin(51.2622070)
   0.7800778103396292000000000000f,   //  9333: sin(51.2677002)
   0.7801377933142345000000000000f,   //  9334: sin(51.2731934)
   0.7801977691179807800000000000f,   //  9335: sin(51.2786865)
   0.7802577377503165900000000000f,   //  9336: sin(51.2841797)
   0.7803176992106907200000000000f,   //  9337: sin(51.2896729)
   0.7803776534985520400000000000f,   //  9338: sin(51.2951660)
   0.7804376006133493200000000000f,   //  9339: sin(51.3006592)
   0.7804975405545319100000000000f,   //  9340: sin(51.3061523)
   0.7805574733215484600000000000f,   //  9341: sin(51.3116455)
   0.7806173989138482900000000000f,   //  9342: sin(51.3171387)
   0.7806773173308805300000000000f,   //  9343: sin(51.3226318)
   0.7807372285720943800000000000f,   //  9344: sin(51.3281250)
   0.7807971326369392800000000000f,   //  9345: sin(51.3336182)
   0.7808570295248644700000000000f,   //  9346: sin(51.3391113)
   0.7809169192353194700000000000f,   //  9347: sin(51.3446045)
   0.7809768017677537500000000000f,   //  9348: sin(51.3500977)
   0.7810366771216168400000000000f,   //  9349: sin(51.3555908)
   0.7810965452963584100000000000f,   //  9350: sin(51.3610840)
   0.7811564062914282400000000000f,   //  9351: sin(51.3665771)
   0.7812162601062760900000000000f,   //  9352: sin(51.3720703)
   0.7812761067403516400000000000f,   //  9353: sin(51.3775635)
   0.7813359461931048700000000000f,   //  9354: sin(51.3830566)
   0.7813957784639858900000000000f,   //  9355: sin(51.3885498)
   0.7814556035524444800000000000f,   //  9356: sin(51.3940430)
   0.7815154214579310700000000000f,   //  9357: sin(51.3995361)
   0.7815752321798955500000000000f,   //  9358: sin(51.4050293)
   0.7816350357177882500000000000f,   //  9359: sin(51.4105225)
   0.7816948320710593900000000000f,   //  9360: sin(51.4160156)
   0.7817546212391594000000000000f,   //  9361: sin(51.4215088)
   0.7818144032215388300000000000f,   //  9362: sin(51.4270020)
   0.7818741780176480200000000000f,   //  9363: sin(51.4324951)
   0.7819339456269376300000000000f,   //  9364: sin(51.4379883)
   0.7819937060488580900000000000f,   //  9365: sin(51.4434814)
   0.7820534592828603000000000000f,   //  9366: sin(51.4489746)
   0.7821132053283950100000000000f,   //  9367: sin(51.4544678)
   0.7821729441849129000000000000f,   //  9368: sin(51.4599609)
   0.7822326758518650700000000000f,   //  9369: sin(51.4654541)
   0.7822924003287024000000000000f,   //  9370: sin(51.4709473)
   0.7823521176148757700000000000f,   //  9371: sin(51.4764404)
   0.7824118277098364200000000000f,   //  9372: sin(51.4819336)
   0.7824715306130355400000000000f,   //  9373: sin(51.4874268)
   0.7825312263239242400000000000f,   //  9374: sin(51.4929199)
   0.7825909148419538700000000000f,   //  9375: sin(51.4984131)
   0.7826505961665757300000000000f,   //  9376: sin(51.5039063)
   0.7827102702972412700000000000f,   //  9377: sin(51.5093994)
   0.7827699372334020500000000000f,   //  9378: sin(51.5148926)
   0.7828295969745096000000000000f,   //  9379: sin(51.5203857)
   0.7828892495200154800000000000f,   //  9380: sin(51.5258789)
   0.7829488948693714700000000000f,   //  9381: sin(51.5313721)
   0.7830085330220291100000000000f,   //  9382: sin(51.5368652)
   0.7830681639774403900000000000f,   //  9383: sin(51.5423584)
   0.7831277877350573100000000000f,   //  9384: sin(51.5478516)
   0.7831874042943315400000000000f,   //  9385: sin(51.5533447)
   0.7832470136547153800000000000f,   //  9386: sin(51.5588379)
   0.7833066158156607500000000000f,   //  9387: sin(51.5643311)
   0.7833662107766197200000000000f,   //  9388: sin(51.5698242)
   0.7834257985370446400000000000f,   //  9389: sin(51.5753174)
   0.7834853790963878200000000000f,   //  9390: sin(51.5808105)
   0.7835449524541016100000000000f,   //  9391: sin(51.5863037)
   0.7836045186096382000000000000f,   //  9392: sin(51.5917969)
   0.7836640775624502700000000000f,   //  9393: sin(51.5972900)
   0.7837236293119904700000000000f,   //  9394: sin(51.6027832)
   0.7837831738577111200000000000f,   //  9395: sin(51.6082764)
   0.7838427111990652300000000000f,   //  9396: sin(51.6137695)
   0.7839022413355052300000000000f,   //  9397: sin(51.6192627)
   0.7839617642664840100000000000f,   //  9398: sin(51.6247559)
   0.7840212799914546600000000000f,   //  9399: sin(51.6302490)
   0.7840807885098699500000000000f,   //  9400: sin(51.6357422)
   0.7841402898211828900000000000f,   //  9401: sin(51.6412354)
   0.7841997839248465700000000000f,   //  9402: sin(51.6467285)
   0.7842592708203142100000000000f,   //  9403: sin(51.6522217)
   0.7843187505070389200000000000f,   //  9404: sin(51.6577148)
   0.7843782229844739100000000000f,   //  9405: sin(51.6632080)
   0.7844376882520727200000000000f,   //  9406: sin(51.6687012)
   0.7844971463092886800000000000f,   //  9407: sin(51.6741943)
   0.7845565971555752400000000000f,   //  9408: sin(51.6796875)
   0.7846160407903859400000000000f,   //  9409: sin(51.6851807)
   0.7846754772131743200000000000f,   //  9410: sin(51.6906738)
   0.7847349064233941600000000000f,   //  9411: sin(51.6961670)
   0.7847943284204992300000000000f,   //  9412: sin(51.7016602)
   0.7848537432039431900000000000f,   //  9413: sin(51.7071533)
   0.7849131507731800200000000000f,   //  9414: sin(51.7126465)
   0.7849725511276636200000000000f,   //  9415: sin(51.7181396)
   0.7850319442668480800000000000f,   //  9416: sin(51.7236328)
   0.7850913301901872900000000000f,   //  9417: sin(51.7291260)
   0.7851507088971355600000000000f,   //  9418: sin(51.7346191)
   0.7852100803871470100000000000f,   //  9419: sin(51.7401123)
   0.7852694446596758500000000000f,   //  9420: sin(51.7456055)
   0.7853288017141766300000000000f,   //  9421: sin(51.7510986)
   0.7853881515501035500000000000f,   //  9422: sin(51.7565918)
   0.7854474941669111800000000000f,   //  9423: sin(51.7620850)
   0.7855068295640539300000000000f,   //  9424: sin(51.7675781)
   0.7855661577409865900000000000f,   //  9425: sin(51.7730713)
   0.7856254786971637000000000000f,   //  9426: sin(51.7785645)
   0.7856847924320399200000000000f,   //  9427: sin(51.7840576)
   0.7857440989450703600000000000f,   //  9428: sin(51.7895508)
   0.7858033982357095500000000000f,   //  9429: sin(51.7950439)
   0.7858626903034126000000000000f,   //  9430: sin(51.8005371)
   0.7859219751476344000000000000f,   //  9431: sin(51.8060303)
   0.7859812527678301500000000000f,   //  9432: sin(51.8115234)
   0.7860405231634549600000000000f,   //  9433: sin(51.8170166)
   0.7860997863339638200000000000f,   //  9434: sin(51.8225098)
   0.7861590422788123900000000000f,   //  9435: sin(51.8280029)
   0.7862182909974555500000000000f,   //  9436: sin(51.8334961)
   0.7862775324893490600000000000f,   //  9437: sin(51.8389893)
   0.7863367667539482600000000000f,   //  9438: sin(51.8444824)
   0.7863959937907085700000000000f,   //  9439: sin(51.8499756)
   0.7864552135990857700000000000f,   //  9440: sin(51.8554688)
   0.7865144261785354000000000000f,   //  9441: sin(51.8609619)
   0.7865736315285132300000000000f,   //  9442: sin(51.8664551)
   0.7866328296484750300000000000f,   //  9443: sin(51.8719482)
   0.7866920205378766800000000000f,   //  9444: sin(51.8774414)
   0.7867512041961742800000000000f,   //  9445: sin(51.8829346)
   0.7868103806228234900000000000f,   //  9446: sin(51.8884277)
   0.7868695498172806300000000000f,   //  9447: sin(51.8939209)
   0.7869287117790017000000000000f,   //  9448: sin(51.8994141)
   0.7869878665074430100000000000f,   //  9449: sin(51.9049072)
   0.7870470140020607900000000000f,   //  9450: sin(51.9104004)
   0.7871061542623112300000000000f,   //  9451: sin(51.9158936)
   0.7871652872876508900000000000f,   //  9452: sin(51.9213867)
   0.7872244130775362100000000000f,   //  9453: sin(51.9268799)
   0.7872835316314236200000000000f,   //  9454: sin(51.9323730)
   0.7873426429487697700000000000f,   //  9455: sin(51.9378662)
   0.7874017470290313200000000000f,   //  9456: sin(51.9433594)
   0.7874608438716651500000000000f,   //  9457: sin(51.9488525)
   0.7875199334761278100000000000f,   //  9458: sin(51.9543457)
   0.7875790158418761700000000000f,   //  9459: sin(51.9598389)
   0.7876380909683674500000000000f,   //  9460: sin(51.9653320)
   0.7876971588550583100000000000f,   //  9461: sin(51.9708252)
   0.7877562195014059500000000000f,   //  9462: sin(51.9763184)
   0.7878152729068674800000000000f,   //  9463: sin(51.9818115)
   0.7878743190709001100000000000f,   //  9464: sin(51.9873047)
   0.7879333579929612700000000000f,   //  9465: sin(51.9927979)
   0.7879923896725079500000000000f,   //  9466: sin(51.9982910)
   0.7880514141089977100000000000f,   //  9467: sin(52.0037842)
   0.7881104313018880700000000000f,   //  9468: sin(52.0092773)
   0.7881694412506364800000000000f,   //  9469: sin(52.0147705)
   0.7882284439547004900000000000f,   //  9470: sin(52.0202637)
   0.7882874394135378500000000000f,   //  9471: sin(52.0257568)
   0.7883464276266062300000000000f,   //  9472: sin(52.0312500)
   0.7884054085933635000000000000f,   //  9473: sin(52.0367432)
   0.7884643823132674300000000000f,   //  9474: sin(52.0422363)
   0.7885233487857760100000000000f,   //  9475: sin(52.0477295)
   0.7885823080103471200000000000f,   //  9476: sin(52.0532227)
   0.7886412599864390800000000000f,   //  9477: sin(52.0587158)
   0.7887002047135096600000000000f,   //  9478: sin(52.0642090)
   0.7887591421910173900000000000f,   //  9479: sin(52.0697021)
   0.7888180724184201700000000000f,   //  9480: sin(52.0751953)
   0.7888769953951766400000000000f,   //  9481: sin(52.0806885)
   0.7889359111207451300000000000f,   //  9482: sin(52.0861816)
   0.7889948195945840600000000000f,   //  9483: sin(52.0916748)
   0.7890537208161518800000000000f,   //  9484: sin(52.0971680)
   0.7891126147849072400000000000f,   //  9485: sin(52.1026611)
   0.7891715015003087900000000000f,   //  9486: sin(52.1081543)
   0.7892303809618154100000000000f,   //  9487: sin(52.1136475)
   0.7892892531688856500000000000f,   //  9488: sin(52.1191406)
   0.7893481181209784900000000000f,   //  9489: sin(52.1246338)
   0.7894069758175528100000000000f,   //  9490: sin(52.1301270)
   0.7894658262580677200000000000f,   //  9491: sin(52.1356201)
   0.7895246694419821900000000000f,   //  9492: sin(52.1411133)
   0.7895835053687552100000000000f,   //  9493: sin(52.1466064)
   0.7896423340378463400000000000f,   //  9494: sin(52.1520996)
   0.7897011554487144400000000000f,   //  9495: sin(52.1575928)
   0.7897599696008190700000000000f,   //  9496: sin(52.1630859)
   0.7898187764936195300000000000f,   //  9497: sin(52.1685791)
   0.7898775761265752800000000000f,   //  9498: sin(52.1740723)
   0.7899363684991459500000000000f,   //  9499: sin(52.1795654)
   0.7899951536107910900000000000f,   //  9500: sin(52.1850586)
   0.7900539314609702500000000000f,   //  9501: sin(52.1905518)
   0.7901127020491433000000000000f,   //  9502: sin(52.1960449)
   0.7901714653747699000000000000f,   //  9503: sin(52.2015381)
   0.7902302214373100300000000000f,   //  9504: sin(52.2070313)
   0.7902889702362235800000000000f,   //  9505: sin(52.2125244)
   0.7903477117709705200000000000f,   //  9506: sin(52.2180176)
   0.7904064460410108500000000000f,   //  9507: sin(52.2235107)
   0.7904651730458048800000000000f,   //  9508: sin(52.2290039)
   0.7905238927848126100000000000f,   //  9509: sin(52.2344971)
   0.7905826052574944600000000000f,   //  9510: sin(52.2399902)
   0.7906413104633106500000000000f,   //  9511: sin(52.2454834)
   0.7907000084017216100000000000f,   //  9512: sin(52.2509766)
   0.7907586990721877700000000000f,   //  9513: sin(52.2564697)
   0.7908173824741696600000000000f,   //  9514: sin(52.2619629)
   0.7908760586071279500000000000f,   //  9515: sin(52.2674561)
   0.7909347274705232900000000000f,   //  9516: sin(52.2729492)
   0.7909933890638163300000000000f,   //  9517: sin(52.2784424)
   0.7910520433864679500000000000f,   //  9518: sin(52.2839355)
   0.7911106904379389100000000000f,   //  9519: sin(52.2894287)
   0.7911693302176900900000000000f,   //  9520: sin(52.2949219)
   0.7912279627251828100000000000f,   //  9521: sin(52.3004150)
   0.7912865879598777200000000000f,   //  9522: sin(52.3059082)
   0.7913452059212363600000000000f,   //  9523: sin(52.3114014)
   0.7914038166087195000000000000f,   //  9524: sin(52.3168945)
   0.7914624200217886800000000000f,   //  9525: sin(52.3223877)
   0.7915210161599052200000000000f,   //  9526: sin(52.3278809)
   0.7915796050225304400000000000f,   //  9527: sin(52.3333740)
   0.7916381866091257700000000000f,   //  9528: sin(52.3388672)
   0.7916967609191528600000000000f,   //  9529: sin(52.3443604)
   0.7917553279520731500000000000f,   //  9530: sin(52.3498535)
   0.7918138877073485100000000000f,   //  9531: sin(52.3553467)
   0.7918724401844404700000000000f,   //  9532: sin(52.3608398)
   0.7919309853828110400000000000f,   //  9533: sin(52.3663330)
   0.7919895233019218500000000000f,   //  9534: sin(52.3718262)
   0.7920480539412350100000000000f,   //  9535: sin(52.3773193)
   0.7921065773002123900000000000f,   //  9536: sin(52.3828125)
   0.7921650933783160900000000000f,   //  9537: sin(52.3883057)
   0.7922236021750083100000000000f,   //  9538: sin(52.3937988)
   0.7922821036897511600000000000f,   //  9539: sin(52.3992920)
   0.7923405979220070600000000000f,   //  9540: sin(52.4047852)
   0.7923990848712382200000000000f,   //  9541: sin(52.4102783)
   0.7924575645369069700000000000f,   //  9542: sin(52.4157715)
   0.7925160369184760500000000000f,   //  9543: sin(52.4212646)
   0.7925745020154075800000000000f,   //  9544: sin(52.4267578)
   0.7926329598271646400000000000f,   //  9545: sin(52.4322510)
   0.7926914103532094500000000000f,   //  9546: sin(52.4377441)
   0.7927498535930049800000000000f,   //  9547: sin(52.4432373)
   0.7928082895460141200000000000f,   //  9548: sin(52.4487305)
   0.7928667182116995200000000000f,   //  9549: sin(52.4542236)
   0.7929251395895242600000000000f,   //  9550: sin(52.4597168)
   0.7929835536789512400000000000f,   //  9551: sin(52.4652100)
   0.7930419604794436400000000000f,   //  9552: sin(52.4707031)
   0.7931003599904645800000000000f,   //  9553: sin(52.4761963)
   0.7931587522114771400000000000f,   //  9554: sin(52.4816895)
   0.7932171371419447500000000000f,   //  9555: sin(52.4871826)
   0.7932755147813306300000000000f,   //  9556: sin(52.4926758)
   0.7933338851290983000000000000f,   //  9557: sin(52.4981689)
   0.7933922481847111000000000000f,   //  9558: sin(52.5036621)
   0.7934506039476326700000000000f,   //  9559: sin(52.5091553)
   0.7935089524173266600000000000f,   //  9560: sin(52.5146484)
   0.7935672935932565100000000000f,   //  9561: sin(52.5201416)
   0.7936256274748861900000000000f,   //  9562: sin(52.5256348)
   0.7936839540616794600000000000f,   //  9563: sin(52.5311279)
   0.7937422733531001000000000000f,   //  9564: sin(52.5366211)
   0.7938005853486122000000000000f,   //  9565: sin(52.5421143)
   0.7938588900476796200000000000f,   //  9566: sin(52.5476074)
   0.7939171874497665800000000000f,   //  9567: sin(52.5531006)
   0.7939754775543371700000000000f,   //  9568: sin(52.5585938)
   0.7940337603608554900000000000f,   //  9569: sin(52.5640869)
   0.7940920358687859600000000000f,   //  9570: sin(52.5695801)
   0.7941503040775927900000000000f,   //  9571: sin(52.5750732)
   0.7942085649867406400000000000f,   //  9572: sin(52.5805664)
   0.7942668185956935900000000000f,   //  9573: sin(52.5860596)
   0.7943250649039165200000000000f,   //  9574: sin(52.5915527)
   0.7943833039108739700000000000f,   //  9575: sin(52.5970459)
   0.7944415356160305900000000000f,   //  9576: sin(52.6025391)
   0.7944997600188511400000000000f,   //  9577: sin(52.6080322)
   0.7945579771188002700000000000f,   //  9578: sin(52.6135254)
   0.7946161869153431900000000000f,   //  9579: sin(52.6190186)
   0.7946743894079445500000000000f,   //  9580: sin(52.6245117)
   0.7947325845960694400000000000f,   //  9581: sin(52.6300049)
   0.7947907724791831700000000000f,   //  9582: sin(52.6354980)
   0.7948489530567505200000000000f,   //  9583: sin(52.6409912)
   0.7949071263282370100000000000f,   //  9584: sin(52.6464844)
   0.7949652922931076400000000000f,   //  9585: sin(52.6519775)
   0.7950234509508280500000000000f,   //  9586: sin(52.6574707)
   0.7950816023008635500000000000f,   //  9587: sin(52.6629639)
   0.7951397463426795900000000000f,   //  9588: sin(52.6684570)
   0.7951978830757416800000000000f,   //  9589: sin(52.6739502)
   0.7952560124995155000000000000f,   //  9590: sin(52.6794434)
   0.7953141346134667800000000000f,   //  9591: sin(52.6849365)
   0.7953722494170611900000000000f,   //  9592: sin(52.6904297)
   0.7954303569097646000000000000f,   //  9593: sin(52.6959229)
   0.7954884570910429900000000000f,   //  9594: sin(52.7014160)
   0.7955465499603621100000000000f,   //  9595: sin(52.7069092)
   0.7956046355171880700000000000f,   //  9596: sin(52.7124023)
   0.7956627137609870700000000000f,   //  9597: sin(52.7178955)
   0.7957207846912250900000000000f,   //  9598: sin(52.7233887)
   0.7957788483073685600000000000f,   //  9599: sin(52.7288818)
   0.7958369046088834600000000000f,   //  9600: sin(52.7343750)
   0.7958949535952365400000000000f,   //  9601: sin(52.7398682)
   0.7959529952658939100000000000f,   //  9602: sin(52.7453613)
   0.7960110296203221100000000000f,   //  9603: sin(52.7508545)
   0.7960690566579879900000000000f,   //  9604: sin(52.7563477)
   0.7961270763783577800000000000f,   //  9605: sin(52.7618408)
   0.7961850887808984400000000000f,   //  9606: sin(52.7673340)
   0.7962430938650765200000000000f,   //  9607: sin(52.7728271)
   0.7963010916303591100000000000f,   //  9608: sin(52.7783203)
   0.7963590820762129800000000000f,   //  9609: sin(52.7838135)
   0.7964170652021049800000000000f,   //  9610: sin(52.7893066)
   0.7964750410075023300000000000f,   //  9611: sin(52.7947998)
   0.7965330094918720000000000000f,   //  9612: sin(52.8002930)
   0.7965909706546812100000000000f,   //  9613: sin(52.8057861)
   0.7966489244953971500000000000f,   //  9614: sin(52.8112793)
   0.7967068710134872500000000000f,   //  9615: sin(52.8167725)
   0.7967648102084187200000000000f,   //  9616: sin(52.8222656)
   0.7968227420796590900000000000f,   //  9617: sin(52.8277588)
   0.7968806666266757800000000000f,   //  9618: sin(52.8332520)
   0.7969385838489365700000000000f,   //  9619: sin(52.8387451)
   0.7969964937459087500000000000f,   //  9620: sin(52.8442383)
   0.7970543963170603200000000000f,   //  9621: sin(52.8497314)
   0.7971122915618589200000000000f,   //  9622: sin(52.8552246)
   0.7971701794797724200000000000f,   //  9623: sin(52.8607178)
   0.7972280600702687000000000000f,   //  9624: sin(52.8662109)
   0.7972859333328157200000000000f,   //  9625: sin(52.8717041)
   0.7973437992668817000000000000f,   //  9626: sin(52.8771973)
   0.7974016578719345100000000000f,   //  9627: sin(52.8826904)
   0.7974595091474424600000000000f,   //  9628: sin(52.8881836)
   0.7975173530928737500000000000f,   //  9629: sin(52.8936768)
   0.7975751897076965900000000000f,   //  9630: sin(52.8991699)
   0.7976330189913796200000000000f,   //  9631: sin(52.9046631)
   0.7976908409433910400000000000f,   //  9632: sin(52.9101563)
   0.7977486555631995200000000000f,   //  9633: sin(52.9156494)
   0.7978064628502735700000000000f,   //  9634: sin(52.9211426)
   0.7978642628040817400000000000f,   //  9635: sin(52.9266357)
   0.7979220554240930000000000000f,   //  9636: sin(52.9321289)
   0.7979798407097759000000000000f,   //  9637: sin(52.9376221)
   0.7980376186605994100000000000f,   //  9638: sin(52.9431152)
   0.7980953892760323000000000000f,   //  9639: sin(52.9486084)
   0.7981531525555437500000000000f,   //  9640: sin(52.9541016)
   0.7982109084986027700000000000f,   //  9641: sin(52.9595947)
   0.7982686571046783100000000000f,   //  9642: sin(52.9650879)
   0.7983263983732398200000000000f,   //  9643: sin(52.9705811)
   0.7983841323037563800000000000f,   //  9644: sin(52.9760742)
   0.7984418588956973000000000000f,   //  9645: sin(52.9815674)
   0.7984995781485320100000000000f,   //  9646: sin(52.9870605)
   0.7985572900617300400000000000f,   //  9647: sin(52.9925537)
   0.7986149946347608200000000000f,   //  9648: sin(52.9980469)
   0.7986726918670940000000000000f,   //  9649: sin(53.0035400)
   0.7987303817581992100000000000f,   //  9650: sin(53.0090332)
   0.7987880643075461200000000000f,   //  9651: sin(53.0145264)
   0.7988457395146045800000000000f,   //  9652: sin(53.0200195)
   0.7989034073788444700000000000f,   //  9653: sin(53.0255127)
   0.7989610678997357600000000000f,   //  9654: sin(53.0310059)
   0.7990187210767484300000000000f,   //  9655: sin(53.0364990)
   0.7990763669093523500000000000f,   //  9656: sin(53.0419922)
   0.7991340053970178400000000000f,   //  9657: sin(53.0474854)
   0.7991916365392152100000000000f,   //  9658: sin(53.0529785)
   0.7992492603354144400000000000f,   //  9659: sin(53.0584717)
   0.7993068767850861600000000000f,   //  9660: sin(53.0639648)
   0.7993644858877004800000000000f,   //  9661: sin(53.0694580)
   0.7994220876427280400000000000f,   //  9662: sin(53.0749512)
   0.7994796820496393700000000000f,   //  9663: sin(53.0804443)
   0.7995372691079050100000000000f,   //  9664: sin(53.0859375)
   0.7995948488169957200000000000f,   //  9665: sin(53.0914307)
   0.7996524211763821300000000000f,   //  9666: sin(53.0969238)
   0.7997099861855352400000000000f,   //  9667: sin(53.1024170)
   0.7997675438439256800000000000f,   //  9668: sin(53.1079102)
   0.7998250941510245400000000000f,   //  9669: sin(53.1134033)
   0.7998826371063028100000000000f,   //  9670: sin(53.1188965)
   0.7999401727092314600000000000f,   //  9671: sin(53.1243896)
   0.7999977009592819100000000000f,   //  9672: sin(53.1298828)
   0.8000552218559250400000000000f,   //  9673: sin(53.1353760)
   0.8001127353986323700000000000f,   //  9674: sin(53.1408691)
   0.8001702415868751100000000000f,   //  9675: sin(53.1463623)
   0.8002277404201247900000000000f,   //  9676: sin(53.1518555)
   0.8002852318978528300000000000f,   //  9677: sin(53.1573486)
   0.8003427160195306600000000000f,   //  9678: sin(53.1628418)
   0.8004001927846300400000000000f,   //  9679: sin(53.1683350)
   0.8004576621926227100000000000f,   //  9680: sin(53.1738281)
   0.8005151242429803200000000000f,   //  9681: sin(53.1793213)
   0.8005725789351747500000000000f,   //  9682: sin(53.1848145)
   0.8006300262686778500000000000f,   //  9683: sin(53.1903076)
   0.8006874662429615000000000000f,   //  9684: sin(53.1958008)
   0.8007448988574980000000000000f,   //  9685: sin(53.2012939)
   0.8008023241117591100000000000f,   //  9686: sin(53.2067871)
   0.8008597420052171500000000000f,   //  9687: sin(53.2122803)
   0.8009171525373443000000000000f,   //  9688: sin(53.2177734)
   0.8009745557076128900000000000f,   //  9689: sin(53.2232666)
   0.8010319515154953300000000000f,   //  9690: sin(53.2287598)
   0.8010893399604639400000000000f,   //  9691: sin(53.2342529)
   0.8011467210419912500000000000f,   //  9692: sin(53.2397461)
   0.8012040947595499000000000000f,   //  9693: sin(53.2452393)
   0.8012614611126125400000000000f,   //  9694: sin(53.2507324)
   0.8013188201006515900000000000f,   //  9695: sin(53.2562256)
   0.8013761717231401300000000000f,   //  9696: sin(53.2617188)
   0.8014335159795510400000000000f,   //  9697: sin(53.2672119)
   0.8014908528693568400000000000f,   //  9698: sin(53.2727051)
   0.8015481823920309600000000000f,   //  9699: sin(53.2781982)
   0.8016055045470460400000000000f,   //  9700: sin(53.2836914)
   0.8016628193338755100000000000f,   //  9701: sin(53.2891846)
   0.8017201267519923300000000000f,   //  9702: sin(53.2946777)
   0.8017774268008698300000000000f,   //  9703: sin(53.3001709)
   0.8018347194799813100000000000f,   //  9704: sin(53.3056641)
   0.8018920047888000700000000000f,   //  9705: sin(53.3111572)
   0.8019492827267996600000000000f,   //  9706: sin(53.3166504)
   0.8020065532934536100000000000f,   //  9707: sin(53.3221436)
   0.8020638164882354400000000000f,   //  9708: sin(53.3276367)
   0.8021210723106189100000000000f,   //  9709: sin(53.3331299)
   0.8021783207600774500000000000f,   //  9710: sin(53.3386230)
   0.8022355618360851300000000000f,   //  9711: sin(53.3441162)
   0.8022927955381157200000000000f,   //  9712: sin(53.3496094)
   0.8023500218656430800000000000f,   //  9713: sin(53.3551025)
   0.8024072408181413000000000000f,   //  9714: sin(53.3605957)
   0.8024644523950843500000000000f,   //  9715: sin(53.3660889)
   0.8025216565959463200000000000f,   //  9716: sin(53.3715820)
   0.8025788534202015200000000000f,   //  9717: sin(53.3770752)
   0.8026360428673241500000000000f,   //  9718: sin(53.3825684)
   0.8026932249367886300000000000f,   //  9719: sin(53.3880615)
   0.8027503996280691600000000000f,   //  9720: sin(53.3935547)
   0.8028075669406403700000000000f,   //  9721: sin(53.3990479)
   0.8028647268739765900000000000f,   //  9722: sin(53.4045410)
   0.8029218794275526600000000000f,   //  9723: sin(53.4100342)
   0.8029790246008431400000000000f,   //  9724: sin(53.4155273)
   0.8030361623933227600000000000f,   //  9725: sin(53.4210205)
   0.8030932928044664000000000000f,   //  9726: sin(53.4265137)
   0.8031504158337486900000000000f,   //  9727: sin(53.4320068)
   0.8032075314806448300000000000f,   //  9728: sin(53.4375000)
   0.8032646397446298000000000000f,   //  9729: sin(53.4429932)
   0.8033217406251784700000000000f,   //  9730: sin(53.4484863)
   0.8033788341217662500000000000f,   //  9731: sin(53.4539795)
   0.8034359202338681200000000000f,   //  9732: sin(53.4594727)
   0.8034929989609594900000000000f,   //  9733: sin(53.4649658)
   0.8035500703025155700000000000f,   //  9734: sin(53.4704590)
   0.8036071342580120000000000000f,   //  9735: sin(53.4759521)
   0.8036641908269240900000000000f,   //  9736: sin(53.4814453)
   0.8037212400087273600000000000f,   //  9737: sin(53.4869385)
   0.8037782818028975700000000000f,   //  9738: sin(53.4924316)
   0.8038353162089102400000000000f,   //  9739: sin(53.4979248)
   0.8038923432262412600000000000f,   //  9740: sin(53.5034180)
   0.8039493628543664700000000000f,   //  9741: sin(53.5089111)
   0.8040063750927615200000000000f,   //  9742: sin(53.5144043)
   0.8040633799409027100000000000f,   //  9743: sin(53.5198975)
   0.8041203773982657000000000000f,   //  9744: sin(53.5253906)
   0.8041773674643268900000000000f,   //  9745: sin(53.5308838)
   0.8042343501385622600000000000f,   //  9746: sin(53.5363770)
   0.8042913254204481200000000000f,   //  9747: sin(53.5418701)
   0.8043482933094607800000000000f,   //  9748: sin(53.5473633)
   0.8044052538050764400000000000f,   //  9749: sin(53.5528564)
   0.8044622069067718400000000000f,   //  9750: sin(53.5583496)
   0.8045191526140230700000000000f,   //  9751: sin(53.5638428)
   0.8045760909263070000000000000f,   //  9752: sin(53.5693359)
   0.8046330218431002600000000000f,   //  9753: sin(53.5748291)
   0.8046899453638795000000000000f,   //  9754: sin(53.5803223)
   0.8047468614881213600000000000f,   //  9755: sin(53.5858154)
   0.8048037702153028100000000000f,   //  9756: sin(53.5913086)
   0.8048606715449007100000000000f,   //  9757: sin(53.5968018)
   0.8049175654763921500000000000f,   //  9758: sin(53.6022949)
   0.8049744520092541000000000000f,   //  9759: sin(53.6077881)
   0.8050313311429636600000000000f,   //  9760: sin(53.6132813)
   0.8050882028769978900000000000f,   //  9761: sin(53.6187744)
   0.8051450672108341200000000000f,   //  9762: sin(53.6242676)
   0.8052019241439498700000000000f,   //  9763: sin(53.6297607)
   0.8052587736758222100000000000f,   //  9764: sin(53.6352539)
   0.8053156158059288100000000000f,   //  9765: sin(53.6407471)
   0.8053724505337470600000000000f,   //  9766: sin(53.6462402)
   0.8054292778587546200000000000f,   //  9767: sin(53.6517334)
   0.8054860977804291200000000000f,   //  9768: sin(53.6572266)
   0.8055429102982483200000000000f,   //  9769: sin(53.6627197)
   0.8055997154116899500000000000f,   //  9770: sin(53.6682129)
   0.8056565131202319000000000000f,   //  9771: sin(53.6737061)
   0.8057133034233521200000000000f,   //  9772: sin(53.6791992)
   0.8057700863205286000000000000f,   //  9773: sin(53.6846924)
   0.8058268618112393000000000000f,   //  9774: sin(53.6901855)
   0.8058836298949625400000000000f,   //  9775: sin(53.6956787)
   0.8059403905711762800000000000f,   //  9776: sin(53.7011719)
   0.8059971438393590500000000000f,   //  9777: sin(53.7066650)
   0.8060538896989889500000000000f,   //  9778: sin(53.7121582)
   0.8061106281495445900000000000f,   //  9779: sin(53.7176514)
   0.8061673591905043100000000000f,   //  9780: sin(53.7231445)
   0.8062240828213467200000000000f,   //  9781: sin(53.7286377)
   0.8062807990415503700000000000f,   //  9782: sin(53.7341309)
   0.8063375078505939900000000000f,   //  9783: sin(53.7396240)
   0.8063942092479562400000000000f,   //  9784: sin(53.7451172)
   0.8064509032331160800000000000f,   //  9785: sin(53.7506104)
   0.8065075898055522600000000000f,   //  9786: sin(53.7561035)
   0.8065642689647437600000000000f,   //  9787: sin(53.7615967)
   0.8066209407101696500000000000f,   //  9788: sin(53.7670898)
   0.8066776050413089200000000000f,   //  9789: sin(53.7725830)
   0.8067342619576407500000000000f,   //  9790: sin(53.7780762)
   0.8067909114586444600000000000f,   //  9791: sin(53.7835693)
   0.8068475535437992200000000000f,   //  9792: sin(53.7890625)
   0.8069041882125844700000000000f,   //  9793: sin(53.7945557)
   0.8069608154644796200000000000f,   //  9794: sin(53.8000488)
   0.8070174352989641900000000000f,   //  9795: sin(53.8055420)
   0.8070740477155176100000000000f,   //  9796: sin(53.8110352)
   0.8071306527136196100000000000f,   //  9797: sin(53.8165283)
   0.8071872502927498500000000000f,   //  9798: sin(53.8220215)
   0.8072438404523882800000000000f,   //  9799: sin(53.8275146)
   0.8073004231920144500000000000f,   //  9800: sin(53.8330078)
   0.8073569985111084300000000000f,   //  9801: sin(53.8385010)
   0.8074135664091501900000000000f,   //  9802: sin(53.8439941)
   0.8074701268856197000000000000f,   //  9803: sin(53.8494873)
   0.8075266799399971600000000000f,   //  9804: sin(53.8549805)
   0.8075832255717626500000000000f,   //  9805: sin(53.8604736)
   0.8076397637803963700000000000f,   //  9806: sin(53.8659668)
   0.8076962945653788400000000000f,   //  9807: sin(53.8714600)
   0.8077528179261903600000000000f,   //  9808: sin(53.8769531)
   0.8078093338623112400000000000f,   //  9809: sin(53.8824463)
   0.8078658423732221200000000000f,   //  9810: sin(53.8879395)
   0.8079223434584035200000000000f,   //  9811: sin(53.8934326)
   0.8079788371173363100000000000f,   //  9812: sin(53.8989258)
   0.8080353233495009000000000000f,   //  9813: sin(53.9044189)
   0.8080918021543782600000000000f,   //  9814: sin(53.9099121)
   0.8081482735314492500000000000f,   //  9815: sin(53.9154053)
   0.8082047374801947200000000000f,   //  9816: sin(53.9208984)
   0.8082611940000956600000000000f,   //  9817: sin(53.9263916)
   0.8083176430906332500000000000f,   //  9818: sin(53.9318848)
   0.8083740847512885800000000000f,   //  9819: sin(53.9373779)
   0.8084305189815427200000000000f,   //  9820: sin(53.9428711)
   0.8084869457808771000000000000f,   //  9821: sin(53.9483643)
   0.8085433651487730100000000000f,   //  9822: sin(53.9538574)
   0.8085997770847117600000000000f,   //  9823: sin(53.9593506)
   0.8086561815881749800000000000f,   //  9824: sin(53.9648438)
   0.8087125786586441000000000000f,   //  9825: sin(53.9703369)
   0.8087689682956008500000000000f,   //  9826: sin(53.9758301)
   0.8088253504985266600000000000f,   //  9827: sin(53.9813232)
   0.8088817252669036100000000000f,   //  9828: sin(53.9868164)
   0.8089380926002133200000000000f,   //  9829: sin(53.9923096)
   0.8089944524979375600000000000f,   //  9830: sin(53.9978027)
   0.8090508049595586100000000000f,   //  9831: sin(54.0032959)
   0.8091071499845581300000000000f,   //  9832: sin(54.0087891)
   0.8091634875724185200000000000f,   //  9833: sin(54.0142822)
   0.8092198177226217500000000000f,   //  9834: sin(54.0197754)
   0.8092761404346501300000000000f,   //  9835: sin(54.0252686)
   0.8093324557079858400000000000f,   //  9836: sin(54.0307617)
   0.8093887635421114200000000000f,   //  9837: sin(54.0362549)
   0.8094450639365091700000000000f,   //  9838: sin(54.0417480)
   0.8095013568906616100000000000f,   //  9839: sin(54.0472412)
   0.8095576424040512600000000000f,   //  9840: sin(54.0527344)
   0.8096139204761608800000000000f,   //  9841: sin(54.0582275)
   0.8096701911064730900000000000f,   //  9842: sin(54.0637207)
   0.8097264542944706500000000000f,   //  9843: sin(54.0692139)
   0.8097827100396364200000000000f,   //  9844: sin(54.0747070)
   0.8098389583414533600000000000f,   //  9845: sin(54.0802002)
   0.8098951991994044500000000000f,   //  9846: sin(54.0856934)
   0.8099514326129726400000000000f,   //  9847: sin(54.0911865)
   0.8100076585816411400000000000f,   //  9848: sin(54.0966797)
   0.8100638771048930300000000000f,   //  9849: sin(54.1021729)
   0.8101200881822116000000000000f,   //  9850: sin(54.1076660)
   0.8101762918130802600000000000f,   //  9851: sin(54.1131592)
   0.8102324879969823300000000000f,   //  9852: sin(54.1186523)
   0.8102886767334012100000000000f,   //  9853: sin(54.1241455)
   0.8103448580218205500000000000f,   //  9854: sin(54.1296387)
   0.8104010318617237400000000000f,   //  9855: sin(54.1351318)
   0.8104571982525947700000000000f,   //  9856: sin(54.1406250)
   0.8105133571939170400000000000f,   //  9857: sin(54.1461182)
   0.8105695086851746300000000000f,   //  9858: sin(54.1516113)
   0.8106256527258510800000000000f,   //  9859: sin(54.1571045)
   0.8106817893154306700000000000f,   //  9860: sin(54.1625977)
   0.8107379184533971600000000000f,   //  9861: sin(54.1680908)
   0.8107940401392347300000000000f,   //  9862: sin(54.1735840)
   0.8108501543724275800000000000f,   //  9863: sin(54.1790771)
   0.8109062611524596700000000000f,   //  9864: sin(54.1845703)
   0.8109623604788156500000000000f,   //  9865: sin(54.1900635)
   0.8110184523509794700000000000f,   //  9866: sin(54.1955566)
   0.8110745367684357700000000000f,   //  9867: sin(54.2010498)
   0.8111306137306691900000000000f,   //  9868: sin(54.2065430)
   0.8111866832371639200000000000f,   //  9869: sin(54.2120361)
   0.8112427452874048100000000000f,   //  9870: sin(54.2175293)
   0.8112987998808765000000000000f,   //  9871: sin(54.2230225)
   0.8113548470170637300000000000f,   //  9872: sin(54.2285156)
   0.8114108866954513600000000000f,   //  9873: sin(54.2340088)
   0.8114669189155242500000000000f,   //  9874: sin(54.2395020)
   0.8115229436767674700000000000f,   //  9875: sin(54.2449951)
   0.8115789609786658900000000000f,   //  9876: sin(54.2504883)
   0.8116349708207046800000000000f,   //  9877: sin(54.2559814)
   0.8116909732023690500000000000f,   //  9878: sin(54.2614746)
   0.8117469681231441700000000000f,   //  9879: sin(54.2669678)
   0.8118029555825153600000000000f,   //  9880: sin(54.2724609)
   0.8118589355799680200000000000f,   //  9881: sin(54.2779541)
   0.8119149081149876800000000000f,   //  9882: sin(54.2834473)
   0.8119708731870597400000000000f,   //  9883: sin(54.2889404)
   0.8120268307956697300000000000f,   //  9884: sin(54.2944336)
   0.8120827809403033900000000000f,   //  9885: sin(54.2999268)
   0.8121387236204464800000000000f,   //  9886: sin(54.3054199)
   0.8121946588355847300000000000f,   //  9887: sin(54.3109131)
   0.8122505865852038800000000000f,   //  9888: sin(54.3164063)
   0.8123065068687900200000000000f,   //  9889: sin(54.3218994)
   0.8123624196858291200000000000f,   //  9890: sin(54.3273926)
   0.8124183250358072400000000000f,   //  9891: sin(54.3328857)
   0.8124742229182104800000000000f,   //  9892: sin(54.3383789)
   0.8125301133325250100000000000f,   //  9893: sin(54.3438721)
   0.8125859962782370200000000000f,   //  9894: sin(54.3493652)
   0.8126418717548331600000000000f,   //  9895: sin(54.3548584)
   0.8126977397617994900000000000f,   //  9896: sin(54.3603516)
   0.8127536002986226500000000000f,   //  9897: sin(54.3658447)
   0.8128094533647891600000000000f,   //  9898: sin(54.3713379)
   0.8128652989597856500000000000f,   //  9899: sin(54.3768311)
   0.8129211370830987700000000000f,   //  9900: sin(54.3823242)
   0.8129769677342152400000000000f,   //  9901: sin(54.3878174)
   0.8130327909126219300000000000f,   //  9902: sin(54.3933105)
   0.8130886066178056900000000000f,   //  9903: sin(54.3988037)
   0.8131444148492535900000000000f,   //  9904: sin(54.4042969)
   0.8132002156064523900000000000f,   //  9905: sin(54.4097900)
   0.8132560088888893800000000000f,   //  9906: sin(54.4152832)
   0.8133117946960517500000000000f,   //  9907: sin(54.4207764)
   0.8133675730274265700000000000f,   //  9908: sin(54.4262695)
   0.8134233438825013700000000000f,   //  9909: sin(54.4317627)
   0.8134791072607632200000000000f,   //  9910: sin(54.4372559)
   0.8135348631616997600000000000f,   //  9911: sin(54.4427490)
   0.8135906115847985100000000000f,   //  9912: sin(54.4482422)
   0.8136463525295468700000000000f,   //  9913: sin(54.4537354)
   0.8137020859954327000000000000f,   //  9914: sin(54.4592285)
   0.8137578119819435200000000000f,   //  9915: sin(54.4647217)
   0.8138135304885671900000000000f,   //  9916: sin(54.4702148)
   0.8138692415147915600000000000f,   //  9917: sin(54.4757080)
   0.8139249450601044900000000000f,   //  9918: sin(54.4812012)
   0.8139806411239941500000000000f,   //  9919: sin(54.4866943)
   0.8140363297059483000000000000f,   //  9920: sin(54.4921875)
   0.8140920108054553500000000000f,   //  9921: sin(54.4976807)
   0.8141476844220033600000000000f,   //  9922: sin(54.5031738)
   0.8142033505550804200000000000f,   //  9923: sin(54.5086670)
   0.8142590092041752700000000000f,   //  9924: sin(54.5141602)
   0.8143146603687758700000000000f,   //  9925: sin(54.5196533)
   0.8143703040483710700000000000f,   //  9926: sin(54.5251465)
   0.8144259402424490800000000000f,   //  9927: sin(54.5306396)
   0.8144815689504986100000000000f,   //  9928: sin(54.5361328)
   0.8145371901720084300000000000f,   //  9929: sin(54.5416260)
   0.8145928039064672700000000000f,   //  9930: sin(54.5471191)
   0.8146484101533638700000000000f,   //  9931: sin(54.5526123)
   0.8147040089121870800000000000f,   //  9932: sin(54.5581055)
   0.8147596001824258800000000000f,   //  9933: sin(54.5635986)
   0.8148151839635693300000000000f,   //  9934: sin(54.5690918)
   0.8148707602551065200000000000f,   //  9935: sin(54.5745850)
   0.8149263290565266200000000000f,   //  9936: sin(54.5800781)
   0.8149818903673187200000000000f,   //  9937: sin(54.5855713)
   0.8150374441869722200000000000f,   //  9938: sin(54.5910645)
   0.8150929905149764100000000000f,   //  9939: sin(54.5965576)
   0.8151485293508208300000000000f,   //  9940: sin(54.6020508)
   0.8152040606939949800000000000f,   //  9941: sin(54.6075439)
   0.8152595845439882800000000000f,   //  9942: sin(54.6130371)
   0.8153151009002904700000000000f,   //  9943: sin(54.6185303)
   0.8153706097623912900000000000f,   //  9944: sin(54.6240234)
   0.8154261111297803600000000000f,   //  9945: sin(54.6295166)
   0.8154816050019477700000000000f,   //  9946: sin(54.6350098)
   0.8155370913783831500000000000f,   //  9947: sin(54.6405029)
   0.8155925702585766800000000000f,   //  9948: sin(54.6459961)
   0.8156480416420183200000000000f,   //  9949: sin(54.6514893)
   0.8157035055281982600000000000f,   //  9950: sin(54.6569824)
   0.8157589619166066800000000000f,   //  9951: sin(54.6624756)
   0.8158144108067337800000000000f,   //  9952: sin(54.6679688)
   0.8158698521980699600000000000f,   //  9953: sin(54.6734619)
   0.8159252860901053900000000000f,   //  9954: sin(54.6789551)
   0.8159807124823308400000000000f,   //  9955: sin(54.6844482)
   0.8160361313742367000000000000f,   //  9956: sin(54.6899414)
   0.8160915427653135900000000000f,   //  9957: sin(54.6954346)
   0.8161469466550521600000000000f,   //  9958: sin(54.7009277)
   0.8162023430429431500000000000f,   //  9959: sin(54.7064209)
   0.8162577319284773900000000000f,   //  9960: sin(54.7119141)
   0.8163131133111457500000000000f,   //  9961: sin(54.7174072)
   0.8163684871904392000000000000f,   //  9962: sin(54.7229004)
   0.8164238535658486800000000000f,   //  9963: sin(54.7283936)
   0.8164792124368653900000000000f,   //  9964: sin(54.7338867)
   0.8165345638029802800000000000f,   //  9965: sin(54.7393799)
   0.8165899076636848900000000000f,   //  9966: sin(54.7448730)
   0.8166452440184701600000000000f,   //  9967: sin(54.7503662)
   0.8167005728668278500000000000f,   //  9968: sin(54.7558594)
   0.8167558942082489000000000000f,   //  9969: sin(54.7613525)
   0.8168112080422252900000000000f,   //  9970: sin(54.7668457)
   0.8168665143682482000000000000f,   //  9971: sin(54.7723389)
   0.8169218131858094800000000000f,   //  9972: sin(54.7778320)
   0.8169771044944007500000000000f,   //  9973: sin(54.7833252)
   0.8170323882935138800000000000f,   //  9974: sin(54.7888184)
   0.8170876645826407000000000000f,   //  9975: sin(54.7943115)
   0.8171429333612729700000000000f,   //  9976: sin(54.7998047)
   0.8171981946289027500000000000f,   //  9977: sin(54.8052979)
   0.8172534483850222300000000000f,   //  9978: sin(54.8107910)
   0.8173086946291233700000000000f,   //  9979: sin(54.8162842)
   0.8173639333606984600000000000f,   //  9980: sin(54.8217773)
   0.8174191645792395800000000000f,   //  9981: sin(54.8272705)
   0.8174743882842392400000000000f,   //  9982: sin(54.8327637)
   0.8175296044751898500000000000f,   //  9983: sin(54.8382568)
   0.8175848131515837100000000000f,   //  9984: sin(54.8437500)
   0.8176400143129134400000000000f,   //  9985: sin(54.8492432)
   0.8176952079586716800000000000f,   //  9986: sin(54.8547363)
   0.8177503940883510400000000000f,   //  9987: sin(54.8602295)
   0.8178055727014442700000000000f,   //  9988: sin(54.8657227)
   0.8178607437974442200000000000f,   //  9989: sin(54.8712158)
   0.8179159073758437400000000000f,   //  9990: sin(54.8767090)
   0.8179710634361357900000000000f,   //  9991: sin(54.8822021)
   0.8180262119778134400000000000f,   //  9992: sin(54.8876953)
   0.8180813530003696600000000000f,   //  9993: sin(54.8931885)
   0.8181364865032976200000000000f,   //  9994: sin(54.8986816)
   0.8181916124860907400000000000f,   //  9995: sin(54.9041748)
   0.8182467309482419600000000000f,   //  9996: sin(54.9096680)
   0.8183018418892450400000000000f,   //  9997: sin(54.9151611)
   0.8183569453085931500000000000f,   //  9998: sin(54.9206543)
   0.8184120412057798200000000000f,   //  9999: sin(54.9261475)
   0.8184671295802986600000000000f,   // 10000: sin(54.9316406)
   0.8185222104316433000000000000f,   // 10001: sin(54.9371338)
   0.8185772837593074900000000000f,   // 10002: sin(54.9426270)
   0.8186323495627849700000000000f,   // 10003: sin(54.9481201)
   0.8186874078415695700000000000f,   // 10004: sin(54.9536133)
   0.8187424585951552600000000000f,   // 10005: sin(54.9591064)
   0.8187975018230360100000000000f,   // 10006: sin(54.9645996)
   0.8188525375247058800000000000f,   // 10007: sin(54.9700928)
   0.8189075656996589500000000000f,   // 10008: sin(54.9755859)
   0.8189625863473893900000000000f,   // 10009: sin(54.9810791)
   0.8190175994673915000000000000f,   // 10010: sin(54.9865723)
   0.8190726050591595800000000000f,   // 10011: sin(54.9920654)
   0.8191276031221882400000000000f,   // 10012: sin(54.9975586)
   0.8191825936559716800000000000f,   // 10013: sin(55.0030518)
   0.8192375766600045200000000000f,   // 10014: sin(55.0085449)
   0.8192925521337813800000000000f,   // 10015: sin(55.0140381)
   0.8193475200767969000000000000f,   // 10016: sin(55.0195313)
   0.8194024804885460300000000000f,   // 10017: sin(55.0250244)
   0.8194574333685232800000000000f,   // 10018: sin(55.0305176)
   0.8195123787162237300000000000f,   // 10019: sin(55.0360107)
   0.8195673165311422300000000000f,   // 10020: sin(55.0415039)
   0.8196222468127738500000000000f,   // 10021: sin(55.0469971)
   0.8196771695606137600000000000f,   // 10022: sin(55.0524902)
   0.8197320847741570400000000000f,   // 10023: sin(55.0579834)
   0.8197869924528989900000000000f,   // 10024: sin(55.0634766)
   0.8198418925963347800000000000f,   // 10025: sin(55.0689697)
   0.8198967852039598100000000000f,   // 10026: sin(55.0744629)
   0.8199516702752696100000000000f,   // 10027: sin(55.0799561)
   0.8200065478097596800000000000f,   // 10028: sin(55.0854492)
   0.8200614178069255400000000000f,   // 10029: sin(55.0909424)
   0.8201162802662627100000000000f,   // 10030: sin(55.0964355)
   0.8201711351872671400000000000f,   // 10031: sin(55.1019287)
   0.8202259825694346900000000000f,   // 10032: sin(55.1074219)
   0.8202808224122608600000000000f,   // 10033: sin(55.1129150)
   0.8203356547152418400000000000f,   // 10034: sin(55.1184082)
   0.8203904794778734700000000000f,   // 10035: sin(55.1239014)
   0.8204452966996520500000000000f,   // 10036: sin(55.1293945)
   0.8205001063800734200000000000f,   // 10037: sin(55.1348877)
   0.8205549085186338900000000000f,   // 10038: sin(55.1403809)
   0.8206097031148298400000000000f,   // 10039: sin(55.1458740)
   0.8206644901681574600000000000f,   // 10040: sin(55.1513672)
   0.8207192696781132600000000000f,   // 10041: sin(55.1568604)
   0.8207740416441936500000000000f,   // 10042: sin(55.1623535)
   0.8208288060658951400000000000f,   // 10043: sin(55.1678467)
   0.8208835629427145800000000000f,   // 10044: sin(55.1733398)
   0.8209383122741483700000000000f,   // 10045: sin(55.1788330)
   0.8209930540596934700000000000f,   // 10046: sin(55.1843262)
   0.8210477882988466100000000000f,   // 10047: sin(55.1898193)
   0.8211025149911046500000000000f,   // 10048: sin(55.1953125)
   0.8211572341359646400000000000f,   // 10049: sin(55.2008057)
   0.8212119457329235500000000000f,   // 10050: sin(55.2062988)
   0.8212666497814785600000000000f,   // 10051: sin(55.2117920)
   0.8213213462811267400000000000f,   // 10052: sin(55.2172852)
   0.8213760352313653800000000000f,   // 10053: sin(55.2227783)
   0.8214307166316917600000000000f,   // 10054: sin(55.2282715)
   0.8214853904816032900000000000f,   // 10055: sin(55.2337646)
   0.8215400567805976100000000000f,   // 10056: sin(55.2392578)
   0.8215947155281718700000000000f,   // 10057: sin(55.2447510)
   0.8216493667238238300000000000f,   // 10058: sin(55.2502441)
   0.8217040103670512100000000000f,   // 10059: sin(55.2557373)
   0.8217586464573516400000000000f,   // 10060: sin(55.2612305)
   0.8218132749942230800000000000f,   // 10061: sin(55.2667236)
   0.8218678959771631400000000000f,   // 10062: sin(55.2722168)
   0.8219225094056700200000000000f,   // 10063: sin(55.2777100)
   0.8219771152792415500000000000f,   // 10064: sin(55.2832031)
   0.8220317135973758100000000000f,   // 10065: sin(55.2886963)
   0.8220863043595710900000000000f,   // 10066: sin(55.2941895)
   0.8221408875653253300000000000f,   // 10067: sin(55.2996826)
   0.8221954632141371700000000000f,   // 10068: sin(55.3051758)
   0.8222500313055046700000000000f,   // 10069: sin(55.3106689)
   0.8223045918389263500000000000f,   // 10070: sin(55.3161621)
   0.8223591448139008200000000000f,   // 10071: sin(55.3216553)
   0.8224136902299263900000000000f,   // 10072: sin(55.3271484)
   0.8224682280865018800000000000f,   // 10073: sin(55.3326416)
   0.8225227583831259400000000000f,   // 10074: sin(55.3381348)
   0.8225772811192974000000000000f,   // 10075: sin(55.3436279)
   0.8226317962945149900000000000f,   // 10076: sin(55.3491211)
   0.8226863039082775700000000000f,   // 10077: sin(55.3546143)
   0.8227408039600844200000000000f,   // 10078: sin(55.3601074)
   0.8227952964494342800000000000f,   // 10079: sin(55.3656006)
   0.8228497813758263200000000000f,   // 10080: sin(55.3710938)
   0.8229042587387598300000000000f,   // 10081: sin(55.3765869)
   0.8229587285377340000000000000f,   // 10082: sin(55.3820801)
   0.8230131907722481000000000000f,   // 10083: sin(55.3875732)
   0.8230676454418016700000000000f,   // 10084: sin(55.3930664)
   0.8231220925458940800000000000f,   // 10085: sin(55.3985596)
   0.8231765320840248600000000000f,   // 10086: sin(55.4040527)
   0.8232309640556936300000000000f,   // 10087: sin(55.4095459)
   0.8232853884604001100000000000f,   // 10088: sin(55.4150391)
   0.8233398052976439500000000000f,   // 10089: sin(55.4205322)
   0.8233942145669250800000000000f,   // 10090: sin(55.4260254)
   0.8234486162677432400000000000f,   // 10091: sin(55.4315186)
   0.8235030103995983900000000000f,   // 10092: sin(55.4370117)
   0.8235573969619908200000000000f,   // 10093: sin(55.4425049)
   0.8236117759544202600000000000f,   // 10094: sin(55.4479980)
   0.8236661473763869900000000000f,   // 10095: sin(55.4534912)
   0.8237205112273913200000000000f,   // 10096: sin(55.4589844)
   0.8237748675069335200000000000f,   // 10097: sin(55.4644775)
   0.8238292162145139900000000000f,   // 10098: sin(55.4699707)
   0.8238835573496330300000000000f,   // 10099: sin(55.4754639)
   0.8239378909117913700000000000f,   // 10100: sin(55.4809570)
   0.8239922169004892900000000000f,   // 10101: sin(55.4864502)
   0.8240465353152277600000000000f,   // 10102: sin(55.4919434)
   0.8241008461555071600000000000f,   // 10103: sin(55.4974365)
   0.8241551494208285700000000000f,   // 10104: sin(55.5029297)
   0.8242094451106927200000000000f,   // 10105: sin(55.5084229)
   0.8242637332246004500000000000f,   // 10106: sin(55.5139160)
   0.8243180137620530500000000000f,   // 10107: sin(55.5194092)
   0.8243722867225512500000000000f,   // 10108: sin(55.5249023)
   0.8244265521055963400000000000f,   // 10109: sin(55.5303955)
   0.8244808099106895000000000000f,   // 10110: sin(55.5358887)
   0.8245350601373320200000000000f,   // 10111: sin(55.5413818)
   0.8245893027850252900000000000f,   // 10112: sin(55.5468750)
   0.8246435378532706000000000000f,   // 10113: sin(55.5523682)
   0.8246977653415694700000000000f,   // 10114: sin(55.5578613)
   0.8247519852494235000000000000f,   // 10115: sin(55.5633545)
   0.8248061975763343300000000000f,   // 10116: sin(55.5688477)
   0.8248604023218036900000000000f,   // 10117: sin(55.5743408)
   0.8249145994853330800000000000f,   // 10118: sin(55.5798340)
   0.8249687890664246800000000000f,   // 10119: sin(55.5853271)
   0.8250229710645802200000000000f,   // 10120: sin(55.5908203)
   0.8250771454793015500000000000f,   // 10121: sin(55.5963135)
   0.8251313123100909600000000000f,   // 10122: sin(55.6018066)
   0.8251854715564503900000000000f,   // 10123: sin(55.6072998)
   0.8252396232178821300000000000f,   // 10124: sin(55.6127930)
   0.8252937672938883700000000000f,   // 10125: sin(55.6182861)
   0.8253479037839713800000000000f,   // 10126: sin(55.6237793)
   0.8254020326876335700000000000f,   // 10127: sin(55.6292725)
   0.8254561540043774400000000000f,   // 10128: sin(55.6347656)
   0.8255102677337056200000000000f,   // 10129: sin(55.6402588)
   0.8255643738751204900000000000f,   // 10130: sin(55.6457520)
   0.8256184724281248100000000000f,   // 10131: sin(55.6512451)
   0.8256725633922213900000000000f,   // 10132: sin(55.6567383)
   0.8257266467669129900000000000f,   // 10133: sin(55.6622314)
   0.8257807225517024300000000000f,   // 10134: sin(55.6677246)
   0.8258347907460926700000000000f,   // 10135: sin(55.6732178)
   0.8258888513495867800000000000f,   // 10136: sin(55.6787109)
   0.8259429043616879400000000000f,   // 10137: sin(55.6842041)
   0.8259969497818989700000000000f,   // 10138: sin(55.6896973)
   0.8260509876097235100000000000f,   // 10139: sin(55.6951904)
   0.8261050178446646100000000000f,   // 10140: sin(55.7006836)
   0.8261590404862256800000000000f,   // 10141: sin(55.7061768)
   0.8262130555339101100000000000f,   // 10142: sin(55.7116699)
   0.8262670629872215200000000000f,   // 10143: sin(55.7171631)
   0.8263210628456634200000000000f,   // 10144: sin(55.7226563)
   0.8263750551087395400000000000f,   // 10145: sin(55.7281494)
   0.8264290397759533900000000000f,   // 10146: sin(55.7336426)
   0.8264830168468089200000000000f,   // 10147: sin(55.7391357)
   0.8265369863208099600000000000f,   // 10148: sin(55.7446289)
   0.8265909481974603700000000000f,   // 10149: sin(55.7501221)
   0.8266449024762642100000000000f,   // 10150: sin(55.7556152)
   0.8266988491567256500000000000f,   // 10151: sin(55.7611084)
   0.8267527882383485200000000000f,   // 10152: sin(55.7666016)
   0.8268067197206372400000000000f,   // 10153: sin(55.7720947)
   0.8268606436030960800000000000f,   // 10154: sin(55.7775879)
   0.8269145598852293300000000000f,   // 10155: sin(55.7830811)
   0.8269684685665414900000000000f,   // 10156: sin(55.7885742)
   0.8270223696465369700000000000f,   // 10157: sin(55.7940674)
   0.8270762631247202700000000000f,   // 10158: sin(55.7995605)
   0.8271301490005961200000000000f,   // 10159: sin(55.8050537)
   0.8271840272736690200000000000f,   // 10160: sin(55.8105469)
   0.8272378979434440400000000000f,   // 10161: sin(55.8160400)
   0.8272917610094258100000000000f,   // 10162: sin(55.8215332)
   0.8273456164711192600000000000f,   // 10163: sin(55.8270264)
   0.8273994643280293500000000000f,   // 10164: sin(55.8325195)
   0.8274533045796611500000000000f,   // 10165: sin(55.8380127)
   0.8275071372255198300000000000f,   // 10166: sin(55.8435059)
   0.8275609622651104400000000000f,   // 10167: sin(55.8489990)
   0.8276147796979384000000000000f,   // 10168: sin(55.8544922)
   0.8276685895235088600000000000f,   // 10169: sin(55.8599854)
   0.8277223917413272200000000000f,   // 10170: sin(55.8654785)
   0.8277761863508991100000000000f,   // 10171: sin(55.8709717)
   0.8278299733517298100000000000f,   // 10172: sin(55.8764648)
   0.8278837527433252600000000000f,   // 10173: sin(55.8819580)
   0.8279375245251908700000000000f,   // 10174: sin(55.8874512)
   0.8279912886968323600000000000f,   // 10175: sin(55.8929443)
   0.8280450452577558000000000000f,   // 10176: sin(55.8984375)
   0.8280987942074666800000000000f,   // 10177: sin(55.9039307)
   0.8281525355454714100000000000f,   // 10178: sin(55.9094238)
   0.8282062692712756100000000000f,   // 10179: sin(55.9149170)
   0.8282599953843855500000000000f,   // 10180: sin(55.9204102)
   0.8283137138843075200000000000f,   // 10181: sin(55.9259033)
   0.8283674247705474800000000000f,   // 10182: sin(55.9313965)
   0.8284211280426119200000000000f,   // 10183: sin(55.9368896)
   0.8284748237000071300000000000f,   // 10184: sin(55.9423828)
   0.8285285117422395200000000000f,   // 10185: sin(55.9478760)
   0.8285821921688157900000000000f,   // 10186: sin(55.9533691)
   0.8286358649792422400000000000f,   // 10187: sin(55.9588623)
   0.8286895301730257100000000000f,   // 10188: sin(55.9643555)
   0.8287431877496729300000000000f,   // 10189: sin(55.9698486)
   0.8287968377086906100000000000f,   // 10190: sin(55.9753418)
   0.8288504800495856100000000000f,   // 10191: sin(55.9808350)
   0.8289041147718648700000000000f,   // 10192: sin(55.9863281)
   0.8289577418750354600000000000f,   // 10193: sin(55.9918213)
   0.8290113613586044300000000000f,   // 10194: sin(55.9973145)
   0.8290649732220788400000000000f,   // 10195: sin(56.0028076)
   0.8291185774649659800000000000f,   // 10196: sin(56.0083008)
   0.8291721740867730200000000000f,   // 10197: sin(56.0137939)
   0.8292257630870075700000000000f,   // 10198: sin(56.0192871)
   0.8292793444651767000000000000f,   // 10199: sin(56.0247803)
   0.8293329182207882500000000000f,   // 10200: sin(56.0302734)
   0.8293864843533495000000000000f,   // 10201: sin(56.0357666)
   0.8294400428623681700000000000f,   // 10202: sin(56.0412598)
   0.8294935937473521000000000000f,   // 10203: sin(56.0467529)
   0.8295471370078088000000000000f,   // 10204: sin(56.0522461)
   0.8296006726432464400000000000f,   // 10205: sin(56.0577393)
   0.8296542006531726400000000000f,   // 10206: sin(56.0632324)
   0.8297077210370954500000000000f,   // 10207: sin(56.0687256)
   0.8297612337945230500000000000f,   // 10208: sin(56.0742188)
   0.8298147389249633800000000000f,   // 10209: sin(56.0797119)
   0.8298682364279248400000000000f,   // 10210: sin(56.0852051)
   0.8299217263029155000000000000f,   // 10211: sin(56.0906982)
   0.8299752085494438400000000000f,   // 10212: sin(56.0961914)
   0.8300286831670181700000000000f,   // 10213: sin(56.1016846)
   0.8300821501551469700000000000f,   // 10214: sin(56.1071777)
   0.8301356095133388700000000000f,   // 10215: sin(56.1126709)
   0.8301890612411023700000000000f,   // 10216: sin(56.1181641)
   0.8302425053379461900000000000f,   // 10217: sin(56.1236572)
   0.8302959418033790700000000000f,   // 10218: sin(56.1291504)
   0.8303493706369098300000000000f,   // 10219: sin(56.1346436)
   0.8304027918380475500000000000f,   // 10220: sin(56.1401367)
   0.8304562054063008300000000000f,   // 10221: sin(56.1456299)
   0.8305096113411790700000000000f,   // 10222: sin(56.1511230)
   0.8305630096421911000000000000f,   // 10223: sin(56.1566162)
   0.8306164003088462000000000000f,   // 10224: sin(56.1621094)
   0.8306697833406537800000000000f,   // 10225: sin(56.1676025)
   0.8307231587371228800000000000f,   // 10226: sin(56.1730957)
   0.8307765264977630100000000000f,   // 10227: sin(56.1785889)
   0.8308298866220835700000000000f,   // 10228: sin(56.1840820)
   0.8308832391095941600000000000f,   // 10229: sin(56.1895752)
   0.8309365839598044100000000000f,   // 10230: sin(56.1950684)
   0.8309899211722238100000000000f,   // 10231: sin(56.2005615)
   0.8310432507463623200000000000f,   // 10232: sin(56.2060547)
   0.8310965726817295400000000000f,   // 10233: sin(56.2115479)
   0.8311498869778354300000000000f,   // 10234: sin(56.2170410)
   0.8312031936341900400000000000f,   // 10235: sin(56.2225342)
   0.8312564926503032100000000000f,   // 10236: sin(56.2280273)
   0.8313097840256851200000000000f,   // 10237: sin(56.2335205)
   0.8313630677598459200000000000f,   // 10238: sin(56.2390137)
   0.8314163438522959000000000000f,   // 10239: sin(56.2445068)
   0.8314696123025452400000000000f,   // 10240: sin(56.2500000)
   0.8315228731101043100000000000f,   // 10241: sin(56.2554932)
   0.8315761262744836300000000000f,   // 10242: sin(56.2609863)
   0.8316293717951936900000000000f,   // 10243: sin(56.2664795)
   0.8316826096717451200000000000f,   // 10244: sin(56.2719727)
   0.8317358399036484100000000000f,   // 10245: sin(56.2774658)
   0.8317890624904144000000000000f,   // 10246: sin(56.2829590)
   0.8318422774315538100000000000f,   // 10247: sin(56.2884521)
   0.8318954847265775900000000000f,   // 10248: sin(56.2939453)
   0.8319486843749965800000000000f,   // 10249: sin(56.2994385)
   0.8320018763763218400000000000f,   // 10250: sin(56.3049316)
   0.8320550607300645200000000000f,   // 10251: sin(56.3104248)
   0.8321082374357354800000000000f,   // 10252: sin(56.3159180)
   0.8321614064928462000000000000f,   // 10253: sin(56.3214111)
   0.8322145679009079800000000000f,   // 10254: sin(56.3269043)
   0.8322677216594318600000000000f,   // 10255: sin(56.3323975)
   0.8323208677679296800000000000f,   // 10256: sin(56.3378906)
   0.8323740062259126200000000000f,   // 10257: sin(56.3433838)
   0.8324271370328922800000000000f,   // 10258: sin(56.3488770)
   0.8324802601883803900000000000f,   // 10259: sin(56.3543701)
   0.8325333756918886800000000000f,   // 10260: sin(56.3598633)
   0.8325864835429288600000000000f,   // 10261: sin(56.3653564)
   0.8326395837410127700000000000f,   // 10262: sin(56.3708496)
   0.8326926762856522400000000000f,   // 10263: sin(56.3763428)
   0.8327457611763594600000000000f,   // 10264: sin(56.3818359)
   0.8327988384126462400000000000f,   // 10265: sin(56.3873291)
   0.8328519079940249800000000000f,   // 10266: sin(56.3928223)
   0.8329049699200077300000000000f,   // 10267: sin(56.3983154)
   0.8329580241901066700000000000f,   // 10268: sin(56.4038086)
   0.8330110708038343000000000000f,   // 10269: sin(56.4093018)
   0.8330641097607028900000000000f,   // 10270: sin(56.4147949)
   0.8331171410602250500000000000f,   // 10271: sin(56.4202881)
   0.8331701647019131900000000000f,   // 10272: sin(56.4257813)
   0.8332231806852800100000000000f,   // 10273: sin(56.4312744)
   0.8332761890098382400000000000f,   // 10274: sin(56.4367676)
   0.8333291896751005000000000000f,   // 10275: sin(56.4422607)
   0.8333821826805797300000000000f,   // 10276: sin(56.4477539)
   0.8334351680257887600000000000f,   // 10277: sin(56.4532471)
   0.8334881457102407700000000000f,   // 10278: sin(56.4587402)
   0.8335411157334484700000000000f,   // 10279: sin(56.4642334)
   0.8335940780949251400000000000f,   // 10280: sin(56.4697266)
   0.8336470327941840600000000000f,   // 10281: sin(56.4752197)
   0.8336999798307382900000000000f,   // 10282: sin(56.4807129)
   0.8337529192041013300000000000f,   // 10283: sin(56.4862061)
   0.8338058509137863400000000000f,   // 10284: sin(56.4916992)
   0.8338587749593069400000000000f,   // 10285: sin(56.4971924)
   0.8339116913401767300000000000f,   // 10286: sin(56.5026855)
   0.8339646000559092200000000000f,   // 10287: sin(56.5081787)
   0.8340175011060181300000000000f,   // 10288: sin(56.5136719)
   0.8340703944900170800000000000f,   // 10289: sin(56.5191650)
   0.8341232802074199900000000000f,   // 10290: sin(56.5246582)
   0.8341761582577408300000000000f,   // 10291: sin(56.5301514)
   0.8342290286404934200000000000f,   // 10292: sin(56.5356445)
   0.8342818913551918200000000000f,   // 10293: sin(56.5411377)
   0.8343347464013500800000000000f,   // 10294: sin(56.5466309)
   0.8343875937784824800000000000f,   // 10295: sin(56.5521240)
   0.8344404334861031900000000000f,   // 10296: sin(56.5576172)
   0.8344932655237264900000000000f,   // 10297: sin(56.5631104)
   0.8345460898908667600000000000f,   // 10298: sin(56.5686035)
   0.8345989065870386100000000000f,   // 10299: sin(56.5740967)
   0.8346517156117563300000000000f,   // 10300: sin(56.5795898)
   0.8347045169645346300000000000f,   // 10301: sin(56.5850830)
   0.8347573106448882300000000000f,   // 10302: sin(56.5905762)
   0.8348100966523317500000000000f,   // 10303: sin(56.5960693)
   0.8348628749863800100000000000f,   // 10304: sin(56.6015625)
   0.8349156456465479700000000000f,   // 10305: sin(56.6070557)
   0.8349684086323504500000000000f,   // 10306: sin(56.6125488)
   0.8350211639433025000000000000f,   // 10307: sin(56.6180420)
   0.8350739115789193000000000000f,   // 10308: sin(56.6235352)
   0.8351266515387159000000000000f,   // 10309: sin(56.6290283)
   0.8351793838222075800000000000f,   // 10310: sin(56.6345215)
   0.8352321084289096000000000000f,   // 10311: sin(56.6400146)
   0.8352848253583373700000000000f,   // 10312: sin(56.6455078)
   0.8353375346100062600000000000f,   // 10313: sin(56.6510010)
   0.8353902361834317800000000000f,   // 10314: sin(56.6564941)
   0.8354429300781296400000000000f,   // 10315: sin(56.6619873)
   0.8354956162936153500000000000f,   // 10316: sin(56.6674805)
   0.8355482948294047400000000000f,   // 10317: sin(56.6729736)
   0.8356009656850134100000000000f,   // 10318: sin(56.6784668)
   0.8356536288599573100000000000f,   // 10319: sin(56.6839600)
   0.8357062843537526000000000000f,   // 10320: sin(56.6894531)
   0.8357589321659149000000000000f,   // 10321: sin(56.6949463)
   0.8358115722959605900000000000f,   // 10322: sin(56.7004395)
   0.8358642047434056100000000000f,   // 10323: sin(56.7059326)
   0.8359168295077663600000000000f,   // 10324: sin(56.7114258)
   0.8359694465885589800000000000f,   // 10325: sin(56.7169189)
   0.8360220559852998800000000000f,   // 10326: sin(56.7224121)
   0.8360746576975054400000000000f,   // 10327: sin(56.7279053)
   0.8361272517246921600000000000f,   // 10328: sin(56.7333984)
   0.8361798380663766400000000000f,   // 10329: sin(56.7388916)
   0.8362324167220756000000000000f,   // 10330: sin(56.7443848)
   0.8362849876913056600000000000f,   // 10331: sin(56.7498779)
   0.8363375509735835300000000000f,   // 10332: sin(56.7553711)
   0.8363901065684261600000000000f,   // 10333: sin(56.7608643)
   0.8364426544753503800000000000f,   // 10334: sin(56.7663574)
   0.8364951946938733500000000000f,   // 10335: sin(56.7718506)
   0.8365477272235118900000000000f,   // 10336: sin(56.7773438)
   0.8366002520637834100000000000f,   // 10337: sin(56.7828369)
   0.8366527692142049500000000000f,   // 10338: sin(56.7883301)
   0.8367052786742937800000000000f,   // 10339: sin(56.7938232)
   0.8367577804435671900000000000f,   // 10340: sin(56.7993164)
   0.8368102745215427700000000000f,   // 10341: sin(56.8048096)
   0.8368627609077378100000000000f,   // 10342: sin(56.8103027)
   0.8369152396016700200000000000f,   // 10343: sin(56.8157959)
   0.8369677106028570200000000000f,   // 10344: sin(56.8212891)
   0.8370201739108164000000000000f,   // 10345: sin(56.8267822)
   0.8370726295250660000000000000f,   // 10346: sin(56.8322754)
   0.8371250774451236600000000000f,   // 10347: sin(56.8377686)
   0.8371775176705071900000000000f,   // 10348: sin(56.8432617)
   0.8372299502007347600000000000f,   // 10349: sin(56.8487549)
   0.8372823750353243200000000000f,   // 10350: sin(56.8542480)
   0.8373347921737939200000000000f,   // 10351: sin(56.8597412)
   0.8373872016156619400000000000f,   // 10352: sin(56.8652344)
   0.8374396033604464300000000000f,   // 10353: sin(56.8707275)
   0.8374919974076658900000000000f,   // 10354: sin(56.8762207)
   0.8375443837568384800000000000f,   // 10355: sin(56.8817139)
   0.8375967624074830400000000000f,   // 10356: sin(56.8872070)
   0.8376491333591178400000000000f,   // 10357: sin(56.8927002)
   0.8377014966112617000000000000f,   // 10358: sin(56.8981934)
   0.8377538521634331200000000000f,   // 10359: sin(56.9036865)
   0.8378062000151509400000000000f,   // 10360: sin(56.9091797)
   0.8378585401659339700000000000f,   // 10361: sin(56.9146729)
   0.8379108726153010600000000000f,   // 10362: sin(56.9201660)
   0.8379631973627713600000000000f,   // 10363: sin(56.9256592)
   0.8380155144078637000000000000f,   // 10364: sin(56.9311523)
   0.8380678237500973600000000000f,   // 10365: sin(56.9366455)
   0.8381201253889915000000000000f,   // 10366: sin(56.9421387)
   0.8381724193240652800000000000f,   // 10367: sin(56.9476318)
   0.8382247055548379700000000000f,   // 10368: sin(56.9531250)
   0.8382769840808291800000000000f,   // 10369: sin(56.9586182)
   0.8383292549015583000000000000f,   // 10370: sin(56.9641113)
   0.8383815180165448100000000000f,   // 10371: sin(56.9696045)
   0.8384337734253083400000000000f,   // 10372: sin(56.9750977)
   0.8384860211273684700000000000f,   // 10373: sin(56.9805908)
   0.8385382611222451700000000000f,   // 10374: sin(56.9860840)
   0.8385904934094581300000000000f,   // 10375: sin(56.9915771)
   0.8386427179885273000000000000f,   // 10376: sin(56.9970703)
   0.8386949348589725100000000000f,   // 10377: sin(57.0025635)
   0.8387471440203139200000000000f,   // 10378: sin(57.0080566)
   0.8387993454720715800000000000f,   // 10379: sin(57.0135498)
   0.8388515392137657600000000000f,   // 10380: sin(57.0190430)
   0.8389037252449165200000000000f,   // 10381: sin(57.0245361)
   0.8389559035650443500000000000f,   // 10382: sin(57.0300293)
   0.8390080741736696300000000000f,   // 10383: sin(57.0355225)
   0.8390602370703126300000000000f,   // 10384: sin(57.0410156)
   0.8391123922544940800000000000f,   // 10385: sin(57.0465088)
   0.8391645397257345700000000000f,   // 10386: sin(57.0520020)
   0.8392166794835547200000000000f,   // 10387: sin(57.0574951)
   0.8392688115274752300000000000f,   // 10388: sin(57.0629883)
   0.8393209358570169500000000000f,   // 10389: sin(57.0684814)
   0.8393730524717006900000000000f,   // 10390: sin(57.0739746)
   0.8394251613710476100000000000f,   // 10391: sin(57.0794678)
   0.8394772625545785500000000000f,   // 10392: sin(57.0849609)
   0.8395293560218146700000000000f,   // 10393: sin(57.0904541)
   0.8395814417722771200000000000f,   // 10394: sin(57.0959473)
   0.8396335198054871700000000000f,   // 10395: sin(57.1014404)
   0.8396855901209661100000000000f,   // 10396: sin(57.1069336)
   0.8397376527182353100000000000f,   // 10397: sin(57.1124268)
   0.8397897075968162600000000000f,   // 10398: sin(57.1179199)
   0.8398417547562304600000000000f,   // 10399: sin(57.1234131)
   0.8398937941959994100000000000f,   // 10400: sin(57.1289063)
   0.8399458259156450400000000000f,   // 10401: sin(57.1343994)
   0.8399978499146887300000000000f,   // 10402: sin(57.1398926)
   0.8400498661926526500000000000f,   // 10403: sin(57.1453857)
   0.8401018747490584000000000000f,   // 10404: sin(57.1508789)
   0.8401538755834280200000000000f,   // 10405: sin(57.1563721)
   0.8402058686952835800000000000f,   // 10406: sin(57.1618652)
   0.8402578540841469900000000000f,   // 10407: sin(57.1673584)
   0.8403098317495407700000000000f,   // 10408: sin(57.1728516)
   0.8403618016909867300000000000f,   // 10409: sin(57.1783447)
   0.8404137639080074800000000000f,   // 10410: sin(57.1838379)
   0.8404657184001251800000000000f,   // 10411: sin(57.1893311)
   0.8405176651668624400000000000f,   // 10412: sin(57.1948242)
   0.8405696042077418500000000000f,   // 10413: sin(57.2003174)
   0.8406215355222856900000000000f,   // 10414: sin(57.2058105)
   0.8406734591100169000000000000f,   // 10415: sin(57.2113037)
   0.8407253749704580700000000000f,   // 10416: sin(57.2167969)
   0.8407772831031319300000000000f,   // 10417: sin(57.2222900)
   0.8408291835075616400000000000f,   // 10418: sin(57.2277832)
   0.8408810761832697900000000000f,   // 10419: sin(57.2332764)
   0.8409329611297796700000000000f,   // 10420: sin(57.2387695)
   0.8409848383466141900000000000f,   // 10421: sin(57.2442627)
   0.8410367078332966500000000000f,   // 10422: sin(57.2497559)
   0.8410885695893501900000000000f,   // 10423: sin(57.2552490)
   0.8411404236142980800000000000f,   // 10424: sin(57.2607422)
   0.8411922699076637100000000000f,   // 10425: sin(57.2662354)
   0.8412441084689705800000000000f,   // 10426: sin(57.2717285)
   0.8412959392977421600000000000f,   // 10427: sin(57.2772217)
   0.8413477623935019500000000000f,   // 10428: sin(57.2827148)
   0.8413995777557737900000000000f,   // 10429: sin(57.2882080)
   0.8414513853840812600000000000f,   // 10430: sin(57.2937012)
   0.8415031852779482100000000000f,   // 10431: sin(57.2991943)
   0.8415549774368983300000000000f,   // 10432: sin(57.3046875)
   0.8416067618604559100000000000f,   // 10433: sin(57.3101807)
   0.8416585385481447600000000000f,   // 10434: sin(57.3156738)
   0.8417103074994888300000000000f,   // 10435: sin(57.3211670)
   0.8417620687140124900000000000f,   // 10436: sin(57.3266602)
   0.8418138221912399000000000000f,   // 10437: sin(57.3321533)
   0.8418655679306953400000000000f,   // 10438: sin(57.3376465)
   0.8419173059319030600000000000f,   // 10439: sin(57.3431396)
   0.8419690361943876800000000000f,   // 10440: sin(57.3486328)
   0.8420207587176736800000000000f,   // 10441: sin(57.3541260)
   0.8420724735012854500000000000f,   // 10442: sin(57.3596191)
   0.8421241805447479100000000000f,   // 10443: sin(57.3651123)
   0.8421758798475855700000000000f,   // 10444: sin(57.3706055)
   0.8422275714093232500000000000f,   // 10445: sin(57.3760986)
   0.8422792552294858800000000000f,   // 10446: sin(57.3815918)
   0.8423309313075985100000000000f,   // 10447: sin(57.3870850)
   0.8423825996431859600000000000f,   // 10448: sin(57.3925781)
   0.8424342602357731700000000000f,   // 10449: sin(57.3980713)
   0.8424859130848856300000000000f,   // 10450: sin(57.4035645)
   0.8425375581900483900000000000f,   // 10451: sin(57.4090576)
   0.8425891955507866000000000000f,   // 10452: sin(57.4145508)
   0.8426408251666258600000000000f,   // 10453: sin(57.4200439)
   0.8426924470370915600000000000f,   // 10454: sin(57.4255371)
   0.8427440611617090800000000000f,   // 10455: sin(57.4310303)
   0.8427956675400041200000000000f,   // 10456: sin(57.4365234)
   0.8428472661715023000000000000f,   // 10457: sin(57.4420166)
   0.8428988570557293100000000000f,   // 10458: sin(57.4475098)
   0.8429504401922107700000000000f,   // 10459: sin(57.4530029)
   0.8430020155804728300000000000f,   // 10460: sin(57.4584961)
   0.8430535832200413100000000000f,   // 10461: sin(57.4639893)
   0.8431051431104420500000000000f,   // 10462: sin(57.4694824)
   0.8431566952512014000000000000f,   // 10463: sin(57.4749756)
   0.8432082396418454400000000000f,   // 10464: sin(57.4804688)
   0.8432597762819003000000000000f,   // 10465: sin(57.4859619)
   0.8433113051708920300000000000f,   // 10466: sin(57.4914551)
   0.8433628263083474700000000000f,   // 10467: sin(57.4969482)
   0.8434143396937927600000000000f,   // 10468: sin(57.5024414)
   0.8434658453267543900000000000f,   // 10469: sin(57.5079346)
   0.8435173432067590800000000000f,   // 10470: sin(57.5134277)
   0.8435688333333334300000000000f,   // 10471: sin(57.5189209)
   0.8436203157060040400000000000f,   // 10472: sin(57.5244141)
   0.8436717903242978400000000000f,   // 10473: sin(57.5299072)
   0.8437232571877415500000000000f,   // 10474: sin(57.5354004)
   0.8437747162958622000000000000f,   // 10475: sin(57.5408936)
   0.8438261676481867400000000000f,   // 10476: sin(57.5463867)
   0.8438776112442422100000000000f,   // 10477: sin(57.5518799)
   0.8439290470835558700000000000f,   // 10478: sin(57.5573730)
   0.8439804751656547800000000000f,   // 10479: sin(57.5628662)
   0.8440318954900664100000000000f,   // 10480: sin(57.5683594)
   0.8440833080563179300000000000f,   // 10481: sin(57.5738525)
   0.8441347128639369300000000000f,   // 10482: sin(57.5793457)
   0.8441861099124506900000000000f,   // 10483: sin(57.5848389)
   0.8442374992013870200000000000f,   // 10484: sin(57.5903320)
   0.8442888807302734200000000000f,   // 10485: sin(57.5958252)
   0.8443402544986375900000000000f,   // 10486: sin(57.6013184)
   0.8443916205060073600000000000f,   // 10487: sin(57.6068115)
   0.8444429787519106600000000000f,   // 10488: sin(57.6123047)
   0.8444943292358752000000000000f,   // 10489: sin(57.6177979)
   0.8445456719574292400000000000f,   // 10490: sin(57.6232910)
   0.8445970069161007300000000000f,   // 10491: sin(57.6287842)
   0.8446483341114178200000000000f,   // 10492: sin(57.6342773)
   0.8446996535429085500000000000f,   // 10493: sin(57.6397705)
   0.8447509652101015100000000000f,   // 10494: sin(57.6452637)
   0.8448022691125248700000000000f,   // 10495: sin(57.6507568)
   0.8448535652497070100000000000f,   // 10496: sin(57.6562500)
   0.8449048536211766200000000000f,   // 10497: sin(57.6617432)
   0.8449561342264621000000000000f,   // 10498: sin(57.6672363)
   0.8450074070650920300000000000f,   // 10499: sin(57.6727295)
   0.8450586721365954700000000000f,   // 10500: sin(57.6782227)
   0.8451099294405009000000000000f,   // 10501: sin(57.6837158)
   0.8451611789763371400000000000f,   // 10502: sin(57.6892090)
   0.8452124207436332300000000000f,   // 10503: sin(57.6947021)
   0.8452636547419182200000000000f,   // 10504: sin(57.7001953)
   0.8453148809707211600000000000f,   // 10505: sin(57.7056885)
   0.8453660994295709700000000000f,   // 10506: sin(57.7111816)
   0.8454173101179971500000000000f,   // 10507: sin(57.7166748)
   0.8454685130355288300000000000f,   // 10508: sin(57.7221680)
   0.8455197081816954200000000000f,   // 10509: sin(57.7276611)
   0.8455708955560262700000000000f,   // 10510: sin(57.7331543)
   0.8456220751580509900000000000f,   // 10511: sin(57.7386475)
   0.8456732469872990700000000000f,   // 10512: sin(57.7441406)
   0.8457244110433000900000000000f,   // 10513: sin(57.7496338)
   0.8457755673255839000000000000f,   // 10514: sin(57.7551270)
   0.8458267158336803000000000000f,   // 10515: sin(57.7606201)
   0.8458778565671188900000000000f,   // 10516: sin(57.7661133)
   0.8459289895254299400000000000f,   // 10517: sin(57.7716064)
   0.8459801147081432700000000000f,   // 10518: sin(57.7770996)
   0.8460312321147889200000000000f,   // 10519: sin(57.7825928)
   0.8460823417448969400000000000f,   // 10520: sin(57.7880859)
   0.8461334435979978000000000000f,   // 10521: sin(57.7935791)
   0.8461845376736216700000000000f,   // 10522: sin(57.7990723)
   0.8462356239712987000000000000f,   // 10523: sin(57.8045654)
   0.8462867024905597100000000000f,   // 10524: sin(57.8100586)
   0.8463377732309348400000000000f,   // 10525: sin(57.8155518)
   0.8463888361919549300000000000f,   // 10526: sin(57.8210449)
   0.8464398913731503400000000000f,   // 10527: sin(57.8265381)
   0.8464909387740520200000000000f,   // 10528: sin(57.8320313)
   0.8465419783941907600000000000f,   // 10529: sin(57.8375244)
   0.8465930102330971900000000000f,   // 10530: sin(57.8430176)
   0.8466440342903024400000000000f,   // 10531: sin(57.8485107)
   0.8466950505653374500000000000f,   // 10532: sin(57.8540039)
   0.8467460590577331500000000000f,   // 10533: sin(57.8594971)
   0.8467970597670209100000000000f,   // 10534: sin(57.8649902)
   0.8468480526927318900000000000f,   // 10535: sin(57.8704834)
   0.8468990378343973500000000000f,   // 10536: sin(57.8759766)
   0.8469500151915484400000000000f,   // 10537: sin(57.8814697)
   0.8470009847637168800000000000f,   // 10538: sin(57.8869629)
   0.8470519465504340300000000000f,   // 10539: sin(57.8924561)
   0.8471029005512315000000000000f,   // 10540: sin(57.8979492)
   0.8471538467656408700000000000f,   // 10541: sin(57.9034424)
   0.8472047851931939800000000000f,   // 10542: sin(57.9089355)
   0.8472557158334225200000000000f,   // 10543: sin(57.9144287)
   0.8473066386858583200000000000f,   // 10544: sin(57.9199219)
   0.8473575537500334100000000000f,   // 10545: sin(57.9254150)
   0.8474084610254797300000000000f,   // 10546: sin(57.9309082)
   0.8474593605117292100000000000f,   // 10547: sin(57.9364014)
   0.8475102522083143300000000000f,   // 10548: sin(57.9418945)
   0.8475611361147670200000000000f,   // 10549: sin(57.9473877)
   0.8476120122306196600000000000f,   // 10550: sin(57.9528809)
   0.8476628805554046200000000000f,   // 10551: sin(57.9583740)
   0.8477137410886542700000000000f,   // 10552: sin(57.9638672)
   0.8477645938299012100000000000f,   // 10553: sin(57.9693604)
   0.8478154387786779300000000000f,   // 10554: sin(57.9748535)
   0.8478662759345171300000000000f,   // 10555: sin(57.9803467)
   0.8479171052969514100000000000f,   // 10556: sin(57.9858398)
   0.8479679268655137000000000000f,   // 10557: sin(57.9913330)
   0.8480187406397368100000000000f,   // 10558: sin(57.9968262)
   0.8480695466191536800000000000f,   // 10559: sin(58.0023193)
   0.8481203448032971200000000000f,   // 10560: sin(58.0078125)
   0.8481711351917006200000000000f,   // 10561: sin(58.0133057)
   0.8482219177838969900000000000f,   // 10562: sin(58.0187988)
   0.8482726925794196200000000000f,   // 10563: sin(58.0242920)
   0.8483234595778015300000000000f,   // 10564: sin(58.0297852)
   0.8483742187785764400000000000f,   // 10565: sin(58.0352783)
   0.8484249701812776000000000000f,   // 10566: sin(58.0407715)
   0.8484757137854384000000000000f,   // 10567: sin(58.0462646)
   0.8485264495905926500000000000f,   // 10568: sin(58.0517578)
   0.8485771775962739300000000000f,   // 10569: sin(58.0572510)
   0.8486278978020158600000000000f,   // 10570: sin(58.0627441)
   0.8486786102073522500000000000f,   // 10571: sin(58.0682373)
   0.8487293148118170100000000000f,   // 10572: sin(58.0737305)
   0.8487800116149442100000000000f,   // 10573: sin(58.0792236)
   0.8488307006162675300000000000f,   // 10574: sin(58.0847168)
   0.8488813818153212500000000000f,   // 10575: sin(58.0902100)
   0.8489320552116396100000000000f,   // 10576: sin(58.0957031)
   0.8489827208047565600000000000f,   // 10577: sin(58.1011963)
   0.8490333785942066900000000000f,   // 10578: sin(58.1066895)
   0.8490840285795242500000000000f,   // 10579: sin(58.1121826)
   0.8491346707602436300000000000f,   // 10580: sin(58.1176758)
   0.8491853051358992900000000000f,   // 10581: sin(58.1231689)
   0.8492359317060259600000000000f,   // 10582: sin(58.1286621)
   0.8492865504701582200000000000f,   // 10583: sin(58.1341553)
   0.8493371614278306700000000000f,   // 10584: sin(58.1396484)
   0.8493877645785783400000000000f,   // 10585: sin(58.1451416)
   0.8494383599219359500000000000f,   // 10586: sin(58.1506348)
   0.8494889474574384100000000000f,   // 10587: sin(58.1561279)
   0.8495395271846208900000000000f,   // 10588: sin(58.1616211)
   0.8495900991030183000000000000f,   // 10589: sin(58.1671143)
   0.8496406632121659100000000000f,   // 10590: sin(58.1726074)
   0.8496912195115987600000000000f,   // 10591: sin(58.1781006)
   0.8497417680008524400000000000f,   // 10592: sin(58.1835938)
   0.8497923086794622000000000000f,   // 10593: sin(58.1890869)
   0.8498428415469632100000000000f,   // 10594: sin(58.1945801)
   0.8498933666028915000000000000f,   // 10595: sin(58.2000732)
   0.8499438838467822100000000000f,   // 10596: sin(58.2055664)
   0.8499943932781712800000000000f,   // 10597: sin(58.2110596)
   0.8500448948965940700000000000f,   // 10598: sin(58.2165527)
   0.8500953887015868500000000000f,   // 10599: sin(58.2220459)
   0.8501458746926852100000000000f,   // 10600: sin(58.2275391)
   0.8501963528694250800000000000f,   // 10601: sin(58.2330322)
   0.8502468232313427100000000000f,   // 10602: sin(58.2385254)
   0.8502972857779739200000000000f,   // 10603: sin(58.2440186)
   0.8503477405088549800000000000f,   // 10604: sin(58.2495117)
   0.8503981874235221300000000000f,   // 10605: sin(58.2550049)
   0.8504486265215116500000000000f,   // 10606: sin(58.2604980)
   0.8504990578023600100000000000f,   // 10607: sin(58.2659912)
   0.8505494812656033700000000000f,   // 10608: sin(58.2714844)
   0.8505998969107786400000000000f,   // 10609: sin(58.2769775)
   0.8506503047374222000000000000f,   // 10610: sin(58.2824707)
   0.8507007047450705400000000000f,   // 10611: sin(58.2879639)
   0.8507510969332607900000000000f,   // 10612: sin(58.2934570)
   0.8508014813015294400000000000f,   // 10613: sin(58.2989502)
   0.8508518578494136400000000000f,   // 10614: sin(58.3044434)
   0.8509022265764498700000000000f,   // 10615: sin(58.3099365)
   0.8509525874821757300000000000f,   // 10616: sin(58.3154297)
   0.8510029405661280200000000000f,   // 10617: sin(58.3209229)
   0.8510532858278437900000000000f,   // 10618: sin(58.3264160)
   0.8511036232668605100000000000f,   // 10619: sin(58.3319092)
   0.8511539528827153400000000000f,   // 10620: sin(58.3374023)
   0.8512042746749457500000000000f,   // 10621: sin(58.3428955)
   0.8512545886430891200000000000f,   // 10622: sin(58.3483887)
   0.8513048947866831400000000000f,   // 10623: sin(58.3538818)
   0.8513551931052652000000000000f,   // 10624: sin(58.3593750)
   0.8514054835983728700000000000f,   // 10625: sin(58.3648682)
   0.8514557662655443100000000000f,   // 10626: sin(58.3703613)
   0.8515060411063170000000000000f,   // 10627: sin(58.3758545)
   0.8515563081202288700000000000f,   // 10628: sin(58.3813477)
   0.8516065673068180500000000000f,   // 10629: sin(58.3868408)
   0.8516568186656223700000000000f,   // 10630: sin(58.3923340)
   0.8517070621961799800000000000f,   // 10631: sin(58.3978271)
   0.8517572978980291200000000000f,   // 10632: sin(58.4033203)
   0.8518075257707079500000000000f,   // 10633: sin(58.4088135)
   0.8518577458137548400000000000f,   // 10634: sin(58.4143066)
   0.8519079580267081600000000000f,   // 10635: sin(58.4197998)
   0.8519581624091063800000000000f,   // 10636: sin(58.4252930)
   0.8520083589604879900000000000f,   // 10637: sin(58.4307861)
   0.8520585476803915800000000000f,   // 10638: sin(58.4362793)
   0.8521087285683559600000000000f,   // 10639: sin(58.4417725)
   0.8521589016239198300000000000f,   // 10640: sin(58.4472656)
   0.8522090668466219000000000000f,   // 10641: sin(58.4527588)
   0.8522592242360010900000000000f,   // 10642: sin(58.4582520)
   0.8523093737915964400000000000f,   // 10643: sin(58.4637451)
   0.8523595155129470900000000000f,   // 10644: sin(58.4692383)
   0.8524096493995917400000000000f,   // 10645: sin(58.4747314)
   0.8524597754510701000000000000f,   // 10646: sin(58.4802246)
   0.8525098936669210900000000000f,   // 10647: sin(58.4857178)
   0.8525600040466839700000000000f,   // 10648: sin(58.4912109)
   0.8526101065898984400000000000f,   // 10649: sin(58.4967041)
   0.8526602012961037600000000000f,   // 10650: sin(58.5021973)
   0.8527102881648395100000000000f,   // 10651: sin(58.5076904)
   0.8527603671956453000000000000f,   // 10652: sin(58.5131836)
   0.8528104383880608100000000000f,   // 10653: sin(58.5186768)
   0.8528605017416258600000000000f,   // 10654: sin(58.5241699)
   0.8529105572558800500000000000f,   // 10655: sin(58.5296631)
   0.8529606049303636300000000000f,   // 10656: sin(58.5351563)
   0.8530106447646164100000000000f,   // 10657: sin(58.5406494)
   0.8530606767581783200000000000f,   // 10658: sin(58.5461426)
   0.8531107009105896000000000000f,   // 10659: sin(58.5516357)
   0.8531607172213904200000000000f,   // 10660: sin(58.5571289)
   0.8532107256901211300000000000f,   // 10661: sin(58.5626221)
   0.8532607263163217700000000000f,   // 10662: sin(58.5681152)
   0.8533107190995330400000000000f,   // 10663: sin(58.5736084)
   0.8533607040392954300000000000f,   // 10664: sin(58.5791016)
   0.8534106811351491700000000000f,   // 10665: sin(58.5845947)
   0.8534606503866353200000000000f,   // 10666: sin(58.5900879)
   0.8535106117932942400000000000f,   // 10667: sin(58.5955811)
   0.8535605653546668400000000000f,   // 10668: sin(58.6010742)
   0.8536105110702938400000000000f,   // 10669: sin(58.6065674)
   0.8536604489397162700000000000f,   // 10670: sin(58.6120605)
   0.8537103789624751500000000000f,   // 10671: sin(58.6175537)
   0.8537603011381113000000000000f,   // 10672: sin(58.6230469)
   0.8538102154661660900000000000f,   // 10673: sin(58.6285400)
   0.8538601219461806600000000000f,   // 10674: sin(58.6340332)
   0.8539100205776961600000000000f,   // 10675: sin(58.6395264)
   0.8539599113602540600000000000f,   // 10676: sin(58.6450195)
   0.8540097942933958500000000000f,   // 10677: sin(58.6505127)
   0.8540596693766627800000000000f,   // 10678: sin(58.6560059)
   0.8541095366095965400000000000f,   // 10679: sin(58.6614990)
   0.8541593959917387300000000000f,   // 10680: sin(58.6669922)
   0.8542092475226311700000000000f,   // 10681: sin(58.6724854)
   0.8542590912018154200000000000f,   // 10682: sin(58.6779785)
   0.8543089270288335400000000000f,   // 10683: sin(58.6834717)
   0.8543587550032274400000000000f,   // 10684: sin(58.6889648)
   0.8544085751245389400000000000f,   // 10685: sin(58.6944580)
   0.8544583873923100600000000000f,   // 10686: sin(58.6999512)
   0.8545081918060832800000000000f,   // 10687: sin(58.7054443)
   0.8545579883654005300000000000f,   // 10688: sin(58.7109375)
   0.8546077770698040600000000000f,   // 10689: sin(58.7164307)
   0.8546575579188364600000000000f,   // 10690: sin(58.7219238)
   0.8547073309120399900000000000f,   // 10691: sin(58.7274170)
   0.8547570960489571100000000000f,   // 10692: sin(58.7329102)
   0.8548068533291305300000000000f,   // 10693: sin(58.7384033)
   0.8548566027521028500000000000f,   // 10694: sin(58.7438965)
   0.8549063443174167400000000000f,   // 10695: sin(58.7493896)
   0.8549560780246148200000000000f,   // 10696: sin(58.7548828)
   0.8550058038732403200000000000f,   // 10697: sin(58.7603760)
   0.8550555218628359500000000000f,   // 10698: sin(58.7658691)
   0.8551052319929446400000000000f,   // 10699: sin(58.7713623)
   0.8551549342631096200000000000f,   // 10700: sin(58.7768555)
   0.8552046286728740600000000000f,   // 10701: sin(58.7823486)
   0.8552543152217810800000000000f,   // 10702: sin(58.7878418)
   0.8553039939093738400000000000f,   // 10703: sin(58.7933350)
   0.8553536647351960300000000000f,   // 10704: sin(58.7988281)
   0.8554033276987909100000000000f,   // 10705: sin(58.8043213)
   0.8554529827997018300000000000f,   // 10706: sin(58.8098145)
   0.8555026300374726200000000000f,   // 10707: sin(58.8153076)
   0.8555522694116469700000000000f,   // 10708: sin(58.8208008)
   0.8556019009217682400000000000f,   // 10709: sin(58.8262939)
   0.8556515245673806900000000000f,   // 10710: sin(58.8317871)
   0.8557011403480279100000000000f,   // 10711: sin(58.8372803)
   0.8557507482632539200000000000f,   // 10712: sin(58.8427734)
   0.8558003483126025400000000000f,   // 10713: sin(58.8482666)
   0.8558499404956182400000000000f,   // 10714: sin(58.8537598)
   0.8558995248118449500000000000f,   // 10715: sin(58.8592529)
   0.8559491012608267900000000000f,   // 10716: sin(58.8647461)
   0.8559986698421083700000000000f,   // 10717: sin(58.8702393)
   0.8560482305552338200000000000f,   // 10718: sin(58.8757324)
   0.8560977833997476200000000000f,   // 10719: sin(58.8812256)
   0.8561473283751944700000000000f,   // 10720: sin(58.8867188)
   0.8561968654811187300000000000f,   // 10721: sin(58.8922119)
   0.8562463947170652100000000000f,   // 10722: sin(58.8977051)
   0.8562959160825784900000000000f,   // 10723: sin(58.9031982)
   0.8563454295772036100000000000f,   // 10724: sin(58.9086914)
   0.8563949352004853700000000000f,   // 10725: sin(58.9141846)
   0.8564444329519684800000000000f,   // 10726: sin(58.9196777)
   0.8564939228311984100000000000f,   // 10727: sin(58.9251709)
   0.8565434048377199600000000000f,   // 10728: sin(58.9306641)
   0.8565928789710783900000000000f,   // 10729: sin(58.9361572)
   0.8566423452308187200000000000f,   // 10730: sin(58.9416504)
   0.8566918036164866700000000000f,   // 10731: sin(58.9471436)
   0.8567412541276274700000000000f,   // 10732: sin(58.9526367)
   0.8567906967637863900000000000f,   // 10733: sin(58.9581299)
   0.8568401315245092200000000000f,   // 10734: sin(58.9636230)
   0.8568895584093414500000000000f,   // 10735: sin(58.9691162)
   0.8569389774178286500000000000f,   // 10736: sin(58.9746094)
   0.8569883885495168700000000000f,   // 10737: sin(58.9801025)
   0.8570377918039516800000000000f,   // 10738: sin(58.9855957)
   0.8570871871806790000000000000f,   // 10739: sin(58.9910889)
   0.8571365746792448700000000000f,   // 10740: sin(58.9965820)
   0.8571859542991953100000000000f,   // 10741: sin(59.0020752)
   0.8572353260400764600000000000f,   // 10742: sin(59.0075684)
   0.8572846899014344700000000000f,   // 10743: sin(59.0130615)
   0.8573340458828155900000000000f,   // 10744: sin(59.0185547)
   0.8573833939837661700000000000f,   // 10745: sin(59.0240479)
   0.8574327342038327000000000000f,   // 10746: sin(59.0295410)
   0.8574820665425614300000000000f,   // 10747: sin(59.0350342)
   0.8575313909994990400000000000f,   // 10748: sin(59.0405273)
   0.8575807075741922500000000000f,   // 10749: sin(59.0460205)
   0.8576300162661876200000000000f,   // 10750: sin(59.0515137)
   0.8576793170750319800000000000f,   // 10751: sin(59.0570068)
   0.8577286100002721200000000000f,   // 10752: sin(59.0625000)
   0.8577778950414548500000000000f,   // 10753: sin(59.0679932)
   0.8578271721981273200000000000f,   // 10754: sin(59.0734863)
   0.8578764414698366600000000000f,   // 10755: sin(59.0789795)
   0.8579257028561297900000000000f,   // 10756: sin(59.0844727)
   0.8579749563565539600000000000f,   // 10757: sin(59.0899658)
   0.8580242019706565400000000000f,   // 10758: sin(59.0954590)
   0.8580734396979847700000000000f,   // 10759: sin(59.1009521)
   0.8581226695380860200000000000f,   // 10760: sin(59.1064453)
   0.8581718914905081000000000000f,   // 10761: sin(59.1119385)
   0.8582211055547982500000000000f,   // 10762: sin(59.1174316)
   0.8582703117305041700000000000f,   // 10763: sin(59.1229248)
   0.8583195100171734400000000000f,   // 10764: sin(59.1284180)
   0.8583687004143542000000000000f,   // 10765: sin(59.1339111)
   0.8584178829215940400000000000f,   // 10766: sin(59.1394043)
   0.8584670575384407700000000000f,   // 10767: sin(59.1448975)
   0.8585162242644427400000000000f,   // 10768: sin(59.1503906)
   0.8585653830991478700000000000f,   // 10769: sin(59.1558838)
   0.8586145340421040800000000000f,   // 10770: sin(59.1613770)
   0.8586636770928599600000000000f,   // 10771: sin(59.1668701)
   0.8587128122509635200000000000f,   // 10772: sin(59.1723633)
   0.8587619395159632500000000000f,   // 10773: sin(59.1778564)
   0.8588110588874075000000000000f,   // 10774: sin(59.1833496)
   0.8588601703648448500000000000f,   // 10775: sin(59.1888428)
   0.8589092739478239000000000000f,   // 10776: sin(59.1943359)
   0.8589583696358931200000000000f,   // 10777: sin(59.1998291)
   0.8590074574286014100000000000f,   // 10778: sin(59.2053223)
   0.8590565373254975800000000000f,   // 10779: sin(59.2108154)
   0.8591056093261303400000000000f,   // 10780: sin(59.2163086)
   0.8591546734300488100000000000f,   // 10781: sin(59.2218018)
   0.8592037296368019200000000000f,   // 10782: sin(59.2272949)
   0.8592527779459387900000000000f,   // 10783: sin(59.2327881)
   0.8593018183570083600000000000f,   // 10784: sin(59.2382812)
   0.8593508508695602000000000000f,   // 10785: sin(59.2437744)
   0.8593998754831434500000000000f,   // 10786: sin(59.2492676)
   0.8594488921973073600000000000f,   // 10787: sin(59.2547607)
   0.8594979010116016200000000000f,   // 10788: sin(59.2602539)
   0.8595469019255757000000000000f,   // 10789: sin(59.2657471)
   0.8595958949387790800000000000f,   // 10790: sin(59.2712402)
   0.8596448800507614500000000000f,   // 10791: sin(59.2767334)
   0.8596938572610726100000000000f,   // 10792: sin(59.2822266)
   0.8597428265692623800000000000f,   // 10793: sin(59.2877197)
   0.8597917879748805400000000000f,   // 10794: sin(59.2932129)
   0.8598407414774771300000000000f,   // 10795: sin(59.2987061)
   0.8598896870766022900000000000f,   // 10796: sin(59.3041992)
   0.8599386247718058300000000000f,   // 10797: sin(59.3096924)
   0.8599875545626382000000000000f,   // 10798: sin(59.3151855)
   0.8600364764486495600000000000f,   // 10799: sin(59.3206787)
   0.8600853904293901400000000000f,   // 10800: sin(59.3261719)
   0.8601342965044104200000000000f,   // 10801: sin(59.3316650)
   0.8601831946732608800000000000f,   // 10802: sin(59.3371582)
   0.8602320849354920800000000000f,   // 10803: sin(59.3426514)
   0.8602809672906545100000000000f,   // 10804: sin(59.3481445)
   0.8603298417382989600000000000f,   // 10805: sin(59.3536377)
   0.8603787082779761300000000000f,   // 10806: sin(59.3591309)
   0.8604275669092369400000000000f,   // 10807: sin(59.3646240)
   0.8604764176316320700000000000f,   // 10808: sin(59.3701172)
   0.8605252604447127800000000000f,   // 10809: sin(59.3756104)
   0.8605740953480299800000000000f,   // 10810: sin(59.3811035)
   0.8606229223411346900000000000f,   // 10811: sin(59.3865967)
   0.8606717414235783800000000000f,   // 10812: sin(59.3920898)
   0.8607205525949120900000000000f,   // 10813: sin(59.3975830)
   0.8607693558546870600000000000f,   // 10814: sin(59.4030762)
   0.8608181512024549700000000000f,   // 10815: sin(59.4085693)
   0.8608669386377673100000000000f,   // 10816: sin(59.4140625)
   0.8609157181601754200000000000f,   // 10817: sin(59.4195557)
   0.8609644897692309000000000000f,   // 10818: sin(59.4250488)
   0.8610132534644857600000000000f,   // 10819: sin(59.4305420)
   0.8610620092454914800000000000f,   // 10820: sin(59.4360352)
   0.8611107571117999600000000000f,   // 10821: sin(59.4415283)
   0.8611594970629633500000000000f,   // 10822: sin(59.4470215)
   0.8612082290985333400000000000f,   // 10823: sin(59.4525146)
   0.8612569532180620600000000000f,   // 10824: sin(59.4580078)
   0.8613056694211018700000000000f,   // 10825: sin(59.4635010)
   0.8613543777072048000000000000f,   // 10826: sin(59.4689941)
   0.8614030780759232000000000000f,   // 10827: sin(59.4744873)
   0.8614517705268092100000000000f,   // 10828: sin(59.4799805)
   0.8615004550594156400000000000f,   // 10829: sin(59.4854736)
   0.8615491316732947200000000000f,   // 10830: sin(59.4909668)
   0.8615978003679989300000000000f,   // 10831: sin(59.4964600)
   0.8616464611430813000000000000f,   // 10832: sin(59.5019531)
   0.8616951139980942900000000000f,   // 10833: sin(59.5074463)
   0.8617437589325907000000000000f,   // 10834: sin(59.5129395)
   0.8617923959461233400000000000f,   // 10835: sin(59.5184326)
   0.8618410250382453300000000000f,   // 10836: sin(59.5239258)
   0.8618896462085096100000000000f,   // 10837: sin(59.5294189)
   0.8619382594564691800000000000f,   // 10838: sin(59.5349121)
   0.8619868647816773000000000000f,   // 10839: sin(59.5404053)
   0.8620354621836872100000000000f,   // 10840: sin(59.5458984)
   0.8620840516620520400000000000f,   // 10841: sin(59.5513916)
   0.8621326332163253800000000000f,   // 10842: sin(59.5568848)
   0.8621812068460605900000000000f,   // 10843: sin(59.5623779)
   0.8622297725508112400000000000f,   // 10844: sin(59.5678711)
   0.8622783303301307900000000000f,   // 10845: sin(59.5733643)
   0.8623268801835730600000000000f,   // 10846: sin(59.5788574)
   0.8623754221106917400000000000f,   // 10847: sin(59.5843506)
   0.8624239561110405000000000000f,   // 10848: sin(59.5898437)
   0.8624724821841734900000000000f,   // 10849: sin(59.5953369)
   0.8625210003296445200000000000f,   // 10850: sin(59.6008301)
   0.8625695105470075900000000000f,   // 10851: sin(59.6063232)
   0.8626180128358167400000000000f,   // 10852: sin(59.6118164)
   0.8626665071956264300000000000f,   // 10853: sin(59.6173096)
   0.8627149936259906900000000000f,   // 10854: sin(59.6228027)
   0.8627634721264637600000000000f,   // 10855: sin(59.6282959)
   0.8628119426966003300000000000f,   // 10856: sin(59.6337891)
   0.8628604053359546500000000000f,   // 10857: sin(59.6392822)
   0.8629088600440812900000000000f,   // 10858: sin(59.6447754)
   0.8629573068205349500000000000f,   // 10859: sin(59.6502686)
   0.8630057456648702100000000000f,   // 10860: sin(59.6557617)
   0.8630541765766419600000000000f,   // 10861: sin(59.6612549)
   0.8631025995554048000000000000f,   // 10862: sin(59.6667480)
   0.8631510146007139700000000000f,   // 10863: sin(59.6722412)
   0.8631994217121241600000000000f,   // 10864: sin(59.6777344)
   0.8632478208891905000000000000f,   // 10865: sin(59.6832275)
   0.8632962121314682300000000000f,   // 10866: sin(59.6887207)
   0.8633445954385125000000000000f,   // 10867: sin(59.6942139)
   0.8633929708098783100000000000f,   // 10868: sin(59.6997070)
   0.8634413382451214800000000000f,   // 10869: sin(59.7052002)
   0.8634896977437971400000000000f,   // 10870: sin(59.7106934)
   0.8635380493054608500000000000f,   // 10871: sin(59.7161865)
   0.8635863929296679900000000000f,   // 10872: sin(59.7216797)
   0.8636347286159744600000000000f,   // 10873: sin(59.7271729)
   0.8636830563639359400000000000f,   // 10874: sin(59.7326660)
   0.8637313761731079100000000000f,   // 10875: sin(59.7381592)
   0.8637796880430466100000000000f,   // 10876: sin(59.7436523)
   0.8638279919733078400000000000f,   // 10877: sin(59.7491455)
   0.8638762879634475100000000000f,   // 10878: sin(59.7546387)
   0.8639245760130217500000000000f,   // 10879: sin(59.7601318)
   0.8639728561215867000000000000f,   // 10880: sin(59.7656250)
   0.8640211282886987000000000000f,   // 10881: sin(59.7711182)
   0.8640693925139136800000000000f,   // 10882: sin(59.7766113)
   0.8641176487967884300000000000f,   // 10883: sin(59.7821045)
   0.8641658971368793000000000000f,   // 10884: sin(59.7875977)
   0.8642141375337425400000000000f,   // 10885: sin(59.7930908)
   0.8642623699869349500000000000f,   // 10886: sin(59.7985840)
   0.8643105944960132200000000000f,   // 10887: sin(59.8040771)
   0.8643588110605340300000000000f,   // 10888: sin(59.8095703)
   0.8644070196800539600000000000f,   // 10889: sin(59.8150635)
   0.8644552203541302500000000000f,   // 10890: sin(59.8205566)
   0.8645034130823197000000000000f,   // 10891: sin(59.8260498)
   0.8645515978641792300000000000f,   // 10892: sin(59.8315430)
   0.8645997746992660800000000000f,   // 10893: sin(59.8370361)
   0.8646479435871374800000000000f,   // 10894: sin(59.8425293)
   0.8646961045273504600000000000f,   // 10895: sin(59.8480225)
   0.8647442575194623800000000000f,   // 10896: sin(59.8535156)
   0.8647924025630306900000000000f,   // 10897: sin(59.8590088)
   0.8648405396576129800000000000f,   // 10898: sin(59.8645020)
   0.8648886688027663800000000000f,   // 10899: sin(59.8699951)
   0.8649367899980490200000000000f,   // 10900: sin(59.8754883)
   0.8649849032430182400000000000f,   // 10901: sin(59.8809814)
   0.8650330085372317500000000000f,   // 10902: sin(59.8864746)
   0.8650811058802476700000000000f,   // 10903: sin(59.8919678)
   0.8651291952716236900000000000f,   // 10904: sin(59.8974609)
   0.8651772767109179300000000000f,   // 10905: sin(59.9029541)
   0.8652253501976880900000000000f,   // 10906: sin(59.9084473)
   0.8652734157314927500000000000f,   // 10907: sin(59.9139404)
   0.8653214733118898000000000000f,   // 10908: sin(59.9194336)
   0.8653695229384375000000000000f,   // 10909: sin(59.9249268)
   0.8654175646106944100000000000f,   // 10910: sin(59.9304199)
   0.8654655983282187900000000000f,   // 10911: sin(59.9359131)
   0.8655136240905689800000000000f,   // 10912: sin(59.9414062)
   0.8655616418973038900000000000f,   // 10913: sin(59.9468994)
   0.8656096517479818800000000000f,   // 10914: sin(59.9523926)
   0.8656576536421618500000000000f,   // 10915: sin(59.9578857)
   0.8657056475794022700000000000f,   // 10916: sin(59.9633789)
   0.8657536335592622700000000000f,   // 10917: sin(59.9688721)
   0.8658016115813007600000000000f,   // 10918: sin(59.9743652)
   0.8658495816450765300000000000f,   // 10919: sin(59.9798584)
   0.8658975437501488200000000000f,   // 10920: sin(59.9853516)
   0.8659454978960767800000000000f,   // 10921: sin(59.9908447)
   0.8659934440824195200000000000f,   // 10922: sin(59.9963379)
   0.8660413823087364000000000000f,   // 10923: sin(60.0018311)
   0.8660893125745867700000000000f,   // 10924: sin(60.0073242)
   0.8661372348795300900000000000f,   // 10925: sin(60.0128174)
   0.8661851492231257300000000000f,   // 10926: sin(60.0183105)
   0.8662330556049335800000000000f,   // 10927: sin(60.0238037)
   0.8662809540245129900000000000f,   // 10928: sin(60.0292969)
   0.8663288444814237800000000000f,   // 10929: sin(60.0347900)
   0.8663767269752258300000000000f,   // 10930: sin(60.0402832)
   0.8664246015054788400000000000f,   // 10931: sin(60.0457764)
   0.8664724680717430500000000000f,   // 10932: sin(60.0512695)
   0.8665203266735781500000000000f,   // 10933: sin(60.0567627)
   0.8665681773105443600000000000f,   // 10934: sin(60.0622559)
   0.8666160199822020600000000000f,   // 10935: sin(60.0677490)
   0.8666638546881110200000000000f,   // 10936: sin(60.0732422)
   0.8667116814278320600000000000f,   // 10937: sin(60.0787354)
   0.8667595002009252900000000000f,   // 10938: sin(60.0842285)
   0.8668073110069513000000000000f,   // 10939: sin(60.0897217)
   0.8668551138454703200000000000f,   // 10940: sin(60.0952148)
   0.8669029087160433600000000000f,   // 10941: sin(60.1007080)
   0.8669506956182310200000000000f,   // 10942: sin(60.1062012)
   0.8669984745515937300000000000f,   // 10943: sin(60.1116943)
   0.8670462455156926500000000000f,   // 10944: sin(60.1171875)
   0.8670940085100885500000000000f,   // 10945: sin(60.1226807)
   0.8671417635343423600000000000f,   // 10946: sin(60.1281738)
   0.8671895105880153000000000000f,   // 10947: sin(60.1336670)
   0.8672372496706684000000000000f,   // 10948: sin(60.1391602)
   0.8672849807818627800000000000f,   // 10949: sin(60.1446533)
   0.8673327039211596900000000000f,   // 10950: sin(60.1501465)
   0.8673804190881205800000000000f,   // 10951: sin(60.1556396)
   0.8674281262823069200000000000f,   // 10952: sin(60.1611328)
   0.8674758255032799500000000000f,   // 10953: sin(60.1666260)
   0.8675235167506014600000000000f,   // 10954: sin(60.1721191)
   0.8675712000238330300000000000f,   // 10955: sin(60.1776123)
   0.8676188753225362300000000000f,   // 10956: sin(60.1831055)
   0.8676665426462729600000000000f,   // 10957: sin(60.1885986)
   0.8677142019946051400000000000f,   // 10958: sin(60.1940918)
   0.8677618533670945500000000000f,   // 10959: sin(60.1995850)
   0.8678094967633032100000000000f,   // 10960: sin(60.2050781)
   0.8678571321827932600000000000f,   // 10961: sin(60.2105713)
   0.8679047596251269200000000000f,   // 10962: sin(60.2160645)
   0.8679523790898661100000000000f,   // 10963: sin(60.2215576)
   0.8679999905765734000000000000f,   // 10964: sin(60.2270508)
   0.8680475940848111400000000000f,   // 10965: sin(60.2325439)
   0.8680951896141416700000000000f,   // 10966: sin(60.2380371)
   0.8681427771641274700000000000f,   // 10967: sin(60.2435303)
   0.8681903567343313100000000000f,   // 10968: sin(60.2490234)
   0.8682379283243156800000000000f,   // 10969: sin(60.2545166)
   0.8682854919336432400000000000f,   // 10970: sin(60.2600098)
   0.8683330475618770100000000000f,   // 10971: sin(60.2655029)
   0.8683805952085798000000000000f,   // 10972: sin(60.2709961)
   0.8684281348733143800000000000f,   // 10973: sin(60.2764893)
   0.8684756665556441200000000000f,   // 10974: sin(60.2819824)
   0.8685231902551319200000000000f,   // 10975: sin(60.2874756)
   0.8685707059713409000000000000f,   // 10976: sin(60.2929688)
   0.8686182137038343000000000000f,   // 10977: sin(60.2984619)
   0.8686657134521755800000000000f,   // 10978: sin(60.3039551)
   0.8687132052159281000000000000f,   // 10979: sin(60.3094482)
   0.8687606889946551900000000000f,   // 10980: sin(60.3149414)
   0.8688081647879205600000000000f,   // 10981: sin(60.3204346)
   0.8688556325952877500000000000f,   // 10982: sin(60.3259277)
   0.8689030924163204700000000000f,   // 10983: sin(60.3314209)
   0.8689505442505823800000000000f,   // 10984: sin(60.3369141)
   0.8689979880976374000000000000f,   // 10985: sin(60.3424072)
   0.8690454239570495300000000000f,   // 10986: sin(60.3479004)
   0.8690928518283824700000000000f,   // 10987: sin(60.3533936)
   0.8691402717112005600000000000f,   // 10988: sin(60.3588867)
   0.8691876836050678200000000000f,   // 10989: sin(60.3643799)
   0.8692350875095482500000000000f,   // 10990: sin(60.3698730)
   0.8692824834242065500000000000f,   // 10991: sin(60.3753662)
   0.8693298713486067300000000000f,   // 10992: sin(60.3808594)
   0.8693772512823133600000000000f,   // 10993: sin(60.3863525)
   0.8694246232248907800000000000f,   // 10994: sin(60.3918457)
   0.8694719871759037900000000000f,   // 10995: sin(60.3973389)
   0.8695193431349169700000000000f,   // 10996: sin(60.4028320)
   0.8695666911014947600000000000f,   // 10997: sin(60.4083252)
   0.8696140310752023000000000000f,   // 10998: sin(60.4138184)
   0.8696613630556042600000000000f,   // 10999: sin(60.4193115)
   0.8697086870422655600000000000f,   // 11000: sin(60.4248047)
   0.8697560030347513100000000000f,   // 11001: sin(60.4302979)
   0.8698033110326266500000000000f,   // 11002: sin(60.4357910)
   0.8698506110354565800000000000f,   // 11003: sin(60.4412842)
   0.8698979030428063400000000000f,   // 11004: sin(60.4467773)
   0.8699451870542412900000000000f,   // 11005: sin(60.4522705)
   0.8699924630693268700000000000f,   // 11006: sin(60.4577637)
   0.8700397310876283300000000000f,   // 11007: sin(60.4632568)
   0.8700869911087113500000000000f,   // 11008: sin(60.4687500)
   0.8701342431321416000000000000f,   // 11009: sin(60.4742432)
   0.8701814871574845600000000000f,   // 11010: sin(60.4797363)
   0.8702287231843060000000000000f,   // 11011: sin(60.4852295)
   0.8702759512121718300000000000f,   // 11012: sin(60.4907227)
   0.8703231712406479500000000000f,   // 11013: sin(60.4962158)
   0.8703703832693001600000000000f,   // 11014: sin(60.5017090)
   0.8704175872976948100000000000f,   // 11015: sin(60.5072021)
   0.8704647833253976700000000000f,   // 11016: sin(60.5126953)
   0.8705119713519750000000000000f,   // 11017: sin(60.5181885)
   0.8705591513769932500000000000f,   // 11018: sin(60.5236816)
   0.8706063234000186400000000000f,   // 11019: sin(60.5291748)
   0.8706534874206175400000000000f,   // 11020: sin(60.5346680)
   0.8707006434383562900000000000f,   // 11021: sin(60.5401611)
   0.8707477914528017900000000000f,   // 11022: sin(60.5456543)
   0.8707949314635203800000000000f,   // 11023: sin(60.5511475)
   0.8708420634700788600000000000f,   // 11024: sin(60.5566406)
   0.8708891874720440200000000000f,   // 11025: sin(60.5621338)
   0.8709363034689827600000000000f,   // 11026: sin(60.5676270)
   0.8709834114604618800000000000f,   // 11027: sin(60.5731201)
   0.8710305114460482600000000000f,   // 11028: sin(60.5786133)
   0.8710776034253092700000000000f,   // 11029: sin(60.5841064)
   0.8711246873978119000000000000f,   // 11030: sin(60.5895996)
   0.8711717633631233000000000000f,   // 11031: sin(60.5950928)
   0.8712188313208109000000000000f,   // 11032: sin(60.6005859)
   0.8712658912704420700000000000f,   // 11033: sin(60.6060791)
   0.8713129432115839200000000000f,   // 11034: sin(60.6115723)
   0.8713599871438044700000000000f,   // 11035: sin(60.6170654)
   0.8714070230666709500000000000f,   // 11036: sin(60.6225586)
   0.8714540509797510400000000000f,   // 11037: sin(60.6280518)
   0.8715010708826125300000000000f,   // 11038: sin(60.6335449)
   0.8715480827748232100000000000f,   // 11039: sin(60.6390381)
   0.8715950866559510900000000000f,   // 11040: sin(60.6445313)
   0.8716420825255637400000000000f,   // 11041: sin(60.6500244)
   0.8716890703832297400000000000f,   // 11042: sin(60.6555176)
   0.8717360502285167500000000000f,   // 11043: sin(60.6610107)
   0.8717830220609930100000000000f,   // 11044: sin(60.6665039)
   0.8718299858802269800000000000f,   // 11045: sin(60.6719971)
   0.8718769416857868900000000000f,   // 11046: sin(60.6774902)
   0.8719238894772409800000000000f,   // 11047: sin(60.6829834)
   0.8719708292541577000000000000f,   // 11048: sin(60.6884766)
   0.8720177610161058400000000000f,   // 11049: sin(60.6939697)
   0.8720646847626539700000000000f,   // 11050: sin(60.6994629)
   0.8721116004933704400000000000f,   // 11051: sin(60.7049561)
   0.8721585082078244800000000000f,   // 11052: sin(60.7104492)
   0.8722054079055845400000000000f,   // 11053: sin(60.7159424)
   0.8722522995862198600000000000f,   // 11054: sin(60.7214355)
   0.8722991832492990000000000000f,   // 11055: sin(60.7269287)
   0.8723460588943915400000000000f,   // 11056: sin(60.7324219)
   0.8723929265210661500000000000f,   // 11057: sin(60.7379150)
   0.8724397861288922800000000000f,   // 11058: sin(60.7434082)
   0.8724866377174391700000000000f,   // 11059: sin(60.7489014)
   0.8725334812862760600000000000f,   // 11060: sin(60.7543945)
   0.8725803168349725000000000000f,   // 11061: sin(60.7598877)
   0.8726271443630979600000000000f,   // 11062: sin(60.7653809)
   0.8726739638702220000000000000f,   // 11063: sin(60.7708740)
   0.8727207753559143000000000000f,   // 11064: sin(60.7763672)
   0.8727675788197444300000000000f,   // 11065: sin(60.7818604)
   0.8728143742612823900000000000f,   // 11066: sin(60.7873535)
   0.8728611616800979700000000000f,   // 11067: sin(60.7928467)
   0.8729079410757609700000000000f,   // 11068: sin(60.7983398)
   0.8729547124478416200000000000f,   // 11069: sin(60.8038330)
   0.8730014757959099200000000000f,   // 11070: sin(60.8093262)
   0.8730482311195360000000000000f,   // 11071: sin(60.8148193)
   0.8730949784182900900000000000f,   // 11072: sin(60.8203125)
   0.8731417176917425400000000000f,   // 11073: sin(60.8258057)
   0.8731884489394637900000000000f,   // 11074: sin(60.8312988)
   0.8732351721610240900000000000f,   // 11075: sin(60.8367920)
   0.8732818873559942100000000000f,   // 11076: sin(60.8422852)
   0.8733285945239446200000000000f,   // 11077: sin(60.8477783)
   0.8733752936644460000000000000f,   // 11078: sin(60.8532715)
   0.8734219847770691200000000000f,   // 11079: sin(60.8587646)
   0.8734686678613848800000000000f,   // 11080: sin(60.8642578)
   0.8735153429169640900000000000f,   // 11081: sin(60.8697510)
   0.8735620099433777400000000000f,   // 11082: sin(60.8752441)
   0.8736086689401968400000000000f,   // 11083: sin(60.8807373)
   0.8736553199069926300000000000f,   // 11084: sin(60.8862305)
   0.8737019628433361200000000000f,   // 11085: sin(60.8917236)
   0.8737485977487988700000000000f,   // 11086: sin(60.8972168)
   0.8737952246229518900000000000f,   // 11087: sin(60.9027100)
   0.8738418434653667500000000000f,   // 11088: sin(60.9082031)
   0.8738884542756150100000000000f,   // 11089: sin(60.9136963)
   0.8739350570532681300000000000f,   // 11090: sin(60.9191895)
   0.8739816517978977700000000000f,   // 11091: sin(60.9246826)
   0.8740282385090756300000000000f,   // 11092: sin(60.9301758)
   0.8740748171863734800000000000f,   // 11093: sin(60.9356689)
   0.8741213878293633300000000000f,   // 11094: sin(60.9411621)
   0.8741679504376168600000000000f,   // 11095: sin(60.9466553)
   0.8742145050107063000000000000f,   // 11096: sin(60.9521484)
   0.8742610515482035500000000000f,   // 11097: sin(60.9576416)
   0.8743075900496809500000000000f,   // 11098: sin(60.9631348)
   0.8743541205147105100000000000f,   // 11099: sin(60.9686279)
   0.8744006429428647900000000000f,   // 11100: sin(60.9741211)
   0.8744471573337160300000000000f,   // 11101: sin(60.9796143)
   0.8744936636868364500000000000f,   // 11102: sin(60.9851074)
   0.8745401620017990700000000000f,   // 11103: sin(60.9906006)
   0.8745866522781761100000000000f,   // 11104: sin(60.9960938)
   0.8746331345155402600000000000f,   // 11105: sin(61.0015869)
   0.8746796087134645100000000000f,   // 11106: sin(61.0070801)
   0.8747260748715215400000000000f,   // 11107: sin(61.0125732)
   0.8747725329892841500000000000f,   // 11108: sin(61.0180664)
   0.8748189830663253300000000000f,   // 11109: sin(61.0235596)
   0.8748654251022182100000000000f,   // 11110: sin(61.0290527)
   0.8749118590965360200000000000f,   // 11111: sin(61.0345459)
   0.8749582850488515400000000000f,   // 11112: sin(61.0400391)
   0.8750047029587384500000000000f,   // 11113: sin(61.0455322)
   0.8750511128257699700000000000f,   // 11114: sin(61.0510254)
   0.8750975146495194600000000000f,   // 11115: sin(61.0565186)
   0.8751439084295602500000000000f,   // 11116: sin(61.0620117)
   0.8751902941654662300000000000f,   // 11117: sin(61.0675049)
   0.8752366718568108700000000000f,   // 11118: sin(61.0729980)
   0.8752830415031677100000000000f,   // 11119: sin(61.0784912)
   0.8753294031041107800000000000f,   // 11120: sin(61.0839844)
   0.8753757566592139700000000000f,   // 11121: sin(61.0894775)
   0.8754221021680508300000000000f,   // 11122: sin(61.0949707)
   0.8754684396301958300000000000f,   // 11123: sin(61.1004639)
   0.8755147690452227400000000000f,   // 11124: sin(61.1059570)
   0.8755610904127059100000000000f,   // 11125: sin(61.1114502)
   0.8756074037322192400000000000f,   // 11126: sin(61.1169434)
   0.8756537090033373900000000000f,   // 11127: sin(61.1224365)
   0.8757000062256346000000000000f,   // 11128: sin(61.1279297)
   0.8757462953986852000000000000f,   // 11129: sin(61.1334229)
   0.8757925765220638800000000000f,   // 11130: sin(61.1389160)
   0.8758388495953451900000000000f,   // 11131: sin(61.1444092)
   0.8758851146181037000000000000f,   // 11132: sin(61.1499023)
   0.8759313715899143000000000000f,   // 11133: sin(61.1553955)
   0.8759776205103516600000000000f,   // 11134: sin(61.1608887)
   0.8760238613789908000000000000f,   // 11135: sin(61.1663818)
   0.8760700941954066000000000000f,   // 11136: sin(61.1718750)
   0.8761163189591740800000000000f,   // 11137: sin(61.1773682)
   0.8761625356698684600000000000f,   // 11138: sin(61.1828613)
   0.8762087443270647500000000000f,   // 11139: sin(61.1883545)
   0.8762549449303384000000000000f,   // 11140: sin(61.1938477)
   0.8763011374792647500000000000f,   // 11141: sin(61.1993408)
   0.8763473219734190200000000000f,   // 11142: sin(61.2048340)
   0.8763934984123767900000000000f,   // 11143: sin(61.2103271)
   0.8764396667957136100000000000f,   // 11144: sin(61.2158203)
   0.8764858271230051600000000000f,   // 11145: sin(61.2213135)
   0.8765319793938271000000000000f,   // 11146: sin(61.2268066)
   0.8765781236077552200000000000f,   // 11147: sin(61.2322998)
   0.8766242597643653100000000000f,   // 11148: sin(61.2377930)
   0.8766703878632333700000000000f,   // 11149: sin(61.2432861)
   0.8767165079039354000000000000f,   // 11150: sin(61.2487793)
   0.8767626198860474200000000000f,   // 11151: sin(61.2542725)
   0.8768087238091457600000000000f,   // 11152: sin(61.2597656)
   0.8768548196728063200000000000f,   // 11153: sin(61.2652588)
   0.8769009074766056500000000000f,   // 11154: sin(61.2707520)
   0.8769469872201199900000000000f,   // 11155: sin(61.2762451)
   0.8769930589029257800000000000f,   // 11156: sin(61.2817383)
   0.8770391225245998100000000000f,   // 11157: sin(61.2872314)
   0.8770851780847183100000000000f,   // 11158: sin(61.2927246)
   0.8771312255828581600000000000f,   // 11159: sin(61.2982178)
   0.8771772650185959400000000000f,   // 11160: sin(61.3037109)
   0.8772232963915086400000000000f,   // 11161: sin(61.3092041)
   0.8772693197011731700000000000f,   // 11162: sin(61.3146973)
   0.8773153349471661800000000000f,   // 11163: sin(61.3201904)
   0.8773613421290651400000000000f,   // 11164: sin(61.3256836)
   0.8774073412464468100000000000f,   // 11165: sin(61.3311768)
   0.8774533322988885600000000000f,   // 11166: sin(61.3366699)
   0.8774993152859675800000000000f,   // 11167: sin(61.3421631)
   0.8775452902072612400000000000f,   // 11168: sin(61.3476563)
   0.8775912570623469700000000000f,   // 11169: sin(61.3531494)
   0.8776372158508021200000000000f,   // 11170: sin(61.3586426)
   0.8776831665722044700000000000f,   // 11171: sin(61.3641357)
   0.8777291092261315700000000000f,   // 11172: sin(61.3696289)
   0.8777750438121608700000000000f,   // 11173: sin(61.3751221)
   0.8778209703298705000000000000f,   // 11174: sin(61.3806152)
   0.8778668887788382300000000000f,   // 11175: sin(61.3861084)
   0.8779127991586417300000000000f,   // 11176: sin(61.3916016)
   0.8779587014688593500000000000f,   // 11177: sin(61.3970947)
   0.8780045957090690800000000000f,   // 11178: sin(61.4025879)
   0.8780504818788489300000000000f,   // 11179: sin(61.4080811)
   0.8780963599777771300000000000f,   // 11180: sin(61.4135742)
   0.8781422300054321200000000000f,   // 11181: sin(61.4190674)
   0.8781880919613922500000000000f,   // 11182: sin(61.4245605)
   0.8782339458452357300000000000f,   // 11183: sin(61.4300537)
   0.8782797916565414600000000000f,   // 11184: sin(61.4355469)
   0.8783256293948877900000000000f,   // 11185: sin(61.4410400)
   0.8783714590598535900000000000f,   // 11186: sin(61.4465332)
   0.8784172806510172100000000000f,   // 11187: sin(61.4520264)
   0.8784630941679578700000000000f,   // 11188: sin(61.4575195)
   0.8785088996102542500000000000f,   // 11189: sin(61.4630127)
   0.8785546969774853400000000000f,   // 11190: sin(61.4685059)
   0.8786004862692302600000000000f,   // 11191: sin(61.4739990)
   0.8786462674850681300000000000f,   // 11192: sin(61.4794922)
   0.8786920406245780600000000000f,   // 11193: sin(61.4849854)
   0.8787378056873392800000000000f,   // 11194: sin(61.4904785)
   0.8787835626729313400000000000f,   // 11195: sin(61.4959717)
   0.8788293115809333600000000000f,   // 11196: sin(61.5014648)
   0.8788750524109250100000000000f,   // 11197: sin(61.5069580)
   0.8789207851624858400000000000f,   // 11198: sin(61.5124512)
   0.8789665098351954200000000000f,   // 11199: sin(61.5179443)
   0.8790122264286334100000000000f,   // 11200: sin(61.5234375)
   0.8790579349423798300000000000f,   // 11201: sin(61.5289307)
   0.8791036353760143300000000000f,   // 11202: sin(61.5344238)
   0.8791493277291169100000000000f,   // 11203: sin(61.5399170)
   0.8791950120012673700000000000f,   // 11204: sin(61.5454102)
   0.8792406881920461500000000000f,   // 11205: sin(61.5509033)
   0.8792863563010332500000000000f,   // 11206: sin(61.5563965)
   0.8793320163278087700000000000f,   // 11207: sin(61.5618896)
   0.8793776682719531800000000000f,   // 11208: sin(61.5673828)
   0.8794233121330469200000000000f,   // 11209: sin(61.5728760)
   0.8794689479106701000000000000f,   // 11210: sin(61.5783691)
   0.8795145756044036000000000000f,   // 11211: sin(61.5838623)
   0.8795601952138278900000000000f,   // 11212: sin(61.5893555)
   0.8796058067385236200000000000f,   // 11213: sin(61.5948486)
   0.8796514101780714700000000000f,   // 11214: sin(61.6003418)
   0.8796970055320525500000000000f,   // 11215: sin(61.6058350)
   0.8797425928000474100000000000f,   // 11216: sin(61.6113281)
   0.8797881719816371700000000000f,   // 11217: sin(61.6168213)
   0.8798337430764029400000000000f,   // 11218: sin(61.6223145)
   0.8798793060839258400000000000f,   // 11219: sin(61.6278076)
   0.8799248610037868600000000000f,   // 11220: sin(61.6333008)
   0.8799704078355674600000000000f,   // 11221: sin(61.6387939)
   0.8800159465788489600000000000f,   // 11222: sin(61.6442871)
   0.8800614772332128200000000000f,   // 11223: sin(61.6497803)
   0.8801069997982403600000000000f,   // 11224: sin(61.6552734)
   0.8801525142735132600000000000f,   // 11225: sin(61.6607666)
   0.8801980206586131900000000000f,   // 11226: sin(61.6662598)
   0.8802435189531218100000000000f,   // 11227: sin(61.6717529)
   0.8802890091566208900000000000f,   // 11228: sin(61.6772461)
   0.8803344912686924500000000000f,   // 11229: sin(61.6827393)
   0.8803799652889182600000000000f,   // 11230: sin(61.6882324)
   0.8804254312168802200000000000f,   // 11231: sin(61.6937256)
   0.8804708890521607500000000000f,   // 11232: sin(61.6992188)
   0.8805163387943418800000000000f,   // 11233: sin(61.7047119)
   0.8805617804430055900000000000f,   // 11234: sin(61.7102051)
   0.8806072139977345600000000000f,   // 11235: sin(61.7156982)
   0.8806526394581110100000000000f,   // 11236: sin(61.7211914)
   0.8806980568237173800000000000f,   // 11237: sin(61.7266846)
   0.8807434660941362300000000000f,   // 11238: sin(61.7321777)
   0.8807888672689502300000000000f,   // 11239: sin(61.7376709)
   0.8808342603477420400000000000f,   // 11240: sin(61.7431641)
   0.8808796453300942200000000000f,   // 11241: sin(61.7486572)
   0.8809250222155898800000000000f,   // 11242: sin(61.7541504)
   0.8809703910038118000000000000f,   // 11243: sin(61.7596436)
   0.8810157516943427600000000000f,   // 11244: sin(61.7651367)
   0.8810611042867663200000000000f,   // 11245: sin(61.7706299)
   0.8811064487806651300000000000f,   // 11246: sin(61.7761230)
   0.8811517851756226500000000000f,   // 11247: sin(61.7816162)
   0.8811971134712219800000000000f,   // 11248: sin(61.7871094)
   0.8812424336670466900000000000f,   // 11249: sin(61.7926025)
   0.8812877457626801000000000000f,   // 11250: sin(61.7980957)
   0.8813330497577055400000000000f,   // 11251: sin(61.8035889)
   0.8813783456517068100000000000f,   // 11252: sin(61.8090820)
   0.8814236334442675500000000000f,   // 11253: sin(61.8145752)
   0.8814689131349713300000000000f,   // 11254: sin(61.8200684)
   0.8815141847234021500000000000f,   // 11255: sin(61.8255615)
   0.8815594482091437800000000000f,   // 11256: sin(61.8310547)
   0.8816047035917801100000000000f,   // 11257: sin(61.8365479)
   0.8816499508708952600000000000f,   // 11258: sin(61.8420410)
   0.8816951900460732200000000000f,   // 11259: sin(61.8475342)
   0.8817404211168983200000000000f,   // 11260: sin(61.8530273)
   0.8817856440829545700000000000f,   // 11261: sin(61.8585205)
   0.8818308589438266200000000000f,   // 11262: sin(61.8640137)
   0.8818760656990986000000000000f,   // 11263: sin(61.8695068)
   0.8819212643483549400000000000f,   // 11264: sin(61.8750000)
   0.8819664548911804200000000000f,   // 11265: sin(61.8804932)
   0.8820116373271595900000000000f,   // 11266: sin(61.8859863)
   0.8820568116558770200000000000f,   // 11267: sin(61.8914795)
   0.8821019778769175800000000000f,   // 11268: sin(61.8969727)
   0.8821471359898660500000000000f,   // 11269: sin(61.9024658)
   0.8821922859943074300000000000f,   // 11270: sin(61.9079590)
   0.8822374278898265100000000000f,   // 11271: sin(61.9134521)
   0.8822825616760086000000000000f,   // 11272: sin(61.9189453)
   0.8823276873524388300000000000f,   // 11273: sin(61.9244385)
   0.8823728049187022900000000000f,   // 11274: sin(61.9299316)
   0.8824179143743842200000000000f,   // 11275: sin(61.9354248)
   0.8824630157190700400000000000f,   // 11276: sin(61.9409180)
   0.8825081089523453300000000000f,   // 11277: sin(61.9464111)
   0.8825531940737954000000000000f,   // 11278: sin(61.9519043)
   0.8825982710830060400000000000f,   // 11279: sin(61.9573975)
   0.8826433399795627900000000000f,   // 11280: sin(61.9628906)
   0.8826884007630513300000000000f,   // 11281: sin(61.9683838)
   0.8827334534330575400000000000f,   // 11282: sin(61.9738770)
   0.8827784979891674100000000000f,   // 11283: sin(61.9793701)
   0.8828235344309667300000000000f,   // 11284: sin(61.9848633)
   0.8828685627580414900000000000f,   // 11285: sin(61.9903564)
   0.8829135829699780200000000000f,   // 11286: sin(61.9958496)
   0.8829585950663623200000000000f,   // 11287: sin(62.0013428)
   0.8830035990467807200000000000f,   // 11288: sin(62.0068359)
   0.8830485949108196600000000000f,   // 11289: sin(62.0123291)
   0.8830935826580653700000000000f,   // 11290: sin(62.0178223)
   0.8831385622881045000000000000f,   // 11291: sin(62.0233154)
   0.8831835338005232800000000000f,   // 11292: sin(62.0288086)
   0.8832284971949088100000000000f,   // 11293: sin(62.0343018)
   0.8832734524708474300000000000f,   // 11294: sin(62.0397949)
   0.8833183996279260200000000000f,   // 11295: sin(62.0452881)
   0.8833633386657315800000000000f,   // 11296: sin(62.0507813)
   0.8834082695838508800000000000f,   // 11297: sin(62.0562744)
   0.8834531923818709200000000000f,   // 11298: sin(62.0617676)
   0.8834981070593788100000000000f,   // 11299: sin(62.0672607)
   0.8835430136159618800000000000f,   // 11300: sin(62.0727539)
   0.8835879120512071200000000000f,   // 11301: sin(62.0782471)
   0.8836328023647017600000000000f,   // 11302: sin(62.0837402)
   0.8836776845560334600000000000f,   // 11303: sin(62.0892334)
   0.8837225586247896600000000000f,   // 11304: sin(62.0947266)
   0.8837674245705575700000000000f,   // 11305: sin(62.1002197)
   0.8838122823929250900000000000f,   // 11306: sin(62.1057129)
   0.8838571320914797600000000000f,   // 11307: sin(62.1112061)
   0.8839019736658094700000000000f,   // 11308: sin(62.1166992)
   0.8839468071155017800000000000f,   // 11309: sin(62.1221924)
   0.8839916324401448900000000000f,   // 11310: sin(62.1276855)
   0.8840364496393265900000000000f,   // 11311: sin(62.1331787)
   0.8840812587126349900000000000f,   // 11312: sin(62.1386719)
   0.8841260596596581800000000000f,   // 11313: sin(62.1441650)
   0.8841708524799845000000000000f,   // 11314: sin(62.1496582)
   0.8842156371732019500000000000f,   // 11315: sin(62.1551514)
   0.8842604137388990800000000000f,   // 11316: sin(62.1606445)
   0.8843051821766643200000000000f,   // 11317: sin(62.1661377)
   0.8843499424860861200000000000f,   // 11318: sin(62.1716309)
   0.8843946946667530200000000000f,   // 11319: sin(62.1771240)
   0.8844394387182537000000000000f,   // 11320: sin(62.1826172)
   0.8844841746401769200000000000f,   // 11321: sin(62.1881104)
   0.8845289024321113500000000000f,   // 11322: sin(62.1936035)
   0.8845736220936460900000000000f,   // 11323: sin(62.1990967)
   0.8846183336243699200000000000f,   // 11324: sin(62.2045898)
   0.8846630370238717200000000000f,   // 11325: sin(62.2100830)
   0.8847077322917409300000000000f,   // 11326: sin(62.2155762)
   0.8847524194275665500000000000f,   // 11327: sin(62.2210693)
   0.8847970984309377900000000000f,   // 11328: sin(62.2265625)
   0.8848417693014438700000000000f,   // 11329: sin(62.2320557)
   0.8848864320386745600000000000f,   // 11330: sin(62.2375488)
   0.8849310866422189800000000000f,   // 11331: sin(62.2430420)
   0.8849757331116666600000000000f,   // 11332: sin(62.2485352)
   0.8850203714466073900000000000f,   // 11333: sin(62.2540283)
   0.8850650016466309300000000000f,   // 11334: sin(62.2595215)
   0.8851096237113269500000000000f,   // 11335: sin(62.2650146)
   0.8851542376402851100000000000f,   // 11336: sin(62.2705078)
   0.8851988434330955200000000000f,   // 11337: sin(62.2760010)
   0.8852434410893482700000000000f,   // 11338: sin(62.2814941)
   0.8852880306086331500000000000f,   // 11339: sin(62.2869873)
   0.8853326119905405900000000000f,   // 11340: sin(62.2924805)
   0.8853771852346606900000000000f,   // 11341: sin(62.2979736)
   0.8854217503405835700000000000f,   // 11342: sin(62.3034668)
   0.8854663073078998800000000000f,   // 11343: sin(62.3089600)
   0.8855108561361999500000000000f,   // 11344: sin(62.3144531)
   0.8855553968250742300000000000f,   // 11345: sin(62.3199463)
   0.8855999293741133600000000000f,   // 11346: sin(62.3254395)
   0.8856444537829080100000000000f,   // 11347: sin(62.3309326)
   0.8856889700510489600000000000f,   // 11348: sin(62.3364258)
   0.8857334781781269800000000000f,   // 11349: sin(62.3419189)
   0.8857779781637329400000000000f,   // 11350: sin(62.3474121)
   0.8858224700074578400000000000f,   // 11351: sin(62.3529053)
   0.8858669537088927900000000000f,   // 11352: sin(62.3583984)
   0.8859114292676287800000000000f,   // 11353: sin(62.3638916)
   0.8859558966832570300000000000f,   // 11354: sin(62.3693848)
   0.8860003559553688600000000000f,   // 11355: sin(62.3748779)
   0.8860448070835554900000000000f,   // 11356: sin(62.3803711)
   0.8860892500674085700000000000f,   // 11357: sin(62.3858643)
   0.8861336849065193400000000000f,   // 11358: sin(62.3913574)
   0.8861781116004794300000000000f,   // 11359: sin(62.3968506)
   0.8862225301488806400000000000f,   // 11360: sin(62.4023438)
   0.8862669405513145000000000000f,   // 11361: sin(62.4078369)
   0.8863113428073728900000000000f,   // 11362: sin(62.4133301)
   0.8863557369166474900000000000f,   // 11363: sin(62.4188232)
   0.8864001228787304900000000000f,   // 11364: sin(62.4243164)
   0.8864445006932139000000000000f,   // 11365: sin(62.4298096)
   0.8864888703596896000000000000f,   // 11366: sin(62.4353027)
   0.8865332318777499100000000000f,   // 11367: sin(62.4407959)
   0.8865775852469870400000000000f,   // 11368: sin(62.4462891)
   0.8866219304669932200000000000f,   // 11369: sin(62.4517822)
   0.8866662675373608900000000000f,   // 11370: sin(62.4572754)
   0.8867105964576826900000000000f,   // 11371: sin(62.4627686)
   0.8867549172275509500000000000f,   // 11372: sin(62.4682617)
   0.8867992298465581200000000000f,   // 11373: sin(62.4737549)
   0.8868435343142973000000000000f,   // 11374: sin(62.4792480)
   0.8868878306303610300000000000f,   // 11375: sin(62.4847412)
   0.8869321187943420800000000000f,   // 11376: sin(62.4902344)
   0.8869763988058335700000000000f,   // 11377: sin(62.4957275)
   0.8870206706644283600000000000f,   // 11378: sin(62.5012207)
   0.8870649343697195600000000000f,   // 11379: sin(62.5067139)
   0.8871091899213000600000000000f,   // 11380: sin(62.5122070)
   0.8871534373187635000000000000f,   // 11381: sin(62.5177002)
   0.8871976765617029000000000000f,   // 11382: sin(62.5231934)
   0.8872419076497115600000000000f,   // 11383: sin(62.5286865)
   0.8872861305823831500000000000f,   // 11384: sin(62.5341797)
   0.8873303453593109900000000000f,   // 11385: sin(62.5396729)
   0.8873745519800887400000000000f,   // 11386: sin(62.5451660)
   0.8874187504443101800000000000f,   // 11387: sin(62.5506592)
   0.8874629407515688400000000000f,   // 11388: sin(62.5561523)
   0.8875071229014586100000000000f,   // 11389: sin(62.5616455)
   0.8875512968935733700000000000f,   // 11390: sin(62.5671387)
   0.8875954627275071100000000000f,   // 11391: sin(62.5726318)
   0.8876396204028539300000000000f,   // 11392: sin(62.5781250)
   0.8876837699192078300000000000f,   // 11393: sin(62.5836182)
   0.8877279112761630200000000000f,   // 11394: sin(62.5891113)
   0.8877720444733138100000000000f,   // 11395: sin(62.5946045)
   0.8878161695102545500000000000f,   // 11396: sin(62.6000977)
   0.8878602863865794300000000000f,   // 11397: sin(62.6055908)
   0.8879043951018832400000000000f,   // 11398: sin(62.6110840)
   0.8879484956557603900000000000f,   // 11399: sin(62.6165771)
   0.8879925880478055600000000000f,   // 11400: sin(62.6220703)
   0.8880366722776134000000000000f,   // 11401: sin(62.6275635)
   0.8880807483447789000000000000f,   // 11402: sin(62.6330566)
   0.8881248162488965000000000000f,   // 11403: sin(62.6385498)
   0.8881688759895616200000000000f,   // 11404: sin(62.6440430)
   0.8882129275663690500000000000f,   // 11405: sin(62.6495361)
   0.8882569709789138700000000000f,   // 11406: sin(62.6550293)
   0.8883010062267910900000000000f,   // 11407: sin(62.6605225)
   0.8883450333095962400000000000f,   // 11408: sin(62.6660156)
   0.8883890522269245500000000000f,   // 11409: sin(62.6715088)
   0.8884330629783713200000000000f,   // 11410: sin(62.6770020)
   0.8884770655635320100000000000f,   // 11411: sin(62.6824951)
   0.8885210599820022600000000000f,   // 11412: sin(62.6879883)
   0.8885650462333776200000000000f,   // 11413: sin(62.6934814)
   0.8886090243172537500000000000f,   // 11414: sin(62.6989746)
   0.8886529942332265200000000000f,   // 11415: sin(62.7044678)
   0.8886969559808917100000000000f,   // 11416: sin(62.7099609)
   0.8887409095598450800000000000f,   // 11417: sin(62.7154541)
   0.8887848549696828500000000000f,   // 11418: sin(62.7209473)
   0.8888287922100010000000000000f,   // 11419: sin(62.7264404)
   0.8888727212803955200000000000f,   // 11420: sin(62.7319336)
   0.8889166421804629600000000000f,   // 11421: sin(62.7374268)
   0.8889605549097993100000000000f,   // 11422: sin(62.7429199)
   0.8890044594680010000000000000f,   // 11423: sin(62.7484131)
   0.8890483558546645700000000000f,   // 11424: sin(62.7539063)
   0.8890922440693863600000000000f,   // 11425: sin(62.7593994)
   0.8891361241117632400000000000f,   // 11426: sin(62.7648926)
   0.8891799959813915200000000000f,   // 11427: sin(62.7703857)
   0.8892238596778682100000000000f,   // 11428: sin(62.7758789)
   0.8892677152007900700000000000f,   // 11429: sin(62.7813721)
   0.8893115625497538500000000000f,   // 11430: sin(62.7868652)
   0.8893554017243566800000000000f,   // 11431: sin(62.7923584)
   0.8893992327241955200000000000f,   // 11432: sin(62.7978516)
   0.8894430555488676000000000000f,   // 11433: sin(62.8033447)
   0.8894868701979697900000000000f,   // 11434: sin(62.8088379)
   0.8895306766710997500000000000f,   // 11435: sin(62.8143311)
   0.8895744749678545800000000000f,   // 11436: sin(62.8198242)
   0.8896182650878317100000000000f,   // 11437: sin(62.8253174)
   0.8896620470306287900000000000f,   // 11438: sin(62.8308105)
   0.8897058207958432600000000000f,   // 11439: sin(62.8363037)
   0.8897495863830728900000000000f,   // 11440: sin(62.8417969)
   0.8897933437919149900000000000f,   // 11441: sin(62.8472900)
   0.8898370930219679000000000000f,   // 11442: sin(62.8527832)
   0.8898808340728291400000000000f,   // 11443: sin(62.8582764)
   0.8899245669440967200000000000f,   // 11444: sin(62.8637695)
   0.8899682916353687200000000000f,   // 11445: sin(62.8692627)
   0.8900120081462432600000000000f,   // 11446: sin(62.8747559)
   0.8900557164763182000000000000f,   // 11447: sin(62.8802490)
   0.8900994166251922100000000000f,   // 11448: sin(62.8857422)
   0.8901431085924634800000000000f,   // 11449: sin(62.8912354)
   0.8901867923777302400000000000f,   // 11450: sin(62.8967285)
   0.8902304679805910200000000000f,   // 11451: sin(62.9022217)
   0.8902741354006444800000000000f,   // 11452: sin(62.9077148)
   0.8903177946374892800000000000f,   // 11453: sin(62.9132080)
   0.8903614456907237300000000000f,   // 11454: sin(62.9187012)
   0.8904050885599470400000000000f,   // 11455: sin(62.9241943)
   0.8904487232447578800000000000f,   // 11456: sin(62.9296875)
   0.8904923497447551100000000000f,   // 11457: sin(62.9351807)
   0.8905359680595378300000000000f,   // 11458: sin(62.9406738)
   0.8905795781887050300000000000f,   // 11459: sin(62.9461670)
   0.8906231801318559300000000000f,   // 11460: sin(62.9516602)
   0.8906667738885896100000000000f,   // 11461: sin(62.9571533)
   0.8907103594585055200000000000f,   // 11462: sin(62.9626465)
   0.8907539368412030800000000000f,   // 11463: sin(62.9681396)
   0.8907975060362814900000000000f,   // 11464: sin(62.9736328)
   0.8908410670433404300000000000f,   // 11465: sin(62.9791260)
   0.8908846198619795300000000000f,   // 11466: sin(62.9846191)
   0.8909281644917984600000000000f,   // 11467: sin(62.9901123)
   0.8909717009323967500000000000f,   // 11468: sin(62.9956055)
   0.8910152291833745000000000000f,   // 11469: sin(63.0010986)
   0.8910587492443315900000000000f,   // 11470: sin(63.0065918)
   0.8911022611148676800000000000f,   // 11471: sin(63.0120850)
   0.8911457647945831800000000000f,   // 11472: sin(63.0175781)
   0.8911892602830781000000000000f,   // 11473: sin(63.0230713)
   0.8912327475799525200000000000f,   // 11474: sin(63.0285645)
   0.8912762266848068800000000000f,   // 11475: sin(63.0340576)
   0.8913196975972413900000000000f,   // 11476: sin(63.0395508)
   0.8913631603168567000000000000f,   // 11477: sin(63.0450439)
   0.8914066148432529000000000000f,   // 11478: sin(63.0505371)
   0.8914500611760309800000000000f,   // 11479: sin(63.0560303)
   0.8914934993147913800000000000f,   // 11480: sin(63.0615234)
   0.8915369292591348600000000000f,   // 11481: sin(63.0670166)
   0.8915803510086622900000000000f,   // 11482: sin(63.0725098)
   0.8916237645629744300000000000f,   // 11483: sin(63.0780029)
   0.8916671699216723900000000000f,   // 11484: sin(63.0834961)
   0.8917105670843569200000000000f,   // 11485: sin(63.0889893)
   0.8917539560506294600000000000f,   // 11486: sin(63.0944824)
   0.8917973368200909900000000000f,   // 11487: sin(63.0999756)
   0.8918407093923427200000000000f,   // 11488: sin(63.1054687)
   0.8918840737669860900000000000f,   // 11489: sin(63.1109619)
   0.8919274299436225100000000000f,   // 11490: sin(63.1164551)
   0.8919707779218534200000000000f,   // 11491: sin(63.1219482)
   0.8920141177012803600000000000f,   // 11492: sin(63.1274414)
   0.8920574492815051000000000000f,   // 11493: sin(63.1329346)
   0.8921007726621291700000000000f,   // 11494: sin(63.1384277)
   0.8921440878427542300000000000f,   // 11495: sin(63.1439209)
   0.8921873948229824800000000000f,   // 11496: sin(63.1494141)
   0.8922306936024156900000000000f,   // 11497: sin(63.1549072)
   0.8922739841806557300000000000f,   // 11498: sin(63.1604004)
   0.8923172665573049200000000000f,   // 11499: sin(63.1658936)
   0.8923605407319653600000000000f,   // 11500: sin(63.1713867)
   0.8924038067042391300000000000f,   // 11501: sin(63.1768799)
   0.8924470644737286800000000000f,   // 11502: sin(63.1823730)
   0.8924903140400363100000000000f,   // 11503: sin(63.1878662)
   0.8925335554027646900000000000f,   // 11504: sin(63.1933594)
   0.8925767885615159000000000000f,   // 11505: sin(63.1988525)
   0.8926200135158930400000000000f,   // 11506: sin(63.2043457)
   0.8926632302654986500000000000f,   // 11507: sin(63.2098389)
   0.8927064388099352800000000000f,   // 11508: sin(63.2153320)
   0.8927496391488060100000000000f,   // 11509: sin(63.2208252)
   0.8927928312817136100000000000f,   // 11510: sin(63.2263184)
   0.8928360152082612800000000000f,   // 11511: sin(63.2318115)
   0.8928791909280516800000000000f,   // 11512: sin(63.2373047)
   0.8929223584406883500000000000f,   // 11513: sin(63.2427979)
   0.8929655177457742600000000000f,   // 11514: sin(63.2482910)
   0.8930086688429128600000000000f,   // 11515: sin(63.2537842)
   0.8930518117317074500000000000f,   // 11516: sin(63.2592773)
   0.8930949464117613500000000000f,   // 11517: sin(63.2647705)
   0.8931380728826782100000000000f,   // 11518: sin(63.2702637)
   0.8931811911440616900000000000f,   // 11519: sin(63.2757568)
   0.8932243011955153200000000000f,   // 11520: sin(63.2812500)
   0.8932674030366428700000000000f,   // 11521: sin(63.2867432)
   0.8933104966670480900000000000f,   // 11522: sin(63.2922363)
   0.8933535820863350900000000000f,   // 11523: sin(63.2977295)
   0.8933966592941076100000000000f,   // 11524: sin(63.3032227)
   0.8934397282899697600000000000f,   // 11525: sin(63.3087158)
   0.8934827890735258500000000000f,   // 11526: sin(63.3142090)
   0.8935258416443797600000000000f,   // 11527: sin(63.3197021)
   0.8935688860021360200000000000f,   // 11528: sin(63.3251953)
   0.8936119221463987300000000000f,   // 11529: sin(63.3306885)
   0.8936549500767724300000000000f,   // 11530: sin(63.3361816)
   0.8936979697928617600000000000f,   // 11531: sin(63.3416748)
   0.8937409812942710400000000000f,   // 11532: sin(63.3471680)
   0.8937839845806051500000000000f,   // 11533: sin(63.3526611)
   0.8938269796514686200000000000f,   // 11534: sin(63.3581543)
   0.8938699665064663300000000000f,   // 11535: sin(63.3636475)
   0.8939129451452032500000000000f,   // 11536: sin(63.3691406)
   0.8939559155672841500000000000f,   // 11537: sin(63.3746338)
   0.8939988777723142400000000000f,   // 11538: sin(63.3801270)
   0.8940418317598983800000000000f,   // 11539: sin(63.3856201)
   0.8940847775296419900000000000f,   // 11540: sin(63.3911133)
   0.8941277150811501900000000000f,   // 11541: sin(63.3966064)
   0.8941706444140282700000000000f,   // 11542: sin(63.4020996)
   0.8942135655278817800000000000f,   // 11543: sin(63.4075928)
   0.8942564784223160400000000000f,   // 11544: sin(63.4130859)
   0.8942993830969366800000000000f,   // 11545: sin(63.4185791)
   0.8943422795513494800000000000f,   // 11546: sin(63.4240723)
   0.8943851677851598600000000000f,   // 11547: sin(63.4295654)
   0.8944280477979738000000000000f,   // 11548: sin(63.4350586)
   0.8944709195893970600000000000f,   // 11549: sin(63.4405518)
   0.8945137831590356200000000000f,   // 11550: sin(63.4460449)
   0.8945566385064954700000000000f,   // 11551: sin(63.4515381)
   0.8945994856313825800000000000f,   // 11552: sin(63.4570312)
   0.8946423245333033900000000000f,   // 11553: sin(63.4625244)
   0.8946851552118639800000000000f,   // 11554: sin(63.4680176)
   0.8947279776666705600000000000f,   // 11555: sin(63.4735107)
   0.8947707918973295500000000000f,   // 11556: sin(63.4790039)
   0.8948135979034475000000000000f,   // 11557: sin(63.4844971)
   0.8948563956846309300000000000f,   // 11558: sin(63.4899902)
   0.8948991852404863900000000000f,   // 11559: sin(63.4954834)
   0.8949419665706207500000000000f,   // 11560: sin(63.5009766)
   0.8949847396746405400000000000f,   // 11561: sin(63.5064697)
   0.8950275045521526300000000000f,   // 11562: sin(63.5119629)
   0.8950702612027640100000000000f,   // 11563: sin(63.5174561)
   0.8951130096260817600000000000f,   // 11564: sin(63.5229492)
   0.8951557498217127500000000000f,   // 11565: sin(63.5284424)
   0.8951984817892642000000000000f,   // 11566: sin(63.5339355)
   0.8952412055283434100000000000f,   // 11567: sin(63.5394287)
   0.8952839210385575800000000000f,   // 11568: sin(63.5449219)
   0.8953266283195139300000000000f,   // 11569: sin(63.5504150)
   0.8953693273708203100000000000f,   // 11570: sin(63.5559082)
   0.8954120181920839400000000000f,   // 11571: sin(63.5614014)
   0.8954547007829124500000000000f,   // 11572: sin(63.5668945)
   0.8954973751429135000000000000f,   // 11573: sin(63.5723877)
   0.8955400412716948400000000000f,   // 11574: sin(63.5778809)
   0.8955826991688644600000000000f,   // 11575: sin(63.5833740)
   0.8956253488340300000000000000f,   // 11576: sin(63.5888672)
   0.8956679902667996600000000000f,   // 11577: sin(63.5943604)
   0.8957106234667813200000000000f,   // 11578: sin(63.5998535)
   0.8957532484335831700000000000f,   // 11579: sin(63.6053467)
   0.8957958651668134200000000000f,   // 11580: sin(63.6108398)
   0.8958384736660803800000000000f,   // 11581: sin(63.6163330)
   0.8958810739309923700000000000f,   // 11582: sin(63.6218262)
   0.8959236659611578000000000000f,   // 11583: sin(63.6273193)
   0.8959662497561851100000000000f,   // 11584: sin(63.6328125)
   0.8960088253156830400000000000f,   // 11585: sin(63.6383057)
   0.8960513926392600400000000000f,   // 11586: sin(63.6437988)
   0.8960939517265250600000000000f,   // 11587: sin(63.6492920)
   0.8961365025770867700000000000f,   // 11588: sin(63.6547852)
   0.8961790451905540200000000000f,   // 11589: sin(63.6602783)
   0.8962215795665359200000000000f,   // 11590: sin(63.6657715)
   0.8962641057046414300000000000f,   // 11591: sin(63.6712646)
   0.8963066236044796600000000000f,   // 11592: sin(63.6767578)
   0.8963491332656595700000000000f,   // 11593: sin(63.6822510)
   0.8963916346877908200000000000f,   // 11594: sin(63.6877441)
   0.8964341278704824900000000000f,   // 11595: sin(63.6932373)
   0.8964766128133440100000000000f,   // 11596: sin(63.6987305)
   0.8965190895159850200000000000f,   // 11597: sin(63.7042236)
   0.8965615579780149600000000000f,   // 11598: sin(63.7097168)
   0.8966040181990434500000000000f,   // 11599: sin(63.7152100)
   0.8966464701786801500000000000f,   // 11600: sin(63.7207031)
   0.8966889139165350500000000000f,   // 11601: sin(63.7261963)
   0.8967313494122178800000000000f,   // 11602: sin(63.7316895)
   0.8967737766653385300000000000f,   // 11603: sin(63.7371826)
   0.8968161956755071900000000000f,   // 11604: sin(63.7426758)
   0.8968586064423339500000000000f,   // 11605: sin(63.7481689)
   0.8969010089654286800000000000f,   // 11606: sin(63.7536621)
   0.8969434032444019200000000000f,   // 11607: sin(63.7591553)
   0.8969857892788639700000000000f,   // 11608: sin(63.7646484)
   0.8970281670684251400000000000f,   // 11609: sin(63.7701416)
   0.8970705366126958700000000000f,   // 11610: sin(63.7756348)
   0.8971128979112867900000000000f,   // 11611: sin(63.7811279)
   0.8971552509638085500000000000f,   // 11612: sin(63.7866211)
   0.8971975957698715700000000000f,   // 11613: sin(63.7921143)
   0.8972399323290870500000000000f,   // 11614: sin(63.7976074)
   0.8972822606410656400000000000f,   // 11615: sin(63.8031006)
   0.8973245807054183200000000000f,   // 11616: sin(63.8085938)
   0.8973668925217558300000000000f,   // 11617: sin(63.8140869)
   0.8974091960896897200000000000f,   // 11618: sin(63.8195801)
   0.8974514914088307400000000000f,   // 11619: sin(63.8250732)
   0.8974937784787901900000000000f,   // 11620: sin(63.8305664)
   0.8975360572991796200000000000f,   // 11621: sin(63.8360596)
   0.8975783278696102300000000000f,   // 11622: sin(63.8415527)
   0.8976205901896933100000000000f,   // 11623: sin(63.8470459)
   0.8976628442590407500000000000f,   // 11624: sin(63.8525391)
   0.8977050900772639600000000000f,   // 11625: sin(63.8580322)
   0.8977473276439746900000000000f,   // 11626: sin(63.8635254)
   0.8977895569587846000000000000f,   // 11627: sin(63.8690186)
   0.8978317780213056500000000000f,   // 11628: sin(63.8745117)
   0.8978739908311496000000000000f,   // 11629: sin(63.8800049)
   0.8979161953879285500000000000f,   // 11630: sin(63.8854980)
   0.8979583916912545800000000000f,   // 11631: sin(63.8909912)
   0.8980005797407398800000000000f,   // 11632: sin(63.8964844)
   0.8980427595359964400000000000f,   // 11633: sin(63.9019775)
   0.8980849310766367800000000000f,   // 11634: sin(63.9074707)
   0.8981270943622731200000000000f,   // 11635: sin(63.9129639)
   0.8981692493925180800000000000f,   // 11636: sin(63.9184570)
   0.8982113961669839800000000000f,   // 11637: sin(63.9239502)
   0.8982535346852835700000000000f,   // 11638: sin(63.9294434)
   0.8982956649470293900000000000f,   // 11639: sin(63.9349365)
   0.8983377869518341900000000000f,   // 11640: sin(63.9404297)
   0.8983799006993110600000000000f,   // 11641: sin(63.9459229)
   0.8984220061890725300000000000f,   // 11642: sin(63.9514160)
   0.8984641034207319100000000000f,   // 11643: sin(63.9569092)
   0.8985061923939018400000000000f,   // 11644: sin(63.9624023)
   0.8985482731081959600000000000f,   // 11645: sin(63.9678955)
   0.8985903455632270300000000000f,   // 11646: sin(63.9733887)
   0.8986324097586084700000000000f,   // 11647: sin(63.9788818)
   0.8986744656939538200000000000f,   // 11648: sin(63.9843750)
   0.8987165133688763700000000000f,   // 11649: sin(63.9898682)
   0.8987585527829894400000000000f,   // 11650: sin(63.9953613)
   0.8988005839359068900000000000f,   // 11651: sin(64.0008545)
   0.8988426068272422600000000000f,   // 11652: sin(64.0063477)
   0.8988846214566094100000000000f,   // 11653: sin(64.0118408)
   0.8989266278236218700000000000f,   // 11654: sin(64.0173340)
   0.8989686259278938400000000000f,   // 11655: sin(64.0228271)
   0.8990106157690390700000000000f,   // 11656: sin(64.0283203)
   0.8990525973466716400000000000f,   // 11657: sin(64.0338135)
   0.8990945706604057700000000000f,   // 11658: sin(64.0393066)
   0.8991365357098555200000000000f,   // 11659: sin(64.0447998)
   0.8991784924946353300000000000f,   // 11660: sin(64.0502930)
   0.8992204410143592700000000000f,   // 11661: sin(64.0557861)
   0.8992623812686420000000000000f,   // 11662: sin(64.0612793)
   0.8993043132570979200000000000f,   // 11663: sin(64.0667725)
   0.8993462369793414600000000000f,   // 11664: sin(64.0722656)
   0.8993881524349876000000000000f,   // 11665: sin(64.0777588)
   0.8994300596236508600000000000f,   // 11666: sin(64.0832520)
   0.8994719585449458800000000000f,   // 11667: sin(64.0887451)
   0.8995138491984878700000000000f,   // 11668: sin(64.0942383)
   0.8995557315838916800000000000f,   // 11669: sin(64.0997314)
   0.8995976057007721800000000000f,   // 11670: sin(64.1052246)
   0.8996394715487444600000000000f,   // 11671: sin(64.1107178)
   0.8996813291274239300000000000f,   // 11672: sin(64.1162109)
   0.8997231784364256900000000000f,   // 11673: sin(64.1217041)
   0.8997650194753650200000000000f,   // 11674: sin(64.1271973)
   0.8998068522438575900000000000f,   // 11675: sin(64.1326904)
   0.8998486767415185800000000000f,   // 11676: sin(64.1381836)
   0.8998904929679636400000000000f,   // 11677: sin(64.1436768)
   0.8999323009228084000000000000f,   // 11678: sin(64.1491699)
   0.8999741006056687400000000000f,   // 11679: sin(64.1546631)
   0.9000158920161602800000000000f,   // 11680: sin(64.1601563)
   0.9000576751538987800000000000f,   // 11681: sin(64.1656494)
   0.9000994500185003400000000000f,   // 11682: sin(64.1711426)
   0.9001412166095810200000000000f,   // 11683: sin(64.1766357)
   0.9001829749267567000000000000f,   // 11684: sin(64.1821289)
   0.9002247249696437900000000000f,   // 11685: sin(64.1876221)
   0.9002664667378584800000000000f,   // 11686: sin(64.1931152)
   0.9003082002310169900000000000f,   // 11687: sin(64.1986084)
   0.9003499254487356000000000000f,   // 11688: sin(64.2041016)
   0.9003916423906310800000000000f,   // 11689: sin(64.2095947)
   0.9004333510563198300000000000f,   // 11690: sin(64.2150879)
   0.9004750514454182800000000000f,   // 11691: sin(64.2205811)
   0.9005167435575435200000000000f,   // 11692: sin(64.2260742)
   0.9005584273923121800000000000f,   // 11693: sin(64.2315674)
   0.9006001029493407900000000000f,   // 11694: sin(64.2370605)
   0.9006417702282467600000000000f,   // 11695: sin(64.2425537)
   0.9006834292286468600000000000f,   // 11696: sin(64.2480469)
   0.9007250799501582700000000000f,   // 11697: sin(64.2535400)
   0.9007667223923978600000000000f,   // 11698: sin(64.2590332)
   0.9008083565549831500000000000f,   // 11699: sin(64.2645264)
   0.9008499824375314500000000000f,   // 11700: sin(64.2700195)
   0.9008916000396598500000000000f,   // 11701: sin(64.2755127)
   0.9009332093609862000000000000f,   // 11702: sin(64.2810059)
   0.9009748104011278100000000000f,   // 11703: sin(64.2864990)
   0.9010164031597023300000000000f,   // 11704: sin(64.2919922)
   0.9010579876363273800000000000f,   // 11705: sin(64.2974854)
   0.9010995638306209500000000000f,   // 11706: sin(64.3029785)
   0.9011411317422006700000000000f,   // 11707: sin(64.3084717)
   0.9011826913706844100000000000f,   // 11708: sin(64.3139648)
   0.9012242427156903500000000000f,   // 11709: sin(64.3194580)
   0.9012657857768365800000000000f,   // 11710: sin(64.3249512)
   0.9013073205537409600000000000f,   // 11711: sin(64.3304443)
   0.9013488470460220300000000000f,   // 11712: sin(64.3359375)
   0.9013903652532978500000000000f,   // 11713: sin(64.3414307)
   0.9014318751751869700000000000f,   // 11714: sin(64.3469238)
   0.9014733768113076800000000000f,   // 11715: sin(64.3524170)
   0.9015148701612786300000000000f,   // 11716: sin(64.3579102)
   0.9015563552247184400000000000f,   // 11717: sin(64.3634033)
   0.9015978320012456600000000000f,   // 11718: sin(64.3688965)
   0.9016393004904791300000000000f,   // 11719: sin(64.3743896)
   0.9016807606920377300000000000f,   // 11720: sin(64.3798828)
   0.9017222126055402000000000000f,   // 11721: sin(64.3853760)
   0.9017636562306056100000000000f,   // 11722: sin(64.3908691)
   0.9018050915668531800000000000f,   // 11723: sin(64.3963623)
   0.9018465186139018600000000000f,   // 11724: sin(64.4018555)
   0.9018879373713707400000000000f,   // 11725: sin(64.4073486)
   0.9019293478388793500000000000f,   // 11726: sin(64.4128418)
   0.9019707500160471000000000000f,   // 11727: sin(64.4183350)
   0.9020121439024930700000000000f,   // 11728: sin(64.4238281)
   0.9020535294978372400000000000f,   // 11729: sin(64.4293213)
   0.9020949068016989000000000000f,   // 11730: sin(64.4348145)
   0.9021362758136978200000000000f,   // 11731: sin(64.4403076)
   0.9021776365334535100000000000f,   // 11732: sin(64.4458008)
   0.9022189889605861700000000000f,   // 11733: sin(64.4512939)
   0.9022603330947155400000000000f,   // 11734: sin(64.4567871)
   0.9023016689354614900000000000f,   // 11735: sin(64.4622803)
   0.9023429964824442000000000000f,   // 11736: sin(64.4677734)
   0.9023843157352837700000000000f,   // 11737: sin(64.4732666)
   0.9024256266936002700000000000f,   // 11738: sin(64.4787598)
   0.9024669293570142200000000000f,   // 11739: sin(64.4842529)
   0.9025082237251458300000000000f,   // 11740: sin(64.4897461)
   0.9025495097976156100000000000f,   // 11741: sin(64.4952393)
   0.9025907875740438700000000000f,   // 11742: sin(64.5007324)
   0.9026320570540513600000000000f,   // 11743: sin(64.5062256)
   0.9026733182372588300000000000f,   // 11744: sin(64.5117188)
   0.9027145711232866800000000000f,   // 11745: sin(64.5172119)
   0.9027558157117561200000000000f,   // 11746: sin(64.5227051)
   0.9027970520022878800000000000f,   // 11747: sin(64.5281982)
   0.9028382799945028300000000000f,   // 11748: sin(64.5336914)
   0.9028794996880219500000000000f,   // 11749: sin(64.5391846)
   0.9029207110824666300000000000f,   // 11750: sin(64.5446777)
   0.9029619141774579700000000000f,   // 11751: sin(64.5501709)
   0.9030031089726170400000000000f,   // 11752: sin(64.5556641)
   0.9030442954675654800000000000f,   // 11753: sin(64.5611572)
   0.9030854736619246000000000000f,   // 11754: sin(64.5666504)
   0.9031266435553156900000000000f,   // 11755: sin(64.5721436)
   0.9031678051473606100000000000f,   // 11756: sin(64.5776367)
   0.9032089584376810100000000000f,   // 11757: sin(64.5831299)
   0.9032501034258984000000000000f,   // 11758: sin(64.5886230)
   0.9032912401116346400000000000f,   // 11759: sin(64.5941162)
   0.9033323684945118200000000000f,   // 11760: sin(64.5996094)
   0.9033734885741516700000000000f,   // 11761: sin(64.6051025)
   0.9034146003501762900000000000f,   // 11762: sin(64.6105957)
   0.9034557038222078600000000000f,   // 11763: sin(64.6160889)
   0.9034967989898684500000000000f,   // 11764: sin(64.6215820)
   0.9035378858527802800000000000f,   // 11765: sin(64.6270752)
   0.9035789644105659500000000000f,   // 11766: sin(64.6325684)
   0.9036200346628476800000000000f,   // 11767: sin(64.6380615)
   0.9036610966092479800000000000f,   // 11768: sin(64.6435547)
   0.9037021502493893800000000000f,   // 11769: sin(64.6490479)
   0.9037431955828946200000000000f,   // 11770: sin(64.6545410)
   0.9037842326093864500000000000f,   // 11771: sin(64.6600342)
   0.9038252613284873900000000000f,   // 11772: sin(64.6655273)
   0.9038662817398206400000000000f,   // 11773: sin(64.6710205)
   0.9039072938430090500000000000f,   // 11774: sin(64.6765137)
   0.9039482976376755900000000000f,   // 11775: sin(64.6820068)
   0.9039892931234433400000000000f,   // 11776: sin(64.6875000)
   0.9040302802999354800000000000f,   // 11777: sin(64.6929932)
   0.9040712591667754400000000000f,   // 11778: sin(64.6984863)
   0.9041122297235862900000000000f,   // 11779: sin(64.7039795)
   0.9041531919699916700000000000f,   // 11780: sin(64.7094727)
   0.9041941459056149800000000000f,   // 11781: sin(64.7149658)
   0.9042350915300797500000000000f,   // 11782: sin(64.7204590)
   0.9042760288430096200000000000f,   // 11783: sin(64.7259521)
   0.9043169578440283200000000000f,   // 11784: sin(64.7314453)
   0.9043578785327596200000000000f,   // 11785: sin(64.7369385)
   0.9043987909088273500000000000f,   // 11786: sin(64.7424316)
   0.9044396949718555000000000000f,   // 11787: sin(64.7479248)
   0.9044805907214682500000000000f,   // 11788: sin(64.7534180)
   0.9045214781572893400000000000f,   // 11789: sin(64.7589111)
   0.9045623572789431900000000000f,   // 11790: sin(64.7644043)
   0.9046032280860540900000000000f,   // 11791: sin(64.7698975)
   0.9046440905782462400000000000f,   // 11792: sin(64.7753906)
   0.9046849447551439400000000000f,   // 11793: sin(64.7808838)
   0.9047257906163719300000000000f,   // 11794: sin(64.7863770)
   0.9047666281615546200000000000f,   // 11795: sin(64.7918701)
   0.9048074573903165400000000000f,   // 11796: sin(64.7973633)
   0.9048482783022826500000000000f,   // 11797: sin(64.8028564)
   0.9048890908970774700000000000f,   // 11798: sin(64.8083496)
   0.9049298951743259800000000000f,   // 11799: sin(64.8138428)
   0.9049706911336532500000000000f,   // 11800: sin(64.8193359)
   0.9050114787746840200000000000f,   // 11801: sin(64.8248291)
   0.9050522580970435900000000000f,   // 11802: sin(64.8303223)
   0.9050930291003570500000000000f,   // 11803: sin(64.8358154)
   0.9051337917842495800000000000f,   // 11804: sin(64.8413086)
   0.9051745461483466900000000000f,   // 11805: sin(64.8468018)
   0.9052152921922734800000000000f,   // 11806: sin(64.8522949)
   0.9052560299156556800000000000f,   // 11807: sin(64.8577881)
   0.9052967593181188200000000000f,   // 11808: sin(64.8632813)
   0.9053374803992883000000000000f,   // 11809: sin(64.8687744)
   0.9053781931587899800000000000f,   // 11810: sin(64.8742676)
   0.9054188975962497200000000000f,   // 11811: sin(64.8797607)
   0.9054595937112932500000000000f,   // 11812: sin(64.8852539)
   0.9055002815035464400000000000f,   // 11813: sin(64.8907471)
   0.9055409609726354800000000000f,   // 11814: sin(64.8962402)
   0.9055816321181864300000000000f,   // 11815: sin(64.9017334)
   0.9056222949398251600000000000f,   // 11816: sin(64.9072266)
   0.9056629494371782900000000000f,   // 11817: sin(64.9127197)
   0.9057035956098720100000000000f,   // 11818: sin(64.9182129)
   0.9057442334575326300000000000f,   // 11819: sin(64.9237061)
   0.9057848629797864400000000000f,   // 11820: sin(64.9291992)
   0.9058254841762604100000000000f,   // 11821: sin(64.9346924)
   0.9058660970465809400000000000f,   // 11822: sin(64.9401855)
   0.9059067015903746700000000000f,   // 11823: sin(64.9456787)
   0.9059472978072684600000000000f,   // 11824: sin(64.9511719)
   0.9059878856968891500000000000f,   // 11825: sin(64.9566650)
   0.9060284652588634900000000000f,   // 11826: sin(64.9621582)
   0.9060690364928187800000000000f,   // 11827: sin(64.9676514)
   0.9061095993983819800000000000f,   // 11828: sin(64.9731445)
   0.9061501539751801700000000000f,   // 11829: sin(64.9786377)
   0.9061907002228405400000000000f,   // 11830: sin(64.9841309)
   0.9062312381409906000000000000f,   // 11831: sin(64.9896240)
   0.9062717677292576600000000000f,   // 11832: sin(64.9951172)
   0.9063122889872689000000000000f,   // 11833: sin(65.0006104)
   0.9063528019146522800000000000f,   // 11834: sin(65.0061035)
   0.9063933065110353300000000000f,   // 11835: sin(65.0115967)
   0.9064338027760454600000000000f,   // 11836: sin(65.0170898)
   0.9064742907093106300000000000f,   // 11837: sin(65.0225830)
   0.9065147703104588000000000000f,   // 11838: sin(65.0280762)
   0.9065552415791177100000000000f,   // 11839: sin(65.0335693)
   0.9065957045149153300000000000f,   // 11840: sin(65.0390625)
   0.9066361591174798600000000000f,   // 11841: sin(65.0445557)
   0.9066766053864394600000000000f,   // 11842: sin(65.0500488)
   0.9067170433214222200000000000f,   // 11843: sin(65.0555420)
   0.9067574729220565500000000000f,   // 11844: sin(65.0610352)
   0.9067978941879708500000000000f,   // 11845: sin(65.0665283)
   0.9068383071187935400000000000f,   // 11846: sin(65.0720215)
   0.9068787117141530200000000000f,   // 11847: sin(65.0775146)
   0.9069191079736780300000000000f,   // 11848: sin(65.0830078)
   0.9069594958969974300000000000f,   // 11849: sin(65.0885010)
   0.9069998754837396100000000000f,   // 11850: sin(65.0939941)
   0.9070402467335336700000000000f,   // 11851: sin(65.0994873)
   0.9070806096460084500000000000f,   // 11852: sin(65.1049805)
   0.9071209642207930200000000000f,   // 11853: sin(65.1104736)
   0.9071613104575162500000000000f,   // 11854: sin(65.1159668)
   0.9072016483558075200000000000f,   // 11855: sin(65.1214600)
   0.9072419779152959300000000000f,   // 11856: sin(65.1269531)
   0.9072822991356106500000000000f,   // 11857: sin(65.1324463)
   0.9073226120163813100000000000f,   // 11858: sin(65.1379395)
   0.9073629165572373300000000000f,   // 11859: sin(65.1434326)
   0.9074032127578080000000000000f,   // 11860: sin(65.1489258)
   0.9074435006177232800000000000f,   // 11861: sin(65.1544189)
   0.9074837801366125700000000000f,   // 11862: sin(65.1599121)
   0.9075240513141057400000000000f,   // 11863: sin(65.1654053)
   0.9075643141498325200000000000f,   // 11864: sin(65.1708984)
   0.9076045686434230900000000000f,   // 11865: sin(65.1763916)
   0.9076448147945070900000000000f,   // 11866: sin(65.1818848)
   0.9076850526027148100000000000f,   // 11867: sin(65.1873779)
   0.9077252820676763300000000000f,   // 11868: sin(65.1928711)
   0.9077655031890219400000000000f,   // 11869: sin(65.1983643)
   0.9078057159663818200000000000f,   // 11870: sin(65.2038574)
   0.9078459203993863900000000000f,   // 11871: sin(65.2093506)
   0.9078861164876661500000000000f,   // 11872: sin(65.2148438)
   0.9079263042308516300000000000f,   // 11873: sin(65.2203369)
   0.9079664836285732400000000000f,   // 11874: sin(65.2258301)
   0.9080066546804619300000000000f,   // 11875: sin(65.2313232)
   0.9080468173861483400000000000f,   // 11876: sin(65.2368164)
   0.9080869717452632100000000000f,   // 11877: sin(65.2423096)
   0.9081271177574376000000000000f,   // 11878: sin(65.2478027)
   0.9081672554223023700000000000f,   // 11879: sin(65.2532959)
   0.9082073847394887000000000000f,   // 11880: sin(65.2587891)
   0.9082475057086275600000000000f,   // 11881: sin(65.2642822)
   0.9082876183293504500000000000f,   // 11882: sin(65.2697754)
   0.9083277226012883600000000000f,   // 11883: sin(65.2752686)
   0.9083678185240727800000000000f,   // 11884: sin(65.2807617)
   0.9084079060973353500000000000f,   // 11885: sin(65.2862549)
   0.9084479853207072500000000000f,   // 11886: sin(65.2917480)
   0.9084880561938202300000000000f,   // 11887: sin(65.2972412)
   0.9085281187163061200000000000f,   // 11888: sin(65.3027344)
   0.9085681728877964500000000000f,   // 11889: sin(65.3082275)
   0.9086082187079231900000000000f,   // 11890: sin(65.3137207)
   0.9086482561763180600000000000f,   // 11891: sin(65.3192139)
   0.9086882852926133600000000000f,   // 11892: sin(65.3247070)
   0.9087283060564409500000000000f,   // 11893: sin(65.3302002)
   0.9087683184674327800000000000f,   // 11894: sin(65.3356934)
   0.9088083225252214800000000000f,   // 11895: sin(65.3411865)
   0.9088483182294391200000000000f,   // 11896: sin(65.3466797)
   0.9088883055797180000000000000f,   // 11897: sin(65.3521729)
   0.9089282845756906400000000000f,   // 11898: sin(65.3576660)
   0.9089682552169896500000000000f,   // 11899: sin(65.3631592)
   0.9090082175032474500000000000f,   // 11900: sin(65.3686523)
   0.9090481714340968900000000000f,   // 11901: sin(65.3741455)
   0.9090881170091705800000000000f,   // 11902: sin(65.3796387)
   0.9091280542281015000000000000f,   // 11903: sin(65.3851318)
   0.9091679830905222700000000000f,   // 11904: sin(65.3906250)
   0.9092079035960662900000000000f,   // 11905: sin(65.3961182)
   0.9092478157443663100000000000f,   // 11906: sin(65.4016113)
   0.9092877195350556100000000000f,   // 11907: sin(65.4071045)
   0.9093276149677672600000000000f,   // 11908: sin(65.4125977)
   0.9093675020421346800000000000f,   // 11909: sin(65.4180908)
   0.9094073807577912600000000000f,   // 11910: sin(65.4235840)
   0.9094472511143703000000000000f,   // 11911: sin(65.4290771)
   0.9094871131115054300000000000f,   // 11912: sin(65.4345703)
   0.9095269667488301600000000000f,   // 11913: sin(65.4400635)
   0.9095668120259782200000000000f,   // 11914: sin(65.4455566)
   0.9096066489425834700000000000f,   // 11915: sin(65.4510498)
   0.9096464774982795400000000000f,   // 11916: sin(65.4565430)
   0.9096862976927004900000000000f,   // 11917: sin(65.4620361)
   0.9097261095254801600000000000f,   // 11918: sin(65.4675293)
   0.9097659129962526500000000000f,   // 11919: sin(65.4730225)
   0.9098057081046522200000000000f,   // 11920: sin(65.4785156)
   0.9098454948503129600000000000f,   // 11921: sin(65.4840088)
   0.9098852732328691600000000000f,   // 11922: sin(65.4895020)
   0.9099250432519552200000000000f,   // 11923: sin(65.4949951)
   0.9099648049072056600000000000f,   // 11924: sin(65.5004883)
   0.9100045581982547600000000000f,   // 11925: sin(65.5059814)
   0.9100443031247373900000000000f,   // 11926: sin(65.5114746)
   0.9100840396862881500000000000f,   // 11927: sin(65.5169678)
   0.9101237678825415700000000000f,   // 11928: sin(65.5224609)
   0.9101634877131328200000000000f,   // 11929: sin(65.5279541)
   0.9102031991776965400000000000f,   // 11930: sin(65.5334473)
   0.9102429022758677900000000000f,   // 11931: sin(65.5389404)
   0.9102825970072817600000000000f,   // 11932: sin(65.5444336)
   0.9103222833715733900000000000f,   // 11933: sin(65.5499268)
   0.9103619613683779900000000000f,   // 11934: sin(65.5554199)
   0.9104016309973307400000000000f,   // 11935: sin(65.5609131)
   0.9104412922580671400000000000f,   // 11936: sin(65.5664063)
   0.9104809451502227100000000000f,   // 11937: sin(65.5718994)
   0.9105205896734326300000000000f,   // 11938: sin(65.5773926)
   0.9105602258273328700000000000f,   // 11939: sin(65.5828857)
   0.9105998536115589300000000000f,   // 11940: sin(65.5883789)
   0.9106394730257465500000000000f,   // 11941: sin(65.5938721)
   0.9106790840695315700000000000f,   // 11942: sin(65.5993652)
   0.9107186867425498500000000000f,   // 11943: sin(65.6048584)
   0.9107582810444375700000000000f,   // 11944: sin(65.6103516)
   0.9107978669748304500000000000f,   // 11945: sin(65.6158447)
   0.9108374445333650100000000000f,   // 11946: sin(65.6213379)
   0.9108770137196772200000000000f,   // 11947: sin(65.6268311)
   0.9109165745334032400000000000f,   // 11948: sin(65.6323242)
   0.9109561269741798300000000000f,   // 11949: sin(65.6378174)
   0.9109956710416431400000000000f,   // 11950: sin(65.6433105)
   0.9110352067354298100000000000f,   // 11951: sin(65.6488037)
   0.9110747340551762500000000000f,   // 11952: sin(65.6542969)
   0.9111142530005194000000000000f,   // 11953: sin(65.6597900)
   0.9111537635710959000000000000f,   // 11954: sin(65.6652832)
   0.9111932657665424700000000000f,   // 11955: sin(65.6707764)
   0.9112327595864961900000000000f,   // 11956: sin(65.6762695)
   0.9112722450305939000000000000f,   // 11957: sin(65.6817627)
   0.9113117220984726700000000000f,   // 11958: sin(65.6872559)
   0.9113511907897697800000000000f,   // 11959: sin(65.6927490)
   0.9113906511041223200000000000f,   // 11960: sin(65.6982422)
   0.9114301030411676700000000000f,   // 11961: sin(65.7037354)
   0.9114695466005430200000000000f,   // 11962: sin(65.7092285)
   0.9115089817818860000000000000f,   // 11963: sin(65.7147217)
   0.9115484085848339900000000000f,   // 11964: sin(65.7202148)
   0.9115878270090246300000000000f,   // 11965: sin(65.7257080)
   0.9116272370540956500000000000f,   // 11966: sin(65.7312012)
   0.9116666387196847900000000000f,   // 11967: sin(65.7366943)
   0.9117060320054298800000000000f,   // 11968: sin(65.7421875)
   0.9117454169109686600000000000f,   // 11969: sin(65.7476807)
   0.9117847934359394300000000000f,   // 11970: sin(65.7531738)
   0.9118241615799800300000000000f,   // 11971: sin(65.7586670)
   0.9118635213427285200000000000f,   // 11972: sin(65.7641602)
   0.9119028727238233100000000000f,   // 11973: sin(65.7696533)
   0.9119422157229025700000000000f,   // 11974: sin(65.7751465)
   0.9119815503396047100000000000f,   // 11975: sin(65.7806396)
   0.9120208765735682300000000000f,   // 11976: sin(65.7861328)
   0.9120601944244316500000000000f,   // 11977: sin(65.7916260)
   0.9120995038918334700000000000f,   // 11978: sin(65.7971191)
   0.9121388049754123300000000000f,   // 11979: sin(65.8026123)
   0.9121780976748070600000000000f,   // 11980: sin(65.8081055)
   0.9122173819896566300000000000f,   // 11981: sin(65.8135986)
   0.9122566579195996500000000000f,   // 11982: sin(65.8190918)
   0.9122959254642754000000000000f,   // 11983: sin(65.8245850)
   0.9123351846233227500000000000f,   // 11984: sin(65.8300781)
   0.9123744353963809700000000000f,   // 11985: sin(65.8355713)
   0.9124136777830890200000000000f,   // 11986: sin(65.8410645)
   0.9124529117830865200000000000f,   // 11987: sin(65.8465576)
   0.9124921373960126500000000000f,   // 11988: sin(65.8520508)
   0.9125313546215068100000000000f,   // 11989: sin(65.8575439)
   0.9125705634592087300000000000f,   // 11990: sin(65.8630371)
   0.9126097639087579200000000000f,   // 11991: sin(65.8685303)
   0.9126489559697939000000000000f,   // 11992: sin(65.8740234)
   0.9126881396419566100000000000f,   // 11993: sin(65.8795166)
   0.9127273149248859000000000000f,   // 11994: sin(65.8850098)
   0.9127664818182215100000000000f,   // 11995: sin(65.8905029)
   0.9128056403216035000000000000f,   // 11996: sin(65.8959961)
   0.9128447904346720400000000000f,   // 11997: sin(65.9014893)
   0.9128839321570672000000000000f,   // 11998: sin(65.9069824)
   0.9129230654884290500000000000f,   // 11999: sin(65.9124756)
   0.9129621904283981000000000000f,   // 12000: sin(65.9179688)
   0.9130013069766147500000000000f,   // 12001: sin(65.9234619)
   0.9130404151327191600000000000f,   // 12002: sin(65.9289551)
   0.9130795148963520800000000000f,   // 12003: sin(65.9344482)
   0.9131186062671541300000000000f,   // 12004: sin(65.9399414)
   0.9131576892447659200000000000f,   // 12005: sin(65.9454346)
   0.9131967638288282000000000000f,   // 12006: sin(65.9509277)
   0.9132358300189817900000000000f,   // 12007: sin(65.9564209)
   0.9132748878148677600000000000f,   // 12008: sin(65.9619141)
   0.9133139372161268600000000000f,   // 12009: sin(65.9674072)
   0.9133529782224002500000000000f,   // 12010: sin(65.9729004)
   0.9133920108333292200000000000f,   // 12011: sin(65.9783936)
   0.9134310350485547200000000000f,   // 12012: sin(65.9838867)
   0.9134700508677182600000000000f,   // 12013: sin(65.9893799)
   0.9135090582904611400000000000f,   // 12014: sin(65.9948730)
   0.9135480573164248600000000000f,   // 12015: sin(66.0003662)
   0.9135870479452508100000000000f,   // 12016: sin(66.0058594)
   0.9136260301765807300000000000f,   // 12017: sin(66.0113525)
   0.9136650040100563500000000000f,   // 12018: sin(66.0168457)
   0.9137039694453191800000000000f,   // 12019: sin(66.0223389)
   0.9137429264820113900000000000f,   // 12020: sin(66.0278320)
   0.9137818751197747100000000000f,   // 12021: sin(66.0333252)
   0.9138208153582511000000000000f,   // 12022: sin(66.0388184)
   0.9138597471970826300000000000f,   // 12023: sin(66.0443115)
   0.9138986706359116800000000000f,   // 12024: sin(66.0498047)
   0.9139375856743802200000000000f,   // 12025: sin(66.0552979)
   0.9139764923121305200000000000f,   // 12026: sin(66.0607910)
   0.9140153905488052100000000000f,   // 12027: sin(66.0662842)
   0.9140542803840464600000000000f,   // 12028: sin(66.0717773)
   0.9140931618174971100000000000f,   // 12029: sin(66.0772705)
   0.9141320348487994600000000000f,   // 12030: sin(66.0827637)
   0.9141708994775964400000000000f,   // 12031: sin(66.0882568)
   0.9142097557035306900000000000f,   // 12032: sin(66.0937500)
   0.9142486035262449300000000000f,   // 12033: sin(66.0992432)
   0.9142874429453824400000000000f,   // 12034: sin(66.1047363)
   0.9143262739605859700000000000f,   // 12035: sin(66.1102295)
   0.9143650965714984500000000000f,   // 12036: sin(66.1157227)
   0.9144039107777634000000000000f,   // 12037: sin(66.1212158)
   0.9144427165790238700000000000f,   // 12038: sin(66.1267090)
   0.9144815139749230500000000000f,   // 12039: sin(66.1322021)
   0.9145203029651044500000000000f,   // 12040: sin(66.1376953)
   0.9145590835492115600000000000f,   // 12041: sin(66.1431885)
   0.9145978557268877900000000000f,   // 12042: sin(66.1486816)
   0.9146366194977767500000000000f,   // 12043: sin(66.1541748)
   0.9146753748615223900000000000f,   // 12044: sin(66.1596680)
   0.9147141218177682300000000000f,   // 12045: sin(66.1651611)
   0.9147528603661581000000000000f,   // 12046: sin(66.1706543)
   0.9147915905063360700000000000f,   // 12047: sin(66.1761475)
   0.9148303122379460900000000000f,   // 12048: sin(66.1816406)
   0.9148690255606323200000000000f,   // 12049: sin(66.1871338)
   0.9149077304740386200000000000f,   // 12050: sin(66.1926270)
   0.9149464269778095900000000000f,   // 12051: sin(66.1981201)
   0.9149851150715893100000000000f,   // 12052: sin(66.2036133)
   0.9150237947550221600000000000f,   // 12053: sin(66.2091064)
   0.9150624660277527600000000000f,   // 12054: sin(66.2145996)
   0.9151011288894256300000000000f,   // 12055: sin(66.2200928)
   0.9151397833396852600000000000f,   // 12056: sin(66.2255859)
   0.9151784293781762800000000000f,   // 12057: sin(66.2310791)
   0.9152170670045437500000000000f,   // 12058: sin(66.2365723)
   0.9152556962184323900000000000f,   // 12059: sin(66.2420654)
   0.9152943170194870500000000000f,   // 12060: sin(66.2475586)
   0.9153329294073527800000000000f,   // 12061: sin(66.2530518)
   0.9153715333816747600000000000f,   // 12062: sin(66.2585449)
   0.9154101289420979400000000000f,   // 12063: sin(66.2640381)
   0.9154487160882678300000000000f,   // 12064: sin(66.2695313)
   0.9154872948198294900000000000f,   // 12065: sin(66.2750244)
   0.9155258651364285300000000000f,   // 12066: sin(66.2805176)
   0.9155644270377101300000000000f,   // 12067: sin(66.2860107)
   0.9156029805233202300000000000f,   // 12068: sin(66.2915039)
   0.9156415255929041300000000000f,   // 12069: sin(66.2969971)
   0.9156800622461076500000000000f,   // 12070: sin(66.3024902)
   0.9157185904825765300000000000f,   // 12071: sin(66.3079834)
   0.9157571103019567200000000000f,   // 12072: sin(66.3134766)
   0.9157956217038941700000000000f,   // 12073: sin(66.3189697)
   0.9158341246880347100000000000f,   // 12074: sin(66.3244629)
   0.9158726192540245200000000000f,   // 12075: sin(66.3299561)
   0.9159111054015098800000000000f,   // 12076: sin(66.3354492)
   0.9159495831301368600000000000f,   // 12077: sin(66.3409424)
   0.9159880524395518400000000000f,   // 12078: sin(66.3464355)
   0.9160265133294013300000000000f,   // 12079: sin(66.3519287)
   0.9160649657993316100000000000f,   // 12080: sin(66.3574219)
   0.9161034098489894100000000000f,   // 12081: sin(66.3629150)
   0.9161418454780213500000000000f,   // 12082: sin(66.3684082)
   0.9161802726860740500000000000f,   // 12083: sin(66.3739014)
   0.9162186914727941100000000000f,   // 12084: sin(66.3793945)
   0.9162571018378288200000000000f,   // 12085: sin(66.3848877)
   0.9162955037808248000000000000f,   // 12086: sin(66.3903809)
   0.9163338973014292200000000000f,   // 12087: sin(66.3958740)
   0.9163722823992891400000000000f,   // 12088: sin(66.4013672)
   0.9164106590740517300000000000f,   // 12089: sin(66.4068604)
   0.9164490273253640400000000000f,   // 12090: sin(66.4123535)
   0.9164873871528738100000000000f,   // 12091: sin(66.4178467)
   0.9165257385562281000000000000f,   // 12092: sin(66.4233398)
   0.9165640815350746300000000000f,   // 12093: sin(66.4288330)
   0.9166024160890606800000000000f,   // 12094: sin(66.4343262)
   0.9166407422178342000000000000f,   // 12095: sin(66.4398193)
   0.9166790599210427000000000000f,   // 12096: sin(66.4453125)
   0.9167173691983339100000000000f,   // 12097: sin(66.4508057)
   0.9167556700493559900000000000f,   // 12098: sin(66.4562988)
   0.9167939624737565500000000000f,   // 12099: sin(66.4617920)
   0.9168322464711838900000000000f,   // 12100: sin(66.4672852)
   0.9168705220412859400000000000f,   // 12101: sin(66.4727783)
   0.9169087891837109900000000000f,   // 12102: sin(66.4782715)
   0.9169470478981072100000000000f,   // 12103: sin(66.4837646)
   0.9169852981841228900000000000f,   // 12104: sin(66.4892578)
   0.9170235400414066300000000000f,   // 12105: sin(66.4947510)
   0.9170617734696068200000000000f,   // 12106: sin(66.5002441)
   0.9170999984683718700000000000f,   // 12107: sin(66.5057373)
   0.9171382150373507100000000000f,   // 12108: sin(66.5112305)
   0.9171764231761918600000000000f,   // 12109: sin(66.5167236)
   0.9172146228845442500000000000f,   // 12110: sin(66.5222168)
   0.9172528141620565100000000000f,   // 12111: sin(66.5277100)
   0.9172909970083779100000000000f,   // 12112: sin(66.5332031)
   0.9173291714231574000000000000f,   // 12113: sin(66.5386963)
   0.9173673374060438100000000000f,   // 12114: sin(66.5441895)
   0.9174054949566866600000000000f,   // 12115: sin(66.5496826)
   0.9174436440747352200000000000f,   // 12116: sin(66.5551758)
   0.9174817847598385500000000000f,   // 12117: sin(66.5606689)
   0.9175199170116462600000000000f,   // 12118: sin(66.5661621)
   0.9175580408298078500000000000f,   // 12119: sin(66.5716553)
   0.9175961562139729500000000000f,   // 12120: sin(66.5771484)
   0.9176342631637909300000000000f,   // 12121: sin(66.5826416)
   0.9176723616789117500000000000f,   // 12122: sin(66.5881348)
   0.9177104517589852500000000000f,   // 12123: sin(66.5936279)
   0.9177485334036612500000000000f,   // 12124: sin(66.5991211)
   0.9177866066125897100000000000f,   // 12125: sin(66.6046143)
   0.9178246713854205700000000000f,   // 12126: sin(66.6101074)
   0.9178627277218041100000000000f,   // 12127: sin(66.6156006)
   0.9179007756213903900000000000f,   // 12128: sin(66.6210938)
   0.9179388150838298000000000000f,   // 12129: sin(66.6265869)
   0.9179768461087727300000000000f,   // 12130: sin(66.6320801)
   0.9180148686958693500000000000f,   // 12131: sin(66.6375732)
   0.9180528828447703800000000000f,   // 12132: sin(66.6430664)
   0.9180908885551264400000000000f,   // 12133: sin(66.6485596)
   0.9181288858265879100000000000f,   // 12134: sin(66.6540527)
   0.9181668746588058600000000000f,   // 12135: sin(66.6595459)
   0.9182048550514309000000000000f,   // 12136: sin(66.6650391)
   0.9182428270041140800000000000f,   // 12137: sin(66.6705322)
   0.9182807905165061300000000000f,   // 12138: sin(66.6760254)
   0.9183187455882583200000000000f,   // 12139: sin(66.6815186)
   0.9183566922190217200000000000f,   // 12140: sin(66.6870117)
   0.9183946304084473800000000000f,   // 12141: sin(66.6925049)
   0.9184325601561867900000000000f,   // 12142: sin(66.6979980)
   0.9184704814618913600000000000f,   // 12143: sin(66.7034912)
   0.9185083943252122500000000000f,   // 12144: sin(66.7089844)
   0.9185462987458010700000000000f,   // 12145: sin(66.7144775)
   0.9185841947233095400000000000f,   // 12146: sin(66.7199707)
   0.9186220822573892800000000000f,   // 12147: sin(66.7254639)
   0.9186599613476919000000000000f,   // 12148: sin(66.7309570)
   0.9186978319938693400000000000f,   // 12149: sin(66.7364502)
   0.9187356941955735500000000000f,   // 12150: sin(66.7419434)
   0.9187735479524563600000000000f,   // 12151: sin(66.7474365)
   0.9188113932641699400000000000f,   // 12152: sin(66.7529297)
   0.9188492301303664600000000000f,   // 12153: sin(66.7584229)
   0.9188870585506979700000000000f,   // 12154: sin(66.7639160)
   0.9189248785248168600000000000f,   // 12155: sin(66.7694092)
   0.9189626900523756300000000000f,   // 12156: sin(66.7749023)
   0.9190004931330264500000000000f,   // 12157: sin(66.7803955)
   0.9190382877664219400000000000f,   // 12158: sin(66.7858887)
   0.9190760739522149100000000000f,   // 12159: sin(66.7913818)
   0.9191138516900577700000000000f,   // 12160: sin(66.7968750)
   0.9191516209796033500000000000f,   // 12161: sin(66.8023682)
   0.9191893818205044700000000000f,   // 12162: sin(66.8078613)
   0.9192271342124142000000000000f,   // 12163: sin(66.8133545)
   0.9192648781549852500000000000f,   // 12164: sin(66.8188477)
   0.9193026136478709100000000000f,   // 12165: sin(66.8243408)
   0.9193403406907242300000000000f,   // 12166: sin(66.8298340)
   0.9193780592831986000000000000f,   // 12167: sin(66.8353271)
   0.9194157694249469600000000000f,   // 12168: sin(66.8408203)
   0.9194534711156230300000000000f,   // 12169: sin(66.8463135)
   0.9194911643548801000000000000f,   // 12170: sin(66.8518066)
   0.9195288491423717600000000000f,   // 12171: sin(66.8572998)
   0.9195665254777515300000000000f,   // 12172: sin(66.8627930)
   0.9196041933606731200000000000f,   // 12173: sin(66.8682861)
   0.9196418527907904700000000000f,   // 12174: sin(66.8737793)
   0.9196795037677572000000000000f,   // 12175: sin(66.8792725)
   0.9197171462912273600000000000f,   // 12176: sin(66.8847656)
   0.9197547803608549000000000000f,   // 12177: sin(66.8902588)
   0.9197924059762937500000000000f,   // 12178: sin(66.8957520)
   0.9198300231371984200000000000f,   // 12179: sin(66.9012451)
   0.9198676318432229500000000000f,   // 12180: sin(66.9067383)
   0.9199052320940215300000000000f,   // 12181: sin(66.9122314)
   0.9199428238892486400000000000f,   // 12182: sin(66.9177246)
   0.9199804072285587800000000000f,   // 12183: sin(66.9232178)
   0.9200179821116065700000000000f,   // 12184: sin(66.9287109)
   0.9200555485380463900000000000f,   // 12185: sin(66.9342041)
   0.9200931065075330700000000000f,   // 12186: sin(66.9396973)
   0.9201306560197215500000000000f,   // 12187: sin(66.9451904)
   0.9201681970742664500000000000f,   // 12188: sin(66.9506836)
   0.9202057296708225900000000000f,   // 12189: sin(66.9561768)
   0.9202432538090453700000000000f,   // 12190: sin(66.9616699)
   0.9202807694885896100000000000f,   // 12191: sin(66.9671631)
   0.9203182767091104800000000000f,   // 12192: sin(66.9726563)
   0.9203557754702633700000000000f,   // 12193: sin(66.9781494)
   0.9203932657717035500000000000f,   // 12194: sin(66.9836426)
   0.9204307476130861900000000000f,   // 12195: sin(66.9891357)
   0.9204682209940671100000000000f,   // 12196: sin(66.9946289)
   0.9205056859143016000000000000f,   // 12197: sin(67.0001221)
   0.9205431423734454800000000000f,   // 12198: sin(67.0056152)
   0.9205805903711542500000000000f,   // 12199: sin(67.0111084)
   0.9206180299070838600000000000f,   // 12200: sin(67.0166016)
   0.9206554609808902400000000000f,   // 12201: sin(67.0220947)
   0.9206928835922290100000000000f,   // 12202: sin(67.0275879)
   0.9207302977407565400000000000f,   // 12203: sin(67.0330811)
   0.9207677034261287900000000000f,   // 12204: sin(67.0385742)
   0.9208051006480019200000000000f,   // 12205: sin(67.0440674)
   0.9208424894060320800000000000f,   // 12206: sin(67.0495605)
   0.9208798696998759000000000000f,   // 12207: sin(67.0550537)
   0.9209172415291895200000000000f,   // 12208: sin(67.0605469)
   0.9209546048936293500000000000f,   // 12209: sin(67.0660400)
   0.9209919597928523100000000000f,   // 12210: sin(67.0715332)
   0.9210293062265148000000000000f,   // 12211: sin(67.0770264)
   0.9210666441942735300000000000f,   // 12212: sin(67.0825195)
   0.9211039736957854500000000000f,   // 12213: sin(67.0880127)
   0.9211412947307072700000000000f,   // 12214: sin(67.0935059)
   0.9211786072986960500000000000f,   // 12215: sin(67.0989990)
   0.9212159113994087300000000000f,   // 12216: sin(67.1044922)
   0.9212532070325024600000000000f,   // 12217: sin(67.1099854)
   0.9212904941976345400000000000f,   // 12218: sin(67.1154785)
   0.9213277728944619900000000000f,   // 12219: sin(67.1209717)
   0.9213650431226423400000000000f,   // 12220: sin(67.1264648)
   0.9214023048818330600000000000f,   // 12221: sin(67.1319580)
   0.9214395581716913200000000000f,   // 12222: sin(67.1374512)
   0.9214768029918751800000000000f,   // 12223: sin(67.1429443)
   0.9215140393420419000000000000f,   // 12224: sin(67.1484375)
   0.9215512672218494300000000000f,   // 12225: sin(67.1539307)
   0.9215884866309553800000000000f,   // 12226: sin(67.1594238)
   0.9216256975690179100000000000f,   // 12227: sin(67.1649170)
   0.9216629000356947300000000000f,   // 12228: sin(67.1704102)
   0.9217000940306440100000000000f,   // 12229: sin(67.1759033)
   0.9217372795535238000000000000f,   // 12230: sin(67.1813965)
   0.9217744566039924900000000000f,   // 12231: sin(67.1868896)
   0.9218116251817081200000000000f,   // 12232: sin(67.1923828)
   0.9218487852863290800000000000f,   // 12233: sin(67.1978760)
   0.9218859369175139700000000000f,   // 12234: sin(67.2033691)
   0.9219230800749210800000000000f,   // 12235: sin(67.2088623)
   0.9219602147582091100000000000f,   // 12236: sin(67.2143555)
   0.9219973409670367800000000000f,   // 12237: sin(67.2198486)
   0.9220344587010628200000000000f,   // 12238: sin(67.2253418)
   0.9220715679599459400000000000f,   // 12239: sin(67.2308350)
   0.9221086687433450700000000000f,   // 12240: sin(67.2363281)
   0.9221457610509192800000000000f,   // 12241: sin(67.2418213)
   0.9221828448823276000000000000f,   // 12242: sin(67.2473145)
   0.9222199202372291000000000000f,   // 12243: sin(67.2528076)
   0.9222569871152830300000000000f,   // 12244: sin(67.2583008)
   0.9222940455161486900000000000f,   // 12245: sin(67.2637939)
   0.9223310954394853300000000000f,   // 12246: sin(67.2692871)
   0.9223681368849525600000000000f,   // 12247: sin(67.2747803)
   0.9224051698522098800000000000f,   // 12248: sin(67.2802734)
   0.9224421943409169000000000000f,   // 12249: sin(67.2857666)
   0.9224792103507331000000000000f,   // 12250: sin(67.2912598)
   0.9225162178813185500000000000f,   // 12251: sin(67.2967529)
   0.9225532169323328300000000000f,   // 12252: sin(67.3022461)
   0.9225902075034359000000000000f,   // 12253: sin(67.3077393)
   0.9226271895942878000000000000f,   // 12254: sin(67.3132324)
   0.9226641632045486900000000000f,   // 12255: sin(67.3187256)
   0.9227011283338785200000000000f,   // 12256: sin(67.3242188)
   0.9227380849819376600000000000f,   // 12257: sin(67.3297119)
   0.9227750331483863800000000000f,   // 12258: sin(67.3352051)
   0.9228119728328850700000000000f,   // 12259: sin(67.3406982)
   0.9228489040350941200000000000f,   // 12260: sin(67.3461914)
   0.9228858267546741200000000000f,   // 12261: sin(67.3516846)
   0.9229227409912856800000000000f,   // 12262: sin(67.3571777)
   0.9229596467445894100000000000f,   // 12263: sin(67.3626709)
   0.9229965440142462500000000000f,   // 12264: sin(67.3681641)
   0.9230334327999170100000000000f,   // 12265: sin(67.3736572)
   0.9230703131012624200000000000f,   // 12266: sin(67.3791504)
   0.9231071849179436400000000000f,   // 12267: sin(67.3846436)
   0.9231440482496218200000000000f,   // 12268: sin(67.3901367)
   0.9231809030959581300000000000f,   // 12269: sin(67.3956299)
   0.9232177494566135000000000000f,   // 12270: sin(67.4011230)
   0.9232545873312495400000000000f,   // 12271: sin(67.4066162)
   0.9232914167195276400000000000f,   // 12272: sin(67.4121094)
   0.9233282376211090500000000000f,   // 12273: sin(67.4176025)
   0.9233650500356556100000000000f,   // 12274: sin(67.4230957)
   0.9234018539628288100000000000f,   // 12275: sin(67.4285889)
   0.9234386494022903700000000000f,   // 12276: sin(67.4340820)
   0.9234754363537018800000000000f,   // 12277: sin(67.4395752)
   0.9235122148167255200000000000f,   // 12278: sin(67.4450684)
   0.9235489847910231000000000000f,   // 12279: sin(67.4505615)
   0.9235857462762565600000000000f,   // 12280: sin(67.4560547)
   0.9236224992720881700000000000f,   // 12281: sin(67.4615479)
   0.9236592437781799800000000000f,   // 12282: sin(67.4670410)
   0.9236959797941941600000000000f,   // 12283: sin(67.4725342)
   0.9237327073197931800000000000f,   // 12284: sin(67.4780273)
   0.9237694263546394300000000000f,   // 12285: sin(67.4835205)
   0.9238061368983954100000000000f,   // 12286: sin(67.4890137)
   0.9238428389507236100000000000f,   // 12287: sin(67.4945068)
   0.9238795325112867400000000000f,   // 12288: sin(67.5000000)
   0.9239162175797475100000000000f,   // 12289: sin(67.5054932)
   0.9239528941557686400000000000f,   // 12290: sin(67.5109863)
   0.9239895622390130700000000000f,   // 12291: sin(67.5164795)
   0.9240262218291438500000000000f,   // 12292: sin(67.5219727)
   0.9240628729258239000000000000f,   // 12293: sin(67.5274658)
   0.9240995155287162800000000000f,   // 12294: sin(67.5329590)
   0.9241361496374842500000000000f,   // 12295: sin(67.5384521)
   0.9241727752517912000000000000f,   // 12296: sin(67.5439453)
   0.9242093923713001800000000000f,   // 12297: sin(67.5494385)
   0.9242460009956748900000000000f,   // 12298: sin(67.5549316)
   0.9242826011245787200000000000f,   // 12299: sin(67.5604248)
   0.9243191927576751600000000000f,   // 12300: sin(67.5659180)
   0.9243557758946280300000000000f,   // 12301: sin(67.5714111)
   0.9243923505351010500000000000f,   // 12302: sin(67.5769043)
   0.9244289166787579300000000000f,   // 12303: sin(67.5823975)
   0.9244654743252626000000000000f,   // 12304: sin(67.5878906)
   0.9245020234742791200000000000f,   // 12305: sin(67.5933838)
   0.9245385641254714200000000000f,   // 12306: sin(67.5988770)
   0.9245750962785035400000000000f,   // 12307: sin(67.6043701)
   0.9246116199330399700000000000f,   // 12308: sin(67.6098633)
   0.9246481350887448800000000000f,   // 12309: sin(67.6153564)
   0.9246846417452825300000000000f,   // 12310: sin(67.6208496)
   0.9247211399023173000000000000f,   // 12311: sin(67.6263428)
   0.9247576295595139100000000000f,   // 12312: sin(67.6318359)
   0.9247941107165368300000000000f,   // 12313: sin(67.6373291)
   0.9248305833730508000000000000f,   // 12314: sin(67.6428223)
   0.9248670475287205100000000000f,   // 12315: sin(67.6483154)
   0.9249035031832109100000000000f,   // 12316: sin(67.6538086)
   0.9249399503361867000000000000f,   // 12317: sin(67.6593018)
   0.9249763889873130500000000000f,   // 12318: sin(67.6647949)
   0.9250128191362549900000000000f,   // 12319: sin(67.6702881)
   0.9250492407826775800000000000f,   // 12320: sin(67.6757813)
   0.9250856539262460900000000000f,   // 12321: sin(67.6812744)
   0.9251220585666257700000000000f,   // 12322: sin(67.6867676)
   0.9251584547034821200000000000f,   // 12323: sin(67.6922607)
   0.9251948423364804200000000000f,   // 12324: sin(67.6977539)
   0.9252312214652864700000000000f,   // 12325: sin(67.7032471)
   0.9252675920895655500000000000f,   // 12326: sin(67.7087402)
   0.9253039542089835900000000000f,   // 12327: sin(67.7142334)
   0.9253403078232062000000000000f,   // 12328: sin(67.7197266)
   0.9253766529318994100000000000f,   // 12329: sin(67.7252197)
   0.9254129895347290600000000000f,   // 12330: sin(67.7307129)
   0.9254493176313609600000000000f,   // 12331: sin(67.7362061)
   0.9254856372214614900000000000f,   // 12332: sin(67.7416992)
   0.9255219483046967000000000000f,   // 12333: sin(67.7471924)
   0.9255582508807326200000000000f,   // 12334: sin(67.7526855)
   0.9255945449492358800000000000f,   // 12335: sin(67.7581787)
   0.9256308305098727200000000000f,   // 12336: sin(67.7636719)
   0.9256671075623097400000000000f,   // 12337: sin(67.7691650)
   0.9257033761062131200000000000f,   // 12338: sin(67.7746582)
   0.9257396361412499900000000000f,   // 12339: sin(67.7801514)
   0.9257758876670867400000000000f,   // 12340: sin(67.7856445)
   0.9258121306833901900000000000f,   // 12341: sin(67.7911377)
   0.9258483651898272700000000000f,   // 12342: sin(67.7966309)
   0.9258845911860648100000000000f,   // 12343: sin(67.8021240)
   0.9259208086717699600000000000f,   // 12344: sin(67.8076172)
   0.9259570176466097600000000000f,   // 12345: sin(67.8131104)
   0.9259932181102514800000000000f,   // 12346: sin(67.8186035)
   0.9260294100623621700000000000f,   // 12347: sin(67.8240967)
   0.9260655935026093100000000000f,   // 12348: sin(67.8295898)
   0.9261017684306602800000000000f,   // 12349: sin(67.8350830)
   0.9261379348461825600000000000f,   // 12350: sin(67.8405762)
   0.9261740927488436600000000000f,   // 12351: sin(67.8460693)
   0.9262102421383112700000000000f,   // 12352: sin(67.8515625)
   0.9262463830142532200000000000f,   // 12353: sin(67.8570557)
   0.9262825153763372100000000000f,   // 12354: sin(67.8625488)
   0.9263186392242310800000000000f,   // 12355: sin(67.8680420)
   0.9263547545576028600000000000f,   // 12356: sin(67.8735352)
   0.9263908613761204800000000000f,   // 12357: sin(67.8790283)
   0.9264269596794521000000000000f,   // 12358: sin(67.8845215)
   0.9264630494672661000000000000f,   // 12359: sin(67.8900146)
   0.9264991307392305100000000000f,   // 12360: sin(67.8955078)
   0.9265352034950137300000000000f,   // 12361: sin(67.9010010)
   0.9265712677342842200000000000f,   // 12362: sin(67.9064941)
   0.9266073234567106000000000000f,   // 12363: sin(67.9119873)
   0.9266433706619612300000000000f,   // 12364: sin(67.9174805)
   0.9266794093497048300000000000f,   // 12365: sin(67.9229736)
   0.9267154395196103300000000000f,   // 12366: sin(67.9284668)
   0.9267514611713463200000000000f,   // 12367: sin(67.9339600)
   0.9267874743045817500000000000f,   // 12368: sin(67.9394531)
   0.9268234789189857500000000000f,   // 12369: sin(67.9449463)
   0.9268594750142271600000000000f,   // 12370: sin(67.9504395)
   0.9268954625899751300000000000f,   // 12371: sin(67.9559326)
   0.9269314416458991300000000000f,   // 12372: sin(67.9614258)
   0.9269674121816681200000000000f,   // 12373: sin(67.9669189)
   0.9270033741969516700000000000f,   // 12374: sin(67.9724121)
   0.9270393276914191700000000000f,   // 12375: sin(67.9779053)
   0.9270752726647401000000000000f,   // 12376: sin(67.9833984)
   0.9271112091165841800000000000f,   // 12377: sin(67.9888916)
   0.9271471370466208800000000000f,   // 12378: sin(67.9943848)
   0.9271830564545201500000000000f,   // 12379: sin(67.9998779)
   0.9272189673399517900000000000f,   // 12380: sin(68.0053711)
   0.9272548697025856400000000000f,   // 12381: sin(68.0108643)
   0.9272907635420917200000000000f,   // 12382: sin(68.0163574)
   0.9273266488581402000000000000f,   // 12383: sin(68.0218506)
   0.9273625256504011100000000000f,   // 12384: sin(68.0273438)
   0.9273983939185446200000000000f,   // 12385: sin(68.0328369)
   0.9274342536622413000000000000f,   // 12386: sin(68.0383301)
   0.9274701048811613300000000000f,   // 12387: sin(68.0438232)
   0.9275059475749751800000000000f,   // 12388: sin(68.0493164)
   0.9275417817433534400000000000f,   // 12389: sin(68.0548096)
   0.9275776073859667300000000000f,   // 12390: sin(68.0603027)
   0.9276134245024857400000000000f,   // 12391: sin(68.0657959)
   0.9276492330925811800000000000f,   // 12392: sin(68.0712891)
   0.9276850331559239900000000000f,   // 12393: sin(68.0767822)
   0.9277208246921852000000000000f,   // 12394: sin(68.0822754)
   0.9277566077010355200000000000f,   // 12395: sin(68.0877686)
   0.9277923821821463200000000000f,   // 12396: sin(68.0932617)
   0.9278281481351886600000000000f,   // 12397: sin(68.0987549)
   0.9278639055598337800000000000f,   // 12398: sin(68.1042480)
   0.9278996544557530600000000000f,   // 12399: sin(68.1097412)
   0.9279353948226178900000000000f,   // 12400: sin(68.1152344)
   0.9279711266600996200000000000f,   // 12401: sin(68.1207275)
   0.9280068499678699700000000000f,   // 12402: sin(68.1262207)
   0.9280425647456005400000000000f,   // 12403: sin(68.1317139)
   0.9280782709929631400000000000f,   // 12404: sin(68.1372070)
   0.9281139687096292600000000000f,   // 12405: sin(68.1427002)
   0.9281496578952711500000000000f,   // 12406: sin(68.1481934)
   0.9281853385495605300000000000f,   // 12407: sin(68.1536865)
   0.9282210106721694400000000000f,   // 12408: sin(68.1591797)
   0.9282566742627700300000000000f,   // 12409: sin(68.1646729)
   0.9282923293210345600000000000f,   // 12410: sin(68.1701660)
   0.9283279758466352900000000000f,   // 12411: sin(68.1756592)
   0.9283636138392443700000000000f,   // 12412: sin(68.1811523)
   0.9283992432985345200000000000f,   // 12413: sin(68.1866455)
   0.9284348642241779800000000000f,   // 12414: sin(68.1921387)
   0.9284704766158473600000000000f,   // 12415: sin(68.1976318)
   0.9285060804732154800000000000f,   // 12416: sin(68.2031250)
   0.9285416757959550300000000000f,   // 12417: sin(68.2086182)
   0.9285772625837388500000000000f,   // 12418: sin(68.2141113)
   0.9286128408362396300000000000f,   // 12419: sin(68.2196045)
   0.9286484105531305200000000000f,   // 12420: sin(68.2250977)
   0.9286839717340845700000000000f,   // 12421: sin(68.2305908)
   0.9287195243787747000000000000f,   // 12422: sin(68.2360840)
   0.9287550684868745000000000000f,   // 12423: sin(68.2415771)
   0.9287906040580570200000000000f,   // 12424: sin(68.2470703)
   0.9288261310919956300000000000f,   // 12425: sin(68.2525635)
   0.9288616495883637000000000000f,   // 12426: sin(68.2580566)
   0.9288971595468349400000000000f,   // 12427: sin(68.2635498)
   0.9289326609670828200000000000f,   // 12428: sin(68.2690430)
   0.9289681538487809500000000000f,   // 12429: sin(68.2745361)
   0.9290036381916033600000000000f,   // 12430: sin(68.2800293)
   0.9290391139952236500000000000f,   // 12431: sin(68.2855225)
   0.9290745812593157500000000000f,   // 12432: sin(68.2910156)
   0.9291100399835537900000000000f,   // 12433: sin(68.2965088)
   0.9291454901676117200000000000f,   // 12434: sin(68.3020020)
   0.9291809318111637900000000000f,   // 12435: sin(68.3074951)
   0.9292163649138839300000000000f,   // 12436: sin(68.3129883)
   0.9292517894754469500000000000f,   // 12437: sin(68.3184814)
   0.9292872054955267900000000000f,   // 12438: sin(68.3239746)
   0.9293226129737981500000000000f,   // 12439: sin(68.3294678)
   0.9293580119099355000000000000f,   // 12440: sin(68.3349609)
   0.9293934023036135600000000000f,   // 12441: sin(68.3404541)
   0.9294287841545068000000000000f,   // 12442: sin(68.3459473)
   0.9294641574622901600000000000f,   // 12443: sin(68.3514404)
   0.9294995222266385600000000000f,   // 12444: sin(68.3569336)
   0.9295348784472268200000000000f,   // 12445: sin(68.3624268)
   0.9295702261237298600000000000f,   // 12446: sin(68.3679199)
   0.9296055652558229400000000000f,   // 12447: sin(68.3734131)
   0.9296408958431813300000000000f,   // 12448: sin(68.3789063)
   0.9296762178854799400000000000f,   // 12449: sin(68.3843994)
   0.9297115313823943700000000000f,   // 12450: sin(68.3898926)
   0.9297468363335998900000000000f,   // 12451: sin(68.3953857)
   0.9297821327387721900000000000f,   // 12452: sin(68.4008789)
   0.9298174205975865400000000000f,   // 12453: sin(68.4063721)
   0.9298526999097187500000000000f,   // 12454: sin(68.4118652)
   0.9298879706748445200000000000f,   // 12455: sin(68.4173584)
   0.9299232328926395600000000000f,   // 12456: sin(68.4228516)
   0.9299584865627800200000000000f,   // 12457: sin(68.4283447)
   0.9299937316849414800000000000f,   // 12458: sin(68.4338379)
   0.9300289682588002100000000000f,   // 12459: sin(68.4393311)
   0.9300641962840323600000000000f,   // 12460: sin(68.4448242)
   0.9300994157603139600000000000f,   // 12461: sin(68.4503174)
   0.9301346266873213900000000000f,   // 12462: sin(68.4558105)
   0.9301698290647308900000000000f,   // 12463: sin(68.4613037)
   0.9302050228922190700000000000f,   // 12464: sin(68.4667969)
   0.9302402081694622900000000000f,   // 12465: sin(68.4722900)
   0.9302753848961370400000000000f,   // 12466: sin(68.4777832)
   0.9303105530719202300000000000f,   // 12467: sin(68.4832764)
   0.9303457126964884700000000000f,   // 12468: sin(68.4887695)
   0.9303808637695186700000000000f,   // 12469: sin(68.4942627)
   0.9304160062906875500000000000f,   // 12470: sin(68.4997559)
   0.9304511402596722400000000000f,   // 12471: sin(68.5052490)
   0.9304862656761497800000000000f,   // 12472: sin(68.5107422)
   0.9305213825397971000000000000f,   // 12473: sin(68.5162354)
   0.9305564908502918000000000000f,   // 12474: sin(68.5217285)
   0.9305915906073107800000000000f,   // 12475: sin(68.5272217)
   0.9306266818105316500000000000f,   // 12476: sin(68.5327148)
   0.9306617644596318900000000000f,   // 12477: sin(68.5382080)
   0.9306968385542888600000000000f,   // 12478: sin(68.5437012)
   0.9307319040941802700000000000f,   // 12479: sin(68.5491943)
   0.9307669610789837100000000000f,   // 12480: sin(68.5546875)
   0.9308020095083771000000000000f,   // 12481: sin(68.5601807)
   0.9308370493820381500000000000f,   // 12482: sin(68.5656738)
   0.9308720806996447800000000000f,   // 12483: sin(68.5711670)
   0.9309071034608750200000000000f,   // 12484: sin(68.5766602)
   0.9309421176654071300000000000f,   // 12485: sin(68.5821533)
   0.9309771233129189300000000000f,   // 12486: sin(68.5876465)
   0.9310121204030888900000000000f,   // 12487: sin(68.5931396)
   0.9310471089355951700000000000f,   // 12488: sin(68.5986328)
   0.9310820889101164600000000000f,   // 12489: sin(68.6041260)
   0.9311170603263307900000000000f,   // 12490: sin(68.6096191)
   0.9311520231839171000000000000f,   // 12491: sin(68.6151123)
   0.9311869774825537500000000000f,   // 12492: sin(68.6206055)
   0.9312219232219195500000000000f,   // 12493: sin(68.6260986)
   0.9312568604016934200000000000f,   // 12494: sin(68.6315918)
   0.9312917890215540700000000000f,   // 12495: sin(68.6370850)
   0.9313267090811804300000000000f,   // 12496: sin(68.6425781)
   0.9313616205802515100000000000f,   // 12497: sin(68.6480713)
   0.9313965235184466000000000000f,   // 12498: sin(68.6535645)
   0.9314314178954447000000000000f,   // 12499: sin(68.6590576)
   0.9314663037109250900000000000f,   // 12500: sin(68.6645508)
   0.9315011809645671300000000000f,   // 12501: sin(68.6700439)
   0.9315360496560503000000000000f,   // 12502: sin(68.6755371)
   0.9315709097850539700000000000f,   // 12503: sin(68.6810303)
   0.9316057613512578300000000000f,   // 12504: sin(68.6865234)
   0.9316406043543414800000000000f,   // 12505: sin(68.6920166)
   0.9316754387939846200000000000f,   // 12506: sin(68.6975098)
   0.9317102646698669500000000000f,   // 12507: sin(68.7030029)
   0.9317450819816687200000000000f,   // 12508: sin(68.7084961)
   0.9317798907290696400000000000f,   // 12509: sin(68.7139893)
   0.9318146909117496200000000000f,   // 12510: sin(68.7194824)
   0.9318494825293890400000000000f,   // 12511: sin(68.7249756)
   0.9318842655816681500000000000f,   // 12512: sin(68.7304688)
   0.9319190400682669800000000000f,   // 12513: sin(68.7359619)
   0.9319538059888659000000000000f,   // 12514: sin(68.7414551)
   0.9319885633431456200000000000f,   // 12515: sin(68.7469482)
   0.9320233121307864900000000000f,   // 12516: sin(68.7524414)
   0.9320580523514689900000000000f,   // 12517: sin(68.7579346)
   0.9320927840048740500000000000f,   // 12518: sin(68.7634277)
   0.9321275070906822600000000000f,   // 12519: sin(68.7689209)
   0.9321622216085743200000000000f,   // 12520: sin(68.7744141)
   0.9321969275582314700000000000f,   // 12521: sin(68.7799072)
   0.9322316249393345400000000000f,   // 12522: sin(68.7854004)
   0.9322663137515646600000000000f,   // 12523: sin(68.7908936)
   0.9323009939946026400000000000f,   // 12524: sin(68.7963867)
   0.9323356656681302000000000000f,   // 12525: sin(68.8018799)
   0.9323703287718284600000000000f,   // 12526: sin(68.8073730)
   0.9324049833053785800000000000f,   // 12527: sin(68.8128662)
   0.9324396292684623600000000000f,   // 12528: sin(68.8183594)
   0.9324742666607611600000000000f,   // 12529: sin(68.8238525)
   0.9325088954819567000000000000f,   // 12530: sin(68.8293457)
   0.9325435157317304400000000000f,   // 12531: sin(68.8348389)
   0.9325781274097644200000000000f,   // 12532: sin(68.8403320)
   0.9326127305157404500000000000f,   // 12533: sin(68.8458252)
   0.9326473250493403400000000000f,   // 12534: sin(68.8513184)
   0.9326819110102462200000000000f,   // 12535: sin(68.8568115)
   0.9327164883981402500000000000f,   // 12536: sin(68.8623047)
   0.9327510572127043500000000000f,   // 12537: sin(68.8677979)
   0.9327856174536209900000000000f,   // 12538: sin(68.8732910)
   0.9328201691205725300000000000f,   // 12539: sin(68.8787842)
   0.9328547122132412300000000000f,   // 12540: sin(68.8842773)
   0.9328892467313094600000000000f,   // 12541: sin(68.8897705)
   0.9329237726744601400000000000f,   // 12542: sin(68.8952637)
   0.9329582900423757400000000000f,   // 12543: sin(68.9007568)
   0.9329927988347388500000000000f,   // 12544: sin(68.9062500)
   0.9330272990512324900000000000f,   // 12545: sin(68.9117432)
   0.9330617906915393800000000000f,   // 12546: sin(68.9172363)
   0.9330962737553425400000000000f,   // 12547: sin(68.9227295)
   0.9331307482423251100000000000f,   // 12548: sin(68.9282227)
   0.9331652141521701300000000000f,   // 12549: sin(68.9337158)
   0.9331996714845607300000000000f,   // 12550: sin(68.9392090)
   0.9332341202391801800000000000f,   // 12551: sin(68.9447021)
   0.9332685604157120500000000000f,   // 12552: sin(68.9501953)
   0.9333029920138394800000000000f,   // 12553: sin(68.9556885)
   0.9333374150332460800000000000f,   // 12554: sin(68.9611816)
   0.9333718294736156300000000000f,   // 12555: sin(68.9666748)
   0.9334062353346315200000000000f,   // 12556: sin(68.9721680)
   0.9334406326159777600000000000f,   // 12557: sin(68.9776611)
   0.9334750213173379500000000000f,   // 12558: sin(68.9831543)
   0.9335094014383961100000000000f,   // 12559: sin(68.9886475)
   0.9335437729788361700000000000f,   // 12560: sin(68.9941406)
   0.9335781359383422700000000000f,   // 12561: sin(68.9996338)
   0.9336124903165985400000000000f,   // 12562: sin(69.0051270)
   0.9336468361132891400000000000f,   // 12563: sin(69.0106201)
   0.9336811733280983000000000000f,   // 12564: sin(69.0161133)
   0.9337155019607107400000000000f,   // 12565: sin(69.0216064)
   0.9337498220108105800000000000f,   // 12566: sin(69.0270996)
   0.9337841334780824200000000000f,   // 12567: sin(69.0325928)
   0.9338184363622109600000000000f,   // 12568: sin(69.0380859)
   0.9338527306628807700000000000f,   // 12569: sin(69.0435791)
   0.9338870163797768900000000000f,   // 12570: sin(69.0490723)
   0.9339212935125837900000000000f,   // 12571: sin(69.0545654)
   0.9339555620609867300000000000f,   // 12572: sin(69.0600586)
   0.9339898220246706200000000000f,   // 12573: sin(69.0655518)
   0.9340240734033205000000000000f,   // 12574: sin(69.0710449)
   0.9340583161966213900000000000f,   // 12575: sin(69.0765381)
   0.9340925504042588700000000000f,   // 12576: sin(69.0820313)
   0.9341267760259180900000000000f,   // 12577: sin(69.0875244)
   0.9341609930612844200000000000f,   // 12578: sin(69.0930176)
   0.9341952015100435400000000000f,   // 12579: sin(69.0985107)
   0.9342294013718808200000000000f,   // 12580: sin(69.1040039)
   0.9342635926464818400000000000f,   // 12581: sin(69.1094971)
   0.9342977753335325300000000000f,   // 12582: sin(69.1149902)
   0.9343319494327185800000000000f,   // 12583: sin(69.1204834)
   0.9343661149437259000000000000f,   // 12584: sin(69.1259766)
   0.9344002718662403100000000000f,   // 12585: sin(69.1314697)
   0.9344344201999480500000000000f,   // 12586: sin(69.1369629)
   0.9344685599445351500000000000f,   // 12587: sin(69.1424561)
   0.9345026910996878700000000000f,   // 12588: sin(69.1479492)
   0.9345368136650923400000000000f,   // 12589: sin(69.1534424)
   0.9345709276404350300000000000f,   // 12590: sin(69.1589355)
   0.9346050330254023200000000000f,   // 12591: sin(69.1644287)
   0.9346391298196807800000000000f,   // 12592: sin(69.1699219)
   0.9346732180229568900000000000f,   // 12593: sin(69.1754150)
   0.9347072976349174400000000000f,   // 12594: sin(69.1809082)
   0.9347413686552490400000000000f,   // 12595: sin(69.1864014)
   0.9347754310836387000000000000f,   // 12596: sin(69.1918945)
   0.9348094849197732300000000000f,   // 12597: sin(69.1973877)
   0.9348435301633394300000000000f,   // 12598: sin(69.2028809)
   0.9348775668140247900000000000f,   // 12599: sin(69.2083740)
   0.9349115948715160900000000000f,   // 12600: sin(69.2138672)
   0.9349456143355006100000000000f,   // 12601: sin(69.2193604)
   0.9349796252056658000000000000f,   // 12602: sin(69.2248535)
   0.9350136274816989200000000000f,   // 12603: sin(69.2303467)
   0.9350476211632874300000000000f,   // 12604: sin(69.2358398)
   0.9350816062501188200000000000f,   // 12605: sin(69.2413330)
   0.9351155827418808900000000000f,   // 12606: sin(69.2468262)
   0.9351495506382612200000000000f,   // 12607: sin(69.2523193)
   0.9351835099389475000000000000f,   // 12608: sin(69.2578125)
   0.9352174606436277600000000000f,   // 12609: sin(69.2633057)
   0.9352514027519898100000000000f,   // 12610: sin(69.2687988)
   0.9352853362637217900000000000f,   // 12611: sin(69.2742920)
   0.9353192611785115000000000000f,   // 12612: sin(69.2797852)
   0.9353531774960475200000000000f,   // 12613: sin(69.2852783)
   0.9353870852160177700000000000f,   // 12614: sin(69.2907715)
   0.9354209843381106100000000000f,   // 12615: sin(69.2962646)
   0.9354548748620146200000000000f,   // 12616: sin(69.3017578)
   0.9354887567874182700000000000f,   // 12617: sin(69.3072510)
   0.9355226301140099300000000000f,   // 12618: sin(69.3127441)
   0.9355564948414784000000000000f,   // 12619: sin(69.3182373)
   0.9355903509695123700000000000f,   // 12620: sin(69.3237305)
   0.9356241984978006500000000000f,   // 12621: sin(69.3292236)
   0.9356580374260320400000000000f,   // 12622: sin(69.3347168)
   0.9356918677538955700000000000f,   // 12623: sin(69.3402100)
   0.9357256894810803700000000000f,   // 12624: sin(69.3457031)
   0.9357595026072753600000000000f,   // 12625: sin(69.3511963)
   0.9357933071321699000000000000f,   // 12626: sin(69.3566895)
   0.9358271030554532500000000000f,   // 12627: sin(69.3621826)
   0.9358608903768146400000000000f,   // 12628: sin(69.3676758)
   0.9358946690959435400000000000f,   // 12629: sin(69.3731689)
   0.9359284392125296600000000000f,   // 12630: sin(69.3786621)
   0.9359622007262623500000000000f,   // 12631: sin(69.3841553)
   0.9359959536368313000000000000f,   // 12632: sin(69.3896484)
   0.9360296979439264300000000000f,   // 12633: sin(69.3951416)
   0.9360634336472375400000000000f,   // 12634: sin(69.4006348)
   0.9360971607464543300000000000f,   // 12635: sin(69.4061279)
   0.9361308792412669200000000000f,   // 12636: sin(69.4116211)
   0.9361645891313655800000000000f,   // 12637: sin(69.4171143)
   0.9361982904164400900000000000f,   // 12638: sin(69.4226074)
   0.9362319830961808300000000000f,   // 12639: sin(69.4281006)
   0.9362656671702782600000000000f,   // 12640: sin(69.4335938)
   0.9362993426384225200000000000f,   // 12641: sin(69.4390869)
   0.9363330095003041800000000000f,   // 12642: sin(69.4445801)
   0.9363666677556138400000000000f,   // 12643: sin(69.4500732)
   0.9364003174040420600000000000f,   // 12644: sin(69.4555664)
   0.9364339584452794400000000000f,   // 12645: sin(69.4610596)
   0.9364675908790168800000000000f,   // 12646: sin(69.4665527)
   0.9365012147049453000000000000f,   // 12647: sin(69.4720459)
   0.9365348299227555000000000000f,   // 12648: sin(69.4775391)
   0.9365684365321385000000000000f,   // 12649: sin(69.4830322)
   0.9366020345327855700000000000f,   // 12650: sin(69.4885254)
   0.9366356239243877100000000000f,   // 12651: sin(69.4940186)
   0.9366692047066360600000000000f,   // 12652: sin(69.4995117)
   0.9367027768792223200000000000f,   // 12653: sin(69.5050049)
   0.9367363404418376200000000000f,   // 12654: sin(69.5104980)
   0.9367698953941735500000000000f,   // 12655: sin(69.5159912)
   0.9368034417359215600000000000f,   // 12656: sin(69.5214844)
   0.9368369794667734700000000000f,   // 12657: sin(69.5269775)
   0.9368705085864209600000000000f,   // 12658: sin(69.5324707)
   0.9369040290945557200000000000f,   // 12659: sin(69.5379639)
   0.9369375409908699000000000000f,   // 12660: sin(69.5434570)
   0.9369710442750551800000000000f,   // 12661: sin(69.5489502)
   0.9370045389468036900000000000f,   // 12662: sin(69.5544434)
   0.9370380250058075700000000000f,   // 12663: sin(69.5599365)
   0.9370715024517591900000000000f,   // 12664: sin(69.5654297)
   0.9371049712843505500000000000f,   // 12665: sin(69.5709229)
   0.9371384315032741400000000000f,   // 12666: sin(69.5764160)
   0.9371718831082224100000000000f,   // 12667: sin(69.5819092)
   0.9372053260988879600000000000f,   // 12668: sin(69.5874023)
   0.9372387604749631300000000000f,   // 12669: sin(69.5928955)
   0.9372721862361409500000000000f,   // 12670: sin(69.5983887)
   0.9373056033821138800000000000f,   // 12671: sin(69.6038818)
   0.9373390119125749600000000000f,   // 12672: sin(69.6093750)
   0.9373724118272168700000000000f,   // 12673: sin(69.6148682)
   0.9374058031257328500000000000f,   // 12674: sin(69.6203613)
   0.9374391858078159300000000000f,   // 12675: sin(69.6258545)
   0.9374725598731591400000000000f,   // 12676: sin(69.6313477)
   0.9375059253214558200000000000f,   // 12677: sin(69.6368408)
   0.9375392821523992300000000000f,   // 12678: sin(69.6423340)
   0.9375726303656828400000000000f,   // 12679: sin(69.6478271)
   0.9376059699609999900000000000f,   // 12680: sin(69.6533203)
   0.9376393009380443700000000000f,   // 12681: sin(69.6588135)
   0.9376726232965094700000000000f,   // 12682: sin(69.6643066)
   0.9377059370360889500000000000f,   // 12683: sin(69.6697998)
   0.9377392421564769700000000000f,   // 12684: sin(69.6752930)
   0.9377725386573669800000000000f,   // 12685: sin(69.6807861)
   0.9378058265384530100000000000f,   // 12686: sin(69.6862793)
   0.9378391057994293100000000000f,   // 12687: sin(69.6917725)
   0.9378723764399898900000000000f,   // 12688: sin(69.6972656)
   0.9379056384598287700000000000f,   // 12689: sin(69.7027588)
   0.9379388918586402100000000000f,   // 12690: sin(69.7082520)
   0.9379721366361188900000000000f,   // 12691: sin(69.7137451)
   0.9380053727919588400000000000f,   // 12692: sin(69.7192383)
   0.9380386003258547300000000000f,   // 12693: sin(69.7247314)
   0.9380718192375011600000000000f,   // 12694: sin(69.7302246)
   0.9381050295265928000000000000f,   // 12695: sin(69.7357178)
   0.9381382311928243600000000000f,   // 12696: sin(69.7412109)
   0.9381714242358906200000000000f,   // 12697: sin(69.7467041)
   0.9382046086554864900000000000f,   // 12698: sin(69.7521973)
   0.9382377844513070100000000000f,   // 12699: sin(69.7576904)
   0.9382709516230470800000000000f,   // 12700: sin(69.7631836)
   0.9383041101704020500000000000f,   // 12701: sin(69.7686768)
   0.9383372600930669500000000000f,   // 12702: sin(69.7741699)
   0.9383704013907371300000000000f,   // 12703: sin(69.7796631)
   0.9384035340631080600000000000f,   // 12704: sin(69.7851563)
   0.9384366581098750900000000000f,   // 12705: sin(69.7906494)
   0.9384697735307338000000000000f,   // 12706: sin(69.7961426)
   0.9385028803253796500000000000f,   // 12707: sin(69.8016357)
   0.9385359784935085600000000000f,   // 12708: sin(69.8071289)
   0.9385690680348162100000000000f,   // 12709: sin(69.8126221)
   0.9386021489489982900000000000f,   // 12710: sin(69.8181152)
   0.9386352212357510500000000000f,   // 12711: sin(69.8236084)
   0.9386682848947701700000000000f,   // 12712: sin(69.8291016)
   0.9387013399257518900000000000f,   // 12713: sin(69.8345947)
   0.9387343863283924600000000000f,   // 12714: sin(69.8400879)
   0.9387674241023878900000000000f,   // 12715: sin(69.8455811)
   0.9388004532474347700000000000f,   // 12716: sin(69.8510742)
   0.9388334737632292300000000000f,   // 12717: sin(69.8565674)
   0.9388664856494680600000000000f,   // 12718: sin(69.8620605)
   0.9388994889058476200000000000f,   // 12719: sin(69.8675537)
   0.9389324835320644900000000000f,   // 12720: sin(69.8730469)
   0.9389654695278155700000000000f,   // 12721: sin(69.8785400)
   0.9389984468927975400000000000f,   // 12722: sin(69.8840332)
   0.9390314156267073300000000000f,   // 12723: sin(69.8895264)
   0.9390643757292419500000000000f,   // 12724: sin(69.8950195)
   0.9390973272000983100000000000f,   // 12725: sin(69.9005127)
   0.9391302700389736500000000000f,   // 12726: sin(69.9060059)
   0.9391632042455649900000000000f,   // 12727: sin(69.9114990)
   0.9391961298195699000000000000f,   // 12728: sin(69.9169922)
   0.9392290467606854200000000000f,   // 12729: sin(69.9224854)
   0.9392619550686091000000000000f,   // 12730: sin(69.9279785)
   0.9392948547430386400000000000f,   // 12731: sin(69.9334717)
   0.9393277457836714000000000000f,   // 12732: sin(69.9389648)
   0.9393606281902051600000000000f,   // 12733: sin(69.9444580)
   0.9393935019623375100000000000f,   // 12734: sin(69.9499512)
   0.9394263670997664600000000000f,   // 12735: sin(69.9554443)
   0.9394592236021899200000000000f,   // 12736: sin(69.9609375)
   0.9394920714693058000000000000f,   // 12737: sin(69.9664307)
   0.9395249107008121200000000000f,   // 12738: sin(69.9719238)
   0.9395577412964072300000000000f,   // 12739: sin(69.9774170)
   0.9395905632557891600000000000f,   // 12740: sin(69.9829102)
   0.9396233765786563600000000000f,   // 12741: sin(69.9884033)
   0.9396561812647070700000000000f,   // 12742: sin(69.9938965)
   0.9396889773136399800000000000f,   // 12743: sin(69.9993896)
   0.9397217647251533400000000000f,   // 12744: sin(70.0048828)
   0.9397545434989459400000000000f,   // 12745: sin(70.0103760)
   0.9397873136347165700000000000f,   // 12746: sin(70.0158691)
   0.9398200751321638100000000000f,   // 12747: sin(70.0213623)
   0.9398528279909866800000000000f,   // 12748: sin(70.0268555)
   0.9398855722108840900000000000f,   // 12749: sin(70.0323486)
   0.9399183077915550500000000000f,   // 12750: sin(70.0378418)
   0.9399510347326985900000000000f,   // 12751: sin(70.0433350)
   0.9399837530340139400000000000f,   // 12752: sin(70.0488281)
   0.9400164626952004500000000000f,   // 12753: sin(70.0543213)
   0.9400491637159573700000000000f,   // 12754: sin(70.0598145)
   0.9400818560959841600000000000f,   // 12755: sin(70.0653076)
   0.9401145398349802800000000000f,   // 12756: sin(70.0708008)
   0.9401472149326451900000000000f,   // 12757: sin(70.0762939)
   0.9401798813886788100000000000f,   // 12758: sin(70.0817871)
   0.9402125392027808100000000000f,   // 12759: sin(70.0872803)
   0.9402451883746508800000000000f,   // 12760: sin(70.0927734)
   0.9402778289039889200000000000f,   // 12761: sin(70.0982666)
   0.9403104607904950700000000000f,   // 12762: sin(70.1037598)
   0.9403430840338692400000000000f,   // 12763: sin(70.1092529)
   0.9403756986338115400000000000f,   // 12764: sin(70.1147461)
   0.9404083045900222300000000000f,   // 12765: sin(70.1202393)
   0.9404409019022017500000000000f,   // 12766: sin(70.1257324)
   0.9404734905700502500000000000f,   // 12767: sin(70.1312256)
   0.9405060705932683000000000000f,   // 12768: sin(70.1367188)
   0.9405386419715564500000000000f,   // 12769: sin(70.1422119)
   0.9405712047046151900000000000f,   // 12770: sin(70.1477051)
   0.9406037587921453100000000000f,   // 12771: sin(70.1531982)
   0.9406363042338475900000000000f,   // 12772: sin(70.1586914)
   0.9406688410294228300000000000f,   // 12773: sin(70.1641846)
   0.9407013691785719400000000000f,   // 12774: sin(70.1696777)
   0.9407338886809959400000000000f,   // 12775: sin(70.1751709)
   0.9407663995363960700000000000f,   // 12776: sin(70.1806641)
   0.9407989017444733400000000000f,   // 12777: sin(70.1861572)
   0.9408313953049288700000000000f,   // 12778: sin(70.1916504)
   0.9408638802174642500000000000f,   // 12779: sin(70.1971436)
   0.9408963564817808300000000000f,   // 12780: sin(70.2026367)
   0.9409288240975799400000000000f,   // 12781: sin(70.2081299)
   0.9409612830645632800000000000f,   // 12782: sin(70.2136230)
   0.9409937333824325300000000000f,   // 12783: sin(70.2191162)
   0.9410261750508892600000000000f,   // 12784: sin(70.2246094)
   0.9410586080696353700000000000f,   // 12785: sin(70.2301025)
   0.9410910324383727800000000000f,   // 12786: sin(70.2355957)
   0.9411234481568033800000000000f,   // 12787: sin(70.2410889)
   0.9411558552246291900000000000f,   // 12788: sin(70.2465820)
   0.9411882536415523400000000000f,   // 12789: sin(70.2520752)
   0.9412206434072751800000000000f,   // 12790: sin(70.2575684)
   0.9412530245214998400000000000f,   // 12791: sin(70.2630615)
   0.9412853969839286600000000000f,   // 12792: sin(70.2685547)
   0.9413177607942642100000000000f,   // 12793: sin(70.2740479)
   0.9413501159522089700000000000f,   // 12794: sin(70.2795410)
   0.9413824624574653700000000000f,   // 12795: sin(70.2850342)
   0.9414148003097362300000000000f,   // 12796: sin(70.2905273)
   0.9414471295087244500000000000f,   // 12797: sin(70.2960205)
   0.9414794500541325800000000000f,   // 12798: sin(70.3015137)
   0.9415117619456636600000000000f,   // 12799: sin(70.3070068)
   0.9415440651830208100000000000f,   // 12800: sin(70.3125000)
   0.9415763597659068100000000000f,   // 12801: sin(70.3179932)
   0.9416086456940251400000000000f,   // 12802: sin(70.3234863)
   0.9416409229670789100000000000f,   // 12803: sin(70.3289795)
   0.9416731915847713600000000000f,   // 12804: sin(70.3344727)
   0.9417054515468059600000000000f,   // 12805: sin(70.3399658)
   0.9417377028528861600000000000f,   // 12806: sin(70.3454590)
   0.9417699455027155300000000000f,   // 12807: sin(70.3509521)
   0.9418021794959976500000000000f,   // 12808: sin(70.3564453)
   0.9418344048324363000000000000f,   // 12809: sin(70.3619385)
   0.9418666215117352800000000000f,   // 12810: sin(70.3674316)
   0.9418988295335983800000000000f,   // 12811: sin(70.3729248)
   0.9419310288977295100000000000f,   // 12812: sin(70.3784180)
   0.9419632196038328900000000000f,   // 12813: sin(70.3839111)
   0.9419954016516125500000000000f,   // 12814: sin(70.3894043)
   0.9420275750407725000000000000f,   // 12815: sin(70.3948975)
   0.9420597397710173100000000000f,   // 12816: sin(70.4003906)
   0.9420918958420512200000000000f,   // 12817: sin(70.4058838)
   0.9421240432535784600000000000f,   // 12818: sin(70.4113770)
   0.9421561820053038200000000000f,   // 12819: sin(70.4168701)
   0.9421883120969317700000000000f,   // 12820: sin(70.4223633)
   0.9422204335281669800000000000f,   // 12821: sin(70.4278564)
   0.9422525462987140200000000000f,   // 12822: sin(70.4333496)
   0.9422846504082780200000000000f,   // 12823: sin(70.4388428)
   0.9423167458565637800000000000f,   // 12824: sin(70.4443359)
   0.9423488326432761800000000000f,   // 12825: sin(70.4498291)
   0.9423809107681204700000000000f,   // 12826: sin(70.4553223)
   0.9424129802308015600000000000f,   // 12827: sin(70.4608154)
   0.9424450410310248900000000000f,   // 12828: sin(70.4663086)
   0.9424770931684955900000000000f,   // 12829: sin(70.4718018)
   0.9425091366429192400000000000f,   // 12830: sin(70.4772949)
   0.9425411714540011800000000000f,   // 12831: sin(70.4827881)
   0.9425731976014468700000000000f,   // 12832: sin(70.4882813)
   0.9426052150849620900000000000f,   // 12833: sin(70.4937744)
   0.9426372239042525300000000000f,   // 12834: sin(70.4992676)
   0.9426692240590237600000000000f,   // 12835: sin(70.5047607)
   0.9427012155489819000000000000f,   // 12836: sin(70.5102539)
   0.9427331983738328500000000000f,   // 12837: sin(70.5157471)
   0.9427651725332825100000000000f,   // 12838: sin(70.5212402)
   0.9427971380270370200000000000f,   // 12839: sin(70.5267334)
   0.9428290948548027100000000000f,   // 12840: sin(70.5322266)
   0.9428610430162855900000000000f,   // 12841: sin(70.5377197)
   0.9428929825111921300000000000f,   // 12842: sin(70.5432129)
   0.9429249133392287900000000000f,   // 12843: sin(70.5487061)
   0.9429568355001021200000000000f,   // 12844: sin(70.5541992)
   0.9429887489935183700000000000f,   // 12845: sin(70.5596924)
   0.9430206538191846500000000000f,   // 12846: sin(70.5651855)
   0.9430525499768073200000000000f,   // 12847: sin(70.5706787)
   0.9430844374660934900000000000f,   // 12848: sin(70.5761719)
   0.9431163162867497500000000000f,   // 12849: sin(70.5816650)
   0.9431481864384834200000000000f,   // 12850: sin(70.5871582)
   0.9431800479210013000000000000f,   // 12851: sin(70.5926514)
   0.9432119007340106200000000000f,   // 12852: sin(70.5981445)
   0.9432437448772186300000000000f,   // 12853: sin(70.6036377)
   0.9432755803503325400000000000f,   // 12854: sin(70.6091309)
   0.9433074071530597200000000000f,   // 12855: sin(70.6146240)
   0.9433392252851077200000000000f,   // 12856: sin(70.6201172)
   0.9433710347461840000000000000f,   // 12857: sin(70.6256104)
   0.9434028355359962400000000000f,   // 12858: sin(70.6311035)
   0.9434346276542520100000000000f,   // 12859: sin(70.6365967)
   0.9434664111006593200000000000f,   // 12860: sin(70.6420898)
   0.9434981858749258400000000000f,   // 12861: sin(70.6475830)
   0.9435299519767593700000000000f,   // 12862: sin(70.6530762)
   0.9435617094058682500000000000f,   // 12863: sin(70.6585693)
   0.9435934581619603900000000000f,   // 12864: sin(70.6640625)
   0.9436251982447438900000000000f,   // 12865: sin(70.6695557)
   0.9436569296539271100000000000f,   // 12866: sin(70.6750488)
   0.9436886523892185100000000000f,   // 12867: sin(70.6805420)
   0.9437203664503262000000000000f,   // 12868: sin(70.6860352)
   0.9437520718369588600000000000f,   // 12869: sin(70.6915283)
   0.9437837685488250600000000000f,   // 12870: sin(70.6970215)
   0.9438154565856334800000000000f,   // 12871: sin(70.7025146)
   0.9438471359470926900000000000f,   // 12872: sin(70.7080078)
   0.9438788066329115700000000000f,   // 12873: sin(70.7135010)
   0.9439104686427991500000000000f,   // 12874: sin(70.7189941)
   0.9439421219764643200000000000f,   // 12875: sin(70.7244873)
   0.9439737666336159800000000000f,   // 12876: sin(70.7299805)
   0.9440054026139633700000000000f,   // 12877: sin(70.7354736)
   0.9440370299172158300000000000f,   // 12878: sin(70.7409668)
   0.9440686485430823700000000000f,   // 12879: sin(70.7464600)
   0.9441002584912726600000000000f,   // 12880: sin(70.7519531)
   0.9441318597614959400000000000f,   // 12881: sin(70.7574463)
   0.9441634523534617700000000000f,   // 12882: sin(70.7629395)
   0.9441950362668798400000000000f,   // 12883: sin(70.7684326)
   0.9442266115014598100000000000f,   // 12884: sin(70.7739258)
   0.9442581780569113700000000000f,   // 12885: sin(70.7794189)
   0.9442897359329444100000000000f,   // 12886: sin(70.7849121)
   0.9443212851292688300000000000f,   // 12887: sin(70.7904053)
   0.9443528256455947500000000000f,   // 12888: sin(70.7958984)
   0.9443843574816320800000000000f,   // 12889: sin(70.8013916)
   0.9444158806370912500000000000f,   // 12890: sin(70.8068848)
   0.9444473951116823000000000000f,   // 12891: sin(70.8123779)
   0.9444789009051155500000000000f,   // 12892: sin(70.8178711)
   0.9445103980171013500000000000f,   // 12893: sin(70.8233643)
   0.9445418864473503800000000000f,   // 12894: sin(70.8288574)
   0.9445733661955731900000000000f,   // 12895: sin(70.8343506)
   0.9446048372614802600000000000f,   // 12896: sin(70.8398438)
   0.9446362996447823500000000000f,   // 12897: sin(70.8453369)
   0.9446677533451904900000000000f,   // 12898: sin(70.8508301)
   0.9446991983624152300000000000f,   // 12899: sin(70.8563232)
   0.9447306346961678000000000000f,   // 12900: sin(70.8618164)
   0.9447620623461591100000000000f,   // 12901: sin(70.8673096)
   0.9447934813121002800000000000f,   // 12902: sin(70.8728027)
   0.9448248915937025300000000000f,   // 12903: sin(70.8782959)
   0.9448562931906772100000000000f,   // 12904: sin(70.8837891)
   0.9448876861027356600000000000f,   // 12905: sin(70.8892822)
   0.9449190703295892200000000000f,   // 12906: sin(70.8947754)
   0.9449504458709494500000000000f,   // 12907: sin(70.9002686)
   0.9449818127265281500000000000f,   // 12908: sin(70.9057617)
   0.9450131708960367600000000000f,   // 12909: sin(70.9112549)
   0.9450445203791870700000000000f,   // 12910: sin(70.9167480)
   0.9450758611756910900000000000f,   // 12911: sin(70.9222412)
   0.9451071932852606100000000000f,   // 12912: sin(70.9277344)
   0.9451385167076075100000000000f,   // 12913: sin(70.9332275)
   0.9451698314424441500000000000f,   // 12914: sin(70.9387207)
   0.9452011374894825300000000000f,   // 12915: sin(70.9442139)
   0.9452324348484348900000000000f,   // 12916: sin(70.9497070)
   0.9452637235190136700000000000f,   // 12917: sin(70.9552002)
   0.9452950035009311000000000000f,   // 12918: sin(70.9606934)
   0.9453262747938998600000000000f,   // 12919: sin(70.9661865)
   0.9453575373976322900000000000f,   // 12920: sin(70.9716797)
   0.9453887913118410600000000000f,   // 12921: sin(70.9771729)
   0.9454200365362390700000000000f,   // 12922: sin(70.9826660)
   0.9454512730705390000000000000f,   // 12923: sin(70.9881592)
   0.9454825009144537400000000000f,   // 12924: sin(70.9936523)
   0.9455137200676962900000000000f,   // 12925: sin(70.9991455)
   0.9455449305299796800000000000f,   // 12926: sin(71.0046387)
   0.9455761323010168900000000000f,   // 12927: sin(71.0101318)
   0.9456073253805212800000000000f,   // 12928: sin(71.0156250)
   0.9456385097682061800000000000f,   // 12929: sin(71.0211182)
   0.9456696854637847100000000000f,   // 12930: sin(71.0266113)
   0.9457008524669705500000000000f,   // 12931: sin(71.0321045)
   0.9457320107774771500000000000f,   // 12932: sin(71.0375977)
   0.9457631603950179500000000000f,   // 12933: sin(71.0430908)
   0.9457943013193068600000000000f,   // 12934: sin(71.0485840)
   0.9458254335500575500000000000f,   // 12935: sin(71.0540771)
   0.9458565570869839100000000000f,   // 12936: sin(71.0595703)
   0.9458876719297997200000000000f,   // 12937: sin(71.0650635)
   0.9459187780782191100000000000f,   // 12938: sin(71.0705566)
   0.9459498755319560900000000000f,   // 12939: sin(71.0760498)
   0.9459809642907247600000000000f,   // 12940: sin(71.0815430)
   0.9460120443542394700000000000f,   // 12941: sin(71.0870361)
   0.9460431157222145600000000000f,   // 12942: sin(71.0925293)
   0.9460741783943644700000000000f,   // 12943: sin(71.0980225)
   0.9461052323704033400000000000f,   // 12944: sin(71.1035156)
   0.9461362776500461500000000000f,   // 12945: sin(71.1090088)
   0.9461673142330073700000000000f,   // 12946: sin(71.1145020)
   0.9461983421190015600000000000f,   // 12947: sin(71.1199951)
   0.9462293613077438200000000000f,   // 12948: sin(71.1254883)
   0.9462603717989488400000000000f,   // 12949: sin(71.1309814)
   0.9462913735923315100000000000f,   // 12950: sin(71.1364746)
   0.9463223666876070500000000000f,   // 12951: sin(71.1419678)
   0.9463533510844905900000000000f,   // 12952: sin(71.1474609)
   0.9463843267826971300000000000f,   // 12953: sin(71.1529541)
   0.9464152937819421100000000000f,   // 12954: sin(71.1584473)
   0.9464462520819407800000000000f,   // 12955: sin(71.1639404)
   0.9464772016824086800000000000f,   // 12956: sin(71.1694336)
   0.9465081425830612600000000000f,   // 12957: sin(71.1749268)
   0.9465390747836141000000000000f,   // 12958: sin(71.1804199)
   0.9465699982837829700000000000f,   // 12959: sin(71.1859131)
   0.9466009130832835300000000000f,   // 12960: sin(71.1914063)
   0.9466318191818317000000000000f,   // 12961: sin(71.1968994)
   0.9466627165791433600000000000f,   // 12962: sin(71.2023926)
   0.9466936052749345100000000000f,   // 12963: sin(71.2078857)
   0.9467244852689211700000000000f,   // 12964: sin(71.2133789)
   0.9467553565608196600000000000f,   // 12965: sin(71.2188721)
   0.9467862191503460000000000000f,   // 12966: sin(71.2243652)
   0.9468170730372166300000000000f,   // 12967: sin(71.2298584)
   0.9468479182211480000000000000f,   // 12968: sin(71.2353516)
   0.9468787547018565600000000000f,   // 12969: sin(71.2408447)
   0.9469095824790587600000000000f,   // 12970: sin(71.2463379)
   0.9469404015524712800000000000f,   // 12971: sin(71.2518311)
   0.9469712119218108800000000000f,   // 12972: sin(71.2573242)
   0.9470020135867943700000000000f,   // 12973: sin(71.2628174)
   0.9470328065471386200000000000f,   // 12974: sin(71.2683105)
   0.9470635908025605300000000000f,   // 12975: sin(71.2738037)
   0.9470943663527772200000000000f,   // 12976: sin(71.2792969)
   0.9471251331975056900000000000f,   // 12977: sin(71.2847900)
   0.9471558913364632700000000000f,   // 12978: sin(71.2902832)
   0.9471866407693672100000000000f,   // 12979: sin(71.2957764)
   0.9472173814959348200000000000f,   // 12980: sin(71.3012695)
   0.9472481135158834500000000000f,   // 12981: sin(71.3067627)
   0.9472788368289308800000000000f,   // 12982: sin(71.3122559)
   0.9473095514347944500000000000f,   // 12983: sin(71.3177490)
   0.9473402573331919400000000000f,   // 12984: sin(71.3232422)
   0.9473709545238412400000000000f,   // 12985: sin(71.3287354)
   0.9474016430064599000000000000f,   // 12986: sin(71.3342285)
   0.9474323227807661700000000000f,   // 12987: sin(71.3397217)
   0.9474629938464777000000000000f,   // 12988: sin(71.3452148)
   0.9474936562033128300000000000f,   // 12989: sin(71.3507080)
   0.9475243098509895700000000000f,   // 12990: sin(71.3562012)
   0.9475549547892262400000000000f,   // 12991: sin(71.3616943)
   0.9475855910177410900000000000f,   // 12992: sin(71.3671875)
   0.9476162185362526600000000000f,   // 12993: sin(71.3726807)
   0.9476468373444791900000000000f,   // 12994: sin(71.3781738)
   0.9476774474421395500000000000f,   // 12995: sin(71.3836670)
   0.9477080488289521000000000000f,   // 12996: sin(71.3891602)
   0.9477386415046358300000000000f,   // 12997: sin(71.3946533)
   0.9477692254689091800000000000f,   // 12998: sin(71.4001465)
   0.9477998007214912800000000000f,   // 12999: sin(71.4056396)
   0.9478303672621010100000000000f,   // 13000: sin(71.4111328)
   0.9478609250904575000000000000f,   // 13001: sin(71.4166260)
   0.9478914742062797300000000000f,   // 13002: sin(71.4221191)
   0.9479220146092870400000000000f,   // 13003: sin(71.4276123)
   0.9479525462991985600000000000f,   // 13004: sin(71.4331055)
   0.9479830692757338400000000000f,   // 13005: sin(71.4385986)
   0.9480135835386122000000000000f,   // 13006: sin(71.4440918)
   0.9480440890875531100000000000f,   // 13007: sin(71.4495850)
   0.9480745859222762300000000000f,   // 13008: sin(71.4550781)
   0.9481050740425012200000000000f,   // 13009: sin(71.4605713)
   0.9481355534479479800000000000f,   // 13010: sin(71.4660645)
   0.9481660241383360600000000000f,   // 13011: sin(71.4715576)
   0.9481964861133855800000000000f,   // 13012: sin(71.4770508)
   0.9482269393728165500000000000f,   // 13013: sin(71.4825439)
   0.9482573839163490600000000000f,   // 13014: sin(71.4880371)
   0.9482878197437031300000000000f,   // 13015: sin(71.4935303)
   0.9483182468545990900000000000f,   // 13016: sin(71.4990234)
   0.9483486652487573800000000000f,   // 13017: sin(71.5045166)
   0.9483790749258981200000000000f,   // 13018: sin(71.5100098)
   0.9484094758857419800000000000f,   // 13019: sin(71.5155029)
   0.9484398681280096200000000000f,   // 13020: sin(71.5209961)
   0.9484702516524213800000000000f,   // 13021: sin(71.5264893)
   0.9485006264586982600000000000f,   // 13022: sin(71.5319824)
   0.9485309925465609200000000000f,   // 13023: sin(71.5374756)
   0.9485613499157302700000000000f,   // 13024: sin(71.5429688)
   0.9485916985659272900000000000f,   // 13025: sin(71.5484619)
   0.9486220384968729900000000000f,   // 13026: sin(71.5539551)
   0.9486523697082885900000000000f,   // 13027: sin(71.5594482)
   0.9486826921998950900000000000f,   // 13028: sin(71.5649414)
   0.9487130059714139500000000000f,   // 13029: sin(71.5704346)
   0.9487433110225664800000000000f,   // 13030: sin(71.5759277)
   0.9487736073530741400000000000f,   // 13031: sin(71.5814209)
   0.9488038949626583800000000000f,   // 13032: sin(71.5869141)
   0.9488341738510409600000000000f,   // 13033: sin(71.5924072)
   0.9488644440179433400000000000f,   // 13034: sin(71.5979004)
   0.9488947054630874100000000000f,   // 13035: sin(71.6033936)
   0.9489249581861951600000000000f,   // 13036: sin(71.6088867)
   0.9489552021869882600000000000f,   // 13037: sin(71.6143799)
   0.9489854374651887100000000000f,   // 13038: sin(71.6198730)
   0.9490156640205187300000000000f,   // 13039: sin(71.6253662)
   0.9490458818527005600000000000f,   // 13040: sin(71.6308594)
   0.9490760909614562900000000000f,   // 13041: sin(71.6363525)
   0.9491062913465082600000000000f,   // 13042: sin(71.6418457)
   0.9491364830075789100000000000f,   // 13043: sin(71.6473389)
   0.9491666659443907000000000000f,   // 13044: sin(71.6528320)
   0.9491968401566662800000000000f,   // 13045: sin(71.6583252)
   0.9492270056441282100000000000f,   // 13046: sin(71.6638184)
   0.9492571624064991600000000000f,   // 13047: sin(71.6693115)
   0.9492873104435020100000000000f,   // 13048: sin(71.6748047)
   0.9493174497548597700000000000f,   // 13049: sin(71.6802979)
   0.9493475803402952100000000000f,   // 13050: sin(71.6857910)
   0.9493777021995314400000000000f,   // 13051: sin(71.6912842)
   0.9494078153322914600000000000f,   // 13052: sin(71.6967773)
   0.9494379197382988300000000000f,   // 13053: sin(71.7022705)
   0.9494680154172765500000000000f,   // 13054: sin(71.7077637)
   0.9494981023689479400000000000f,   // 13055: sin(71.7132568)
   0.9495281805930366700000000000f,   // 13056: sin(71.7187500)
   0.9495582500892660900000000000f,   // 13057: sin(71.7242432)
   0.9495883108573599500000000000f,   // 13058: sin(71.7297363)
   0.9496183628970418200000000000f,   // 13059: sin(71.7352295)
   0.9496484062080354800000000000f,   // 13060: sin(71.7407227)
   0.9496784407900649100000000000f,   // 13061: sin(71.7462158)
   0.9497084666428538000000000000f,   // 13062: sin(71.7517090)
   0.9497384837661263500000000000f,   // 13063: sin(71.7572021)
   0.9497684921596066800000000000f,   // 13064: sin(71.7626953)
   0.9497984918230187900000000000f,   // 13065: sin(71.7681885)
   0.9498284827560870000000000000f,   // 13066: sin(71.7736816)
   0.9498584649585357600000000000f,   // 13067: sin(71.7791748)
   0.9498884384300893000000000000f,   // 13068: sin(71.7846680)
   0.9499184031704721600000000000f,   // 13069: sin(71.7901611)
   0.9499483591794090100000000000f,   // 13070: sin(71.7956543)
   0.9499783064566244000000000000f,   // 13071: sin(71.8011475)
   0.9500082450018430000000000000f,   // 13072: sin(71.8066406)
   0.9500381748147898000000000000f,   // 13073: sin(71.8121338)
   0.9500680958951895900000000000f,   // 13074: sin(71.8176270)
   0.9500980082427673600000000000f,   // 13075: sin(71.8231201)
   0.9501279118572481000000000000f,   // 13076: sin(71.8286133)
   0.9501578067383570400000000000f,   // 13077: sin(71.8341064)
   0.9501876928858192800000000000f,   // 13078: sin(71.8395996)
   0.9502175702993602700000000000f,   // 13079: sin(71.8450928)
   0.9502474389787052300000000000f,   // 13080: sin(71.8505859)
   0.9502772989235797100000000000f,   // 13081: sin(71.8560791)
   0.9503071501337091400000000000f,   // 13082: sin(71.8615723)
   0.9503369926088193200000000000f,   // 13083: sin(71.8670654)
   0.9503668263486357800000000000f,   // 13084: sin(71.8725586)
   0.9503966513528844300000000000f,   // 13085: sin(71.8780518)
   0.9504264676212909000000000000f,   // 13086: sin(71.8835449)
   0.9504562751535813300000000000f,   // 13087: sin(71.8890381)
   0.9504860739494817000000000000f,   // 13088: sin(71.8945313)
   0.9505158640087180100000000000f,   // 13089: sin(71.9000244)
   0.9505456453310166000000000000f,   // 13090: sin(71.9055176)
   0.9505754179161035600000000000f,   // 13091: sin(71.9110107)
   0.9506051817637052300000000000f,   // 13092: sin(71.9165039)
   0.9506349368735482800000000000f,   // 13093: sin(71.9219971)
   0.9506646832453589100000000000f,   // 13094: sin(71.9274902)
   0.9506944208788638000000000000f,   // 13095: sin(71.9329834)
   0.9507241497737896100000000000f,   // 13096: sin(71.9384766)
   0.9507538699298631000000000000f,   // 13097: sin(71.9439697)
   0.9507835813468110700000000000f,   // 13098: sin(71.9494629)
   0.9508132840243603800000000000f,   // 13099: sin(71.9549561)
   0.9508429779622381600000000000f,   // 13100: sin(71.9604492)
   0.9508726631601712700000000000f,   // 13101: sin(71.9659424)
   0.9509023396178870600000000000f,   // 13102: sin(71.9714355)
   0.9509320073351125200000000000f,   // 13103: sin(71.9769287)
   0.9509616663115750800000000000f,   // 13104: sin(71.9824219)
   0.9509913165470020900000000000f,   // 13105: sin(71.9879150)
   0.9510209580411210800000000000f,   // 13106: sin(71.9934082)
   0.9510505907936595000000000000f,   // 13107: sin(71.9989014)
   0.9510802148043450100000000000f,   // 13108: sin(72.0043945)
   0.9511098300729052800000000000f,   // 13109: sin(72.0098877)
   0.9511394365990681900000000000f,   // 13110: sin(72.0153809)
   0.9511690343825615100000000000f,   // 13111: sin(72.0208740)
   0.9511986234231132300000000000f,   // 13112: sin(72.0263672)
   0.9512282037204513600000000000f,   // 13113: sin(72.0318604)
   0.9512577752743040000000000000f,   // 13114: sin(72.0373535)
   0.9512873380843993600000000000f,   // 13115: sin(72.0428467)
   0.9513168921504655500000000000f,   // 13116: sin(72.0483398)
   0.9513464374722311300000000000f,   // 13117: sin(72.0538330)
   0.9513759740494244200000000000f,   // 13118: sin(72.0593262)
   0.9514055018817739700000000000f,   // 13119: sin(72.0648193)
   0.9514350209690083400000000000f,   // 13120: sin(72.0703125)
   0.9514645313108561800000000000f,   // 13121: sin(72.0758057)
   0.9514940329070463700000000000f,   // 13122: sin(72.0812988)
   0.9515235257573074800000000000f,   // 13123: sin(72.0867920)
   0.9515530098613685900000000000f,   // 13124: sin(72.0922852)
   0.9515824852189587200000000000f,   // 13125: sin(72.0977783)
   0.9516119518298067300000000000f,   // 13126: sin(72.1032715)
   0.9516414096936420800000000000f,   // 13127: sin(72.1087646)
   0.9516708588101938600000000000f,   // 13128: sin(72.1142578)
   0.9517002991791913000000000000f,   // 13129: sin(72.1197510)
   0.9517297308003637200000000000f,   // 13130: sin(72.1252441)
   0.9517591536734408800000000000f,   // 13131: sin(72.1307373)
   0.9517885677981521300000000000f,   // 13132: sin(72.1362305)
   0.9518179731742271200000000000f,   // 13133: sin(72.1417236)
   0.9518473698013956200000000000f,   // 13134: sin(72.1472168)
   0.9518767576793874000000000000f,   // 13135: sin(72.1527100)
   0.9519061368079322300000000000f,   // 13136: sin(72.1582031)
   0.9519355071867602300000000000f,   // 13137: sin(72.1636963)
   0.9519648688156013800000000000f,   // 13138: sin(72.1691895)
   0.9519942216941857900000000000f,   // 13139: sin(72.1746826)
   0.9520235658222435700000000000f,   // 13140: sin(72.1801758)
   0.9520529011995050300000000000f,   // 13141: sin(72.1856689)
   0.9520822278257006200000000000f,   // 13142: sin(72.1911621)
   0.9521115457005606700000000000f,   // 13143: sin(72.1966553)
   0.9521408548238158300000000000f,   // 13144: sin(72.2021484)
   0.9521701551951965400000000000f,   // 13145: sin(72.2076416)
   0.9521994468144335800000000000f,   // 13146: sin(72.2131348)
   0.9522287296812576000000000000f,   // 13147: sin(72.2186279)
   0.9522580037953996000000000000f,   // 13148: sin(72.2241211)
   0.9522872691565903400000000000f,   // 13149: sin(72.2296143)
   0.9523165257645608300000000000f,   // 13150: sin(72.2351074)
   0.9523457736190423800000000000f,   // 13151: sin(72.2406006)
   0.9523750127197658800000000000f,   // 13152: sin(72.2460938)
   0.9524042430664626500000000000f,   // 13153: sin(72.2515869)
   0.9524334646588640300000000000f,   // 13154: sin(72.2570801)
   0.9524626774967014400000000000f,   // 13155: sin(72.2625732)
   0.9524918815797063200000000000f,   // 13156: sin(72.2680664)
   0.9525210769076102300000000000f,   // 13157: sin(72.2735596)
   0.9525502634801449300000000000f,   // 13158: sin(72.2790527)
   0.9525794412970419700000000000f,   // 13159: sin(72.2845459)
   0.9526086103580332400000000000f,   // 13160: sin(72.2900391)
   0.9526377706628507100000000000f,   // 13161: sin(72.2955322)
   0.9526669222112261700000000000f,   // 13162: sin(72.3010254)
   0.9526960650028917200000000000f,   // 13163: sin(72.3065186)
   0.9527251990375795700000000000f,   // 13164: sin(72.3120117)
   0.9527543243150218300000000000f,   // 13165: sin(72.3175049)
   0.9527834408349509200000000000f,   // 13166: sin(72.3229980)
   0.9528125485970989600000000000f,   // 13167: sin(72.3284912)
   0.9528416476011987200000000000f,   // 13168: sin(72.3339844)
   0.9528707378469824000000000000f,   // 13169: sin(72.3394775)
   0.9528998193341828800000000000f,   // 13170: sin(72.3449707)
   0.9529288920625326200000000000f,   // 13171: sin(72.3504639)
   0.9529579560317647000000000000f,   // 13172: sin(72.3559570)
   0.9529870112416116700000000000f,   // 13173: sin(72.3614502)
   0.9530160576918065300000000000f,   // 13174: sin(72.3669434)
   0.9530450953820823700000000000f,   // 13175: sin(72.3724365)
   0.9530741243121722000000000000f,   // 13176: sin(72.3779297)
   0.9531031444818092200000000000f,   // 13177: sin(72.3834229)
   0.9531321558907267500000000000f,   // 13178: sin(72.3889160)
   0.9531611585386581300000000000f,   // 13179: sin(72.3944092)
   0.9531901524253365600000000000f,   // 13180: sin(72.3999023)
   0.9532191375504958100000000000f,   // 13181: sin(72.4053955)
   0.9532481139138693200000000000f,   // 13182: sin(72.4108887)
   0.9532770815151907500000000000f,   // 13183: sin(72.4163818)
   0.9533060403541937500000000000f,   // 13184: sin(72.4218750)
   0.9533349904306124300000000000f,   // 13185: sin(72.4273682)
   0.9533639317441803300000000000f,   // 13186: sin(72.4328613)
   0.9533928642946315500000000000f,   // 13187: sin(72.4383545)
   0.9534217880817003100000000000f,   // 13188: sin(72.4438477)
   0.9534507031051205900000000000f,   // 13189: sin(72.4493408)
   0.9534796093646266100000000000f,   // 13190: sin(72.4548340)
   0.9535085068599527000000000000f,   // 13191: sin(72.4603271)
   0.9535373955908332800000000000f,   // 13192: sin(72.4658203)
   0.9535662755570028000000000000f,   // 13193: sin(72.4713135)
   0.9535951467581956800000000000f,   // 13194: sin(72.4768066)
   0.9536240091941466900000000000f,   // 13195: sin(72.4822998)
   0.9536528628645905000000000000f,   // 13196: sin(72.4877930)
   0.9536817077692617600000000000f,   // 13197: sin(72.4932861)
   0.9537105439078955600000000000f,   // 13198: sin(72.4987793)
   0.9537393712802267900000000000f,   // 13199: sin(72.5042725)
   0.9537681898859903300000000000f,   // 13200: sin(72.5097656)
   0.9537969997249213800000000000f,   // 13201: sin(72.5152588)
   0.9538258007967550500000000000f,   // 13202: sin(72.5207520)
   0.9538545931012267800000000000f,   // 13203: sin(72.5262451)
   0.9538833766380717700000000000f,   // 13204: sin(72.5317383)
   0.9539121514070254500000000000f,   // 13205: sin(72.5372314)
   0.9539409174078235000000000000f,   // 13206: sin(72.5427246)
   0.9539696746402012200000000000f,   // 13207: sin(72.5482178)
   0.9539984231038944900000000000f,   // 13208: sin(72.5537109)
   0.9540271627986390800000000000f,   // 13209: sin(72.5592041)
   0.9540558937241706600000000000f,   // 13210: sin(72.5646973)
   0.9540846158802252000000000000f,   // 13211: sin(72.5701904)
   0.9541133292665388000000000000f,   // 13212: sin(72.5756836)
   0.9541420338828474600000000000f,   // 13213: sin(72.5811768)
   0.9541707297288872800000000000f,   // 13214: sin(72.5866699)
   0.9541994168043945700000000000f,   // 13215: sin(72.5921631)
   0.9542280951091056700000000000f,   // 13216: sin(72.5976563)
   0.9542567646427568800000000000f,   // 13217: sin(72.6031494)
   0.9542854254050846500000000000f,   // 13218: sin(72.6086426)
   0.9543140773958256300000000000f,   // 13219: sin(72.6141357)
   0.9543427206147164800000000000f,   // 13220: sin(72.6196289)
   0.9543713550614938400000000000f,   // 13221: sin(72.6251221)
   0.9543999807358944900000000000f,   // 13222: sin(72.6306152)
   0.9544285976376554200000000000f,   // 13223: sin(72.6361084)
   0.9544572057665134900000000000f,   // 13224: sin(72.6416016)
   0.9544858051222058200000000000f,   // 13225: sin(72.6470947)
   0.9545143957044695000000000000f,   // 13226: sin(72.6525879)
   0.9545429775130417300000000000f,   // 13227: sin(72.6580811)
   0.9545715505476596300000000000f,   // 13228: sin(72.6635742)
   0.9546001148080608400000000000f,   // 13229: sin(72.6690674)
   0.9546286702939826800000000000f,   // 13230: sin(72.6745605)
   0.9546572170051625900000000000f,   // 13231: sin(72.6800537)
   0.9546857549413383400000000000f,   // 13232: sin(72.6855469)
   0.9547142841022475700000000000f,   // 13233: sin(72.6910400)
   0.9547428044876279400000000000f,   // 13234: sin(72.6965332)
   0.9547713160972173300000000000f,   // 13235: sin(72.7020264)
   0.9547998189307537200000000000f,   // 13236: sin(72.7075195)
   0.9548283129879751000000000000f,   // 13237: sin(72.7130127)
   0.9548567982686195800000000000f,   // 13238: sin(72.7185059)
   0.9548852747724252400000000000f,   // 13239: sin(72.7239990)
   0.9549137424991305200000000000f,   // 13240: sin(72.7294922)
   0.9549422014484735300000000000f,   // 13241: sin(72.7349854)
   0.9549706516201927900000000000f,   // 13242: sin(72.7404785)
   0.9549990930140268600000000000f,   // 13243: sin(72.7459717)
   0.9550275256297141600000000000f,   // 13244: sin(72.7514648)
   0.9550559494669933500000000000f,   // 13245: sin(72.7569580)
   0.9550843645256034100000000000f,   // 13246: sin(72.7624512)
   0.9551127708052829000000000000f,   // 13247: sin(72.7679443)
   0.9551411683057706700000000000f,   // 13248: sin(72.7734375)
   0.9551695570268059500000000000f,   // 13249: sin(72.7789307)
   0.9551979369681277100000000000f,   // 13250: sin(72.7844238)
   0.9552263081294749500000000000f,   // 13251: sin(72.7899170)
   0.9552546705105869900000000000f,   // 13252: sin(72.7954102)
   0.9552830241112031400000000000f,   // 13253: sin(72.8009033)
   0.9553113689310627200000000000f,   // 13254: sin(72.8063965)
   0.9553397049699052800000000000f,   // 13255: sin(72.8118896)
   0.9553680322274702400000000000f,   // 13256: sin(72.8173828)
   0.9553963507034973800000000000f,   // 13257: sin(72.8228760)
   0.9554246603977263300000000000f,   // 13258: sin(72.8283691)
   0.9554529613098967600000000000f,   // 13259: sin(72.8338623)
   0.9554812534397487700000000000f,   // 13260: sin(72.8393555)
   0.9555095367870221100000000000f,   // 13261: sin(72.8448486)
   0.9555378113514567700000000000f,   // 13262: sin(72.8503418)
   0.9555660771327930700000000000f,   // 13263: sin(72.8558350)
   0.9555943341307711100000000000f,   // 13264: sin(72.8613281)
   0.9556225823451309800000000000f,   // 13265: sin(72.8668213)
   0.9556508217756132200000000000f,   // 13266: sin(72.8723145)
   0.9556790524219582700000000000f,   // 13267: sin(72.8778076)
   0.9557072742839065600000000000f,   // 13268: sin(72.8833008)
   0.9557354873611987300000000000f,   // 13269: sin(72.8887939)
   0.9557636916535754400000000000f,   // 13270: sin(72.8942871)
   0.9557918871607773400000000000f,   // 13271: sin(72.8997803)
   0.9558200738825454200000000000f,   // 13272: sin(72.9052734)
   0.9558482518186204300000000000f,   // 13273: sin(72.9107666)
   0.9558764209687435900000000000f,   // 13274: sin(72.9162598)
   0.9559045813326557700000000000f,   // 13275: sin(72.9217529)
   0.9559327329100981700000000000f,   // 13276: sin(72.9272461)
   0.9559608757008121200000000000f,   // 13277: sin(72.9327393)
   0.9559890097045389300000000000f,   // 13278: sin(72.9382324)
   0.9560171349210198100000000000f,   // 13279: sin(72.9437256)
   0.9560452513499964100000000000f,   // 13280: sin(72.9492188)
   0.9560733589912102600000000000f,   // 13281: sin(72.9547119)
   0.9561014578444030400000000000f,   // 13282: sin(72.9602051)
   0.9561295479093163700000000000f,   // 13283: sin(72.9656982)
   0.9561576291856921400000000000f,   // 13284: sin(72.9711914)
   0.9561857016732721000000000000f,   // 13285: sin(72.9766846)
   0.9562137653717984700000000000f,   // 13286: sin(72.9821777)
   0.9562418202810130100000000000f,   // 13287: sin(72.9876709)
   0.9562698664006581400000000000f,   // 13288: sin(72.9931641)
   0.9562979037304757400000000000f,   // 13289: sin(72.9986572)
   0.9563259322702082300000000000f,   // 13290: sin(73.0041504)
   0.9563539520195981600000000000f,   // 13291: sin(73.0096436)
   0.9563819629783876200000000000f,   // 13292: sin(73.0151367)
   0.9564099651463194900000000000f,   // 13293: sin(73.0206299)
   0.9564379585231361800000000000f,   // 13294: sin(73.0261230)
   0.9564659431085804600000000000f,   // 13295: sin(73.0316162)
   0.9564939189023949900000000000f,   // 13296: sin(73.0371094)
   0.9565218859043228500000000000f,   // 13297: sin(73.0426025)
   0.9565498441141068200000000000f,   // 13298: sin(73.0480957)
   0.9565777935314897500000000000f,   // 13299: sin(73.0535889)
   0.9566057341562150800000000000f,   // 13300: sin(73.0590820)
   0.9566336659880256800000000000f,   // 13301: sin(73.0645752)
   0.9566615890266649800000000000f,   // 13302: sin(73.0700684)
   0.9566895032718763000000000000f,   // 13303: sin(73.0755615)
   0.9567174087234030500000000000f,   // 13304: sin(73.0810547)
   0.9567453053809887900000000000f,   // 13305: sin(73.0865479)
   0.9567731932443769300000000000f,   // 13306: sin(73.0920410)
   0.9568010723133112400000000000f,   // 13307: sin(73.0975342)
   0.9568289425875353700000000000f,   // 13308: sin(73.1030273)
   0.9568568040667933000000000000f,   // 13309: sin(73.1085205)
   0.9568846567508289000000000000f,   // 13310: sin(73.1140137)
   0.9569125006393860400000000000f,   // 13311: sin(73.1195068)
   0.9569403357322089400000000000f,   // 13312: sin(73.1250000)
   0.9569681620290414500000000000f,   // 13313: sin(73.1304932)
   0.9569959795296282300000000000f,   // 13314: sin(73.1359863)
   0.9570237882337132600000000000f,   // 13315: sin(73.1414795)
   0.9570515881410409700000000000f,   // 13316: sin(73.1469727)
   0.9570793792513560000000000000f,   // 13317: sin(73.1524658)
   0.9571071615644027900000000000f,   // 13318: sin(73.1579590)
   0.9571349350799258600000000000f,   // 13319: sin(73.1634521)
   0.9571626997976701000000000000f,   // 13320: sin(73.1689453)
   0.9571904557173802600000000000f,   // 13321: sin(73.1744385)
   0.9572182028388012100000000000f,   // 13322: sin(73.1799316)
   0.9572459411616778300000000000f,   // 13323: sin(73.1854248)
   0.9572736706857552000000000000f,   // 13324: sin(73.1909180)
   0.9573013914107785200000000000f,   // 13325: sin(73.1964111)
   0.9573291033364927900000000000f,   // 13326: sin(73.2019043)
   0.9573568064626435400000000000f,   // 13327: sin(73.2073975)
   0.9573845007889758600000000000f,   // 13328: sin(73.2128906)
   0.9574121863152353900000000000f,   // 13329: sin(73.2183838)
   0.9574398630411675700000000000f,   // 13330: sin(73.2238770)
   0.9574675309665181500000000000f,   // 13331: sin(73.2293701)
   0.9574951900910325700000000000f,   // 13332: sin(73.2348633)
   0.9575228404144566800000000000f,   // 13333: sin(73.2403564)
   0.9575504819365364700000000000f,   // 13334: sin(73.2458496)
   0.9575781146570175900000000000f,   // 13335: sin(73.2513428)
   0.9576057385756462400000000000f,   // 13336: sin(73.2568359)
   0.9576333536921685100000000000f,   // 13337: sin(73.2623291)
   0.9576609600063306100000000000f,   // 13338: sin(73.2678223)
   0.9576885575178786200000000000f,   // 13339: sin(73.2733154)
   0.9577161462265588700000000000f,   // 13340: sin(73.2788086)
   0.9577437261321180000000000000f,   // 13341: sin(73.2843018)
   0.9577712972343023200000000000f,   // 13342: sin(73.2897949)
   0.9577988595328583700000000000f,   // 13343: sin(73.2952881)
   0.9578264130275329100000000000f,   // 13344: sin(73.3007813)
   0.9578539577180725800000000000f,   // 13345: sin(73.3062744)
   0.9578814936042242500000000000f,   // 13346: sin(73.3117676)
   0.9579090206857349100000000000f,   // 13347: sin(73.3172607)
   0.9579365389623514200000000000f,   // 13348: sin(73.3227539)
   0.9579640484338208800000000000f,   // 13349: sin(73.3282471)
   0.9579915490998903700000000000f,   // 13350: sin(73.3337402)
   0.9580190409603071000000000000f,   // 13351: sin(73.3392334)
   0.9580465240148186000000000000f,   // 13352: sin(73.3447266)
   0.9580739982631718600000000000f,   // 13353: sin(73.3502197)
   0.9581014637051146200000000000f,   // 13354: sin(73.3557129)
   0.9581289203403944300000000000f,   // 13355: sin(73.3612061)
   0.9581563681687588200000000000f,   // 13356: sin(73.3666992)
   0.9581838071899554400000000000f,   // 13357: sin(73.3721924)
   0.9582112374037322600000000000f,   // 13358: sin(73.3776855)
   0.9582386588098370500000000000f,   // 13359: sin(73.3831787)
   0.9582660714080176700000000000f,   // 13360: sin(73.3886719)
   0.9582934751980222200000000000f,   // 13361: sin(73.3941650)
   0.9583208701795988800000000000f,   // 13362: sin(73.3996582)
   0.9583482563524957600000000000f,   // 13363: sin(73.4051514)
   0.9583756337164611700000000000f,   // 13364: sin(73.4106445)
   0.9584030022712434200000000000f,   // 13365: sin(73.4161377)
   0.9584303620165910400000000000f,   // 13366: sin(73.4216309)
   0.9584577129522523500000000000f,   // 13367: sin(73.4271240)
   0.9584850550779761000000000000f,   // 13368: sin(73.4326172)
   0.9585123883935110500000000000f,   // 13369: sin(73.4381104)
   0.9585397128986057300000000000f,   // 13370: sin(73.4436035)
   0.9585670285930091300000000000f,   // 13371: sin(73.4490967)
   0.9585943354764702200000000000f,   // 13372: sin(73.4545898)
   0.9586216335487377500000000000f,   // 13373: sin(73.4600830)
   0.9586489228095610400000000000f,   // 13374: sin(73.4655762)
   0.9586762032586893000000000000f,   // 13375: sin(73.4710693)
   0.9587034748958716000000000000f,   // 13376: sin(73.4765625)
   0.9587307377208572600000000000f,   // 13377: sin(73.4820557)
   0.9587579917333957100000000000f,   // 13378: sin(73.4875488)
   0.9587852369332365800000000000f,   // 13379: sin(73.4930420)
   0.9588124733201292000000000000f,   // 13380: sin(73.4985352)
   0.9588397008938235300000000000f,   // 13381: sin(73.5040283)
   0.9588669196540690100000000000f,   // 13382: sin(73.5095215)
   0.9588941296006156000000000000f,   // 13383: sin(73.5150146)
   0.9589213307332130600000000000f,   // 13384: sin(73.5205078)
   0.9589485230516116000000000000f,   // 13385: sin(73.5260010)
   0.9589757065555610800000000000f,   // 13386: sin(73.5314941)
   0.9590028812448115900000000000f,   // 13387: sin(73.5369873)
   0.9590300471191135500000000000f,   // 13388: sin(73.5424805)
   0.9590572041782171600000000000f,   // 13389: sin(73.5479736)
   0.9590843524218727300000000000f,   // 13390: sin(73.5534668)
   0.9591114918498308000000000000f,   // 13391: sin(73.5589600)
   0.9591386224618418900000000000f,   // 13392: sin(73.5644531)
   0.9591657442576566600000000000f,   // 13393: sin(73.5699463)
   0.9591928572370257400000000000f,   // 13394: sin(73.5754395)
   0.9592199613996998900000000000f,   // 13395: sin(73.5809326)
   0.9592470567454300900000000000f,   // 13396: sin(73.5864258)
   0.9592741432739672100000000000f,   // 13397: sin(73.5919189)
   0.9593012209850622100000000000f,   // 13398: sin(73.5974121)
   0.9593282898784664100000000000f,   // 13399: sin(73.6029053)
   0.9593553499539307900000000000f,   // 13400: sin(73.6083984)
   0.9593824012112066600000000000f,   // 13401: sin(73.6138916)
   0.9594094436500455500000000000f,   // 13402: sin(73.6193848)
   0.9594364772701986500000000000f,   // 13403: sin(73.6248779)
   0.9594635020714175100000000000f,   // 13404: sin(73.6303711)
   0.9594905180534538700000000000f,   // 13405: sin(73.6358643)
   0.9595175252160592600000000000f,   // 13406: sin(73.6413574)
   0.9595445235589855600000000000f,   // 13407: sin(73.6468506)
   0.9595715130819845200000000000f,   // 13408: sin(73.6523438)
   0.9595984937848081000000000000f,   // 13409: sin(73.6578369)
   0.9596254656672083000000000000f,   // 13410: sin(73.6633301)
   0.9596524287289370800000000000f,   // 13411: sin(73.6688232)
   0.9596793829697467500000000000f,   // 13412: sin(73.6743164)
   0.9597063283893895200000000000f,   // 13413: sin(73.6798096)
   0.9597332649876176800000000000f,   // 13414: sin(73.6853027)
   0.9597601927641836700000000000f,   // 13415: sin(73.6907959)
   0.9597871117188399000000000000f,   // 13416: sin(73.6962891)
   0.9598140218513390200000000000f,   // 13417: sin(73.7017822)
   0.9598409231614336600000000000f,   // 13418: sin(73.7072754)
   0.9598678156488765800000000000f,   // 13419: sin(73.7127686)
   0.9598946993134205300000000000f,   // 13420: sin(73.7182617)
   0.9599215741548183800000000000f,   // 13421: sin(73.7237549)
   0.9599484401728232100000000000f,   // 13422: sin(73.7292480)
   0.9599752973671880100000000000f,   // 13423: sin(73.7347412)
   0.9600021457376658500000000000f,   // 13424: sin(73.7402344)
   0.9600289852840100400000000000f,   // 13425: sin(73.7457275)
   0.9600558160059738900000000000f,   // 13426: sin(73.7512207)
   0.9600826379033107200000000000f,   // 13427: sin(73.7567139)
   0.9601094509757739400000000000f,   // 13428: sin(73.7622070)
   0.9601362552231171900000000000f,   // 13429: sin(73.7677002)
   0.9601630506450940000000000000f,   // 13430: sin(73.7731934)
   0.9601898372414581200000000000f,   // 13431: sin(73.7786865)
   0.9602166150119634300000000000f,   // 13432: sin(73.7841797)
   0.9602433839563636600000000000f,   // 13433: sin(73.7896729)
   0.9602701440744128000000000000f,   // 13434: sin(73.7951660)
   0.9602968953658648200000000000f,   // 13435: sin(73.8006592)
   0.9603236378304739200000000000f,   // 13436: sin(73.8061523)
   0.9603503714679942900000000000f,   // 13437: sin(73.8116455)
   0.9603770962781801300000000000f,   // 13438: sin(73.8171387)
   0.9604038122607858600000000000f,   // 13439: sin(73.8226318)
   0.9604305194155657900000000000f,   // 13440: sin(73.8281250)
   0.9604572177422745500000000000f,   // 13441: sin(73.8336182)
   0.9604839072406667900000000000f,   // 13442: sin(73.8391113)
   0.9605105879104970400000000000f,   // 13443: sin(73.8446045)
   0.9605372597515200500000000000f,   // 13444: sin(73.8500977)
   0.9605639227634907900000000000f,   // 13445: sin(73.8555908)
   0.9605905769461641200000000000f,   // 13446: sin(73.8610840)
   0.9606172222992950300000000000f,   // 13447: sin(73.8665771)
   0.9606438588226384700000000000f,   // 13448: sin(73.8720703)
   0.9606704865159498800000000000f,   // 13449: sin(73.8775635)
   0.9606971053789844500000000000f,   // 13450: sin(73.8830566)
   0.9607237154114972600000000000f,   // 13451: sin(73.8885498)
   0.9607503166132439500000000000f,   // 13452: sin(73.8940430)
   0.9607769089839799400000000000f,   // 13453: sin(73.8995361)
   0.9608034925234607600000000000f,   // 13454: sin(73.9050293)
   0.9608300672314420400000000000f,   // 13455: sin(73.9105225)
   0.9608566331076796600000000000f,   // 13456: sin(73.9160156)
   0.9608831901519292500000000000f,   // 13457: sin(73.9215088)
   0.9609097383639467700000000000f,   // 13458: sin(73.9270020)
   0.9609362777434883300000000000f,   // 13459: sin(73.9324951)
   0.9609628082903097800000000000f,   // 13460: sin(73.9379883)
   0.9609893300041673100000000000f,   // 13461: sin(73.9434814)
   0.9610158428848172300000000000f,   // 13462: sin(73.9489746)
   0.9610423469320157300000000000f,   // 13463: sin(73.9544678)
   0.9610688421455193500000000000f,   // 13464: sin(73.9599609)
   0.9610953285250843900000000000f,   // 13465: sin(73.9654541)
   0.9611218060704673800000000000f,   // 13466: sin(73.9709473)
   0.9611482747814250600000000000f,   // 13467: sin(73.9764404)
   0.9611747346577140800000000000f,   // 13468: sin(73.9819336)
   0.9612011856990913000000000000f,   // 13469: sin(73.9874268)
   0.9612276279053134600000000000f,   // 13470: sin(73.9929199)
   0.9612540612761375500000000000f,   // 13471: sin(73.9984131)
   0.9612804858113206400000000000f,   // 13472: sin(74.0039063)
   0.9613069015106198200000000000f,   // 13473: sin(74.0093994)
   0.9613333083737922700000000000f,   // 13474: sin(74.0148926)
   0.9613597064005952000000000000f,   // 13475: sin(74.0203857)
   0.9613860955907862500000000000f,   // 13476: sin(74.0258789)
   0.9614124759441224900000000000f,   // 13477: sin(74.0313721)
   0.9614388474603615700000000000f,   // 13478: sin(74.0368652)
   0.9614652101392612300000000000f,   // 13479: sin(74.0423584)
   0.9614915639805790000000000000f,   // 13480: sin(74.0478516)
   0.9615179089840726300000000000f,   // 13481: sin(74.0533447)
   0.9615442451494999900000000000f,   // 13482: sin(74.0588379)
   0.9615705724766191500000000000f,   // 13483: sin(74.0643311)
   0.9615968909651878600000000000f,   // 13484: sin(74.0698242)
   0.9616232006149643100000000000f,   // 13485: sin(74.0753174)
   0.9616495014257068200000000000f,   // 13486: sin(74.0808105)
   0.9616757933971733500000000000f,   // 13487: sin(74.0863037)
   0.9617020765291225400000000000f,   // 13488: sin(74.0917969)
   0.9617283508213125800000000000f,   // 13489: sin(74.0972900)
   0.9617546162735020100000000000f,   // 13490: sin(74.1027832)
   0.9617808728854494400000000000f,   // 13491: sin(74.1082764)
   0.9618071206569135400000000000f,   // 13492: sin(74.1137695)
   0.9618333595876529300000000000f,   // 13493: sin(74.1192627)
   0.9618595896774265700000000000f,   // 13494: sin(74.1247559)
   0.9618858109259933500000000000f,   // 13495: sin(74.1302490)
   0.9619120233331121000000000000f,   // 13496: sin(74.1357422)
   0.9619382268985421400000000000f,   // 13497: sin(74.1412354)
   0.9619644216220423200000000000f,   // 13498: sin(74.1467285)
   0.9619906075033719500000000000f,   // 13499: sin(74.1522217)
   0.9620167845422905600000000000f,   // 13500: sin(74.1577148)
   0.9620429527385572200000000000f,   // 13501: sin(74.1632080)
   0.9620691120919315800000000000f,   // 13502: sin(74.1687012)
   0.9620952626021731500000000000f,   // 13503: sin(74.1741943)
   0.9621214042690415800000000000f,   // 13504: sin(74.1796875)
   0.9621475370922965000000000000f,   // 13505: sin(74.1851807)
   0.9621736610716977700000000000f,   // 13506: sin(74.1906738)
   0.9621997762070053600000000000f,   // 13507: sin(74.1961670)
   0.9622258824979790200000000000f,   // 13508: sin(74.2016602)
   0.9622519799443789400000000000f,   // 13509: sin(74.2071533)
   0.9622780685459650900000000000f,   // 13510: sin(74.2126465)
   0.9623041483024978900000000000f,   // 13511: sin(74.2181396)
   0.9623302192137374000000000000f,   // 13512: sin(74.2236328)
   0.9623562812794440600000000000f,   // 13513: sin(74.2291260)
   0.9623823344993783800000000000f,   // 13514: sin(74.2346191)
   0.9624083788733008800000000000f,   // 13515: sin(74.2401123)
   0.9624344144009719900000000000f,   // 13516: sin(74.2456055)
   0.9624604410821526700000000000f,   // 13517: sin(74.2510986)
   0.9624864589166034500000000000f,   // 13518: sin(74.2565918)
   0.9625124679040852900000000000f,   // 13519: sin(74.2620850)
   0.9625384680443591600000000000f,   // 13520: sin(74.2675781)
   0.9625644593371859300000000000f,   // 13521: sin(74.2730713)
   0.9625904417823267800000000000f,   // 13522: sin(74.2785645)
   0.9626164153795430100000000000f,   // 13523: sin(74.2840576)
   0.9626423801285957100000000000f,   // 13524: sin(74.2895508)
   0.9626683360292461700000000000f,   // 13525: sin(74.2950439)
   0.9626942830812559300000000000f,   // 13526: sin(74.3005371)
   0.9627202212843865000000000000f,   // 13527: sin(74.3060303)
   0.9627461506383994100000000000f,   // 13528: sin(74.3115234)
   0.9627720711430563000000000000f,   // 13529: sin(74.3170166)
   0.9627979827981190100000000000f,   // 13530: sin(74.3225098)
   0.9628238856033493100000000000f,   // 13531: sin(74.3280029)
   0.9628497795585090300000000000f,   // 13532: sin(74.3334961)
   0.9628756646633601600000000000f,   // 13533: sin(74.3389893)
   0.9629015409176650000000000000f,   // 13534: sin(74.3444824)
   0.9629274083211855100000000000f,   // 13535: sin(74.3499756)
   0.9629532668736838800000000000f,   // 13536: sin(74.3554688)
   0.9629791165749225200000000000f,   // 13537: sin(74.3609619)
   0.9630049574246638500000000000f,   // 13538: sin(74.3664551)
   0.9630307894226701700000000000f,   // 13539: sin(74.3719482)
   0.9630566125687043400000000000f,   // 13540: sin(74.3774414)
   0.9630824268625286500000000000f,   // 13541: sin(74.3829346)
   0.9631082323039061900000000000f,   // 13542: sin(74.3884277)
   0.9631340288925993600000000000f,   // 13543: sin(74.3939209)
   0.9631598166283713600000000000f,   // 13544: sin(74.3994141)
   0.9631855955109850400000000000f,   // 13545: sin(74.4049072)
   0.9632113655402034800000000000f,   // 13546: sin(74.4104004)
   0.9632371267157897600000000000f,   // 13547: sin(74.4158936)
   0.9632628790375070700000000000f,   // 13548: sin(74.4213867)
   0.9632886225051187100000000000f,   // 13549: sin(74.4268799)
   0.9633143571183880900000000000f,   // 13550: sin(74.4323730)
   0.9633400828770787300000000000f,   // 13551: sin(74.4378662)
   0.9633657997809540500000000000f,   // 13552: sin(74.4433594)
   0.9633915078297776700000000000f,   // 13553: sin(74.4488525)
   0.9634172070233133500000000000f,   // 13554: sin(74.4543457)
   0.9634428973613248200000000000f,   // 13555: sin(74.4598389)
   0.9634685788435759500000000000f,   // 13556: sin(74.4653320)
   0.9634942514698307000000000000f,   // 13557: sin(74.4708252)
   0.9635199152398531400000000000f,   // 13558: sin(74.4763184)
   0.9635455701534072500000000000f,   // 13559: sin(74.4818115)
   0.9635712162102572100000000000f,   // 13560: sin(74.4873047)
   0.9635968534101675400000000000f,   // 13561: sin(74.4927979)
   0.9636224817529022200000000000f,   // 13562: sin(74.4982910)
   0.9636481012382259700000000000f,   // 13563: sin(74.5037842)
   0.9636737118659032300000000000f,   // 13564: sin(74.5092773)
   0.9636993136356985000000000000f,   // 13565: sin(74.5147705)
   0.9637249065473764100000000000f,   // 13566: sin(74.5202637)
   0.9637504906007019500000000000f,   // 13567: sin(74.5257568)
   0.9637760657954398400000000000f,   // 13568: sin(74.5312500)
   0.9638016321313549500000000000f,   // 13569: sin(74.5367432)
   0.9638271896082123400000000000f,   // 13570: sin(74.5422363)
   0.9638527382257769900000000000f,   // 13571: sin(74.5477295)
   0.9638782779838142000000000000f,   // 13572: sin(74.5532227)
   0.9639038088820891500000000000f,   // 13573: sin(74.5587158)
   0.9639293309203671400000000000f,   // 13574: sin(74.5642090)
   0.9639548440984137000000000000f,   // 13575: sin(74.5697021)
   0.9639803484159941100000000000f,   // 13576: sin(74.5751953)
   0.9640058438728740200000000000f,   // 13577: sin(74.5806885)
   0.9640313304688192800000000000f,   // 13578: sin(74.5861816)
   0.9640568082035952900000000000f,   // 13579: sin(74.5916748)
   0.9640822770769681400000000000f,   // 13580: sin(74.5971680)
   0.9641077370887035600000000000f,   // 13581: sin(74.6026611)
   0.9641331882385676400000000000f,   // 13582: sin(74.6081543)
   0.9641586305263262200000000000f,   // 13583: sin(74.6136475)
   0.9641840639517457200000000000f,   // 13584: sin(74.6191406)
   0.9642094885145923200000000000f,   // 13585: sin(74.6246338)
   0.9642349042146322000000000000f,   // 13586: sin(74.6301270)
   0.9642603110516316800000000000f,   // 13587: sin(74.6356201)
   0.9642857090253573700000000000f,   // 13588: sin(74.6411133)
   0.9643110981355759200000000000f,   // 13589: sin(74.6466064)
   0.9643364783820537200000000000f,   // 13590: sin(74.6520996)
   0.9643618497645575200000000000f,   // 13591: sin(74.6575928)
   0.9643872122828542900000000000f,   // 13592: sin(74.6630859)
   0.9644125659367106500000000000f,   // 13593: sin(74.6685791)
   0.9644379107258939100000000000f,   // 13594: sin(74.6740723)
   0.9644632466501706900000000000f,   // 13595: sin(74.6795654)
   0.9644885737093084100000000000f,   // 13596: sin(74.6850586)
   0.9645138919030741300000000000f,   // 13597: sin(74.6905518)
   0.9645392012312351500000000000f,   // 13598: sin(74.6960449)
   0.9645645016935589000000000000f,   // 13599: sin(74.7015381)
   0.9645897932898126500000000000f,   // 13600: sin(74.7070313)
   0.9646150760197641500000000000f,   // 13601: sin(74.7125244)
   0.9646403498831809300000000000f,   // 13602: sin(74.7180176)
   0.9646656148798306000000000000f,   // 13603: sin(74.7235107)
   0.9646908710094809200000000000f,   // 13604: sin(74.7290039)
   0.9647161182718999600000000000f,   // 13605: sin(74.7344971)
   0.9647413566668553400000000000f,   // 13606: sin(74.7399902)
   0.9647665861941152600000000000f,   // 13607: sin(74.7454834)
   0.9647918068534479000000000000f,   // 13608: sin(74.7509766)
   0.9648170186446212200000000000f,   // 13609: sin(74.7564697)
   0.9648422215674035100000000000f,   // 13610: sin(74.7619629)
   0.9648674156215633100000000000f,   // 13611: sin(74.7674561)
   0.9648926008068688900000000000f,   // 13612: sin(74.7729492)
   0.9649177771230886800000000000f,   // 13613: sin(74.7784424)
   0.9649429445699914100000000000f,   // 13614: sin(74.7839355)
   0.9649681031473457100000000000f,   // 13615: sin(74.7894287)
   0.9649932528549203200000000000f,   // 13616: sin(74.7949219)
   0.9650183936924841000000000000f,   // 13617: sin(74.8004150)
   0.9650435256598058900000000000f,   // 13618: sin(74.8059082)
   0.9650686487566546600000000000f,   // 13619: sin(74.8114014)
   0.9650937629827995900000000000f,   // 13620: sin(74.8168945)
   0.9651188683380097500000000000f,   // 13621: sin(74.8223877)
   0.9651439648220544500000000000f,   // 13622: sin(74.8278809)
   0.9651690524347029700000000000f,   // 13623: sin(74.8333740)
   0.9651941311757247200000000000f,   // 13624: sin(74.8388672)
   0.9652192010448891200000000000f,   // 13625: sin(74.8443604)
   0.9652442620419657800000000000f,   // 13626: sin(74.8498535)
   0.9652693141667243500000000000f,   // 13627: sin(74.8553467)
   0.9652943574189346600000000000f,   // 13628: sin(74.8608398)
   0.9653193917983663400000000000f,   // 13629: sin(74.8663330)
   0.9653444173047893700000000000f,   // 13630: sin(74.8718262)
   0.9653694339379737000000000000f,   // 13631: sin(74.8773193)
   0.9653944416976894000000000000f,   // 13632: sin(74.8828125)
   0.9654194405837065500000000000f,   // 13633: sin(74.8883057)
   0.9654444305957954300000000000f,   // 13634: sin(74.8937988)
   0.9654694117337262500000000000f,   // 13635: sin(74.8992920)
   0.9654943839972695000000000000f,   // 13636: sin(74.9047852)
   0.9655193473861956000000000000f,   // 13637: sin(74.9102783)
   0.9655443019002750700000000000f,   // 13638: sin(74.9157715)
   0.9655692475392786400000000000f,   // 13639: sin(74.9212646)
   0.9655941843029768300000000000f,   // 13640: sin(74.9267578)
   0.9656191121911404900000000000f,   // 13641: sin(74.9322510)
   0.9656440312035405900000000000f,   // 13642: sin(74.9377441)
   0.9656689413399479600000000000f,   // 13643: sin(74.9432373)
   0.9656938426001336900000000000f,   // 13644: sin(74.9487305)
   0.9657187349838689500000000000f,   // 13645: sin(74.9542236)
   0.9657436184909248300000000000f,   // 13646: sin(74.9597168)
   0.9657684931210726000000000000f,   // 13647: sin(74.9652100)
   0.9657933588740835700000000000f,   // 13648: sin(74.9707031)
   0.9658182157497294800000000000f,   // 13649: sin(74.9761963)
   0.9658430637477815100000000000f,   // 13650: sin(74.9816895)
   0.9658679028680113900000000000f,   // 13651: sin(74.9871826)
   0.9658927331101908600000000000f,   // 13652: sin(74.9926758)
   0.9659175544740916700000000000f,   // 13653: sin(74.9981689)
   0.9659423669594855400000000000f,   // 13654: sin(75.0036621)
   0.9659671705661444500000000000f,   // 13655: sin(75.0091553)
   0.9659919652938405700000000000f,   // 13656: sin(75.0146484)
   0.9660167511423458600000000000f,   // 13657: sin(75.0201416)
   0.9660415281114324000000000000f,   // 13658: sin(75.0256348)
   0.9660662962008725900000000000f,   // 13659: sin(75.0311279)
   0.9660910554104388300000000000f,   // 13660: sin(75.0366211)
   0.9661158057399033000000000000f,   // 13661: sin(75.0421143)
   0.9661405471890387500000000000f,   // 13662: sin(75.0476074)
   0.9661652797576175700000000000f,   // 13663: sin(75.0531006)
   0.9661900034454126200000000000f,   // 13664: sin(75.0585938)
   0.9662147182521964000000000000f,   // 13665: sin(75.0640869)
   0.9662394241777418900000000000f,   // 13666: sin(75.0695801)
   0.9662641212218219300000000000f,   // 13667: sin(75.0750732)
   0.9662888093842095800000000000f,   // 13668: sin(75.0805664)
   0.9663134886646779200000000000f,   // 13669: sin(75.0860596)
   0.9663381590630001300000000000f,   // 13670: sin(75.0915527)
   0.9663628205789492900000000000f,   // 13671: sin(75.0970459)
   0.9663874732122987900000000000f,   // 13672: sin(75.1025391)
   0.9664121169628221400000000000f,   // 13673: sin(75.1080322)
   0.9664367518302926500000000000f,   // 13674: sin(75.1135254)
   0.9664613778144840500000000000f,   // 13675: sin(75.1190186)
   0.9664859949151698400000000000f,   // 13676: sin(75.1245117)
   0.9665106031321237800000000000f,   // 13677: sin(75.1300049)
   0.9665352024651197000000000000f,   // 13678: sin(75.1354980)
   0.9665597929139314600000000000f,   // 13679: sin(75.1409912)
   0.9665843744783331200000000000f,   // 13680: sin(75.1464844)
   0.9666089471580985300000000000f,   // 13681: sin(75.1519775)
   0.9666335109530021000000000000f,   // 13682: sin(75.1574707)
   0.9666580658628178800000000000f,   // 13683: sin(75.1629639)
   0.9666826118873201900000000000f,   // 13684: sin(75.1684570)
   0.9667071490262833000000000000f,   // 13685: sin(75.1739502)
   0.9667316772794818400000000000f,   // 13686: sin(75.1794434)
   0.9667561966466903200000000000f,   // 13687: sin(75.1849365)
   0.9667807071276832700000000000f,   // 13688: sin(75.1904297)
   0.9668052087222355200000000000f,   // 13689: sin(75.1959229)
   0.9668297014301218100000000000f,   // 13690: sin(75.2014160)
   0.9668541852511169900000000000f,   // 13691: sin(75.2069092)
   0.9668786601849959100000000000f,   // 13692: sin(75.2124023)
   0.9669031262315337400000000000f,   // 13693: sin(75.2178955)
   0.9669275833905056600000000000f,   // 13694: sin(75.2233887)
   0.9669520316616866400000000000f,   // 13695: sin(75.2288818)
   0.9669764710448520700000000000f,   // 13696: sin(75.2343750)
   0.9670009015397773600000000000f,   // 13697: sin(75.2398682)
   0.9670253231462379000000000000f,   // 13698: sin(75.2453613)
   0.9670497358640092200000000000f,   // 13699: sin(75.2508545)
   0.9670741396928670400000000000f,   // 13700: sin(75.2563477)
   0.9670985346325867700000000000f,   // 13701: sin(75.2618408)
   0.9671229206829443600000000000f,   // 13702: sin(75.2673340)
   0.9671472978437156700000000000f,   // 13703: sin(75.2728271)
   0.9671716661146766400000000000f,   // 13704: sin(75.2783203)
   0.9671960254956031300000000000f,   // 13705: sin(75.2838135)
   0.9672203759862713100000000000f,   // 13706: sin(75.2893066)
   0.9672447175864574700000000000f,   // 13707: sin(75.2947998)
   0.9672690502959377900000000000f,   // 13708: sin(75.3002930)
   0.9672933741144885700000000000f,   // 13709: sin(75.3057861)
   0.9673176890418863100000000000f,   // 13710: sin(75.3112793)
   0.9673419950779074100000000000f,   // 13711: sin(75.3167725)
   0.9673662922223285100000000000f,   // 13712: sin(75.3222656)
   0.9673905804749263200000000000f,   // 13713: sin(75.3277588)
   0.9674148598354774800000000000f,   // 13714: sin(75.3332520)
   0.9674391303037588300000000000f,   // 13715: sin(75.3387451)
   0.9674633918795474400000000000f,   // 13716: sin(75.3442383)
   0.9674876445626202600000000000f,   // 13717: sin(75.3497314)
   0.9675118883527541500000000000f,   // 13718: sin(75.3552246)
   0.9675361232497264900000000000f,   // 13719: sin(75.3607178)
   0.9675603492533143600000000000f,   // 13720: sin(75.3662109)
   0.9675845663632952600000000000f,   // 13721: sin(75.3717041)
   0.9676087745794463800000000000f,   // 13722: sin(75.3771973)
   0.9676329739015454600000000000f,   // 13723: sin(75.3826904)
   0.9676571643293698800000000000f,   // 13724: sin(75.3881836)
   0.9676813458626972700000000000f,   // 13725: sin(75.3936768)
   0.9677055185013054800000000000f,   // 13726: sin(75.3991699)
   0.9677296822449722400000000000f,   // 13727: sin(75.4046631)
   0.9677538370934755100000000000f,   // 13728: sin(75.4101563)
   0.9677779830465931300000000000f,   // 13729: sin(75.4156494)
   0.9678021201041032700000000000f,   // 13730: sin(75.4211426)
   0.9678262482657840100000000000f,   // 13731: sin(75.4266357)
   0.9678503675314136200000000000f,   // 13732: sin(75.4321289)
   0.9678744779007704100000000000f,   // 13733: sin(75.4376221)
   0.9678985793736326600000000000f,   // 13734: sin(75.4431152)
   0.9679226719497789900000000000f,   // 13735: sin(75.4486084)
   0.9679467556289878000000000000f,   // 13736: sin(75.4541016)
   0.9679708304110378200000000000f,   // 13737: sin(75.4595947)
   0.9679948962957076700000000000f,   // 13738: sin(75.4650879)
   0.9680189532827762100000000000f,   // 13739: sin(75.4705811)
   0.9680430013720222600000000000f,   // 13740: sin(75.4760742)
   0.9680670405632249000000000000f,   // 13741: sin(75.4815674)
   0.9680910708561629700000000000f,   // 13742: sin(75.4870605)
   0.9681150922506157600000000000f,   // 13743: sin(75.4925537)
   0.9681391047463623300000000000f,   // 13744: sin(75.4980469)
   0.9681631083431822000000000000f,   // 13745: sin(75.5035400)
   0.9681871030408544200000000000f,   // 13746: sin(75.5090332)
   0.9682110888391586300000000000f,   // 13747: sin(75.5145264)
   0.9682350657378743200000000000f,   // 13748: sin(75.5200195)
   0.9682590337367810200000000000f,   // 13749: sin(75.5255127)
   0.9682829928356586600000000000f,   // 13750: sin(75.5310059)
   0.9683069430342867700000000000f,   // 13751: sin(75.5364990)
   0.9683308843324453000000000000f,   // 13752: sin(75.5419922)
   0.9683548167299140800000000000f,   // 13753: sin(75.5474854)
   0.9683787402264733000000000000f,   // 13754: sin(75.5529785)
   0.9684026548219029100000000000f,   // 13755: sin(75.5584717)
   0.9684265605159831900000000000f,   // 13756: sin(75.5639648)
   0.9684504573084944400000000000f,   // 13757: sin(75.5694580)
   0.9684743451992168200000000000f,   // 13758: sin(75.5749512)
   0.9684982241879309700000000000f,   // 13759: sin(75.5804443)
   0.9685220942744172700000000000f,   // 13760: sin(75.5859375)
   0.9685459554584564500000000000f,   // 13761: sin(75.5914307)
   0.9685698077398289300000000000f,   // 13762: sin(75.5969238)
   0.9685936511183157500000000000f,   // 13763: sin(75.6024170)
   0.9686174855936975400000000000f,   // 13764: sin(75.6079102)
   0.9686413111657552500000000000f,   // 13765: sin(75.6134033)
   0.9686651278342699500000000000f,   // 13766: sin(75.6188965)
   0.9686889355990228000000000000f,   // 13767: sin(75.6243896)
   0.9687127344597947800000000000f,   // 13768: sin(75.6298828)
   0.9687365244163671500000000000f,   // 13769: sin(75.6353760)
   0.9687603054685214300000000000f,   // 13770: sin(75.6408691)
   0.9687840776160388000000000000f,   // 13771: sin(75.6463623)
   0.9688078408587009700000000000f,   // 13772: sin(75.6518555)
   0.9688315951962892500000000000f,   // 13773: sin(75.6573486)
   0.9688553406285855800000000000f,   // 13774: sin(75.6628418)
   0.9688790771553714700000000000f,   // 13775: sin(75.6683350)
   0.9689028047764288700000000000f,   // 13776: sin(75.6738281)
   0.9689265234915396300000000000f,   // 13777: sin(75.6793213)
   0.9689502333004858000000000000f,   // 13778: sin(75.6848145)
   0.9689739342030493400000000000f,   // 13779: sin(75.6903076)
   0.9689976261990123100000000000f,   // 13780: sin(75.6958008)
   0.9690213092881572200000000000f,   // 13781: sin(75.7012939)
   0.9690449834702662400000000000f,   // 13782: sin(75.7067871)
   0.9690686487451216600000000000f,   // 13783: sin(75.7122803)
   0.9690923051125061000000000000f,   // 13784: sin(75.7177734)
   0.9691159525722021800000000000f,   // 13785: sin(75.7232666)
   0.9691395911239922800000000000f,   // 13786: sin(75.7287598)
   0.9691632207676592600000000000f,   // 13787: sin(75.7342529)
   0.9691868415029859500000000000f,   // 13788: sin(75.7397461)
   0.9692104533297553100000000000f,   // 13789: sin(75.7452393)
   0.9692340562477500500000000000f,   // 13790: sin(75.7507324)
   0.9692576502567533700000000000f,   // 13791: sin(75.7562256)
   0.9692812353565485300000000000f,   // 13792: sin(75.7617188)
   0.9693048115469185000000000000f,   // 13793: sin(75.7672119)
   0.9693283788276466600000000000f,   // 13794: sin(75.7727051)
   0.9693519371985164200000000000f,   // 13795: sin(75.7781982)
   0.9693754866593112800000000000f,   // 13796: sin(75.7836914)
   0.9693990272098146300000000000f,   // 13797: sin(75.7891846)
   0.9694225588498103200000000000f,   // 13798: sin(75.7946777)
   0.9694460815790818500000000000f,   // 13799: sin(75.8001709)
   0.9694695953974129500000000000f,   // 13800: sin(75.8056641)
   0.9694931003045878000000000000f,   // 13801: sin(75.8111572)
   0.9695165963003900000000000000f,   // 13802: sin(75.8166504)
   0.9695400833846037300000000000f,   // 13803: sin(75.8221436)
   0.9695635615570131800000000000f,   // 13804: sin(75.8276367)
   0.9695870308174025000000000000f,   // 13805: sin(75.8331299)
   0.9696104911655558700000000000f,   // 13806: sin(75.8386230)
   0.9696339426012576800000000000f,   // 13807: sin(75.8441162)
   0.9696573851242924500000000000f,   // 13808: sin(75.8496094)
   0.9696808187344446700000000000f,   // 13809: sin(75.8551025)
   0.9697042434314987500000000000f,   // 13810: sin(75.8605957)
   0.9697276592152397300000000000f,   // 13811: sin(75.8660889)
   0.9697510660854521400000000000f,   // 13812: sin(75.8715820)
   0.9697744640419209100000000000f,   // 13813: sin(75.8770752)
   0.9697978530844308900000000000f,   // 13814: sin(75.8825684)
   0.9698212332127671400000000000f,   // 13815: sin(75.8880615)
   0.9698446044267148300000000000f,   // 13816: sin(75.8935547)
   0.9698679667260590200000000000f,   // 13817: sin(75.8990479)
   0.9698913201105851000000000000f,   // 13818: sin(75.9045410)
   0.9699146645800782500000000000f,   // 13819: sin(75.9100342)
   0.9699380001343239600000000000f,   // 13820: sin(75.9155273)
   0.9699613267731077600000000000f,   // 13821: sin(75.9210205)
   0.9699846444962152400000000000f,   // 13822: sin(75.9265137)
   0.9700079533034321500000000000f,   // 13823: sin(75.9320068)
   0.9700312531945439700000000000f,   // 13824: sin(75.9375000)
   0.9700545441693367900000000000f,   // 13825: sin(75.9429932)
   0.9700778262275964200000000000f,   // 13826: sin(75.9484863)
   0.9701010993691088200000000000f,   // 13827: sin(75.9539795)
   0.9701243635936602800000000000f,   // 13828: sin(75.9594727)
   0.9701476189010367300000000000f,   // 13829: sin(75.9649658)
   0.9701708652910243600000000000f,   // 13830: sin(75.9704590)
   0.9701941027634097800000000000f,   // 13831: sin(75.9759521)
   0.9702173313179791600000000000f,   // 13832: sin(75.9814453)
   0.9702405509545191100000000000f,   // 13833: sin(75.9869385)
   0.9702637616728161400000000000f,   // 13834: sin(75.9924316)
   0.9702869634726568600000000000f,   // 13835: sin(75.9979248)
   0.9703101563538281100000000000f,   // 13836: sin(76.0034180)
   0.9703333403161166200000000000f,   // 13837: sin(76.0089111)
   0.9703565153593094500000000000f,   // 13838: sin(76.0144043)
   0.9703796814831933100000000000f,   // 13839: sin(76.0198975)
   0.9704028386875555000000000000f,   // 13840: sin(76.0253906)
   0.9704259869721829600000000000f,   // 13841: sin(76.0308838)
   0.9704491263368630900000000000f,   // 13842: sin(76.0363770)
   0.9704722567813831600000000000f,   // 13843: sin(76.0418701)
   0.9704953783055304500000000000f,   // 13844: sin(76.0473633)
   0.9705184909090925900000000000f,   // 13845: sin(76.0528564)
   0.9705415945918570700000000000f,   // 13846: sin(76.0583496)
   0.9705646893536115100000000000f,   // 13847: sin(76.0638428)
   0.9705877751941436300000000000f,   // 13848: sin(76.0693359)
   0.9706108521132411600000000000f,   // 13849: sin(76.0748291)
   0.9706339201106921600000000000f,   // 13850: sin(76.0803223)
   0.9706569791862844600000000000f,   // 13851: sin(76.0858154)
   0.9706800293398061300000000000f,   // 13852: sin(76.0913086)
   0.9707030705710453200000000000f,   // 13853: sin(76.0968018)
   0.9707261028797901100000000000f,   // 13854: sin(76.1022949)
   0.9707491262658289900000000000f,   // 13855: sin(76.1077881)
   0.9707721407289503500000000000f,   // 13856: sin(76.1132813)
   0.9707951462689423700000000000f,   // 13857: sin(76.1187744)
   0.9708181428855938700000000000f,   // 13858: sin(76.1242676)
   0.9708411305786933700000000000f,   // 13859: sin(76.1297607)
   0.9708641093480294700000000000f,   // 13860: sin(76.1352539)
   0.9708870791933911200000000000f,   // 13861: sin(76.1407471)
   0.9709100401145670500000000000f,   // 13862: sin(76.1462402)
   0.9709329921113464300000000000f,   // 13863: sin(76.1517334)
   0.9709559351835179700000000000f,   // 13864: sin(76.1572266)
   0.9709788693308709600000000000f,   // 13865: sin(76.1627197)
   0.9710017945531946900000000000f,   // 13866: sin(76.1682129)
   0.9710247108502783100000000000f,   // 13867: sin(76.1737061)
   0.9710476182219111000000000000f,   // 13868: sin(76.1791992)
   0.9710705166678825800000000000f,   // 13869: sin(76.1846924)
   0.9710934061879824600000000000f,   // 13870: sin(76.1901855)
   0.9711162867820000200000000000f,   // 13871: sin(76.1956787)
   0.9711391584497250900000000000f,   // 13872: sin(76.2011719)
   0.9711620211909475200000000000f,   // 13873: sin(76.2066650)
   0.9711848750054570300000000000f,   // 13874: sin(76.2121582)
   0.9712077198930436600000000000f,   // 13875: sin(76.2176514)
   0.9712305558534973800000000000f,   // 13876: sin(76.2231445)
   0.9712533828866082300000000000f,   // 13877: sin(76.2286377)
   0.9712762009921664900000000000f,   // 13878: sin(76.2341309)
   0.9712990101699623400000000000f,   // 13879: sin(76.2396240)
   0.9713218104197861600000000000f,   // 13880: sin(76.2451172)
   0.9713446017414283400000000000f,   // 13881: sin(76.2506104)
   0.9713673841346794900000000000f,   // 13882: sin(76.2561035)
   0.9713901575993301200000000000f,   // 13883: sin(76.2615967)
   0.9714129221351709400000000000f,   // 13884: sin(76.2670898)
   0.9714356777419925800000000000f,   // 13885: sin(76.2725830)
   0.9714584244195859600000000000f,   // 13886: sin(76.2780762)
   0.9714811621677420500000000000f,   // 13887: sin(76.2835693)
   0.9715038909862517800000000000f,   // 13888: sin(76.2890625)
   0.9715266108749062200000000000f,   // 13889: sin(76.2945557)
   0.9715493218334966300000000000f,   // 13890: sin(76.3000488)
   0.9715720238618141800000000000f,   // 13891: sin(76.3055420)
   0.9715947169596501600000000000f,   // 13892: sin(76.3110352)
   0.9716174011267960700000000000f,   // 13893: sin(76.3165283)
   0.9716400763630433900000000000f,   // 13894: sin(76.3220215)
   0.9716627426681836400000000000f,   // 13895: sin(76.3275146)
   0.9716854000420085400000000000f,   // 13896: sin(76.3330078)
   0.9717080484843098100000000000f,   // 13897: sin(76.3385010)
   0.9717306879948791600000000000f,   // 13898: sin(76.3439941)
   0.9717533185735085500000000000f,   // 13899: sin(76.3494873)
   0.9717759402199901400000000000f,   // 13900: sin(76.3549805)
   0.9717985529341157700000000000f,   // 13901: sin(76.3604736)
   0.9718211567156777000000000000f,   // 13902: sin(76.3659668)
   0.9718437515644681200000000000f,   // 13903: sin(76.3714600)
   0.9718663374802794000000000000f,   // 13904: sin(76.3769531)
   0.9718889144629038200000000000f,   // 13905: sin(76.3824463)
   0.9719114825121340000000000000f,   // 13906: sin(76.3879395)
   0.9719340416277624200000000000f,   // 13907: sin(76.3934326)
   0.9719565918095816000000000000f,   // 13908: sin(76.3989258)
   0.9719791330573845900000000000f,   // 13909: sin(76.4044189)
   0.9720016653709638900000000000f,   // 13910: sin(76.4099121)
   0.9720241887501125400000000000f,   // 13911: sin(76.4154053)
   0.9720467031946235000000000000f,   // 13912: sin(76.4208984)
   0.9720692087042897000000000000f,   // 13913: sin(76.4263916)
   0.9720917052789044300000000000f,   // 13914: sin(76.4318848)
   0.9721141929182607300000000000f,   // 13915: sin(76.4373779)
   0.9721366716221521200000000000f,   // 13916: sin(76.4428711)
   0.9721591413903719600000000000f,   // 13917: sin(76.4483643)
   0.9721816022227134400000000000f,   // 13918: sin(76.4538574)
   0.9722040541189703700000000000f,   // 13919: sin(76.4593506)
   0.9722264970789362700000000000f,   // 13920: sin(76.4648438)
   0.9722489311024049600000000000f,   // 13921: sin(76.4703369)
   0.9722713561891700400000000000f,   // 13922: sin(76.4758301)
   0.9722937723390254700000000000f,   // 13923: sin(76.4813232)
   0.9723161795517653000000000000f,   // 13924: sin(76.4868164)
   0.9723385778271834700000000000f,   // 13925: sin(76.4923096)
   0.9723609671650741400000000000f,   // 13926: sin(76.4978027)
   0.9723833475652314800000000000f,   // 13927: sin(76.5032959)
   0.9724057190274497700000000000f,   // 13928: sin(76.5087891)
   0.9724280815515233800000000000f,   // 13929: sin(76.5142822)
   0.9724504351372468300000000000f,   // 13930: sin(76.5197754)
   0.9724727797844146000000000000f,   // 13931: sin(76.5252686)
   0.9724951154928211900000000000f,   // 13932: sin(76.5307617)
   0.9725174422622614400000000000f,   // 13933: sin(76.5362549)
   0.9725397600925301800000000000f,   // 13934: sin(76.5417480)
   0.9725620689834221200000000000f,   // 13935: sin(76.5472412)
   0.9725843689347322100000000000f,   // 13936: sin(76.5527344)
   0.9726066599462556100000000000f,   // 13937: sin(76.5582275)
   0.9726289420177872700000000000f,   // 13938: sin(76.5637207)
   0.9726512151491224500000000000f,   // 13939: sin(76.5692139)
   0.9726734793400564300000000000f,   // 13940: sin(76.5747070)
   0.9726957345903846100000000000f,   // 13941: sin(76.5802002)
   0.9727179808999022500000000000f,   // 13942: sin(76.5856934)
   0.9727402182684050700000000000f,   // 13943: sin(76.5911865)
   0.9727624466956885700000000000f,   // 13944: sin(76.5966797)
   0.9727846661815484600000000000f,   // 13945: sin(76.6021729)
   0.9728068767257803700000000000f,   // 13946: sin(76.6076660)
   0.9728290783281803300000000000f,   // 13947: sin(76.6131592)
   0.9728512709885441800000000000f,   // 13948: sin(76.6186523)
   0.9728734547066679700000000000f,   // 13949: sin(76.6241455)
   0.9728956294823477600000000000f,   // 13950: sin(76.6296387)
   0.9729177953153797000000000000f,   // 13951: sin(76.6351318)
   0.9729399522055600700000000000f,   // 13952: sin(76.6406250)
   0.9729621001526853600000000000f,   // 13953: sin(76.6461182)
   0.9729842391565517400000000000f,   // 13954: sin(76.6516113)
   0.9730063692169558200000000000f,   // 13955: sin(76.6571045)
   0.9730284903336941000000000000f,   // 13956: sin(76.6625977)
   0.9730506025065635000000000000f,   // 13957: sin(76.6680908)
   0.9730727057353605300000000000f,   // 13958: sin(76.6735840)
   0.9730948000198820200000000000f,   // 13959: sin(76.6790771)
   0.9731168853599251300000000000f,   // 13960: sin(76.6845703)
   0.9731389617552865800000000000f,   // 13961: sin(76.6900635)
   0.9731610292057635300000000000f,   // 13962: sin(76.6955566)
   0.9731830877111532500000000000f,   // 13963: sin(76.7010498)
   0.9732051372712528000000000000f,   // 13964: sin(76.7065430)
   0.9732271778858596600000000000f,   // 13965: sin(76.7120361)
   0.9732492095547711200000000000f,   // 13966: sin(76.7175293)
   0.9732712322777847800000000000f,   // 13967: sin(76.7230225)
   0.9732932460546982500000000000f,   // 13968: sin(76.7285156)
   0.9733152508853089000000000000f,   // 13969: sin(76.7340088)
   0.9733372467694148000000000000f,   // 13970: sin(76.7395020)
   0.9733592337068136500000000000f,   // 13971: sin(76.7449951)
   0.9733812116973032900000000000f,   // 13972: sin(76.7504883)
   0.9734031807406816600000000000f,   // 13973: sin(76.7559814)
   0.9734251408367470300000000000f,   // 13974: sin(76.7614746)
   0.9734470919852974400000000000f,   // 13975: sin(76.7669678)
   0.9734690341861309500000000000f,   // 13976: sin(76.7724609)
   0.9734909674390461700000000000f,   // 13977: sin(76.7779541)
   0.9735128917438413700000000000f,   // 13978: sin(76.7834473)
   0.9735348071003149300000000000f,   // 13979: sin(76.7889404)
   0.9735567135082655600000000000f,   // 13980: sin(76.7944336)
   0.9735786109674917600000000000f,   // 13981: sin(76.7999268)
   0.9736004994777923700000000000f,   // 13982: sin(76.8054199)
   0.9736223790389660900000000000f,   // 13983: sin(76.8109131)
   0.9736442496508118700000000000f,   // 13984: sin(76.8164063)
   0.9736661113131287500000000000f,   // 13985: sin(76.8218994)
   0.9736879640257156700000000000f,   // 13986: sin(76.8273926)
   0.9737098077883718000000000000f,   // 13987: sin(76.8328857)
   0.9737316426008964000000000000f,   // 13988: sin(76.8383789)
   0.9737534684630886300000000000f,   // 13989: sin(76.8438721)
   0.9737752853747480000000000000f,   // 13990: sin(76.8493652)
   0.9737970933356739900000000000f,   // 13991: sin(76.8548584)
   0.9738188923456661000000000000f,   // 13992: sin(76.8603516)
   0.9738406824045239300000000000f,   // 13993: sin(76.8658447)
   0.9738624635120473000000000000f,   // 13994: sin(76.8713379)
   0.9738842356680358400000000000f,   // 13995: sin(76.8768311)
   0.9739059988722894600000000000f,   // 13996: sin(76.8823242)
   0.9739277531246082200000000000f,   // 13997: sin(76.8878174)
   0.9739494984247921700000000000f,   // 13998: sin(76.8933105)
   0.9739712347726413600000000000f,   // 13999: sin(76.8988037)
   0.9739929621679558300000000000f,   // 14000: sin(76.9042969)
   0.9740146806105362000000000000f,   // 14001: sin(76.9097900)
   0.9740363901001826100000000000f,   // 14002: sin(76.9152832)
   0.9740580906366955700000000000f,   // 14003: sin(76.9207764)
   0.9740797822198756800000000000f,   // 14004: sin(76.9262695)
   0.9741014648495234200000000000f,   // 14005: sin(76.9317627)
   0.9741231385254395200000000000f,   // 14006: sin(76.9372559)
   0.9741448032474249200000000000f,   // 14007: sin(76.9427490)
   0.9741664590152803200000000000f,   // 14008: sin(76.9482422)
   0.9741881058288067700000000000f,   // 14009: sin(76.9537354)
   0.9742097436878051100000000000f,   // 14010: sin(76.9592285)
   0.9742313725920767100000000000f,   // 14011: sin(76.9647217)
   0.9742529925414225000000000000f,   // 14012: sin(76.9702148)
   0.9742746035356439900000000000f,   // 14013: sin(76.9757080)
   0.9742962055745423300000000000f,   // 14014: sin(76.9812012)
   0.9743177986579191200000000000f,   // 14015: sin(76.9866943)
   0.9743393827855758600000000000f,   // 14016: sin(76.9921875)
   0.9743609579573140300000000000f,   // 14017: sin(76.9976807)
   0.9743825241729354700000000000f,   // 14018: sin(77.0031738)
   0.9744040814322418900000000000f,   // 14019: sin(77.0086670)
   0.9744256297350349900000000000f,   // 14020: sin(77.0141602)
   0.9744471690811169500000000000f,   // 14021: sin(77.0196533)
   0.9744686994702895800000000000f,   // 14022: sin(77.0251465)
   0.9744902209023551500000000000f,   // 14023: sin(77.0306396)
   0.9745117333771157200000000000f,   // 14024: sin(77.0361328)
   0.9745332368943736600000000000f,   // 14025: sin(77.0416260)
   0.9745547314539312300000000000f,   // 14026: sin(77.0471191)
   0.9745762170555908300000000000f,   // 14027: sin(77.0526123)
   0.9745976936991550500000000000f,   // 14028: sin(77.0581055)
   0.9746191613844263900000000000f,   // 14029: sin(77.0635986)
   0.9746406201112075600000000000f,   // 14030: sin(77.0690918)
   0.9746620698793013700000000000f,   // 14031: sin(77.0745850)
   0.9746835106885106700000000000f,   // 14032: sin(77.0800781)
   0.9747049425386382600000000000f,   // 14033: sin(77.0855713)
   0.9747263654294873200000000000f,   // 14034: sin(77.0910645)
   0.9747477793608607700000000000f,   // 14035: sin(77.0965576)
   0.9747691843325617700000000000f,   // 14036: sin(77.1020508)
   0.9747905803443937000000000000f,   // 14037: sin(77.1075439)
   0.9748119673961598300000000000f,   // 14038: sin(77.1130371)
   0.9748333454876635400000000000f,   // 14039: sin(77.1185303)
   0.9748547146187084300000000000f,   // 14040: sin(77.1240234)
   0.9748760747890979900000000000f,   // 14041: sin(77.1295166)
   0.9748974259986358200000000000f,   // 14042: sin(77.1350098)
   0.9749187682471258700000000000f,   // 14043: sin(77.1405029)
   0.9749401015343717200000000000f,   // 14044: sin(77.1459961)
   0.9749614258601775300000000000f,   // 14045: sin(77.1514893)
   0.9749827412243471400000000000f,   // 14046: sin(77.1569824)
   0.9750040476266845800000000000f,   // 14047: sin(77.1624756)
   0.9750253450669941200000000000f,   // 14048: sin(77.1679688)
   0.9750466335450799200000000000f,   // 14049: sin(77.1734619)
   0.9750679130607463600000000000f,   // 14050: sin(77.1789551)
   0.9750891836137978200000000000f,   // 14051: sin(77.1844482)
   0.9751104452040388900000000000f,   // 14052: sin(77.1899414)
   0.9751316978312738500000000000f,   // 14053: sin(77.1954346)
   0.9751529414953076200000000000f,   // 14054: sin(77.2009277)
   0.9751741761959448200000000000f,   // 14055: sin(77.2064209)
   0.9751954019329903700000000000f,   // 14056: sin(77.2119141)
   0.9752166187062489800000000000f,   // 14057: sin(77.2174072)
   0.9752378265155258200000000000f,   // 14058: sin(77.2229004)
   0.9752590253606258100000000000f,   // 14059: sin(77.2283936)
   0.9752802152413542200000000000f,   // 14060: sin(77.2338867)
   0.9753013961575161000000000000f,   // 14061: sin(77.2393799)
   0.9753225681089169300000000000f,   // 14062: sin(77.2448730)
   0.9753437310953621000000000000f,   // 14063: sin(77.2503662)
   0.9753648851166568700000000000f,   // 14064: sin(77.2558594)
   0.9753860301726071700000000000f,   // 14065: sin(77.2613525)
   0.9754071662630182700000000000f,   // 14066: sin(77.2668457)
   0.9754282933876961000000000000f,   // 14067: sin(77.2723389)
   0.9754494115464463800000000000f,   // 14068: sin(77.2778320)
   0.9754705207390750300000000000f,   // 14069: sin(77.2833252)
   0.9754916209653881100000000000f,   // 14070: sin(77.2888184)
   0.9755127122251914300000000000f,   // 14071: sin(77.2943115)
   0.9755337945182913600000000000f,   // 14072: sin(77.2998047)
   0.9755548678444939700000000000f,   // 14073: sin(77.3052979)
   0.9755759322036056100000000000f,   // 14074: sin(77.3107910)
   0.9755969875954327900000000000f,   // 14075: sin(77.3162842)
   0.9756180340197817500000000000f,   // 14076: sin(77.3217773)
   0.9756390714764591200000000000f,   // 14077: sin(77.3272705)
   0.9756600999652715900000000000f,   // 14078: sin(77.3327637)
   0.9756811194860257600000000000f,   // 14079: sin(77.3382568)
   0.9757021300385285700000000000f,   // 14080: sin(77.3437500)
   0.9757231316225867300000000000f,   // 14081: sin(77.3492432)
   0.9757441242380072700000000000f,   // 14082: sin(77.3547363)
   0.9757651078845973600000000000f,   // 14083: sin(77.3602295)
   0.9757860825621639300000000000f,   // 14084: sin(77.3657227)
   0.9758070482705142300000000000f,   // 14085: sin(77.3712158)
   0.9758280050094555500000000000f,   // 14086: sin(77.3767090)
   0.9758489527787953500000000000f,   // 14087: sin(77.3822021)
   0.9758698915783410300000000000f,   // 14088: sin(77.3876953)
   0.9758908214079000700000000000f,   // 14089: sin(77.3931885)
   0.9759117422672801700000000000f,   // 14090: sin(77.3986816)
   0.9759326541562889400000000000f,   // 14091: sin(77.4041748)
   0.9759535570747343000000000000f,   // 14092: sin(77.4096680)
   0.9759744510224239700000000000f,   // 14093: sin(77.4151611)
   0.9759953359991658800000000000f,   // 14094: sin(77.4206543)
   0.9760162120047682900000000000f,   // 14095: sin(77.4261475)
   0.9760370790390390200000000000f,   // 14096: sin(77.4316406)
   0.9760579371017865700000000000f,   // 14097: sin(77.4371338)
   0.9760787861928188500000000000f,   // 14098: sin(77.4426270)
   0.9760996263119445800000000000f,   // 14099: sin(77.4481201)
   0.9761204574589719100000000000f,   // 14100: sin(77.4536133)
   0.9761412796337095600000000000f,   // 14101: sin(77.4591064)
   0.9761620928359661100000000000f,   // 14102: sin(77.4645996)
   0.9761828970655501700000000000f,   // 14103: sin(77.4700928)
   0.9762036923222705600000000000f,   // 14104: sin(77.4755859)
   0.9762244786059360900000000000f,   // 14105: sin(77.4810791)
   0.9762452559163558000000000000f,   // 14106: sin(77.4865723)
   0.9762660242533386400000000000f,   // 14107: sin(77.4920654)
   0.9762867836166936300000000000f,   // 14108: sin(77.4975586)
   0.9763075340062301600000000000f,   // 14109: sin(77.5030518)
   0.9763282754217572600000000000f,   // 14110: sin(77.5085449)
   0.9763490078630844300000000000f,   // 14111: sin(77.5140381)
   0.9763697313300211400000000000f,   // 14112: sin(77.5195313)
   0.9763904458223767700000000000f,   // 14113: sin(77.5250244)
   0.9764111513399610400000000000f,   // 14114: sin(77.5305176)
   0.9764318478825835300000000000f,   // 14115: sin(77.5360107)
   0.9764525354500540600000000000f,   // 14116: sin(77.5415039)
   0.9764732140421824600000000000f,   // 14117: sin(77.5469971)
   0.9764938836587785400000000000f,   // 14118: sin(77.5524902)
   0.9765145442996525600000000000f,   // 14119: sin(77.5579834)
   0.9765351959646144700000000000f,   // 14120: sin(77.5634766)
   0.9765558386534744000000000000f,   // 14121: sin(77.5689697)
   0.9765764723660426100000000000f,   // 14122: sin(77.5744629)
   0.9765970971021296100000000000f,   // 14123: sin(77.5799561)
   0.9766177128615456400000000000f,   // 14124: sin(77.5854492)
   0.9766383196441011900000000000f,   // 14125: sin(77.5909424)
   0.9766589174496069800000000000f,   // 14126: sin(77.5964355)
   0.9766795062778735900000000000f,   // 14127: sin(77.6019287)
   0.9767000861287118400000000000f,   // 14128: sin(77.6074219)
   0.9767206570019324500000000000f,   // 14129: sin(77.6129150)
   0.9767412188973465500000000000f,   // 14130: sin(77.6184082)
   0.9767617718147648700000000000f,   // 14131: sin(77.6239014)
   0.9767823157539986500000000000f,   // 14132: sin(77.6293945)
   0.9768028507148590600000000000f,   // 14133: sin(77.6348877)
   0.9768233766971572400000000000f,   // 14134: sin(77.6403809)
   0.9768438937007046800000000000f,   // 14135: sin(77.6458740)
   0.9768644017253126400000000000f,   // 14136: sin(77.6513672)
   0.9768849007707927100000000000f,   // 14137: sin(77.6568604)
   0.9769053908369564900000000000f,   // 14138: sin(77.6623535)
   0.9769258719236154600000000000f,   // 14139: sin(77.6678467)
   0.9769463440305815600000000000f,   // 14140: sin(77.6733398)
   0.9769668071576665900000000000f,   // 14141: sin(77.6788330)
   0.9769872613046823900000000000f,   // 14142: sin(77.6843262)
   0.9770077064714409700000000000f,   // 14143: sin(77.6898193)
   0.9770281426577543900000000000f,   // 14144: sin(77.6953125)
   0.9770485698634346900000000000f,   // 14145: sin(77.7008057)
   0.9770689880882944500000000000f,   // 14146: sin(77.7062988)
   0.9770893973321456100000000000f,   // 14147: sin(77.7117920)
   0.9771097975948008800000000000f,   // 14148: sin(77.7172852)
   0.9771301888760725000000000000f,   // 14149: sin(77.7227783)
   0.9771505711757732000000000000f,   // 14150: sin(77.7282715)
   0.9771709444937155500000000000f,   // 14151: sin(77.7337646)
   0.9771913088297122800000000000f,   // 14152: sin(77.7392578)
   0.9772116641835761900000000000f,   // 14153: sin(77.7447510)
   0.9772320105551203200000000000f,   // 14154: sin(77.7502441)
   0.9772523479441575000000000000f,   // 14155: sin(77.7557373)
   0.9772726763505008600000000000f,   // 14156: sin(77.7612305)
   0.9772929957739635600000000000f,   // 14157: sin(77.7667236)
   0.9773133062143587500000000000f,   // 14158: sin(77.7722168)
   0.9773336076714996800000000000f,   // 14159: sin(77.7777100)
   0.9773539001451999600000000000f,   // 14160: sin(77.7832031)
   0.9773741836352729500000000000f,   // 14161: sin(77.7886963)
   0.9773944581415322500000000000f,   // 14162: sin(77.7941895)
   0.9774147236637914500000000000f,   // 14163: sin(77.7996826)
   0.9774349802018642600000000000f,   // 14164: sin(77.8051758)
   0.9774552277555644800000000000f,   // 14165: sin(77.8106689)
   0.9774754663247060500000000000f,   // 14166: sin(77.8161621)
   0.9774956959091030100000000000f,   // 14167: sin(77.8216553)
   0.9775159165085692800000000000f,   // 14168: sin(77.8271484)
   0.9775361281229190100000000000f,   // 14169: sin(77.8326416)
   0.9775563307519664600000000000f,   // 14170: sin(77.8381348)
   0.9775765243955260000000000000f,   // 14171: sin(77.8436279)
   0.9775967090534117800000000000f,   // 14172: sin(77.8491211)
   0.9776168847254386200000000000f,   // 14173: sin(77.8546143)
   0.9776370514114207700000000000f,   // 14174: sin(77.8601074)
   0.9776572091111730400000000000f,   // 14175: sin(77.8656006)
   0.9776773578245099300000000000f,   // 14176: sin(77.8710938)
   0.9776974975512464600000000000f,   // 14177: sin(77.8765869)
   0.9777176282911975700000000000f,   // 14178: sin(77.8820801)
   0.9777377500441778400000000000f,   // 14179: sin(77.8875732)
   0.9777578628100027600000000000f,   // 14180: sin(77.8930664)
   0.9777779665884871500000000000f,   // 14181: sin(77.8985596)
   0.9777980613794463600000000000f,   // 14182: sin(77.9040527)
   0.9778181471826956600000000000f,   // 14183: sin(77.9095459)
   0.9778382239980504300000000000f,   // 14184: sin(77.9150391)
   0.9778582918253260200000000000f,   // 14185: sin(77.9205322)
   0.9778783506643381500000000000f,   // 14186: sin(77.9260254)
   0.9778984005149022900000000000f,   // 14187: sin(77.9315186)
   0.9779184413768343700000000000f,   // 14188: sin(77.9370117)
   0.9779384732499498700000000000f,   // 14189: sin(77.9425049)
   0.9779584961340648300000000000f,   // 14190: sin(77.9479980)
   0.9779785100289952700000000000f,   // 14191: sin(77.9534912)
   0.9779985149345571400000000000f,   // 14192: sin(77.9589844)
   0.9780185108505664600000000000f,   // 14193: sin(77.9644775)
   0.9780384977768396000000000000f,   // 14194: sin(77.9699707)
   0.9780584757131928200000000000f,   // 14195: sin(77.9754639)
   0.9780784446594423800000000000f,   // 14196: sin(77.9809570)
   0.9780984046154047600000000000f,   // 14197: sin(77.9864502)
   0.9781183555808966600000000000f,   // 14198: sin(77.9919434)
   0.9781382975557344500000000000f,   // 14199: sin(77.9974365)
   0.9781582305397350500000000000f,   // 14200: sin(78.0029297)
   0.9781781545327150600000000000f,   // 14201: sin(78.0084229)
   0.9781980695344914000000000000f,   // 14202: sin(78.0139160)
   0.9782179755448811000000000000f,   // 14203: sin(78.0194092)
   0.9782378725637010900000000000f,   // 14204: sin(78.0249023)
   0.9782577605907685200000000000f,   // 14205: sin(78.0303955)
   0.9782776396259004200000000000f,   // 14206: sin(78.0358887)
   0.9782975096689143800000000000f,   // 14207: sin(78.0413818)
   0.9783173707196276500000000000f,   // 14208: sin(78.0468750)
   0.9783372227778575100000000000f,   // 14209: sin(78.0523682)
   0.9783570658434216400000000000f,   // 14210: sin(78.0578613)
   0.9783768999161376300000000000f,   // 14211: sin(78.0633545)
   0.9783967249958230900000000000f,   // 14212: sin(78.0688477)
   0.9784165410822958100000000000f,   // 14213: sin(78.0743408)
   0.9784363481753737300000000000f,   // 14214: sin(78.0798340)
   0.9784561462748747600000000000f,   // 14215: sin(78.0853271)
   0.9784759353806168300000000000f,   // 14216: sin(78.0908203)
   0.9784957154924180900000000000f,   // 14217: sin(78.0963135)
   0.9785154866100969100000000000f,   // 14218: sin(78.1018066)
   0.9785352487334712000000000000f,   // 14219: sin(78.1072998)
   0.9785550018623595500000000000f,   // 14220: sin(78.1127930)
   0.9785747459965804500000000000f,   // 14221: sin(78.1182861)
   0.9785944811359522700000000000f,   // 14222: sin(78.1237793)
   0.9786142072802935800000000000f,   // 14223: sin(78.1292725)
   0.9786339244294231000000000000f,   // 14224: sin(78.1347656)
   0.9786536325831597400000000000f,   // 14225: sin(78.1402588)
   0.9786733317413222100000000000f,   // 14226: sin(78.1457520)
   0.9786930219037294200000000000f,   // 14227: sin(78.1512451)
   0.9787127030702004200000000000f,   // 14228: sin(78.1567383)
   0.9787323752405543400000000000f,   // 14229: sin(78.1622314)
   0.9787520384146103400000000000f,   // 14230: sin(78.1677246)
   0.9787716925921876600000000000f,   // 14231: sin(78.1732178)
   0.9787913377731056700000000000f,   // 14232: sin(78.1787109)
   0.9788109739571837500000000000f,   // 14233: sin(78.1842041)
   0.9788306011442414700000000000f,   // 14234: sin(78.1896973)
   0.9788502193340983300000000000f,   // 14235: sin(78.1951904)
   0.9788698285265741200000000000f,   // 14236: sin(78.2006836)
   0.9788894287214884300000000000f,   // 14237: sin(78.2061768)
   0.9789090199186613100000000000f,   // 14238: sin(78.2116699)
   0.9789286021179125500000000000f,   // 14239: sin(78.2171631)
   0.9789481753190622000000000000f,   // 14240: sin(78.2226563)
   0.9789677395219302800000000000f,   // 14241: sin(78.2281494)
   0.9789872947263370500000000000f,   // 14242: sin(78.2336426)
   0.9790068409321026600000000000f,   // 14243: sin(78.2391357)
   0.9790263781390475800000000000f,   // 14244: sin(78.2446289)
   0.9790459063469921800000000000f,   // 14245: sin(78.2501221)
   0.9790654255557569300000000000f,   // 14246: sin(78.2556152)
   0.9790849357651623100000000000f,   // 14247: sin(78.2611084)
   0.9791044369750292500000000000f,   // 14248: sin(78.2666016)
   0.9791239291851782100000000000f,   // 14249: sin(78.2720947)
   0.9791434123954302300000000000f,   // 14250: sin(78.2775879)
   0.9791628866056061300000000000f,   // 14251: sin(78.2830811)
   0.9791823518155269300000000000f,   // 14252: sin(78.2885742)
   0.9792018080250137800000000000f,   // 14253: sin(78.2940674)
   0.9792212552338877000000000000f,   // 14254: sin(78.2995605)
   0.9792406934419699600000000000f,   // 14255: sin(78.3050537)
   0.9792601226490820200000000000f,   // 14256: sin(78.3105469)
   0.9792795428550451500000000000f,   // 14257: sin(78.3160400)
   0.9792989540596810400000000000f,   // 14258: sin(78.3215332)
   0.9793183562628109400000000000f,   // 14259: sin(78.3270264)
   0.9793377494642567800000000000f,   // 14260: sin(78.3325195)
   0.9793571336638402500000000000f,   // 14261: sin(78.3380127)
   0.9793765088613831700000000000f,   // 14262: sin(78.3435059)
   0.9793958750567073300000000000f,   // 14263: sin(78.3489990)
   0.9794152322496347800000000000f,   // 14264: sin(78.3544922)
   0.9794345804399876600000000000f,   // 14265: sin(78.3599854)
   0.9794539196275882100000000000f,   // 14266: sin(78.3654785)
   0.9794732498122583600000000000f,   // 14267: sin(78.3709717)
   0.9794925709938207000000000000f,   // 14268: sin(78.3764648)
   0.9795118831720975900000000000f,   // 14269: sin(78.3819580)
   0.9795311863469113900000000000f,   // 14270: sin(78.3874512)
   0.9795504805180849100000000000f,   // 14271: sin(78.3929443)
   0.9795697656854405200000000000f,   // 14272: sin(78.3984375)
   0.9795890418488011300000000000f,   // 14273: sin(78.4039307)
   0.9796083090079894500000000000f,   // 14274: sin(78.4094238)
   0.9796275671628285100000000000f,   // 14275: sin(78.4149170)
   0.9796468163131412100000000000f,   // 14276: sin(78.4204102)
   0.9796660564587506000000000000f,   // 14277: sin(78.4259033)
   0.9796852875994799300000000000f,   // 14278: sin(78.4313965)
   0.9797045097351523300000000000f,   // 14279: sin(78.4368896)
   0.9797237228655911700000000000f,   // 14280: sin(78.4423828)
   0.9797429269906197100000000000f,   // 14281: sin(78.4478760)
   0.9797621221100616400000000000f,   // 14282: sin(78.4533691)
   0.9797813082237404300000000000f,   // 14283: sin(78.4588623)
   0.9798004853314796800000000000f,   // 14284: sin(78.4643555)
   0.9798196534331032900000000000f,   // 14285: sin(78.4698486)
   0.9798388125284347400000000000f,   // 14286: sin(78.4753418)
   0.9798579626172982900000000000f,   // 14287: sin(78.4808350)
   0.9798771036995176400000000000f,   // 14288: sin(78.4863281)
   0.9798962357749170200000000000f,   // 14289: sin(78.4918213)
   0.9799153588433204800000000000f,   // 14290: sin(78.4973145)
   0.9799344729045522700000000000f,   // 14291: sin(78.5028076)
   0.9799535779584367400000000000f,   // 14292: sin(78.5083008)
   0.9799726740047982600000000000f,   // 14293: sin(78.5137939)
   0.9799917610434612000000000000f,   // 14294: sin(78.5192871)
   0.9800108390742502400000000000f,   // 14295: sin(78.5247803)
   0.9800299080969899800000000000f,   // 14296: sin(78.5302734)
   0.9800489681115052100000000000f,   // 14297: sin(78.5357666)
   0.9800680191176206500000000000f,   // 14298: sin(78.5412598)
   0.9800870611151612000000000000f,   // 14299: sin(78.5467529)
   0.9801060941039517700000000000f,   // 14300: sin(78.5522461)
   0.9801251180838175300000000000f,   // 14301: sin(78.5577393)
   0.9801441330545835900000000000f,   // 14302: sin(78.5632324)
   0.9801631390160751000000000000f,   // 14303: sin(78.5687256)
   0.9801821359681173200000000000f,   // 14304: sin(78.5742188)
   0.9802011239105358200000000000f,   // 14305: sin(78.5797119)
   0.9802201028431559700000000000f,   // 14306: sin(78.5852051)
   0.9802390727658033500000000000f,   // 14307: sin(78.5906982)
   0.9802580336783035500000000000f,   // 14308: sin(78.5961914)
   0.9802769855804822600000000000f,   // 14309: sin(78.6016846)
   0.9802959284721652900000000000f,   // 14310: sin(78.6071777)
   0.9803148623531785500000000000f,   // 14311: sin(78.6126709)
   0.9803337872233479600000000000f,   // 14312: sin(78.6181641)
   0.9803527030824996700000000000f,   // 14313: sin(78.6236572)
   0.9803716099304596900000000000f,   // 14314: sin(78.6291504)
   0.9803905077670543900000000000f,   // 14315: sin(78.6346436)
   0.9804093965921099100000000000f,   // 14316: sin(78.6401367)
   0.9804282764054526000000000000f,   // 14317: sin(78.6456299)
   0.9804471472069090600000000000f,   // 14318: sin(78.6511230)
   0.9804660089963057600000000000f,   // 14319: sin(78.6566162)
   0.9804848617734693800000000000f,   // 14320: sin(78.6621094)
   0.9805037055382265200000000000f,   // 14321: sin(78.6676025)
   0.9805225402904040900000000000f,   // 14322: sin(78.6730957)
   0.9805413660298288900000000000f,   // 14323: sin(78.6785889)
   0.9805601827563279500000000000f,   // 14324: sin(78.6840820)
   0.9805789904697281800000000000f,   // 14325: sin(78.6895752)
   0.9805977891698568500000000000f,   // 14326: sin(78.6950684)
   0.9806165788565410800000000000f,   // 14327: sin(78.7005615)
   0.9806353595296081200000000000f,   // 14328: sin(78.7060547)
   0.9806541311888854500000000000f,   // 14329: sin(78.7115479)
   0.9806728938342005300000000000f,   // 14330: sin(78.7170410)
   0.9806916474653808400000000000f,   // 14331: sin(78.7225342)
   0.9807103920822539700000000000f,   // 14332: sin(78.7280273)
   0.9807291276846477100000000000f,   // 14333: sin(78.7335205)
   0.9807478542723897500000000000f,   // 14334: sin(78.7390137)
   0.9807665718453080200000000000f,   // 14335: sin(78.7445068)
   0.9807852804032304300000000000f,   // 14336: sin(78.7500000)
   0.9808039799459851200000000000f,   // 14337: sin(78.7554932)
   0.9808226704733999900000000000f,   // 14338: sin(78.7609863)
   0.9808413519853035300000000000f,   // 14339: sin(78.7664795)
   0.9808600244815238700000000000f,   // 14340: sin(78.7719727)
   0.9808786879618893700000000000f,   // 14341: sin(78.7774658)
   0.9808973424262283900000000000f,   // 14342: sin(78.7829590)
   0.9809159878743696200000000000f,   // 14343: sin(78.7884521)
   0.9809346243061416400000000000f,   // 14344: sin(78.7939453)
   0.9809532517213731500000000000f,   // 14345: sin(78.7994385)
   0.9809718701198928400000000000f,   // 14346: sin(78.8049316)
   0.9809904795015297300000000000f,   // 14347: sin(78.8104248)
   0.9810090798661126300000000000f,   // 14348: sin(78.8159180)
   0.9810276712134705600000000000f,   // 14349: sin(78.8214111)
   0.9810462535434327800000000000f,   // 14350: sin(78.8269043)
   0.9810648268558284100000000000f,   // 14351: sin(78.8323975)
   0.9810833911504865900000000000f,   // 14352: sin(78.8378906)
   0.9811019464272369200000000000f,   // 14353: sin(78.8433838)
   0.9811204926859087300000000000f,   // 14354: sin(78.8488770)
   0.9811390299263315100000000000f,   // 14355: sin(78.8543701)
   0.9811575581483348300000000000f,   // 14356: sin(78.8598633)
   0.9811760773517486100000000000f,   // 14357: sin(78.8653564)
   0.9811945875364023200000000000f,   // 14358: sin(78.8708496)
   0.9812130887021260900000000000f,   // 14359: sin(78.8763428)
   0.9812315808487497300000000000f,   // 14360: sin(78.8818359)
   0.9812500639761031500000000000f,   // 14361: sin(78.8873291)
   0.9812685380840167100000000000f,   // 14362: sin(78.8928223)
   0.9812870031723204300000000000f,   // 14363: sin(78.8983154)
   0.9813054592408446700000000000f,   // 14364: sin(78.9038086)
   0.9813239062894196800000000000f,   // 14365: sin(78.9093018)
   0.9813423443178759300000000000f,   // 14366: sin(78.9147949)
   0.9813607733260441000000000000f,   // 14367: sin(78.9202881)
   0.9813791933137545600000000000f,   // 14368: sin(78.9257813)
   0.9813976042808381100000000000f,   // 14369: sin(78.9312744)
   0.9814160062271255500000000000f,   // 14370: sin(78.9367676)
   0.9814343991524476800000000000f,   // 14371: sin(78.9422607)
   0.9814527830566355200000000000f,   // 14372: sin(78.9477539)
   0.9814711579395200000000000000f,   // 14373: sin(78.9532471)
   0.9814895238009321300000000000f,   // 14374: sin(78.9587402)
   0.9815078806407032700000000000f,   // 14375: sin(78.9642334)
   0.9815262284586646600000000000f,   // 14376: sin(78.9697266)
   0.9815445672546476700000000000f,   // 14377: sin(78.9752197)
   0.9815628970284836500000000000f,   // 14378: sin(78.9807129)
   0.9815812177800040700000000000f,   // 14379: sin(78.9862061)
   0.9815995295090407200000000000f,   // 14380: sin(78.9916992)
   0.9816178322154250900000000000f,   // 14381: sin(78.9971924)
   0.9816361258989890800000000000f,   // 14382: sin(79.0026855)
   0.9816544105595643700000000000f,   // 14383: sin(79.0081787)
   0.9816726861969831100000000000f,   // 14384: sin(79.0136719)
   0.9816909528110772100000000000f,   // 14385: sin(79.0191650)
   0.9817092104016788000000000000f,   // 14386: sin(79.0246582)
   0.9817274589686199000000000000f,   // 14387: sin(79.0301514)
   0.9817456985117329900000000000f,   // 14388: sin(79.0356445)
   0.9817639290308503000000000000f,   // 14389: sin(79.0411377)
   0.9817821505258043100000000000f,   // 14390: sin(79.0466309)
   0.9818003629964275900000000000f,   // 14391: sin(79.0521240)
   0.9818185664425525000000000000f,   // 14392: sin(79.0576172)
   0.9818367608640119500000000000f,   // 14393: sin(79.0631104)
   0.9818549462606386300000000000f,   // 14394: sin(79.0686035)
   0.9818731226322653400000000000f,   // 14395: sin(79.0740967)
   0.9818912899787249900000000000f,   // 14396: sin(79.0795898)
   0.9819094482998507200000000000f,   // 14397: sin(79.0850830)
   0.9819275975954755400000000000f,   // 14398: sin(79.0905762)
   0.9819457378654326000000000000f,   // 14399: sin(79.0960693)
   0.9819638691095552400000000000f,   // 14400: sin(79.1015625)
   0.9819819913276767200000000000f,   // 14401: sin(79.1070557)
   0.9820001045196304900000000000f,   // 14402: sin(79.1125488)
   0.9820182086852500300000000000f,   // 14403: sin(79.1180420)
   0.9820363038243690200000000000f,   // 14404: sin(79.1235352)
   0.9820543899368211500000000000f,   // 14405: sin(79.1290283)
   0.9820724670224398900000000000f,   // 14406: sin(79.1345215)
   0.9820905350810594800000000000f,   // 14407: sin(79.1400146)
   0.9821085941125136100000000000f,   // 14408: sin(79.1455078)
   0.9821266441166361900000000000f,   // 14409: sin(79.1510010)
   0.9821446850932615800000000000f,   // 14410: sin(79.1564941)
   0.9821627170422238000000000000f,   // 14411: sin(79.1619873)
   0.9821807399633572000000000000f,   // 14412: sin(79.1674805)
   0.9821987538564959100000000000f,   // 14413: sin(79.1729736)
   0.9822167587214745100000000000f,   // 14414: sin(79.1784668)
   0.9822347545581274800000000000f,   // 14415: sin(79.1839600)
   0.9822527413662893700000000000f,   // 14416: sin(79.1894531)
   0.9822707191457948900000000000f,   // 14417: sin(79.1949463)
   0.9822886878964788300000000000f,   // 14418: sin(79.2004395)
   0.9823066476181759900000000000f,   // 14419: sin(79.2059326)
   0.9823245983107211600000000000f,   // 14420: sin(79.2114258)
   0.9823425399739496000000000000f,   // 14421: sin(79.2169189)
   0.9823604726076962100000000000f,   // 14422: sin(79.2224121)
   0.9823783962117961200000000000f,   // 14423: sin(79.2279053)
   0.9823963107860846900000000000f,   // 14424: sin(79.2333984)
   0.9824142163303972700000000000f,   // 14425: sin(79.2388916)
   0.9824321128445691100000000000f,   // 14426: sin(79.2443848)
   0.9824500003284358800000000000f,   // 14427: sin(79.2498779)
   0.9824678787818331700000000000f,   // 14428: sin(79.2553711)
   0.9824857482045965500000000000f,   // 14429: sin(79.2608643)
   0.9825036085965617200000000000f,   // 14430: sin(79.2663574)
   0.9825214599575646800000000000f,   // 14431: sin(79.2718506)
   0.9825393022874412400000000000f,   // 14432: sin(79.2773438)
   0.9825571355860274200000000000f,   // 14433: sin(79.2828369)
   0.9825749598531592400000000000f,   // 14434: sin(79.2883301)
   0.9825927750886729300000000000f,   // 14435: sin(79.2938232)
   0.9826105812924047500000000000f,   // 14436: sin(79.2993164)
   0.9826283784641910400000000000f,   // 14437: sin(79.3048096)
   0.9826461666038680500000000000f,   // 14438: sin(79.3103027)
   0.9826639457112724700000000000f,   // 14439: sin(79.3157959)
   0.9826817157862408600000000000f,   // 14440: sin(79.3212891)
   0.9826994768286097000000000000f,   // 14441: sin(79.3267822)
   0.9827172288382159900000000000f,   // 14442: sin(79.3322754)
   0.9827349718148963300000000000f,   // 14443: sin(79.3377686)
   0.9827527057584878300000000000f,   // 14444: sin(79.3432617)
   0.9827704306688273000000000000f,   // 14445: sin(79.3487549)
   0.9827881465457519700000000000f,   // 14446: sin(79.3542480)
   0.9828058533890988700000000000f,   // 14447: sin(79.3597412)
   0.9828235511987052400000000000f,   // 14448: sin(79.3652344)
   0.9828412399744085300000000000f,   // 14449: sin(79.3707275)
   0.9828589197160461100000000000f,   // 14450: sin(79.3762207)
   0.9828765904234554300000000000f,   // 14451: sin(79.3817139)
   0.9828942520964740700000000000f,   // 14452: sin(79.3872070)
   0.9829119047349397200000000000f,   // 14453: sin(79.3927002)
   0.9829295483386900600000000000f,   // 14454: sin(79.3981934)
   0.9829471829075630000000000000f,   // 14455: sin(79.4036865)
   0.9829648084413964400000000000f,   // 14456: sin(79.4091797)
   0.9829824249400283000000000000f,   // 14457: sin(79.4146729)
   0.9830000324032965900000000000f,   // 14458: sin(79.4201660)
   0.9830176308310396600000000000f,   // 14459: sin(79.4256592)
   0.9830352202230956400000000000f,   // 14460: sin(79.4311523)
   0.9830528005793027800000000000f,   // 14461: sin(79.4366455)
   0.9830703718994996400000000000f,   // 14462: sin(79.4421387)
   0.9830879341835245800000000000f,   // 14463: sin(79.4476318)
   0.9831054874312162900000000000f,   // 14464: sin(79.4531250)
   0.9831230316424133300000000000f,   // 14465: sin(79.4586182)
   0.9831405668169545000000000000f,   // 14466: sin(79.4641113)
   0.9831580929546784900000000000f,   // 14467: sin(79.4696045)
   0.9831756100554244200000000000f,   // 14468: sin(79.4750977)
   0.9831931181190311000000000000f,   // 14469: sin(79.4805908)
   0.9832106171453376400000000000f,   // 14470: sin(79.4860840)
   0.9832281071341832900000000000f,   // 14471: sin(79.4915771)
   0.9832455880854070700000000000f,   // 14472: sin(79.4970703)
   0.9832630599988485500000000000f,   // 14473: sin(79.5025635)
   0.9832805228743469700000000000f,   // 14474: sin(79.5080566)
   0.9832979767117419100000000000f,   // 14475: sin(79.5135498)
   0.9833154215108728100000000000f,   // 14476: sin(79.5190430)
   0.9833328572715793700000000000f,   // 14477: sin(79.5245361)
   0.9833502839937015000000000000f,   // 14478: sin(79.5300293)
   0.9833677016770787600000000000f,   // 14479: sin(79.5355225)
   0.9833851103215511800000000000f,   // 14480: sin(79.5410156)
   0.9834025099269587700000000000f,   // 14481: sin(79.5465088)
   0.9834199004931415400000000000f,   // 14482: sin(79.5520020)
   0.9834372820199396300000000000f,   // 14483: sin(79.5574951)
   0.9834546545071932700000000000f,   // 14484: sin(79.5629883)
   0.9834720179547428200000000000f,   // 14485: sin(79.5684814)
   0.9834893723624287300000000000f,   // 14486: sin(79.5739746)
   0.9835067177300912400000000000f,   // 14487: sin(79.5794678)
   0.9835240540575712600000000000f,   // 14488: sin(79.5849609)
   0.9835413813447092500000000000f,   // 14489: sin(79.5904541)
   0.9835586995913459000000000000f,   // 14490: sin(79.5959473)
   0.9835760087973219900000000000f,   // 14491: sin(79.6014404)
   0.9835933089624786500000000000f,   // 14492: sin(79.6069336)
   0.9836106000866566800000000000f,   // 14493: sin(79.6124268)
   0.9836278821696972100000000000f,   // 14494: sin(79.6179199)
   0.9836451552114412500000000000f,   // 14495: sin(79.6234131)
   0.9836624192117302500000000000f,   // 14496: sin(79.6289063)
   0.9836796741704053600000000000f,   // 14497: sin(79.6343994)
   0.9836969200873080200000000000f,   // 14498: sin(79.6398926)
   0.9837141569622798200000000000f,   // 14499: sin(79.6453857)
   0.9837313847951620900000000000f,   // 14500: sin(79.6508789)
   0.9837486035857966300000000000f,   // 14501: sin(79.6563721)
   0.9837658133340252400000000000f,   // 14502: sin(79.6618652)
   0.9837830140396896000000000000f,   // 14503: sin(79.6673584)
   0.9838002057026314900000000000f,   // 14504: sin(79.6728516)
   0.9838173883226931600000000000f,   // 14505: sin(79.6783447)
   0.9838345618997166300000000000f,   // 14506: sin(79.6838379)
   0.9838517264335437900000000000f,   // 14507: sin(79.6893311)
   0.9838688819240172200000000000f,   // 14508: sin(79.6948242)
   0.9838860283709789400000000000f,   // 14509: sin(79.7003174)
   0.9839031657742715000000000000f,   // 14510: sin(79.7058105)
   0.9839202941337372700000000000f,   // 14511: sin(79.7113037)
   0.9839374134492189200000000000f,   // 14512: sin(79.7167969)
   0.9839545237205590300000000000f,   // 14513: sin(79.7222900)
   0.9839716249476002700000000000f,   // 14514: sin(79.7277832)
   0.9839887171301856500000000000f,   // 14515: sin(79.7332764)
   0.9840058002681578700000000000f,   // 14516: sin(79.7387695)
   0.9840228743613599300000000000f,   // 14517: sin(79.7442627)
   0.9840399394096349700000000000f,   // 14518: sin(79.7497559)
   0.9840569954128261000000000000f,   // 14519: sin(79.7552490)
   0.9840740423707764500000000000f,   // 14520: sin(79.7607422)
   0.9840910802833294800000000000f,   // 14521: sin(79.7662354)
   0.9841081091503285400000000000f,   // 14522: sin(79.7717285)
   0.9841251289716170800000000000f,   // 14523: sin(79.7772217)
   0.9841421397470385700000000000f,   // 14524: sin(79.7827148)
   0.9841591414764367900000000000f,   // 14525: sin(79.7882080)
   0.9841761341596553200000000000f,   // 14526: sin(79.7937012)
   0.9841931177965381700000000000f,   // 14527: sin(79.7991943)
   0.9842100923869290300000000000f,   // 14528: sin(79.8046875)
   0.9842270579306720000000000000f,   // 14529: sin(79.8101807)
   0.9842440144276111100000000000f,   // 14530: sin(79.8156738)
   0.9842609618775904900000000000f,   // 14531: sin(79.8211670)
   0.9842779002804543700000000000f,   // 14532: sin(79.8266602)
   0.9842948296360469800000000000f,   // 14533: sin(79.8321533)
   0.9843117499442127800000000000f,   // 14534: sin(79.8376465)
   0.9843286612047962300000000000f,   // 14535: sin(79.8431396)
   0.9843455634176419000000000000f,   // 14536: sin(79.8486328)
   0.9843624565825944700000000000f,   // 14537: sin(79.8541260)
   0.9843793406994985100000000000f,   // 14538: sin(79.8596191)
   0.9843962157681990200000000000f,   // 14539: sin(79.8651123)
   0.9844130817885407000000000000f,   // 14540: sin(79.8706055)
   0.9844299387603686600000000000f,   // 14541: sin(79.8760986)
   0.9844467866835279200000000000f,   // 14542: sin(79.8815918)
   0.9844636255578636000000000000f,   // 14543: sin(79.8870850)
   0.9844804553832209300000000000f,   // 14544: sin(79.8925781)
   0.9844972761594451600000000000f,   // 14545: sin(79.8980713)
   0.9845140878863818400000000000f,   // 14546: sin(79.9035645)
   0.9845308905638762200000000000f,   // 14547: sin(79.9090576)
   0.9845476841917739600000000000f,   // 14548: sin(79.9145508)
   0.9845644687699207600000000000f,   // 14549: sin(79.9200439)
   0.9845812442981621800000000000f,   // 14550: sin(79.9255371)
   0.9845980107763442300000000000f,   // 14551: sin(79.9310303)
   0.9846147682043126000000000000f,   // 14552: sin(79.9365234)
   0.9846315165819133900000000000f,   // 14553: sin(79.9420166)
   0.9846482559089926300000000000f,   // 14554: sin(79.9475098)
   0.9846649861853963300000000000f,   // 14555: sin(79.9530029)
   0.9846817074109709400000000000f,   // 14556: sin(79.9584961)
   0.9846984195855625900000000000f,   // 14557: sin(79.9639893)
   0.9847151227090176200000000000f,   // 14558: sin(79.9694824)
   0.9847318167811827100000000000f,   // 14559: sin(79.9749756)
   0.9847485018019042100000000000f,   // 14560: sin(79.9804688)
   0.9847651777710289000000000000f,   // 14561: sin(79.9859619)
   0.9847818446884033500000000000f,   // 14562: sin(79.9914551)
   0.9847985025538744700000000000f,   // 14563: sin(79.9969482)
   0.9848151513672891400000000000f,   // 14564: sin(80.0024414)
   0.9848317911284942800000000000f,   // 14565: sin(80.0079346)
   0.9848484218373370100000000000f,   // 14566: sin(80.0134277)
   0.9848650434936644400000000000f,   // 14567: sin(80.0189209)
   0.9848816560973237000000000000f,   // 14568: sin(80.0244141)
   0.9848982596481621300000000000f,   // 14569: sin(80.0299072)
   0.9849148541460272000000000000f,   // 14570: sin(80.0354004)
   0.9849314395907663400000000000f,   // 14571: sin(80.0408936)
   0.9849480159822270300000000000f,   // 14572: sin(80.0463867)
   0.9849645833202570500000000000f,   // 14573: sin(80.0518799)
   0.9849811416047039600000000000f,   // 14574: sin(80.0573730)
   0.9849976908354155500000000000f,   // 14575: sin(80.0628662)
   0.9850142310122398400000000000f,   // 14576: sin(80.0683594)
   0.9850307621350247200000000000f,   // 14577: sin(80.0738525)
   0.9850472842036182000000000000f,   // 14578: sin(80.0793457)
   0.9850637972178685200000000000f,   // 14579: sin(80.0848389)
   0.9850803011776238000000000000f,   // 14580: sin(80.0903320)
   0.9850967960827323700000000000f,   // 14581: sin(80.0958252)
   0.9851132819330425900000000000f,   // 14582: sin(80.1013184)
   0.9851297587284030300000000000f,   // 14583: sin(80.1068115)
   0.9851462264686622300000000000f,   // 14584: sin(80.1123047)
   0.9851626851536685600000000000f,   // 14585: sin(80.1177979)
   0.9851791347832710200000000000f,   // 14586: sin(80.1232910)
   0.9851955753573183900000000000f,   // 14587: sin(80.1287842)
   0.9852120068756594600000000000f,   // 14588: sin(80.1342773)
   0.9852284293381431400000000000f,   // 14589: sin(80.1397705)
   0.9852448427446185400000000000f,   // 14590: sin(80.1452637)
   0.9852612470949349000000000000f,   // 14591: sin(80.1507568)
   0.9852776423889412200000000000f,   // 14592: sin(80.1562500)
   0.9852940286264869600000000000f,   // 14593: sin(80.1617432)
   0.9853104058074215700000000000f,   // 14594: sin(80.1672363)
   0.9853267739315942900000000000f,   // 14595: sin(80.1727295)
   0.9853431329988547900000000000f,   // 14596: sin(80.1782227)
   0.9853594830090527400000000000f,   // 14597: sin(80.1837158)
   0.9853758239620377100000000000f,   // 14598: sin(80.1892090)
   0.9853921558576596000000000000f,   // 14599: sin(80.1947021)
   0.9854084786957684200000000000f,   // 14600: sin(80.2001953)
   0.9854247924762139500000000000f,   // 14601: sin(80.2056885)
   0.9854410971988462100000000000f,   // 14602: sin(80.2111816)
   0.9854573928635154100000000000f,   // 14603: sin(80.2166748)
   0.9854736794700718100000000000f,   // 14604: sin(80.2221680)
   0.9854899570183657300000000000f,   // 14605: sin(80.2276611)
   0.9855062255082472900000000000f,   // 14606: sin(80.2331543)
   0.9855224849395672900000000000f,   // 14607: sin(80.2386475)
   0.9855387353121760600000000000f,   // 14608: sin(80.2441406)
   0.9855549766259242800000000000f,   // 14609: sin(80.2496338)
   0.9855712088806627400000000000f,   // 14610: sin(80.2551270)
   0.9855874320762422200000000000f,   // 14611: sin(80.2606201)
   0.9856036462125134000000000000f,   // 14612: sin(80.2661133)
   0.9856198512893275000000000000f,   // 14613: sin(80.2716064)
   0.9856360473065354200000000000f,   // 14614: sin(80.2770996)
   0.9856522342639884000000000000f,   // 14615: sin(80.2825928)
   0.9856684121615375500000000000f,   // 14616: sin(80.2880859)
   0.9856845809990342200000000000f,   // 14617: sin(80.2935791)
   0.9857007407763298500000000000f,   // 14618: sin(80.2990723)
   0.9857168914932756800000000000f,   // 14619: sin(80.3045654)
   0.9857330331497234900000000000f,   // 14620: sin(80.3100586)
   0.9857491657455248500000000000f,   // 14621: sin(80.3155518)
   0.9857652892805313100000000000f,   // 14622: sin(80.3210449)
   0.9857814037545948900000000000f,   // 14623: sin(80.3265381)
   0.9857975091675673700000000000f,   // 14624: sin(80.3320313)
   0.9858136055193007500000000000f,   // 14625: sin(80.3375244)
   0.9858296928096470500000000000f,   // 14626: sin(80.3430176)
   0.9858457710384583800000000000f,   // 14627: sin(80.3485107)
   0.9858618402055869800000000000f,   // 14628: sin(80.3540039)
   0.9858779003108850700000000000f,   // 14629: sin(80.3594971)
   0.9858939513542052100000000000f,   // 14630: sin(80.3649902)
   0.9859099933353997500000000000f,   // 14631: sin(80.3704834)
   0.9859260262543211300000000000f,   // 14632: sin(80.3759766)
   0.9859420501108221400000000000f,   // 14633: sin(80.3814697)
   0.9859580649047554600000000000f,   // 14634: sin(80.3869629)
   0.9859740706359737500000000000f,   // 14635: sin(80.3924561)
   0.9859900673043300300000000000f,   // 14636: sin(80.3979492)
   0.9860060549096773000000000000f,   // 14637: sin(80.4034424)
   0.9860220334518685600000000000f,   // 14638: sin(80.4089355)
   0.9860380029307568300000000000f,   // 14639: sin(80.4144287)
   0.9860539633461954400000000000f,   // 14640: sin(80.4199219)
   0.9860699146980376200000000000f,   // 14641: sin(80.4254150)
   0.9860858569861368200000000000f,   // 14642: sin(80.4309082)
   0.9861017902103463900000000000f,   // 14643: sin(80.4364014)
   0.9861177143705200900000000000f,   // 14644: sin(80.4418945)
   0.9861336294665112900000000000f,   // 14645: sin(80.4473877)
   0.9861495354981738600000000000f,   // 14646: sin(80.4528809)
   0.9861654324653614800000000000f,   // 14647: sin(80.4583740)
   0.9861813203679282700000000000f,   // 14648: sin(80.4638672)
   0.9861971992057279000000000000f,   // 14649: sin(80.4693604)
   0.9862130689786144900000000000f,   // 14650: sin(80.4748535)
   0.9862289296864422700000000000f,   // 14651: sin(80.4803467)
   0.9862447813290654600000000000f,   // 14652: sin(80.4858398)
   0.9862606239063381700000000000f,   // 14653: sin(80.4913330)
   0.9862764574181149800000000000f,   // 14654: sin(80.4968262)
   0.9862922818642503300000000000f,   // 14655: sin(80.5023193)
   0.9863080972445986700000000000f,   // 14656: sin(80.5078125)
   0.9863239035590145600000000000f,   // 14657: sin(80.5133057)
   0.9863397008073530000000000000f,   // 14658: sin(80.5187988)
   0.9863554889894684500000000000f,   // 14659: sin(80.5242920)
   0.9863712681052160300000000000f,   // 14660: sin(80.5297852)
   0.9863870381544506100000000000f,   // 14661: sin(80.5352783)
   0.9864027991370272200000000000f,   // 14662: sin(80.5407715)
   0.9864185510528009600000000000f,   // 14663: sin(80.5462646)
   0.9864342939016270700000000000f,   // 14664: sin(80.5517578)
   0.9864500276833609900000000000f,   // 14665: sin(80.5572510)
   0.9864657523978579400000000000f,   // 14666: sin(80.5627441)
   0.9864814680449733900000000000f,   // 14667: sin(80.5682373)
   0.9864971746245628800000000000f,   // 14668: sin(80.5737305)
   0.9865128721364820900000000000f,   // 14669: sin(80.5792236)
   0.9865285605805866900000000000f,   // 14670: sin(80.5847168)
   0.9865442399567325700000000000f,   // 14671: sin(80.5902100)
   0.9865599102647754100000000000f,   // 14672: sin(80.5957031)
   0.9865755715045714200000000000f,   // 14673: sin(80.6011963)
   0.9865912236759764000000000000f,   // 14674: sin(80.6066895)
   0.9866068667788466800000000000f,   // 14675: sin(80.6121826)
   0.9866225008130384800000000000f,   // 14676: sin(80.6176758)
   0.9866381257784078200000000000f,   // 14677: sin(80.6231689)
   0.9866537416748113500000000000f,   // 14678: sin(80.6286621)
   0.9866693485021055300000000000f,   // 14679: sin(80.6341553)
   0.9866849462601466900000000000f,   // 14680: sin(80.6396484)
   0.9867005349487916200000000000f,   // 14681: sin(80.6451416)
   0.9867161145678971000000000000f,   // 14682: sin(80.6506348)
   0.9867316851173196800000000000f,   // 14683: sin(80.6561279)
   0.9867472465969164800000000000f,   // 14684: sin(80.6616211)
   0.9867627990065444000000000000f,   // 14685: sin(80.6671143)
   0.9867783423460604300000000000f,   // 14686: sin(80.6726074)
   0.9867938766153217000000000000f,   // 14687: sin(80.6781006)
   0.9868094018141854200000000000f,   // 14688: sin(80.6835938)
   0.9868249179425090400000000000f,   // 14689: sin(80.6890869)
   0.9868404250001496800000000000f,   // 14690: sin(80.6945801)
   0.9868559229869650100000000000f,   // 14691: sin(80.7000732)
   0.9868714119028124700000000000f,   // 14692: sin(80.7055664)
   0.9868868917475497300000000000f,   // 14693: sin(80.7110596)
   0.9869023625210344700000000000f,   // 14694: sin(80.7165527)
   0.9869178242231244600000000000f,   // 14695: sin(80.7220459)
   0.9869332768536777100000000000f,   // 14696: sin(80.7275391)
   0.9869487204125521100000000000f,   // 14697: sin(80.7330322)
   0.9869641548996056500000000000f,   // 14698: sin(80.7385254)
   0.9869795803146965700000000000f,   // 14699: sin(80.7440186)
   0.9869949966576828700000000000f,   // 14700: sin(80.7495117)
   0.9870104039284232100000000000f,   // 14701: sin(80.7550049)
   0.9870258021267756000000000000f,   // 14702: sin(80.7604980)
   0.9870411912525987000000000000f,   // 14703: sin(80.7659912)
   0.9870565713057509700000000000f,   // 14704: sin(80.7714844)
   0.9870719422860911900000000000f,   // 14705: sin(80.7769775)
   0.9870873041934779000000000000f,   // 14706: sin(80.7824707)
   0.9871026570277698900000000000f,   // 14707: sin(80.7879639)
   0.9871180007888262800000000000f,   // 14708: sin(80.7934570)
   0.9871333354765057200000000000f,   // 14709: sin(80.7989502)
   0.9871486610906675700000000000f,   // 14710: sin(80.8044434)
   0.9871639776311705900000000000f,   // 14711: sin(80.8099365)
   0.9871792850978743400000000000f,   // 14712: sin(80.8154297)
   0.9871945834906379300000000000f,   // 14713: sin(80.8209229)
   0.9872098728093208200000000000f,   // 14714: sin(80.8264160)
   0.9872251530537824400000000000f,   // 14715: sin(80.8319092)
   0.9872404242238822500000000000f,   // 14716: sin(80.8374023)
   0.9872556863194800200000000000f,   // 14717: sin(80.8428955)
   0.9872709393404354200000000000f,   // 14718: sin(80.8483887)
   0.9872861832866082200000000000f,   // 14719: sin(80.8538818)
   0.9873014181578584300000000000f,   // 14720: sin(80.8593750)
   0.9873166439540457300000000000f,   // 14721: sin(80.8648682)
   0.9873318606750304300000000000f,   // 14722: sin(80.8703613)
   0.9873470683206726500000000000f,   // 14723: sin(80.8758545)
   0.9873622668908324000000000000f,   // 14724: sin(80.8813477)
   0.9873774563853701100000000000f,   // 14725: sin(80.8868408)
   0.9873926368041462400000000000f,   // 14726: sin(80.8923340)
   0.9874078081470211200000000000f,   // 14727: sin(80.8978271)
   0.9874229704138554100000000000f,   // 14728: sin(80.9033203)
   0.9874381236045095500000000000f,   // 14729: sin(80.9088135)
   0.9874532677188445600000000000f,   // 14730: sin(80.9143066)
   0.9874684027567208800000000000f,   // 14731: sin(80.9197998)
   0.9874835287179997100000000000f,   // 14732: sin(80.9252930)
   0.9874986456025418600000000000f,   // 14733: sin(80.9307861)
   0.9875137534102084200000000000f,   // 14734: sin(80.9362793)
   0.9875288521408605000000000000f,   // 14735: sin(80.9417725)
   0.9875439417943592300000000000f,   // 14736: sin(80.9472656)
   0.9875590223705661400000000000f,   // 14737: sin(80.9527588)
   0.9875740938693423600000000000f,   // 14738: sin(80.9582520)
   0.9875891562905495500000000000f,   // 14739: sin(80.9637451)
   0.9876042096340491600000000000f,   // 14740: sin(80.9692383)
   0.9876192538997027300000000000f,   // 14741: sin(80.9747314)
   0.9876342890873721600000000000f,   // 14742: sin(80.9802246)
   0.9876493151969192300000000000f,   // 14743: sin(80.9857178)
   0.9876643322282057100000000000f,   // 14744: sin(80.9912109)
   0.9876793401810936000000000000f,   // 14745: sin(80.9967041)
   0.9876943390554451300000000000f,   // 14746: sin(81.0021973)
   0.9877093288511221700000000000f,   // 14747: sin(81.0076904)
   0.9877243095679869600000000000f,   // 14748: sin(81.0131836)
   0.9877392812059020400000000000f,   // 14749: sin(81.0186768)
   0.9877542437647295300000000000f,   // 14750: sin(81.0241699)
   0.9877691972443321000000000000f,   // 14751: sin(81.0296631)
   0.9877841416445721800000000000f,   // 14752: sin(81.0351563)
   0.9877990769653124400000000000f,   // 14753: sin(81.0406494)
   0.9878140032064155500000000000f,   // 14754: sin(81.0461426)
   0.9878289203677443900000000000f,   // 14755: sin(81.0516357)
   0.9878438284491617400000000000f,   // 14756: sin(81.0571289)
   0.9878587274505307200000000000f,   // 14757: sin(81.0626221)
   0.9878736173717142000000000000f,   // 14758: sin(81.0681152)
   0.9878884982125755200000000000f,   // 14759: sin(81.0736084)
   0.9879033699729777900000000000f,   // 14760: sin(81.0791016)
   0.9879182326527842200000000000f,   // 14761: sin(81.0845947)
   0.9879330862518583800000000000f,   // 14762: sin(81.0900879)
   0.9879479307700636000000000000f,   // 14763: sin(81.0955811)
   0.9879627662072634200000000000f,   // 14764: sin(81.1010742)
   0.9879775925633216300000000000f,   // 14765: sin(81.1065674)
   0.9879924098381018800000000000f,   // 14766: sin(81.1120605)
   0.9880072180314678500000000000f,   // 14767: sin(81.1175537)
   0.9880220171432835300000000000f,   // 14768: sin(81.1230469)
   0.9880368071734129100000000000f,   // 14769: sin(81.1285400)
   0.9880515881217201100000000000f,   // 14770: sin(81.1340332)
   0.9880663599880690200000000000f,   // 14771: sin(81.1395264)
   0.9880811227723240700000000000f,   // 14772: sin(81.1450195)
   0.9880958764743496000000000000f,   // 14773: sin(81.1505127)
   0.9881106210940098200000000000f,   // 14774: sin(81.1560059)
   0.9881253566311692900000000000f,   // 14775: sin(81.1614990)
   0.9881400830856925700000000000f,   // 14776: sin(81.1669922)
   0.9881548004574441900000000000f,   // 14777: sin(81.1724854)
   0.9881695087462890600000000000f,   // 14778: sin(81.1779785)
   0.9881842079520919400000000000f,   // 14779: sin(81.1834717)
   0.9881988980747176100000000000f,   // 14780: sin(81.1889648)
   0.9882135791140310700000000000f,   // 14781: sin(81.1944580)
   0.9882282510698974200000000000f,   // 14782: sin(81.1999512)
   0.9882429139421818900000000000f,   // 14783: sin(81.2054443)
   0.9882575677307494600000000000f,   // 14784: sin(81.2109375)
   0.9882722124354655900000000000f,   // 14785: sin(81.2164307)
   0.9882868480561957100000000000f,   // 14786: sin(81.2219238)
   0.9883014745928052600000000000f,   // 14787: sin(81.2274170)
   0.9883160920451596900000000000f,   // 14788: sin(81.2329102)
   0.9883307004131247600000000000f,   // 14789: sin(81.2384033)
   0.9883452996965661500000000000f,   // 14790: sin(81.2438965)
   0.9883598898953497300000000000f,   // 14791: sin(81.2493896)
   0.9883744710093412800000000000f,   // 14792: sin(81.2548828)
   0.9883890430384068000000000000f,   // 14793: sin(81.2603760)
   0.9884036059824123900000000000f,   // 14794: sin(81.2658691)
   0.9884181598412241600000000000f,   // 14795: sin(81.2713623)
   0.9884327046147083400000000000f,   // 14796: sin(81.2768555)
   0.9884472403027312300000000000f,   // 14797: sin(81.2823486)
   0.9884617669051593000000000000f,   // 14798: sin(81.2878418)
   0.9884762844218588600000000000f,   // 14799: sin(81.2933350)
   0.9884907928526965900000000000f,   // 14800: sin(81.2988281)
   0.9885052921975392400000000000f,   // 14801: sin(81.3043213)
   0.9885197824562532700000000000f,   // 14802: sin(81.3098145)
   0.9885342636287056700000000000f,   // 14803: sin(81.3153076)
   0.9885487357147632000000000000f,   // 14804: sin(81.3208008)
   0.9885631987142929900000000000f,   // 14805: sin(81.3262939)
   0.9885776526271620200000000000f,   // 14806: sin(81.3317871)
   0.9885920974532375100000000000f,   // 14807: sin(81.3372803)
   0.9886065331923864500000000000f,   // 14808: sin(81.3427734)
   0.9886209598444764000000000000f,   // 14809: sin(81.3482666)
   0.9886353774093747900000000000f,   // 14810: sin(81.3537598)
   0.9886497858869488500000000000f,   // 14811: sin(81.3592529)
   0.9886641852770662300000000000f,   // 14812: sin(81.3647461)
   0.9886785755795947100000000000f,   // 14813: sin(81.3702393)
   0.9886929567944019400000000000f,   // 14814: sin(81.3757324)
   0.9887073289213556000000000000f,   // 14815: sin(81.3812256)
   0.9887216919603237800000000000f,   // 14816: sin(81.3867188)
   0.9887360459111743700000000000f,   // 14817: sin(81.3922119)
   0.9887503907737753600000000000f,   // 14818: sin(81.3977051)
   0.9887647265479949700000000000f,   // 14819: sin(81.4031982)
   0.9887790532337015200000000000f,   // 14820: sin(81.4086914)
   0.9887933708307632400000000000f,   // 14821: sin(81.4141846)
   0.9888076793390483400000000000f,   // 14822: sin(81.4196777)
   0.9888219787584257000000000000f,   // 14823: sin(81.4251709)
   0.9888362690887635400000000000f,   // 14824: sin(81.4306641)
   0.9888505503299306300000000000f,   // 14825: sin(81.4361572)
   0.9888648224817956400000000000f,   // 14826: sin(81.4416504)
   0.9888790855442275400000000000f,   // 14827: sin(81.4471436)
   0.9888933395170951300000000000f,   // 14828: sin(81.4526367)
   0.9889075844002672700000000000f,   // 14829: sin(81.4581299)
   0.9889218201936131900000000000f,   // 14830: sin(81.4636230)
   0.9889360468970021000000000000f,   // 14831: sin(81.4691162)
   0.9889502645103029900000000000f,   // 14832: sin(81.4746094)
   0.9889644730333853100000000000f,   // 14833: sin(81.4801025)
   0.9889786724661184800000000000f,   // 14834: sin(81.4855957)
   0.9889928628083719500000000000f,   // 14835: sin(81.4910889)
   0.9890070440600152700000000000f,   // 14836: sin(81.4965820)
   0.9890212162209181000000000000f,   // 14837: sin(81.5020752)
   0.9890353792909503100000000000f,   // 14838: sin(81.5075684)
   0.9890495332699814600000000000f,   // 14839: sin(81.5130615)
   0.9890636781578815400000000000f,   // 14840: sin(81.5185547)
   0.9890778139545206600000000000f,   // 14841: sin(81.5240479)
   0.9890919406597688000000000000f,   // 14842: sin(81.5295410)
   0.9891060582734959600000000000f,   // 14843: sin(81.5350342)
   0.9891201667955726900000000000f,   // 14844: sin(81.5405273)
   0.9891342662258690900000000000f,   // 14845: sin(81.5460205)
   0.9891483565642555900000000000f,   // 14846: sin(81.5515137)
   0.9891624378106026500000000000f,   // 14847: sin(81.5570068)
   0.9891765099647810100000000000f,   // 14848: sin(81.5625000)
   0.9891905730266610200000000000f,   // 14849: sin(81.5679932)
   0.9892046269961137800000000000f,   // 14850: sin(81.5734863)
   0.9892186718730098200000000000f,   // 14851: sin(81.5789795)
   0.9892327076572200500000000000f,   // 14852: sin(81.5844727)
   0.9892467343486156500000000000f,   // 14853: sin(81.5899658)
   0.9892607519470676400000000000f,   // 14854: sin(81.5954590)
   0.9892747604524470000000000000f,   // 14855: sin(81.6009521)
   0.9892887598646251700000000000f,   // 14856: sin(81.6064453)
   0.9893027501834733600000000000f,   // 14857: sin(81.6119385)
   0.9893167314088630000000000000f,   // 14858: sin(81.6174316)
   0.9893307035406655500000000000f,   // 14859: sin(81.6229248)
   0.9893446665787526400000000000f,   // 14860: sin(81.6284180)
   0.9893586205229958400000000000f,   // 14861: sin(81.6339111)
   0.9893725653732670100000000000f,   // 14862: sin(81.6394043)
   0.9893865011294378200000000000f,   // 14863: sin(81.6448975)
   0.9894004277913803800000000000f,   // 14864: sin(81.6503906)
   0.9894143453589664400000000000f,   // 14865: sin(81.6558838)
   0.9894282538320682300000000000f,   // 14866: sin(81.6613770)
   0.9894421532105579500000000000f,   // 14867: sin(81.6668701)
   0.9894560434943077100000000000f,   // 14868: sin(81.6723633)
   0.9894699246831898400000000000f,   // 14869: sin(81.6778564)
   0.9894837967770767600000000000f,   // 14870: sin(81.6833496)
   0.9894976597758410300000000000f,   // 14871: sin(81.6888428)
   0.9895115136793551900000000000f,   // 14872: sin(81.6943359)
   0.9895253584874919000000000000f,   // 14873: sin(81.6998291)
   0.9895391942001239300000000000f,   // 14874: sin(81.7053223)
   0.9895530208171240400000000000f,   // 14875: sin(81.7108154)
   0.9895668383383651200000000000f,   // 14876: sin(81.7163086)
   0.9895806467637202600000000000f,   // 14877: sin(81.7218018)
   0.9895944460930624600000000000f,   // 14878: sin(81.7272949)
   0.9896082363262649300000000000f,   // 14879: sin(81.7327881)
   0.9896220174632007800000000000f,   // 14880: sin(81.7382813)
   0.9896357895037435300000000000f,   // 14881: sin(81.7437744)
   0.9896495524477665300000000000f,   // 14882: sin(81.7492676)
   0.9896633062951432100000000000f,   // 14883: sin(81.7547607)
   0.9896770510457472100000000000f,   // 14884: sin(81.7602539)
   0.9896907866994522100000000000f,   // 14885: sin(81.7657471)
   0.9897045132561318500000000000f,   // 14886: sin(81.7712402)
   0.9897182307156600100000000000f,   // 14887: sin(81.7767334)
   0.9897319390779105700000000000f,   // 14888: sin(81.7822266)
   0.9897456383427576400000000000f,   // 14889: sin(81.7877197)
   0.9897593285100752000000000000f,   // 14890: sin(81.7932129)
   0.9897730095797374600000000000f,   // 14891: sin(81.7987061)
   0.9897866815516186400000000000f,   // 14892: sin(81.8041992)
   0.9898003444255930600000000000f,   // 14893: sin(81.8096924)
   0.9898139982015352600000000000f,   // 14894: sin(81.8151855)
   0.9898276428793194600000000000f,   // 14895: sin(81.8206787)
   0.9898412784588205300000000000f,   // 14896: sin(81.8261719)
   0.9898549049399129100000000000f,   // 14897: sin(81.8316650)
   0.9898685223224715800000000000f,   // 14898: sin(81.8371582)
   0.9898821306063712000000000000f,   // 14899: sin(81.8426514)
   0.9898957297914866600000000000f,   // 14900: sin(81.8481445)
   0.9899093198776930400000000000f,   // 14901: sin(81.8536377)
   0.9899229008648654500000000000f,   // 14902: sin(81.8591309)
   0.9899364727528791000000000000f,   // 14903: sin(81.8646240)
   0.9899500355416089900000000000f,   // 14904: sin(81.8701172)
   0.9899635892309307500000000000f,   // 14905: sin(81.8756104)
   0.9899771338207196100000000000f,   // 14906: sin(81.8811035)
   0.9899906693108511100000000000f,   // 14907: sin(81.8865967)
   0.9900041957012009100000000000f,   // 14908: sin(81.8920898)
   0.9900177129916446500000000000f,   // 14909: sin(81.8975830)
   0.9900312211820580000000000000f,   // 14910: sin(81.9030762)
   0.9900447202723168200000000000f,   // 14911: sin(81.9085693)
   0.9900582102622971200000000000f,   // 14912: sin(81.9140625)
   0.9900716911518747700000000000f,   // 14913: sin(81.9195557)
   0.9900851629409259700000000000f,   // 14914: sin(81.9250488)
   0.9900986256293269300000000000f,   // 14915: sin(81.9305420)
   0.9901120792169537700000000000f,   // 14916: sin(81.9360352)
   0.9901255237036827900000000000f,   // 14917: sin(81.9415283)
   0.9901389590893906500000000000f,   // 14918: sin(81.9470215)
   0.9901523853739536700000000000f,   // 14919: sin(81.9525146)
   0.9901658025572484000000000000f,   // 14920: sin(81.9580078)
   0.9901792106391516000000000000f,   // 14921: sin(81.9635010)
   0.9901926096195400300000000000f,   // 14922: sin(81.9689941)
   0.9902059994982905800000000000f,   // 14923: sin(81.9744873)
   0.9902193802752800000000000000f,   // 14924: sin(81.9799805)
   0.9902327519503855100000000000f,   // 14925: sin(81.9854736)
   0.9902461145234839900000000000f,   // 14926: sin(81.9909668)
   0.9902594679944527500000000000f,   // 14927: sin(81.9964600)
   0.9902728123631691100000000000f,   // 14928: sin(82.0019531)
   0.9902861476295102800000000000f,   // 14929: sin(82.0074463)
   0.9902994737933535900000000000f,   // 14930: sin(82.0129395)
   0.9903127908545768000000000000f,   // 14931: sin(82.0184326)
   0.9903260988130573300000000000f,   // 14932: sin(82.0239258)
   0.9903393976686729600000000000f,   // 14933: sin(82.0294189)
   0.9903526874213013400000000000f,   // 14934: sin(82.0349121)
   0.9903659680708204500000000000f,   // 14935: sin(82.0404053)
   0.9903792396171081600000000000f,   // 14936: sin(82.0458984)
   0.9903925020600423700000000000f,   // 14937: sin(82.0513916)
   0.9904057553995012600000000000f,   // 14938: sin(82.0568848)
   0.9904189996353630600000000000f,   // 14939: sin(82.0623779)
   0.9904322347675059700000000000f,   // 14940: sin(82.0678711)
   0.9904454607958083100000000000f,   // 14941: sin(82.0733643)
   0.9904586777201486200000000000f,   // 14942: sin(82.0788574)
   0.9904718855404053300000000000f,   // 14943: sin(82.0843506)
   0.9904850842564569800000000000f,   // 14944: sin(82.0898438)
   0.9904982738681824600000000000f,   // 14945: sin(82.0953369)
   0.9905114543754602900000000000f,   // 14946: sin(82.1008301)
   0.9905246257781694700000000000f,   // 14947: sin(82.1063232)
   0.9905377880761887500000000000f,   // 14948: sin(82.1118164)
   0.9905509412693974700000000000f,   // 14949: sin(82.1173096)
   0.9905640853576743700000000000f,   // 14950: sin(82.1228027)
   0.9905772203408989000000000000f,   // 14951: sin(82.1282959)
   0.9905903462189501500000000000f,   // 14952: sin(82.1337891)
   0.9906034629917076500000000000f,   // 14953: sin(82.1392822)
   0.9906165706590506200000000000f,   // 14954: sin(82.1447754)
   0.9906296692208587100000000000f,   // 14955: sin(82.1502686)
   0.9906427586770115700000000000f,   // 14956: sin(82.1557617)
   0.9906558390273887400000000000f,   // 14957: sin(82.1612549)
   0.9906689102718699800000000000f,   // 14958: sin(82.1667480)
   0.9906819724103354000000000000f,   // 14959: sin(82.1722412)
   0.9906950254426646300000000000f,   // 14960: sin(82.1777344)
   0.9907080693687379000000000000f,   // 14961: sin(82.1832275)
   0.9907211041884351800000000000f,   // 14962: sin(82.1887207)
   0.9907341299016366700000000000f,   // 14963: sin(82.1942139)
   0.9907471465082227100000000000f,   // 14964: sin(82.1997070)
   0.9907601540080736000000000000f,   // 14965: sin(82.2052002)
   0.9907731524010697800000000000f,   // 14966: sin(82.2106934)
   0.9907861416870918900000000000f,   // 14967: sin(82.2161865)
   0.9907991218660203700000000000f,   // 14968: sin(82.2216797)
   0.9908120929377359800000000000f,   // 14969: sin(82.2271729)
   0.9908250549021194700000000000f,   // 14970: sin(82.2326660)
   0.9908380077590516200000000000f,   // 14971: sin(82.2381592)
   0.9908509515084136200000000000f,   // 14972: sin(82.2436523)
   0.9908638861500862500000000000f,   // 14973: sin(82.2491455)
   0.9908768116839508100000000000f,   // 14974: sin(82.2546387)
   0.9908897281098881800000000000f,   // 14975: sin(82.2601318)
   0.9909026354277800100000000000f,   // 14976: sin(82.2656250)
   0.9909155336375075100000000000f,   // 14977: sin(82.2711182)
   0.9909284227389519900000000000f,   // 14978: sin(82.2766113)
   0.9909413027319951000000000000f,   // 14979: sin(82.2821045)
   0.9909541736165185000000000000f,   // 14980: sin(82.2875977)
   0.9909670353924037200000000000f,   // 14981: sin(82.2930908)
   0.9909798880595327400000000000f,   // 14982: sin(82.2985840)
   0.9909927316177873400000000000f,   // 14983: sin(82.3040771)
   0.9910055660670493700000000000f,   // 14984: sin(82.3095703)
   0.9910183914072009400000000000f,   // 14985: sin(82.3150635)
   0.9910312076381241300000000000f,   // 14986: sin(82.3205566)
   0.9910440147597011600000000000f,   // 14987: sin(82.3260498)
   0.9910568127718143400000000000f,   // 14988: sin(82.3315430)
   0.9910696016743459900000000000f,   // 14989: sin(82.3370361)
   0.9910823814671786400000000000f,   // 14990: sin(82.3425293)
   0.9910951521501947200000000000f,   // 14991: sin(82.3480225)
   0.9911079137232767800000000000f,   // 14992: sin(82.3535156)
   0.9911206661863077900000000000f,   // 14993: sin(82.3590088)
   0.9911334095391701700000000000f,   // 14994: sin(82.3645020)
   0.9911461437817470400000000000f,   // 14995: sin(82.3699951)
   0.9911588689139213500000000000f,   // 14996: sin(82.3754883)
   0.9911715849355760000000000000f,   // 14997: sin(82.3809814)
   0.9911842918465941800000000000f,   // 14998: sin(82.3864746)
   0.9911969896468590900000000000f,   // 14999: sin(82.3919678)
   0.9912096783362540600000000000f,   // 15000: sin(82.3974609)
   0.9912223579146622900000000000f,   // 15001: sin(82.4029541)
   0.9912350283819674200000000000f,   // 15002: sin(82.4084473)
   0.9912476897380528800000000000f,   // 15003: sin(82.4139404)
   0.9912603419828024400000000000f,   // 15004: sin(82.4194336)
   0.9912729851160995100000000000f,   // 15005: sin(82.4249268)
   0.9912856191378282000000000000f,   // 15006: sin(82.4304199)
   0.9912982440478721500000000000f,   // 15007: sin(82.4359131)
   0.9913108598461154400000000000f,   // 15008: sin(82.4414063)
   0.9913234665324419700000000000f,   // 15009: sin(82.4468994)
   0.9913360641067361400000000000f,   // 15010: sin(82.4523926)
   0.9913486525688818300000000000f,   // 15011: sin(82.4578857)
   0.9913612319187634600000000000f,   // 15012: sin(82.4633789)
   0.9913738021562654700000000000f,   // 15013: sin(82.4688721)
   0.9913863632812722800000000000f,   // 15014: sin(82.4743652)
   0.9913989152936684100000000000f,   // 15015: sin(82.4798584)
   0.9914114581933385400000000000f,   // 15016: sin(82.4853516)
   0.9914239919801672900000000000f,   // 15017: sin(82.4908447)
   0.9914365166540394200000000000f,   // 15018: sin(82.4963379)
   0.9914490322148399300000000000f,   // 15019: sin(82.5018311)
   0.9914615386624537900000000000f,   // 15020: sin(82.5073242)
   0.9914740359967658700000000000f,   // 15021: sin(82.5128174)
   0.9914865242176614800000000000f,   // 15022: sin(82.5183105)
   0.9914990033250257200000000000f,   // 15023: sin(82.5238037)
   0.9915114733187439000000000000f,   // 15024: sin(82.5292969)
   0.9915239341987014400000000000f,   // 15025: sin(82.5347900)
   0.9915363859647838800000000000f,   // 15026: sin(82.5402832)
   0.9915488286168765400000000000f,   // 15027: sin(82.5457764)
   0.9915612621548652900000000000f,   // 15028: sin(82.5512695)
   0.9915736865786356500000000000f,   // 15029: sin(82.5567627)
   0.9915861018880735000000000000f,   // 15030: sin(82.5622559)
   0.9915985080830647100000000000f,   // 15031: sin(82.5677490)
   0.9916109051634953700000000000f,   // 15032: sin(82.5732422)
   0.9916232931292512400000000000f,   // 15033: sin(82.5787354)
   0.9916356719802187400000000000f,   // 15034: sin(82.5842285)
   0.9916480417162839600000000000f,   // 15035: sin(82.5897217)
   0.9916604023373332100000000000f,   // 15036: sin(82.5952148)
   0.9916727538432529300000000000f,   // 15037: sin(82.6007080)
   0.9916850962339295300000000000f,   // 15038: sin(82.6062012)
   0.9916974295092494400000000000f,   // 15039: sin(82.6116943)
   0.9917097536690995300000000000f,   // 15040: sin(82.6171875)
   0.9917220687133663200000000000f,   // 15041: sin(82.6226807)
   0.9917343746419368100000000000f,   // 15042: sin(82.6281738)
   0.9917466714546977500000000000f,   // 15043: sin(82.6336670)
   0.9917589591515361100000000000f,   // 15044: sin(82.6391602)
   0.9917712377323389900000000000f,   // 15045: sin(82.6446533)
   0.9917835071969934900000000000f,   // 15046: sin(82.6501465)
   0.9917957675453869000000000000f,   // 15047: sin(82.6556396)
   0.9918080187774064300000000000f,   // 15048: sin(82.6611328)
   0.9918202608929396200000000000f,   // 15049: sin(82.6666260)
   0.9918324938918737800000000000f,   // 15050: sin(82.6721191)
   0.9918447177740964400000000000f,   // 15051: sin(82.6776123)
   0.9918569325394953600000000000f,   // 15052: sin(82.6831055)
   0.9918691381879583000000000000f,   // 15053: sin(82.6885986)
   0.9918813347193730100000000000f,   // 15054: sin(82.6940918)
   0.9918935221336273600000000000f,   // 15055: sin(82.6995850)
   0.9919057004306093300000000000f,   // 15056: sin(82.7050781)
   0.9919178696102070000000000000f,   // 15057: sin(82.7105713)
   0.9919300296723084800000000000f,   // 15058: sin(82.7160645)
   0.9919421806168020600000000000f,   // 15059: sin(82.7215576)
   0.9919543224435759500000000000f,   // 15060: sin(82.7270508)
   0.9919664551525186900000000000f,   // 15061: sin(82.7325439)
   0.9919785787435185800000000000f,   // 15062: sin(82.7380371)
   0.9919906932164643800000000000f,   // 15063: sin(82.7435303)
   0.9920027985712445200000000000f,   // 15064: sin(82.7490234)
   0.9920148948077479600000000000f,   // 15065: sin(82.7545166)
   0.9920269819258633600000000000f,   // 15066: sin(82.7600098)
   0.9920390599254795800000000000f,   // 15067: sin(82.7655029)
   0.9920511288064857200000000000f,   // 15068: sin(82.7709961)
   0.9920631885687708500000000000f,   // 15069: sin(82.7764893)
   0.9920752392122240700000000000f,   // 15070: sin(82.7819824)
   0.9920872807367345800000000000f,   // 15071: sin(82.7874756)
   0.9920993131421918000000000000f,   // 15072: sin(82.7929688)
   0.9921113364284849200000000000f,   // 15073: sin(82.7984619)
   0.9921233505955037200000000000f,   // 15074: sin(82.8039551)
   0.9921353556431376000000000000f,   // 15075: sin(82.8094482)
   0.9921473515712760900000000000f,   // 15076: sin(82.8149414)
   0.9921593383798091900000000000f,   // 15077: sin(82.8204346)
   0.9921713160686265200000000000f,   // 15078: sin(82.8259277)
   0.9921832846376181800000000000f,   // 15079: sin(82.8314209)
   0.9921952440866739200000000000f,   // 15080: sin(82.8369141)
   0.9922071944156839500000000000f,   // 15081: sin(82.8424072)
   0.9922191356245384500000000000f,   // 15082: sin(82.8479004)
   0.9922310677131275200000000000f,   // 15083: sin(82.8533936)
   0.9922429906813417000000000000f,   // 15084: sin(82.8588867)
   0.9922549045290711700000000000f,   // 15085: sin(82.8643799)
   0.9922668092562065800000000000f,   // 15086: sin(82.8698730)
   0.9922787048626383600000000000f,   // 15087: sin(82.8753662)
   0.9922905913482573700000000000f,   // 15088: sin(82.8808594)
   0.9923024687129541300000000000f,   // 15089: sin(82.8863525)
   0.9923143369566196400000000000f,   // 15090: sin(82.8918457)
   0.9923261960791447400000000000f,   // 15091: sin(82.8973389)
   0.9923380460804204200000000000f,   // 15092: sin(82.9028320)
   0.9923498869603376600000000000f,   // 15093: sin(82.9083252)
   0.9923617187187878700000000000f,   // 15094: sin(82.9138184)
   0.9923735413556620300000000000f,   // 15095: sin(82.9193115)
   0.9923853548708516700000000000f,   // 15096: sin(82.9248047)
   0.9923971592642481000000000000f,   // 15097: sin(82.9302979)
   0.9924089545357428500000000000f,   // 15098: sin(82.9357910)
   0.9924207406852274500000000000f,   // 15099: sin(82.9412842)
   0.9924325177125935500000000000f,   // 15100: sin(82.9467773)
   0.9924442856177330100000000000f,   // 15101: sin(82.9522705)
   0.9924560444005377000000000000f,   // 15102: sin(82.9577637)
   0.9924677940608992400000000000f,   // 15103: sin(82.9632568)
   0.9924795345987099700000000000f,   // 15104: sin(82.9687500)
   0.9924912660138618400000000000f,   // 15105: sin(82.9742432)
   0.9925029883062469500000000000f,   // 15106: sin(82.9797363)
   0.9925147014757576000000000000f,   // 15107: sin(82.9852295)
   0.9925264055222861000000000000f,   // 15108: sin(82.9907227)
   0.9925381004457249900000000000f,   // 15109: sin(82.9962158)
   0.9925497862459665700000000000f,   // 15110: sin(83.0017090)
   0.9925614629229037000000000000f,   // 15111: sin(83.0072021)
   0.9925731304764288100000000000f,   // 15112: sin(83.0126953)
   0.9925847889064346500000000000f,   // 15113: sin(83.0181885)
   0.9925964382128142900000000000f,   // 15114: sin(83.0236816)
   0.9926080783954603900000000000f,   // 15115: sin(83.0291748)
   0.9926197094542661400000000000f,   // 15116: sin(83.0346680)
   0.9926313313891246300000000000f,   // 15117: sin(83.0401611)
   0.9926429441999288200000000000f,   // 15118: sin(83.0456543)
   0.9926545478865722600000000000f,   // 15119: sin(83.0511475)
   0.9926661424489480200000000000f,   // 15120: sin(83.0566406)
   0.9926777278869496300000000000f,   // 15121: sin(83.0621338)
   0.9926893042004707500000000000f,   // 15122: sin(83.0676270)
   0.9927008713894047700000000000f,   // 15123: sin(83.0731201)
   0.9927124294536454600000000000f,   // 15124: sin(83.0786133)
   0.9927239783930865700000000000f,   // 15125: sin(83.0841064)
   0.9927355182076218500000000000f,   // 15126: sin(83.0895996)
   0.9927470488971453800000000000f,   // 15127: sin(83.0950928)
   0.9927585704615511400000000000f,   // 15128: sin(83.1005859)
   0.9927700829007331000000000000f,   // 15129: sin(83.1060791)
   0.9927815862145855700000000000f,   // 15130: sin(83.1115723)
   0.9927930804030028500000000000f,   // 15131: sin(83.1170654)
   0.9928045654658791400000000000f,   // 15132: sin(83.1225586)
   0.9928160414031089700000000000f,   // 15133: sin(83.1280518)
   0.9928275082145867600000000000f,   // 15134: sin(83.1335449)
   0.9928389659002072600000000000f,   // 15135: sin(83.1390381)
   0.9928504144598651000000000000f,   // 15136: sin(83.1445313)
   0.9928618538934549400000000000f,   // 15137: sin(83.1500244)
   0.9928732842008717300000000000f,   // 15138: sin(83.1555176)
   0.9928847053820104600000000000f,   // 15139: sin(83.1610107)
   0.9928961174367659800000000000f,   // 15140: sin(83.1665039)
   0.9929075203650336000000000000f,   // 15141: sin(83.1719971)
   0.9929189141667083000000000000f,   // 15142: sin(83.1774902)
   0.9929302988416854900000000000f,   // 15143: sin(83.1829834)
   0.9929416743898604700000000000f,   // 15144: sin(83.1884766)
   0.9929530408111286700000000000f,   // 15145: sin(83.1939697)
   0.9929643981053856100000000000f,   // 15146: sin(83.1994629)
   0.9929757462725270500000000000f,   // 15147: sin(83.2049561)
   0.9929870853124483900000000000f,   // 15148: sin(83.2104492)
   0.9929984152250456200000000000f,   // 15149: sin(83.2159424)
   0.9930097360102145800000000000f,   // 15150: sin(83.2214355)
   0.9930210476678511500000000000f,   // 15151: sin(83.2269287)
   0.9930323501978514100000000000f,   // 15152: sin(83.2324219)
   0.9930436436001113300000000000f,   // 15153: sin(83.2379150)
   0.9930549278745273200000000000f,   // 15154: sin(83.2434082)
   0.9930662030209954600000000000f,   // 15155: sin(83.2489014)
   0.9930774690394123000000000000f,   // 15156: sin(83.2543945)
   0.9930887259296741200000000000f,   // 15157: sin(83.2598877)
   0.9930999736916775700000000000f,   // 15158: sin(83.2653809)
   0.9931112123253190700000000000f,   // 15159: sin(83.2708740)
   0.9931224418304955800000000000f,   // 15160: sin(83.2763672)
   0.9931336622071037500000000000f,   // 15161: sin(83.2818604)
   0.9931448734550404300000000000f,   // 15162: sin(83.2873535)
   0.9931560755742026000000000000f,   // 15163: sin(83.2928467)
   0.9931672685644872300000000000f,   // 15164: sin(83.2983398)
   0.9931784524257915000000000000f,   // 15165: sin(83.3038330)
   0.9931896271580126200000000000f,   // 15166: sin(83.3093262)
   0.9932007927610478900000000000f,   // 15167: sin(83.3148193)
   0.9932119492347945000000000000f,   // 15168: sin(83.3203125)
   0.9932230965791502000000000000f,   // 15169: sin(83.3258057)
   0.9932342347940122900000000000f,   // 15170: sin(83.3312988)
   0.9932453638792784200000000000f,   // 15171: sin(83.3367920)
   0.9932564838348464400000000000f,   // 15172: sin(83.3422852)
   0.9932675946606139800000000000f,   // 15173: sin(83.3477783)
   0.9932786963564790300000000000f,   // 15174: sin(83.3532715)
   0.9932897889223394300000000000f,   // 15175: sin(83.3587646)
   0.9933008723580932800000000000f,   // 15176: sin(83.3642578)
   0.9933119466636387600000000000f,   // 15177: sin(83.3697510)
   0.9933230118388739500000000000f,   // 15178: sin(83.3752441)
   0.9933340678836971600000000000f,   // 15179: sin(83.3807373)
   0.9933451147980069100000000000f,   // 15180: sin(83.3862305)
   0.9933561525817015100000000000f,   // 15181: sin(83.3917236)
   0.9933671812346796000000000000f,   // 15182: sin(83.3972168)
   0.9933782007568396900000000000f,   // 15183: sin(83.4027100)
   0.9933892111480806500000000000f,   // 15184: sin(83.4082031)
   0.9934002124083011200000000000f,   // 15185: sin(83.4136963)
   0.9934112045374000600000000000f,   // 15186: sin(83.4191895)
   0.9934221875352764500000000000f,   // 15187: sin(83.4246826)
   0.9934331614018293600000000000f,   // 15188: sin(83.4301758)
   0.9934441261369577600000000000f,   // 15189: sin(83.4356689)
   0.9934550817405609600000000000f,   // 15190: sin(83.4411621)
   0.9934660282125383800000000000f,   // 15191: sin(83.4466553)
   0.9934769655527891900000000000f,   // 15192: sin(83.4521484)
   0.9934878937612130500000000000f,   // 15193: sin(83.4576416)
   0.9934988128377093600000000000f,   // 15194: sin(83.4631348)
   0.9935097227821777500000000000f,   // 15195: sin(83.4686279)
   0.9935206235945180900000000000f,   // 15196: sin(83.4741211)
   0.9935315152746301300000000000f,   // 15197: sin(83.4796143)
   0.9935423978224136000000000000f,   // 15198: sin(83.4851074)
   0.9935532712377687100000000000f,   // 15199: sin(83.4906006)
   0.9935641355205953000000000000f,   // 15200: sin(83.4960938)
   0.9935749906707936900000000000f,   // 15201: sin(83.5015869)
   0.9935858366882639500000000000f,   // 15202: sin(83.5070801)
   0.9935966735729064900000000000f,   // 15203: sin(83.5125732)
   0.9936075013246216100000000000f,   // 15204: sin(83.5180664)
   0.9936183199433098500000000000f,   // 15205: sin(83.5235596)
   0.9936291294288717200000000000f,   // 15206: sin(83.5290527)
   0.9936399297812079600000000000f,   // 15207: sin(83.5345459)
   0.9936507210002191200000000000f,   // 15208: sin(83.5400391)
   0.9936615030858061400000000000f,   // 15209: sin(83.5455322)
   0.9936722760378700100000000000f,   // 15210: sin(83.5510254)
   0.9936830398563114600000000000f,   // 15211: sin(83.5565186)
   0.9936937945410316800000000000f,   // 15212: sin(83.5620117)
   0.9937045400919318800000000000f,   // 15213: sin(83.5675049)
   0.9937152765089132300000000000f,   // 15214: sin(83.5729980)
   0.9937260037918770300000000000f,   // 15215: sin(83.5784912)
   0.9937367219407246000000000000f,   // 15216: sin(83.5839844)
   0.9937474309553575600000000000f,   // 15217: sin(83.5894775)
   0.9937581308356774300000000000f,   // 15218: sin(83.5949707)
   0.9937688215815858600000000000f,   // 15219: sin(83.6004639)
   0.9937795031929845800000000000f,   // 15220: sin(83.6059570)
   0.9937901756697753400000000000f,   // 15221: sin(83.6114502)
   0.9938008390118601200000000000f,   // 15222: sin(83.6169434)
   0.9938114932191408600000000000f,   // 15223: sin(83.6224365)
   0.9938221382915196600000000000f,   // 15224: sin(83.6279297)
   0.9938327742288987100000000000f,   // 15225: sin(83.6334229)
   0.9938434010311801800000000000f,   // 15226: sin(83.6389160)
   0.9938540186982663900000000000f,   // 15227: sin(83.6444092)
   0.9938646272300597500000000000f,   // 15228: sin(83.6499023)
   0.9938752266264627700000000000f,   // 15229: sin(83.6553955)
   0.9938858168873780900000000000f,   // 15230: sin(83.6608887)
   0.9938963980127082400000000000f,   // 15231: sin(83.6663818)
   0.9939069700023560600000000000f,   // 15232: sin(83.6718750)
   0.9939175328562243100000000000f,   // 15233: sin(83.6773682)
   0.9939280865742158300000000000f,   // 15234: sin(83.6828613)
   0.9939386311562338200000000000f,   // 15235: sin(83.6883545)
   0.9939491666021811300000000000f,   // 15236: sin(83.6938477)
   0.9939596929119611800000000000f,   // 15237: sin(83.6993408)
   0.9939702100854769200000000000f,   // 15238: sin(83.7048340)
   0.9939807181226318900000000000f,   // 15239: sin(83.7103271)
   0.9939912170233293800000000000f,   // 15240: sin(83.7158203)
   0.9940017067874730200000000000f,   // 15241: sin(83.7213135)
   0.9940121874149662200000000000f,   // 15242: sin(83.7268066)
   0.9940226589057128400000000000f,   // 15243: sin(83.7322998)
   0.9940331212596164000000000000f,   // 15244: sin(83.7377930)
   0.9940435744765808700000000000f,   // 15245: sin(83.7432861)
   0.9940540185565102100000000000f,   // 15246: sin(83.7487793)
   0.9940644534993083900000000000f,   // 15247: sin(83.7542725)
   0.9940748793048793700000000000f,   // 15248: sin(83.7597656)
   0.9940852959731274500000000000f,   // 15249: sin(83.7652588)
   0.9940957035039569300000000000f,   // 15250: sin(83.7707520)
   0.9941061018972720000000000000f,   // 15251: sin(83.7762451)
   0.9941164911529770700000000000f,   // 15252: sin(83.7817383)
   0.9941268712709767600000000000f,   // 15253: sin(83.7872314)
   0.9941372422511757200000000000f,   // 15254: sin(83.7927246)
   0.9941476040934784700000000000f,   // 15255: sin(83.7982178)
   0.9941579567977897300000000000f,   // 15256: sin(83.8037109)
   0.9941683003640144900000000000f,   // 15257: sin(83.8092041)
   0.9941786347920575900000000000f,   // 15258: sin(83.8146973)
   0.9941889600818240000000000000f,   // 15259: sin(83.8201904)
   0.9941992762332189100000000000f,   // 15260: sin(83.8256836)
   0.9942095832461475000000000000f,   // 15261: sin(83.8311768)
   0.9942198811205148500000000000f,   // 15262: sin(83.8366699)
   0.9942301698562265900000000000f,   // 15263: sin(83.8421631)
   0.9942404494531879000000000000f,   // 15264: sin(83.8476563)
   0.9942507199113044300000000000f,   // 15265: sin(83.8531494)
   0.9942609812304817900000000000f,   // 15266: sin(83.8586426)
   0.9942712334106255100000000000f,   // 15267: sin(83.8641357)
   0.9942814764516415500000000000f,   // 15268: sin(83.8696289)
   0.9942917103534355500000000000f,   // 15269: sin(83.8751221)
   0.9943019351159135800000000000f,   // 15270: sin(83.8806152)
   0.9943121507389816000000000000f,   // 15271: sin(83.8861084)
   0.9943223572225458100000000000f,   // 15272: sin(83.8916016)
   0.9943325545665122600000000000f,   // 15273: sin(83.8970947)
   0.9943427427707872700000000000f,   // 15274: sin(83.9025879)
   0.9943529218352772400000000000f,   // 15275: sin(83.9080811)
   0.9943630917598885700000000000f,   // 15276: sin(83.9135742)
   0.9943732525445278000000000000f,   // 15277: sin(83.9190674)
   0.9943834041891014300000000000f,   // 15278: sin(83.9245605)
   0.9943935466935163200000000000f,   // 15279: sin(83.9300537)
   0.9944036800576791000000000000f,   // 15280: sin(83.9355469)
   0.9944138042814966200000000000f,   // 15281: sin(83.9410400)
   0.9944239193648759500000000000f,   // 15282: sin(83.9465332)
   0.9944340253077240700000000000f,   // 15283: sin(83.9520264)
   0.9944441221099480400000000000f,   // 15284: sin(83.9575195)
   0.9944542097714550400000000000f,   // 15285: sin(83.9630127)
   0.9944642882921523900000000000f,   // 15286: sin(83.9685059)
   0.9944743576719474700000000000f,   // 15287: sin(83.9739990)
   0.9944844179107476000000000000f,   // 15288: sin(83.9794922)
   0.9944944690084605000000000000f,   // 15289: sin(83.9849854)
   0.9945045109649935900000000000f,   // 15290: sin(83.9904785)
   0.9945145437802548300000000000f,   // 15291: sin(83.9959717)
   0.9945245674541517400000000000f,   // 15292: sin(84.0014648)
   0.9945345819865921700000000000f,   // 15293: sin(84.0069580)
   0.9945445873774843000000000000f,   // 15294: sin(84.0124512)
   0.9945545836267359900000000000f,   // 15295: sin(84.0179443)
   0.9945645707342554200000000000f,   // 15296: sin(84.0234375)
   0.9945745486999507700000000000f,   // 15297: sin(84.0289307)
   0.9945845175237303400000000000f,   // 15298: sin(84.0344238)
   0.9945944772055025400000000000f,   // 15299: sin(84.0399170)
   0.9946044277451756600000000000f,   // 15300: sin(84.0454102)
   0.9946143691426584400000000000f,   // 15301: sin(84.0509033)
   0.9946243013978594000000000000f,   // 15302: sin(84.0563965)
   0.9946342245106871700000000000f,   // 15303: sin(84.0618896)
   0.9946441384810507100000000000f,   // 15304: sin(84.0673828)
   0.9946540433088587600000000000f,   // 15305: sin(84.0728760)
   0.9946639389940202800000000000f,   // 15306: sin(84.0783691)
   0.9946738255364444600000000000f,   // 15307: sin(84.0838623)
   0.9946837029360402500000000000f,   // 15308: sin(84.0893555)
   0.9946935711927169500000000000f,   // 15309: sin(84.0948486)
   0.9947034303063838600000000000f,   // 15310: sin(84.1003418)
   0.9947132802769502700000000000f,   // 15311: sin(84.1058350)
   0.9947231211043257000000000000f,   // 15312: sin(84.1113281)
   0.9947329527884197800000000000f,   // 15313: sin(84.1168213)
   0.9947427753291420100000000000f,   // 15314: sin(84.1223145)
   0.9947525887264020400000000000f,   // 15315: sin(84.1278076)
   0.9947623929801099300000000000f,   // 15316: sin(84.1333008)
   0.9947721880901753100000000000f,   // 15317: sin(84.1387939)
   0.9947819740565082600000000000f,   // 15318: sin(84.1442871)
   0.9947917508790188300000000000f,   // 15319: sin(84.1497803)
   0.9948015185576171100000000000f,   // 15320: sin(84.1552734)
   0.9948112770922134000000000000f,   // 15321: sin(84.1607666)
   0.9948210264827178600000000000f,   // 15322: sin(84.1662598)
   0.9948307667290409200000000000f,   // 15323: sin(84.1717529)
   0.9948404978310931800000000000f,   // 15324: sin(84.1772461)
   0.9948502197887851800000000000f,   // 15325: sin(84.1827393)
   0.9948599326020273200000000000f,   // 15326: sin(84.1882324)
   0.9948696362707305500000000000f,   // 15327: sin(84.1937256)
   0.9948793307948056200000000000f,   // 15328: sin(84.1992188)
   0.9948890161741633700000000000f,   // 15329: sin(84.2047119)
   0.9948986924087148700000000000f,   // 15330: sin(84.2102051)
   0.9949083594983710900000000000f,   // 15331: sin(84.2156982)
   0.9949180174430432000000000000f,   // 15332: sin(84.2211914)
   0.9949276662426423900000000000f,   // 15333: sin(84.2266846)
   0.9949373058970800700000000000f,   // 15334: sin(84.2321777)
   0.9949469364062675200000000000f,   // 15335: sin(84.2376709)
   0.9949565577701163800000000000f,   // 15336: sin(84.2431641)
   0.9949661699885379300000000000f,   // 15337: sin(84.2486572)
   0.9949757730614441400000000000f,   // 15338: sin(84.2541504)
   0.9949853669887465100000000000f,   // 15339: sin(84.2596436)
   0.9949949517703570200000000000f,   // 15340: sin(84.2651367)
   0.9950045274061873900000000000f,   // 15341: sin(84.2706299)
   0.9950140938961497000000000000f,   // 15342: sin(84.2761230)
   0.9950236512401561300000000000f,   // 15343: sin(84.2816162)
   0.9950331994381186300000000000f,   // 15344: sin(84.2871094)
   0.9950427384899495100000000000f,   // 15345: sin(84.2926025)
   0.9950522683955611600000000000f,   // 15346: sin(84.2980957)
   0.9950617891548657600000000000f,   // 15347: sin(84.3035889)
   0.9950713007677761700000000000f,   // 15348: sin(84.3090820)
   0.9950808032342046700000000000f,   // 15349: sin(84.3145752)
   0.9950902965540638900000000000f,   // 15350: sin(84.3200684)
   0.9950997807272667900000000000f,   // 15351: sin(84.3255615)
   0.9951092557537261100000000000f,   // 15352: sin(84.3310547)
   0.9951187216333546900000000000f,   // 15353: sin(84.3365479)
   0.9951281783660654900000000000f,   // 15354: sin(84.3420410)
   0.9951376259517718000000000000f,   // 15355: sin(84.3475342)
   0.9951470643903864700000000000f,   // 15356: sin(84.3530273)
   0.9951564936818230200000000000f,   // 15357: sin(84.3585205)
   0.9951659138259946200000000000f,   // 15358: sin(84.3640137)
   0.9951753248228147900000000000f,   // 15359: sin(84.3695068)
   0.9951847266721968200000000000f,   // 15360: sin(84.3750000)
   0.9951941193740545500000000000f,   // 15361: sin(84.3804932)
   0.9952035029283015100000000000f,   // 15362: sin(84.3859863)
   0.9952128773348515300000000000f,   // 15363: sin(84.3914795)
   0.9952222425936182400000000000f,   // 15364: sin(84.3969727)
   0.9952315987045158300000000000f,   // 15365: sin(84.4024658)
   0.9952409456674581300000000000f,   // 15366: sin(84.4079590)
   0.9952502834823592200000000000f,   // 15367: sin(84.4134521)
   0.9952596121491333900000000000f,   // 15368: sin(84.4189453)
   0.9952689316676947000000000000f,   // 15369: sin(84.4244385)
   0.9952782420379576700000000000f,   // 15370: sin(84.4299316)
   0.9952875432598365900000000000f,   // 15371: sin(84.4354248)
   0.9952968353332460900000000000f,   // 15372: sin(84.4409180)
   0.9953061182581006700000000000f,   // 15373: sin(84.4464111)
   0.9953153920343150700000000000f,   // 15374: sin(84.4519043)
   0.9953246566618040300000000000f,   // 15375: sin(84.4573975)
   0.9953339121404822800000000000f,   // 15376: sin(84.4628906)
   0.9953431584702648900000000000f,   // 15377: sin(84.4683838)
   0.9953523956510668100000000000f,   // 15378: sin(84.4738770)
   0.9953616236828031200000000000f,   // 15379: sin(84.4793701)
   0.9953708425653889900000000000f,   // 15380: sin(84.4848633)
   0.9953800522987397100000000000f,   // 15381: sin(84.4903564)
   0.9953892528827706900000000000f,   // 15382: sin(84.4958496)
   0.9953984443173972100000000000f,   // 15383: sin(84.5013428)
   0.9954076266025349000000000000f,   // 15384: sin(84.5068359)
   0.9954167997380993800000000000f,   // 15385: sin(84.5123291)
   0.9954259637240061600000000000f,   // 15386: sin(84.5178223)
   0.9954351185601711900000000000f,   // 15387: sin(84.5233154)
   0.9954442642465103400000000000f,   // 15388: sin(84.5288086)
   0.9954534007829393100000000000f,   // 15389: sin(84.5343018)
   0.9954625281693744200000000000f,   // 15390: sin(84.5397949)
   0.9954716464057314900000000000f,   // 15391: sin(84.5452881)
   0.9954807554919269400000000000f,   // 15392: sin(84.5507813)
   0.9954898554278769400000000000f,   // 15393: sin(84.5562744)
   0.9954989462134977700000000000f,   // 15394: sin(84.5617676)
   0.9955080278487059600000000000f,   // 15395: sin(84.5672607)
   0.9955171003334181100000000000f,   // 15396: sin(84.5727539)
   0.9955261636675506500000000000f,   // 15397: sin(84.5782471)
   0.9955352178510203900000000000f,   // 15398: sin(84.5837402)
   0.9955442628837439800000000000f,   // 15399: sin(84.5892334)
   0.9955532987656384700000000000f,   // 15400: sin(84.5947266)
   0.9955623254966207100000000000f,   // 15401: sin(84.6002197)
   0.9955713430766077700000000000f,   // 15402: sin(84.6057129)
   0.9955803515055166000000000000f,   // 15403: sin(84.6112061)
   0.9955893507832646000000000000f,   // 15404: sin(84.6166992)
   0.9955983409097689500000000000f,   // 15405: sin(84.6221924)
   0.9956073218849470500000000000f,   // 15406: sin(84.6276855)
   0.9956162937087162900000000000f,   // 15407: sin(84.6331787)
   0.9956252563809943100000000000f,   // 15408: sin(84.6386719)
   0.9956342099016986000000000000f,   // 15409: sin(84.6441650)
   0.9956431542707469000000000000f,   // 15410: sin(84.6496582)
   0.9956520894880570600000000000f,   // 15411: sin(84.6551514)
   0.9956610155535469100000000000f,   // 15412: sin(84.6606445)
   0.9956699324671344200000000000f,   // 15413: sin(84.6661377)
   0.9956788402287375400000000000f,   // 15414: sin(84.6716309)
   0.9956877388382745500000000000f,   // 15415: sin(84.6771240)
   0.9956966282956635200000000000f,   // 15416: sin(84.6826172)
   0.9957055086008227400000000000f,   // 15417: sin(84.6881104)
   0.9957143797536706100000000000f,   // 15418: sin(84.6936035)
   0.9957232417541257400000000000f,   // 15419: sin(84.6990967)
   0.9957320946021064300000000000f,   // 15420: sin(84.7045898)
   0.9957409382975314100000000000f,   // 15421: sin(84.7100830)
   0.9957497728403194000000000000f,   // 15422: sin(84.7155762)
   0.9957585982303892600000000000f,   // 15423: sin(84.7210693)
   0.9957674144676598200000000000f,   // 15424: sin(84.7265625)
   0.9957762215520499200000000000f,   // 15425: sin(84.7320557)
   0.9957850194834787500000000000f,   // 15426: sin(84.7375488)
   0.9957938082618654800000000000f,   // 15427: sin(84.7430420)
   0.9958025878871291600000000000f,   // 15428: sin(84.7485352)
   0.9958113583591892100000000000f,   // 15429: sin(84.7540283)
   0.9958201196779649100000000000f,   // 15430: sin(84.7595215)
   0.9958288718433758700000000000f,   // 15431: sin(84.7650146)
   0.9958376148553416100000000000f,   // 15432: sin(84.7705078)
   0.9958463487137816400000000000f,   // 15433: sin(84.7760010)
   0.9958550734186157900000000000f,   // 15434: sin(84.7814941)
   0.9958637889697638000000000000f,   // 15435: sin(84.7869873)
   0.9958724953671457300000000000f,   // 15436: sin(84.7924805)
   0.9958811926106813100000000000f,   // 15437: sin(84.7979736)
   0.9958898807002907200000000000f,   // 15438: sin(84.8034668)
   0.9958985596358941300000000000f,   // 15439: sin(84.8089600)
   0.9959072294174117200000000000f,   // 15440: sin(84.8144531)
   0.9959158900447637700000000000f,   // 15441: sin(84.8199463)
   0.9959245415178706900000000000f,   // 15442: sin(84.8254395)
   0.9959331838366530800000000000f,   // 15443: sin(84.8309326)
   0.9959418170010313500000000000f,   // 15444: sin(84.8364258)
   0.9959504410109261100000000000f,   // 15445: sin(84.8419189)
   0.9959590558662583200000000000f,   // 15446: sin(84.8474121)
   0.9959676615669484900000000000f,   // 15447: sin(84.8529053)
   0.9959762581129177900000000000f,   // 15448: sin(84.8583984)
   0.9959848455040870600000000000f,   // 15449: sin(84.8638916)
   0.9959934237403773600000000000f,   // 15450: sin(84.8693848)
   0.9960019928217098700000000000f,   // 15451: sin(84.8748779)
   0.9960105527480058700000000000f,   // 15452: sin(84.8803711)
   0.9960191035191866500000000000f,   // 15453: sin(84.8858643)
   0.9960276451351736100000000000f,   // 15454: sin(84.8913574)
   0.9960361775958881400000000000f,   // 15455: sin(84.8968506)
   0.9960447009012519700000000000f,   // 15456: sin(84.9023438)
   0.9960532150511867100000000000f,   // 15457: sin(84.9078369)
   0.9960617200456140000000000000f,   // 15458: sin(84.9133301)
   0.9960702158844557700000000000f,   // 15459: sin(84.9188232)
   0.9960787025676339800000000000f,   // 15460: sin(84.9243164)
   0.9960871800950704700000000000f,   // 15461: sin(84.9298096)
   0.9960956484666873000000000000f,   // 15462: sin(84.9353027)
   0.9961041076824068700000000000f,   // 15463: sin(84.9407959)
   0.9961125577421511300000000000f,   // 15464: sin(84.9462891)
   0.9961209986458426900000000000f,   // 15465: sin(84.9517822)
   0.9961294303934037400000000000f,   // 15466: sin(84.9572754)
   0.9961378529847568800000000000f,   // 15467: sin(84.9627686)
   0.9961462664198246200000000000f,   // 15468: sin(84.9682617)
   0.9961546706985298100000000000f,   // 15469: sin(84.9737549)
   0.9961630658207949500000000000f,   // 15470: sin(84.9792480)
   0.9961714517865429800000000000f,   // 15471: sin(84.9847412)
   0.9961798285956968700000000000f,   // 15472: sin(84.9902344)
   0.9961881962481796700000000000f,   // 15473: sin(84.9957275)
   0.9961965547439142200000000000f,   // 15474: sin(85.0012207)
   0.9962049040828240300000000000f,   // 15475: sin(85.0067139)
   0.9962132442648320400000000000f,   // 15476: sin(85.0122070)
   0.9962215752898617700000000000f,   // 15477: sin(85.0177002)
   0.9962298971578365000000000000f,   // 15478: sin(85.0231934)
   0.9962382098686799500000000000f,   // 15479: sin(85.0286865)
   0.9962465134223155200000000000f,   // 15480: sin(85.0341797)
   0.9962548078186670400000000000f,   // 15481: sin(85.0396729)
   0.9962630930576580300000000000f,   // 15482: sin(85.0451660)
   0.9962713691392126600000000000f,   // 15483: sin(85.0506592)
   0.9962796360632546500000000000f,   // 15484: sin(85.0561523)
   0.9962878938297080600000000000f,   // 15485: sin(85.0616455)
   0.9962961424384968500000000000f,   // 15486: sin(85.0671387)
   0.9963043818895455100000000000f,   // 15487: sin(85.0726318)
   0.9963126121827780000000000000f,   // 15488: sin(85.0781250)
   0.9963208333181188300000000000f,   // 15489: sin(85.0836182)
   0.9963290452954923800000000000f,   // 15490: sin(85.0891113)
   0.9963372481148232700000000000f,   // 15491: sin(85.0946045)
   0.9963454417760359000000000000f,   // 15492: sin(85.1000977)
   0.9963536262790551000000000000f,   // 15493: sin(85.1055908)
   0.9963618016238057200000000000f,   // 15494: sin(85.1110840)
   0.9963699678102123600000000000f,   // 15495: sin(85.1165771)
   0.9963781248382002100000000000f,   // 15496: sin(85.1220703)
   0.9963862727076940900000000000f,   // 15497: sin(85.1275635)
   0.9963944114186192900000000000f,   // 15498: sin(85.1330566)
   0.9964025409709008600000000000f,   // 15499: sin(85.1385498)
   0.9964106613644641000000000000f,   // 15500: sin(85.1440430)
   0.9964187725992345000000000000f,   // 15501: sin(85.1495361)
   0.9964268746751372400000000000f,   // 15502: sin(85.1550293)
   0.9964349675920981500000000000f,   // 15503: sin(85.1605225)
   0.9964430513500426300000000000f,   // 15504: sin(85.1660156)
   0.9964511259488965100000000000f,   // 15505: sin(85.1715088)
   0.9964591913885854100000000000f,   // 15506: sin(85.1770020)
   0.9964672476690353800000000000f,   // 15507: sin(85.1824951)
   0.9964752947901721600000000000f,   // 15508: sin(85.1879883)
   0.9964833327519220200000000000f,   // 15509: sin(85.1934814)
   0.9964913615542109200000000000f,   // 15510: sin(85.1989746)
   0.9964993811969650200000000000f,   // 15511: sin(85.2044678)
   0.9965073916801108200000000000f,   // 15512: sin(85.2099609)
   0.9965153930035743900000000000f,   // 15513: sin(85.2154541)
   0.9965233851672824500000000000f,   // 15514: sin(85.2209473)
   0.9965313681711615000000000000f,   // 15515: sin(85.2264404)
   0.9965393420151379400000000000f,   // 15516: sin(85.2319336)
   0.9965473066991387100000000000f,   // 15517: sin(85.2374268)
   0.9965552622230905400000000000f,   // 15518: sin(85.2429199)
   0.9965632085869202700000000000f,   // 15519: sin(85.2484131)
   0.9965711457905548400000000000f,   // 15520: sin(85.2539063)
   0.9965790738339213000000000000f,   // 15521: sin(85.2593994)
   0.9965869927169469500000000000f,   // 15522: sin(85.2648926)
   0.9965949024395587300000000000f,   // 15523: sin(85.2703857)
   0.9966028030016841300000000000f,   // 15524: sin(85.2758789)
   0.9966106944032504500000000000f,   // 15525: sin(85.2813721)
   0.9966185766441850700000000000f,   // 15526: sin(85.2868652)
   0.9966264497244157200000000000f,   // 15527: sin(85.2923584)
   0.9966343136438699000000000000f,   // 15528: sin(85.2978516)
   0.9966421684024754400000000000f,   // 15529: sin(85.3033447)
   0.9966500140001600700000000000f,   // 15530: sin(85.3088379)
   0.9966578504368516200000000000f,   // 15531: sin(85.3143311)
   0.9966656777124781600000000000f,   // 15532: sin(85.3198242)
   0.9966734958269676300000000000f,   // 15533: sin(85.3253174)
   0.9966813047802483000000000000f,   // 15534: sin(85.3308105)
   0.9966891045722483500000000000f,   // 15535: sin(85.3363037)
   0.9966968952028960600000000000f,   // 15536: sin(85.3417969)
   0.9967046766721198200000000000f,   // 15537: sin(85.3472900)
   0.9967124489798480100000000000f,   // 15538: sin(85.3527832)
   0.9967202121260094700000000000f,   // 15539: sin(85.3582764)
   0.9967279661105324900000000000f,   // 15540: sin(85.3637695)
   0.9967357109333461200000000000f,   // 15541: sin(85.3692627)
   0.9967434465943788600000000000f,   // 15542: sin(85.3747559)
   0.9967511730935598700000000000f,   // 15543: sin(85.3802490)
   0.9967588904308180000000000000f,   // 15544: sin(85.3857422)
   0.9967665986060824100000000000f,   // 15545: sin(85.3912354)
   0.9967742976192820500000000000f,   // 15546: sin(85.3967285)
   0.9967819874703464100000000000f,   // 15547: sin(85.4022217)
   0.9967896681592045600000000000f,   // 15548: sin(85.4077148)
   0.9967973396857861000000000000f,   // 15549: sin(85.4132080)
   0.9968050020500203200000000000f,   // 15550: sin(85.4187012)
   0.9968126552518370400000000000f,   // 15551: sin(85.4241943)
   0.9968202992911656700000000000f,   // 15552: sin(85.4296875)
   0.9968279341679361400000000000f,   // 15553: sin(85.4351807)
   0.9968355598820781700000000000f,   // 15554: sin(85.4406738)
   0.9968431764335216000000000000f,   // 15555: sin(85.4461670)
   0.9968507838221966100000000000f,   // 15556: sin(85.4516602)
   0.9968583820480330100000000000f,   // 15557: sin(85.4571533)
   0.9968659711109613100000000000f,   // 15558: sin(85.4626465)
   0.9968735510109114600000000000f,   // 15559: sin(85.4681396)
   0.9968811217478138500000000000f,   // 15560: sin(85.4736328)
   0.9968886833215989700000000000f,   // 15561: sin(85.4791260)
   0.9968962357321972100000000000f,   // 15562: sin(85.4846191)
   0.9969037789795393000000000000f,   // 15563: sin(85.4901123)
   0.9969113130635557400000000000f,   // 15564: sin(85.4956055)
   0.9969188379841773500000000000f,   // 15565: sin(85.5010986)
   0.9969263537413350900000000000f,   // 15566: sin(85.5065918)
   0.9969338603349595700000000000f,   // 15567: sin(85.5120850)
   0.9969413577649821600000000000f,   // 15568: sin(85.5175781)
   0.9969488460313336000000000000f,   // 15569: sin(85.5230713)
   0.9969563251339452800000000000f,   // 15570: sin(85.5285645)
   0.9969637950727484600000000000f,   // 15571: sin(85.5340576)
   0.9969712558476743200000000000f,   // 15572: sin(85.5395508)
   0.9969787074586543600000000000f,   // 15573: sin(85.5450439)
   0.9969861499056201800000000000f,   // 15574: sin(85.5505371)
   0.9969935831885032900000000000f,   // 15575: sin(85.5560303)
   0.9970010073072352900000000000f,   // 15576: sin(85.5615234)
   0.9970084222617480200000000000f,   // 15577: sin(85.5670166)
   0.9970158280519733100000000000f,   // 15578: sin(85.5725098)
   0.9970232246778431000000000000f,   // 15579: sin(85.5780029)
   0.9970306121392894500000000000f,   // 15580: sin(85.5834961)
   0.9970379904362444100000000000f,   // 15581: sin(85.5889893)
   0.9970453595686400400000000000f,   // 15582: sin(85.5944824)
   0.9970527195364088400000000000f,   // 15583: sin(85.5999756)
   0.9970600703394829600000000000f,   // 15584: sin(85.6054688)
   0.9970674119777949200000000000f,   // 15585: sin(85.6109619)
   0.9970747444512773100000000000f,   // 15586: sin(85.6164551)
   0.9970820677598625200000000000f,   // 15587: sin(85.6219482)
   0.9970893819034834000000000000f,   // 15588: sin(85.6274414)
   0.9970966868820727600000000000f,   // 15589: sin(85.6329346)
   0.9971039826955633300000000000f,   // 15590: sin(85.6384277)
   0.9971112693438880500000000000f,   // 15591: sin(85.6439209)
   0.9971185468269799800000000000f,   // 15592: sin(85.6494141)
   0.9971258151447722800000000000f,   // 15593: sin(85.6549072)
   0.9971330742971981100000000000f,   // 15594: sin(85.6604004)
   0.9971403242841907500000000000f,   // 15595: sin(85.6658936)
   0.9971475651056834800000000000f,   // 15596: sin(85.6713867)
   0.9971547967616097900000000000f,   // 15597: sin(85.6768799)
   0.9971620192519032900000000000f,   // 15598: sin(85.6823730)
   0.9971692325764974800000000000f,   // 15599: sin(85.6878662)
   0.9971764367353261900000000000f,   // 15600: sin(85.6933594)
   0.9971836317283230300000000000f,   // 15601: sin(85.6988525)
   0.9971908175554219400000000000f,   // 15602: sin(85.7043457)
   0.9971979942165568600000000000f,   // 15603: sin(85.7098389)
   0.9972051617116618500000000000f,   // 15604: sin(85.7153320)
   0.9972123200406710600000000000f,   // 15605: sin(85.7208252)
   0.9972194692035186700000000000f,   // 15606: sin(85.7263184)
   0.9972266092001389500000000000f,   // 15607: sin(85.7318115)
   0.9972337400304661600000000000f,   // 15608: sin(85.7373047)
   0.9972408616944350400000000000f,   // 15609: sin(85.74279