/*********************************************************************NVMH2****
Path:  C:\Dev\devrel\Nv_sdk_4\Dx8\CommonSrc
File:  NV_Error.h

Copyright (C) 1999, 2000 NVIDIA Corporation
This file is provided without support, instruction, or implied warranty of any
kind.  NVIDIA makes no guarantee of its fitness for a particular purpose and is
not liable under any circumstances for any damages or loss whatsoever arising
from the use or inability to use this file or items derived from it.

Comments:

******************************************************************************/


#ifndef	__MYERROR__
#define	__MYERROR__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


void DoError( char * str, bool quit );	// BOOL is quit/don't quit

void OkMsgBox( char * szCaption, char * szFormat, ... );

void FDebug( char * szFormat, ... );
void FMsg( char * szFormat, ... );


#ifndef NULLCHECK
#define NULLCHECK(q, msg,quit) {if(q==NULL) { DoError(msg, quit); }}
#endif

#ifndef IFNULLRET
#define IFNULLRET(q, msg)	   {if(q==NULL) { FDebug(msg); return;}}
#endif

#ifndef FAILRET
#define FAILRET(hres, msg) {if(FAILED(hres)){FDebug("*** %s   HRESULT: %d\n",msg, hres);return hres;}}
#endif

#ifndef HRESCHECK
#define HRESCHECK(q, msg)	 {if(FAILED(q)) { FDebug(msg); return;}}
#endif

#ifndef NULLASSERT
#define NULLASSERT( q, msg,quit )   {if(q==NULL) { FDebug(msg); assert(false); if(quit) exit(0); }}
#endif


#endif
