--
-- Batch behavior exporter
--

--
--Export function, takes an input dir (where max anim files are),
-- and an output dir, where the exported .beh files should go
--
function ExportFiles inDir outDir =
(
	files = getFiles (inDir + "*.max")
	
	for f in files do
	(
		behFile=(outDir + getFilenameFile f + ".beh")
		format "anim file:%\tbeh file:%\n" f behFile 
		loadMAXFile f
		exportFile behFile #noPrompt
	)
)

--
-- main
--

-- normal player behaviors
ExportFiles  "..\\animations\\player\\"		 "..\\..\\beh\\player\\"
ExportFiles  "..\\animations\\player\\climb\\" 	"..\\..\\beh\\player\\climb\\"
ExportFiles  "..\\animations\\player\\swim\\" 	"..\\..\\beh\\player\\swim\\"
ExportFiles  "..\\animations\\player\\inventory\\" 	"..\\..\\beh\\player\\inventory\\"
-- oneshots
ExportFiles  "..\\animations\\player\\canned\\"	"..\\..\\beh\\player\\canned\\"
-- personas
ExportFiles  "..\\animations\\player_flash\\" 	"..\\..\\beh\\player_flash\\"
ExportFiles  "..\\animations\\player_climb_lr\\" 	"..\\..\\beh\\player_climb_lr\\"

