utility set_lights "Set Multi-Lights"
(
	radiobuttons abs_rel "Set numbers:" labels:#("relative", "absolute")
	spinner multi_spin "Multiplier:" range:[-50,50,0]
	spinner const_spin "Contrast:" range:[0,100,0]
	spinner sde_spin "Soften Diff. Edge:" range:[0,100,0]

	checkbutton color_btn "Set RGB"
	colorpicker rgb_picker "Color:" color:[255,255,255] enabled:false

	radiobuttons hsv_abs "Set HSV:" labels:#("relative", "absolute")
	spinner hue_spin "Hue:" range:[-255,255,0] type:#integer
	spinner sat_spin "Saturation:" range:[-255,255,0] type:#integer
	spinner val_spin "Value:" range:[-255,255,0] type:#integer

	checkbutton switches_btn "Set Switches"
	checkbox on_cb "On:" enabled:false
	checkbox affdiff_cb "Affect Diffuse:" enabled:false
	checkbox affspec_cb "Affect Specular:" enabled:false
	
	button change_lights "Change Lights"
	
	on color_btn changed state do
	(
		rgb_picker.enabled = state
	)

	on switches_btn changed state do
	(
		affdiff_cb.enabled = state
		affspec_cb.enabled = state
		on_cb.enabled = state
	)

	on change_lights pressed do
	(
		for li in selection do
		(
			if isKindOf li Light then
			(
				-- is it relative (add or subtract values)?
				if abs_rel.state == 1 then
				(
					li.multiplier = li.multiplier + multi_spin.value
					li.contrast = li.contrast + const_spin.value
					li.softenDiffuseEdge = li.softenDiffuseEdge + sde_spin.value
				)
				else -- else must be absolute (set to certain value)
				(
					li.multiplier = multi_spin.value
					li.contrast = const_spin.value
					li.softenDiffuseEdge = sde_spin.value
				)
				if color_btn.state then
				(
					li.rgb = rgb_picker.color
					li.color = rgb_picker.color
				)
				if hsv_abs.state == 1 then
				(
					li.hsv.x = li.hsv.x + hue_spin.value
					li.hsv.y = li.hsv.y + sat_spin.value
					li.hsv.z = li.hsv.z + val_spin.value
				)
				else -- else must be setting to specific hsv
				(
					li.hsv.x = hue_spin.value
					li.hsv.y = sat_spin.value
					li.hsv.z = val_spin.value
				)
				if switches_btn.state then
				(
					li.on = on_cb.state
					li.affectDiffuse = affdiff_cb.state
					li.affectSpecular = affspec_cb.state
				)
			)
		)
	)

)
