fn name_replace obj fstring rstring verbose =
(
	number_changed = 0
	index = findString obj.name fstring
	if  index != undefined then
	(
		if verbose then
			format "% ==> " obj.name
		pre_string = ""
		post_string = ""
		if index == 1 then
		(
			if obj.name.count > fstring.count then
				post_string = substring obj.name (fstring.count + 1 ) (obj.name.count - fstring.count)
		)
		else
		(
			pre_string = substring obj.name 1 (index - 1)
			if obj.name.count > index - 1 + fstring.count then
			(
				start = index + fstring.count
				size = obj.name.count - start + 1
				post_string = substring obj.name start size
			)
		)
		obj.name = pre_string + rstring + post_string
		if verbose then
			format "%\n" obj.name
		number_changed = number_changed + 1
	)
	return number_changed
)

utility replace_name "Replace(in Name)"
(
	edittext find_string "                 Find:" fieldWidth:100
	edittext replace_string "Replace with:" fieldWidth:100
	radiobuttons scope labels:#("Only Selected", "All Objects")
	checkbox verbose "Verbose" checked:true
	button start_replace "Start Replace"
		
	on start_replace pressed do
	(
		number_changed = 0
		if verbose.state then
			format "-- replace.ms  version 0.1 --\n"
		case scope.state of
		(
			1: for obj in selection do
				number_changed = number_changed + name_replace obj find_string.text replace_string.text verbose.state

			2: for obj in objects do
				number_changed = number_changed + name_replace obj find_string.text replace_string.text verbose.state
		)
		format "% objects were changed\n" number_changed
	)
)

