fn map_replace bmap fstring rstring verbose =
(
	number_changed = 0
	index = findString bmap.filename fstring
	if  index != undefined then
	(
		if verbose then
			format "    % ==> " bmap.filename
		pre_string = ""
		post_string = ""
		if index == 1 then
		(
			if bmap.filename.count > fstring.count then
				post_string = substring bmap.filename (fstring.count + 1 ) (bmap.filename.count - fstring.count)
		)
		else
		(
			pre_string = substring bmap.filename 1 (index - 1)
			if bmap.filename.count > index - 1 + fstring.count then
			(
				start = index + fstring.count
				size = bmap.filename.count - start + 1
				post_string = substring bmap.filename start size
			)
		)
		bmap.filename = pre_string + rstring + post_string
		if verbose then
			format "%\n" bmap.filename
		number_changed = number_changed + 1
	)
	return number_changed
)

fn ReplaceMaterialMaps mat findonly verbose fstring rstring=
(
	number_changed = 0
	if isKindOf mat StandardMaterial then
	(
		if isKindOf mat.ambientmap BitmapTexture then
		(
			if findonly or verbose then format "    (ambient map)"
			if findonly then
			(
				format " is %\n" mat.ambientmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + dmap_replace mat.ambientmap fstring rstring verbose
			)
		)
		if isKindOf mat.diffusemap BitmapTexture then
		(
			if findonly or verbose then format "    (diffuse map)"
			if findonly then
			(
				format " is %\n" mat.diffusemap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.diffusemap fstring rstring verbose
			)
		)
		if isKindOf mat.displacementmap BitmapTexture then
		(
			if findonly or verbose then format "    (displacement map)"
			if findonly then
			(
				format " is %\n" mat.displacementmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.displacementmap fstring rstring verbose
			)
		)
		if isKindOf mat.specularmap BitmapTexture then
		(
			if findonly or verbose then format "    (specular map)"
			if findonly then
			(
				format " is %\n" mat.specularmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.specularmap fstring rstring verbose
			)
		)
		if isKindOf mat.shininessmap BitmapTexture then
		(
			if findonly or verbose then format "    (shininess map)"
			if findonly then
			(
				format " is %\n" mat.shininessmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.shininessmap fstring rstring verbose
			)
		)
		if isKindOf mat.shinestrengthmap BitmapTexture then
		(
			if findonly or verbose then format "    (shine strength map)"
			if findonly then
			(
				format " is %\n" mat.shinestrengthmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.shinestrengthmap fstring rstring verbose
			)
		)
		if isKindOf mat.selfillummap BitmapTexture then
		(
			if findonly or verbose then format "    (self illumination map)"
			if findonly then
			(
				format " is %\n" mat.selfillummap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.selfillummap fstring rstring verbose
			)
		)
		if isKindOf mat.opacitymap BitmapTexture then
		(
			if findonly or verbose then format "    (opacity map)"
			if findonly then
			(
				format " is %\n" mat.opacitymap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.opacitymap fstring rstring verbose
			)
		)
		if isKindOf mat.filtermap BitmapTexture then
		(
			if findonly or verbose then format "    (filter map)"
			if findonly then
			(
				format " is %\n" mat.filtermap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.filtermap fstring rstring verbose
			)
		)
		if isKindOf mat.bumpmap BitmapTexture then
		(
			if findonly or verbose then format "    (bump map)"
			if findonly then
			(
				format " is %\n" mat.bumpmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.bumpmap fstring rstring verbose
			)
		)
		if isKindOf mat.reflectionmap BitmapTexture then
		(
			if findonly or verbose then format "    (reflection map)"
			if findonly then
			(
				format " is %\n" mat.reflectionmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.reflectionmap fstring rstring verbose
			)
		)
		if isKindOf mat.refractionmap BitmapTexture then
		(
			if findonly or verbose then format "    (refraction map)"
			if findonly then
			(
				format " is %\n" mat.refractionmap.filename
			)
			else
			(
				if verbose then format "\n"
				number_changed = number_changed + map_replace mat.refractionmap fstring rstring verbose
			)
		)
	)
	else
	(
		if findonly or verbose then format "Non-standard Material used on material: %\n" mat.name
	)
	return number_changed
)

fn ReplaceMaps findonly verbose fstring rstring =
(
	total_number_changed = 0
	format "\n\nReplace Maps v0.1\n"
	for m in scenematerials do
	(
		if isKindOf m StandardMaterial then
		(
			if findonly or verbose then format "% contains:\n" m.name
			total_number_changed = total_number_changed + ReplaceMaterialMaps m findonly verbose fstring rstring
		)
		else if isKindOf m MultiMaterial then
		(
			if findonly or verbose then format  "% (a MultiMaterial) contains:\n" m.name
			for i=1 to m.numsubs do
			(
				if findonly or verbose then format  "  % (a sub-material) contains:\n" m[i].name
				total_number_changed = total_number_changed + ReplaceMaterialMaps m[i] findonly verbose fstring rstring
			)
		)
		else
		(
			if findonly or verbose then format "Non-standard Material used on material: %\n" m.name
		)
	)
	if findonly == false then format "Total changes made were %\n" total_number_changed
)

utility ufrmaps "Replace Material Maps"
(
	edittext find_string "Find:" fieldWidth:119
	edittext replace_string "Replace with:" fieldWidth:77
	checkbox verbose "Verbose" checked:true
	button do_replace "Do Replace"
	button list_maps "Just List All Map Filesnames"
	
	on do_replace pressed do
	(
		ReplaceMaps false verbose.state find_string.text replace_string.text
	)
	on list_maps pressed do
	(
		ReplaceMaps true true " " " "
	)
)
