-- Export function, takes an input dir (where max scene files are),
-- and an output dir, where the exported .scn files should go
--

function ExportScenes   =
(
	scnInDir = GetSavePath caption:"Choose Scene Source Directory"
	if scnInDir == undefined then return "Cancel"
	scnOutDir = GetSavePath caption:"Choose Scene Dest Directory"
	if scnOutDir == undefined then return "Cancel"
		 
		 
	scnInDir = scnInDir + "\\"
	scnOutDir = scnOutDir +"\\"
	makeDir (scnOutDir + "maps\\")
	files = getFiles (scnInDir + "*.max")
	start = timeStamp()
	for f in files do
	(
		scnFile=(scnOutDir  + getFilenameFile f + ".scn")
		format "Exporting file % to %\n" f scnFile 
		loadMAXFile f
		exportFile scnFile #noPrompt
	)
	end = TimeStamp()
	format "Scene Exporting took % minutes\n" (( end - start) / 60000.0)
)

function getOuputDir src dest =
(
	newstr = ""
	start = dest.count;
	i = 1;
	do (
		newstr = src[src.count - i] + newstr;
		i += 1;
	) while src[src.count - i] != "\\"
	return dest + (newstr + "\\")
)

-- 
-- Behavoirs
--
function ExportBehaviorDir iDir oDir = 
(
	format " Exporting Behavoirs in % OutputDir %\n" iDir oDir;
	makeDir oDir
	files = getFiles (iDir + "*.max")
	for f in files do
	(
		behFile=(oDir  + getFilenameFile f + ".beh")
		format "Exporting  file % to %\n" f behFile 
		loadMAXFile f
		exportFile behFile #noPrompt
	)
	dirs = getDirectories (iDir + "*");
	for d in dirs do
	(
		newDir = getOuputDir d oDir
		ExportBehaviorDir d newDir
	)
)

function ExportBehaviorTree  = 
(
	behInDir = GetSavePath caption:"Choose Behavior Source Directory"
	if behInDir == undefined then return "Cancel"
	behOutDir = GetSavePath caption:"Choose Behavoir Dest Directory"
	if behOutDir == undefined then return "Cancel"

	behInDir = behInDir + "\\"
	behOutDir = behOutDir +"\\"
	start =TimeStamp()
	ExportBehaviorDir behInDir behOutDir
	end = TimeStamp()
	format "Behavoir Exporting took % minutes\n" (( end - start) / 60000.0)
)


--
-- Shapes
--

function ExportShapeDir iDir oDir = 
(
	format "Exporting Shapes in % OutputDir %\n" iDir oDir;
	makeDir oDir
	makeDir (oDir + "maps\\")
	files = getFiles (iDir + "*.max")
	for f in files do
	(
		shpFile=(oDir  + getFilenameFile f + ".shp")
		format "Exporting  file % to %\n" f shpFile 
		loadMAXFile f
		exportFile shpFile #noPrompt
	)
	dirs = getDirectories (iDir + "*");
	for d in dirs do
	(
		newDir = getOuputDir d oDir
		ExportShapeDir d newDir
	)
)

function ExportShapeTree  = 
(
	shpInDir = GetSavePath caption:"Choose Shape Source Directory"
	if shpInDir == undefined then return "Cancel"
	shpOutDir = GetSavePath caption:"Choose Shape Dest Directory"
	if shpOutDir == undefined then return "Cancel"

	shpInDir = shpInDir + "\\"
	shpOutDir = shpOutDir +"\\"
	start =TimeStamp()
	ExportShapeDir shpInDir shpOutDir
	end = TimeStamp()
	format "Shape Exporting took % minutes\n" (( end - start) / 60000.0)
)

--
-- main
--
utility main_panel "Build Data"
(
	button convert_scenes "Process Scenes"
	button convert_behavoirs "Process Behaviors"
	button convert_shapes "Process Shapes"
	on convert_scenes pressed do
	(
		ExportScenes ()
	)
	on convert_behavoirs pressed do
	(
		ExportBehaviorTree ()
	)
	on convert_shapes pressed do
	(
		ExportShapeTree()
	)
)