fn tokenize str =
(
	tokens = #()
	seperators = " 	,=:;"
	start = -1
	
	if str != undefined then
	(
		for i=1 to str.count do
		(
			itsa_sep = false
			for j=1 to seperators.count do
			(
				if seperators[j] == str[i] then
					itsa_sep = true
			)
			if itsa_sep then
			(
				if start > 0 then
				(
					token = substring str start (i-start)
					append tokens token
					start = -1
				)
			)
			else
			(
				if start <= 0 then
					start = i
			)
		)
		if start > 0 then
		(
			token = substring str start str.count
			append tokens token
		)
	)
	return tokens
)

fn is_a_match str1_array str2_array =
(
	if str1_array != undefined and str2_array != undefined then
	(
		for tok1 in str1_array do
		(
			for tok2 in str2_array do
			(
				if tok1 == tok2 then
					return true
			)
		)
	)
	-- no matches found, so sorry
	return false
)

fn plasma_selective obj =
(
	global includes
	global excludes
	global select_assume

	incl = select_assume

	tok_name = tokenize obj.name

	-- if we are including everything but excludes
	if incl then
	(
		-- check to see if there are items to exclude from the list
		if is_a_match tok_name excludes then incl=false

		-- check to items to see if this object is to be included
		if is_a_match tok_name includes then incl=true 
	)
	else -- else if we are excluding everything but includes
	(
		-- check to items to see if this object is to be included
		if is_a_match tok_name includes then incl=true 

		-- check to see if there are items to exclude from the list
		if is_a_match tok_name excludes then incl=false
	)

	return incl
)

utility select_helper "SelectByName Helper"
(
	-- all the triggers
	checkbox select_trig "Generic Triggers"
	checkbox select_trca "Camera Triggers"
	checkbox select_tran "Animation Triggers"
	checkbox select_trli "Light Triggers"
	checkbox select_trpo "Portal Triggers"
	checkbox select_trfl "Flock Triggers"
	checkbox select_trat "Attach Triggers"
	checkbox select_trbe "Behavior Triggers"
	checkbox select_trpe "Persona Triggers"
	checkbox select_trik "IK Triggers"
	checkbox select_trgr "Grab Triggers"
	checkbox select_trbr "Brain Triggers"

	checkbox select_port "Portals"
	checkbox select_flock "Flock"
	checkbox select_bb "Billboards"
	checkbox select_pst "Player Start Position"
	checkbox select_light "Lights"
	checkbox select_cam "Camera"
	checkbox select_psys "Particle System"
	checkbox select_path "Path"
	checkbox select_foot "Footprint"
	checkbox select_force "Vector Field"
	checkbox select_pcm "PathCam"
	checkbox select_guide "Guide Rail"
	checkbox select_env "Environment node"
	checkbox select_amb "Ambient room sound"
	checkbox select_objs "All other objects (models)"
	checkbox select_dis "Disabled"
	edittext inc_string "Include:" fieldWidth:100
	edittext ex_string "Exclude:" fieldWidth:100
	button start_select "SelectByName"
		
	on start_select pressed do
	(
		-- build include and exclude string arrays
		global includes
		global excludes
		global select_assume
		includes = #()
		excludes = #()
		select_assume = false

		if select_trig.state then
			if includes == undefined then includes = #("trig") else append includes "trig"

		if select_trca.state then
			if includes == undefined then includes = #("trca", "trcm") else join includes #("trca", "trcm")

		if select_tran.state then
			if includes == undefined then includes = #("tran") else append includes "tran"

		if select_trli.state then
			if includes == undefined then includes = #("trli") else append includes "trli"

		if select_trpo.state then
			if includes == undefined then includes = #("trpo") else append includes "trpo"

		if select_trfl.state then
			if includes == undefined then includes = #("trfl") else append includes "trfl"

		if select_trat.state then
			if includes == undefined then includes = #("trat") else append includes "trat"

		if select_trbe.state then
			if includes == undefined then includes = #("trbe") else append includes "trbe"

		if select_trpe.state then
			if includes == undefined then includes = #("trpe") else append includes "trpe"

		if select_trik.state then
			if includes == undefined then includes = #("trik") else append includes "trik"

		if select_trgr.state then
			if includes == undefined then includes = #("trgr") else append includes "trgr"

		if select_trbr.state then
			if includes == undefined then includes = #("trbr") else append includes "trbr"

		if select_port.state then
			if includes == undefined then includes = #("pr") else append includes "pr"

		flocks = #("flock", "flbnd", "flgoal")
		if select_flock.state then
			if includes == undefined then includes = flocks else join includes flocks
		
		billbs = #("vf", "vfy")
		if select_bb.state then
			if includes == undefined then includes = billbs else join includes billbs
		
		if select_pst.state then
			if includes == undefined then includes = #("pst") else append includes "pst"

		if select_light.state then
			if includes == undefined then includes = #("li") else append includes "li"

		if select_cam.state then
			if includes == undefined then includes = #("cm") else append includes "cm"

		if select_psys.state then
			if includes == undefined then includes = #("psys") else append includes "psys"

		if select_path.state then
			if includes == undefined then includes = #("path") else append includes "path"

		if select_foot.state then
			if includes == undefined then includes = #("foot") else append includes "foot"

		if select_force.state then
			if includes == undefined then includes = #("force") else append includes "force"

		if select_pcm.state then
			if includes == undefined then includes = #("pcm") else append includes "pcm"

		if select_guide.state then
			if includes == undefined then includes = #("guide") else append includes "guide"

		if select_env.state then
			if includes == undefined then includes = #("env") else append includes "env"

		if select_amb.state then
			if includes == undefined then includes = #("amb") else append includes "amb"

		if select_objs.state then
		(
			triggers = #("trig", "trca", "trcm", "tran", "trli", "trpo", "trfl", "trat", "trbe", "trpe", "trik", "trgr", "trbr")
			if excludes == undefined then excludes = triggers else join excludes triggers
			join excludes flocks
			join excludes billbs
			all_others = #("pr", "pst", "li", "cm", "psys", "path", "foot", "force", "pcm", "guide", "env", "amb")
			join excludes all_others
			select_assume = true
		)

		dis = #("dis", "di")
		if select_dis.state then
			if includes == undefined then includes = dis else join includes dis

		if inc_string.text != "" then
		(
			inc_tokens = tokenize inc_string.text
			if includes == undefined then includes = inc_tokens else join includes inc_tokens
		)
		if ex_string.text != "" then
		(
			ex_tokens = tokenize ex_string.text
			if excludes == undefined then excludes = ex_tokens else join excludes ex_tokens
		)

		selected_objs = selectByName title:"SelectByName Plasma Enhanced" filter:plasma_selective
		if selected_objs != undefined then select selected_objs
	)
)
