@echo off
cls
echo ***************************************************************************
echo *                                                                         *
echo *                  Shadow Warrior (1997) Source Codes                     *
echo *                  ----------------------------------                     *
echo *                                                                         *
echo * [1] 1.0 [2] 1.1                                                         *
echo * [3] Shareware 1.2 [4] UK 1.2 [5] Registered 1.2 [6] Parental locked 1.2 *
echo *                                                                         *
echo * [0] Cancel and quit                                                     *
echo *                                                                         *
echo ***************************************************************************
echo.
choice /C:6543210 /N Please select code tree to prepare in the DEV\SW directory:
echo.

if ERRORLEVEL 7 goto quit
if ERRORLEVEL 1 set CHOICE=6
if ERRORLEVEL 2 set CHOICE=5
if ERRORLEVEL 3 set CHOICE=4
if ERRORLEVEL 4 set CHOICE=3
if ERRORLEVEL 5 set CHOICE=2
if ERRORLEVEL 6 set CHOICE=1

REM Preparation common to all version

mkdir DEV
mkdir DEV\SW
mkdir DEV\SW\OBJ
mkdir DEV\SW\SETUP
mkdir DEV\SW\SETUP\MACT

copy source\CODE\*.LIB DEV\SW
copy source\CODE\OBJ\A.OBJ source\CODE\OBJ\MMULTI.OBJ source\CODE\OBJ\CACHE1D.OBJ DEV\SW\OBJ
copy source\CODE\SETUP\*.H DEV\SW\SETUP
copy source\CODE\SETUP\MACT\*.H source\CODE\SETUP\MACT\MACT386.LIB DEV\SW\SETUP\MACT

REM Unfortunately, the original HOOKS.OBJ as used in 1.0-1.2 includes direct
REM calls to MC functions. A recreated HOOKS.C file which is perfectly
REM matching is used. Apparently HOOKS.OBJ was built with the assistance of
REM headers from SWC0507B. In particular, DEBUG was defined to 1 in GAME.H,
REM thus NOMEMCHECK was *NOT* defined and calls to MC functions were inserted.

REM Similarly, edited MAKEFILEs are used, with the MC dependencies removed.
REM As a bonus, though, the static symbols were added.

call tools\striphdr DEV\SW newstuff\HOOKS.C
REM copy source\CODE\OBJ\HOOKS.OBJ DEV\SW\OBJ

if %CHOICE% == 1 goto sw10

REM Build engine object for 1.1 + 1.2

copy source\CODE\OBJ\ENGINE.OBJ DEV\SW\OBJ

if %CHOICE% == 2 goto sw11

REM Preparation for 1.2

copy source\CODE\OBJ\BUILD.OBJ DEV\SW\OBJ
copy source\CODE\WSTUB.EXE DEV\SW\WSTUBALT.EXE

copy tools\MAKEBLD.BAT DEV\SW

mkdir DEV\SW\ten
mkdir DEV\SW\ten\INCL
mkdir DEV\SW\ten\LIB
copy source\CODE\INCL\*.H DEV\SW\ten\INCL
copy source\CODE\LIB\SDKBOXR.LIB DEV\SW\ten\LIB\SDKBOXR.LIB

copy newstuff\SWV12ADD\MAKEFILE newstuff\SWV12ADD\makebld DEV\SW
REM Unfortunately a few of these will be overwritten soon (from SWV12)...
copy source\REGCODE\*.H source\REGCODE\*.DEF DEV\SW
call tools\STRIPREG.BAT
REM And here it begins...
call tools\striphdr DEV\SW source\SWV12ADD\MISCACTR.C source\SWV12ADD\PLAYER.C source\SWV12ADD\TEXT.C source\SWV12ADD\WEAPON.C

if %CHOICE% == 3 goto swshar12
if %CHOICE% == 4 goto swuk12
if %CHOICE% == 5 goto swreg12
if %CHOICE% == 6 goto swplck12

goto quit

:sw10

copy tools\MAKESW.BAT DEV\SW
copy F_OBJS\ENGINE.OBJ DEV\SW\OBJ
copy newstuff\sws10\*.OBJ DEV\SW\OBJ
copy newstuff\sws10\MAKEFILE DEV\SW
copy source\sws10\*.H source\sws10\*.DEF DEV\SW
call tools\STRIPS10.BAT

goto quit

:sw11

copy tools\MAKESW.BAT DEV\SW
copy newstuff\SWV11\*.OBJ DEV\SW\OBJ
copy newstuff\SWV11\MAKEFILE DEV\SW
copy source\SWV11\*.H source\SWV11\*.DEF DEV\SW
call tools\STRIPV11.BAT

goto quit

:swshar12

copy tools\MAKESW_2.BAT DEV\SW\MAKESW.BAT
copy newstuff\SWV12ADD\*.OBJ DEV\SW\OBJ
copy /Y source\SWV12ADD\SHAR\GAME.H DEV\SW
call tools\striphdr DEV\SW source\SWV12ADD\NET.C source\SWV12ADD\SHAR\GAME.C

goto quit

:swuk12

copy tools\MAKESW_2.BAT DEV\SW\MAKESW.BAT
copy newstuff\SWV12ADD\*.OBJ DEV\SW\OBJ
copy /Y source\SWV12ADD\UK\GAME.H DEV\SW
call tools\striphdr DEV\SW source\SWV12ADD\NET.C source\SWV12ADD\UK\GAME.C

goto quit

:swreg12

copy tools\MAKESW.BAT DEV\SW
copy newstuff\SWV12ADD\ALT\*.OBJ DEV\SW\OBJ
call tools\striphdr DEV\SW source\SWV12ADD\ALT\NET.C source\SWV12ADD\ALT\REG\GAME.C

goto quit

:swplck12

copy tools\MAKESW.BAT DEV\SW
copy newstuff\SWV12ADD\ALT\*.OBJ DEV\SW\OBJ
call tools\striphdr DEV\SW source\SWV12ADD\ALT\NET.C source\SWV12ADD\ALT\PLOCK\GAME.C

goto quit

:quit
