//-------------------------------------------------------------------------
/*
Copyright (C) 2019 GHI Media, LLC

This file is NOT part of Shadow Warrior (1997).
However, it is either an older version of a file that is, or is some
test code written or used during the development of Shadow Warrior (1997).
This file is provided purely for educational interest.

*/
//-------------------------------------------------------------------------

// lbmlib.h

typedef unsigned char   UBYTE;
typedef short           WORD;
typedef unsigned short  UWORD;
typedef long            LONG;

typedef enum
{
    ms_none,
    ms_mask,
    ms_transcolor,
    ms_lasso
} mask_t;

typedef enum
{
    cm_none,
    cm_rle1
} compress_t;

typedef struct
{
    UWORD       w,h;
    WORD        x,y;
    UBYTE       nPlanes;
    UBYTE       masking;
    UBYTE       compression;
    UBYTE       pad1;
    UWORD       transparentColor;
    UBYTE       xAspect,yAspect;
    WORD        pageWidth,pageHeight;
} bmhd_t;

extern  bmhd_t  bmhd;                       // will be in native byte order


void LoadLBM (char *filename, byte **picture, byte **palette);

void WriteLBMfile (char *filename, byte *data, int width, int height
    , byte *palette);

