//-------------------------------------------------------------------------
/*
Copyright (C) 2019 GHI Media, LLC

This file is NOT part of Shadow Warrior (1997).
However, it is either an older version of a file that is, or is some
test code written or used during the development of Shadow Warrior (1997).
This file is provided purely for educational interest.

*/
//-------------------------------------------------------------------------

#ifdef DIGI_TABLE
#define DIGI_ENTRY(name, id, pri, pitch_lo, pitch_hi, voc_num, voc_dist, voc_flags) { name, NULL, pitch_lo, pitch_hi, pri, voc_num, voc_dist, voc_flags},
#endif

#ifdef DIGI_ENUM
#define DIGI_ENTRY(name, id, pri, pitch_lo, pitch_hi, voc_num, voc_dist, voc_flags) id,
#endif

// !JIM! 09/20/95
// NOTE: HIGHER priority numbers have the highest precedence in the play list.
#define PRI_MAX                 100
#define PRI_PLAYERDEATH         50
#define PRI_HI_PLAYERWEAP       49
#define PRI_LOW_PLAYERWEAP      48
#define PRI_PLAYERAMBIENT       47
#define PRI_NPCDEATH            40
#define PRI_NPCWEAP             39
#define PRI_NPCATTACK           38
#define PRI_NPCAMBIENT          37
#define PRI_ITEM                40
#define PRI_SWITCH              PRI_MAX  // To give a clue to player location
#define PRI_SECTOROBJ           30
#define PRI_ENVIRONMENT         20
#define PRI_AMBIENT             10

// Distance definitions for effective sound ranges
// Note: These are some useful constants, but you can type in whatever you want!
#define DIST_NORMAL             0        // Just play sound normaly
#define DIST_MAXNORMAL          16384    // This is max distance constant for normal sounds
                                         // This is the limiting constant in Sound_Dist function.
#define DIST_WIDE               65536    // Half Level at full volume before sound begins to fade.
#define DIST_LEVELWIDE          131072   // Full Level

// VOC Flag definitions
#define VF_NORMAL               0
#define VF_LOOP                 1

// WEAPONS ////////////////////////////////////////////////////////////////////

// SWORD   
DIGI_ENTRY("SWRDSTR1.VOC",  DIGI_SWORDSWOOSH,       PRI_HI_PLAYERWEAP,    -200,   200, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("SWRDSTR2.VOC",  DIGI_SWORDSWOOSH_PWR,   PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("SWRDSMK1.VOC",  DIGI_SWORDSMACK,        PRI_HI_PLAYERWEAP,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
//DIGI_ENTRY("SWRDSMK2.VOC",  DIGI_SWORDSMACK_PWR,    PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("SWRDRL.VOC",    DIGI_SWORDRAISELOWER,   PRI_LOW_PLAYERWEAP, 0,      0  )

// SHURIKEN
DIGI_ENTRY("STAR.VOC",      DIGI_STAR,              PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("STRCLNK.VOC",   DIGI_STARCLINK,         PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("STRPWR.VOC",    DIGI_STAR_PWR,          PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("STRCLNKP.VOC",  DIGI_STARCLINK_PWR,     PRI_LOW_PLAYERWEAP, 0,      0  )
//DIGI_ENTRY("STRRL.VOC",     DIGI_STARRAISELOWER,    PRI_LOW_PLAYERWEAP, 0,      0  )

// UZI
DIGI_ENTRY("UZIFIRE1.VOC",  DIGI_UZIFIRE,           PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("UZIFIRE2.VOC",  DIGI_UZIFIRE_PWR,       PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("RICH1.VOC",     DIGI_RICHOCHET1,        PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
//DIGI_ENTRY("RICH2.VOC",     DIGI_RICHOCHET2,        PRI_LOW_PLAYERWEAP, 0,      0  )
//DIGI_ENTRY("UZICLK.VOC",    DIGI_UZIDRYFIRE,        PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("RMVCLIP.VOC",   DIGI_REMOVECLIP,        PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("RPLCLIP.VOC",   DIGI_REPLACECLIP,       PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("UZICOCK.VOC",   DIGI_COCKUZI,           PRI_LOW_PLAYERWEAP, 0,      0  )
//DIGI_ENTRY("UZIWTR.VOC",    DIGI_UZIFIREUNDERWATER, PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("UZISHELL.VOC",  DIGI_UZISPENTBRASS,     PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )

// CROSSBOW
DIGI_ENTRY("BOWFIR1.VOC",   DIGI_BOWFIRE,           PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("BOWRLD.VOC",    DIGI_BOWRELOAD,         PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("BOWFIR2.VOC",   DIGI_BOWFIRE_PWR,       PRI_HI_PLAYERWEAP,  -400,   400  )
DIGI_ENTRY("BOWEXP1.VOC",   DIGI_BOLTEXPLODE,       PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_MAXNORMAL, VF_NORMAL )
//DIGI_ENTRY("BOWEXP2.VOC",   DIGI_BOLTEXPLODE_PWR,   PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("BOWEXP3.VOC",   DIGI_BOLTEXPLODEINWATER,PRI_HI_PLAYERWEAP,  0,      0  )
DIGI_ENTRY("BOWWIZ.VOC",    DIGI_BOLTWIZ,           PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_LOOP )
//DIGI_ENTRY("BOWRL.VOC",     DIGI_RAISELOWER,        PRI_LOW_PLAYERWEAP, 0,      0  )

// GORO HEAD
DIGI_ENTRY("GHFIR1.VOC",    DIGI_HEADFIRE,          PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("GHFIR2.VOC",    DIGI_HEADFIRE_PWR,      PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("GHRL.VOC",      DIGI_HEADRAISELOWER,    PRI_LOW_PLAYERWEAP, 0,      0  )
//DIGI_ENTRY("GHWATER.VOC",   DIGI_HEADFIREUNDERWATER,PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("GHWIZ.VOC",     DIGI_HEADSHOTWIZ,       PRI_PLAYERAMBIENT,  0,      0  )
//DIGI_ENTRY("GHHIT.VOC",     DIGI_HEADSHOTHIT,       PRI_LOW_PLAYERWEAP, 0,      0  )

// GUANTLET WRIST BLADE
DIGI_ENTRY("GNTFIR1.VOC",   DIGI_GNTFIRE,           PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("GNTFIR2.VOC",   DIGI_GNTFIRE_PWR,       PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("GNTRL.VOC",     DIGI_GNTRAISELOWER,     PRI_LOW_PLAYERWEAP, 0,      0  )
DIGI_ENTRY("GNTHITW.VOC",   DIGI_GNTHITWALL,        PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("GNTHIT.VOC",    DIGI_GNTZAPHIT,         PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )

// HEART ATTACK
DIGI_ENTRY("HRTBEAT.VOC",   DIGI_HEARTBEAT,         PRI_LOW_PLAYERWEAP,   0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("HRTSQZ.VOC",    DIGI_HEARTSQUEEZE,      PRI_LOW_PLAYERWEAP, 0,      0  )
DIGI_ENTRY("HRTFIR1.VOC",   DIGI_HEARTFIRE,         PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("HRTFIR2.VOC",   DIGI_HEARTFIRE_PWR,     PRI_HI_PLAYERWEAP,  0,      0  )
//DIGI_ENTRY("HRTHIT.VOC",    DIGI_HEARTHIT,          PRI_LOW_PLAYERWEAP, 0,      0  )
//DIGI_ENTRY("HRTGOOSH.VOC",  DIGI_HEARTGOOSH,        PRI_NPCDEATH,       0,      0  )

// RING OF FIRE SPELL
DIGI_ENTRY("RFWIZ.VOC",     DIGI_RFWIZ,             PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("RFHIT.VOC",     DIGI_RFHIT,             PRI_LOW_PLAYERWEAP, 0,      0  )

// NAPALM SPELL
DIGI_ENTRY("NAPFIRE.VOC",   DIGI_NAPFIRE,           PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("NAPTWIZ.VOC",   DIGI_NAPWIZ,            PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("NAPPUFF.VOC",   DIGI_NAPPUFF,           PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("NAPSIZL.VOC",   DIGI_NAPSIZZLE,         PRI_LOW_PLAYERWEAP, 0,      0  )

// MAGIC MIRV SPELL
DIGI_ENTRY("MMFIRE.VOC",    DIGI_MIRVFIRE,          PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("MMWIZ.VOC",     DIGI_MIRVWIZ,           PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("MMHIT.VOC",     DIGI_MIRVHIT,           PRI_LOW_PLAYERWEAP, 0,      0  )

// SPIRAL SPELL
DIGI_ENTRY("SPRLFIRE.VOC",  DIGI_SPIRALFIRE,        PRI_HI_PLAYERWEAP,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
DIGI_ENTRY("SPRLWIZ.VOC",   DIGI_SPIRALWIZ,         PRI_PLAYERAMBIENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL )
//DIGI_ENTRY("SPRLHIT.VOC",   DIGI_SPIRALHIT,         PRI_LOW_PLAYERWEAP, 0,      0  )

// MAGIC SOUNDS, GENERIC (USED FOR MAGIC CARPET RIDES,ETC.)
DIGI_ENTRY("MAGIC1.VOC",    DIGI_MAGIC1,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL )             
DIGI_ENTRY("MAGIC2.VOC",    DIGI_MAGIC2,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("MAGIC3.VOC",    DIGI_MAGIC3,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("MAGIC4.VOC",    DIGI_MAGIC4,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("MAGIC5.VOC",    DIGI_MAGIC5,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("MAGIC6.VOC",    DIGI_MAGIC6,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("MAGIC7.VOC",    DIGI_MAGIC7,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SHADOW WARRIOR SPELL
DIGI_ENTRY("SWSPELL.VOC",   DIGI_SWCLOAKUNCLOAK,    PRI_HI_PLAYERWEAP,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// PLAYER DEAD HEAD
DIGI_ENTRY("DHVOMIT.VOC",   DIGI_DHVOMIT,           PRI_HI_PLAYERWEAP,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("DHCLUNK.VOC",   DIGI_DHCLUNK,           PRI_PLAYERAMBIENT,  -200,   200, NULL, DIST_NORMAL, VF_NORMAL  )
//DIGI_ENTRY("DHOOF.VOC",     DIGI_DHOOF,             PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("DHSQSH.VOC",    DIGI_DHSQUISH,          PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// WEAPON RELATED
DIGI_ENTRY("LAVAHIT.VOC",   DIGI_PROJECTILELAVAHIT, PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("WATRHIT.VOC",   DIGI_PROJECTILEWATERHIT,PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
                                                        
// ITEMS                                                
DIGI_ENTRY("KEY.VOC",       DIGI_KEY,               PRI_ITEM,           0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("ITEM.VOC",      DIGI_ITEM,              PRI_ITEM,           0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("FLY.VOC",       DIGI_FLYSPELL,          PRI_ITEM,           0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// DEATH/HURT
DIGI_ENTRY("BODY1.VOC",     DIGI_BODYFALL1,         PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BODY2.VOC",     DIGI_BODYSQUISH1,       PRI_PLAYERAMBIENT,  -200,   200, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BURN1.VOC",     DIGI_BODYBURN,          PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BURNSCRM.VOC",  DIGI_BODYBURNSCREAM,    PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BODY3.VOC",     DIGI_BODYCRUSHED1,      PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BODY4.VOC",     DIGI_BODYHACKED1,       PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("BURN2.VOC",     DIGI_BODYSINGED,        PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("DROWN1.VOC",    DIGI_DROWN,             PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("SCREAM1.VOC",   DIGI_SCREAM1,           PRI_PLAYERDEATH,    -200,   400, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("SCREAM2.VOC",   DIGI_SCREAM2,           PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("SCREAM3.VOC",   DIGI_SCREAM3,           PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("HIT1.VOC",      DIGI_HIT1,              PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("ELECTRC1.VOC",  DIGI_ELECTRICUTE1,      PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("FALL1.VOC",     DIGI_FALLSCREAM,        PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("IMPALE1.VOC",   DIGI_IMPALED,           PRI_PLAYERDEATH,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("OOF1.VOC",      DIGI_OOF1,              PRI_PLAYERAMBIENT,  0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// NPC'S //////////////////////////////////////////////////////////////////////

// COOLIE
DIGI_ENTRY("COLEXP.VOC",    DIGI_COOLIEEXPLODE,     PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("COLSCRM.VOC",   DIGI_COOLIESCREAM,      PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("COLALRT.VOC",   DIGI_COOLIEALERT,       PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("COLAMB.VOC",    DIGI_COOLIEAMBIENT,     PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("COLPAIN.VOC",   DIGI_COOLIEPAIN,        PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// COOLIE GHOST
DIGI_ENTRY("CGMAT.VOC",     DIGI_CGMATERIALIZE,     PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGALRT.VOC",    DIGI_CGALERT,           PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGWHACK.VOC",   DIGI_CGTHIGHBONE,       PRI_NPCWEAP,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGAMB.VOC",     DIGI_CGAMBIENT,         PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGPAIN.VOC",    DIGI_CGPAIN,            PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGSHOOT.VOC",   DIGI_CGMAGIC,           PRI_NPCWEAP,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGHIT.VOC",     DIGI_CGMAGICHIT,        PRI_NPCWEAP,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("CGSCRM.VOC",    DIGI_CGSCREAM,          PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// NINJA
DIGI_ENTRY("NINAMB.VOC",    DIGI_NINJAAMBIENT,      PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NINSTAR.VOC",   DIGI_NINJASTAR,         PRI_NPCWEAP,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NINPAIN.VOC",   DIGI_NINJAPAIN,         PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NINSCRM.VOC",   DIGI_NINJASCREAM,       PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("NINALRT.VOC",   DIGI_NINJAALERT,        PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// RIPPER
DIGI_ENTRY("RIPAMB.VOC",    DIGI_RIPPERAMBIENT,     PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("RIPALRT.VOC",   DIGI_RIPPERALERT,       PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("RIPATCK.VOC",   DIGI_RIPPERATTACK,      PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("RIPPAIN.VOC",   DIGI_RIPPERPAIN,        PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("RIPSCRM.VOC",   DIGI_RIPPERSCREAM,      PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("RIPHRT.VOC",    DIGI_RIPPERHEARTOUT,    PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// GUARDIAN 
DIGI_ENTRY("GRDAMB.VOC",    DIGI_GRDAMBIENT,        PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDALRT.VOC",   DIGI_GRDALERT,          PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDPAIN.VOC",   DIGI_GRDPAIN,           PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDSCRM.VOC",   DIGI_GRDSCREAM,         PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDFIR.VOC",    DIGI_GRDFIREBALL,       PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDAXE.VOC",    DIGI_GRDSWINGAXE,       PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )
DIGI_ENTRY("GRDAXHT.VOC",   DIGI_GRDAXEHIT,         PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )

// SKELETOR PRIEST
DIGI_ENTRY("SPAMB.VOC",     DIGI_SPAMBIENT,         PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPALRT.VOC",    DIGI_SPALERT,           PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPPAIN.VOC",    DIGI_SPPAIN,            PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPSCRM.VOC",    DIGI_SPSCREAM,          PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPBLADE.VOC",   DIGI_SPBLADE,           PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPELEC.VOC",    DIGI_SPELEC,            PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SPTLPRT.VOC",   DIGI_SPTELEPORT,        PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// ACCURSED HEAD
DIGI_ENTRY("AHAMB.VOC",     DIGI_AHAMBIENT,         PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("AHSCRM.VOC",    DIGI_AHSCREAMATTACK,    PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("AHEXP.VOC",     DIGI_AHEXPLODE,         PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("AHSHWSH.VOC",   DIGI_AHSWOOSH,          PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// HORNET
DIGI_ENTRY("HBUZZ.VOC",     DIGI_HORNETBUZZ,        PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("HSTING.VOC",    DIGI_HORNETSTING,       PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("HPAIN.VOC",     DIGI_HORNETPAIN,        PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("HDEATH.VOC",    DIGI_HORNETDEATH,       PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SERPENT GOD BOSS
DIGI_ENTRY("SGAMB.VOC",     DIGI_SERPAMBIENT,       PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGALRT.VOC",    DIGI_SERPALERT,         PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGPAIN.VOC",    DIGI_SERPPAIN,          PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGSCRM.VOC",    DIGI_SERPSCREAM,        PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGDETH.VOC",    DIGI_SERPDEATHEXPLODE,  PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGSWORD.VOC",   DIGI_SERPSWORDATTACK,   PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGMAGIC.VOC",   DIGI_SERPMAGICLAUNCH,   PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGHEADS.VOC",   DIGI_SERPSUMMONHEADS,   PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("SGTAUNT.VOC",   DIGI_SERPTAUNTYOU,      PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// LAVA BOSS
DIGI_ENTRY("LVAMB.VOC",     DIGI_LAVABOSSAMBIENT,   PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVSWIM.VOC",    DIGI_LAVABOSSSWIM,      PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVRISE.VOC",    DIGI_LAVABOSSRISE,      PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVALRT.VOC",    DIGI_LAVABOSSALERT,     PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVFLAME.VOC",   DIGI_LAVABOSSFLAME,     PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVMETEOR.VOC",  DIGI_LAVABOSSMETEOR,    PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVMETEXP.VOC",  DIGI_LAVABOSSMETEXP,    PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVPAIN.VOC",    DIGI_LAVABOSSPAIN,      PRI_NPCATTACK,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVSIZZLE.VOC",  DIGI_LAVABOSSSIZZLE,    PRI_NPCAMBIENT,     0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("LVEXPL.VOC",    DIGI_LAVABOSSEXPLODE,   PRI_NPCDEATH,       0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// LEVEL AND SECTOR OBJECT SOUNDS /////////////////////////////////////////////

// MOTOR BOAT
DIGI_ENTRY("BTSTRT.VOC",    DIGI_BOATSTART,         PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("BTRUN.VOC",     DIGI_BOATRUN,           PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("BTSTOP.VOC",    DIGI_BOATSTOP,          PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WWII JAP ARMY TANK
DIGI_ENTRY("TNKSTRT.VOC",   DIGI_TANKSTART,         PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("TNKRUN.VOC",    DIGI_TANKRUN,           PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("TNKSTOP.VOC",   DIGI_TANKSTOP,          PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("TNKIDLE.VOC",   DIGI_TANKRUNIDLE,       PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("TNKFIRE.VOC",   DIGI_TANKFIRE,          PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WWII JAP BOMBER PLANE
DIGI_ENTRY("BMBFLY.VOC",    DIGI_BOMBRFLYING,       PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("BMBDROP.VOC",   DIGI_BOMBRDROPBOMB,     PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// BUBBLES
DIGI_ENTRY("BUBBLE.VOC",    DIGI_BUBBLES,           PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// CHAIN MOVING
DIGI_ENTRY("CHAIN.VOC",     DIGI_CHAIN,             PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// CHAIN DOOR
DIGI_ENTRY("CHNDOOR.VOC",   DIGI_CHAINDOOR,         PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// CRICKETS
DIGI_ENTRY("CRCKT.VOC",     DIGI_CRICKETS,          PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WOOD DOOR OPEN/CLOSE
DIGI_ENTRY("DRWOODO.VOC",   DIGI_WOODDOOROPEN,      PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("DRWOODC.VOC",   DIGI_WOODDOORCLOSE,     PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// METAL DOOR OPEN/CLOSE
DIGI_ENTRY("DRMETO.VOC",    DIGI_METALDOOROPEN,     PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("DRMETC.VOC",    DIGI_METALDOORCLOSE,    PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SLIDING DOOR OPEN/CLOSE
DIGI_ENTRY("DRSLDO.VOC",    DIGI_SLIDEDOOROPEN,     PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("DRSLDC.VOC",    DIGI_SLIDEDOORCLOSE,    PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// STONE SLIDING DOOR OPEN/CLOSE
DIGI_ENTRY("DRSTNO.VOC",    DIGI_STONEDOOROPEN,     PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("DRSTNC.VOC",    DIGI_STONEDOORCLOSE,    PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SQUEAKY DOOR OPEN/CLOSE
DIGI_ENTRY("DRSQKO.VOC",    DIGI_SQUEAKYDOOROPEN,   PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("DRSQKC.VOC",    DIGI_SQUEAKYDOORCLOSE,  PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// GIANT DRILL MACHINE
DIGI_ENTRY("DRILL.VOC",     DIGI_DRILL,             PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT WATER DRIPPING IN CAVE
DIGI_ENTRY("CAVE1.VOC",     DIGI_CAVEDRIP1,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("CAVE2.VOC",     DIGI_CAVEDRIP2,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("CAVE3.VOC",     DIGI_CAVEDRIP3,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WATER FALL
DIGI_ENTRY("WTRFAL1.VOC",   DIGI_WATERFALL1,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("WTRFAL2.VOC",   DIGI_WATERFALL2,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WATER FLOWING
DIGI_ENTRY("WTRFLW1.VOC",   DIGI_WATERFLOW1,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("WTRFLW2.VOC",   DIGI_WATERFLOW2,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// ELEVATOR START/STOP
DIGI_ENTRY("ELEV1.VOC",     DIGI_ELEVATOR,          PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SMALL EXPLOSION
DIGI_ENTRY("EXPSML.VOC",    DIGI_SMALLEXPLOSION,    PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// MEDIUM EXPLOSION
DIGI_ENTRY("EXPMED.VOC",    DIGI_MEDIUMEXPLOSION,   PRI_ENVIRONMENT,    0,      0, NULL, DIST_MAXNORMAL, VF_LOOP )             

// LARGE EXPLOSION
DIGI_ENTRY("EXPLRG.VOC",    DIGI_LARGEEXPLOSION,    PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// CRACKLING FIRE FOR CONTINUOUS BURN
DIGI_ENTRY("FIRE1.VOC",     DIGI_FIRE1,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// POWERFULL HIGH HEAT CONTINUOUS BURN
DIGI_ENTRY("FIRE2.VOC",     DIGI_FIRE2,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SHOOTING FIREBALL FOR FIREBALL TRAP
DIGI_ENTRY("FBALL1.VOC",    DIGI_FIREBALL1,         PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SECTOR GEAR COG TURNING
DIGI_ENTRY("GEAR1.VOC",     DIGI_GEAR1,             PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT GONG FOR USE IN TEMPLE/PALACE LEVELS
DIGI_ENTRY("GONG.VOC",      DIGI_GONG,              PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT LAVA FLOW
DIGI_ENTRY("LAVAFLW1.VOC",  DIGI_LAVAFLOW1,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// GENERIC SECTOR OBJECT MACHINE RUNNING
DIGI_ENTRY("MACHN1.VOC",    DIGI_MACHINE1,          PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT MUD BUBBLES
DIGI_ENTRY("MUD1.VOC",      DIGI_MUBBUBBLES1,       PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT EARTH QUAKE 
DIGI_ENTRY("QUAKE1.VOC",    DIGI_EARTHQUAKE,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// YUCKY SEWER FLOW
DIGI_ENTRY("SEWER1.VOC",    DIGI_SEWERFLOW1,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// WATER SPLASHING (USE FOR PLAYER/NPC'S JUMPING AROUND IN WATER)
DIGI_ENTRY("SPLASH1.VOC",   DIGI_SPLASH1,           PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// STEAM FLOW
DIGI_ENTRY("STEAM1.VOC",    DIGI_STEAM1,            PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// VOLCANIC STEAM VENT
DIGI_ENTRY("VOLSTM1.VOC",   DIGI_VOLCANOSTEAM1,     PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// STOMPER THUD SECTOR OBJECT
DIGI_ENTRY("STMPR.VOC",     DIGI_STOMPER,           PRI_SECTOROBJ,      0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SCARY AMBIENT SWAMP SOUNDS
DIGI_ENTRY("SWAMP1.VOC",    DIGI_SWAMP,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// FLIP SWITCH
DIGI_ENTRY("SWITCH1.VOC",   DIGI_REGULARSWITCH,     PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// FLIP LARGE SWITCH
DIGI_ENTRY("SWITCH2.VOC",   DIGI_BIGSWITCH,         PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// STONE SWITCH
DIGI_ENTRY("SWITCH3.VOC",   DIGI_STONESWITCH,       PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// BREAKABLE GLASS SWITCH
DIGI_ENTRY("SWITCH4.VOC",   DIGI_GLASSSWITCH,       PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// AMBIENT ROLLING THUNDER
DIGI_ENTRY("THUNDR.VOC",    DIGI_THUNDER,           PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// TELEPORTER
DIGI_ENTRY("TELPORT.VOC",   DIGI_TELEPORT,          PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// UNDERWATER AMBIENCE
DIGI_ENTRY("UNDRWTR.VOC",   DIGI_UNDERWATER,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// UNLOCK BIG LOCKED DOOR
DIGI_ENTRY("UNLOCK.VOC",    DIGI_UNLOCK,            PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SQUEAKY VALVE TURNING
DIGI_ENTRY("VALVE.VOC",     DIGI_SQUEAKYVALVE,      PRI_ENVIRONMENT,    0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// SPOOKY ETHERAL VOID AMBIENCE (NETHERWORLDLY SOUNDS)
DIGI_ENTRY("VOID1.VOC",     DIGI_VOID1,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("VOID2.VOC",     DIGI_VOID2,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("VOID3.VOC",     DIGI_VOID3,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("VOID4.VOC",     DIGI_VOID4,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             
DIGI_ENTRY("VOID5.VOC",     DIGI_VOID5,             PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// VOLCANIC ERUPTION
DIGI_ENTRY("ERUPT.VOC",     DIGI_ERUPTION,          PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// VOLCANIC SIZZLING PROJECTILES FLYING THROUGH AIR
DIGI_ENTRY("VOLPRJCT.VOC",  DIGI_VOLCANOPROJECTILE, PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// LIGHT WIND AMBIENCE
DIGI_ENTRY("WIND1.VOC",     DIGI_LIGHTWIND,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// STRONG BLOWING WIND AMBIENCE
DIGI_ENTRY("WIND2.VOC",     DIGI_STRONGWIND,        PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// BREAKING WOOD AMBIENCE
DIGI_ENTRY("WOODBRK.VOC",   DIGI_BREAKINGWOOD,      PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// BREAKING, TUMBLING STONES FALLING AMBIENCE
DIGI_ENTRY("STONEBRK.VOC",  DIGI_BREAKSTONES,       PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

// TREES BURNING AMBIENCE
DIGI_ENTRY("BRNTREE.VOC",   DIGI_BURNTREES,         PRI_AMBIENT,        0,      0, NULL, DIST_NORMAL, VF_NORMAL  )             

#undef DIGI_ENTRY
