/*
Copyright (C) 2019 Apogee Software, Ltd.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

*/

//***************************************************************************
//
//    RT_UTIL.C - various utils palette funcs and modex stuff
//
//***************************************************************************

#ifndef _util_lib_public
#define _util_lib_public

extern  int32    _argc;
extern  char **  _argv;

void   Error (int8 *error, ...);

int8   CheckParm (char *check);

void   GraphicsMode(void);
void   TextMode(void);

void   GetPalette(char * pal);
void   *SafeMalloc (int32 size);
void   SafeFree (void * ptr);
int32  ParseHex (char *hex);
int32  ParseNum (char *str);
int16  MotoShort (int16 l);
int16  IntelShort (int16 l);
int32  MotoLong (int32 l);
int32  IntelLong (int32 l);
void   SetPalette ( char * pal );
void   NormalizePalette (byte *palette);

void HeapSort(char * base, int32 nel, int32 width, int32 (*compare)(), void (*switcher)());

#endif
