#include "PCH.h"
#include "../MSystem.h"
#include "MInput.h"
#include "MInputCore.h"

// -------------------------------------------------------------------
//  CScanKey
// -------------------------------------------------------------------
CScanCodeName CScanKey::ms_ScanCodeNames[] = 
{
	{ SKEY_CURSOR_LEFT, SKEY_CURSOR_LEFT, "LEFT" },
	{ SKEY_CURSOR_UP, SKEY_CURSOR_UP, "UP" },
	{ SKEY_CURSOR_RIGHT, SKEY_CURSOR_RIGHT, "RIGHT" },
	{ SKEY_CURSOR_DOWN, SKEY_CURSOR_DOWN, "DOWN" },

	{ SKEY_INSERT, SKEY_INSERT, "INS" },
	{ SKEY_DELETE, SKEY_DELETE, "DEL" },
	{ SKEY_HOME, SKEY_HOME, "HOME" },
	{ SKEY_END, SKEY_END, "END" },
	{ SKEY_PAGEUP, SKEY_PAGEUP, "PAGEUP" },
	{ SKEY_PAGEDOWN, SKEY_PAGEDOWN, "PAGEDOWN" },
	{ SKEY_BACKSPACE, SKEY_BACKSPACE, "BACKSPACE" },
	{ SKEY_RETURN, SKEY_RETURN, "RETURN" },
	{ SKEY_TAB, SKEY_TAB, "TAB" },
	{ SKEY_SPACE, SKEY_SPACE, "SPACE" },
	{ SKEY_ESC, SKEY_ESC, "ESC" },

	{ SKEY_F1, SKEY_F1, "F1" },
	{ SKEY_F2, SKEY_F2, "F2" },
	{ SKEY_F3, SKEY_F3, "F3" },
	{ SKEY_F4, SKEY_F4, "F4" },
	{ SKEY_F5, SKEY_F5, "F5" },
	{ SKEY_F6, SKEY_F6, "F6" },
	{ SKEY_F7, SKEY_F7, "F7" },
	{ SKEY_F8, SKEY_F8, "F8" },
	{ SKEY_F9, SKEY_F9, "F9" },
	{ SKEY_F10, SKEY_F10, "F10" },
	{ SKEY_F11, SKEY_F11, "F11" },
	{ SKEY_F12, SKEY_F12, "F12" },

	{ SKEY_LEFT_SHIFT, SKEY_MODIFIER_SHIFT, "SHIFT" },
	{ SKEY_RIGHT_SHIFT, SKEY_MODIFIER_SHIFT, "RSHIFT" },
	{ SKEY_LEFT_CONTROL, SKEY_MODIFIER_CONTROL, "CTRL" },
	{ SKEY_RIGHT_CONTROL, SKEY_MODIFIER_CONTROL, "RCTRL" },
	{ SKEY_LEFT_ALT, SKEY_MODIFIER_ALT, "ALT" },
	{ SKEY_RIGHT_ALT, SKEY_MODIFIER_ALT, "RALT" },

	{ SKEY_LWIN, SKEY_LWIN, "LWIN" },
	{ SKEY_RWIN, SKEY_RWIN, "RWIN" },
	{ SKEY_APPS, SKEY_APPS, "APPS" },

	{ SKEY_CAPSLOCK, SKEY_CAPSLOCK, "CAPSLOCK" },

	{ SKEY_1, SKEY_1, "1" },
	{ SKEY_2, SKEY_2, "2" },
	{ SKEY_3, SKEY_3, "3" },
	{ SKEY_4, SKEY_4, "4" },
	{ SKEY_5, SKEY_5, "5" },
	{ SKEY_6, SKEY_6, "6" },
	{ SKEY_7, SKEY_7, "7" },
	{ SKEY_8, SKEY_8, "8" },
	{ SKEY_9, SKEY_9, "9" },
	{ SKEY_0, SKEY_0, "0" },

	{ SKEY_Q, SKEY_Q, "Q" },
	{ SKEY_W, SKEY_W, "W" },
	{ SKEY_E, SKEY_E, "E" },
	{ SKEY_R, SKEY_R, "R" },
	{ SKEY_T, SKEY_T, "T" },
	{ SKEY_Y, SKEY_Y, "Y" },
	{ SKEY_U, SKEY_U, "U" },
	{ SKEY_I, SKEY_I, "I" },
	{ SKEY_O, SKEY_O, "O" },
	{ SKEY_P, SKEY_P, "P" },

	{ SKEY_A, SKEY_A, "A" },
	{ SKEY_S, SKEY_S, "S" },
	{ SKEY_D, SKEY_D, "D" },
	{ SKEY_F, SKEY_F, "F" },
	{ SKEY_G, SKEY_G, "G" },
	{ SKEY_H, SKEY_H, "H" },
	{ SKEY_J, SKEY_J, "J" },
	{ SKEY_K, SKEY_K, "K" },
	{ SKEY_L, SKEY_L, "L" },

	{ SKEY_Z, SKEY_Z, "Z" },
	{ SKEY_X, SKEY_X, "X" },
	{ SKEY_C, SKEY_C, "C" },
	{ SKEY_V, SKEY_V, "V" },
	{ SKEY_B, SKEY_B, "B" },
	{ SKEY_N, SKEY_N, "N" },
	{ SKEY_M, SKEY_M, "M" },

#ifdef PLATFORM_XBOX1
	{ SKEY_JOY0_AXIS00, SKEY_JOY0_AXIS00, "JOY0_AXIS00" },
	{ SKEY_JOY0_AXIS01, SKEY_JOY0_AXIS01, "JOY0_AXIS01" },
	{ SKEY_JOY0_AXIS02, SKEY_JOY0_AXIS02, "JOY0_AXIS02" },
	{ SKEY_JOY0_AXIS03, SKEY_JOY0_AXIS03, "JOY0_AXIS03" },
	{ SKEY_JOY0_AXIS04, SKEY_JOY0_AXIS04, "JOY0_AXIS04" },
	{ SKEY_JOY0_AXIS05, SKEY_JOY0_AXIS05, "JOY0_AXIS05" },
	{ SKEY_JOY0_AXIS06, SKEY_JOY0_AXIS06, "JOY0_AXIS06" },
	{ SKEY_JOY0_AXIS07, SKEY_JOY0_AXIS07, "JOY0_AXIS07" },
	{ SKEY_JOY0_AXIS08, SKEY_JOY0_AXIS08, "JOY0_AXIS08" },
	{ SKEY_JOY0_AXIS09, SKEY_JOY0_AXIS09, "JOY0_AXIS09" },
	{ SKEY_JOY0_AXIS0A, SKEY_JOY0_AXIS0A, "JOY0_AXIS0A" },
	{ SKEY_JOY0_AXIS0B, SKEY_JOY0_AXIS0B, "JOY0_AXIS0B" },
	{ SKEY_JOY0_AXIS0C, SKEY_JOY0_AXIS0C, "JOY0_AXIS0C" },
	{ SKEY_JOY0_AXIS0D, SKEY_JOY0_AXIS0D, "JOY0_AXIS0D" },
	{ SKEY_JOY0_AXIS0E, SKEY_JOY0_AXIS0E, "JOY0_AXIS0E" },
	{ SKEY_JOY0_AXIS0F, SKEY_JOY0_AXIS0F, "JOY0_AXIS0F" },

	{ SKEY_JOY1_AXIS00, SKEY_JOY1_AXIS00, "JOY1_AXIS00" },
	{ SKEY_JOY1_AXIS01, SKEY_JOY1_AXIS01, "JOY1_AXIS01" },
	{ SKEY_JOY1_AXIS02, SKEY_JOY1_AXIS02, "JOY1_AXIS02" },
	{ SKEY_JOY1_AXIS03, SKEY_JOY1_AXIS03, "JOY1_AXIS03" },
	{ SKEY_JOY1_AXIS04, SKEY_JOY1_AXIS04, "JOY1_AXIS04" },
	{ SKEY_JOY1_AXIS05, SKEY_JOY1_AXIS05, "JOY1_AXIS05" },
	{ SKEY_JOY1_AXIS06, SKEY_JOY1_AXIS06, "JOY1_AXIS06" },
	{ SKEY_JOY1_AXIS07, SKEY_JOY1_AXIS07, "JOY1_AXIS07" },
	{ SKEY_JOY1_AXIS08, SKEY_JOY1_AXIS08, "JOY1_AXIS08" },
	{ SKEY_JOY1_AXIS09, SKEY_JOY1_AXIS09, "JOY1_AXIS09" },
	{ SKEY_JOY1_AXIS0A, SKEY_JOY1_AXIS0A, "JOY1_AXIS0A" },
	{ SKEY_JOY1_AXIS0B, SKEY_JOY1_AXIS0B, "JOY1_AXIS0B" },
	{ SKEY_JOY1_AXIS0C, SKEY_JOY1_AXIS0C, "JOY1_AXIS0C" },
	{ SKEY_JOY1_AXIS0D, SKEY_JOY1_AXIS0D, "JOY1_AXIS0D" },
	{ SKEY_JOY1_AXIS0E, SKEY_JOY1_AXIS0E, "JOY1_AXIS0E" },
	{ SKEY_JOY1_AXIS0F, SKEY_JOY1_AXIS0F, "JOY1_AXIS0F" },

	{ SKEY_JOY2_AXIS00, SKEY_JOY2_AXIS00, "JOY2_AXIS00" },
	{ SKEY_JOY2_AXIS01, SKEY_JOY2_AXIS01, "JOY2_AXIS01" },
	{ SKEY_JOY2_AXIS02, SKEY_JOY2_AXIS02, "JOY2_AXIS02" },
	{ SKEY_JOY2_AXIS03, SKEY_JOY2_AXIS03, "JOY2_AXIS03" },
	{ SKEY_JOY2_AXIS04, SKEY_JOY2_AXIS04, "JOY2_AXIS04" },
	{ SKEY_JOY2_AXIS05, SKEY_JOY2_AXIS05, "JOY2_AXIS05" },
	{ SKEY_JOY2_AXIS06, SKEY_JOY2_AXIS06, "JOY2_AXIS06" },
	{ SKEY_JOY2_AXIS07, SKEY_JOY2_AXIS07, "JOY2_AXIS07" },
	{ SKEY_JOY2_AXIS08, SKEY_JOY2_AXIS08, "JOY2_AXIS08" },
	{ SKEY_JOY2_AXIS09, SKEY_JOY2_AXIS09, "JOY2_AXIS09" },
	{ SKEY_JOY2_AXIS0A, SKEY_JOY2_AXIS0A, "JOY2_AXIS0A" },
	{ SKEY_JOY2_AXIS0B, SKEY_JOY2_AXIS0B, "JOY2_AXIS0B" },
	{ SKEY_JOY2_AXIS0C, SKEY_JOY2_AXIS0C, "JOY2_AXIS0C" },
	{ SKEY_JOY2_AXIS0D, SKEY_JOY2_AXIS0D, "JOY2_AXIS0D" },
	{ SKEY_JOY2_AXIS0E, SKEY_JOY2_AXIS0E, "JOY2_AXIS0E" },
	{ SKEY_JOY2_AXIS0F, SKEY_JOY2_AXIS0F, "JOY2_AXIS0F" },

	{ SKEY_JOY3_AXIS00, SKEY_JOY3_AXIS00, "JOY3_AXIS00" },
	{ SKEY_JOY3_AXIS01, SKEY_JOY3_AXIS01, "JOY3_AXIS01" },
	{ SKEY_JOY3_AXIS02, SKEY_JOY3_AXIS02, "JOY3_AXIS02" },
	{ SKEY_JOY3_AXIS03, SKEY_JOY3_AXIS03, "JOY3_AXIS03" },
	{ SKEY_JOY3_AXIS04, SKEY_JOY3_AXIS04, "JOY3_AXIS04" },
	{ SKEY_JOY3_AXIS05, SKEY_JOY3_AXIS05, "JOY3_AXIS05" },
	{ SKEY_JOY3_AXIS06, SKEY_JOY3_AXIS06, "JOY3_AXIS06" },
	{ SKEY_JOY3_AXIS07, SKEY_JOY3_AXIS07, "JOY3_AXIS07" },
	{ SKEY_JOY3_AXIS08, SKEY_JOY3_AXIS08, "JOY3_AXIS08" },
	{ SKEY_JOY3_AXIS09, SKEY_JOY3_AXIS09, "JOY3_AXIS09" },
	{ SKEY_JOY3_AXIS0A, SKEY_JOY3_AXIS0A, "JOY3_AXIS0A" },
	{ SKEY_JOY3_AXIS0B, SKEY_JOY3_AXIS0B, "JOY3_AXIS0B" },
	{ SKEY_JOY3_AXIS0C, SKEY_JOY3_AXIS0C, "JOY3_AXIS0C" },
	{ SKEY_JOY3_AXIS0D, SKEY_JOY3_AXIS0D, "JOY3_AXIS0D" },
	{ SKEY_JOY3_AXIS0E, SKEY_JOY3_AXIS0E, "JOY3_AXIS0E" },
	{ SKEY_JOY3_AXIS0F, SKEY_JOY3_AXIS0F, "JOY3_AXIS0F" },
#else
	{ SKEY_JOY_AXIS00_POS, SKEY_JOY_AXIS00_POS, "JOY_AXIS_POS_00" },
	{ SKEY_JOY_AXIS00_NEG, SKEY_JOY_AXIS00_NEG, "JOY_AXIS_NEG_00" },
	{ SKEY_JOY_AXIS01_POS, SKEY_JOY_AXIS01_POS, "JOY_AXIS_POS_01" },
	{ SKEY_JOY_AXIS01_NEG, SKEY_JOY_AXIS01_NEG, "JOY_AXIS_NEG_01" },
	{ SKEY_JOY_AXIS02_POS, SKEY_JOY_AXIS02_POS, "JOY_AXIS_POS_02" },
	{ SKEY_JOY_AXIS02_NEG, SKEY_JOY_AXIS02_NEG, "JOY_AXIS_NEG_02" },
	{ SKEY_JOY_AXIS03_POS, SKEY_JOY_AXIS03_POS, "JOY_AXIS_POS_03" },
	{ SKEY_JOY_AXIS03_NEG, SKEY_JOY_AXIS03_NEG, "JOY_AXIS_NEG_03" },
	{ SKEY_JOY_AXIS04_POS, SKEY_JOY_AXIS04_POS, "JOY_AXIS_POS_04" },
	{ SKEY_JOY_AXIS04_NEG, SKEY_JOY_AXIS04_NEG, "JOY_AXIS_NEG_04" },
	{ SKEY_JOY_AXIS05_POS, SKEY_JOY_AXIS05_POS, "JOY_AXIS_POS_05" },
	{ SKEY_JOY_AXIS05_NEG, SKEY_JOY_AXIS05_NEG, "JOY_AXIS_NEG_05" },
	{ SKEY_JOY_AXIS06_POS, SKEY_JOY_AXIS06_POS, "JOY_AXIS_POS_06" },
	{ SKEY_JOY_AXIS06_NEG, SKEY_JOY_AXIS06_NEG, "JOY_AXIS_NEG_06" },
	{ SKEY_JOY_AXIS07_POS, SKEY_JOY_AXIS07_POS, "JOY_AXIS_POS_07" },
	{ SKEY_JOY_AXIS07_NEG, SKEY_JOY_AXIS07_NEG, "JOY_AXIS_NEG_07" },
	{ SKEY_JOY_AXIS08_POS, SKEY_JOY_AXIS08_POS, "JOY_AXIS_POS_08" },
	{ SKEY_JOY_AXIS08_NEG, SKEY_JOY_AXIS08_NEG, "JOY_AXIS_NEG_08" },
	{ SKEY_JOY_AXIS09_POS, SKEY_JOY_AXIS09_POS, "JOY_AXIS_POS_09" },
	{ SKEY_JOY_AXIS09_NEG, SKEY_JOY_AXIS09_NEG, "JOY_AXIS_NEG_09" },
	{ SKEY_JOY_AXIS0A_POS, SKEY_JOY_AXIS0A_POS, "JOY_AXIS_POS_0A" },
	{ SKEY_JOY_AXIS0A_NEG, SKEY_JOY_AXIS0A_NEG, "JOY_AXIS_NEG_0A" },
	{ SKEY_JOY_AXIS0B_POS, SKEY_JOY_AXIS0B_POS, "JOY_AXIS_POS_0B" },
	{ SKEY_JOY_AXIS0B_NEG, SKEY_JOY_AXIS0B_NEG, "JOY_AXIS_NEG_0B" },
	{ SKEY_JOY_AXIS0C_POS, SKEY_JOY_AXIS0C_POS, "JOY_AXIS_POS_0C" },
	{ SKEY_JOY_AXIS0C_NEG, SKEY_JOY_AXIS0C_NEG, "JOY_AXIS_NEG_0C" },
	{ SKEY_JOY_AXIS0D_POS, SKEY_JOY_AXIS0D_POS, "JOY_AXIS_POS_0D" },
	{ SKEY_JOY_AXIS0D_NEG, SKEY_JOY_AXIS0D_NEG, "JOY_AXIS_NEG_0D" },
	{ SKEY_JOY_AXIS0E_POS, SKEY_JOY_AXIS0E_POS, "JOY_AXIS_POS_0E" },
	{ SKEY_JOY_AXIS0E_NEG, SKEY_JOY_AXIS0E_NEG, "JOY_AXIS_NEG_0E" },
	{ SKEY_JOY_AXIS0F_POS, SKEY_JOY_AXIS0F_POS, "JOY_AXIS_POS_0F" },
	{ SKEY_JOY_AXIS0F_NEG, SKEY_JOY_AXIS0F_NEG, "JOY_AXIS_NEG_0F" },

	{ SKEY_JOY_BUTTON00, SKEY_JOY_BUTTON00, "JOY_BUTTON_00" },
	{ SKEY_JOY_BUTTON01, SKEY_JOY_BUTTON01, "JOY_BUTTON_01" },
	{ SKEY_JOY_BUTTON02, SKEY_JOY_BUTTON02, "JOY_BUTTON_02" },
	{ SKEY_JOY_BUTTON03, SKEY_JOY_BUTTON03, "JOY_BUTTON_03" },
	{ SKEY_JOY_BUTTON04, SKEY_JOY_BUTTON04, "JOY_BUTTON_04" },
	{ SKEY_JOY_BUTTON05, SKEY_JOY_BUTTON05, "JOY_BUTTON_05" },
	{ SKEY_JOY_BUTTON06, SKEY_JOY_BUTTON06, "JOY_BUTTON_06" },
	{ SKEY_JOY_BUTTON07, SKEY_JOY_BUTTON07, "JOY_BUTTON_07" },
	{ SKEY_JOY_BUTTON08, SKEY_JOY_BUTTON08, "JOY_BUTTON_08" },
	{ SKEY_JOY_BUTTON09, SKEY_JOY_BUTTON09, "JOY_BUTTON_09" },
	{ SKEY_JOY_BUTTON0A, SKEY_JOY_BUTTON0A, "JOY_BUTTON_0A" },
	{ SKEY_JOY_BUTTON0B, SKEY_JOY_BUTTON0B, "JOY_BUTTON_0B" },
	{ SKEY_JOY_BUTTON0C, SKEY_JOY_BUTTON0C, "JOY_BUTTON_0C" },
	{ SKEY_JOY_BUTTON0D, SKEY_JOY_BUTTON0D, "JOY_BUTTON_0D" },
	{ SKEY_JOY_BUTTON0E, SKEY_JOY_BUTTON0E, "JOY_BUTTON_0E" },
	{ SKEY_JOY_BUTTON0F, SKEY_JOY_BUTTON0F, "JOY_BUTTON_0F" },

	{ SKEY_JOY_POV00, SKEY_JOY_POV00, "JOY_POV_00" },
	{ SKEY_JOY_POV01, SKEY_JOY_POV01, "JOY_POV_01" },
	{ SKEY_JOY_POV02, SKEY_JOY_POV02, "JOY_POV_02" },
	{ SKEY_JOY_POV03, SKEY_JOY_POV03, "JOY_POV_03" },
	{ SKEY_JOY_POV04, SKEY_JOY_POV04, "JOY_POV_04" },
	{ SKEY_JOY_POV05, SKEY_JOY_POV05, "JOY_POV_05" },
	{ SKEY_JOY_POV06, SKEY_JOY_POV06, "JOY_POV_06" },
	{ SKEY_JOY_POV07, SKEY_JOY_POV07, "JOY_POV_07" },
	{ SKEY_JOY_POV08, SKEY_JOY_POV08, "JOY_POV_08" },
	{ SKEY_JOY_POV09, SKEY_JOY_POV09, "JOY_POV_09" },
	{ SKEY_JOY_POV0A, SKEY_JOY_POV0A, "JOY_POV_0A" },
	{ SKEY_JOY_POV0B, SKEY_JOY_POV0B, "JOY_POV_0B" },
	{ SKEY_JOY_POV0C, SKEY_JOY_POV0C, "JOY_POV_0C" },
	{ SKEY_JOY_POV0D, SKEY_JOY_POV0D, "JOY_POV_0D" },
	{ SKEY_JOY_POV0E, SKEY_JOY_POV0E, "JOY_POV_0E" },
	{ SKEY_JOY_POV0F, SKEY_JOY_POV0F, "JOY_POV_0F" },
#endif

	{ SKEY_MOUSE1, SKEY_MOUSE1, "MOUSE1" },
	{ SKEY_MOUSE2, SKEY_MOUSE2, "MOUSE2" },
	{ SKEY_MOUSE3, SKEY_MOUSE3, "MOUSE3" },
	{ SKEY_MOUSE4, SKEY_MOUSE4, "MOUSE4" },
	{ SKEY_MOUSE4, SKEY_MOUSE5, "MOUSE5" },
	{ SKEY_MOUSE4, SKEY_MOUSE6, "MOUSE6" },
	{ SKEY_MOUSE4, SKEY_MOUSE7, "MOUSE7" },
	{ SKEY_MOUSE4, SKEY_MOUSE8, "MOUSE8" },
	{ SKEY_MOUSEWHEELUP, SKEY_MOUSEWHEELUP, "MOUSEWHEELUP" },
	{ SKEY_MOUSEWHEELDOWN, SKEY_MOUSEWHEELDOWN, "MOUSEWHEELDOWN" },
	{ SKEY_MOUSEMOVE, SKEY_MOUSEMOVE, "MOUSE" },
	{ SKEY_MOUSEMOVEREL, SKEY_MOUSEMOVEREL, "MOUSEMOVE" },
	
	{ SKEY_GUI_UP, SKEY_GUI_UP, "GUI_UP" },
	{ SKEY_GUI_DOWN, SKEY_GUI_DOWN, "GUI_DOWN" },
	{ SKEY_GUI_LEFT, SKEY_GUI_LEFT, "GUI_LEFT" },
	{ SKEY_GUI_RIGHT, SKEY_GUI_RIGHT, "GUI_RIGHT" },
	{ SKEY_GUI_OK, SKEY_GUI_OK, "GUI_OK" },
	{ SKEY_GUI_CANCEL, SKEY_GUI_CANCEL, "GUI_CANCEL" },
	{ SKEY_GUI_START, SKEY_GUI_START, "GUI_START" },
	{ SKEY_GUI_BACK, SKEY_GUI_BACK, "GUI_BACK" },
	{ SKEY_GUI_BUTTON0, SKEY_GUI_BUTTON0, "GUI_BUTTON0" },
	{ SKEY_GUI_BUTTON1, SKEY_GUI_BUTTON1, "GUI_BUTTON1" },
	{ SKEY_GUI_BUTTON2, SKEY_GUI_BUTTON2, "GUI_BUTTON2" },
	{ SKEY_GUI_BUTTON3, SKEY_GUI_BUTTON3, "GUI_BUTTON3" },
	{ SKEY_GUI_BUTTON4, SKEY_GUI_BUTTON4, "GUI_BUTTON4" },
	{ SKEY_GUI_BUTTON5, SKEY_GUI_BUTTON5, "GUI_BUTTON5" },

	// Numpad

	{ 0x52, 0x52, "NUM-0" },
	{ 0x4f, 0x4f, "NUM-1" },
	{ 0x50, 0x50, "NUM-2" },
	{ 0x51, 0x51, "NUM-3" },
	{ 0x4b, 0x4b, "NUM-4" },
	{ 0x4c, 0x4c, "NUM-5" },
	{ 0x4d, 0x4d, "NUM-6" },
	{ 0x47, 0x47, "NUM-7" },
	{ 0x48, 0x48, "NUM-8" },
	{ 0x49, 0x49, "NUM-9" },

	{ 0x145, 0x145, "NUMLOCK" },
	{ 0x135, 0x135, "NUM-SLASH" },
	{ 0x37, 0x37, "NUM-MULT" },
	{ 0x4a, 0x4a, "NUM-MINUS" },
	{ 0x4e, 0x4e, "NUM-ADD" },
	{ 0x11c, 0x11c, "NUM-ENTER" },
	{ 0x53, 0x53, "NUM-POINT" },

	//
	{ 0x0c, 0x0c, "MINUS" },
	{ 0x0d, 0x0d, "EQUAL" },

	{ 0x1a, 0x1a, "LBRACKET" },
	{ 0x1b, 0x1b, "RBRACKET" },

	{ 0x27, 0x27, "SEMICOLON" },
	{ 0x28, 0x28, "APOSTROPHE" },
	{ 0x2b, 0x2b, "BACKSLASH"},

	{ 0x33, 0x33, "COMMA" },
	{ 0x34, 0x34, "POINT" },
	{ 0x35, 0x35, "SLASH"},

	{ 0x56, 0x56, "EXTENDED"},

	{ 0x137, 0x137, "PRTSCN"},
	{ 0x46, 0x46, "SCRLOCK"},
	{ 0x45, 0x45, "PAUSE"},

	{ 0x16a, 0x16a, "I-BACK"},
	{ 0x169, 0x169, "I-FORWARD"},
	{ 0x168, 0x168, "I-STOP"},
	{ 0x167, 0x167, "I-REFRESH"},
	{ 0x165, 0x165, "I-SEARCH"},
	{ 0x166, 0x166, "I-FAVORITES"},
	{ 0x132, 0x132, "I-HOME"},
	{ 0x16c, 0x16c, "I-MAIL"},
	{ 0x120, 0x120, "M-MUTE"},
	{ 0x12e, 0x12e, "M-VOLUP"},
	{ 0x130, 0x130, "M-VOLDOWN"},
	{ 0x122, 0x122, "M-PLAY"},
	{ 0x124, 0x124, "M-STOP"},
	{ 0x110, 0x110, "M-PREV"},
	{ 0x119, 0x119, "M-NEXT"},
	{ 0x16d, 0x16d, "M-MEDIA"},
	{ 0x16b, 0x16b, "A-MYCOMP"},
	{ 0x121, 0x121, "A-CALC"},

	//
};


bool CScanKey::IsASCII() const
{
	return m_Char >= 32;

//	return ((m_Char >= 32) && (m_Char < 0x3a)) || ((m_Char >= 96) && (m_Char < 127));
};

char CScanKey::GetASCII() const
{
//	if (!IsDown()) return 0;
	return m_Char;
};

int CScanKey::GetScanCode(CStr _s)
{
	int nCodes = sizeof(ms_ScanCodeNames) / sizeof(CScanCodeName);
	for(int i = 0; i < nCodes; i++)
	{
		if (_s.CompareNoCase(ms_ScanCodeNames[i].m_pName) == 0) return ms_ScanCodeNames[i].m_ScanCode;
	}
	if (_s[0] == '#')
	{
		CStr NewStr;
		NewStr.Capture(_s.Str() + 1);
		return NewStr.Val_int();
	}
	return 0;
}

int CScanKey::GetScanKey32(CStr _s)
{
	int nCodes = sizeof(ms_ScanCodeNames) / sizeof(CScanCodeName);
	for(int i = 0; i < nCodes; i++)
	{
		if (_s.CompareNoCase(ms_ScanCodeNames[i].m_pName) == 0) return ms_ScanCodeNames[i].m_ScanKey32;
	}
	return 0;
}

int CScanKey::GetScanKey32Comb(CStr _s)
{
	int ScanKey = 0;
	while(_s.Len())
	{
		ScanKey += GetScanKey32(_s.GetStrSep("+"));
	}
	return ScanKey;
}

CStr CScanKey::GetScanCodeName(int _Scan)
{
	int nCodes = sizeof(ms_ScanCodeNames) / sizeof(CScanCodeName);
	for(int i = 0; i < nCodes; i++)
	{
		if (ms_ScanCodeNames[i].m_ScanCode == _Scan) return ms_ScanCodeNames[i].m_pName;
	}
	return CStrF("#%d",_Scan);
}

CStr CScanKey::GetScanKey32Name(int _ScanKey)
{
	int nCodes = sizeof(ms_ScanCodeNames) / sizeof(CScanCodeName);
	for(int i = 0; i < nCodes; i++)
	{
		if (ms_ScanCodeNames[i].m_ScanKey32 == _ScanKey) return ms_ScanCodeNames[i].m_pName;
	}
	return "";
}
#ifdef PLATFORM_WIN_PC
#include "windows.h"
#endif

CStr CScanKey::GetLocalizedKeyName(int _ScanKey)
{
#ifdef PLATFORM_WIN_PC

	if (_ScanKey >= 0 && _ScanKey < 128)// || _ScanKey >= 256 && _ScanKey <= (256+128))
	{
		int ScanKey = _ScanKey;
		int bExtended = ScanKey > 255;
		if (ScanKey > 256)
			ScanKey -= 256;

		wchar String[256];
		String[0] = 0;

		if (bExtended)
		{
			if (GetKeyNameTextW(ScanKey << 16 | 1 | bExtended<< 24, (LPWSTR)String, 256))
			{
				if (String[0] && String[0] < 256)
					return String;
				else
					return GetScanCodeName(_ScanKey);
			}
/*			else if (GetKeyNameTextW((ScanKey + 256) << 16 | 1 | bExtended<< 24, String, 256))
			{
				return String;
			}
			else if (GetKeyNameTextW((ScanKey + 256) << 16 | 1, String, 256))
			{
				return String;
			}
			else if (GetKeyNameTextW(ScanKey << 16 | 1, String, 256))
			{
				return String;
			}*/
		}
		else
		{
			if (GetKeyNameTextW(ScanKey << 16 | 1, (LPWSTR)String, 256))
			{
				if (String[0] && String[0] < 256)
					return String;
				else
					return GetScanCodeName(_ScanKey);
			}
		}
	}

#endif

	return GetScanCodeName(_ScanKey);
}
 

/*
CScanCodeName* CScanKey::GetScanCodeNames()
{
	return ms_ScanCodeNames;
}

int CScanKey::GetNumScanCodeNames()
{
	return sizeof(ms_ScanCodeNames) / sizeof(CScanCodeName);
}

*/

