#include "PCH.h"

#include "MRenderPS3_Image.h"

// -------------------------------------------------------------------
//  OpenGL Help Macros
// -------------------------------------------------------------------
//#define MACRO_GLCOLOR_PIXEL32(col) glnColor3ub(col.GetR(), col.GetG(), col.GetB())
//#define MACRO_GLCOLOR_INT(color) glnColor3ub((color >> 16) & 0xff, (color >> 8) & 0xff, color & 0xff)
#define MACRO_GLCOLOR_PIXEL32(col) glnColor3f((fp4)col.GetR()/255.0, (fp4)col.GetG()/255.0, (fp4)col.GetB()/255.0)
#define MACRO_GLCOLOR_INT(color) glnColor3f(((color >> 16) & 0xff)/255.0, ((color >> 8) & 0xff)/255.0, (color & 0xff)/255.0)

// -------------------------------------------------------------------
//  OpenGL Image
// -------------------------------------------------------------------
void* CImagePS3::__Lock(int ExtLockMode)
{
	Error("__Lock", "OGL Images cannot be locked.");
	return NULL;
};

void CImagePS3::__Unlock()
{
};

// Construction & Destruction
CImagePS3::CImagePS3()
{
};

CImagePS3::~CImagePS3()
{
	Destroy();
};

void CImagePS3::Destroy()
{
	m_Width = 0;
	m_Height = 0;
	m_Format = 0;
	m_Memmodel = 0;
	m_spPalette = NULL;
	UpdateFormat();
};

void CImagePS3::Create(int _w, int _h, int _format, int _memmodel, spCImagePalette _spPalette)
{
	m_Width = _w;
	m_Height = _h;
	m_Format = _format;
	m_Memmodel = _memmodel;
	m_spPalette = _spPalette;
	UpdateFormat();
};

void CImagePS3::GetRAWData(CPnt pos, int bytecount, uint8* _pData)
{
	if (pos.x >= m_Width) return;
	if (pos.y >= m_Height) return;
	if (pos.x < 0) return;
	if (pos.y < 0) return;
//	FillChar(_pData, bytecount, 0xff);
	bytecount /= m_Pixelsize;
//	glnReadBuffer(GL_FRONT);
//	GLErr("GetRawData");
	glnReadPixels(pos.x, (m_Height-pos.y-1), bytecount, 1, GL_ABGR, GL_UNSIGNED_BYTE, _pData);

	GLErr("GetRawData");
}


uint8 CImagePS3::DebugFont[128][8] = 
{
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},{0x80,0x80,0x80,0x80,0x00,0x80,0x00,0x00},
    {0xA0,0xA0,0x00,0x00,0x00,0x00,0x00,0x00},{0x50,0xF8,0x50,0x50,0xF8,0x50,0x00,0x00},
    {0x78,0xA0,0x70,0x28,0x28,0xF0,0x00,0x00},{0x00,0x90,0x20,0x40,0x90,0x00,0x00,0x00},
    {0x60,0x50,0x20,0x54,0x88,0x74,0x00,0x00},{0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x40,0x80,0x80,0x80,0x80,0x40,0x00,0x00},{0x80,0x40,0x40,0x40,0x40,0x80,0x00,0x00},
    {0x00,0x00,0xA0,0x40,0xA0,0x00,0x00,0x00},{0x00,0x00,0x40,0xE0,0x40,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x40,0x80,0x00},{0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00},{0x04,0x08,0x10,0x20,0x40,0x80,0x00,0x00},
    {0x60,0x90,0x90,0x90,0x90,0x60,0x00,0x00},{0x40,0xC0,0x40,0x40,0x40,0xE0,0x00,0x00},
    {0x60,0x90,0x20,0x40,0x80,0xF0,0x00,0x00},{0xE0,0x10,0x70,0x10,0x10,0xE0,0x00,0x00},
    {0x90,0x90,0xF0,0x10,0x10,0x10,0x00,0x00},{0xF0,0x80,0xE0,0x10,0x10,0xE0,0x00,0x00},
    {0x70,0x80,0xE0,0x90,0x90,0x60,0x00,0x00},{0xF0,0x10,0x60,0x20,0x40,0x40,0x00,0x00},
    {0x60,0x90,0x60,0x90,0x90,0x60,0x00,0x00},{0x70,0x90,0x70,0x10,0x10,0xE0,0x00,0x00},
    {0x00,0x00,0x80,0x00,0x80,0x00,0x00,0x00},{0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00},
    {0x00,0x20,0x40,0x80,0x40,0x20,0x00,0x00},{0x00,0x00,0xF0,0x00,0xF0,0x00,0x00,0x00},
    {0x00,0x80,0x40,0x20,0x40,0x80,0x00,0x00},{0xE0,0x10,0x20,0x40,0x00,0x40,0x00,0x00},
    {0x60,0x90,0xB0,0xB0,0x80,0x70,0x00,0x00},{0x60,0x90,0xF0,0x90,0x90,0x90,0x00,0x00},
    {0xE0,0x90,0xE0,0x90,0x90,0xE0,0x00,0x00},{0x70,0x80,0x80,0x80,0x80,0x70,0x00,0x00},
    {0xE0,0x90,0x90,0x90,0x90,0xE0,0x00,0x00},{0xF0,0x80,0xE0,0x80,0x80,0xF0,0x00,0x00},
    {0xF0,0x80,0xE0,0x80,0x80,0x80,0x00,0x00},{0x70,0x80,0xB0,0x90,0x90,0x60,0x00,0x00},
    {0x90,0x90,0xF0,0x90,0x90,0x90,0x00,0x00},{0xE0,0x40,0x40,0x40,0x40,0xE0,0x00,0x00},
    {0x70,0x10,0x10,0x10,0x10,0xE0,0x00,0x00},{0x90,0x90,0xE0,0x90,0x90,0x90,0x00,0x00},
    {0x80,0x80,0x80,0x80,0x80,0xF0,0x00,0x00},{0x88,0xD8,0xA8,0x88,0x88,0x88,0x00,0x00},
    {0x90,0xD0,0xB0,0x90,0x90,0x90,0x00,0x00},{0x60,0x90,0x90,0x90,0x90,0x60,0x00,0x00},
    {0xE0,0x90,0x90,0xE0,0x80,0x80,0x00,0x00},{0x60,0x90,0x90,0x90,0x80,0x70,0x00,0x00},
    {0xE0,0x90,0x90,0xE0,0x90,0x90,0x00,0x00},{0x70,0x80,0x60,0x10,0x10,0xE0,0x00,0x00},
    {0xF8,0x20,0x20,0x20,0x20,0x20,0x00,0x00},{0x90,0x90,0x90,0x90,0x90,0x60,0x00,0x00},
    {0x90,0x90,0x90,0x90,0x50,0x20,0x00,0x00},{0x88,0x88,0x88,0xA8,0xD8,0x88,0x00,0x00},
    {0x88,0x50,0x20,0x50,0x88,0x88,0x00,0x00},{0x90,0x90,0x70,0x10,0x10,0xE0,0x00,0x00},
    {0xF0,0x10,0x60,0x80,0x80,0xF0,0x00,0x00},{0xC0,0x80,0x80,0x80,0x80,0xC0,0x00,0x00},
    {0x80,0xC0,0x60,0x30,0x18,0x08,0x00,0x00},{0xC0,0x40,0x40,0x40,0x40,0xC0,0x00,0x00},
    {0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00},
    {0x80,0x40,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x60,0x90,0x90,0x70,0x00,0x00},
    {0x80,0x80,0xE0,0x90,0x90,0xE0,0x00,0x00},{0x00,0x00,0x70,0x80,0x80,0x70,0x00,0x00},
    {0x10,0x10,0x70,0x90,0x90,0x70,0x00,0x00},{0x00,0x00,0x60,0xF0,0x80,0x70,0x00,0x00},
    {0x20,0x40,0xE0,0x40,0x40,0x40,0x00,0x00},{0x00,0x00,0x70,0x90,0x90,0x70,0x10,0xE0},
    {0x80,0x80,0xE0,0x90,0x90,0x90,0x00,0x00},{0x80,0x00,0x80,0x80,0x80,0x80,0x00,0x00},
    {0x40,0x00,0x40,0x40,0x40,0x40,0x40,0x80},{0x80,0x80,0xA0,0xC0,0xA0,0x90,0x00,0x00},
    {0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00},{0x00,0x00,0xD0,0xA8,0xA8,0xA8,0x00,0x00},
    {0x00,0x00,0xE0,0x90,0x90,0x90,0x00,0x00},{0x00,0x00,0x60,0x90,0x90,0x60,0x00,0x00},
    {0x00,0x00,0xE0,0x90,0x90,0xE0,0x80,0x80},{0x00,0x00,0x70,0x90,0x90,0x70,0x10,0x10},
    {0x00,0x00,0xB0,0xC0,0x80,0x80,0x00,0x00},{0x00,0x00,0x70,0xE0,0x10,0xF0,0x00,0x00},
    {0x00,0x40,0xE0,0x40,0x40,0x20,0x00,0x00},{0x00,0x00,0x90,0x90,0x90,0x70,0x00,0x00},
    {0x00,0x00,0x90,0x90,0x50,0x20,0x00,0x00},{0x00,0x00,0xA8,0xA8,0xA8,0x58,0x00,0x00},
    {0x00,0x00,0x90,0x60,0x90,0x90,0x00,0x00},{0x00,0x00,0x90,0x90,0x90,0x70,0x10,0xE0},
    {0x00,0x00,0xF0,0x20,0x40,0xF0,0x00,0x00},{0x60,0x40,0xC0,0x40,0x40,0x60,0x00,0x00},
    {0x00,0x80,0x80,0x00,0x80,0x80,0x00,0x00},{0xC0,0x40,0x60,0x40,0x40,0xC0,0x00,0x00},
    {0x50,0xA0,0x00,0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x60,0x90,0x90,0xF0,0x00,0x00}
};

uint8 CImagePS3::DebugFontWidth[128] = 
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    0x03,0x02,0x04,0x06,0x06,0x05,0x07,0x02,0x03,0x03,0x04,0x04,0x03,0x04,0x02,0x07,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x02,0x02,0x04,0x05,0x04,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x04,0x05,0x05,0x05,0x06,0x05,0x05,
    0x05,0x05,0x05,0x05,0x06,0x05,0x05,0x06,0x06,0x05,0x05,0x03,0x06,0x03,0x06,0x05,
    0x03,0x05,0x05,0x05,0x05,0x05,0x04,0x05,0x05,0x02,0x03,0x05,0x02,0x06,0x05,0x05,
    0x05,0x05,0x05,0x05,0x04,0x05,0x05,0x06,0x05,0x05,0x05,0x04,0x02,0x04,0x05,0x05,
};






