#ifndef __TICAMERA_H__
#define __TICAMERA_H__
/******************************************************************

  Module: TiCamera.h

  Author: Bijan Forutanpour

  Description:   Game camera.

  NOTES: Camera impelementations
     a) stationary camera
     b) stationary panning camera, following player
     c) stationary panning camera, lookat player  (and follow at
        fixed distance)
     d) fixed angle player camera
     e) fixed angle player camera - keyframe animated offset
     f) keyframe animated

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*******************************************************************/
#include <SyTypes.h>
#include <SyBBox.h>
#include <SyCameraAnim.h>
#include <SyCurve.h>
#include <SyObjFile.h>
#include <SyTime.h>

/*
 * Our camera - the regular SyCamera doesn't have a 
 * center of interest point attribute. May merge in 
 * future.
 */
class TiCamera : public SyCameraAnim
{
public:
    int32     mCamType;
    int32     mCamTransition;
    SyVect3   mInterest;
    float32   mZoneClock;

    // for player-relative "playercam"s
    SyCurve   mPlayerOffsetX, mPlayerOffsetY, mPlayerOffsetZ;
    SyCurve   mPlayerOffsetInterestX, mPlayerOffsetInterestY, mPlayerOffsetInterestZ;

    // for "lookat" cam (if following)
    int32     mUseMinMax;
    float32   mMinDist;
    float32   mMaxDist;

    // misc info
    int32    mUseRail, mPlayOnce, mAnimPlayed, mRangeMarker;

 public:
    TiCamera ();
    ~TiCamera (){}

		// frame based
    void GetOffsetPos (float fFrame, SyVect3* result);
    void GetOffsetInterest (float fFrame, SyVect3* result);
    // time based
    void GetOffsetPos (SyTime animTime, SyVect3* result);
    void GetOffsetInterest (SyTime animTime, SyVect3* result);
};

#endif
