#ifndef NETWORKMANAGER_H
#define NETWORKMANAGER_H

#include "PeeringNetwork/PeeringServerApi.h"
#include "PeeringNetwork/ObjectManager.h"

class NetworkManager;
class Titan;

enum AppPacketType 
{ 
    cAppPacketNone
    , cAppPacketObjectManager       // packet that should be routed to ObjectManager for processing
};

class NetworkManager : public PeeringNetwork::PeeringServerHandler, public PeeringNetwork::ObjectHandler
{
    public:
        NetworkManager(Titan *titan);
        virtual ~NetworkManager();
        void GiveTime();
        void Connect(const char *address, const char *name, const char *password);

            // PeeringServerHandler functions
        virtual void OnTerminated(PeeringNetwork::PeeringServerApi *api);
        virtual void OnAuthenticated(PeeringNetwork::PeeringServerApi *api);
        virtual void OnGameListArrived(PeeringNetwork::PeeringServerApi *api);
        virtual void OnGameJoined(PeeringNetwork::PeeringServerApi *api);       // called in response to a create or join game request
        virtual void OnPeerAdded(PeeringNetwork::PeeringServerApi *api, int peerId);
        virtual void OnPeerRemoved(PeeringNetwork::PeeringServerApi *api, int peerId);
        virtual void OnPeerReady(PeeringNetwork::PeeringServerApi *api, int peerId);
        virtual void OnClusterReady(PeeringNetwork::PeeringServerApi *api);
        virtual void OnRoutePacket(PeeringNetwork::PeeringServerApi *api, int fromPeerId, int applicationType, const char *data, int dataLen);

            // ObjectHandler functions
        virtual void OnObjectCreate(PeeringNetwork::ObjectManager *manager, int typeId, int objectId, const char *fullState, int fullStateLen);
        virtual void OnObjectReset(PeeringNetwork::ObjectManager *manager, int objectId, const char *fullState, int fullStateLen);
        virtual void OnObjectDestroy(PeeringNetwork::ObjectManager *manager, int objectId);
        virtual void OnObjectMessage(PeeringNetwork::ObjectManager *manager, int objectId, const char *data, int dataLen);
        virtual void OnObjectTakeOwnership(PeeringNetwork::ObjectManager *manager, int objectId);
        virtual int OnObjectGetState(PeeringNetwork::ObjectManager *manager, int objectId, char *stateBuffer, int stateBufferLen);
        virtual void OnPeerSend(PeeringNetwork::ObjectManager *manager, int peerId, const char *data, int dataLen);

    protected:
        Titan *m_pTitan;
        PeeringNetwork::ObjectManager *m_objectManager;
        PeeringNetwork::PeeringServerApi *m_peeringApi;
};


#endif