/******************************************************************
  
  Module:  TitanFXScriptDriver.cpp
  
  Author: Bijan Forutanpour
  
  Description: Application specific hooks into the FXScript system.

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#include "TitanFXScriptDriver.h"
#include "cameracontroller.h"
#include "registry.h"
#include "animcontroller.h"
#include "graphic.h"
#include "SyCSprite.h"
#include "SyScene.h"

/**********************************************************
 * Constructor
 **********************************************************/
TitanFXScriptDriver::TitanFXScriptDriver(Titan *titan) :
  mTitan(titan)
{
  mCutSceneRunning = false;
  Init (*(titan->GetScene()));
  return;
}

/**********************************************************
 * Destructor
 **********************************************************/
TitanFXScriptDriver::~TitanFXScriptDriver()
{
  return;
}

/**********************************************************
 * SetCamera - communicate back to the application that there
 * is a camera they should use.
 **********************************************************/
int TitanFXScriptDriver::SetCamera ( const SyVect3& Loc, const SyVect3& Dir, const float32& Fov )
{
  cCameraController* titanCameraController = mTitan->GetCameraController();
  titanCameraController->OverrideCamera (Loc, Dir, Fov);
  return 0;
}


/**********************************************************
 * PlayAnimByHandle
 **********************************************************/
int32 TitanFXScriptDriver::PlayAnimByHandle( SyActorHandle ActorHandle, int32 AnimHandle )
{
  cGameObjectRegistry* gameRegistry = mTitan->GetRegistry();
  cGameObject* gameObject = gameRegistry->FetchByActorHandle (ActorHandle);
  cGraphicCharacter* gameGraphicCharacter = prop_cast<cGraphicCharacter*>(gameObject->GetGraphic());
  cAnimCharControllerInput* animController = gameGraphicCharacter->GetAnimInput();
  animController->mAnimationOverride = AnimHandle;
  ((cPhysicsAnimated*)gameObject->GetPhysics ())->SetLocomotion (cPhysics::LOCO_CUTSCENE);
  return 0;
}



/**********************************************************
 * PlayAnimByHandle
 **********************************************************/
void  TitanFXScriptDriver::PlayAnimByHandleComplete(  SyActorHandle ActorHandle )
{
  cGameObjectRegistry* gameRegistry = mTitan->GetRegistry();
  cGameObject* gameObject = gameRegistry->FetchByActorHandle (ActorHandle);

  cGraphicCharacter *gameGraphicCharacter = prop_cast<cGraphicCharacter*>(gameObject->GetGraphic());
  SyAssert(gameGraphicCharacter);
  cAnimCharControllerInput* animController = gameGraphicCharacter->GetAnimInput ();
  SyAssert(animController);
  animController->mOverrideCancelEnd = true;
  EndCutScene();
}



/**********************************************************
 * PlayCameraAnimEnd - tell the world we're ending a camera
 * animation (e.g., a cut scene)
 **********************************************************/
int TitanFXScriptDriver::PlayCameraAnimComplete ()
{
  /*
   * Tell the camera controller
   */
  cCameraController* titanCameraController = mTitan->GetCameraController();
  titanCameraController->ClearOverrideCamera();
  return 0;
}

  
/**********************************************************
 * BeginCutScene - tell the world we're beginning a cut scene
 **********************************************************/ 
void TitanFXScriptDriver::BeginCutScene()
{
  mCutSceneRunning = true;
}

/**********************************************************
 * EndCutScene - tell the world we're ending a cut scene
 **********************************************************/ 
void TitanFXScriptDriver::EndCutScene()
{
  mCutSceneRunning = false;
}

/**********************************************************
 * As whether we're running a cut scene
 **********************************************************/ 
bool TitanFXScriptDriver::isCutScenePlaying()
{
  return mCutSceneRunning;
}

