#include "TitanInputHandler.h"
#include "SyAssert.h"
#include "SyDebug.h"
#include "SyScene.h"
#include "gameobj.h"
#include "animcontroller.h"
#include "graphic.h"
#include "intel.h"
#include "tuning.h"
#include "titan.h"

TitanInputHandler::TitanInputHandler( TitanUII* titanUI, cGameObject *obj ):
mpTitanUI( titanUI ),
mpObject(obj)
{
}

void TitanInputHandler::OnButtonDown( TitanButton tb )
{
  TitanControllerI* controller = mpTitanUI->GetController(0);
  SyDebug( "TitanInputHandler::OnButtonDown %i (%i,%i)\n", tb, controller->GetForward(), controller->GetRight() );

  cGraphicCharacter *graphic = prop_cast<cGraphicCharacter*>(mpObject->GetGraphic());
  SyAssert(graphic);
  cAnimCharControllerInput *input = graphic->GetAnimInput();

  static int once = true;

  if (!controller->GetButtonState(ButtonBlock) &&
    !controller->GetButtonState(ButtonMagic) &&
    !controller->GetButtonState(ButtonDodge) &&
    !controller->GetButtonState(ButtonAttackRanged)) 
  {
    once = true;
  }

  if (controller->GetButtonState(ButtonBlock) &&
     controller->GetButtonState(ButtonMagic) &&
     controller->GetButtonState(ButtonDodge) &&
     controller->GetButtonState(ButtonAction)&& once) 
  {
    once = false;
    // test code
    if (controller->GetButtonState(ButtonJump))
    {
      // save game 
      mpObject->GetTitan()->SaveGame();
    }
    else if (controller->GetButtonState(ButtonAttackRanged))
    {
      // load game
      mpObject->GetTitan()->LoadGame();
    }
    else if (controller->GetButtonState(ButtonAttackL))
    {
      gTuningSys.LoadValues();
    }
    else
    {
      // reset player
      mpObject->Reset();
    }
  }

  switch (tb)
  {
    case ButtonAttackL:
      input->mAttackRequestL = true;
      input->mTarget = mpObject->GetIntel()->PickAttackTarget(COMBO_L);
      if (input->mTarget == ID_NONE)
      {
        cIntelPlayer *intel = (cIntelPlayer *)mpObject->GetIntel();
        if (intel->GetControllerMagnitude() > 0.5f)
        {
          input->mTargetAngle =intel->GetControllerHeading(0.0f);
        }
        else
        {
          input->mTargetAngle =mpObject->GetHeading();
        }
      }
      break;
    case ButtonAttackS:
      input->mAttackRequestS = true;
      input->mTarget = mpObject->GetIntel()->PickAttackTarget(COMBO_H);
      if (input->mTarget == ID_NONE)
      {
        cIntelPlayer *intel = (cIntelPlayer *)mpObject->GetIntel();
        if (intel->GetControllerMagnitude() > 0.5f)
        {
          input->mTargetAngle =intel->GetControllerHeading(0.0f);
        }
        else
        {
          input->mTargetAngle =mpObject->GetHeading();
        }
      }
      break;
    case ButtonAttackRanged:
      input->mAttackRequestRanged = true;
      input->mTarget = mpObject->GetIntel()->PickAttackTargetRanged();
      if (input->mTarget == ID_NONE)
      {
        cIntelPlayer *intel = (cIntelPlayer *)mpObject->GetIntel();
        if (intel->GetControllerMagnitude() > 0.5f)
        {
          input->mTargetAngle =intel->GetControllerHeading(0.0f);
        }
        else
        {
          input->mTargetAngle =mpObject->GetHeading();
        }
      }
      break;
    case ButtonJump:
      input->mJumpRequest = true;
      break;     
    case ButtonAction:
      input->mActionTarget  = mpObject->GetIntel()->PickActionTarget();

      if (input->mActionTarget != ID_NONE)
      {
        input->mActionRequest = true;
      }
      break;     
    case ButtonBlock:
      input->mBlockRequest = true;
      break;
    case ButtonPause:
      if (mpObject->GetTitan()->IsPaused())
      {
        mpObject->GetTitan()->UnpauseGame();
      }
      else
      {
        mpObject->GetTitan()->PauseGame();
      }
    default:
      break;
  }
}

void TitanInputHandler::OnButtonUp( TitanButton tb )
{
  cGraphicCharacter *graphic = prop_cast<cGraphicCharacter *>(mpObject->GetGraphic());
  SyAssert(graphic);
  cAnimCharControllerInput *input = graphic->GetAnimInput();
  SyAssert(input);

  SyDebug( "TitanInputHandler::OnButtonUp %i\n", tb );
  switch (tb)
  {
    case ButtonBlock:
      input->mBlockRequest = false;
      break;
    default:
      break;
  }
}

