/******************************************************************

Module: TitanInputHandler.h

Author: 

Description:

TitanInputHandler class definition

Copyright 2005 Sony Online Entertainment.  All rights reserved.

*******************************************************************/

#ifndef __TITANINPUTHANDLER_H__
#define	__TITANINPUTHANDLER_H__

/*
**
**	 Forward Declarations
**
*/

class TitanUII;

/**/

/*
**
**	 Includes
**
*/

#include "TitanI.h"

/**/

class cGameObject;

/*
**
**	 Type Definitions
**
*/
class TitanInputHandler : public TitanInputHandlerI
{
public:
  TitanInputHandler( TitanUII* titanUII, cGameObject *obj );

  // handle controller button state changes
  virtual void OnButtonDown( TitanButton tb );
  virtual void OnButtonUp( TitanButton tb );
  void SetGameObject(cGameObject *newobj)
  {
    mpObject = newobj;
  }
  cGameObject* GetGameObject() { return( mpObject ); }

private:
  TitanUII*    mpTitanUI;
  cGameObject *mpObject;
};

/**/

#endif // __TITANINPUTHANDLER_H__








