/********************************************************************

  Module: TitanT4File

  Author: Carlo Ordonez

  Description:

    Platform-specific file I/O for T4 data files

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TitanT4File_h_
#define _TitanT4File_h_

#include "t4file.h"

class SyFile;
class TitanT4File : public T4File
{
public:
  TitanT4File();
  TitanT4File( const char* pFilename, const char* pMode );

  ~TitanT4File();

  // overrides
  virtual int     error();
  virtual bool    isBusy();
  virtual int     load( long Offset, void* ptr, size_t StrLen );
  virtual T4File* open( const char* pFilename, const char* pMode );
  virtual size_t  read( void* ptr, size_t Size, size_t NObj );
  virtual int     seek( long Offset, int Origin );
  virtual long    tell();

private:

  // the object doing the real operations
  SyFile*         mpFile;
};

#endif

