/******************************************************************
  
  Module:  AIDebugDraw.h
  
  Author: Borut Pfeifer
  
  Description: Render debug info for a character's AI

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef AIDEBUGDRAW_H
#define AIDEBUGDRAW_H

//-------------------------------------------------------- Includes
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

//#ifdef _DEBUG
#define _AIDEBUGDRAW
//#endif

#ifdef _AIDEBUGDRAW

#include "SyColor.h"
#include "SyVect3.h"
#include "../gameobj.h"

#define AIDEBUGDRAW_LINE(npc, start, end, color) cAIDebugDraw::DrawLine((npc), (start), (end), (color))
#define AIDEBUGDRAW_BOX(npc, v0, v1, v2, v3, color) cAIDebugDraw::DrawLine((npc), (start), (end), (color))

#else

#define AIDEBUGDRAW_LINE(npc, start, end, color)
#define AIDEBUGDRAW_BOX(npc, v0, v1, v2, v3, color) 

#endif


#ifdef _AIDEBUGDRAW

class SyRaster;
class SyCamera;
class cGameObjectRegistry;

class cAIDebugDraw
{
public:
  static void DrawLine(tGameObjectID npcID, const SyVect3& start, const SyVect3& end, SyColor32F color);
  static void DrawBox(tGameObjectID npcID, const SyVect3& v0, const SyVect3& v1, const SyVect3& v2, const SyVect3& v3, SyColor32F color);

  static void Toggle();
  static void SelectNextNPC(cGameObjectRegistry* pRegistry, SyCamera* pCam);
  static void SelectPrevNPC(cGameObjectRegistry* pRegistry, SyCamera* pCam);

  static void Render(SyRaster* pRasterDev, SyCamera* pCam);


  static const SyColor32F RED;
  static const SyColor32F GREEN;
  static const SyColor32F BLUE;
  static const SyColor32F CYAN;
  static const SyColor32F MAGENTA;
  static const SyColor32F YELLOW;
  static const SyColor32F WHITE;
  static const SyColor32F BLACK;

  struct Line
  {
    tGameObjectID npcID;
    SyVect3 start, end;
    SyColor32F color;
  };

private:
  static tGameObjectID smSelectedID;
  static bool smbEnabled;
};

#endif

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
