/******************************************************************
  
  Module:  aigoal_cast.h
  
  Author: Borut Pfeifer
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/
#ifndef AIGOAL_CAST_H
#define AIGOAL_CAST_H

//-------------------------------------------------------- Includes
#include "aigoal.h"

//
// cGoal_Cast - base spell casting behavior class
//
class cGoal_Cast : public cAiGoal
{
public:
  cGoal_Cast();

  virtual eGoalType GetType(){return GOAL_CAST;};

  virtual void Enter();
  virtual void Update(float time);
  virtual void Exit();

protected:
  virtual bool RequiresTarget() { return false; }
  virtual tGameObjectID SelectTarget() { return ID_NONE; }

  virtual bool MoveToCastPosition(float speed) = 0; // true if we're in cast position
  virtual bool Cast(float time) = 0; // if we should continue casting

  bool IsTargetValid();
  cGameObject* GetTarget();

  tGameObjectID mTargetID;

private:
  bool mbCasting;
  float mCastingTime;
};

//
// cGoal_CastNearFriendlyTarget - base spell casting behavior class for
// running to nearby friend
//
class cGoal_CastNearFriendlyTarget : public cGoal_Cast
{
public:
  cGoal_CastNearFriendlyTarget();

protected:
  virtual bool RequiresTarget() { return true; }
  virtual bool MoveToCastPosition(float speed);
};

//
// cGoal_CastAreaEffect - base spell casting behavior class for
// casting towards a cluster of targets
//
class cGoal_CastAreaEffect : public cGoal_Cast
{
public:
  cGoal_CastAreaEffect();

  virtual void Enter();
  virtual void Update(float time);

protected:
  virtual bool RequiresTarget() { return false; }
  virtual bool MoveToCastPosition(float speed);

  virtual bool IsValidTarget(cGameObject* pTarget);
  virtual bool SelectTargetPosition(SyVect3& targetPos);

  cAiLOSMemory mSpellTargetLOS;
  SyVect3 mSpellTargetPos;
  bool mbHasSpellTarget; 
  float mTargetLOSWaitTime;
};

class cGoal_CastExplosion : public cGoal_CastAreaEffect
{
public:
  cGoal_CastExplosion();

protected:
//  virtual bool IsValidTarget(cGameObject* pTarget);
  virtual bool Cast(float time);

  float mCastTimer;
};

class cGoal_CastHeal : public cGoal_CastNearFriendlyTarget
{
public:
  cGoal_CastHeal();

protected:
  virtual tGameObjectID SelectTarget();

  virtual bool Cast(float time);
};

class cGoal_CastSummon : public cGoal_Cast
{
public:
  cGoal_CastSummon();

protected:
  virtual bool RequiresTarget() {return false;}

  virtual bool MoveToCastPosition(float speed);
  virtual bool Cast(float time);

private:
  float mCastTimer;
};

#endif
