/******************************************************************
  
  Module:  calculation.h
  
  Author: Sean Craig
  
  Description:  
  A system for accumulating and reporting bonuses and penalties to
  stats.  For example, the damage done by a character could be 
  influenced by both the weapon used and the strength of the character.
  The bonus system performs this calculation and stores the result
  in a format that we can look at for debugging and perhaps to 
  convey to the user.  

  The calculations are applied in a fixed order according to the
  order of operations.  So if a magic ring doubles the player's 
  strength, and a spell adds 10 to the player's strength, the 
  spell will add 10 to the player's strength before doubling, even
  if the spell is added to the calculation before the the ring.

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef CALCULATION_H
#define CALCULATION_H

//-------------------------------------------------------- Includes
#include "systring.h"
#include <vector>
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cBonus;

class cCalculation 
{

public:
  cCalculation();
  ~cCalculation();
  void Add(int amount, const SyString &description);
  void Multiply(float amount, const SyString &description);
  void AddRandom(int min_amount,int max_amount, const SyString &description);
  void Set(int amount, const SyString &description);
  void Min(int amount, const SyString &description);
  void Max(int amount, const SyString &description);

  int GetValue();

  void Report(SyString *ans); 
  // TODO: improve reporting mechanism
  // something like  void Report() or perhaps uid Store();

protected:
  std::vector<cBonus *>    mBonuses;
  float                    mTotal;
  bool                     mCalculated;
};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
