/******************************************************************
  
  Module:  class.h
  
  Author: Sean Craig
  
  Description:  Code for character classes, game statistics
  which vary with the character level.

  Data is set by the designers in an Access database, exported into
  an XML file, then parsed into the cClass structure.
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef CLASS_H
#define CLASS_H

//-------------------------------------------------------- Includes
#include "nameid.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
class TiXmlNode;

class cStatistics
{
public:
  cStatistics();
  void          Parse(TiXmlNode* node);


  float         mMaxHP;
  float         mMaxMana;
  float         mMeleePower;
  float         mRangedPower;
  float         mSpellPower;
  float         mDefense;
  float         mStrikethrough;
  float         mBlockMeter;
  float         mShadowResist;
  float         mIceResist;
  float         mFireResist;
  float         mMagicResist;
  float         mPoisonResist;

  float         mAttackDelay;
  float         mBlockDelay;
  float         mMovementSpeed;
  float         mCloseDistance;
  float         mAccuracy;
  char          mNPCBehaviorType;  // selects appropriate actions/goals for NPC
  char          mNPCFaction;  // is ally/monster?
};

class cCharacterClass
{
public:
  cCharacterClass(){};
  cNameID     mName;

  cStatistics  mStats;

};


class cCharacterLevel
{
public:
  cCharacterLevel(){};

  int         mLevel;
  cStatistics  mStats;

};



//------------------------------------------- Function Declarations


cCharacterClass *ParseClass(TiXmlNode* node);
cCharacterLevel *ParseLevel(TiXmlNode* node);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
