/******************************************************************
  
  Module:  database.h
  
  Author: Sean Craig
  
  Description: All of the xml database code, globbed into one place! 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DATABASE_H
#define DATABASE_H

//-------------------------------------------------------- Includes
#include "nameid.h"
#include "SyMap.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class Titan;
class cStatsCharacterMaster;
class cStatsItemMaster;
class cStatsProjectileMaster;
class cStatsPropMaster;
class cCharacterClass;
class cCharacterLevel;

class cTreasureSet;
class cDropList;
class cDebrisMaster;



class cDatabaseSys
{
public:

  cDatabaseSys(Titan *titan);
  ~cDatabaseSys();

  void                         Init();

  void                         LoadDebrisModels();

  const cStatsCharacterMaster  *GetCharacterMaster(tGameID id);
  const cStatsItemMaster       *GetItemMaster(tGameID id);
  const cStatsProjectileMaster *GetProjectileMaster(tGameID id);
  const cStatsPropMaster       *GetPropMaster(tGameID id);
  const cCharacterClass        *GetCharacterClass(tGameID id);
  const cCharacterLevel        *GetCharacterLevel(int level);

        cTreasureSet           *GetTreasureSet(tGameID id);
        cDropList              *GetDropList(tGameID id);
  const cDebrisMaster          *GetDebrisMaster(tGameID id);

  const SyMap<tGameID,cStatsCharacterMaster*>& GetCharacterMap() { return mCharacterMasters; }
  const SyMap<tGameID,cStatsItemMaster*>&      GetItemMap() { return mItemMasters; }
  const SyMap<tGameID,cStatsPropMaster*>&      GetPropMap() { return mPropMasters; }

private:

  void                         LoadCharacterMasters();
  void                         LoadItemMasters();
  void                         LoadProjectileMasters();
  void                         LoadPropMasters();
  void                         LoadClasses();
  void                         LoadLevels();
  void                         LoadDropLists();
  void                         LoadTreasureSets();
  void                         LoadDebris();

  SyMap<tGameID,cStatsCharacterMaster *>  mCharacterMasters;
  SyMap<tGameID,cStatsItemMaster *>       mItemMasters;
  SyMap<tGameID,cStatsProjectileMaster *> mProjectileMasters;
  SyMap<tGameID,cStatsPropMaster *>       mPropMasters;
  SyMap<tGameID,cCharacterClass *>        mCharacterClasses; 
  SyMap<int,cCharacterLevel *>            mLevelMasters; 
  SyMap<int,cTreasureSet *>               mTreasureSets;
  SyMap<int,cDropList *>                  mDropLists;
  SyMap<int,cDebrisMaster *>              mDebrisMasters;

  Titan *                       mpTitan;

};

//------------------------------------------- Function Declarations
bool ChooseEnum(const char *str,const char **name_list,int name_list_size, int& retVal);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
