/******************************************************************
  
  Module:  droplist.h
  
  Author: Sean Craig
  
  Description: A system for the designers to specify which items
  get produced when a monster gets killed or a barrel gets broken. 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef DROPLIST_H
#define DROPLIST_H

//-------------------------------------------------------- Includes
#include "titan.h"
#include "SyVect3.h"
#include "nameid.h"
#include "SyVector.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cDropListElement
{
public:
  typedef enum 
  {
    DROP_ITEM,
    DROP_LIST,
  } eDropType;

  cDropListElement();
  ~cDropListElement();

  bool                        Drop(Titan *titan,SyVect3 location);

  eDropType                   mType;
  tGameID                     mDropID; // item or drop list id
  int                         mWeight;
  int                         mMinAmount;
  int                         mMaxAmount;
};

class cDropList 
{
public:
  cDropList();
  ~cDropList();

  void                        Drop(Titan *titan,SyVect3 location);

  cNameID                     mName;
  SyVector<cDropListElement>  mElements;

};

class cTreasureSetElement
{
public:
  cTreasureSetElement();
  ~cTreasureSetElement();

  void                        Drop(Titan *titan,SyVect3 location);

  tGameID                     mDropID;  // drop list id
  float                       mChance;
};


class cTreasureSet
{
public:
  cTreasureSet();
  ~cTreasureSet();

  void                        Drop(Titan *titan,SyVect3 location);

  cNameID                     mName;
  SyVector<cTreasureSetElement>  mElements;
};




//------------------------------------------- Function Declarations
class TiXmlNode;
class cDatabaseSys;
cDropList *   ParseDropList(cDatabaseSys *db,TiXmlNode* node);
cTreasureSet *ParseTreasureSet(cDatabaseSys *db, TiXmlNode* node);
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
