/******************************************************************
  
  Module:  graphic.h
  
  Author: Sean Craig
  
  Description: Handles rendering of an object.  Could be a static 
  model, an animatted model, or perhaps a particle system. 
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef GRAPHIC_H
#define GRAPHIC_H

//-------------------------------------------------------- Includes
#include "SySceneTypes.h"
#include "SyPropObject.h"
#include "animcontroller.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cGameObject;




class cGraphic : public SyPropObject
{
public:
  cGraphic();
  virtual ~cGraphic(){};

  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();  
  static const int     mCLASSID            =  0xFFFF4001;

  // public interface

  virtual void Init(){};
  virtual void Exit(){};
  virtual void Reset(){};
  virtual void Update(float time){};
  virtual void Prerender(){};
  virtual void SetAlpha(float alpha){};

  void SetVisible(bool bVisible);
  void SetOwner(cGameObject *);
  virtual void NetworkReceiveBroadcast(const char *packet,int size){};
  virtual void          EnterScope(){}; // called when an object enters scope (inside simulation bubble)


  virtual SyActorHandle         GetActorHandle(){return SyActorNull;};
protected:

  cGameObject       *mOwner;
};


class cGraphicActor : public cGraphic
{
public:
  cGraphicActor();
  virtual ~cGraphicActor();

  /* Property Class Support */
  static int            InitPropClass();
  static SyPropObject*  Creator();
  static const int      mCLASSID       =  0xFFFF4002;

  // public interface

  void                  Create();
  virtual void          Release();
  virtual void          Init();
  virtual void          SetAlpha(float alpha);
  virtual void          Prerender();


  virtual SyActorHandle         GetActorHandle(){return mActorHandle;};

protected:
  SyActorHandle             mActorHandle;
};

class cGraphicCharacter : public cGraphicActor
{
public:
  cGraphicCharacter();
  virtual ~cGraphicCharacter();

  /* Property Class Support */
  static int            InitPropClass();
  static SyPropObject*  Creator();
  static const int      mCLASSID   =  0xFFFF4003;

  // public interface

  void                  Create();
  virtual void          Init();
  virtual void          Reset();
  virtual void          Update(float time); // once/frame
  void                  SetDirty(){mDirty = true;};

  cAnimCharControllerInput *GetAnimInput(){return mAnimController->GetInput();};
  virtual void          EnterScope(); // called when a character enters scope (inside simulation bubble)
  const SyVect3 &       GetDisplacement(); // how much root node has moved this frame.

  virtual void          NetworkReceiveBroadcast(const char *packet,int size){mAnimController->NetworkReceiveBroadcast(packet,size);}
  cAnimCharControllerInterface *GetAnimController(){return mAnimController;};


  void                  AddDebugText(const char *line1, const char *line2);

protected:

  void                  RecalculateWeaponAttachments();

  cAnimCharControllerInterface *mAnimController;
  SyVect3                   mAnimDisplacement;
  bool                      mDirty; // need to recalculate weapon attachments, skins, etc. 
  int32                     mNameSpriteHandle;
  int32                     mNameAttachIndex;
  int32                     mNameSpriteHandle2; // second line of debug text
  int32                     mNameAttachIndex2;  // second line of debug text
 
};

class cGraphicProp : public cGraphicActor
{
public:
  cGraphicProp();
  virtual ~cGraphicProp();

  /* Property Class Support */
  static int            InitPropClass();
  static SyPropObject*  Creator();
  static const int      mCLASSID        =  0xFFFF4004;

  // public interface

  void                  Create();
  virtual void          Init();
  virtual void          Reset();
  virtual void          Update(float time); // once/frame

  virtual void          NetworkReceiveBroadcast(const char *packet,int size);
  
  cAnimPropControllerInterface *GetAnimController(){return mAnimController;};

protected:
  cAnimPropControllerInterface *mAnimController;
};

//------------------------------------------- Function Declarations

void RegPropClasses_Graphic();
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
