/******************************************************************
  
  Module:  item.h
  
  Author: Sean Craig
  
  Description: Code for game items. 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef ITEM_H
#define ITEM_H

//-------------------------------------------------------- Includes
#include "SyPropObject.h"
#include "nameid.h"
#include "rulepacket.h"

//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations
static const int ITEM_CLASSID            =  0xFFFF6001;

class cDatabaseSys;

typedef enum
{
  IT_MELEE,
  IT_RANGED,
  IT_HEAD,
  IT_BODY,
  IT_FEET,
  IT_ACCESSORY,
  IT_ENHANCEMENT,
  IT_GOLD,
  IT_TRINKET,
  IT_POTION,
  NUM_ITEM_TYPES
} eItemType;

typedef enum
{
  IC_KNIGHT,
  IC_MAGE,
  IC_BRUTE,
  IC_ANY,
  NUM_ITEM_CLASSES
} eItemClass; // which classes can use the item

class cStatsItemMaster 
{
public:
  cStatsItemMaster();
  ~cStatsItemMaster();

  cNameID                     mID;
  eItemType                   mType;
  eItemClass                  mClass;

  char *                      mWorldModel; // pathname of model to use when it's sitting in the world?                 
  char *                      mIcon; 
  char *                      mAttachModel; 
  tGameID                     mProjectile;  

  char *                      mNameString; // needs localization
  char *                      mDescriptionString; // needs localization

  int                         mValue;
  eNormalDamageType           mBaseDamageType;
  int                         mBaseDamageBonus;
  int                         mDefenseBonus;

  static const int  MAX_NUM_ENHANCEMENTS = 4;
  tGameID                     mEnhancements[MAX_NUM_ENHANCEMENTS]; // designer placed enhancemnts; permenantly bound to the item
};

typedef enum
{
  EQUIP_MELEE,
  EQUIP_RANGED,
  EQUIP_HEAD,
  EQUIP_BODY,
  EQUIP_FEET,
  EQUIP_ACCESSORY,
  EQUIP_UNEQUIPPED,
} eEquipSlot;

class cItem : public SyPropObject
{
public:
  cItem();
  ~cItem();

  /* Property Class Support */
  static int           InitPropClass();
  static SyPropObject* Creator();

  void Init(cDatabaseSys *db);
  void SetMaster(const cStatsItemMaster *master);
  const cStatsItemMaster *GetMaster(){return mpMaster;};
  const char *GetMasterName(){return mMasterName.AsChar();};

  int  GetQuantity(){return mQuantity;};
  void SetQuantity(int quantity); 

  bool Merge(cItem *other);

  bool CanEquip(eEquipSlot slot); // returns true if item is of the correct type
  bool Unequip(eEquipSlot slot); // if we're in the specified slot, unequip 
  void Unequip()  {mEquipSlot = EQUIP_UNEQUIPPED;}; // unequip no matter what
  bool Equip(eEquipSlot slot); // note: up to client (inventory system) to make sure we don't have two equipped helms, etc
  eEquipSlot GetEquipSlot(){return mEquipSlot;};

  tGameID GetMasterID(){return mpMaster->mID.GetID();};

  tGameID GetEnhancement(int index) const;
  bool    SetEnhancement(int index,tGameID id);

  static const SyPropID PropId_MasterName   = 0x0000;
  static const SyPropID PropId_Quantity     = 0x0001;
  static const SyPropID PropId_EquipSlot    = 0x0002;

protected:
  void    CalcEffectiveEnhancements(); 

  const cStatsItemMaster    * mpMaster;
  SyString                    mMasterName;
  int                         mQuantity;
  eEquipSlot                  mEquipSlot;  
  tGameID                     mEnhancements[cStatsItemMaster::MAX_NUM_ENHANCEMENTS]; // user-added enhancements.
  tGameID                     mEffectiveEnhancements[cStatsItemMaster::MAX_NUM_ENHANCEMENTS]; // after morphing
  bool                        mNoDrop;

  // charges? RuleContainer? 
};

//------------------------------------------- Function Declarations
void RegPropClasses_Item();
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
