#include "netpacket.h"

void cNetPacket::Pack(SyPack::DataStream *stream)
{
    stream->Pack8u(&mType);
}

void cNetPositionPacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->PackFloat(&mLocation.X);
    stream->PackFloat(&mLocation.Y);
    stream->PackFloat(&mLocation.Z);
    stream->PackFloat(&mVelocity.X);
    stream->PackFloat(&mVelocity.Y);
    stream->PackFloat(&mVelocity.Z);
    stream->PackFloat(&mHeading);
    stream->PackFloat(&mSpeedRequest);
    stream->PackFloat(&mHeadingRequest);
}

void cNetAnimStatePacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->Pack32s(&mAnimState);
    stream->Pack32s(&mTarget);
    stream->Pack32s(&mActionTarget);
}


void cNetDamagePacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->Pack32s(&mTotalDamage);
    stream->Pack32s(&mAttacker);
    stream->PackBool(&mDeath);
    stream->PackBool(&mHitReact);
    stream->Pack32s(&mHitReactAmount);
}

void cNetPickupRequestPacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->Pack32s(&mActor);
}

void cNetPickupConfirmPacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->Pack32s(&mActor);
}

void cNetDropPacket::Pack(SyPack::DataStream *stream)
{
    cNetPacket::Pack(stream);
    stream->Pack32s(&mObject);
}

void cNetAIBlackboardPacket::Pack(SyPack::DataStream *stream)
{
  cNetPacket::Pack(stream);
  stream->Pack8s(&mRecordType);
  stream->Pack32s(&mSourceID);
  stream->Pack32s(&mTargetID);
  stream->Pack32u(&mData);
  stream->PackFloat(&mLocation.X);
  stream->PackFloat(&mLocation.Y);
  stream->PackFloat(&mLocation.Z);
  stream->PackBool(&mbRemoveIfExists);
}

