/******************************************************************
  
  Module:  netpacket.h
  
  Author: Sean Craig
  
  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef NETPACKET_H
#define NETPACKET_H

//-------------------------------------------------------- Includes
#include "gameobj.h"
#include "SyPack.h"
//-------------------------------------------------------- Typedefs

//---------------------------------------------- Class Declarations

class cNetPacket : public SyPack::Object
{
public:

  typedef enum
  {
    NET_POSITION,
    NET_ANIMSTATE,
    NET_DAMAGE,
    NET_PICKUP_REQUEST,
    NET_PICKUP_CONFIRM,
    NET_DROP,
    NET_AIBLACKBOARD,
    NUM_NETWORK_PACKET_TYPES,
  } eNetPacketType;

  cNetPacket(eNetPacketType type) : mType(type){};

  virtual void Pack(SyPack::DataStream *stream);

  eNetPacketType mType;
};

class cNetPositionPacket : public cNetPacket
{
public:
  cNetPositionPacket() : cNetPacket(NET_POSITION){};
  virtual void Pack(SyPack::DataStream *stream);

  SyVect3 mLocation;
  SyVect3 mVelocity;
  float   mHeading;
  float   mSpeedRequest;
  float   mHeadingRequest;
};

class cNetAnimStatePacket : public cNetPacket
{
public:
  cNetAnimStatePacket() : cNetPacket(NET_ANIMSTATE){};
  virtual void Pack(SyPack::DataStream *stream);

  int                             mAnimState;
  tGameObjectID                   mTarget;
  tGameObjectID                   mActionTarget;
};

class cNetDamagePacket : public cNetPacket
{
public:
  cNetDamagePacket() : cNetPacket(NET_DAMAGE){};
  virtual void Pack(SyPack::DataStream *stream);

  int                             mTotalDamage; // on the character
  tGameObjectID                   mAttacker;
  bool                            mDeath;
  bool                            mHitReact;
  int                             mHitReactAmount;
};

class cNetPickupRequestPacket: public cNetPacket
{
public:
  cNetPickupRequestPacket() : cNetPacket(NET_PICKUP_REQUEST){};
  virtual void Pack(SyPack::DataStream *stream);

  tGameObjectID                   mActor;
};

class cNetPickupConfirmPacket: public cNetPacket
{
public:
  cNetPickupConfirmPacket() : cNetPacket(NET_PICKUP_CONFIRM){};
  virtual void Pack(SyPack::DataStream *stream);

  tGameObjectID                   mActor;
};

class cNetDropPacket: public cNetPacket
{
public:
  cNetDropPacket() : cNetPacket(NET_DROP){};
  virtual void Pack(SyPack::DataStream *stream);

  tGameObjectID                   mObject;
};

class cNetAIBlackboardPacket : public cNetPacket
{
public:
  cNetAIBlackboardPacket() : cNetPacket(NET_AIBLACKBOARD){};
  virtual void Pack(SyPack::DataStream *stream);

  char            mRecordType;
  tGameObjectID   mSourceID;
  tGameObjectID   mTargetID;
  unsigned int    mData;
  SyVect3         mLocation;
  bool            mbRemoveIfExists;
};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
