/******************************************************************
  
  Module:  rule_condition.h
  
  Author: Sean Craig
  
  Description:  Rule event handlers with durations.  For example,
  the Poison condition does damage every update, and removes 
  itself after a duration.

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef RULE_CONDITION_H
#define RULE_CONDITION_H

//-------------------------------------------------------- Includes
#include "rule.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations

class cRule_Condition : public cRule
{
public:
  cRule_Condition();
  virtual ~cRule_Condition(){};

  virtual void                Init(int numParams, cell* pParams);
  virtual void                Update(float time); 
  virtual cRule_Condition*    Clone() { return new cRule_Condition(*this); }

protected:
  cRule_Condition(const cRule_Condition& rule); // protect so everybody else must use clone

  float           mRemainingTime;
  tGameObjectID   mSourceID;
};


class cRule_Invisible : public cRule_Condition
{
public:
  virtual const char * GetName(){return "Invisible";};
  virtual cRule_Condition* Clone() { return new cRule_Invisible(*this); }

protected:
  virtual void QueryFlag(cFlagPacket *packet);
  virtual bool OnAdded(tGameObjectID target);
  virtual bool OnRemoved(tGameObjectID target);
};

class cRule_Stunned : public cRule_Condition
{
public:
  virtual const char*     GetName() {return "Stunned";};
  virtual cRule_Condition* Clone() { return new cRule_Stunned(*this); }

protected:
  virtual void QueryFlag(cFlagPacket *packet);
  virtual bool OnAdded(tGameObjectID target);
  virtual bool OnRemoved(tGameObjectID target);
};

class cRule_Invulnerable : public cRule_Condition
{
public:
  virtual const char * GetName(){return "Invulnerable";};
  virtual cRule_Condition* Clone() { return new cRule_Invulnerable(*this); }
protected:
  virtual void CalcDamageReduced(cDamagePacket *packet);
};

class cRule_PartialInvulnerability : public cRule_Condition
{
public:
  virtual const char * GetName(){return "PartialInvulnerability";};
  virtual cRule_Condition* Clone() { return new cRule_PartialInvulnerability(*this); }

  virtual void Init(int numParams, cell* pParams);

protected:
  virtual void CalcDamageReduced(cDamagePacket *packet);

  float mDmgMult;
};


//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
