/******************************************************************
  
  Module:  rule_inventory.h
  
  Author: Sean Craig
  
  Description: rules for inventory items. 

  
  Copyright 2005 Sony Online Entertainment.  All rights reserved.
  
*******************************************************************/

#ifndef RULE_INVENTORY_H
#define RULE_INVENTORY_H

//-------------------------------------------------------- Includes
#include "rule.h"
#include "item.h"
//-------------------------------------------------------- Typedefs
//---------------------------------------------- Class Declarations


class cInventoryRule: public cRule
{
public:
  virtual ~cInventoryRule(){};
  void SetItem(cItem *item){mpItem = item;};

protected:
  cItem*        mpItem;
};


class cInventoryRuleContainer
{
public:
  cInventoryRuleContainer();
  virtual ~cInventoryRuleContainer();

  void           SetTitan(Titan *titan);
  virtual   void ProcessPacket(cItem *item,cRulePacket *packet);

protected:
  cInventoryRule      *mpBase; // base handler for all items
  SyMap<tGameID,cInventoryRule*> mEnhancementEffects; // handers for enhancements
};

//------------------------------------------- Function Declarations
//--------------------------------------------------------- Globals
//------------------------------------------------ Inline Functions

#endif
